; =======================================================================
;                         Shared Install Functions
; =======================================================================

Function .onInstSuccess
; Remove unpacked files

  RMDir /r "$TEMP\PCSX2 ${APP_VERSION}"

FunctionEnd

; =======================================================================
;                         Shared Uninstall Functions
; =======================================================================

Function un.onUninstSuccess
  ; And remove the various install dir(s) but only if they're clean of user content:

  Delete "$INSTDIR\Uninst-pcsx2.exe"
  RMDir "$INSTDIR"

FunctionEnd
; =======================================================================
;                           Un.Installer Sections
; =======================================================================
Section "Un.Program and Plugins ${APP_NAME}"
SectionIn RO

  ; First thing, remove the registry entry in case uninstall doesn't complete successfully
  ;   otherwise, pcsx2 will be "confused" if it's re-installed later.
  DeleteRegKey HKLM Software\PCSX2

  ; This key is generated by PCSX2 and *not* NSIS! 
  ; Failure to delete this key can result in configuration errors after a fresh install.
  DeleteRegKey HKCU Software\PCSX2

  ; Remove regkey generated by NSIS for uninstall functions
  DeleteRegKey HKLM "${INSTDIR_REG_KEY}"

  ; Remove shortcuts, if any
  Delete "$DESKTOP\${APP_NAME}.lnk"
  Delete "$SMPROGRAMS\${APP_NAME}.lnk"

  Delete "$INSTDIR\GameIndex.dbf"
  Delete "$INSTDIR\cheats_ws.zip"
  Delete "$INSTDIR\PCSX2_keys.ini.default"
  Delete "$INSTDIR\pcsx2.exe"
  RMDir /r "$INSTDIR\Langs"
  RMDir /r "$INSTDIR\Plugins"
  RMDir /r "$INSTDIR\Docs"
  RMDir /r "$INSTDIR\Shaders"

  
  ; FIXME: PCSX2 currently does not account for non-default file paths in the uninstaller
  ; These paths would either have to be written to the registry by PCSX2 itself or read directly 
  ; using a script in NSIS. 
  
  SetShellVarContext current
  Delete $DOCUMENTS\PCSX2\inis\PCSX2_ui.ini
SectionEnd

; /o for optional and unticked by default
Section /o "Un.Configuration files (Programs and Plugins)"
  SetShellVarContext current
  RMDir /r "$DOCUMENTS\PCSX2\inis\"
SectionEnd

; /o for optional and unticked by default
Section /o "Un.Memory Cards and Savestates"
  SetShellVarContext current
  RMDir /r "$DOCUMENTS\PCSX2\memcards\"
  RMDir /r "$DOCUMENTS\PCSX2\sstates\"
SectionEnd

; /o for optional and unticked by default
Section /o "Un.User files (Cheats, Logs, Snapshots)"
  SetShellVarContext current
  RMDir /r "$DOCUMENTS\PCSX2\Cheats_ws\"
  RMDir /r "$DOCUMENTS\PCSX2\cheats\"
  RMDir /r "$DOCUMENTS\PCSX2\logs\"
  RMDir /r "$DOCUMENTS\PCSX2\snaps\"
SectionEnd

; /o for optional and unticked by default
Section /o "Un.BIOS files"
  SetShellVarContext current
  RMDir /r "$DOCUMENTS\PCSX2\bios\"
SectionEnd