// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <avtLabelMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose:
//   Init utility for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtLabelMetaData::Init()
{

    avtLabelMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose:
//   Copy utility for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtLabelMetaData::Copy(const avtLabelMetaData &obj)
{

    avtLabelMetaData::SelectAll();
}

// Type map format string
const char *avtLabelMetaData::TypeMapFormatString = AVTLABELMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtLabelMetaData::TmfsStruct = {AVTLABELMETADATA_TMFS};


// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose:
//   Default constructor for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData() :
    avtVarMetaData(avtLabelMetaData::TmfsStruct)
{
    avtLabelMetaData::Init();
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose:
//   Constructor for the derived classes of avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData(private_tmfs_t tmfs) :
    avtVarMetaData(tmfs)
{
    avtLabelMetaData::Init();
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose:
//   Copy constructor for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData(const avtLabelMetaData &obj) :
    avtVarMetaData(obj,avtLabelMetaData::TmfsStruct)
{
    avtLabelMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose:
//   Copy constructor for derived classes of the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData(const avtLabelMetaData &obj, private_tmfs_t tmfs) :
    avtVarMetaData(obj,tmfs)
{
    avtLabelMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtLabelMetaData::~avtLabelMetaData
//
// Purpose:
//   Destructor for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtLabelMetaData::~avtLabelMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtLabelMetaData::operator =
//
// Purpose:
//   Assignment operator for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtLabelMetaData&
avtLabelMetaData::operator = (const avtLabelMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtLabelMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtLabelMetaData::operator ==
//
// Purpose:
//   Comparison operator == for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtLabelMetaData::operator == (const avtLabelMetaData &obj) const
{
    // Create the return value
    return (true);
}

// ****************************************************************************
// Method: avtLabelMetaData::operator !=
//
// Purpose:
//   Comparison operator != for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtLabelMetaData::operator != (const avtLabelMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtLabelMetaData::TypeName
//
// Purpose:
//   Type name method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
avtLabelMetaData::TypeName() const
{
    return "avtLabelMetaData";
}

// ****************************************************************************
// Method: avtLabelMetaData::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtLabelMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtLabelMetaData *tmp = (const avtLabelMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtLabelMetaData::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtLabelMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtLabelMetaData(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: avtLabelMetaData::NewInstance
//
// Purpose:
//   NewInstance method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtLabelMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtLabelMetaData(*this);
    else
        retval = new avtLabelMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtLabelMetaData::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
avtLabelMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtLabelMetaData::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtLabelMetaData::GetFieldName(int index) const
{
    return avtVarMetaData::GetFieldName(index);
}

// ****************************************************************************
// Method: avtLabelMetaData::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
avtLabelMetaData::GetFieldType(int index) const
{
    return avtVarMetaData::GetFieldType(index);
}

// ****************************************************************************
// Method: avtLabelMetaData::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtLabelMetaData::GetFieldTypeName(int index) const
{
    return avtVarMetaData::GetFieldTypeName(index);
}

// ****************************************************************************
// Method: avtLabelMetaData::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtLabelMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    return avtVarMetaData::FieldsEqual(index_, rhs);
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

avtLabelMetaData::avtLabelMetaData(const std::string &n, const std::string &mn,
   avtCentering c) : avtVarMetaData(avtLabelMetaData::TmfsStruct, n, mn, c)
{
    avtLabelMetaData::Init();
}

