#ifndef INCLUDED_STORE_
#define INCLUDED_STORE_

#include <iosfwd>
#include <string>
#include <vector>
#include <unordered_map>

#include "../xrefdata/xrefdata.h"

// XrefData elements in the vector d_xrefVector. 
// XrefData's usedBy() returns a vector of indices in d_xrefVector of functions
//          using XrefData's symbol(). 
//          XrefData's element's identifier itself is returned by XrefData's 
//          name().
// 
// Indices of defined elements are stored in d_defIdx. Other entries in 
//          d_defIdx are used, but not defined in the specified object
//          files. 



namespace FBB
{
    class Pattern;
}

class Store
{
    friend std::ostream &operator<<(std::ostream &out, Store const &store);

    size_t d_currentIdx;
    std::string d_sourceFile;
    std::string d_objFile;
    std::string d_symbol;

    XrefVector d_xrefVector;
    mutable std::vector<size_t> d_defIdx;       // indices of defined 
                                                // functions/objects

    public:
        Store();

        void setSource(std::string const &fname);
        void setObjfile(std::string const &fname);

        void setFunction(std::string const &function);
        void setObject(std::string const &object);
        void undefined(std::string const &symbol);

        void tree(std::string const &symbol) const;

    private:
        void define(std::string const &symbol, bool isFunction);
        std::ostream &insertInto(std::ostream &out) const;
        void insert(std::ostream &out, std::string const &name, 
                                                        bool doSelect) const;

        size_t symbolIdx(std::string const &symbol) const;

        static bool findSymbol(XrefData const &data, 
                               std::string const &target);

        static void insertDefined(size_t idx, std::ostream &out, 
                                  XrefVector const &xref);
        static void usedBy(size_t idx, std::ostream &out, 
                                  XrefVector const &xref);
        static std::string rmBlanks(std::string const &symbol);
};

inline std::ostream &operator<<(std::ostream &out, Store const &store)
{
    return store.insertInto(out);   
}
        
#endif





