
#line 1 "hb-ot-shaper-use-machine.rl"
/*
 * Copyright © 2015  Mozilla Foundation.
 * Copyright © 2015  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Mozilla Author(s): Jonathan Kew
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPER_USE_MACHINE_HH
#define HB_OT_SHAPER_USE_MACHINE_HH

#include "hb.hh"

#include "hb-ot-shaper-syllabic.hh"

/* buffer var allocations */
#define use_category() ot_shaper_var_u8_category()

#define USE(Cat) use_syllable_machine_ex_##Cat

enum use_syllable_type_t {
  use_virama_terminated_cluster,
  use_sakot_terminated_cluster,
  use_standard_cluster,
  use_number_joiner_terminated_cluster,
  use_numeral_cluster,
  use_symbol_cluster,
  use_hieroglyph_cluster,
  use_broken_cluster,
  use_non_cluster,
};


#line 57 "hb-ot-shaper-use-machine.hh"
#define use_syllable_machine_ex_B 1u
#define use_syllable_machine_ex_CGJ 6u
#define use_syllable_machine_ex_CMAbv 31u
#define use_syllable_machine_ex_CMBlw 32u
#define use_syllable_machine_ex_CS 43u
#define use_syllable_machine_ex_FAbv 24u
#define use_syllable_machine_ex_FBlw 25u
#define use_syllable_machine_ex_FMAbv 45u
#define use_syllable_machine_ex_FMBlw 46u
#define use_syllable_machine_ex_FMPst 47u
#define use_syllable_machine_ex_FPst 26u
#define use_syllable_machine_ex_G 49u
#define use_syllable_machine_ex_GB 5u
#define use_syllable_machine_ex_H 12u
#define use_syllable_machine_ex_HM 54u
#define use_syllable_machine_ex_HN 13u
#define use_syllable_machine_ex_HR 55u
#define use_syllable_machine_ex_HVM 53u
#define use_syllable_machine_ex_IS 44u
#define use_syllable_machine_ex_J 50u
#define use_syllable_machine_ex_MAbv 27u
#define use_syllable_machine_ex_MBlw 28u
#define use_syllable_machine_ex_MPre 30u
#define use_syllable_machine_ex_MPst 29u
#define use_syllable_machine_ex_N 4u
#define use_syllable_machine_ex_O 0u
#define use_syllable_machine_ex_R 18u
#define use_syllable_machine_ex_SB 51u
#define use_syllable_machine_ex_SE 52u
#define use_syllable_machine_ex_SMAbv 41u
#define use_syllable_machine_ex_SMBlw 42u
#define use_syllable_machine_ex_SUB 11u
#define use_syllable_machine_ex_Sk 48u
#define use_syllable_machine_ex_VAbv 33u
#define use_syllable_machine_ex_VBlw 34u
#define use_syllable_machine_ex_VMAbv 37u
#define use_syllable_machine_ex_VMBlw 38u
#define use_syllable_machine_ex_VMPre 23u
#define use_syllable_machine_ex_VMPst 39u
#define use_syllable_machine_ex_VPre 22u
#define use_syllable_machine_ex_VPst 35u
#define use_syllable_machine_ex_WJ 16u
#define use_syllable_machine_ex_ZWNJ 14u


#line 103 "hb-ot-shaper-use-machine.hh"
static const unsigned char _use_syllable_machine_trans_keys[] = {
        49u, 51u, 0u, 53u, 11u, 53u, 11u, 53u, 1u, 53u, 14u, 48u, 14u, 47u, 14u, 47u,
        14u, 47u, 14u, 46u, 14u, 46u, 14u, 14u, 14u, 48u, 14u, 48u, 14u, 48u, 1u, 14u,
        14u, 48u, 14u, 53u, 14u, 53u, 14u, 53u, 14u, 53u, 12u, 53u, 14u, 53u, 12u, 53u,
        12u, 53u, 12u, 53u, 11u, 53u, 1u, 14u, 1u, 48u, 14u, 42u, 14u, 42u, 11u, 53u,
        1u, 53u, 14u, 48u, 14u, 47u, 14u, 47u, 14u, 47u, 14u, 46u, 14u, 46u, 14u, 14u,
        14u, 48u, 14u, 48u, 14u, 48u, 1u, 14u, 14u, 48u, 14u, 53u, 14u, 53u, 14u, 53u,
        14u, 53u, 12u, 53u, 14u, 53u, 12u, 53u, 12u, 53u, 12u, 53u, 11u, 53u, 1u, 14u,
        1u, 14u, 1u, 48u, 13u, 14u, 4u, 14u, 11u, 53u, 11u, 53u, 1u, 53u, 14u, 48u,
        14u, 47u, 14u, 47u, 14u, 47u, 14u, 46u, 14u, 46u, 14u, 14u, 14u, 48u, 14u, 48u,
        14u, 48u, 1u, 14u, 14u, 48u, 14u, 53u, 14u, 53u, 14u, 53u, 14u, 53u, 12u, 53u,
        14u, 53u, 12u, 53u, 12u, 53u, 12u, 53u, 11u, 53u, 1u, 14u, 1u, 14u, 1u, 48u,
        11u, 53u, 1u, 53u, 14u, 48u, 14u, 47u, 14u, 47u, 14u, 47u, 14u, 46u, 14u, 46u,
        14u, 14u, 14u, 48u, 14u, 48u, 14u, 48u, 1u, 14u, 14u, 48u, 14u, 53u, 14u, 53u,
        14u, 53u, 14u, 53u, 12u, 53u, 14u, 53u, 12u, 53u, 12u, 53u, 12u, 53u, 11u, 53u,
        1u, 14u, 1u, 48u, 4u, 14u, 13u, 14u, 1u, 53u, 14u, 42u, 14u, 42u, 1u, 5u,
        14u, 55u, 14u, 51u, 14u, 52u, 14u, 54u, 11u, 53u, 0
};

static const char _use_syllable_machine_key_spans[] = {
        3, 54, 43, 43, 53, 35, 34, 34,
        34, 33, 33, 1, 35, 35, 35, 14,
        35, 40, 40, 40, 40, 42, 40, 42,
        42, 42, 43, 14, 48, 29, 29, 43,
        53, 35, 34, 34, 34, 33, 33, 1,
        35, 35, 35, 14, 35, 40, 40, 40,
        40, 42, 40, 42, 42, 42, 43, 14,
        14, 48, 2, 11, 43, 43, 53, 35,
        34, 34, 34, 33, 33, 1, 35, 35,
        35, 14, 35, 40, 40, 40, 40, 42,
        40, 42, 42, 42, 43, 14, 14, 48,
        43, 53, 35, 34, 34, 34, 33, 33,
        1, 35, 35, 35, 14, 35, 40, 40,
        40, 40, 42, 40, 42, 42, 42, 43,
        14, 48, 11, 2, 53, 29, 29, 5,
        42, 38, 39, 41, 43
};

static const short _use_syllable_machine_index_offsets[] = {
        0, 4, 59, 103, 147, 201, 237, 272,
        307, 342, 376, 410, 412, 448, 484, 520,
        535, 571, 612, 653, 694, 735, 778, 819,
        862, 905, 948, 992, 1007, 1056, 1086, 1116,
        1160, 1214, 1250, 1285, 1320, 1355, 1389, 1423,
        1425, 1461, 1497, 1533, 1548, 1584, 1625, 1666,
        1707, 1748, 1791, 1832, 1875, 1918, 1961, 2005,
        2020, 2035, 2084, 2087, 2099, 2143, 2187, 2241,
        2277, 2312, 2347, 2382, 2416, 2450, 2452, 2488,
        2524, 2560, 2575, 2611, 2652, 2693, 2734, 2775,
        2818, 2859, 2902, 2945, 2988, 3032, 3047, 3062,
        3111, 3155, 3209, 3245, 3280, 3315, 3350, 3384,
        3418, 3420, 3456, 3492, 3528, 3543, 3579, 3620,
        3661, 3702, 3743, 3786, 3827, 3870, 3913, 3956,
        4000, 4015, 4064, 4076, 4079, 4133, 4163, 4193,
        4199, 4242, 4281, 4321, 4363
};

static const unsigned char _use_syllable_machine_indicies[] = {
        1, 0, 2, 0, 3, 4, 5, 5,
        6, 7, 5, 5, 5, 5, 5, 8,
        9, 10, 11, 5, 5, 5, 12, 5,
        5, 5, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 8, 22, 23, 24, 25,
        5, 26, 27, 28, 5, 29, 30, 31,
        32, 33, 34, 35, 32, 1, 5, 36,
        5, 37, 5, 39, 40, 38, 41, 38,
        38, 38, 38, 38, 38, 38, 42, 43,
        44, 45, 46, 47, 48, 49, 50, 39,
        51, 52, 53, 54, 38, 55, 56, 57,
        38, 58, 59, 38, 60, 61, 62, 63,
        60, 38, 38, 38, 38, 64, 38, 39,
        40, 38, 41, 38, 38, 38, 38, 38,
        38, 38, 42, 43, 44, 45, 46, 47,
        48, 49, 50, 39, 51, 52, 53, 54,
        38, 55, 56, 57, 38, 38, 38, 38,
        60, 61, 62, 63, 60, 38, 38, 38,
        38, 64, 38, 39, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        41, 38, 38, 38, 38, 38, 38, 38,
        38, 43, 44, 45, 46, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 55,
        56, 57, 38, 38, 38, 38, 38, 61,
        62, 63, 65, 38, 38, 38, 38, 43,
        38, 41, 38, 38, 38, 38, 38, 38,
        38, 38, 43, 44, 45, 46, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        55, 56, 57, 38, 38, 38, 38, 38,
        61, 62, 63, 65, 38, 41, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 44,
        45, 46, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 61, 62, 63, 38,
        41, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 45, 46, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 61,
        62, 63, 38, 41, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 46,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 61, 62, 63, 38, 41, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 61, 62, 38,
        41, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        62, 38, 41, 38, 41, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 44, 45,
        46, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 55, 56, 57, 38, 38,
        38, 38, 38, 61, 62, 63, 65, 38,
        41, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 44, 45, 46, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        56, 57, 38, 38, 38, 38, 38, 61,
        62, 63, 65, 38, 41, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 44, 45,
        46, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 57, 38, 38,
        38, 38, 38, 61, 62, 63, 65, 38,
        66, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 41, 38, 41,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 44, 45, 46, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 61, 62,
        63, 65, 38, 41, 38, 38, 38, 38,
        38, 38, 38, 42, 43, 44, 45, 46,
        38, 38, 38, 38, 38, 38, 52, 53,
        54, 38, 55, 56, 57, 38, 38, 38,
        38, 38, 61, 62, 63, 65, 38, 38,
        38, 38, 43, 38, 41, 38, 38, 38,
        38, 38, 38, 38, 38, 43, 44, 45,
        46, 38, 38, 38, 38, 38, 38, 52,
        53, 54, 38, 55, 56, 57, 38, 38,
        38, 38, 38, 61, 62, 63, 65, 38,
        38, 38, 38, 43, 38, 41, 38, 38,
        38, 38, 38, 38, 38, 38, 43, 44,
        45, 46, 38, 38, 38, 38, 38, 38,
        38, 53, 54, 38, 55, 56, 57, 38,
        38, 38, 38, 38, 61, 62, 63, 65,
        38, 38, 38, 38, 43, 38, 41, 38,
        38, 38, 38, 38, 38, 38, 38, 43,
        44, 45, 46, 38, 38, 38, 38, 38,
        38, 38, 38, 54, 38, 55, 56, 57,
        38, 38, 38, 38, 38, 61, 62, 63,
        65, 38, 38, 38, 38, 43, 38, 67,
        38, 41, 38, 38, 38, 38, 38, 38,
        38, 42, 43, 44, 45, 46, 38, 48,
        49, 38, 38, 38, 52, 53, 54, 38,
        55, 56, 57, 38, 38, 38, 38, 38,
        61, 62, 63, 65, 38, 38, 38, 38,
        43, 38, 41, 38, 38, 38, 38, 38,
        38, 38, 38, 43, 44, 45, 46, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 55, 56, 57, 38, 38, 38, 38,
        38, 61, 62, 63, 65, 38, 38, 38,
        38, 43, 38, 67, 38, 41, 38, 38,
        38, 38, 38, 38, 38, 42, 43, 44,
        45, 46, 38, 38, 49, 38, 38, 38,
        52, 53, 54, 38, 55, 56, 57, 38,
        38, 38, 38, 38, 61, 62, 63, 65,
        38, 38, 38, 38, 43, 38, 67, 38,
        41, 38, 38, 38, 38, 38, 38, 38,
        42, 43, 44, 45, 46, 38, 38, 38,
        38, 38, 38, 52, 53, 54, 38, 55,
        56, 57, 38, 38, 38, 38, 38, 61,
        62, 63, 65, 38, 38, 38, 38, 43,
        38, 67, 38, 41, 38, 38, 38, 38,
        38, 38, 38, 42, 43, 44, 45, 46,
        47, 48, 49, 38, 38, 38, 52, 53,
        54, 38, 55, 56, 57, 38, 38, 38,
        38, 38, 61, 62, 63, 65, 38, 38,
        38, 38, 43, 38, 39, 40, 38, 41,
        38, 38, 38, 38, 38, 38, 38, 42,
        43, 44, 45, 46, 47, 48, 49, 50,
        38, 51, 52, 53, 54, 38, 55, 56,
        57, 38, 38, 38, 38, 60, 61, 62,
        63, 60, 38, 38, 38, 38, 64, 38,
        39, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 41, 38, 39,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 41, 38, 38, 38,
        38, 38, 38, 38, 38, 43, 44, 45,
        46, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 55, 56, 57, 38, 38,
        38, 38, 38, 61, 62, 63, 65, 38,
        41, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 58, 59, 38, 41, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 38, 38, 38, 38, 38, 38,
        38, 38, 59, 38, 4, 69, 68, 70,
        68, 68, 68, 68, 68, 68, 68, 71,
        72, 73, 74, 75, 76, 77, 78, 79,
        4, 80, 81, 82, 83, 68, 84, 85,
        86, 68, 68, 68, 68, 87, 88, 89,
        90, 91, 68, 68, 68, 68, 92, 68,
        4, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 68, 72, 73,
        74, 75, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 84, 85, 86, 68,
        68, 68, 68, 68, 88, 89, 90, 93,
        68, 68, 68, 68, 72, 68, 70, 68,
        68, 68, 68, 68, 68, 68, 68, 72,
        73, 74, 75, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 84, 85, 86,
        68, 68, 68, 68, 68, 88, 89, 90,
        93, 68, 70, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 73, 74, 75, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 88, 89, 90, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        74, 75, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 88, 89, 90, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 75, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 88,
        89, 90, 68, 70, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 88, 89, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 89, 68, 70,
        68, 70, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 73, 74, 75, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        84, 85, 86, 68, 68, 68, 68, 68,
        88, 89, 90, 93, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 73,
        74, 75, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 85, 86, 68,
        68, 68, 68, 68, 88, 89, 90, 93,
        68, 70, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 73, 74, 75, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 86, 68, 68, 68, 68, 68,
        88, 89, 90, 93, 68, 95, 94, 94,
        94, 94, 94, 94, 94, 94, 94, 94,
        94, 94, 96, 94, 70, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 73, 74,
        75, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 88, 89, 90, 93, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        71, 72, 73, 74, 75, 68, 68, 68,
        68, 68, 68, 81, 82, 83, 68, 84,
        85, 86, 68, 68, 68, 68, 68, 88,
        89, 90, 93, 68, 68, 68, 68, 72,
        68, 70, 68, 68, 68, 68, 68, 68,
        68, 68, 72, 73, 74, 75, 68, 68,
        68, 68, 68, 68, 81, 82, 83, 68,
        84, 85, 86, 68, 68, 68, 68, 68,
        88, 89, 90, 93, 68, 68, 68, 68,
        72, 68, 70, 68, 68, 68, 68, 68,
        68, 68, 68, 72, 73, 74, 75, 68,
        68, 68, 68, 68, 68, 68, 82, 83,
        68, 84, 85, 86, 68, 68, 68, 68,
        68, 88, 89, 90, 93, 68, 68, 68,
        68, 72, 68, 70, 68, 68, 68, 68,
        68, 68, 68, 68, 72, 73, 74, 75,
        68, 68, 68, 68, 68, 68, 68, 68,
        83, 68, 84, 85, 86, 68, 68, 68,
        68, 68, 88, 89, 90, 93, 68, 68,
        68, 68, 72, 68, 97, 68, 70, 68,
        68, 68, 68, 68, 68, 68, 71, 72,
        73, 74, 75, 68, 77, 78, 68, 68,
        68, 81, 82, 83, 68, 84, 85, 86,
        68, 68, 68, 68, 68, 88, 89, 90,
        93, 68, 68, 68, 68, 72, 68, 70,
        68, 68, 68, 68, 68, 68, 68, 68,
        72, 73, 74, 75, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 84, 85,
        86, 68, 68, 68, 68, 68, 88, 89,
        90, 93, 68, 68, 68, 68, 72, 68,
        97, 68, 70, 68, 68, 68, 68, 68,
        68, 68, 71, 72, 73, 74, 75, 68,
        68, 78, 68, 68, 68, 81, 82, 83,
        68, 84, 85, 86, 68, 68, 68, 68,
        68, 88, 89, 90, 93, 68, 68, 68,
        68, 72, 68, 97, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 71, 72, 73,
        74, 75, 68, 68, 68, 68, 68, 68,
        81, 82, 83, 68, 84, 85, 86, 68,
        68, 68, 68, 68, 88, 89, 90, 93,
        68, 68, 68, 68, 72, 68, 97, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        71, 72, 73, 74, 75, 76, 77, 78,
        68, 68, 68, 81, 82, 83, 68, 84,
        85, 86, 68, 68, 68, 68, 68, 88,
        89, 90, 93, 68, 68, 68, 68, 72,
        68, 4, 69, 68, 70, 68, 68, 68,
        68, 68, 68, 68, 71, 72, 73, 74,
        75, 76, 77, 78, 79, 68, 80, 81,
        82, 83, 68, 84, 85, 86, 68, 68,
        68, 68, 87, 88, 89, 90, 91, 68,
        68, 68, 68, 92, 68, 4, 98, 98,
        98, 98, 98, 98, 98, 98, 98, 98,
        98, 98, 99, 98, 4, 94, 94, 94,
        94, 94, 94, 94, 94, 94, 94, 94,
        94, 96, 94, 4, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        68, 72, 73, 74, 75, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 84,
        85, 86, 68, 68, 68, 68, 68, 88,
        89, 90, 93, 68, 101, 102, 100, 6,
        103, 103, 103, 103, 103, 103, 103, 103,
        103, 104, 103, 105, 106, 68, 70, 68,
        68, 68, 68, 68, 68, 68, 107, 108,
        109, 110, 111, 112, 113, 114, 115, 105,
        116, 117, 118, 119, 68, 120, 121, 122,
        68, 58, 59, 68, 123, 124, 125, 126,
        127, 68, 68, 68, 68, 128, 68, 105,
        106, 68, 70, 68, 68, 68, 68, 68,
        68, 68, 107, 108, 109, 110, 111, 112,
        113, 114, 115, 105, 116, 117, 118, 119,
        68, 120, 121, 122, 68, 68, 68, 68,
        123, 124, 125, 126, 127, 68, 68, 68,
        68, 128, 68, 105, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        68, 108, 109, 110, 111, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 120,
        121, 122, 68, 68, 68, 68, 68, 124,
        125, 126, 129, 68, 68, 68, 68, 108,
        68, 70, 68, 68, 68, 68, 68, 68,
        68, 68, 108, 109, 110, 111, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        120, 121, 122, 68, 68, 68, 68, 68,
        124, 125, 126, 129, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 109,
        110, 111, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 124, 125, 126, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 110, 111, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 124,
        125, 126, 68, 70, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 111,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 124, 125, 126, 68, 70, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 124, 125, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        125, 68, 70, 68, 70, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 109, 110,
        111, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 120, 121, 122, 68, 68,
        68, 68, 68, 124, 125, 126, 129, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 109, 110, 111, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        121, 122, 68, 68, 68, 68, 68, 124,
        125, 126, 129, 68, 70, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 109, 110,
        111, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 122, 68, 68,
        68, 68, 68, 124, 125, 126, 129, 68,
        130, 94, 94, 94, 94, 94, 94, 94,
        94, 94, 94, 94, 94, 96, 94, 70,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 109, 110, 111, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 124, 125,
        126, 129, 68, 70, 68, 68, 68, 68,
        68, 68, 68, 107, 108, 109, 110, 111,
        68, 68, 68, 68, 68, 68, 117, 118,
        119, 68, 120, 121, 122, 68, 68, 68,
        68, 68, 124, 125, 126, 129, 68, 68,
        68, 68, 108, 68, 70, 68, 68, 68,
        68, 68, 68, 68, 68, 108, 109, 110,
        111, 68, 68, 68, 68, 68, 68, 117,
        118, 119, 68, 120, 121, 122, 68, 68,
        68, 68, 68, 124, 125, 126, 129, 68,
        68, 68, 68, 108, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 68, 108, 109,
        110, 111, 68, 68, 68, 68, 68, 68,
        68, 118, 119, 68, 120, 121, 122, 68,
        68, 68, 68, 68, 124, 125, 126, 129,
        68, 68, 68, 68, 108, 68, 70, 68,
        68, 68, 68, 68, 68, 68, 68, 108,
        109, 110, 111, 68, 68, 68, 68, 68,
        68, 68, 68, 119, 68, 120, 121, 122,
        68, 68, 68, 68, 68, 124, 125, 126,
        129, 68, 68, 68, 68, 108, 68, 131,
        68, 70, 68, 68, 68, 68, 68, 68,
        68, 107, 108, 109, 110, 111, 68, 113,
        114, 68, 68, 68, 117, 118, 119, 68,
        120, 121, 122, 68, 68, 68, 68, 68,
        124, 125, 126, 129, 68, 68, 68, 68,
        108, 68, 70, 68, 68, 68, 68, 68,
        68, 68, 68, 108, 109, 110, 111, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 120, 121, 122, 68, 68, 68, 68,
        68, 124, 125, 126, 129, 68, 68, 68,
        68, 108, 68, 131, 68, 70, 68, 68,
        68, 68, 68, 68, 68, 107, 108, 109,
        110, 111, 68, 68, 114, 68, 68, 68,
        117, 118, 119, 68, 120, 121, 122, 68,
        68, 68, 68, 68, 124, 125, 126, 129,
        68, 68, 68, 68, 108, 68, 131, 68,
        70, 68, 68, 68, 68, 68, 68, 68,
        107, 108, 109, 110, 111, 68, 68, 68,
        68, 68, 68, 117, 118, 119, 68, 120,
        121, 122, 68, 68, 68, 68, 68, 124,
        125, 126, 129, 68, 68, 68, 68, 108,
        68, 131, 68, 70, 68, 68, 68, 68,
        68, 68, 68, 107, 108, 109, 110, 111,
        112, 113, 114, 68, 68, 68, 117, 118,
        119, 68, 120, 121, 122, 68, 68, 68,
        68, 68, 124, 125, 126, 129, 68, 68,
        68, 68, 108, 68, 105, 106, 68, 70,
        68, 68, 68, 68, 68, 68, 68, 107,
        108, 109, 110, 111, 112, 113, 114, 115,
        68, 116, 117, 118, 119, 68, 120, 121,
        122, 68, 68, 68, 68, 123, 124, 125,
        126, 127, 68, 68, 68, 68, 128, 68,
        105, 98, 98, 98, 98, 98, 98, 98,
        98, 98, 98, 98, 98, 99, 98, 105,
        94, 94, 94, 94, 94, 94, 94, 94,
        94, 94, 94, 94, 96, 94, 105, 68,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 70, 68, 68, 68, 68,
        68, 68, 68, 68, 108, 109, 110, 111,
        68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 120, 121, 122, 68, 68, 68,
        68, 68, 124, 125, 126, 129, 68, 8,
        9, 132, 11, 132, 132, 132, 132, 132,
        132, 132, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 8, 22, 23, 24, 25,
        132, 26, 27, 28, 132, 132, 132, 132,
        32, 33, 34, 35, 32, 132, 132, 132,
        132, 37, 132, 8, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        11, 132, 132, 132, 132, 132, 132, 132,
        132, 14, 15, 16, 17, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 26,
        27, 28, 132, 132, 132, 132, 132, 33,
        34, 35, 133, 132, 132, 132, 132, 14,
        132, 11, 132, 132, 132, 132, 132, 132,
        132, 132, 14, 15, 16, 17, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        26, 27, 28, 132, 132, 132, 132, 132,
        33, 34, 35, 133, 132, 11, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 15,
        16, 17, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 33, 34, 35, 132,
        11, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 16, 17, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 33,
        34, 35, 132, 11, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 17,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 33, 34, 35, 132, 11, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 33, 34, 132,
        11, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        34, 132, 11, 132, 11, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 15, 16,
        17, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 26, 27, 28, 132, 132,
        132, 132, 132, 33, 34, 35, 133, 132,
        11, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 15, 16, 17, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        27, 28, 132, 132, 132, 132, 132, 33,
        34, 35, 133, 132, 11, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 15, 16,
        17, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 28, 132, 132,
        132, 132, 132, 33, 34, 35, 133, 132,
        134, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 11, 132, 11,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 15, 16, 17, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 33, 34,
        35, 133, 132, 11, 132, 132, 132, 132,
        132, 132, 132, 13, 14, 15, 16, 17,
        132, 132, 132, 132, 132, 132, 23, 24,
        25, 132, 26, 27, 28, 132, 132, 132,
        132, 132, 33, 34, 35, 133, 132, 132,
        132, 132, 14, 132, 11, 132, 132, 132,
        132, 132, 132, 132, 132, 14, 15, 16,
        17, 132, 132, 132, 132, 132, 132, 23,
        24, 25, 132, 26, 27, 28, 132, 132,
        132, 132, 132, 33, 34, 35, 133, 132,
        132, 132, 132, 14, 132, 11, 132, 132,
        132, 132, 132, 132, 132, 132, 14, 15,
        16, 17, 132, 132, 132, 132, 132, 132,
        132, 24, 25, 132, 26, 27, 28, 132,
        132, 132, 132, 132, 33, 34, 35, 133,
        132, 132, 132, 132, 14, 132, 11, 132,
        132, 132, 132, 132, 132, 132, 132, 14,
        15, 16, 17, 132, 132, 132, 132, 132,
        132, 132, 132, 25, 132, 26, 27, 28,
        132, 132, 132, 132, 132, 33, 34, 35,
        133, 132, 132, 132, 132, 14, 132, 135,
        132, 11, 132, 132, 132, 132, 132, 132,
        132, 13, 14, 15, 16, 17, 132, 19,
        20, 132, 132, 132, 23, 24, 25, 132,
        26, 27, 28, 132, 132, 132, 132, 132,
        33, 34, 35, 133, 132, 132, 132, 132,
        14, 132, 11, 132, 132, 132, 132, 132,
        132, 132, 132, 14, 15, 16, 17, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 26, 27, 28, 132, 132, 132, 132,
        132, 33, 34, 35, 133, 132, 132, 132,
        132, 14, 132, 135, 132, 11, 132, 132,
        132, 132, 132, 132, 132, 13, 14, 15,
        16, 17, 132, 132, 20, 132, 132, 132,
        23, 24, 25, 132, 26, 27, 28, 132,
        132, 132, 132, 132, 33, 34, 35, 133,
        132, 132, 132, 132, 14, 132, 135, 132,
        11, 132, 132, 132, 132, 132, 132, 132,
        13, 14, 15, 16, 17, 132, 132, 132,
        132, 132, 132, 23, 24, 25, 132, 26,
        27, 28, 132, 132, 132, 132, 132, 33,
        34, 35, 133, 132, 132, 132, 132, 14,
        132, 135, 132, 11, 132, 132, 132, 132,
        132, 132, 132, 13, 14, 15, 16, 17,
        18, 19, 20, 132, 132, 132, 23, 24,
        25, 132, 26, 27, 28, 132, 132, 132,
        132, 132, 33, 34, 35, 133, 132, 132,
        132, 132, 14, 132, 8, 9, 132, 11,
        132, 132, 132, 132, 132, 132, 132, 13,
        14, 15, 16, 17, 18, 19, 20, 21,
        132, 22, 23, 24, 25, 132, 26, 27,
        28, 132, 132, 132, 132, 32, 33, 34,
        35, 32, 132, 132, 132, 132, 37, 132,
        8, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 11, 132, 8,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 11, 132, 132, 132,
        132, 132, 132, 132, 132, 14, 15, 16,
        17, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 26, 27, 28, 132, 132,
        132, 132, 132, 33, 34, 35, 133, 132,
        136, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 11, 132, 10, 11, 132, 4,
        132, 132, 132, 4, 132, 132, 132, 132,
        132, 8, 9, 10, 11, 132, 132, 132,
        132, 132, 132, 132, 13, 14, 15, 16,
        17, 18, 19, 20, 21, 8, 22, 23,
        24, 25, 132, 26, 27, 28, 132, 29,
        30, 132, 32, 33, 34, 35, 32, 132,
        132, 132, 132, 37, 132, 11, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        29, 30, 132, 11, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 132,
        132, 132, 132, 132, 132, 132, 132, 30,
        132, 4, 137, 137, 137, 4, 137, 139,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 140, 138, 141, 138, 141,
        142, 138, 139, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 1, 140, 140,
        138, 139, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 140, 138, 141,
        138, 139, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 138, 138, 138,
        138, 138, 138, 138, 138, 140, 138, 141,
        138, 141, 138, 39, 40, 38, 41, 38,
        38, 38, 38, 38, 38, 38, 42, 43,
        44, 45, 46, 47, 48, 49, 50, 39,
        51, 52, 53, 54, 38, 55, 56, 57,
        38, 58, 59, 38, 60, 61, 62, 63,
        60, 1, 38, 2, 38, 64, 38, 0
};

static const char _use_syllable_machine_trans_targs[] = {
        1, 120, 0, 2, 31, 1, 58, 60,
        88, 89, 114, 1, 116, 102, 90, 91,
        92, 93, 106, 108, 109, 110, 111, 103,
        104, 105, 97, 98, 99, 117, 118, 119,
        112, 94, 95, 96, 124, 113, 1, 3,
        4, 1, 17, 5, 6, 7, 8, 21,
        23, 24, 25, 26, 18, 19, 20, 12,
        13, 14, 29, 30, 27, 9, 10, 11,
        28, 15, 16, 22, 1, 32, 1, 45,
        33, 34, 35, 36, 49, 51, 52, 53,
        54, 46, 47, 48, 40, 41, 42, 55,
        37, 38, 39, 56, 57, 43, 1, 44,
        1, 50, 1, 1, 1, 59, 1, 1,
        1, 61, 62, 75, 63, 64, 65, 66,
        79, 81, 82, 83, 84, 76, 77, 78,
        70, 71, 72, 85, 67, 68, 69, 86,
        87, 73, 74, 80, 1, 100, 101, 107,
        115, 1, 1, 1, 121, 122, 123
};

static const char _use_syllable_machine_trans_actions[] = {
        1, 0, 0, 0, 0, 4, 0, 0,
        0, 0, 0, 5, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 6, 0, 7, 0,
        0, 8, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 9, 0, 10, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 11, 0,
        12, 0, 13, 14, 15, 0, 16, 17,
        18, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 19, 0, 0, 0,
        0, 20, 21, 22, 0, 0, 0
};

static const char _use_syllable_machine_to_state_actions[] = {
        0, 2, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0
};

static const char _use_syllable_machine_from_state_actions[] = {
        0, 3, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0
};

static const short _use_syllable_machine_eof_trans[] = {
        1, 0, 39, 39, 39, 39, 39, 39,
        39, 39, 39, 39, 39, 39, 39, 39,
        39, 39, 39, 39, 39, 39, 39, 39,
        39, 39, 39, 39, 39, 39, 39, 69,
        69, 69, 69, 69, 69, 69, 69, 69,
        69, 69, 69, 95, 69, 69, 69, 69,
        69, 69, 69, 69, 69, 69, 69, 99,
        95, 69, 101, 104, 69, 69, 69, 69,
        69, 69, 69, 69, 69, 69, 69, 69,
        69, 95, 69, 69, 69, 69, 69, 69,
        69, 69, 69, 69, 69, 99, 95, 69,
        133, 133, 133, 133, 133, 133, 133, 133,
        133, 133, 133, 133, 133, 133, 133, 133,
        133, 133, 133, 133, 133, 133, 133, 133,
        133, 133, 133, 133, 133, 133, 133, 138,
        139, 139, 139, 139, 39
};

static const int use_syllable_machine_start = 1;
static const int use_syllable_machine_first_final = 1;
static const int use_syllable_machine_error = -1;

static const int use_syllable_machine_en_main = 1;


#line 58 "hb-ot-shaper-use-machine.rl"



#line 184 "hb-ot-shaper-use-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %u..%u %s\n", (*ts).second.first, (*te).second.first, #syllable_type); \
    for (unsigned i = (*ts).second.first; i < (*te).second.first; ++i) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    syllable_serial++; \
    if (syllable_serial == 16) syllable_serial = 1; \
  } HB_STMT_END


template <typename Iter>
struct machine_index_t :
  hb_iter_with_fallback_t<machine_index_t<Iter>,
                          typename Iter::item_t>
{
  machine_index_t (const Iter& it) : it (it) {}
  machine_index_t (const machine_index_t& o) : hb_iter_with_fallback_t<machine_index_t<Iter>,
                                                                       typename Iter::item_t> (),
                                               it (o.it), is_null (o.is_null) {}

  static constexpr bool is_random_access_iterator = Iter::is_random_access_iterator;
  static constexpr bool is_sorted_iterator = Iter::is_sorted_iterator;

  typename Iter::item_t __item__ () const { return *it; }
  typename Iter::item_t __item_at__ (unsigned i) const { return it[i]; }
  unsigned __len__ () const { return it.len (); }
  void __next__ () { ++it; }
  void __forward__ (unsigned n) { it += n; }
  void __prev__ () { --it; }
  void __rewind__ (unsigned n) { it -= n; }

  void operator = (unsigned n)
  {
    assert (n == 0);
    is_null = true;
  }
  explicit operator bool () { return !is_null; }

  void operator = (const machine_index_t& o)
  {
    is_null = o.is_null;
    unsigned index = (*it).first;
    unsigned n = (*o.it).first;
    if (index < n) it += n - index; else if (index > n) it -= index - n;
  }
  bool operator == (const machine_index_t& o) const
  { return is_null ? o.is_null : !o.is_null && (*it).first == (*o.it).first; }
  bool operator != (const machine_index_t& o) const { return !(*this == o); }

  private:
  Iter it;
  bool is_null = false;
};
struct
{
  template <typename Iter,
            hb_requires (hb_is_iterable (Iter))>
  machine_index_t<hb_iter_type<Iter>>
  operator () (Iter&& it) const
  { return machine_index_t<hb_iter_type<Iter>> (hb_iter (it)); }
}
HB_FUNCOBJ (machine_index);



static bool
not_ccs_default_ignorable (const hb_glyph_info_t &i)
{ return i.use_category() != USE(CGJ); }

static inline void
find_syllables_use (hb_buffer_t *buffer)
{
  hb_glyph_info_t *info = buffer->info;
  auto p =
    + hb_iter (info, buffer->len)
    | hb_enumerate
    | hb_filter ([] (const hb_glyph_info_t &i) { return not_ccs_default_ignorable (i); },
                 hb_second)
    | hb_filter ([&] (const hb_pair_t<unsigned, const hb_glyph_info_t &> p)
                 {
                   if (p.second.use_category() == USE(ZWNJ))
                     for (unsigned i = p.first + 1; i < buffer->len; ++i)
                       if (not_ccs_default_ignorable (info[i]))
                         return !_hb_glyph_info_is_unicode_mark (&info[i]);
                   return true;
                 })
    | hb_enumerate
    | machine_index
    ;
  auto pe = p + p.len ();
  auto eof = +pe;
  auto ts = +p;
  auto te = +p;
  unsigned int act HB_UNUSED;
  int cs;

#line 924 "hb-ot-shaper-use-machine.hh"
        {
        cs = use_syllable_machine_start;
        ts = 0;
        te = 0;
        act = 0;
        }

#line 284 "hb-ot-shaper-use-machine.rl"


  unsigned int syllable_serial = 1;

#line 937 "hb-ot-shaper-use-machine.hh"
        {
        int _slen;
        int _trans;
        const unsigned char *_keys;
        const unsigned char *_inds;
        if ( p == pe )
                goto _test_eof;
_resume:
        switch ( _use_syllable_machine_from_state_actions[cs] ) {
        case 3:
#line 1 "NONE"
        {ts = p;}
        break;
#line 951 "hb-ot-shaper-use-machine.hh"
        }

        _keys = _use_syllable_machine_trans_keys + (cs<<1);
        _inds = _use_syllable_machine_indicies + _use_syllable_machine_index_offsets[cs];

        _slen = _use_syllable_machine_key_spans[cs];
        _trans = _inds[ _slen > 0 && _keys[0] <=( (*p).second.second.use_category()) &&
                ( (*p).second.second.use_category()) <= _keys[1] ?
                ( (*p).second.second.use_category()) - _keys[0] : _slen ];

_eof_trans:
        cs = _use_syllable_machine_trans_targs[_trans];

        if ( _use_syllable_machine_trans_actions[_trans] == 0 )
                goto _again;

        switch ( _use_syllable_machine_trans_actions[_trans] ) {
        case 6:
#line 1 "NONE"
        {te = p+1;}
        break;
        case 14:
#line 172 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_virama_terminated_cluster); }}
        break;
        case 12:
#line 173 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_sakot_terminated_cluster); }}
        break;
        case 10:
#line 174 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_standard_cluster); }}
        break;
        case 18:
#line 175 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_number_joiner_terminated_cluster); }}
        break;
        case 16:
#line 176 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_numeral_cluster); }}
        break;
        case 8:
#line 177 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_symbol_cluster); }}
        break;
        case 22:
#line 178 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_hieroglyph_cluster); }}
        break;
        case 5:
#line 179 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_broken_cluster); buffer->scratch_flags |= HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE; }}
        break;
        case 4:
#line 180 "hb-ot-shaper-use-machine.rl"
        {te = p+1;{ found_syllable (use_non_cluster); }}
        break;
        case 13:
#line 172 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_virama_terminated_cluster); }}
        break;
        case 11:
#line 173 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_sakot_terminated_cluster); }}
        break;
        case 9:
#line 174 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_standard_cluster); }}
        break;
        case 17:
#line 175 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_number_joiner_terminated_cluster); }}
        break;
        case 15:
#line 176 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_numeral_cluster); }}
        break;
        case 7:
#line 177 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_symbol_cluster); }}
        break;
        case 21:
#line 178 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_hieroglyph_cluster); }}
        break;
        case 19:
#line 179 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_broken_cluster); buffer->scratch_flags |= HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE; }}
        break;
        case 20:
#line 180 "hb-ot-shaper-use-machine.rl"
        {te = p;p--;{ found_syllable (use_non_cluster); }}
        break;
        case 1:
#line 177 "hb-ot-shaper-use-machine.rl"
        {{p = ((te))-1;}{ found_syllable (use_symbol_cluster); }}
        break;
#line 1049 "hb-ot-shaper-use-machine.hh"
        }

_again:
        switch ( _use_syllable_machine_to_state_actions[cs] ) {
        case 2:
#line 1 "NONE"
        {ts = 0;}
        break;
#line 1058 "hb-ot-shaper-use-machine.hh"
        }

        if ( ++p != pe )
                goto _resume;
        _test_eof: {}
        if ( p == eof )
        {
        if ( _use_syllable_machine_eof_trans[cs] > 0 ) {
                _trans = _use_syllable_machine_eof_trans[cs] - 1;
                goto _eof_trans;
        }
        }

        }

#line 289 "hb-ot-shaper-use-machine.rl"

}

#undef found_syllable

#endif /* HB_OT_SHAPER_USE_MACHINE_HH */
