// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepTools_Modifier_HeaderFile
#define _BRepTools_Modifier_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopTools_DataMapOfShapeShape.hxx>
#include <TopoDS_Shape.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_BRepTools_Modification.hxx>
#include <Handle_Message_ProgressIndicator.hxx>
class Standard_NullObject;
class Standard_NoSuchObject;
class TopoDS_Shape;
class BRepTools_Modification;
class Message_ProgressIndicator;


//! Performs geometric modifications on a shape.
class BRepTools_Modifier 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates an empty Modifier.
  Standard_EXPORT BRepTools_Modifier();
  
  //! Creates a modifier on the shape <S>.
  Standard_EXPORT BRepTools_Modifier(const TopoDS_Shape& S);
  
  //! Creates a modifier on  the shape <S>, and performs
  //! the modifications described by <M>.
  Standard_EXPORT BRepTools_Modifier(const TopoDS_Shape& S, const Handle(BRepTools_Modification)& M);
  
  //! Initializes the modifier with the shape <S>.
  Standard_EXPORT   void Init (const TopoDS_Shape& S) ;
  
  //! Performs the modifications described by <M>.
  Standard_EXPORT   void Perform (const Handle(BRepTools_Modification)& M, const Handle(Message_ProgressIndicator)& aProgress = NULL) ;
  
  //! Returns Standard_True if the modification has
  //! been computed successfully.
      Standard_Boolean IsDone()  const;
  
  //! Returns the modified shape corresponding to <S>.
     const  TopoDS_Shape& ModifiedShape (const TopoDS_Shape& S)  const;




protected:





private:

  
  Standard_EXPORT   void Put (const TopoDS_Shape& S) ;
  
  Standard_EXPORT   Standard_Boolean Rebuild (const TopoDS_Shape& S, const Handle(BRepTools_Modification)& M, const Handle(Message_ProgressIndicator)& aProgress = NULL) ;


  TopTools_DataMapOfShapeShape myMap;
  TopoDS_Shape myShape;
  Standard_Boolean myDone;


};


#include <BRepTools_Modifier.lxx>





#endif // _BRepTools_Modifier_HeaderFile
