C
C $Id: tdttri.f,v 1.3 2008-07-27 00:17:33 haley Exp $
C
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
      SUBROUTINE TDTTRI (UCRA,VCRA,WCRA,NCRA,IMRK,RMRK,SMRK,RTRI,MTRI,
     +                        NTRI,IRST,UMIN,VMIN,WMIN,UMAX,VMAX,WMAX)
C
C The routine TDTTRI, given a trajectory defined by a series of points,
C calls TDMTRI to create markers showing the trajectory.  The arguments
C are as follows:
C
C   UCRA is a real array of U coordinates of points on the trajectory.
C
C   VCRA is a real array of V coordinates of points on the trajectory.
C
C   WCRA is a real array of W coordinates of points on the trajectory.
C
C   NCRA is an integer expression whose value is the number of points on
C   the trajectory.
C
C   IMRK is an integer expression whose absolute value may be from 1 to
C   5, inclusive, to select markers that are tetrahedrons, octahedrons,
C   cubes, icosahedrons, or elaborated icosahedrons (effectively,
C   spheres), respectively.  If IMRK is less than zero, the marks are
C   not clipped at the faces of the box defined by the last six
C   arguments; otherwise, they are.
C
C   RMRK is a real expression whose value is the desired radius of each
C   mark.  Its value must be greater than zero.
C
C   SMRK is a real expression whose value is the desired gap between two
C   marks along the trajectory.  A negative value can be used if it is
C   desired that the marks should overlap.  However, don't try to make
C   SMRK negative and larger in absolute value than 2.*RMRK.
C
C   RTRI is a real array in which a list of triangles is being
C   generated; it is dimensioned 10 x MTRI.  Each 10-word entry in
C   the list consists of the U, V, and W coordinates of each of three
C   points, followed by a rendering style index.
C
C   MTRI is an input integer specifying the second dimension of the
C   array RTRI: the maximum number of triangles the list will hold.
C
C   NTRI is an input/output integer specifying the number of triangles
C   currently in the array RTRI.  Initially, NTRI must be zeroed by the
C   user.  Each call to one of the routines TDSTRI or TDITRI updates the
C   value of NTRI to reflect the number of triangles added to the list.
C
C   IRST is an input integer specifying the rendering style index to be
C   used for all the triangles generated by a particular call to TDTTRI.
C   Note that more than one surface can be represented by the triangles
C   in the triangle list and that each surface can be rendered in its
C   own particular style.
C
C   UMIN, VMIN, WMIN, UMAX, VMAX, and WMAX define the clipping box for
C   the marks generated by TDTTRI.
C
C The distance from the center of one mark to the center of the next one
C will be approximately 2.*RMRK + SMRK, but a slightly adjusted value of
C SMRK is used in order to make the spacing come out even.
C
        DIMENSION UCRA(NCRA),VCRA(NCRA),WCRA(NCRA)
C
        TLEN=0.
C
C Compute the total length of the trajectory.
C
        DO 101 I=2,NCRA
          TLEN=TLEN+SQRT((UCRA(I)-UCRA(I-1))*(UCRA(I)-UCRA(I-1))+
     +                   (VCRA(I)-VCRA(I-1))*(VCRA(I)-VCRA(I-1))+
     +                   (WCRA(I)-WCRA(I-1))*(WCRA(I)-WCRA(I-1)))
  101   CONTINUE
C
C Determine how many marks will be required along the trajectory and
C quit if the number turns out to be less than or equal to zero.
C
        NMKS=INT(1.+TLEN/(RMRK+RMRK+SMRK))
        IF (NMKS.LE.0) RETURN
C
C Compute a slightly adjusted value of SMRK that will allow us to put
C marks at the beginning and end of the trajectory, with the ones in
C between evenly spaced.
C
        SADJ=(TLEN-.01*RMRK)/REAL(NMKS-1)-RMRK-RMRK
C
C Initialize.  IONP is the index of the next point on the trajectory
C and DTNM is the distance along the trajectory to the next mark.
C DTNP is the distance to the next point on the trajectory.
C
        IONP=1
        DTNM=0.
C
C Do it.  This loop is not well-protected against bad user input, so
C there is some chance it could turn into an infinite loop.  In time,
C perhaps, I will fix that ...
C
  102   IF (IONP.LT.NCRA) THEN
          IOLP=IONP
          IONP=IONP+1
          DTNP=SQRT((UCRA(IONP)-UCRA(IOLP))*(UCRA(IONP)-UCRA(IOLP))+
     +              (VCRA(IONP)-VCRA(IOLP))*(VCRA(IONP)-VCRA(IOLP))+
     +              (WCRA(IONP)-WCRA(IOLP))*(WCRA(IONP)-WCRA(IOLP)))
  103     IF (DTNP.LT.DTNM) THEN
            DTNM=DTNM-DTNP
            GO TO 102
          ELSE
            UMRK=UCRA(IOLP)+(DTNM/DTNP)*(UCRA(IONP)-UCRA(IOLP))
            VMRK=VCRA(IOLP)+(DTNM/DTNP)*(VCRA(IONP)-VCRA(IOLP))
            WMRK=WCRA(IOLP)+(DTNM/DTNP)*(WCRA(IONP)-WCRA(IOLP))
            CALL TDMTRI (IMRK,UMRK,VMRK,WMRK,RMRK,RTRI,MTRI,NTRI,IRST,
     +                                  UMIN,VMIN,WMIN,UMAX,VMAX,WMAX)
            DTNM=DTNM+RMRK+RMRK+SADJ
            GO TO 103
          END IF
        END IF
C
C Done.
C
        RETURN
C
      END
