#ifndef OBJTOOLS_EDIT___EDIT_EXCEPTION__HPP
#define OBJTOOLS_EDIT___EDIT_EXCEPTION__HPP

/*  $Id: edit_exception.hpp 638615 2021-10-02 09:47:34Z stakhovv $
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* Author: Mati Shomrat, NCBI
*
* File Description:
*   Edit exceptions
*
*/
#include <corelib/ncbistd.hpp>
#include <corelib/ncbiexpt.hpp>


BEGIN_NCBI_SCOPE
BEGIN_SCOPE(objects)
BEGIN_SCOPE(edit)


class CEditException : EXCEPTION_VIRTUAL_BASE public CException
{
public:
    enum EErrCode {
        eNotImplemented,
        eInvalid
    };
    const char* GetErrCodeString() const override;
    NCBI_EXCEPTION_DEFAULT(CEditException, CException);
};


/////////////////////////////////////////////////////////////////////////////
//  inline methods

inline
const char* CEditException::GetErrCodeString(void) const
{
    switch ( GetErrCode() ) {
    case eNotImplemented:
        return "eNotImplemented";
    case eInvalid:
        return "eInvalid";
    default:
        return CException::GetErrCodeString();
    }
}


END_SCOPE(edit)
END_SCOPE(objects)
END_NCBI_SCOPE

#endif  /* OBJTOOLS_EDIT___EDIT_EXCEPTION__HPP */
