#!/bin/sh
# $Id: copyutl.sh 471605 2015-06-29 18:57:23Z gouriano $
# ===========================================================================
# 
#                            PUBLIC DOMAIN NOTICE
#               National Center for Biotechnology Information
# 
#  This software/database is a "United States Government Work" under the
#  terms of the United States Copyright Act.  It was written as part of
#  the author's official duties as a United States Government employee and
#  thus cannot be copyrighted.  This software/database is freely available
#  to the public for use. The National Library of Medicine and the U.S.
#  Government have not placed any restriction on its use or reproduction.
# 
#  Although all reasonable efforts have been taken to ensure the accuracy
#  and reliability of the software and data, the NLM and the U.S.
#  Government do not and cannot warrant the performance or results that
#  may be obtained by using this software or data. The NLM and the U.S.
#  Government disclaim all warranties, express or implied, including
#  warranties of performance, merchantability or fitness for any particular
#  purpose.
# 
#  Please cite the author in any work or product based on this material.
#  
# ===========================================================================
# 
# Author:  Andrei Gourianov, NCBI (gouriano@ncbi.nlm.nih.gov)
#
# Copy binaries into bin directory
#
# DO NOT ATTEMPT to run this script manually
# ===========================================================================

for v in "$BUILD_TREE_BIN" "$BUILD_TREE_ROOT"; do
  if test "$v" = ""; then
    echo ERROR: required environment variable is missing
    echo DO NOT ATTEMPT to run this script manually
    exit 1
  fi
done

test -d "${PROJECT_DIR}/../${BUILD_TREE_BIN}" || mkdir -p "${PROJECT_DIR}/../${BUILD_TREE_BIN}"
cp -f -p -R ${PROJECT_DIR}/${BUILD_TREE_BIN}/* "${PROJECT_DIR}/../${BUILD_TREE_BIN}"
exit 0
