// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

[assembly:System.Runtime.CompilerServices.ReferenceAssemblyAttribute]
[assembly:System.Reflection.AssemblyVersionAttribute("0.0.0.0")]
[assembly:System.CLSCompliantAttribute(false)]

namespace System
{
    public struct nfloat
    {
        public static readonly System.nfloat MaxValue;
        public nfloat(double v) { throw null; }
        public nfloat(float v) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static System.nfloat operator +(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator --(System.nfloat v) { throw null; }
        public static System.nfloat operator /(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator ==(System.nfloat l, System.nfloat r) { throw null; }
        public static explicit operator System.nfloat (decimal v) { throw null; }
        public static explicit operator System.nfloat (double v) { throw null; }
        public static explicit operator System.nfloat (System.IntPtr v) { throw null; }
        public static explicit operator byte (System.nfloat v) { throw null; }
        public static explicit operator char (System.nfloat v) { throw null; }
        public static explicit operator decimal (System.nfloat v) { throw null; }
        public static explicit operator short (System.nfloat v) { throw null; }
        public static explicit operator int (System.nfloat v) { throw null; }
        public static explicit operator long (System.nfloat v) { throw null; }
        public static explicit operator System.IntPtr (System.nfloat v) { throw null; }
        public static explicit operator sbyte (System.nfloat v) { throw null; }
        public static explicit operator float (System.nfloat v) { throw null; }
        public static explicit operator ushort (System.nfloat v) { throw null; }
        public static explicit operator uint (System.nfloat v) { throw null; }
        public static explicit operator ulong (System.nfloat v) { throw null; }
        public static bool operator >(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator >=(System.nfloat l, System.nfloat r) { throw null; }
        public static implicit operator System.nfloat (byte v) { throw null; }
        public static implicit operator System.nfloat (char v) { throw null; }
        public static implicit operator System.nfloat (short v) { throw null; }
        public static implicit operator System.nfloat (int v) { throw null; }
        public static implicit operator System.nfloat (long v) { throw null; }
        public static implicit operator double (System.nfloat v) { throw null; }
        public static implicit operator System.nfloat (sbyte v) { throw null; }
        public static implicit operator System.nfloat (float v) { throw null; }
        public static implicit operator System.nfloat (ushort v) { throw null; }
        public static implicit operator System.nfloat (uint v) { throw null; }
        public static implicit operator System.nfloat (ulong v) { throw null; }
        public static System.nfloat operator ++(System.nfloat v) { throw null; }
        public static bool operator !=(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator <(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator <=(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator %(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator *(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator -(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator -(System.nfloat v) { throw null; }
        public static System.nfloat operator +(System.nfloat v) { throw null; }
    }
    public partial struct nint
    {
        public nint(int v) { throw null; }
        public nint(long v) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static System.nint operator +(System.nint l, System.nint r) { throw null; }
        public static System.nint operator &(System.nint l, System.nint r) { throw null; }
        public static System.nint operator |(System.nint l, System.nint r) { throw null; }
        public static System.nint operator --(System.nint v) { throw null; }
        public static System.nint operator /(System.nint l, System.nint r) { throw null; }
        public static bool operator ==(System.nint l, System.nint r) { throw null; }
        public static System.nint operator ^(System.nint l, System.nint r) { throw null; }
        public static explicit operator System.nint (decimal v) { throw null; }
        public static explicit operator System.nint (double v) { throw null; }
        public static explicit operator System.nint (long v) { throw null; }
        public static explicit operator System.nint (System.IntPtr v) { throw null; }
        public static explicit operator System.nint (System.nfloat v) { throw null; }
        public static explicit operator byte (System.nint v) { throw null; }
        public static explicit operator char (System.nint v) { throw null; }
        public static explicit operator short (System.nint v) { throw null; }
        public static explicit operator int (System.nint v) { throw null; }
        public static explicit operator System.IntPtr (System.nint v) { throw null; }
        public static explicit operator sbyte (System.nint v) { throw null; }
        public static explicit operator ushort (System.nint v) { throw null; }
        public static explicit operator uint (System.nint v) { throw null; }
        public static explicit operator ulong (System.nint v) { throw null; }
        public static explicit operator System.nint (float v) { throw null; }
        public static explicit operator System.nint (ushort v) { throw null; }
        public static explicit operator System.nint (uint v) { throw null; }
        public static explicit operator System.nint (ulong v) { throw null; }
        public static bool operator >(System.nint l, System.nint r) { throw null; }
        public static bool operator >=(System.nint l, System.nint r) { throw null; }
        public static implicit operator System.nint (byte v) { throw null; }
        public static implicit operator System.nint (char v) { throw null; }
        public static implicit operator System.nint (short v) { throw null; }
        public static implicit operator System.nint (int v) { throw null; }
        public static implicit operator decimal (System.nint v) { throw null; }
        public static implicit operator double (System.nint v) { throw null; }
        public static implicit operator long (System.nint v) { throw null; }
        public static implicit operator System.nfloat (System.nint v) { throw null; }
        public static implicit operator float (System.nint v) { throw null; }
        public static implicit operator System.nint (sbyte v) { throw null; }
        public static System.nint operator ++(System.nint v) { throw null; }
        public static bool operator !=(System.nint l, System.nint r) { throw null; }
        public static System.nint operator <<(System.nint l, int r) { throw null; }
        public static bool operator <(System.nint l, System.nint r) { throw null; }
        public static bool operator <=(System.nint l, System.nint r) { throw null; }
        public static System.nint operator %(System.nint l, System.nint r) { throw null; }
        public static System.nint operator *(System.nint l, System.nint r) { throw null; }
        public static System.nint operator ~(System.nint v) { throw null; }
        public static System.nint operator >>(System.nint l, int r) { throw null; }
        public static System.nint operator -(System.nint l, System.nint r) { throw null; }
        public static System.nint operator -(System.nint v) { throw null; }
        public static System.nint operator +(System.nint v) { throw null; }
    }
    public class NMath
    {
        public static readonly System.nfloat PI;
        public static System.nfloat Ceiling(System.nfloat value) { throw null; }
    }
}

namespace CoreGraphics
{
    public enum CGInterpolationQuality
    {
        Default = 0,
        High = 3,
        Low = 2,
        Medium = 4,
        None = 1,
    }
    public enum CGPathDrawingMode
    {
        EOFill = 1,
        EOFillStroke = 4,
        Fill = 0,
        FillStroke = 3,
        Stroke = 2,
    }
    public enum CGBlendMode
    {
        Clear = 16,
        Color = 14,
        ColorBurn = 7,
        ColorDodge = 6,
        Copy = 17,
        Darken = 4,
        DestinationAtop = 24,
        DestinationIn = 22,
        DestinationOut = 23,
        DestinationOver = 21,
        Difference = 10,
        Exclusion = 11,
        HardLight = 9,
        Hue = 12,
        Lighten = 5,
        Luminosity = 15,
        Multiply = 1,
        Normal = 0,
        Overlay = 3,
        PlusDarker = 26,
        PlusLighter = 27,
        Saturation = 13,
        Screen = 2,
        SoftLight = 8,
        SourceAtop = 20,
        SourceIn = 18,
        SourceOut = 19,
        XOR = 25,
    }
    public enum CGLineCap
    {
        Butt = 0,
        Round = 1,
        Square = 2,
    }
    public enum CGBitmapFlags : uint
    {
        AlphaInfoMask = (uint)31,
        ByteOrder16Big = (uint)12288,
        ByteOrder16Little = (uint)4096,
        ByteOrder32Big = (uint)16384,
        ByteOrder32Little = (uint)8192,
        ByteOrderDefault = (uint)0,
        ByteOrderMask = (uint)28672,
        First = (uint)4,
        FloatComponents = (uint)256,
        FloatInfoMask = (uint)3840,
        Last = (uint)3,
        None = (uint)0,
        NoneSkipFirst = (uint)6,
        NoneSkipLast = (uint)5,
        Only = (uint)7,
        PremultipliedFirst = (uint)2,
        PremultipliedLast = (uint)1,
    }
    public enum CGColorRenderingIntent
    {
        AbsoluteColorimetric = 1,
        Default = 0,
        Perceptual = 3,
        RelativeColorimetric = 2,
        Saturation = 4,
    }
    public enum CGImageAlphaInfo : uint
    {
        First = (uint)4,
        Last = (uint)3,
        None = (uint)0,
        NoneSkipFirst = (uint)6,
        NoneSkipLast = (uint)5,
        Only = (uint)7,
        PremultipliedFirst = (uint)2,
        PremultipliedLast = (uint)1,
    }
    public enum CGColorSpaceModel
    {
        CMYK = 2,
        DeviceN = 4,
        Indexed = 5,
        Lab = 3,
        Monochrome = 0,
        Pattern = 6,
        RGB = 1,
        Unknown = -1,
        Xyz = 7,
    }
    public enum CGPDFBox
    {
        Art = 4,
        Bleed = 2,
        Crop = 1,
        Media = 0,
        Trim = 3,
    }
    public enum CGPatternTiling
    {
        ConstantSpacing = 2,
        ConstantSpacingMinimalDistortion = 1,
        NoDistortion = 0,
    }
    public enum CGPathElementType
    {
        AddCurveToPoint = 3,
        AddLineToPoint = 1,
        AddQuadCurveToPoint = 2,
        CloseSubpath = 4,
        MoveToPoint = 0,
    }

    public struct CGAffineTransform
    {
        public System.nfloat x0;
        public System.nfloat xx;
        public System.nfloat xy;
        public System.nfloat y0;
        public System.nfloat yx;
        public System.nfloat yy;        
        public CGAffineTransform(System.nfloat xx, System.nfloat yx, System.nfloat xy, System.nfloat yy, System.nfloat x0, System.nfloat y0) { throw null; }
        public bool IsIdentity { get { throw null; } }
        public static CoreGraphics.CGAffineTransform CGAffineTransformInvert(CoreGraphics.CGAffineTransform t) { throw null; }
        public CoreGraphics.CGAffineTransform Invert() { throw null; }
        public static CoreGraphics.CGAffineTransform MakeIdentity() { throw null; }
        public static CoreGraphics.CGAffineTransform MakeRotation(System.nfloat angle) { throw null; }
        public static CoreGraphics.CGAffineTransform MakeScale(System.nfloat sx, System.nfloat sy) { throw null; }
        public static CoreGraphics.CGAffineTransform MakeTranslation(System.nfloat tx, System.nfloat ty) { throw null; }
        public void Multiply(CoreGraphics.CGAffineTransform b) { }
        public static CoreGraphics.CGAffineTransform Multiply(CoreGraphics.CGAffineTransform a, CoreGraphics.CGAffineTransform b) { throw null; }
        public static CoreGraphics.CGAffineTransform Rotate(CoreGraphics.CGAffineTransform transform, System.nfloat angle) { throw null; }
        public void Rotate(System.nfloat angle) { }
        public static CoreGraphics.CGAffineTransform Scale(CoreGraphics.CGAffineTransform transform, System.nfloat sx, System.nfloat sy) { throw null; }
        public void Scale(System.nfloat sx, System.nfloat sy) { }
        public CoreGraphics.CGPoint TransformPoint(CoreGraphics.CGPoint point) { throw null; }
        public static CoreGraphics.CGAffineTransform Translate(CoreGraphics.CGAffineTransform transform, System.nfloat tx, System.nfloat ty) { throw null; }
        public void Translate(System.nfloat tx, System.nfloat ty) { }
    }
    public struct CGPathElement
    {
        public CoreGraphics.CGPoint Point1;
        public CoreGraphics.CGPoint Point2;
        public CoreGraphics.CGPoint Point3;
        public CoreGraphics.CGPathElementType Type;
    }
    public struct CGPoint
    {
        public CGPoint(float x, float y) { throw null; }
        public System.nfloat X { get { throw null; } set { } }
        public System.nfloat Y { get { throw null; } set { } }
//        public static explicit operator System.Drawing.PointF (CoreGraphics.CGPoint point) { throw null; }        
//        public static implicit operator CoreGraphics.CGPoint (System.Drawing.PointF point) { throw null; }
    }
    public struct CGRect
    {
        public static readonly CoreGraphics.CGRect Empty;
        public CGRect(CoreGraphics.CGPoint location, CoreGraphics.CGSize size) { throw null; }
        public CGRect(double x, double y, double width, double height) { throw null; }
        public CGRect(System.nfloat x, System.nfloat y, System.nfloat width, System.nfloat height) { throw null; }
        public CGRect(float x, float y, float width, float height) { throw null; }
        public System.nfloat Bottom { get { throw null; } }
        public System.nfloat Height { get { throw null; } set { } }
        public System.nfloat Left { get { throw null; } }
        public System.nfloat Top { get { throw null; } }
        public System.nfloat Width { get { throw null; } set { } }
        public System.nfloat X { get { throw null; } set { } }
        public System.nfloat Y { get { throw null; } set { } }
        public System.nfloat Right { get { throw null; } }
        public CoreGraphics.CGSize Size { get { throw null; } set { } }
        public bool Equals(CoreGraphics.CGRect rect) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(CoreGraphics.CGRect left, CoreGraphics.CGRect right) { throw null; }
//        public static explicit operator System.Drawing.RectangleF (CoreGraphics.CGRect rect) { throw null; }
//        public static implicit operator CoreGraphics.CGRect (System.Drawing.Rectangle rect) { throw null; }
//        public static implicit operator CoreGraphics.CGRect (System.Drawing.RectangleF rect) { throw null; }        
        public static bool operator !=(CoreGraphics.CGRect left, CoreGraphics.CGRect right) { throw null; }
    }
    public struct CGSize
    {
        public static readonly CoreGraphics.CGSize Empty;
        public CGSize(float width, float height) { throw null; }        
        public CGSize(System.nfloat width, System.nfloat height) { throw null; }
        public System.nfloat Height { get { throw null; } set { } }
        public System.nfloat Width { get { throw null; } set { } }
//        public static explicit operator System.Drawing.SizeF (CoreGraphics.CGSize size) { throw null; }
//        public static implicit operator CoreGraphics.CGSize (System.Drawing.SizeF size) { throw null; }
    }

    public class CGColor
    {
        public CGColor(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { }        
        public System.nfloat[] Components { get { throw null; } }
        public System.nint NumberOfComponents { get { throw null; } }
        public override bool Equals(object o) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(CoreGraphics.CGColor color1, CoreGraphics.CGColor color2) { throw null; }
        public static bool operator !=(CoreGraphics.CGColor color1, CoreGraphics.CGColor color2) { throw null; }
    }
    public partial class CGContext
    {
        public CGContext(System.IntPtr handle) { }
        public System.IntPtr Handle { get { throw null; } }
        public CoreGraphics.CGInterpolationQuality InterpolationQuality { get { throw null; } set { } }
        public CoreGraphics.CGAffineTransform TextMatrix { get { throw null; } set { } }
        public void AddCurveToPoint(System.nfloat cp1x, System.nfloat cp1y, System.nfloat cp2x, System.nfloat cp2y, System.nfloat x, System.nfloat y) { }
        public void AddEllipseInRect(CoreGraphics.CGRect rect) { }
        public void AddLineToPoint(System.nfloat x, System.nfloat y) { }
        public void AddPath(CoreGraphics.CGPath path) { }
        public void BeginPage(System.Nullable<CoreGraphics.CGRect> rect) { }
        public void BeginTransparencyLayer(Foundation.NSDictionary auxiliaryInfo = null) { }
        public void ClearRect(CoreGraphics.CGRect rect) { }
        public void Clip() { }
        public void ClipToRect(CoreGraphics.CGRect rect) { }
        public void ClosePath() { }
        public void ConcatCTM(CoreGraphics.CGAffineTransform transform) { }
        public CoreGraphics.CGRect ConvertRectToUserSpace(CoreGraphics.CGRect rect) { throw null; }
        public CoreGraphics.CGSize ConvertSizeToDeviceSpace(CoreGraphics.CGSize size) { throw null; }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public void DrawImage(CoreGraphics.CGRect rect, CoreGraphics.CGImage image) { }
        public void DrawPath(CoreGraphics.CGPathDrawingMode mode) { }
        public void DrawPDFPage(CoreGraphics.CGPDFPage page) { }
        public void DrawShading(CoreGraphics.CGShading shading) { }
        public void EndPage() { }
        public void EndTransparencyLayer() { }
        public void EOFillPath() { }
        public void FillEllipseInRect(CoreGraphics.CGRect rect) { }
        public void FillPath() { }
        public void FillRect(CoreGraphics.CGRect rect) { }
        public void Flush() { }
        public CoreGraphics.CGRect GetClipBoundingBox() { throw null; }
        public CoreGraphics.CGAffineTransform GetCTM() { throw null; }
        public bool IsPathEmpty() { throw null; }
        public void MoveTo(System.nfloat x, System.nfloat y) { }
        public void RestoreState() { }
        public void SaveState() { }
        public void ScaleCTM(System.nfloat sx, System.nfloat sy) { }
        public void SetBlendMode(CoreGraphics.CGBlendMode mode) { }
        public void SetFillColor(CoreGraphics.CGColor color) { }
        public void SetFillColor(System.nfloat gray, System.nfloat alpha) { }
        public void SetFillColor(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { }
        public void SetFillColorSpace(CoreGraphics.CGColorSpace space) { }
        public void SetFillPattern(CoreGraphics.CGPattern pattern, System.nfloat[] components) { }
        public void SetLineCap(CoreGraphics.CGLineCap cap) { }
        public void SetLineDash(System.nfloat phase, System.nfloat[] lengths) { }
        public void SetLineWidth(System.nfloat w) { }
        public void SetShouldAntialias(bool shouldAntialias) { }
        public void SetStrokeColor(CoreGraphics.CGColor color) { }
        public void SetStrokeColor(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { }
        public void SetStrokeColorSpace(CoreGraphics.CGColorSpace space) { }
        public void SetStrokePattern(CoreGraphics.CGPattern pattern, System.nfloat[] components) { }
        public void StrokePath() { }
        public void StrokeRect(CoreGraphics.CGRect rect) { }
        public void Synchronize() { }
        public void TranslateCTM(System.nfloat tx, System.nfloat ty) { }
    }
    public class CGPDFDocument
    {
        public CGPDFDocument(CoreGraphics.CGDataProvider provider) { }
        public System.nint Pages { get { throw null; } }
        public CoreGraphics.CGPDFPage GetPage(System.nint page) { throw null; }
    }
    public class CGPDFPage
    {
        public CoreGraphics.CGRect GetBoxRect(CoreGraphics.CGPDFBox box) { throw null; }
        public CoreGraphics.CGAffineTransform GetDrawingTransform(CoreGraphics.CGPDFBox box, CoreGraphics.CGRect rect, int rotate, bool preserveAspectRatio) { throw null; }
    }
    public class CGPDFPageInfo {}
    public class CGImage : System.IDisposable
    {
        public CGImage(int width, int height, int bitsPerComponent, int bitsPerPixel, int bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGBitmapFlags bitmapFlags, CoreGraphics.CGDataProvider provider, System.nfloat[] decode, bool shouldInterpolate, CoreGraphics.CGColorRenderingIntent intent) { }
        public CGImage(int width, int height, int bitsPerComponent, int bitsPerPixel, int bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGImageAlphaInfo alphaInfo, CoreGraphics.CGDataProvider provider, System.nfloat[] decode, bool shouldInterpolate, CoreGraphics.CGColorRenderingIntent intent) { }
        public CoreGraphics.CGImageAlphaInfo AlphaInfo { get { throw null; } }
        public CoreGraphics.CGBitmapFlags BitmapInfo { get { throw null; } }
        public System.nint BitsPerComponent { get { throw null; } }
        public System.nint BitsPerPixel { get { throw null; } }
        public System.nint BytesPerRow { get { throw null; } }
        public CoreGraphics.CGColorSpace ColorSpace { get { throw null; } }
        public CoreGraphics.CGDataProvider DataProvider { get { throw null; } }
        public System.nint Height { get { throw null; } }
        public CoreGraphics.CGColorRenderingIntent RenderingIntent { get { throw null; } }
        public System.nint Width { get { throw null; } }
        public CoreGraphics.CGImage Clone() { throw null; }
        public void Dispose() { }
        public CoreGraphics.CGImage WithColorSpace(CoreGraphics.CGColorSpace cs) { throw null; }
        public CoreGraphics.CGImage WithImageInRect(CoreGraphics.CGRect rect) { throw null; }
    }
    public class CGContextPDF : CoreGraphics.CGContext
    {
        public CGContextPDF(CoreGraphics.CGDataConsumer dataConsumer) : base (default(System.IntPtr)) { }
        public void BeginPage(CoreGraphics.CGPDFPageInfo info) { }
        protected override void Dispose(bool disposing) { }
        public new void EndPage() { }        
    }
    public class CGBitmapContext : CoreGraphics.CGContext
    {
        public CGBitmapContext(System.IntPtr data, System.nint width, System.nint height, System.nint bitsPerComponent, System.nint bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGBitmapFlags bitmapInfo) : base (default(System.IntPtr)) { }
        public CGBitmapContext(System.IntPtr data, System.nint width, System.nint height, System.nint bitsPerComponent, System.nint bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGImageAlphaInfo bitmapInfo) : base (default(System.IntPtr)) { }
        public CoreGraphics.CGImage ToImage() { throw null; }
    }
    public class CGDataConsumer
    {
        public CGDataConsumer(Foundation.NSMutableData data) { }
    }
    public class CGFunction
    {
        public CGFunction(System.nfloat[] domain, System.nfloat[] range, CoreGraphics.CGFunction.CGFunctionEvaluate callback) { }
        public void Dispose() { }
        public unsafe delegate void CGFunctionEvaluate(System.nfloat* data, System.nfloat* outData);
    }
    public class CGDataProvider
    {
        public CGDataProvider(Foundation.NSData data) { }
        public CGDataProvider(System.IntPtr memoryBlock, int size) { }
        public CGDataProvider(System.IntPtr memoryBlock, int size, bool ownBuffer) { }
        public CGDataProvider(string file) { }
        public Foundation.NSData CopyData() { throw null; }
        public void Dispose() { }
    }
    public class CGPath
    {
        public CGPath() { }
        public CGPath(CoreGraphics.CGPath basePath) { }
        public CoreGraphics.CGRect BoundingBox { get { throw null; } }
        public bool IsEmpty { get { throw null; } }
        public void AddCurveToPoint(System.nfloat cp1x, System.nfloat cp1y, System.nfloat cp2x, System.nfloat cp2y, System.nfloat x, System.nfloat y) { }
        public void AddLineToPoint(CoreGraphics.CGPoint point) { }
        public void AddLineToPoint(System.nfloat x, System.nfloat y) { }
        public void Apply(CoreGraphics.CGPath.ApplierFunction func) { }
        public void CloseSubpath() { }
        public bool ContainsPoint(CoreGraphics.CGPoint point, bool eoFill) { throw null; }
        public override bool Equals(object o) { throw null; }
        public override int GetHashCode() { throw null; }
        public void MoveToPoint(CoreGraphics.CGPoint point) { }
        public void MoveToPoint(System.nfloat x, System.nfloat y) { }
        public static bool operator ==(CoreGraphics.CGPath path1, CoreGraphics.CGPath path2) { throw null; }
        public static bool operator !=(CoreGraphics.CGPath path1, CoreGraphics.CGPath path2) { throw null; }
        public delegate void ApplierFunction(CoreGraphics.CGPathElement element);
    }
    public class CGShading
    {
        public static CoreGraphics.CGShading CreateAxial(CoreGraphics.CGColorSpace colorspace, CoreGraphics.CGPoint start, CoreGraphics.CGPoint end, CoreGraphics.CGFunction function, bool extendStart, bool extendEnd) { throw null; }
        public void Dispose() { }
    }
    public class CGColorSpace
    {
        public CoreGraphics.CGColorSpaceModel Model { get { throw null; } }
        public static CoreGraphics.CGColorSpace CreateDeviceRGB() { throw null; }
        public static CoreGraphics.CGColorSpace CreateIndexed(CoreGraphics.CGColorSpace baseSpace, int lastIndex, byte[] colorTable) { throw null; }
        public static CoreGraphics.CGColorSpace CreatePattern(CoreGraphics.CGColorSpace baseSpace) { throw null; }
        public void Dispose() { }
    }
    public class CGPattern
    {
        public CGPattern(CoreGraphics.CGRect bounds, CoreGraphics.CGAffineTransform matrix, System.nfloat xStep, System.nfloat yStep, CoreGraphics.CGPatternTiling tiling, bool isColored, CoreGraphics.CGPattern.DrawPattern drawPattern) { }
        public delegate void DrawPattern(CoreGraphics.CGContext ctx);
    }
    public class CGImageProperties
    {
        public System.Nullable<float> DPIHeightF { get { throw null; } set { } }
        public System.Nullable<float> DPIWidthF { get { throw null; } set { } }
        public System.Nullable<int> PixelHeight { get { throw null; } set { } }
        public System.Nullable<int> PixelWidth { get { throw null; } set { } }
    }
    public class CGFont
    {
        public static CoreGraphics.CGFont CreateFromProvider(CoreGraphics.CGDataProvider provider) { throw null; }
    }
}

namespace CoreImage
{
    public class CIContext
    {
        public virtual CoreGraphics.CGImage CreateCGImage(CoreImage.CIImage image, CoreGraphics.CGRect fromRectangle) { throw null; }
        public static CoreImage.CIContext FromContext(CoreGraphics.CGContext ctx) { throw null; }
        public static CoreImage.CIContext FromOptions(CoreImage.CIContextOptions options) { throw null; }
    }
    public class CIContextOptions {}
    public class CIImage : Foundation.NSObject
    {
        public static implicit operator CoreImage.CIImage (CoreGraphics.CGImage image) { throw null; }
        public virtual CoreGraphics.CGRect Extent { get { throw null; } }
    }
    public class CIFilter : Foundation.NSObject
    {
        public static CoreImage.CIFilter FromName(string name) { throw null; }
        public virtual void SetDefaults() { }
    }
    public class CIVector : Foundation.NSObject
    {
        public CIVector(System.nfloat x, System.nfloat y, System.nfloat z, System.nfloat w) { }
    }
}

namespace CoreText
{
    public enum CTFontSymbolicTraits : uint
    {
        Bold = (uint)2,
        ColorGlyphs = (uint)8192,
        Composite = (uint)16384,
        Condensed = (uint)64,
        Expanded = (uint)32,
        Italic = (uint)1,
        Mask = (uint)4026531840,
        MonoSpace = (uint)1024,
        None = (uint)0,
        UIOptimized = (uint)4096,
        Vertical = (uint)2048,
    }
    public enum CTTextAlignment : byte
    {
        Center = (byte)2,
        Justified = (byte)3,
        Left = (byte)0,
        Natural = (byte)4,
        Right = (byte)1,
    }
    public enum CTLineTruncation : uint
    {
        End = (uint)1,
        Middle = (uint)2,
        Start = (uint)0,
    }
    public enum CTUnderlineStyle
    {
        Double = 9,
        None = 0,
        Single = 1,
        Thick = 2,
    }
    public enum CTFontUIFontType : uint
    {
        AlertHeader = (uint)18,
        Application = (uint)9,
        ControlContent = (uint)26,
        EmphasizedSystem = (uint)3,
        EmphasizedSystemDetail = (uint)20,
        Label = (uint)10,
        MenuItem = (uint)12,
        MenuItemCmdKey = (uint)14,
        MenuItemMark = (uint)13,
        MenuTitle = (uint)11,
        Message = (uint)23,
        MiniEmphasizedSystem = (uint)7,
        MiniSystem = (uint)6,
        None = (uint)4294967295,
        Palette = (uint)24,
        PushButton = (uint)16,
        SmallEmphasizedSystem = (uint)5,
        SmallSystem = (uint)4,
        SmallToolbar = (uint)22,
        System = (uint)2,
        SystemDetail = (uint)19,
        Toolbar = (uint)21,
        ToolTip = (uint)25,
        User = (uint)0,
        UserFixedPitch = (uint)1,
        UtilityWindowTitle = (uint)17,
        Views = (uint)8,
        WindowTitle = (uint)15,
    }

    public class CTFont
    {
        public CTFont(CoreGraphics.CGFont font, System.nfloat size, CoreGraphics.CGAffineTransform transform) { }
        public CTFont(CoreGraphics.CGFont font, System.nfloat size, CoreText.CTFontDescriptor descriptor) { }
        public CTFont(CoreText.CTFontDescriptor descriptor, System.nfloat size) { }
        public CTFont(CoreText.CTFontUIFontType uiType, System.nfloat size, string language) { }
        public System.nfloat AscentMetric { get { throw null; } }
        public System.nfloat DescentMetric { get { throw null; } }
        public string FamilyName { get { throw null; } }
        public System.IntPtr Handle { get { throw null; } }
        public System.nfloat LeadingMetric { get { throw null; } }
        public System.nfloat Size { get { throw null; } }
        public CoreText.CTFontSymbolicTraits SymbolicTraits { get { throw null; } }
        public System.nfloat UnderlineThickness { get { throw null; } }
        public uint UnitsPerEmMetric { get { throw null; } }
        public System.nfloat XHeightMetric { get { throw null; } }
        public void Dispose() { }
        public CoreText.CTFontDescriptor GetFontDescriptor() { throw null; }
        public CoreGraphics.CGPath GetPathForGlyph(ushort glyph) { throw null; }
        public CoreText.CTFontTraits GetTraits() { throw null; }
        public CoreText.CTFont WithSymbolicTraits(System.nfloat size, CoreText.CTFontSymbolicTraits symTraitValue, CoreText.CTFontSymbolicTraits symTraitMask) { throw null; }
    }
    public class CTFontDescriptor
    {
        public CTFontDescriptor(CoreText.CTFontDescriptorAttributes attributes) { }
        public CTFontDescriptor(string name, System.nfloat size) { }
        public Foundation.NSObject GetAttribute(Foundation.NSString attribute) { throw null; }
        public CoreText.CTFontDescriptorAttributes GetAttributes() { throw null; }
        public CoreText.CTFontDescriptor[] GetMatchingFontDescriptors(Foundation.NSSet mandatoryAttributes) { throw null; }
    }
    public class CTFontDescriptorAttributes
    {
        public CTFontDescriptorAttributes(Foundation.NSDictionary dictionary) { }
        public string FamilyName { get { throw null; } set { } }
    }
    public class CTFontDescriptorAttributeKey
    {
        public static readonly Foundation.NSString FamilyName;
        public static readonly Foundation.NSString Traits;
    }
    public class CTLine : System.IDisposable
    {
        public CTLine(Foundation.NSAttributedString value) { }
        public Foundation.NSRange StringRange { get { throw null; } }
        public double TrailingWhitespaceWidth { get { throw null; } }
        public void Dispose() { }
        public void Draw(CoreGraphics.CGContext context) { }
        public CoreText.CTRun[] GetGlyphRuns() { throw null; }
        public double GetPenOffsetForFlush(System.nfloat flushFactor, double flushWidth) { throw null; }
        public CoreText.CTLine GetTruncatedLine(double width, CoreText.CTLineTruncation truncationType, CoreText.CTLine truncationToken) { throw null; }
        public double GetTypographicBounds(out System.nfloat ascent, out System.nfloat descent, out System.nfloat leading) { throw null; }
    }
    public class CTRun
    {
        public ushort[] GetGlyphs() { throw null; }
        public CoreGraphics.CGPoint[] GetPositions() { throw null; }
    }
    public class CTFontCollection
    {
        public CTFontCollection(CoreText.CTFontCollectionOptions options) { }
        public void Dispose() { }
        public CoreText.CTFontDescriptor[] GetMatchingFontDescriptors() { throw null; }
    }
    public class CTFontTraitKey
    {
        public static readonly Foundation.NSString Symbolic;
        public static readonly Foundation.NSString Weight;
    }
    public class CTFontTraits
    {
        public System.Nullable<CoreText.CTFontSymbolicTraits> SymbolicTraits { get { throw null; } set { } }
    }
    public class CTFontManager
    {
        public static bool RegisterGraphicsFont(CoreGraphics.CGFont font, out Foundation.NSError error) { throw null; }
    }
    public class CTFontCollectionOptions
    {
        public bool RemoveDuplicates { get { throw null; } set { } }
    }
    public class CTStringAttributes
    {
        public Foundation.NSDictionary Dictionary { get { throw null; } }
        public CoreText.CTFont Font { get { throw null; } set { } }
        public CoreGraphics.CGColor ForegroundColor { get { throw null; } set { } }
        public bool ForegroundColorFromContext { get { throw null; } set { } }
        public CoreText.CTParagraphStyle ParagraphStyle { get { throw null; } set { } }
        public System.Nullable<CoreText.CTUnderlineStyle> UnderlineStyle { get { throw null; } set { } }
        public System.Nullable<int> UnderlineStyleValue { get { throw null; } set { } }
    }
    public class CTParagraphStyle
    {
        public CTParagraphStyle(CoreText.CTParagraphStyleSettings settings) { }
    }
    public class CTTypesetter : System.IDisposable
    {
        public CTTypesetter(Foundation.NSAttributedString value) { }
        public void Dispose() { }
        public CoreText.CTLine GetLine(Foundation.NSRange stringRange) { throw null; }
        public System.nint SuggestLineBreak(int startIndex, double width) { throw null; }
    }
    public class CTParagraphStyleSettings
    {
        public System.Nullable<CoreText.CTTextAlignment> Alignment { get { throw null; } set { } }
    }
}

namespace Foundation
{
    public struct NSRange
    {
        public System.nint Length;
        public NSRange(System.nint start, System.nint len) { throw null; }        
    }

    public class NSAttributedString
    {
        public NSAttributedString() { }
        public NSAttributedString(string str, Foundation.NSDictionary attributes) { }
        public virtual System.nint Length { get { throw null; } }        
    }
    public class NSBundle
    {
        public static Foundation.NSBundle MainBundle { get { throw null; } }        
        public virtual string PathForResource(string name, string ofType) { throw null; }
    }
    public class NSData : Foundation.NSObject, System.IDisposable
    {
        public virtual byte this[System.nint idx] { get { throw null; } set { } }
        public virtual System.IO.Stream AsStream() { throw null; }
        public static Foundation.NSData FromArray(byte[] buffer) { throw null; }
        public static Foundation.NSData FromStream(System.IO.Stream stream) { throw null; }        
    }
    public class NSDictionary : Foundation.NSObject
    {
        public virtual Foundation.NSObject this[Foundation.NSString key] { get { throw null; } set { } }
    }
    public class NSError
    {
        public virtual System.nint Code { get { throw null; } }        
    }
    public class NSLocale
    {
        public static string[] PreferredLanguages { get { throw null; } }        
    }
    public class NSMutableAttributedString : Foundation.NSAttributedString
    {
        public NSMutableAttributedString(string str) { }
        public NSMutableAttributedString(string str, Foundation.NSDictionary attributes) { }
        public virtual void AddAttributes(Foundation.NSDictionary attrs, Foundation.NSRange range) { }
        public void AddAttributes(CoreText.CTStringAttributes attrs, Foundation.NSRange range) { }
    }
    public class NSMutableData : Foundation.NSData {}
    public class NSMutableDictionary : Foundation.NSDictionary {}
    public class NSNotification {}
    public class NSNotificationCenter
    {
        public static Foundation.NSNotificationCenter DefaultCenter { get { throw null; } }
        public Foundation.NSObject AddObserver(Foundation.NSString aName, System.Action<Foundation.NSNotification> notify) { throw null; }
    }
    public class NSNumber : Foundation.NSValue
    {
        public static Foundation.NSNumber FromFloat(float value) { throw null; }        
        public static Foundation.NSNumber FromUInt32(uint value) { throw null; }
    }
    public class NSObject : System.IDisposable
    {
        public System.IntPtr Handle { get { throw null; } set { } }
        public void Dispose() { }
        public virtual void SetValueForKey(Foundation.NSObject value, Foundation.NSString key) { }
        public virtual Foundation.NSObject ValueForKey(Foundation.NSString key) { throw null; }
    }
    public class NSValue : Foundation.NSObject {}
    public class NSSet {}
    public class NSString : Foundation.NSObject
    {
        public NSString(string str) { }
        public static explicit operator Foundation.NSString (string str) { throw null; }
    }
    public class NSUrl
    {
        public static Foundation.NSUrl FromFilename(string url) { throw null; }
        public virtual string Path { get { throw null; } }
    }
}

namespace ImageIO
{
    public class CGImageSource : System.IDisposable
    {
        public System.nint ImageCount { get { throw null; } }
        public string TypeIdentifier { get { throw null; } }
        public CoreGraphics.CGImage CreateImage(int index, ImageIO.CGImageOptions options) { throw null; }
        public void Dispose() { }
        public static ImageIO.CGImageSource FromData(Foundation.NSData data) { throw null; }
        public static ImageIO.CGImageSource FromUrl(Foundation.NSUrl url) { throw null; }
        public CoreGraphics.CGImageProperties GetProperties(int index, ImageIO.CGImageOptions options = null) { throw null; }
    }
    public class CGImageOptions {}
    public class CGImageDestination : System.IDisposable
    {
        public void AddImage(CoreGraphics.CGImage image, Foundation.NSDictionary properties) { }
        public bool Close() { throw null; }
        public void Dispose() { }
        public static ImageIO.CGImageDestination Create(Foundation.NSMutableData data, string typeIdentifier, int imageCount, ImageIO.CGImageDestinationOptions options = null) { throw null; }
        public static ImageIO.CGImageDestination Create(Foundation.NSUrl url, string typeIdentifier, int imageCount) { throw null; }
    }
    public class CGImageDestinationOptions {}
}

namespace ObjCRuntime
{
    public static partial class Runtime
    {
        public static Foundation.NSObject GetNSObject(System.IntPtr ptr) { throw null; }
    }
}

namespace AppKit
{
    public enum NSTextAlignment : ulong
    {
        Center = (ulong)2,
        Justified = (ulong)3,
        Left = (ulong)0,
        Natural = (ulong)4,
        Right = (ulong)1,
    }
    public enum NSPrintingOrientation : ulong
    {
        Landscape = (ulong)1,
        Portrait = (ulong)0,
    }
    public enum NSUnderlinePattern
    {
        Dash = 512,
        DashDot = 768,
        DashDotDot = 1024,
        Dot = 256,
        Solid = 0,
    }
    public enum NSUnderlineStyle : long
    {
        ByWord = (long)32768,
        Double = (long)9,
        None = (long)0,
        PatternDash = (long)512,
        PatternDashDot = (long)768,
        PatternDashDotDot = (long)1024,
        PatternDot = (long)256,
        PatternSolid = (long)0,
        Single = (long)1,
        Thick = (long)2,
    }

	public class NSColor : Foundation.NSObject
	{
        public virtual CoreGraphics.CGColor CGColor { get { throw null; } }
        public static AppKit.NSColor Control { get { throw null; } }
        public static AppKit.NSColor ControlBackground { get { throw null; } }
        public static AppKit.NSColor ControlDarkShadow { get { throw null; } }
        public static AppKit.NSColor ControlHighlight { get { throw null; } }
        public static AppKit.NSColor ControlLightHighlight { get { throw null; } }
        public static AppKit.NSColor ControlShadow { get { throw null; } }
        public static AppKit.NSColor ControlText { get { throw null; } }
        public static AppKit.NSColor DisabledControlText { get { throw null; } }
        public static AppKit.NSColor ScrollBar { get { throw null; } }
        public static AppKit.NSColor SelectedText { get { throw null; } }
        public static AppKit.NSColor SelectedTextBackground { get { throw null; } }
        public static AppKit.NSColor WindowFrame { get { throw null; } }
        public static AppKit.NSColor FromDeviceRgba(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { throw null; }
        public virtual void GetRgba(out System.nfloat red, out System.nfloat green, out System.nfloat blue, out System.nfloat alpha) { throw null; }
        public virtual AppKit.NSColor UsingColorSpace(AppKit.NSColorSpace colorSpace) { throw null; }
	}
	public class NSColorSpace : Foundation.NSObject
	{
        public static AppKit.NSColorSpace GenericRGBColorSpace { get { throw null; } }
	}
	public class NSFont : Foundation.NSObject {}
	public class NSGraphicsContext : Foundation.NSObject
	{
        public virtual CoreGraphics.CGContext CGContext { get { throw null; } }
        public static AppKit.NSGraphicsContext CurrentContext { get { throw null; } set { } }
        public virtual CoreGraphics.CGContext GraphicsPort { get { throw null; } }
        public virtual bool IsFlipped { get { throw null; } }
        public static AppKit.NSGraphicsContext FromGraphicsPort(CoreGraphics.CGContext context, bool initialFlippedState) { throw null; }
	}
	public class NSImage : Foundation.NSObject
	{
        public NSImage(CoreGraphics.CGImage cgImage, CoreGraphics.CGSize size) { }
//        public NSImage(CoreGraphics.CGSize aSize) { }
//        public NSImage(Foundation.NSCoder coder) { }
        public NSImage(Foundation.NSData data) { }
//        public NSImage(Foundation.NSData data, bool ignoresOrientation) { }
//        protected NSImage(Foundation.NSObjectFlag t) { }
//        public NSImage(Foundation.NSUrl url) { }
//        public NSImage(string fileName) { }
//        public NSImage(string fileName, bool lazy) { }
	}
	public class NSPrinter : Foundation.NSObject
	{
        public virtual string Name { get { throw null; } }
        public static string[] PrinterNames { get { throw null; } }
        public virtual CoreGraphics.CGSize PageSizeForPaper(string paperName) { throw null; }
        public static AppKit.NSPrinter PrinterWithName(string name) { throw null; }
        public virtual string[] StringListForKey(string key, string table) { throw null; }
	}
	public class NSPrintInfo : Foundation.NSObject
	{
        public NSPrintInfo(Foundation.NSDictionary attributes) { }
        public virtual System.nfloat BottomMargin { get { throw null; } set { } }
        public static AppKit.NSPrinter DefaultPrinter { get { throw null; } }
        public virtual Foundation.NSMutableDictionary Dictionary { get { throw null; } }
        public virtual CoreGraphics.CGRect ImageablePageBounds { get { throw null; } }
        public virtual System.nfloat LeftMargin { get { throw null; } set { } }
        public virtual AppKit.NSPrintingOrientation Orientation { get { throw null; } set { } }
        public virtual string PaperName { get { throw null; } set { } }
        public virtual CoreGraphics.CGSize PaperSize { get { throw null; } set { } }
        public virtual AppKit.NSPrinter Printer { get { throw null; } set { } }
        public virtual System.nfloat RightMargin { get { throw null; } set { } }
        public static AppKit.NSPrintInfo SharedPrintInfo { get { throw null; } set { } }
        public virtual System.nfloat TopMargin { get { throw null; } set { } }
        public virtual System.IntPtr GetPMPageFormat() { throw null; }
        public virtual System.IntPtr GetPMPrintSession() { throw null; }
	}
	public class NSResponder : Foundation.NSObject {}
	public class NSScreen : Foundation.NSObject
	{
        public virtual System.nfloat BackingScaleFactor { get { throw null; } }
        public static AppKit.NSScreen MainScreen { get { throw null; } }
	}
	public class NSView : AppKit.NSResponder
	{
        public virtual AppKit.NSWindow Window { get { throw null; } }
        public static AppKit.NSView FocusView() { throw null; }
        public virtual bool LockFocusIfCanDraw() { throw null; }
        public virtual void UnlockFocus() { }
	}
	public class NSWindow : AppKit.NSResponder
	{
        public virtual AppKit.NSGraphicsContext GraphicsContext { get { throw null; } }
	}
}

namespace CoreFoundation
{
	public class CFString : System.IDisposable
	{
        public CFString(string str) { }
        public System.IntPtr Handle { get { throw null; } }
        public void Dispose() { }
	}
}

namespace PrintCore
{
    public enum PMDuplexMode : uint
    {
        None = (uint)1,
        NoTumble = (uint)2,
        SimplexTumble = (uint)4,
        Tumble = (uint)3,
    }

    public enum PMStatusCode
    {
        AllocationFailure = -108,
        CloseFailed = -9785,
        CreateMessageFailed = -9620,
        CvmSymbolNotFound = -9662,
        DeleteSubTicketFailed = -9585,
        DocumentNotFound = -9644,
        DontSwitchPdeError = -9531,
        EditRequestFailed = -9544,
        FeatureNotInstalled = -9533,
        FileOrDirOperationFailed = -9634,
        FontNameTooLong = -9704,
        FontNotFound = -9703,
        GeneralCGError = -9705,
        GeneralError = -30870,
        InternalError = -30870,
        InvalidAllocator = -30890,
        InvalidCalibrationTarget = -30898,
        InvalidConnection = -30887,
        InvalidCvmContext = -9665,
        InvalidFileType = -30895,
        InvalidIndex = -30882,
        InvalidIOMContext = -9664,
        InvalidItem = -30892,
        InvalidJobID = -9666,
        InvalidJobTemplate = -30885,
        InvalidKey = -30888,
        InvalidLookupSpec = -9542,
        InvalidObject = -30896,
        InvalidPageFormat = -30876,
        InvalidPaper = -30897,
        InvalidParameter = -50,
        InvalidPbmRef = -9540,
        InvalidPdeContext = -9530,
        InvalidPMContext = -9663,
        InvalidPreset = -30899,
        InvalidPrinter = -30880,
        InvalidPrinterAddress = -9780,
        InvalidPrinterInfo = -30886,
        InvalidPrintSession = -30879,
        InvalidPrintSettings = -30875,
        InvalidReply = -30894,
        InvalidState = -9706,
        InvalidSubTicket = -9584,
        InvalidTicket = -30891,
        InvalidType = -30893,
        InvalidValue = -30889,
        IOAttrNotAvailable = -9787,
        IOMSymbolNotFound = -9661,
        ItemIsLocked = -9586,
        JobBusy = -9642,
        JobCanceled = -9643,
        JobGetTicketBadFormatError = -9672,
        JobGetTicketReadError = -9673,
        JobManagerAborted = -9671,
        JobNotFound = -9641,
        JobStreamEndError = -9670,
        JobStreamOpenFailed = -9668,
        JobStreamReadFailed = -9669,
        KeyNotFound = -9589,
        KeyNotUnique = -9590,
        KeyOrValueNotFound = -9623,
        LockIgnored = -30878,
        MessagingError = -9624,
        NoDefaultItem = -9500,
        NoDefaultPrinter = -30872,
        NoDefaultSettings = -9501,
        NoPrinterJobID = -9667,
        NoSelectedPrinters = -9541,
        NoSuchEntry = -30874,
        NotImplemented = -30873,
        ObjectInUse = -30881,
        Ok = 0,
        OpenFailed = -9781,
        OutOfScope = -30871,
        PermissionError = -9636,
        PluginNotFound = -9701,
        PluginRegisterationFailed = -9702,
        PMSymbolNotFound = -9660,
        PrBrowserNoUI = -9545,
        QueueAlreadyExists = -9639,
        QueueJobFailed = -9640,
        QueueNotFound = -9638,
        ReadFailed = -9782,
        ReadGotZeroData = -9788,
        ServerAlreadyRunning = -9631,
        ServerAttributeRestricted = -9633,
        ServerCommunicationFailed = -9621,
        ServerNotFound = -9630,
        ServerSuspended = -9632,
        StatusFailed = -9784,
        StringConversionFailure = -30883,
        SubTicketNotFound = -9583,
        SyncRequestFailed = -9543,
        TemplateIsLocked = -9588,
        TicketIsLocked = -9587,
        TicketTypeNotFound = -9580,
        UnableToFindProcess = -9532,
        UnexpectedImagingError = -9707,
        UnknownDataType = -9591,
        UnknownMessage = -9637,
        UnsupportedConnection = -9786,
        UpdateTicketFailed = -9581,
        UserOrGroupNotFound = -9635,
        ValidateTicketFailed = -9582,
        ValueOutOfRange = -30877,
        WriteFailed = -9783,
        XMLParseError = -30884,
    }

    public partial class PMPrintCoreBase : System.IDisposable
    {
        public System.IntPtr Handle { get { throw null; } }
        public void Dispose() { }
    }
	public class PMPrintSettings : PrintCore.PMPrintCoreBase
	{
        public bool Collate { get { throw null; } set { } }
        public PrintCore.PMDuplexMode DuplexMode { get { throw null; } set { } }
        public uint FirstPage { get { throw null; } set { } }
        public uint LastPage { get { throw null; } set { } }
        public PrintCore.PMStatusCode SetPageRange(uint minPage, uint maxPage) { throw null; }
	}
}
