(* Utility functions for HTML output. *)

let create_page filename title =
  let root = Misc.get_root_directory () in
  let path = root ^ "/html/" ^ filename ^ ".html" in
  try
    let channel = open_out path in
      output_string channel "<html><head><title>";
      output_string channel title;
      output_string channel "</title>";
      output_string channel "<link rel=\"stylesheet\" type=\"text/css\" ";
      output_string channel "href=\"accounts.css\" />";
      output_string channel "</head>\n<body>";
      output_string channel "<h1>";
      output_string channel title;
      output_string channel "</h1>";
      channel
  with Sys_error _ -> Misc.fail ("Could not create file " ^ path)

let finish_page channel =
  output_string channel "</body></html>";
  close_out channel

