/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "Preferences.h"
#include "MvPath.hpp"
#include "ObjectList.h"

Preferences::Preferences(Presentable& owner) :
    owner_(&owner)
//		inputType_       ( NOINPUT       ),
//		cursorType_      ( POINTERCURSOR ),
//		keepAspectRatio_ ( true          ),
//		printJob_        ( false         )
{
}
Preferences::Preferences(const Preferences& old) :
    owner_(old.owner_)
//		inputType_  (  old.inputType_      ),
//		cursorType_  ( old.cursorType_ ),
//		keepAspectRatio_ (old.keepAspectRatio_  ),
//		printJob_        (  old.printJob_ )
{
}

MvRequest Preferences::CoastRequest()
{
    // Create a coastline request and read user's preferences
    MvRequest coastRequest;
    string path = MakeUserDefPath("CoastlinesGeographyHelper");

    // Do we have a preference ?
    if ((FileCanBeOpened(path.c_str(), "rw") == false) ||
        (FileHasValidSize(path.c_str()) == false)) {
        // Create a new one
        coastRequest = ObjectList::CreateDefaultRequest("MCOAST");
        coastRequest.save(path.c_str());
    }
    else
        coastRequest.read(path.c_str());

    return coastRequest;
}

#if 0
// --  METHOD:  DeviceRequest
//
// --  PURPOSE: Retrieves the device Request from
//              the user's preferences directory


MvRequest
Preferences::PrinterRequest()
{
	MvRequest printerRequest;

	Cached path = MakeUserPrefPath ("Printer Manager");

	// Do we have a preference ?

	if ( ( FileCanBeOpened ( path, "rw" ) == false ) || ( FileHasValidSize ( path ) == false ))
	{
		// Create a new one
		printerRequest = ObjectList::CreateDefaultRequest  ("PRINTER_MANAGER");
		printerRequest.save ( path  );
		return printerRequest;
	}

	printerRequest.read ( (const char*) path );

	return printerRequest;
}


void
Preferences::EditPrinterPreferences( bool printJob )
{
	// Check if we are creating a macro job afterwards
	printJob_ = printJob;

	MvRequest printerRequest;
	Cached path = MakeUserPrefPath ("Printer Manager");

	// Try to open a file on the user's preferences directory
	if ( ( FileCanBeOpened ( path, "r" ) == false ) || ( FileHasValidSize ( path ) == false ) ) 
	{
		// Create a new one
		printerRequest = ObjectList::CreateDefaultRequest  ("PRINTER_MANAGER");
		printerRequest.save ( path  );
	}
	else
		printerRequest.read ( path );

	// Call GenApp - if failed, post a message
	// Note the callback function
	if ( CallGenAppService ( *this,  &Preferences::SavePrinterPreferences, 
				 printerRequest ) == false )
		PlotMod::UserMessage ("Please Finish Current Preferences Setup");
}
//
// -- METHOD: SavePrinterPreferences 
//
// -- PURPOSE: Save the user preferences (which are edited by GenApp)
//             in a file AND tell the superpage to print the request
//			   This method is called back after GenApp has finished
//
// -- CAVEAT:  This "side effect" is difficult to avoid, since we cannot
//             start printing until the user has decided on his preferences
// 
void
Preferences::SavePrinterPreferences( MvRequest& replyRequest )
{
	// Test for Cancel button selected on Printer interface
	if ( replyRequest.getVerb() != Cached ( "PRINTER_MANAGER" ) )
		return;

	// Expand the reply request from GenApp
	MvRequest expandedRequest = ObjectList::ExpandRequest ( replyRequest, 0  );

	Cached path = MakeUserPrefPath ("Printer Manager");

	// Save the reply request

	if ( FileCanBeOpened ( path, "w" ) == true )
		expandedRequest.save ( path );

	// Based on destination set the owner print mode (preview or file)
	Cached destination = expandedRequest( "DESTINATION" );
	if (( destination == Cached( "SCREEN" )) || 
            ( destination == Cached( "PREVIEW" ))  )
		Owner().PrintPreview();
	

	if ( expandedRequest( "PRINT_OPTION" ) == Cached ( "ALL" ) )
		Owner().PrintAll ( true );
	else
		Owner().PrintAll ( false );

	// Remember to ask the superpage to really print
	if ( printJob_ == true )
		Owner().PrintJob();
}

void
Preferences::EditInterfacePreferences()
{
}

void
Preferences::SaveInterfacePreferences(MvRequest& )
{
}

void
Preferences::EditMapPreferences()
{
	MvRequest mapRequest;
	Cached path = MakeUserPrefPath ("MapDefinition");

	// Do we have a preference ?

	if ( ( FileCanBeOpened ( path, "rw" ) == false )|| ( FileHasValidSize( path ) == false ) )
	{
		// Create a new one
		mapRequest = ObjectList::CreateDefaultRequest  ("MAP_DEFINITION");
		mapRequest.save ( path  );
	}
	else
		mapRequest.read ( (const char*) path );

	// Call GenApp - if failed, post a message
	// Note the callback function
	
	if ( CallGenAppService ( *this,  &Preferences::SaveMapPreferences, 
				 mapRequest ) == false )
		PlotMod::UserMessage ("Please Finish Current Preferences Setup");


}

void
Preferences::SaveMapPreferences( MvRequest& replyRequest )
{
	// Expand the reply request from GenApp
	MvRequest expandedRequest = ObjectList::ExpandRequest ( replyRequest, 0  );

	Cached path = MakeUserPrefPath ("MapDefinition");

	// Save the reply request

	if ( FileCanBeOpened ( path, "w" ) == true )
		expandedRequest.save ( path );
}

MvRequest
Preferences::MapDefRequest()
{
         // Create a map definition request
	MvRequest mapdefRequest;

	Cached path = MakeUserPrefPath ("MapDefinition");

	// Do we have a preference ?
	if ( ( FileCanBeOpened ( path, "rw" ) == false ) || ( FileHasValidSize( path ) == false ) )
	{
		// Create a new one
		mapdefRequest = ObjectList::CreateDefaultRequest  ("MAP_DEFINITION");
		mapdefRequest.save ( path  );
	}
	else
		mapdefRequest.read ( (const char*) path );

return mapdefRequest;
}

void
Preferences::EditCoastPreferences ()
{
	// Create a coastline request and read user's preferences

	MvRequest coastRequest;
	Cached path = MakeUserPrefPath ("Coastlines");

	// Do we have a preference ?
	if ( ( FileCanBeOpened ( path, "rw" ) == false ) || ( FileHasValidSize( path ) == false ) )
	{
		// Create a new one
		coastRequest = ObjectList::CreateDefaultRequest  ("PCOAST");
		coastRequest.save ( path  );
	}
	else
		coastRequest.read ( (const char*) path );

	// Call GenApp - if failed, post a message
	// Note the callback function
	if ( CallGenAppService ( *this, &Preferences::SaveCoastPreferences, 
				 coastRequest ) == false )
		PlotMod::UserMessage ("Please Finish Current Preferences Setup");
}

void
Preferences::SaveCoastPreferences ( MvRequest& replyRequest )
{
	if ( replyRequest.getVerb () != PCOAST )
		return;

	// Expand the reply request from GenApp
	MvRequest expandedRequest = ObjectList::ExpandRequest ( replyRequest, 0  );

	Cached path = MakeUserPrefPath ("Coastlines");

	// Save the reply request
	if ( FileCanBeOpened ( path, "w" ) == true )
		expandedRequest.save ( path );

	Owner().UpdateVisDef ( replyRequest );
}

void
Preferences::SetZoomOption ( int option )
{
	if ( option == MAGNIFY )
		cursorType_ = MAGNIFYCURSOR;
	else
		cursorType_ = ZOOMCURSOR;
}
#endif
