.TH "{BuildPackage}" "1" "December 2009" "{BuildPackage} {Version}" "User Commands"

.SH NAME

{BuildPackage} - Build a .deb package from source code under
Mercurial control.

.SH SYNOPSIS

\fB{BuildPackage}\fR [\fIoption\fR] ...

.SH DESCRIPTION

\fB{BuildPackage}\fR builds a .deb package from within a Mercurial
repository.  The package is built either by use of
\fBpbuilder\fR(1) or in-place, depending on the options.

.SH OPTIONS

.HP
\fB\-\-version\fR, \fB\-V\fR
.IP
Output version and exit.
.HP
\fB\-\-verbose\fR, \fB\-v\fR
.IP
Increase verbosity level.  Can be used several times.
.HP
\fB\-\-no\-check\-dependencies\fR, \fB\-d\fR
.IP
Do not check for missing build dependencies.
.HP
\fB\-\-include\-source\fR, \fB\-s\fR, \fB\-sa\fR
.IP
Force inclusion of upstream source.
.HP
\fB\-\-from\-version\fR \fIchangelogversion\fR, \fB\-f\fR \fIchangelogversion\fR
.IP
Include all changelog entries from \fIchangelogversion\fR.
.HP
\fB\-\-source\-only\fR, \fB\-S\fR
.IP
Build the source only.
.HP
\fB\-\-configfile\fR \fIpbuilderconfigfile\fR, \fB\-c\fR \fIpbuilderconfigfile\fR
.IP
Use \fBpbuilder\fR(1) to build package in a \fBchroot\fR(8) specified
in \fIpbuilderconfigfile\fR.

.SH EXAMPLES

.HP
\fB{BuildPackage}\fR
.IP
Silently build a package in-place using debian/rules and
\fBdpkg\-genchanges\fR(1).  The complete build log
will be placed in
\fR../\fIpackage\fR_\fIversion\fR_\fIarch\fR.build\fR.

.HP
\fB{BuildPackage}\fR \fB\-s\fR \fB\-f\fR 1.2\-3
\fB\-c\fR /home/jps/lenny\-pbuilderrc
.IP
Build a backport package for the Lenny release using pbuilder.  The
source and all changelog entries since 1.2\-3 are included in package.

.SH REPOSITORY LAYOUT

Let us assume that your package is called \fImypack\fR.  The package
repository should be created by a regular \fBhg\fR \fBinit\fR
\fImypack\fR command.

.P
If \fImypack\fR is a native package, then your repository will only have
the usual \fBdefault\fR branch and {Package} will only affect the
\fB.hgtags\fR file when \fB{TagVersion}\fR(1) is invoked to tag a
release of \fImypack\fR.

.P
If \fImypack\fR is a non-native package, then it will have a number of
upstream tarballs, as specified in \fBdpkg\-source\fR(1).  Let us assume
that the upstream tarballs are mypack_1.0.orig.tar.gz,
mypack_1.0.orig\-comp1.tar.bz2 and mypack_1.0.orig\-comp2.tar.gz, and that
you therefore use package format 3.0 (quilt).
{Package} will then maintain the following branches.

.TP 10
mypack
A branch containing the source from the main tarball.
.TP
comp1
A branch containing the source from the comp1 tarball.
.TP
comp2
A branch containing the source from the comp2 tarball.
.TP
pristine
A branch containing additional information for recreating pristine
upstream tarballs.
.TP
upstream
The combination of all upstream tarballs, as specified in
\fBdpkg\-source\fR(1).
.TP
default 
The branch for mainline package work.  It will have all debian/patches
applied and the quilt .pc directory included as part of the repository.

.P
So each upstream tarball will have its own branch which together with
the \fBpristine\fR branch are used by \fB{PristineTar}\fR(1) to recreate
pristine upstream tarballs.

.P
The \fBupstream\fR branch is used by \fB{ImportOrig}\fR(1) to merge
new upstream versions into the mainline \fBdefault\fR branch; and by
\fB{Port}\fR(1) to make alternative packages of selected upstream
versions, for instance for backporting.

.P
In general, you should leave alone all the branches dealing with upsteam
sources, and only work in the \fBdefault\fR branch or branches created
by \fB{Port}\fR(1) for porting.

.SH OPERATIONAL OUTLINE

.SS In-place building

.nf
fakeroot debian/rules clean
dpkg\-source \-i.hg \-b mypack ..
debian/rules build
debian/rules binary
dpkg\-genchanges > ../mypack_1.0\-2_i386.changes
.fi

.SS Chroot building

.nf
fakeroot debian/rules clean
dpkg\-source \-i.hg \-b mypack ..
pbuilder \-\-build \-\-configfile ~/etc/sid\-pbuilderrc ../mypack_1.0\-2.dsc
.fi

.SH AUTHOR

Jens Peter Secher <jpsecher@gmail.com>

.SH THANKS

The ideas for this package originates from John Goerzen's
\fBhg\-buildpackage\fR.

.SH SEE ALSO

\fBdpkg\-source\fR(1),
\fBpbuilder\fR(1),
\fB{ImportOrig}\fR(1),
\fB{ImportDsc}\fR(1),
\fB{TagVersion}\fR(1),
\fB{PristineTar}\fR(1),
\fB{Port}\fR(1).
