# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_buffer_object import OpenGLBufferObject


class OpenGLIndexBufferObject(OpenGLBufferObject):
    r"""
    OpenGLIndexBufferObject - open_gl vertex buffer object
    
    Superclass: OpenGLBufferObject
    
    open_gl buffer object to store geometry and/or attribute data on the
    GPU.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLIndexBufferObject, obj, update, **traits)
    
    def append_edge_flag_index_buffer(self, *args):
        """
        append_edge_flag_index_buffer(indexArray:[int, ...],
            cells:CellArray, vertexOffset:int, edgeflags:DataArray)
            -> None
        C++: static void append_edge_flag_index_buffer(
            std::vector<unsigned int> &indexArray, CellArray *cells,
            IdType vertexOffset, DataArray *edgeflags)
        special index buffer for polys wireframe with edge
        visibilityflags
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'vtkCellArray', 'int', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.AppendEdgeFlagIndexBuffer, *my_args)
        return ret

    def append_line_index_buffer(self, *args):
        """
        append_line_index_buffer(indexArray:[int, ...], cells:CellArray,
            vertexOffset:int) -> None
        C++: static void append_line_index_buffer(
            std::vector<unsigned int> &indexArray, CellArray *cells,
            IdType vertexOffset)
        used to create an IBO for line primitives
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'vtkCellArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.AppendLineIndexBuffer, *my_args)
        return ret

    def append_point_index_buffer(self, *args):
        """
        append_point_index_buffer(indexArray:[int, ...], cells:CellArray,
            vertexOffset:int) -> None
        C++: static void append_point_index_buffer(
            std::vector<unsigned int> &indexArray, CellArray *cells,
            IdType vertexOffset)
        used to create an IBO for primitives as points
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'vtkCellArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.AppendPointIndexBuffer, *my_args)
        return ret

    def append_strip_index_buffer(self, *args):
        """
        append_strip_index_buffer(indexArray:[int, ...], cells:CellArray,
            vertexOffset:int, wireframeTriStrips:bool) -> None
        C++: static void append_strip_index_buffer(
            std::vector<unsigned int> &indexArray, CellArray *cells,
            IdType vertexOffset, bool wireframeTriStrips)"""
        my_args = deref_array(args, [(['int', Ellipsis], 'vtkCellArray', 'int', 'bool')])
        ret = self._wrap_call(self._vtk_obj.AppendStripIndexBuffer, *my_args)
        return ret

    def append_triangle_line_index_buffer(self, *args):
        """
        append_triangle_line_index_buffer(indexArray:[int, ...],
            cells:CellArray, vertexOffset:int) -> None
        C++: static void append_triangle_line_index_buffer(
            std::vector<unsigned int> &indexArray, CellArray *cells,
            IdType vertexOffset)
        create a IBO for wireframe polys/tris
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'vtkCellArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.AppendTriangleLineIndexBuffer, *my_args)
        return ret

    def create_edge_flag_index_buffer(self, *args):
        """
        create_edge_flag_index_buffer(self, cells:CellArray,
            edgeflags:DataArray) -> int
        C++: size_t create_edge_flag_index_buffer(CellArray *cells,
            DataArray *edgeflags)"""
        my_args = deref_array(args, [('vtkCellArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.CreateEdgeFlagIndexBuffer, *my_args)
        return ret

    def create_line_index_buffer(self, *args):
        """
        create_line_index_buffer(self, cells:CellArray) -> int
        C++: size_t create_line_index_buffer(CellArray *cells)
        create a IBO for wireframe polys/tris
        """
        my_args = deref_array(args, [['vtkCellArray']])
        ret = self._wrap_call(self._vtk_obj.CreateLineIndexBuffer, *my_args)
        return ret

    def create_point_index_buffer(self, *args):
        """
        create_point_index_buffer(self, cells:CellArray) -> int
        C++: size_t create_point_index_buffer(CellArray *cells)
        used to create an IBO for primitives as points
        """
        my_args = deref_array(args, [['vtkCellArray']])
        ret = self._wrap_call(self._vtk_obj.CreatePointIndexBuffer, *my_args)
        return ret

    def create_strip_index_buffer(self, *args):
        """
        create_strip_index_buffer(self, cells:CellArray,
            wireframeTriStrips:bool) -> int
        C++: size_t create_strip_index_buffer(CellArray *cells,
            bool wireframeTriStrips)
        used to create an IBO for line strips and triangle strips
        """
        my_args = deref_array(args, [('vtkCellArray', 'bool')])
        ret = self._wrap_call(self._vtk_obj.CreateStripIndexBuffer, *my_args)
        return ret

    def create_triangle_line_index_buffer(self, *args):
        """
        create_triangle_line_index_buffer(self, cells:CellArray) -> int
        C++: size_t create_triangle_line_index_buffer(CellArray *cells)
        create a IBO for wireframe polys/tris
        """
        my_args = deref_array(args, [['vtkCellArray']])
        ret = self._wrap_call(self._vtk_obj.CreateTriangleLineIndexBuffer, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLIndexBufferObject, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLIndexBufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLIndexBufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLIndexBufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

