# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_widget import AbstractWidget


class MagnifierWidget(AbstractWidget):
    r"""
    MagnifierWidget - create a moving, magnifying renderer that can
    inspect the contents
             of an encapsulating renderer.
    
    Superclass: AbstractWidget
    
    This class provides a small, interactive, overlayed viewport (i.e.,
    renderer) that follows the mouse while inside another, larger
    renderer. Inside this viewport effects like magnification (via zoom
    or adjustment of the view angle), or other rendering effects are
    possible.
    
    To use this widget, pair it with a representation (which provides
    options like a border and so on). In the representation, indicate
    what renderer with which the magnifier is associated. Optionally, a
    list of actors can be provided to the magnifier so that it only
    renders the actors specified (this is useful for removing objects
    like widgets from the scene, or creating separate pipelines for
    creating special effects).
    
    By default, the magnifier responds to the keypress "m" to toggle
    between showing/hiding the magnifier. Internally, it also follows
    mouse move events to track the magnifier with the mouse motion.
    Finally, using the "-" or "+" keys can be used to decrease/increase
    the magnification factor by observing the
    "Command::widget_value_changed_event".
    
    @sa
    MagnifierRepresentation
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMagnifierWidget, obj, update, **traits)
    
    key_press_decrease_value = traits.String('-', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _key_press_decrease_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetKeyPressDecreaseValue,
                        self.key_press_decrease_value)

    key_press_increase_value = traits.String('+', enter_set=True, auto_set=False, desc=\
        r"""
        By default, the keypress "+" increases magnification, and the
        keypress "-" decreases magnification. These can be changed to
        other key press values. Note that in either case, these
        keypresses cause the widget to emit the
        "Command::widget_value_changed_event".
        """
    )

    def _key_press_increase_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetKeyPressIncreaseValue,
                        self.key_press_increase_value)

    def _get_representation(self):
        return wrap_vtk(self._vtk_obj.GetRepresentation())
    def _set_representation(self, arg):
        old_val = self._get_representation()
        self._wrap_call(self._vtk_obj.SetRepresentation,
                        deref_vtk(arg))
        self.trait_property_changed('representation', old_val, arg)
    representation = traits.Property(_get_representation, _set_representation, desc=\
        r"""
        Return an instance of WidgetRepresentation used to represent
        this widget in the scene. Note that the representation is a
        subclass of Prop (typically a subclass of
        WidgetRepresentation) so it can be added to the renderer
        independent of the widget.
        """
    )

    def _get_magnifier_representation(self):
        return wrap_vtk(self._vtk_obj.GetMagnifierRepresentation())
    magnifier_representation = traits.Property(_get_magnifier_representation, desc=\
        r"""
        Return the representation as a BorderRepresentation.
        """
    )

    _updateable_traits_ = \
    (('manages_cursor', 'GetManagesCursor'), ('process_events',
    'GetProcessEvents'), ('enabled', 'GetEnabled'),
    ('key_press_activation', 'GetKeyPressActivation'), ('picking_managed',
    'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('key_press_decrease_value', 'GetKeyPressDecreaseValue'),
    ('key_press_increase_value', 'GetKeyPressIncreaseValue'), ('priority',
    'GetPriority'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'enabled', 'global_warning_display',
    'key_press_activation', 'manages_cursor', 'picking_managed',
    'process_events', 'key_press_activation_value',
    'key_press_decrease_value', 'key_press_increase_value', 'priority'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MagnifierWidget, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MagnifierWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enabled', 'key_press_activation', 'manages_cursor',
            'picking_managed', 'process_events'], [],
            ['key_press_activation_value', 'key_press_decrease_value',
            'key_press_increase_value', 'priority']),
            title='Edit MagnifierWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MagnifierWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

