# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class GenericVertexAttributeMapping(Object):
    r"""
    GenericVertexAttributeMapping - stores mapping for data arrays to
    generic vertex attributes.
    
    Superclass: Object
    
    GenericVertexAttributeMapping stores mapping between data arrays
    and generic vertex attributes. It is used by PainterPolyDataMapper
    to pass the mappings to the painter which rendering the
    attributes.@par Thanks: Support for generic vertex attributes in VTK
    was contributed in collaboration with Stephane Ploix at EDF.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenericVertexAttributeMapping, obj, update, **traits)
    
    def get_array_name(self, *args):
        """
        get_array_name(self, index:int) -> str
        C++: const char *get_array_name(unsigned int index)
        Get the array name at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetArrayName, *args)
        return ret

    def get_attribute_name(self, *args):
        """
        get_attribute_name(self, index:int) -> str
        C++: const char *get_attribute_name(unsigned int index)
        Get the attribute name at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetAttributeName, *args)
        return ret

    def get_component(self, *args):
        """
        get_component(self, index:int) -> int
        C++: int get_component(unsigned int index)
        Get the component no. at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetComponent, *args)
        return ret

    def get_field_association(self, *args):
        """
        get_field_association(self, index:int) -> int
        C++: int get_field_association(unsigned int index)
        Get the field association at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetFieldAssociation, *args)
        return ret

    def _get_number_of_mappings(self):
        return self._vtk_obj.GetNumberOfMappings()
    number_of_mappings = traits.Property(_get_number_of_mappings, desc=\
        r"""
        Get number of mappings.
        """
    )

    def get_texture_unit(self, *args):
        """
        get_texture_unit(self, index:int) -> int
        C++: int get_texture_unit(unsigned int index)
        Get the component no. at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetTextureUnit, *args)
        return ret

    def add_mapping(self, *args):
        """
        add_mapping(self, attributeName:str, arrayName:str,
            fieldAssociation:int, component:int) -> None
        C++: void add_mapping(const char *attributeName,
            const char *arrayName, int fieldAssociation, int component)
        add_mapping(self, unit:int, arrayName:str, fieldAssociation:int,
            component:int) -> None
        C++: void add_mapping(int unit, const char *arrayName,
            int fieldAssociation, int component)
        Select a data array from the point/cell data and map it to a
        generic vertex attribute. Note that indices change when a mapping
        is added/removed.
        """
        ret = self._wrap_call(self._vtk_obj.AddMapping, *args)
        return ret

    def remove_all_mappings(self):
        """
        remove_all_mappings(self) -> None
        C++: void remove_all_mappings()
        Remove all mappings.
        """
        ret = self._vtk_obj.RemoveAllMappings()
        return ret
        

    def remove_mapping(self, *args):
        """
        remove_mapping(self, attributeName:str) -> bool
        C++: bool remove_mapping(const char *attributeName)
        Remove a vertex attribute mapping.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveMapping, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenericVertexAttributeMapping, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenericVertexAttributeMapping properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit GenericVertexAttributeMapping properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenericVertexAttributeMapping properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

