// Value base class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "allValues.h"
#include "UnionType.h"

/** @file Value.C
 * Abstract base class for values
 */

/* Copyright  1999-2001 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

bool
Value::operator< (const class Value& other) const
{
  assert (other.getKind () == getKind ());
  switch (getKind ()) {
  case vLeaf:
    return static_cast<const class LeafValue&>(*this) <
      static_cast<const class LeafValue&>(other);
  case vStruct:
    return static_cast<const class StructValue&>(*this) <
      static_cast<const class StructValue&>(other);
  case vUnion:
    return static_cast<const class UnionValue&>(*this) <
      static_cast<const class UnionValue&>(other);
  case vVector:
    return static_cast<const class VectorValue&>(*this) <
      static_cast<const class VectorValue&>(other);
  case vBuffer:
    return static_cast<const class BufferValue&>(*this) <
      static_cast<const class BufferValue&>(other);
  }
  assert (false);
  return false;
}

bool
Value::operator== (const class Value& other) const
{
  assert (other.getKind () == getKind ());
  switch (getKind ()) {
  case vLeaf:
    return static_cast<const class LeafValue&>(*this) ==
      static_cast<const class LeafValue&>(other);
  case vStruct:
    return static_cast<const class StructValue&>(*this) ==
      static_cast<const class StructValue&>(other);
  case vUnion:
    return static_cast<const class UnionValue&>(*this) ==
      static_cast<const class UnionValue&>(other);
  case vVector:
    return static_cast<const class VectorValue&>(*this) ==
      static_cast<const class VectorValue&>(other);
  case vBuffer:
    return static_cast<const class BufferValue&>(*this) ==
      static_cast<const class BufferValue&>(other);
  }
  assert (false);
  return false;
}

card_t
Value::operator- (const class Value& other) const
{
  assert (other.getKind () == getKind ());
  assert (!(*this < other));
  switch (getKind ()) {
  case vLeaf:
    return static_cast<const class LeafValue&>(*this) -
      static_cast<const class LeafValue&>(other);
  case vStruct:
    return static_cast<const class StructValue&>(*this) -
      static_cast<const class StructValue&>(other);
  case vUnion:
    return static_cast<const class UnionValue&>(*this) -
      static_cast<const class UnionValue&>(other);
  case vVector:
    return static_cast<const class VectorValue&>(*this) -
      static_cast<const class VectorValue&>(other);
  case vBuffer:
    return static_cast<const class BufferValue&>(*this) -
      static_cast<const class BufferValue&>(other);
  }
  assert (false);
  return 0;
}

class Value*
Value::cast (const class Type& type)
{
  if (type.getKind () == Type::tUnion)
    return static_cast<const class UnionType&>(type).cast (*this);

  if (getKind () != vLeaf ||
      (type.getKind () == myType->getKind () ||
       int_t (static_cast<class LeafValue&>(*this)) >= 0 ||
       myType->getKind () != Type::tInt ||
       type.getKind () == Type::tInt)) {
    setType (type);
    if (type.isConstrained (*this))
      return this;
  }

  delete this;
  return 0;
}
