
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileWrepJSonAttributes.h
    \brief Definition of WrepJSon Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef WrepJSonAttributes_H
#define WrepJSonAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class WrepJSonAttributes 
{
public:
//  --  constructor
    WrepJSonAttributes();
    
//  --  destructor
    virtual ~WrepJSonAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const WrepJSonAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string path_;
	string param_info_;
	bool title_;
	bool position_info_;
	string product_info_;
	string family_;
	string key_;
	double plumes_;
	bool information_;
	string keyword_;
	string station_name_;
	string param_;
	double param_scaling_factor_;
	double param_offset_factor_;
	string clim_param_;
	int clim_step_;
	intarray steps_;
	double percentile_;
	double threshold_;
	double y_max_threshold_;
	double y_percent_;
	bool correction_;
	double missing_value_;
	stringarray ignore_keys_;
	string profile_quantile_;
	bool hodograph_grid_;
	bool hodograph_tephi_;
	int hodograph_member_;
	 

private:
	friend ostream& operator<<(ostream& s,const WrepJSonAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

