-- examples of factorisations with factorWA
R1=makeWA(QQ[x_1])
-- the hs are ex from the paper ``Factoring linear partial differential operators in n variables''
h_0=(x_1^4-1)*x_1*dx_1^2+(1+7*x_1^4)*dx_1+8*x_1^3 -- "h" in the paper. 5 facs
p_0=dx_1*(x_1^2+1)
p_4=(x_1^4+1)*(1+31*dx_1) -- irreducible over QQ! shouldn't factor it
p_5=(x_1^2+5*x_1+1)*(x_1^2+3*x_1+1)*(1+13*dx_1) -- degree>1 solution
p_6=(dx_1+11)*(1-x_1^2) -- should give unique fac despite constant (here, sign) issues
A=(1+x_1)*(2+dx_1);
p_12=A*(A-1)*(A-2); -- 11 facs, would be a lot less if we allowed commutation of *arbitrary* factors, not just irreducible ones.
-- more importantly, shows that the commutative algebra approach won't give all factorisations, can only work with StopAfter<infinity
p_13=A^2*(A-3)^2; -- takes forever with StopAfter=>infinity
u:=dx_1^3+x_1^2-8; v:=1/2*dx_1; U=u^2+4*v; V=u^3+3*(u*v+v*u);  -- Makar-Limanov example. V^2=U^3+8
p_14=U*V; -- takes forever with StopAfter=>infinity
p_15=(U+1)*(U*V-1); -- takes forever with StopAfter=>infinity
-- other, trickier ones: U^2, V^2
-- my RL examples:
l={x_1^2*dx_1^14-38*x_1^2*dx_1^13+541*x_1^2*dx_1^12+36*x_1*dx_1^13-3056*x_1^2*dx_1^11-1262*x_1*dx_1^12-1670*x_1^2*dx_1^10+16426*x_1*dx_1^11+306*dx_1^12+82684*x_1^2*dx_1^9-83404*x_1*dx_1^10-9886*dx_1^11-132318*x_1^2*dx_1^8-53512*x_1*dx_1^9+117414*dx_1^10-1060344*x_1^2*dx_1^7+1868604*x_1*dx_1^8-533480*dx_1^9+1610973*x_1^2*dx_1^6-2398308*x_1*dx_1^7-392388*dx_1^8+9644474*x_1^2*dx_1^5-18732144*x_1*dx_1^6+9825804*dx_1^7-881167*x_1^2*dx_1^4+21153468*x_1*dx_1^5-9535908*dx_1^6-46656232*x_1^2*dx_1^3+118955634*x_1*dx_1^4-76099656*dx_1^5-78118936*x_1^2*dx_1^2+7849898*x_1*dx_1^3+54718650*dx_1^4-52706752*x_1^2*dx_1-312216436*x_1*dx_1^2+322264866*dx_1^3-13176688*x_1^2-359131976*x_1*dx_1+103224478*dx_1^2-122354960*x_1-300797280*dx_1-193482184, x_1^3*dx_1^13-39*x_1^3*dx_1^12+4*x_1^2*dx_1^13+580*x_1^3*dx_1^11-123*x_1^2*dx_1^12-3636*x_1^3*dx_1^10+1142*x_1^2*dx_1^11+136*x_1*dx_1^12+1966*x_1^3*dx_1^9+1320*x_1^2*dx_1^10-4632*x_1*dx_1^11+80718*x_1^3*dx_1^8-80496*x_1^2*dx_1^9+58166*x_1*dx_1^10+1088*dx_1^11-213036*x_1^3*dx_1^7+351822*x_1^2*dx_1^8-277008*x_1*dx_1^9-36000*dx_1^10-847308*x_1^3*dx_1^6+745356*x_1^2*dx_1^7-309528*x_1*dx_1^8+447490*dx_1^9+2458281*x_1^3*dx_1^5-6745932*x_1^2*dx_1^6+6687912*x_1*dx_1^7-2304402*dx_1^8+7186193*x_1^3*dx_1^4-3000396*x_1^2*dx_1^5-7946052*x_1*dx_1^6+1044378*dx_1^7-8067360*x_1^3*dx_1^3+55356917*x_1^2*dx_1^4-63026568*x_1*dx_1^5+31570926*dx_1^6-38588872*x_1^3*dx_1^2+38515470*x_1^2*dx_1^3+77541576*x_1*dx_1^4-61768506*dx_1^5-39530064*x_1^3*dx_1-193088420*x_1^2*dx_1^2+342285776*x_1*dx_1^3-179603550*dx_1^4-13176688*x_1^3-315837144*x_1^2*dx_1-65652258*x_1*dx_1^2+320936574*dx_1^3-135531648*x_1^2-693812168*x_1*dx_1+625837114*dx_1^2-411838728*x_1-147286944*dx_1-362090008, 9*x_1^4*dx_1^12-369*x_1^4*dx_1^11-81*x_1^3*dx_1^12-764*x_1^2*dx_1^13+5958*x_1^4*dx_1^10+3582*x_1^3*dx_1^11+30092*x_1^2*dx_1^12-44640*x_1^4*dx_1^9-63270*x_1^3*dx_1^10-457650*x_1^2*dx_1^11-25976*x_1*dx_1^12+106974*x_1^4*dx_1^8+540000*x_1^3*dx_1^9+3064036*x_1^2*dx_1^10+940024*x_1*dx_1^11+512514*x_1^4*dx_1^7-1855926*x_1^3*dx_1^8-4293328*x_1^2*dx_1^9-12962476*x_1*dx_1^10-207808*dx_1^11-2942352*x_1^4*dx_1^6-2993652*x_1^3*dx_1^7-49278960*x_1^2*dx_1^8+76388114*x_1*dx_1^9+6901200*dx_1^10-1741068*x_1^4*dx_1^5+35570664*x_1^3*dx_1^6+161267724*x_1^2*dx_1^7-66869058*x_1*dx_1^8-86332220*dx_1^9+25606665*x_1^4*dx_1^4-20950272*x_1^3*dx_1^5+469532880*x_1^2*dx_1^6-1179842262*x_1*dx_1^7+451498716*dx_1^8+13462407*x_1^4*dx_1^3-265757625*x_1^3*dx_1^4-1558801548*x_1^2*dx_1^5+3096370086*x_1*dx_1^6-266728908*dx_1^7-99531054*x_1^4*dx_1^2+86516262*x_1^3*dx_1^3-4404117004*x_1^2*dx_1^4+8393378502*x_1*dx_1^5-5915806404*dx_1^6-148237740*x_1^4*dx_1+1063638198*x_1^3*dx_1^2+4499833366*x_1^2*dx_1^3-23012211558*x_1*dx_1^4+12326878092*dx_1^5-59295096*x_1^4+1047950064*x_1^3*dx_1+24960407724*x_1^2*dx_1^2-46738243594*x_1*dx_1^3+32319917700*dx_1^4+279534024*x_1^3+28571611880*x_1^2*dx_1+41320491758*x_1*dx_1^2-62419057092*dx_1^3+10689520912*x_1^2+119285406352*x_1*dx_1-112183579004*dx_1^2+58513234360*x_1+30960222720*dx_1+65835842576, 1492992*x_1^7*dx_1^11-50761728*x_1^7*dx_1^10+7464960*x_1^6*dx_1^11+633028608*x_1^7*dx_1^9-220962816*x_1^6*dx_1^10+18019584*x_1^5*dx_1^11-2974040064*x_1^7*dx_1^8+2149908480*x_1^6*dx_1^9-448436736*x_1^5*dx_1^10+32633856*x_1^4*dx_1^11+459044952*x_1^3*dx_1^12+4738995139*x_1^2*dx_1^13-3072577536*x_1^7*dx_1^7-3475685376*x_1^6*dx_1^8+2668640256*x_1^5*dx_1^9-761020416*x_1^4*dx_1^10-18759281664*x_1^3*dx_1^11-187175841597*x_1^2*dx_1^12+63511879680*x_1^7*dx_1^6-62947528704*x_1^6*dx_1^7+17963182080*x_1^5*dx_1^8+3775523328*x_1^4*dx_1^9+302240069472*x_1^3*dx_1^10+2858603072796*x_1^2*dx_1^11+161125834726*x_1*dx_1^12-43517730816*x_1^7*dx_1^5+274543312896*x_1^6*dx_1^6-241878016512*x_1^5*dx_1^7+34988613120*x_1^4*dx_1^8-2263075967040*x_1^3*dx_1^9-19285496328572*x_1^2*dx_1^10-5847457076934*x_1*dx_1^11-593446404096*x_1^7*dx_1^4+544553902080*x_1^6*dx_1^5+426960129024*x_1^5*dx_1^6-355245848064*x_1^4*dx_1^7+5447881445904*x_1^3*dx_1^8+28080085156650*x_1^2*dx_1^9+81016009335836*x_1*dx_1^10+1289006677808*dx_1^11+93713614848*x_1^7*dx_1^3-3402409328640*x_1^6*dx_1^4+3116569789440*x_1^5*dx_1^5+177916055040*x_1^4*dx_1^6+25737397791552*x_1^3*dx_1^7+308952241579098*x_1^2*dx_1^8-482560560969752*x_1*dx_1^9-42931824024900*dx_1^10+2889247076352*x_1^7*dx_1^2-4279003158528*x_1^6*dx_1^3-7513197576192*x_1^5*dx_1^4+5621071154688*x_1^4*dx_1^5-148782083764320*x_1^3*dx_1^6-1062443135708676*x_1^2*dx_1^7+471134764064876*x_1*dx_1^8+539767189042810*dx_1^9+3713722048512*x_1^7*dx_1+15008517070848*x_1^6*dx_1^2-22415260896000*x_1^5*dx_1^3-5558902304256*x_1^4*dx_1^4-86446131708096*x_1^3*dx_1^5-2774665124198820*x_1^2*dx_1^6+7216345506856628*x_1*dx_1^7-2856746878013338*dx_1^8+1405192126464*x_1^7+30125598547968*x_1^6*dx_1+28613790825984*x_1^5*dx_1^2-41871120238080*x_1^4*dx_1^3+1296882745242840*x_1^3*dx_1^4+10234646666917083*x_1^2*dx_1^5-19787230210618744*x_1*dx_1^6+1987107955738338*dx_1^7+14453404729344*x_1^6+93774867250176*x_1^5*dx_1+6875092965888*x_1^4*dx_1^2+682984943562432*x_1^3*dx_1^3+25491014527222475*x_1^2*dx_1^4-49671863784092080*x_1*dx_1^5+36129410931753358*dx_1^6+52691916662784*x_1^5+118558792912896*x_1^4*dx_1-5081048512516032*x_1^3*dx_1^2-31056497630110512*x_1^2*dx_1^3+144853059477715694*x_1*dx_1^4-79077432704220610*dx_1^5+80428971829248*x_1^4-7637776459993344*x_1^3*dx_1-148073678767841400*x_1^2*dx_1^2+275702978123931778*x_1*dx_1^3-190656682008507750*dx_1^4-3090584815118976*x_1^3-163560033575410864*x_1^2*dx_1-265561180783923220*x_1*dx_1^2+392704478479664806*dx_1^3-60345534451679568*x_1^2-714815358414141096*x_1*dx_1+659472804357356094*dx_1^2-342113266967900624*x_1-206021914401892848*dx_1-391912559053553160};
-- for example l#0 is
-- (dx_1-7)^6*(dx_1+1)^2*(dx_1+2)^3 -- silly prefactor times the thing we care about
-- *(-56*x_1 - 14*x_1^2 + 42*dx_1 - 18*x_1*dx_1 - 19*x_1^2*dx_1 + 14*x_1*dx_1^2 - 4*x_1^2*dx_1^2 + x_1^2*dx_1^3)

R2=makeWA(QQ[x_1,x_2])
h_1=(dx_1+1)^2*(dx_1+x_1*dx_2) -- 2 factorisations
scan(1..2,i->th_i=x_i*dx_i)
h_2=(th_1*dx_2+(th_1+3)*th_2+x_2)*((th_1+4)*x_1*dx_2+x_1+(th_1+1)*x_1*x_2) -- 3 factorisations because of monomial moving around
h_4=(x_1^2*dx_1+x_1*x_2*dx_2)*(dx_1*dx_2+dx_1^2*dx_2^2*x_1*x_2) -- same remark as h3
p_1=(x_1*dx_1+2*x_2)*(x_2*dx_2+3*x_1) -- sharing constants right, factorisation should be unique
p_2=(x_1*dx_1+x_2+dx_2)^3 -- example with non radical ideal of eqs
p_3=(x_1*dx_2+x_2*dx_1)*(3+x_1*dx_1)*(4+x_2*dx_2) -- should give unique fac
p_7=(11+3*x_1*dx_1+5*x_2*dx_2)*(1+31*x_1) -- tests edge case
p_8=x_1^5*dx_1+x_1^5-(307/84)*x_1^4*dx_1-(307/84)*x_1^4+(863/168)*x_1^3*dx_1+(863/168)*x_1^3-(24/7)*x_1^2*dx_1-(24/7)*x_1^2+(179/168)*x_1*dx_1+(179/168)*x_1-(5/42)*dx_1-5/42 -- one variable. 2 factorisations
p_9=x_1^4*(1+2*x_2*dx_1+3*x_1*dx_2)*dx_2^4 -- 1 fac. how to guess that here, monomials can be taken out w/o losing any factorisations?
p_10=3/5*(x_1*dx_1)^2*(x_2/13+1+7/31*dx_2)^2 -- this one is greatly improved by optimisation. 6 facs
p_11=(1+3*x_1+4*dx_2)^2*(1+5*x_2+3*dx_1)^2 -- 3 facs. didn't finish with earlier versions of the algo

R3=makeWA(QQ[x_1..x_3])
h_3=x_1*x_2^2*x_3^3*dx_1*dx_2^2+x_2*x_3^3*dx_2 -- homogeneous -- 60 factorisations but really all of them are identical up to permutation of commuting parts

tstall = () -> apply(apply(5,i->h_i) | apply(13,i->p_i),a->timing tst a) -- last should be {5, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 6, 3, 11}

-- random examples for benchmarking
(frame random)#0=(frame random)#0 ++ {Height=>100};
R2c=QQ[a_1..a_2,b_1..b_2]
f=map(R2,R2c,gens R2)
rnd=k->f sum(0..k,i->random(i,R2c)) -- really bad for this algo: unique lowest/highest degree terms
tot=10;
-- examples where algo should be better: lots of terms of same degree
use R2
rnd1=()->random QQ + random QQ * x_1 * dx_1 + random QQ * x_2 * dx_2 + random QQ * x_1 + random QQ * x_2
rnd2=()->random QQ + random QQ * x_1 * dx_1 + random QQ * x_2 * dx_2 + random QQ * x_1 + random QQ * x_2 + random QQ * x_1^2 + random QQ * x_2^2 + random QQ * x_1 * x_2
bnch = () -> (
    timing(for i from 1 to tot do tst (rnd 1*rnd 2)), -- anything beyond rnd 1*rnd 2 is too complicated
    timing(for i from 1 to tot do tst (rnd1()*rnd1()*rnd1())),
    timing(for i from 1 to tot do tst (dx_1*rnd2()*rnd2()))
    )




