#
# @file    TestRateRule.py
# @brief   RateRule unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestRateRule.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestRateRule(unittest.TestCase):

  global RR
  RR = None

  def setUp(self):
    self.RR = libsbml.RateRule(1,2)
    if (self.RR == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.RR ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_RateRule_create(self):
    self.assertTrue( self.RR.getTypeCode() == libsbml.SBML_RATE_RULE )
    self.assertTrue( self.RR.getMetaId() == "" )
    self.assertTrue( self.RR.getNotes() == None )
    self.assertTrue( self.RR.getAnnotation() == None )
    self.assertTrue( self.RR.getFormula() == "" )
    self.assertTrue( self.RR.getMath() == None )
    self.assertTrue( self.RR.getVariable() == "" )
    self.assertTrue( self.RR.getType() == libsbml.RULE_TYPE_RATE )
    pass  

  def test_RateRule_createWithNS(self):
    xmlns = libsbml.XMLNamespaces()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = libsbml.SBMLNamespaces(2,1)
    sbmlns.addNamespaces(xmlns)
    object = libsbml.RateRule(sbmlns)
    self.assertTrue( object.getTypeCode() == libsbml.SBML_RATE_RULE )
    self.assertTrue( object.getMetaId() == "" )
    self.assertTrue( object.getNotes() == None )
    self.assertTrue( object.getAnnotation() == None )
    self.assertTrue( object.getLevel() == 2 )
    self.assertTrue( object.getVersion() == 1 )
    self.assertTrue( object.getNamespaces() != None )
    self.assertTrue( object.getNamespaces().getLength() == 2 )
    _dummyList = [ object ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_RateRule_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_RateRule_setVariable(self):
    variable =  "x";
    self.RR.setVariable(variable)
    self.assertTrue(( variable == self.RR.getVariable() ))
    self.assertEqual( True, self.RR.isSetVariable() )
    if (self.RR.getVariable() == variable):
      pass    
    self.RR.setVariable(self.RR.getVariable())
    self.assertTrue(( variable == self.RR.getVariable() ))
    self.RR.setVariable("")
    self.assertEqual( False, self.RR.isSetVariable() )
    if (self.RR.getVariable() != None):
      pass    
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestRateRule))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
