#ifndef RND_MBTK_COMMON_H
#define RND_MBTK_COMMON_H

#include <libmbtk/libmbtk.h>
#include <libmbtk/backend.h>
#include <libmbtk/display.h>
#include <librnd/core/rnd_bool.h>
#include <librnd/core/hidlib.h>
#include <librnd/hid/hid_cfg_input.h>
#include <libmbtk/widget/canvas_native.h>


typedef struct rnd_mbtk_view_s {
	double coord_per_px;     /* Zoom level described as PCB units per screen pixel */

	rnd_coord_t x0, y0, width, height;

	unsigned inhibit_pan_common:1; /* when 1, do not call rnd_gtk_pan_common() */
	unsigned use_max_hidlib:1;     /* when 1, use hidlib->size_*; when 0, use the following two: */
	unsigned local_flip:1;   /* ignore hidlib's flip and use the local one */
	unsigned flip_x:1, flip_y:1; /* local version of flips when ->local_flip is enabled */
	rnd_coord_t max_width;
	rnd_coord_t max_height;

	int canvas_width, canvas_height;

	rnd_bool has_entered;
	rnd_bool panning;
	rnd_coord_t design_x, design_y;        /* design space coordinates of the mouse pointer */
	rnd_coord_t crosshair_x, crosshair_y;  /* design_space coordinates of the crosshair     */

	struct rnd_mbtk_s *ctx;

	unsigned local_hidlib:1; /* if 1, use local hidlib instead of current GUI hidlib (for local dialogs) */
	rnd_design_t *hidlib;    /* remember the hidlib the dialog was opened for */
} rnd_mbtk_view_t;

typedef struct rnd_mbtk_topwin_s rnd_mbtk_topwin_t; /* opaque so that libmbtk/widgets.h doesn't need to be included here */

/* Global context for an active HID */
typedef struct rnd_mbtk_s rnd_mbtk_t;
struct rnd_mbtk_s {
	mbtk_backend_t be;
	mbtk_display_t disp;
	const char *default_font, *bold_font, *italic_font;
	mbtk_font_id_t bold_fid, italic_fid; /* default_fid is stored in ->disp */

	rnd_bool drawing_allowed;     /* track if a drawing area is available for rendering */
	rnd_mbtk_view_t view;         /* top window's ddrawing area */
	rnd_design_t *hidlib;
	unsigned hid_active:1;
	unsigned gui_is_up:1;
	unsigned pressed_esc:1;
	rnd_mbtk_topwin_t *topwin;

	gdl_list_t dad_dialogs; /* all open DAD dialogs */

	unsigned command_entry_status_line_active:1;

	/* mouse click in main window drawing */
	unsigned need_xy:1;
	unsigned have_xy:1;
	unsigned block_xy:1;
	unsigned cmd_is_active:1;
	int action_x, action_y;
	int in_move_event;
	rnd_hid_cfg_mouse_t hc_mouse;
	rnd_hid_cfg_keys_t hc_keymap;

	/* HID implementation needs to fill these in: */
	int (*init_backend)(rnd_mbtk_t *mctx, int *argc, char **argv[]);
	int (*main_drawing_area_first_draw_cb)(mbtk_canvas_native_t *c, void *native_ctx, long x_offs, long y_offs, long w, long h);
	int (*main_drawing_area_draw_cb)(mbtk_canvas_native_t *c, void *native_ctx, long x_offs, long y_offs, long w, long h);
	void (*crosshair_set)(rnd_mbtk_t *mctx, rnd_coord_t x, rnd_coord_t y, rnd_set_crosshair_t action);
	void (*crosshair_move_to)(rnd_mbtk_t *mctx, rnd_coord_t x, rnd_coord_t y);
	void (*screen_coords_to_design)(int scx, int scy, rnd_coord_t *xout, rnd_coord_t *yout);
};

#endif
