/*
 *                            COPYRIGHT
 *
 *  pcb-rnd, interactive printed circuit board design
 *  Copyright (C) 2025 Tibor 'Igor2' Palinkas
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 31 Milk Street, # 960789 Boston, MA 02196 USA.
 *
 *  Contact:
 *    Project page: http://www.repo.hu/projects/librnd
 *    lead developer: http://www.repo.hu/projects/librnd/contact.html
 *    mailing list: pcb-rnd (at) list.repo.hu (send "subscribe")
 */

TODO("test with 2d draft, that needs more hooks")

TODO("do we need this?")
#if 0
static void command_pre_entry(void)
{
#if RND_GTK_DISABLE_MOUSE_DURING_CMD_ENTRY
	rnd_gtk_interface_input_signals_disconnect();
#endif
	rnd_gtk_interface_set_sensitive(FALSE);
}

static void command_post_entry(void)
{
#if RND_GTK_DISABLE_MOUSE_DURING_CMD_ENTRY
	rnd_gtk_interface_input_signals_connect();
#endif
	rnd_gtk_interface_set_sensitive(TRUE);
	gtk_widget_grab_focus(ghidgui->port.drawing_area);
}
#endif

void rnd_mbtk_topwin_show_status(rnd_mbtk_t *mctx, int show)
{
	mbtk_widget_t *st = &mctx->topwin->dockbox[RND_HID_DOCK_BOTTOM].w;

	if (show)
		mbtk_widget_show(st, 0);
	else
		mbtk_widget_hide(st, 0);
}

static mbtk_event_handled_t cmd_enter_cb(mbtk_widget_t *w, mbtk_kw_t id, void *user_data)
{
	rnd_mbtk_t *mctx = user_data;

	rnd_trace("cmd enter!\n");

	mctx->topwin->cmd_finished = 1;
	mctx->topwin->cmd_entered = mbtk_combo_get_str(&mctx->topwin->cmd);
	return MBTK_EVENT_HANDLED;
}

static mbtk_event_handled_t cmd_esc_cb(mbtk_widget_t *w, mbtk_kw_t id, void *user_data)
{
	rnd_mbtk_t *mctx = user_data;

	rnd_trace("cmd ESC!\n");

	mctx->topwin->cmd_finished = 1;
	return MBTK_EVENT_HANDLED;
}

/* This is the command entry function called from Action Command().
   The command_combo_box is packed into the status line label hbox. */
static const char *rnd_mbtk_command_entry_get(rnd_mbtk_t *mctx, const char *prompt, const char *command)
{
	mbtk_widget_t *last_focus = mctx->topwin->win->focus;

	/* Flag so output drawing area won't try to get focus away from us and
	   so resetting the status line label can be blocked when resize
	   callbacks are invokded from the resize caused by showing the combo box. */
	mctx->command_entry_status_line_active = 1;

	mbtk_combo_set_val_str(&mctx->topwin->cmd, command ? command : "");

	if (rnd_conf.editor.fullscreen)
		mbtk_widget_show(&mctx->topwin->bottom_hbox.w, 0);

	mbtk_widget_show(&mctx->topwin->cmd_prompt.w, 0);
	mbtk_widget_show(&mctx->topwin->cmd.w, 0);
	rnd_mbtk_topwin_show_status(mctx, 0);

	mbtk_combo_set_focus_enter(&mctx->topwin->cmd);

TODO("implement these:");
/*
	escape_sig_id = gtkc_bind_key_press(ctx->command_entry,  rnd_gtkc_xy_ev(&ctx->kpress, command_key_press_cb, ctx));
	escape_sig2_id = gtkc_bind_key_release(ctx->command_entry, rnd_gtkc_xy_ev(&ctx->krelease, command_key_release_cb, ctx));
*/


	mbtk_combo_callback_keypress_enter(&mctx->topwin->cmd, cmd_enter_cb, mctx);
	mbtk_combo_callback_keypress_esc(&mctx->topwin->cmd, cmd_esc_cb, mctx);

rnd_trace("cmd loop enter\n");
	mctx->topwin->cmd_finished = 0;
	mctx->topwin->cmd_entered = NULL;
	while (!mctx->topwin->cmd_finished) {
		mbtk_event_t dst;
		mbtk_iterate(&mctx->disp, &dst, 1);
	}
rnd_trace("cmd loop leave\n");


	mctx->command_entry_status_line_active = 0;

TODO("implement this?");
#if 0
	/* Restore the damage we did before entering the loop. */
	gtkc_unbind_key(ctx->command_entry, escape_sig_id);
	gtkc_unbind_key(ctx->command_entry, escape_sig2_id);
#endif

	/* Hide/show the widgets */
	if (rnd_conf.editor.fullscreen)
		mbtk_widget_hide(&mctx->topwin->bottom_hbox.w, 0);
	rnd_mbtk_topwin_show_status(mctx, 1);

	/* Restore the status line label and give focus back to the drawing area */
	mbtk_widget_hide(&mctx->topwin->cmd_prompt.w, 0);
	mbtk_widget_hide(&mctx->topwin->cmd.w, 0);

	mbtk_window_set_focus(mctx->topwin->win, last_focus, 0);

	return mctx->topwin->cmd_entered;
}


static void rnd_mbtk_open_command(rnd_hid_t *hid)
{
	rnd_mbtk_t *mctx = hid->hid_data;
	const char *command;

	command = rnd_mbtk_command_entry_get(mctx, rnd_cli_prompt(":"), "");
	if (command != NULL) {
		/* copy new command line to save buffer */
		rnd_parse_command(mctx->hidlib, command, rnd_false);
	}
}
