C
C   Copyright (c) 1997 Silvano Bonazzola
C
C    This file is part of LORENE.
C
C    LORENE is free software; you can redistribute it and/or modify
C    it under the terms of the GNU General Public License as published by
C    the Free Software Foundation; either version 2 of the License, or
C    (at your option) any later version.
C
C    LORENE is distributed in the hope that it will be useful,
C    but WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with LORENE; if not, write to the Free Software
C    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
C
C

	SUBROUTINE CEPL3S(NDEG,NDR,NDT,IPAR,ISYG,INV,TRA0,TRA1,DEN)

C
C		TROUVE' UN BUG LE 2 JUIN 94 ET CORRIGE' (SORRY MRS ALLGOOD)
C
C		ROUTINE POUR LA TRANSFORMATION 3-D DE LEGENDRE -> TCHEBYTCHEV
C		ET VICEVERSA DANS LE CAS AVEC UNE SYMETRIE (ANTISYMETRIE)
C		PAR RAPPORT LE PLAN Z=0 ET AVC UNE SUPER SYMETRIE
C
C		ARGUMENTS DE LA ROUTINE:
C
C			NDEG	=TABLEAU CONTENANT LES DEGRES DE LIBERTE
C				 EN R,THETA ET PHI
C			NDR,NDT =DIMENSIONS DES TABLEAUX COMME DECLAREES
C		 		 DANS LE PROGRAMME APPELANT LA ROUTINE.
C			IPAR	=DRAPEAU DEFINISSANT LA SYMETRIE DE LA
C			         FONCTION QUI DIOIT ETRE TRANSFORMEE
C			         IPAR=0 : FONCTION SYMETRIQUE PAR
C			         RAPPORT LE PLAN EQUATORIAL Z=0, IPAR=1
C				 FONCTION ANTISYMETRIQUE
C			ISYG	=DRAPEAU: SI ISYG=0 ON A SEULEMENT
C			         LA SYMETRIE PAR RAPPORT AU PLAN EQUATORIAL
C			         SI ISYG=2 ON A EN PLUS LA SYMETRIE PAR 
C				 RAPPORT A LA TRANSFORMATION X,Y -> -X,-Y
C			INV	=DRAPEAU: SI INV=0 LA TRANSFORMATION
C				 TCHEBYTCHEV -> LEGENDRE EST EFFECTUEE,
C			         SI INV=1 LA ROUTINE EFFECTUE LA TRANSFOR-
C			         MATION LEGENDRE -> TCHEBYTCHEV.
C
C			 TRA0,TRA1=TABLEAUX DE TRAVAIL, DIMENSIONS MINIMES
C				   NDEG(1)*NDEG(2)  
C			 DEN	=TABLEAU INPUT CONTENANT LES COEFFICIENTS
C				 DE TCHEBYTCHEV ET DE FOURIER SELON THETA
C				 ET PHI (2EME ET 3EME INDEX) COMME FONCTIONS
C				 DE R. (1ER INDEX) EN OUTPUT DEN CONTIENT
C				 LES COEFFICIENTS DE LEGENDRE. DIMENSIONS
C			         MINIMES DE DEN=NDEG(1)*NDEG(2)*NDEG(3)
C
C		ROUTINE TESTE LE 20 SEPTEMBRE 1993
C
C				 
C
	IMPLICIT NONE
C
C $Id: cepl3s.f,v 1.2 2012/03/30 12:12:42 j_novak Exp $
C $Log: cepl3s.f,v $
C Revision 1.2  2012/03/30 12:12:42  j_novak
C Cleaning of fortran files
C
C Revision 1.1.1.1  2001/11/20 15:19:30  e_gourgoulhon
C LORENE
C
c Revision 1.2  1997/05/23  11:34:04  hyc
c *** empty log message ***
c
C Revision 1.1  1997/05/07 16:33:10  hyc
C Initial revision
C
C
C $Header: /cvsroot/Lorene/F77/Source/Poisson2d/cepl3s.f,v 1.2 2012/03/30 12:12:42 j_novak Exp $
C
C
	character*120 header
	data header/'$Header: /cvsroot/Lorene/F77/Source/Poisson2d/cepl3s.f,v 1.2 2012/03/30 12:12:42 j_novak Exp $'/

C
	real*8 TRA0,TRA1,DEN
C
	INTEGER NDEG,NDR,NDT,LR,LY,NF,LM,MM,NR1,NY1,JM,IPAR,ISYG
     1	,INV,LY1,MP,NY
C
	DIMENSION TRA0(NDR,*),TRA1(NDR,*),DEN(NDR,NDT,*)
	DIMENSION NDEG(3)
C
	NR1=NDEG(1)
	NY1=NDEG(2)
	NY=NY1-1
	NF=NDEG(3)
	IF(NR1.GT.NDR.OR.NY1.GT.NDT) THEN
	PRINT*,'ROUTINE CEPL3S: TABLEAUX MAL DIMENSIONES:,NR1,NY1,NDR,NDT='
	PRINT*,NR1,NY1,NDR,NDT
	STOP
	ENDIF
C
	IF(INV.EQ.1) GO TO 333
C
C		LA TRANSFORMATION TCEBYTCHEV LEGENDRE EST EFFECTUEE
C
	IF(ISYG.EQ.2) THEN
C
C		LE CAS SUPER SYMETRIQUE EST TRAITE
C
	IF(IPAR.EQ.0) THEN
C
C		LE CAS SYMETRIQUE EST TRAITE (M EST PAIRE)
C
	MM=0
	DO LY=1,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,1)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LM=2,NF,2
	MM=LM
	DO JM=LM,MIN(LM+1,NF)
	DO LY=1,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,JM)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,JM)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,JM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
	RETURN
	ENDIF
C
	IF(IPAR.EQ.1) THEN
C
C		LE CAS ANTISYMETRIQUE EST TRAITE (M DOIT ETRE PAIR)
C
	MM=0
	DO LY=1,NY1
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LM=2,NF,2
	MM=LM
	DO JM=LM,MIN(LM+1,NF)
	DO LY=1,NY1
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,JM)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,JM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
	RETURN
	ENDIF
C
	ENDIF
C
	IF(ISYG.EQ.0) THEN
C
C		LE CAS  NON SUPER SYMETRIQUE EST TRAITE
C
	IF(IPAR.EQ.0) THEN
C
C	 CAS SYMETRIQUE PAR RAPPORT Z=0
C
	DO LM=1,NF
	MM=LM/2
	IF((MM/2)*2.EQ.MM) THEN
C
	DO LY=1,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,LM)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,LM)
	ENDDO
	ENDDO
C
	ELSE
	DO LY=1,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,LM)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,LM)
	ENDDO
	ENDDO
	ENDIF
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,LM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	ENDDO
	RETURN
	ENDIF
C
	IF(IPAR.EQ.1) THEN
C
C		CAS ANTISYMETRIQUE
	DO LM=1,NF
	MM=LM/2
	MP=1
	IF((MM/2)*2.EQ.MM) THEN
	MP=0
	DO LY=1,NY1
	DO LR=1,NR1
C	TRA0(LR,LY)=-DEN(LR,LY,LM)
	TRA0(LR,LY)=DEN(LR,LY,LM)
	ENDDO
	ENDDO
	ELSE
	DO LY=2,NY1,2
	LY1=LY-1
	DO LR=1,NR1
	TRA0(LR,LY1)=-DEN(LR,LY,LM)
	ENDDO
	ENDDO
C
	DO LY=3,NY1,2
	LY1=LY-1
	DO LR=1,NR1
	TRA0(LR,LY1)=DEN(LR,LY,LM)
	ENDDO
	ENDDO
	ENDIF
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	IF(MP.EQ.0) THEN
	DO LY=1,NY
	DO LR=1,NR1
	DEN(LR,LY,LM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	ELSE
	DO LY=1,NY
	LY1=LY+1
	DO LR=1,NR1
	DEN(LR,LY1,LM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	DO LR=1,NR1
	DEN(LR,1,LM)=0
	ENDDO
	ENDIF
	ENDDO
	RETURN
	ENDIF
	ENDIF
C
 333		CONTINUE
C
C		TRANSFORMATION INVERSE
C
	IF(ISYG.EQ.2) THEN
	IF(IPAR.EQ.0) THEN
	MM=0
	DO LY=1,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,1)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	DO LY=1,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,1)=TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LY=2,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,1)=-TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LM=2,NF,2
	MM=LM
	DO JM=LM,MIN(LM+1,NF)
	DO LY=1,NY
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,JM)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
	DO LY=1,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=-TRA1(LR,LY)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
		RETURN
	ENDIF
C
	IF(IPAR.EQ.1) THEN
	MM=0
	DO LY=1,NY1
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LM=2,NF,2
	MM=LM
	DO JM=LM,MIN(LM+1,NF)
	DO LY=1,NY1
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,JM)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,JM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
	RETURN
	ENDIF
C
	ENDIF
C
	IF(ISYG.EQ.0) THEN
	IF(IPAR.EQ.0) THEN
	MM=0
	DO LY=1,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,1)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	DO LY=1,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,1)=TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LY=2,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,1)=-TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LM=2,NF,2
	MM=LM/2
C
	DO JM=LM,MIN(LM+1,NF)
	DO LY=1,NY
	DO LR=1,NR1
	TRA0(LR,LY)=DEN(LR,LY,JM)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
	IF((MM/2)*2.EQ.MM) THEN
	DO LY=1,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=-TRA1(LR,LY)
	ENDDO
	ENDDO
	ELSE
	DO LY=1,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=-TRA1(LR,LY)
	ENDDO
	ENDDO
	DO LY=2,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=TRA1(LR,LY)
	ENDDO
	ENDDO
	ENDIF
	ENDDO
	ENDDO
		RETURN
	ENDIF
C
	IF(IPAR.EQ.1) THEN
	MM=0
	DO LY=1,NY1
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LM=2,NF,2
	MM=LM/2
	DO JM=LM,MIN(LM+1,NF)
	DO LY=1,NY1
	DO LR=1,NR1
	TRA0(LR,LY)=-DEN(LR,LY,JM)
	ENDDO
	ENDDO
C
	CALL CEPLES(NDEG,NDR,INV,IPAR,MM,TRA0,TRA1)
C
	IF((MM/2)*2.EQ.MM) THEN
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,JM)=-TRA1(LR,LY)
	ENDDO
	ENDDO
	ELSE
	DO LY=1,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=-TRA1(LR,LY)
	ENDDO
	ENDDO
C
	DO LY=2,NY1,2
	DO LR=1,NR1
	DEN(LR,LY,JM)=TRA1(LR,LY)
	ENDDO
	ENDDO
C
	ENDIF
	ENDDO
	ENDDO
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=-DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	RETURN
	ENDIF
C
	ENDIF
  100	FORMAT(1X,10E10.3)
  101	FORMAT(1X,' ')
	END
