/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcmaps_defines.h
    \brief  Public header file with common definitions for the LCMAPS (authorization modules)
    \author Martijn Steenbakkers for the EU DataGrid.

    Here the return values for the LCMAPS plugins/modules are defined as well as the
    default locations of the LCMAPS "etc", "lib" and "modules" directories.
    \ingroup APIforLcmapsPlugins
*/

#ifndef LCMAPS_DEFINES_H
#define LCMAPS_DEFINES_H

/******************************************************************************
                             Define constants
******************************************************************************/

#define LCMAPS_MOD_SUCCESS ((int)0) /*!< Return value of LCMAPS plugin module
                                       indicating succes (authorization granted)*/
#define LCMAPS_MOD_FAIL    ((int)1) /*!< Return value of LCMAPS plugin module
                                       indicating failure (no authorization) */
#define LCMAPS_MOD_NOFILE  ((int)2) /*!< Return value of LCMAPS plugin module
                                       indicating that no file could be found */
#define LCMAPS_MOD_ENTRY   ((int)3) /*!< Return value of LCMAPS plugin module
                                       indicating that an entry was found */
#define LCMAPS_MOD_NOENTRY ((int)4) /*!< Return value of LCMAPS plugin module
                                       indicating that no entry was found */

#define LCMAPS_MAXPATHLEN    ((size_t)500) /*!< maximum path lengths of files, used in plugin
                               and database structures. \internal */
#define LCMAPS_MAXARGSTRING  ((size_t)2000) /*!< maximum length of the plugin argument string as
                               specified in the LCMAPS database. \internal */
#define LCMAPS_MAXARGS       51  /*!< maximum number of arguments (+1) to be passed to
                               LCMAPS authorization plugins/modules. \internal */

#endif /* LCMAPS_DEFINES_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/interface/lcmaps_defines.h,v $
    $Date: 2013-12-08 16:15:30 +0100 (Sun, 08 Dec 2013) $
    $Revision: 17212 $
    $Author: msalle $
******************************************************************************/
