/*
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */


/**
    \file   _lcmaps_gss_assist_gridmap.h
    \brief  This file holds implementation details of the \a lcmaps_gss_assist_gridmap
    interface that users of the API should not need to deal with.
    \author Dennis van Dok is taking all the blame


    \ingroup LcmapsHiddenInterface
*/

#ifndef _LCMAPS_GSS_ASSIST_GRIDMAP_H
#define _LCMAPS_GSS_ASSIST_GRIDMAP_H

/* Needed for NULL */
#include <stdio.h>

# ifdef LCMAPS_USE_DLOPEN

/*!
  \def LCMAPS_LIB_GSS_ASSIST_GRIDMAP
  \brief The name of the shared object that implements the interface.
*/
#define LCMAPS_LIB_GSS_ASSIST_GRIDMAP "liblcmaps_gss_assist_gridmap" LIBSUFF

/**
   \struct _lcmaps_handle_gss_assist_gridmap_s
    \brief Struct containing all the LCMAPS functions, will be filled using dlsym() 
*/
typedef struct _lcmaps_handle_gss_assist_gridmap_s {
    const char *libfilename;
    const char *helpername;
    void *handle,*helper;   /* handles to the LCMAPS library and its optional
			       helper (the latter is needed for the 'old' API to
			       provide missing symbols) */
    char *errmsg;
    lcmaps_init_t *lcmaps_init;
    globus_gss_assist_gridmap_t *globus_gss_assist_gridmap;
    lcmaps_term_t *lcmaps_term;
    /* Remainder is for 'new' API */
    /* LCMAPS_HANDLE_VERSION_MEMBERS; */
    getMajorVersion_t *getMajorVersion;
    lcmaps_get_major_version_t *lcmaps_get_major_version;
    lcmaps_get_minor_version_t *lcmaps_get_minor_version;
    lcmaps_get_patch_version_t *lcmaps_get_patch_version;
    /* If the above cannot be found (old lcmaps) these values will be
       set to 0 */
    int majorversion, minorversion, patchversion;
    /* Next three is the 'OSG API' */
    lcmaps_disable_voms_attributes_verification_t *lcmaps_disable_voms_attributes_verification;
    lcmaps_enable_voms_attributes_verification_t *lcmaps_enable_voms_attributes_verification;
    lcmaps_is_set_to_verify_voms_attributes_t *lcmaps_is_set_to_verify_voms_attributes;
    /* Plus the new two more fine-grained functions */
    lcmaps_set_voms_attributes_verification_t *lcmaps_set_voms_attributes_verification;
    lcmaps_get_voms_attributes_verification_t *lcmaps_get_voms_attributes_verification;
    /* Verification time of proxies */
    lcmaps_set_voms_verification_time_t *lcmaps_set_voms_verification_time;
    lcmaps_get_voms_verification_time_t *lcmaps_get_voms_verification_time;
} _lcmaps_handle_gss_assist_gridmap_t;

/* The declarator of the handle object */
#define _LCMAPS_DECL_HANDLE_GSS_ASSIST_GRIDMAP(l)	\
    _lcmaps_handle_gss_assist_gridmap_t l = {		\
	LCMAPS_LIB_GSS_ASSIST_GRIDMAP,			\
	LCMAPS_FIXVOMSHACKSO,				\
	NULL,						\
	NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        -1,-1,-1,					\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
    };


/* The initializer of the handle object */
#define _LCMAPS_INIT_HANDLE_GSS_ASSIST_GRIDMAP(l)			\
    (									\
     (l)->libfilename = LCMAPS_LIB_GSS_ASSIST_GRIDMAP,		\
     (l)->helpername = LCMAPS_FIXVOMSHACKSO,				\
     (l)->handle = (l)->helper = NULL,					\
     (l)->errmsg = NULL,						\
     (l)->majorversion = (l)->minorversion = (l)->patchversion = -1,	\
     (l)->lcmaps_init = NULL,						\
     (l)->lcmaps_gss_assist_gridmap = NULL,				\
     (l)->lcmaps_term = NULL,						\
     (l)->getMajorVersion = NULL,					\
     (l)->lcmaps_disable_voms_attributes_verification = NULL,		\
     (l)->lcmaps_enable_voms_attributes_verification = NULL,		\
     (l)->lcmaps_is_set_to_verify_voms_attributes = NULL,		\
     (l)->lcmaps_set_voms_attributes_verification = NULL,		\
     (l)->lcmaps_get_voms_attributes_verification = NULL,		\
     (l)->lcmaps_set_voms_verification_time = NULL,			\
     (l)->lcmaps_get_voms_verification_time = NULL,			\
     1									\
    )


/* The single macro to call to initialize lcmaps */
#define _LCMAPS_LOAD_GSS_ASSIST_GRIDMAP(l)				\
    (									\
     _LCMAPS_LOAD_INTERFACE_WITH_FIX(l)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_init)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_gss_assist_gridmap)			\
     && LCMAPS_LOAD_FUNC(l,lcmaps_term)					\
    )	    

# else /* LCMAPS_USE_DLOPEN */

typedef void * _lcmaps_handle_gss_assist_gridmap_t;

#define _LCMAPS_DECL_HANDLE_GSS_ASSIST_GRIDMAP(l)
#define _LCMAPS_INIT_HANDLE_GSS_ASSIST_GRIDMAP(l) (l = NULL)
#define _LCMAPS_INTERFACE_GSS_ASSIST_GRIDMAP(l) (1)

# endif /* LCMAPS_USE_DLOPEN */

#endif /* _LCMAPS_GSS_ASSIST_GRIDMAP_H */
