/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "titlewidget.h"
#include <QLabel>
#include <QVariant>
#include <QPushButton>
#include <QHBoxLayout>
#include <QMouseEvent>
#include <QGSettings>
#include <QDebug>

#include "global/xatom-helper.h"
#include "global/global.h"
#include "kmenu.h"

using namespace Global;

TitleWidget::TitleWidget(QWidget *parent) : QWidget(parent)
{
    initLayout();
    initConnect();
    setAttribute(Qt::WA_TranslucentBackground, true);
}

TitleWidget::~TitleWidget()
{

}

int TitleWidget::getMenuBtnX()
{
    return btnMenu->x();
}

void TitleWidget::setTitle(QString title, bool tip)
{
    m_fullTitle = title;
    QFontMetrics fontWidth(labTitle->font());//得到每个字符的宽度
    QString show_name = fontWidth.elidedText(m_fullTitle, Qt::ElideRight, labTitle->width() < 720 ? 720 : labTitle->width());//最大宽度150像素
    labTitle->setText(show_name);

    if (tip)
        labTitle->setToolTip(m_fullTitle);
    else
        labTitle->setToolTip("");
}

/** ************************************************************************
 * 更新最大化按钮图标
 ***************************************************************************/
void TitleWidget::updateMaxButtonStatus(bool _isMaxed)
{
    if (_isMaxed)
    {
        btnMaxSize->setIcon(QIcon::fromTheme("window-restore-symbolic"));
        btnMaxSize->setToolTip(tr("Restore"));
    }
    else
    {
        btnMaxSize->setIcon(QIcon::fromTheme("window-maximize-symbolic"));
        btnMaxSize->setToolTip(tr("Maximize"));
    }
    btnMaxSize->setProperty("setIconHighlightEffectDefaultColor", QColor(Qt::white));
}

void TitleWidget::setButtonState(bool _isAvailable)
{
    btnMinSize->setVisible(_isAvailable);
    btnMaxSize->setVisible(_isAvailable);
    if(!m_isHomePage)
        btnMiniMode->setVisible(_isAvailable);
}

void TitleWidget::setHide()
{
    hide();
}

void TitleWidget::setShow()
{
    if(!m_isMiniMode)
        show();
}

void TitleWidget::setHomePage(bool _isHomePage)
{
    m_isHomePage = _isHomePage;
    btnMiniMode->setVisible(!_isHomePage);
}

void TitleWidget::initLayout()
{
    // 标题栏没有主题适配，黑白主题都是黑底白字
    setFixedHeight(TITLE_BAR_FIXED_HEIGHT);

//    menu = new KMenu(parentWidget());
    menu = new KMenu;

    widget = new QWidget(this);
    widget->setObjectName("widget");
    // 渐变背景
    widget->setStyleSheet("#widget{background-color:qlineargradient(spread:pad, x1:0, y1:0, x2:0, y2:1, stop:0 rgba(19, 19, 20, 77), stop:1 rgba(255, 255, 255, 0));}");

    QHBoxLayout *h = new QHBoxLayout(this);
    h->setContentsMargins(0,0,0,0);
    h->addWidget(widget);
    QHBoxLayout *hb = new QHBoxLayout(widget);

    btnIcon = new QPushButton;
    btnIcon->setFixedSize(QSize(26, 26));
    btnIcon->setIconSize(QSize(26, 26));
    btnIcon->setIcon(QIcon::fromTheme("kylin-video"));
    btnIcon->setStyleSheet("QPushButton{border:0px;background:transparent;}"
                           "QPushButton::hover{border:0px;background:transparent;}"
                           "QPushButton::pressed{border:0px;background:transparent;}");
    hb->addWidget(btnIcon);

    labTitle = new QLabel;
    labTitle->setStyleSheet("color:#ffffff;");

    hb->addWidget(labTitle);
    hb->setStretchFactor(labTitle, 1);
    labTitle->setText(tr("Video Player"));
    hb->setContentsMargins(8, 0, 4, 0);

    btnMenu = new QPushButton;
    hb->addWidget(btnMenu);
    btnMenu->setFixedSize(30, 30);
    btnMenu->setProperty("isOptionButton", true);
    btnMenu->setProperty("isWindowButton", 0x1);
    btnMenu->setProperty("useIconHighlightEffect", 0x2);
    btnMenu->setFlat(true);
    btnMenu->setIcon(QIcon::fromTheme("open-menu-symbolic"));
    btnMenu->setProperty("setIconHighlightEffectDefaultColor", QColor(Qt::white));
    btnMenu->setToolTip(tr("Menu"));

    btnMiniMode = new QPushButton;
    hb->addWidget(btnMiniMode);
    btnMiniMode->setFixedSize(30, 30);
    btnMiniMode->setProperty("isOptionButton", true);
    btnMiniMode->setProperty("isWindowButton", 0x1);
    btnMiniMode->setProperty("useIconHighlightEffect", 0x2);
    btnMiniMode->setFlat(true);
    btnMiniMode->setIcon(QIcon::fromTheme("ukui-mini"));
    btnMiniMode->setProperty("setIconHighlightEffectDefaultColor", QColor(Qt::white));
    btnMiniMode->setVisible(false);
    btnMiniMode->setToolTip(tr("Mini mode"));

    btnMinSize = new QPushButton;
    hb->addWidget(btnMinSize);
    btnMinSize->setFixedSize(30, 30);
    btnMinSize->setProperty("isWindowButton", 0x1);
    btnMinSize->setProperty("useIconHighlightEffect", 0x2);
    btnMinSize->setFlat(true);
    btnMinSize->setIcon(QIcon::fromTheme("window-minimize-symbolic"));
    btnMinSize->setProperty("setIconHighlightEffectDefaultColor", QColor(Qt::white));
    btnMinSize->setToolTip(tr("Minimize"));

    btnMaxSize = new QPushButton;
    hb->addWidget(btnMaxSize);
    btnMaxSize->setFixedSize(30, 30);
    btnMaxSize->setProperty("isWindowButton", 0x1);
    btnMaxSize->setProperty("useIconHighlightEffect", 0x2);
    btnMaxSize->setFlat(true);
    btnMaxSize->setIcon(QIcon::fromTheme("window-maximize-symbolic"));
    btnMaxSize->setProperty("setIconHighlightEffectDefaultColor", QColor(Qt::white));
    btnMaxSize->setToolTip(tr("Maximize"));

    btnClose = new QPushButton;
    hb->addWidget(btnClose);
    btnClose->setFixedSize(30, 30);
    btnClose->setProperty("isWindowButton", 0x2);
    btnClose->setProperty("useIconHighlightEffect", 0x8);
    btnClose->setFlat(true);
    btnClose->setIcon(QIcon::fromTheme("window-close-symbolic"));
    btnClose->setProperty("setIconHighlightEffectDefaultColor", QColor(Qt::white));
    btnClose->setToolTip(tr("Close"));

    resetFont();
}

void TitleWidget::initConnect()
{
    connect(btnClose,       &QPushButton::clicked,  [this](){emit sigClose();});
    connect(btnMaxSize,     &QPushButton::clicked,  [this](){emit sigMaxSize();});
    connect(btnMinSize,     &QPushButton::clicked,  [this](){emit sigMiniSize();});
    connect(btnMiniMode,    &QPushButton::clicked,  [this](){emit sigMiniMode();});
    connect(btnMenu,        &QPushButton::clicked,  [this](){emit sigShowMenu();});
    connect(g_gsettings,    &QGSettings::changed,   [this](QString key){
        if (key == "systemFontSize" || key == "systemFont")
            resetFont();
    });
}

void TitleWidget::resetFont()
{
    QString fontFamily = g_gsettings->get("systemFont").toString();
    int fontSize = g_gsettings->get("systemFontSize").toInt();

    QFont f(fontFamily);
    f.setPointSize(fontSize);
    labTitle->setFont(f);

    QFontMetrics fontWidth(labTitle->font());//得到每个字符的宽度
    QString show_name = fontWidth.elidedText(m_fullTitle, Qt::ElideRight, labTitle->width() < 720 ? 720 : labTitle->width());//最大宽度150像素
    labTitle->setText(show_name);
}

bool TitleWidget::event(QEvent *e)
{
    return QWidget::event(e);
}

void TitleWidget::enterEvent(QEvent *e)
{
    if(m_leaveState) {
        m_leaveState = false;
        emit sigCanHide(false);
    }
}

void TitleWidget::leaveEvent(QEvent *e)
{
    m_leaveState = true;
    emit sigCanHide(true);
}

void TitleWidget::resizeEvent(QResizeEvent *e)
{
    QFontMetrics fontWidth(labTitle->font());//得到每个字符的宽度
    QString show_name = fontWidth.elidedText(m_fullTitle, Qt::ElideRight, labTitle->width() < 720 ? 720 : labTitle->width());
    labTitle->setText(show_name);
}

void TitleWidget::mouseDoubleClickEvent(QMouseEvent *event)
{
    if(event->button() == Qt::LeftButton)
        emit sigMaxSize();
}
