/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef PREVIEWWIDGET_H
#define PREVIEWWIDGET_H

#include <QWidget>
#include <mutex>
#include "global/global.h"

#include <libffmpegthumbnailer/videothumbnailer.h>
using namespace ffmpegthumbnailer;

namespace Ui {
class PreviewWidget;
}

class PreviewWidget : public QWidget
{
    Q_OBJECT

public:
    explicit PreviewWidget(QWidget *parent = nullptr);
    ~PreviewWidget();

    void setHide();
    void setPreview(int time);
    void setMoveRange(int range){moveRange = range;}

    void setBlackTheme();
    void setLightTheme();

private:
    Ui::PreviewWidget *ui;
    QString currentFile;
    int videoStream = -1;
    int duration;
    int previewTime = 0;
    int moveRange = 1;

signals:
    void updatePreview();

private slots:
    void slotFileInfoChange(Mpv::FileInfo info);
    void updatePos();

protected:
    std::mutex mux;
    VideoThumbnailer *m_videoTbr;
};

#endif // PREVIEWWIDGET_H
