
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCommonStyle.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCommonStyle>
#include <QApplication>
#include <QChildEvent>
#include <QEvent>
#include <QFontMetrics>
#include <QIcon>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QSize>
#include <QStyle>
#include <QStyleHintReturn>
#include <QStyleOption>
#include <QStyleOptionComplex>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include "gsiDeclQtWidgetsTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCommonStyle

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCommonStyle::staticMetaObject);
}


// void QCommonStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)


static void _init_f_drawComplexControl_c9027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawComplexControl_c9027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->drawComplexControl (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, arg3, arg4);
}


// void QCommonStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawControl_c8285 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawControl_c8285 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ControlElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->drawControl (qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(arg1).cref(), arg2, arg3, arg4);
}


// void QCommonStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawPrimitive_c8501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawPrimitive_c8501 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->drawPrimitive (qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(arg1).cref(), arg2, arg3, arg4);
}


// QPixmap QCommonStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)


static void _init_f_generatedIconPixmap_c5776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_generatedIconPixmap_c5776 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QIcon::Mode>::target_type & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QStyleOption *arg3 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  ret.write<QPixmap > ((QPixmap)((QCommonStyle *)cls)->generatedIconPixmap (qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg1).cref(), arg2, arg3));
}


// QStyle::SubControl QCommonStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)


static void _init_f_hitTestComplexControl_c9517 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_f_hitTestComplexControl_c9517 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  const QPoint &arg3 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)qt_gsi::CppToQtAdaptor<QStyle::SubControl>(((QCommonStyle *)cls)->hitTestComplexControl (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, arg3, arg4)));
}


// int QCommonStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)


static void _init_f_layoutSpacing_c11697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_layoutSpacing_c11697 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  const QStyleOption *arg4 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg5 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<int > ((int)((QCommonStyle *)cls)->layoutSpacing (qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg3).cref(), arg4, arg5));
}


// int QCommonStyle::pixelMetric(QStyle::PixelMetric m, const QStyleOption *opt, const QWidget *widget)


static void _init_f_pixelMetric_c6642 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_pixelMetric_c6642 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<int > ((int)((QCommonStyle *)cls)->pixelMetric (qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(arg1).cref(), arg2, arg3));
}


// void QCommonStyle::polish(QPalette &)


static void _init_f_polish_1418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1418 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPalette &arg1 = gsi::arg_reader<QPalette & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->polish (arg1);
}


// void QCommonStyle::polish(QApplication *app)


static void _init_f_polish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("app");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1843 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = gsi::arg_reader<QApplication * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->polish (arg1);
}


// void QCommonStyle::polish(QWidget *widget)


static void _init_f_polish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->polish (arg1);
}


// QSize QCommonStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)


static void _init_f_sizeFromContents_c8477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_f_sizeFromContents_c8477 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ContentsType>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  const QSize &arg3 = gsi::arg_reader<const QSize & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QSize > ((QSize)((QCommonStyle *)cls)->sizeFromContents (qt_gsi::QtToCppAdaptor<QStyle::ContentsType>(arg1).cref(), arg2, arg3, arg4));
}


// QIcon QCommonStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)


static void _init_f_standardIcon_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_f_standardIcon_c6956 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QIcon > ((QIcon)((QCommonStyle *)cls)->standardIcon (qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(arg1).cref(), arg2, arg3));
}


// QPixmap QCommonStyle::standardPixmap(QStyle::StandardPixmap sp, const QStyleOption *opt, const QWidget *widget)


static void _init_f_standardPixmap_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sp");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_standardPixmap_c6956 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QPixmap > ((QPixmap)((QCommonStyle *)cls)->standardPixmap (qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(arg1).cref(), arg2, arg3));
}


// int QCommonStyle::styleHint(QStyle::StyleHint sh, const QStyleOption *opt, const QWidget *w, QStyleHintReturn *shret)


static void _init_f_styleHint_c8615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("shret", true, "0");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_f_styleHint_c8615 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StyleHint>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  QStyleHintReturn *arg4 = args ? gsi::arg_reader<QStyleHintReturn * >() (args, heap) : gsi::arg_maker<QStyleHintReturn * >() (0, heap);
  ret.write<int > ((int)((QCommonStyle *)cls)->styleHint (qt_gsi::QtToCppAdaptor<QStyle::StyleHint>(arg1).cref(), arg2, arg3, arg4));
}


// QRect QCommonStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *w)


static void _init_f_subControlRect_c9798 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_f_subControlRect_c9798 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QStyle::SubControl>::target_type & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QRect > ((QRect)((QCommonStyle *)cls)->subControlRect (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, qt_gsi::QtToCppAdaptor<QStyle::SubControl>(arg3).cref(), arg4));
}


// QRect QCommonStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)


static void _init_f_subElementRect_c6528 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_subElementRect_c6528 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::SubElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QRect > ((QRect)((QCommonStyle *)cls)->subElementRect (qt_gsi::QtToCppAdaptor<QStyle::SubElement>(arg1).cref(), arg2, arg3));
}


// void QCommonStyle::unpolish(QWidget *widget)


static void _init_f_unpolish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->unpolish (arg1);
}


// void QCommonStyle::unpolish(QApplication *application)


static void _init_f_unpolish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1843 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = gsi::arg_reader<QApplication * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle *)cls)->unpolish (arg1);
}


// static QString QCommonStyle::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCommonStyle::tr (arg1, arg2, arg3));
}


// static QString QCommonStyle::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCommonStyle::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCommonStyle () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@brief Method void QCommonStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QStyle::drawComplexControl", true, &_init_f_drawComplexControl_c9027, &_call_f_drawComplexControl_c9027);
  methods += new qt_gsi::GenericMethod ("drawControl", "@brief Method void QCommonStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QStyle::drawControl", true, &_init_f_drawControl_c8285, &_call_f_drawControl_c8285);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@brief Method void QCommonStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QStyle::drawPrimitive", true, &_init_f_drawPrimitive_c8501, &_call_f_drawPrimitive_c8501);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Method QPixmap QCommonStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\nThis is a reimplementation of QStyle::generatedIconPixmap", true, &_init_f_generatedIconPixmap_c5776, &_call_f_generatedIconPixmap_c5776);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Method QStyle::SubControl QCommonStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)\nThis is a reimplementation of QStyle::hitTestComplexControl", true, &_init_f_hitTestComplexControl_c9517, &_call_f_hitTestComplexControl_c9517);
  methods += new qt_gsi::GenericMethod ("layoutSpacing", "@brief Method int QCommonStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\nThis is a reimplementation of QStyle::layoutSpacing", true, &_init_f_layoutSpacing_c11697, &_call_f_layoutSpacing_c11697);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@brief Method int QCommonStyle::pixelMetric(QStyle::PixelMetric m, const QStyleOption *opt, const QWidget *widget)\nThis is a reimplementation of QStyle::pixelMetric", true, &_init_f_pixelMetric_c6642, &_call_f_pixelMetric_c6642);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QCommonStyle::polish(QPalette &)\nThis is a reimplementation of QStyle::polish", false, &_init_f_polish_1418, &_call_f_polish_1418);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QCommonStyle::polish(QApplication *app)\nThis is a reimplementation of QStyle::polish", false, &_init_f_polish_1843, &_call_f_polish_1843);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QCommonStyle::polish(QWidget *widget)\nThis is a reimplementation of QStyle::polish", false, &_init_f_polish_1315, &_call_f_polish_1315);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@brief Method QSize QCommonStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)\nThis is a reimplementation of QStyle::sizeFromContents", true, &_init_f_sizeFromContents_c8477, &_call_f_sizeFromContents_c8477);
  methods += new qt_gsi::GenericMethod ("standardIcon", "@brief Method QIcon QCommonStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)\nThis is a reimplementation of QStyle::standardIcon", true, &_init_f_standardIcon_c6956, &_call_f_standardIcon_c6956);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@brief Method QPixmap QCommonStyle::standardPixmap(QStyle::StandardPixmap sp, const QStyleOption *opt, const QWidget *widget)\nThis is a reimplementation of QStyle::standardPixmap", true, &_init_f_standardPixmap_c6956, &_call_f_standardPixmap_c6956);
  methods += new qt_gsi::GenericMethod ("styleHint", "@brief Method int QCommonStyle::styleHint(QStyle::StyleHint sh, const QStyleOption *opt, const QWidget *w, QStyleHintReturn *shret)\nThis is a reimplementation of QStyle::styleHint", true, &_init_f_styleHint_c8615, &_call_f_styleHint_c8615);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@brief Method QRect QCommonStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *w)\nThis is a reimplementation of QStyle::subControlRect", true, &_init_f_subControlRect_c9798, &_call_f_subControlRect_c9798);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@brief Method QRect QCommonStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)\nThis is a reimplementation of QStyle::subElementRect", true, &_init_f_subElementRect_c6528, &_call_f_subElementRect_c6528);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Method void QCommonStyle::unpolish(QWidget *widget)\nThis is a reimplementation of QStyle::unpolish", false, &_init_f_unpolish_1315, &_call_f_unpolish_1315);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Method void QCommonStyle::unpolish(QApplication *application)\nThis is a reimplementation of QStyle::unpolish", false, &_init_f_unpolish_1843, &_call_f_unpolish_1843);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCommonStyle::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCommonStyle::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCommonStyle::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QStyle> &qtdecl_QStyle ();

qt_gsi::QtNativeClass<QCommonStyle> decl_QCommonStyle (qtdecl_QStyle (), "QtWidgets", "QCommonStyle_Native",
  methods_QCommonStyle (),
  "@hide\n@alias QCommonStyle");

GSI_QTWIDGETS_PUBLIC gsi::Class<QCommonStyle> &qtdecl_QCommonStyle () { return decl_QCommonStyle; }

}


class QCommonStyle_Adaptor : public QCommonStyle, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCommonStyle_Adaptor();

  //  [adaptor ctor] QCommonStyle::QCommonStyle()
  QCommonStyle_Adaptor() : QCommonStyle()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCommonStyle::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCommonStyle_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCommonStyle::isSignalConnected(signal);
  }

  //  [expose] int QCommonStyle::receivers(const char *signal)
  int fp_QCommonStyle_receivers_c1731 (const char *signal) const {
    return QCommonStyle::receivers(signal);
  }

  //  [expose] QObject *QCommonStyle::sender()
  QObject * fp_QCommonStyle_sender_c0 () const {
    return QCommonStyle::sender();
  }

  //  [expose] int QCommonStyle::senderSignalIndex()
  int fp_QCommonStyle_senderSignalIndex_c0 () const {
    return QCommonStyle::senderSignalIndex();
  }

  //  [emitter impl] void QCommonStyle::destroyed(QObject *)
  void emitter_QCommonStyle_destroyed_1302(QObject *arg1)
  {
    emit QCommonStyle::destroyed(arg1);
  }

  //  [adaptor impl] void QCommonStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)
  void cbs_drawComplexControl_c9027_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w) const
  {
    QCommonStyle::drawComplexControl(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, p, w);
  }

  virtual void drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawComplexControl_c9027_1.can_issue()) {
      cb_drawComplexControl_c9027_1.issue<QCommonStyle_Adaptor, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, QPainter *, const QWidget *>(&QCommonStyle_Adaptor::cbs_drawComplexControl_c9027_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, p, w);
    } else {
      QCommonStyle::drawComplexControl(cc, opt, p, w);
    }
  }

  //  [adaptor impl] void QCommonStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawControl_c8285_1(const qt_gsi::Converter<QStyle::ControlElement>::target_type & element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    QCommonStyle::drawControl(qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(element).cref(), opt, p, w);
  }

  virtual void drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawControl_c8285_1.can_issue()) {
      cb_drawControl_c8285_1.issue<QCommonStyle_Adaptor, const qt_gsi::Converter<QStyle::ControlElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QCommonStyle_Adaptor::cbs_drawControl_c8285_1, qt_gsi::CppToQtAdaptor<QStyle::ControlElement>(element), opt, p, w);
    } else {
      QCommonStyle::drawControl(element, opt, p, w);
    }
  }

  //  [adaptor impl] void QCommonStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)
  void cbs_drawItemPixmap_c5678_0(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    QCommonStyle::drawItemPixmap(painter, rect, alignment, pixmap);
  }

  virtual void drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    if (cb_drawItemPixmap_c5678_0.can_issue()) {
      cb_drawItemPixmap_c5678_0.issue<QCommonStyle_Adaptor, QPainter *, const QRect &, int, const QPixmap &>(&QCommonStyle_Adaptor::cbs_drawItemPixmap_c5678_0, painter, rect, alignment, pixmap);
    } else {
      QCommonStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }
  }

  //  [adaptor impl] void QCommonStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)
  void cbs_drawItemText_c10604_1(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, const qt_gsi::Converter<QPalette::ColorRole>::target_type & textRole) const
  {
    QCommonStyle::drawItemText(painter, rect, flags, pal, enabled, text, qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(textRole).cref());
  }

  virtual void drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole) const
  {
    if (cb_drawItemText_c10604_1.can_issue()) {
      cb_drawItemText_c10604_1.issue<QCommonStyle_Adaptor, QPainter *, const QRect &, int, const QPalette &, bool, const QString &, const qt_gsi::Converter<QPalette::ColorRole>::target_type &>(&QCommonStyle_Adaptor::cbs_drawItemText_c10604_1, painter, rect, flags, pal, enabled, text, qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(textRole));
    } else {
      QCommonStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }
  }

  //  [adaptor impl] void QCommonStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawPrimitive_c8501_1(const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    QCommonStyle::drawPrimitive(qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(pe).cref(), opt, p, w);
  }

  virtual void drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawPrimitive_c8501_1.can_issue()) {
      cb_drawPrimitive_c8501_1.issue<QCommonStyle_Adaptor, const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QCommonStyle_Adaptor::cbs_drawPrimitive_c8501_1, qt_gsi::CppToQtAdaptor<QStyle::PrimitiveElement>(pe), opt, p, w);
    } else {
      QCommonStyle::drawPrimitive(pe, opt, p, w);
    }
  }

  //  [adaptor impl] bool QCommonStyle::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCommonStyle::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCommonStyle_Adaptor, bool, QEvent *>(&QCommonStyle_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCommonStyle::event(arg1);
    }
  }

  //  [adaptor impl] bool QCommonStyle::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCommonStyle::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCommonStyle_Adaptor, bool, QObject *, QEvent *>(&QCommonStyle_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCommonStyle::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QPixmap QCommonStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)
  QPixmap cbs_generatedIconPixmap_c5776_0(const qt_gsi::Converter<QIcon::Mode>::target_type & iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    return QCommonStyle::generatedIconPixmap(qt_gsi::QtToCppAdaptor<QIcon::Mode>(iconMode).cref(), pixmap, opt);
  }

  virtual QPixmap generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    if (cb_generatedIconPixmap_c5776_0.can_issue()) {
      return cb_generatedIconPixmap_c5776_0.issue<QCommonStyle_Adaptor, QPixmap, const qt_gsi::Converter<QIcon::Mode>::target_type &, const QPixmap &, const QStyleOption *>(&QCommonStyle_Adaptor::cbs_generatedIconPixmap_c5776_0, qt_gsi::CppToQtAdaptor<QIcon::Mode>(iconMode), pixmap, opt);
    } else {
      return QCommonStyle::generatedIconPixmap(iconMode, pixmap, opt);
    }
  }

  //  [adaptor impl] QStyle::SubControl QCommonStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)
  qt_gsi::Converter<QStyle::SubControl>::target_type cbs_hitTestComplexControl_c9517_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w) const
  {
    return qt_gsi::CppToQtAdaptor<QStyle::SubControl>(QCommonStyle::hitTestComplexControl(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, pt, w));
  }

  virtual QStyle::SubControl hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w) const
  {
    if (cb_hitTestComplexControl_c9517_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStyle::SubControl>(cb_hitTestComplexControl_c9517_1.issue<QCommonStyle_Adaptor, qt_gsi::Converter<QStyle::SubControl>::target_type, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const QPoint &, const QWidget *>(&QCommonStyle_Adaptor::cbs_hitTestComplexControl_c9517_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, pt, w)).cref();
    } else {
      return QCommonStyle::hitTestComplexControl(cc, opt, pt, w);
    }
  }

  //  [adaptor impl] QRect QCommonStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)
  QRect cbs_itemPixmapRect_c4360_0(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    return QCommonStyle::itemPixmapRect(r, flags, pixmap);
  }

  virtual QRect itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    if (cb_itemPixmapRect_c4360_0.can_issue()) {
      return cb_itemPixmapRect_c4360_0.issue<QCommonStyle_Adaptor, QRect, const QRect &, int, const QPixmap &>(&QCommonStyle_Adaptor::cbs_itemPixmapRect_c4360_0, r, flags, pixmap);
    } else {
      return QCommonStyle::itemPixmapRect(r, flags, pixmap);
    }
  }

  //  [adaptor impl] QRect QCommonStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)
  QRect cbs_itemTextRect_c7544_0(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    return QCommonStyle::itemTextRect(fm, r, flags, enabled, text);
  }

  virtual QRect itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    if (cb_itemTextRect_c7544_0.can_issue()) {
      return cb_itemTextRect_c7544_0.issue<QCommonStyle_Adaptor, QRect, const QFontMetrics &, const QRect &, int, bool, const QString &>(&QCommonStyle_Adaptor::cbs_itemTextRect_c7544_0, fm, r, flags, enabled, text);
    } else {
      return QCommonStyle::itemTextRect(fm, r, flags, enabled, text);
    }
  }

  //  [adaptor impl] int QCommonStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)
  int cbs_layoutSpacing_c11697_2(const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control1, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control2, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QStyleOption *option, const QWidget *widget) const
  {
    return QCommonStyle::layoutSpacing(qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), option, widget);
  }

  virtual int layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_layoutSpacing_c11697_2.can_issue()) {
      return cb_layoutSpacing_c11697_2.issue<QCommonStyle_Adaptor, int, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type &, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type &, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QStyleOption *, const QWidget *>(&QCommonStyle_Adaptor::cbs_layoutSpacing_c11697_2, qt_gsi::CppToQtAdaptor<QSizePolicy::ControlType>(control1), qt_gsi::CppToQtAdaptor<QSizePolicy::ControlType>(control2), qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), option, widget);
    } else {
      return QCommonStyle::layoutSpacing(control1, control2, orientation, option, widget);
    }
  }

  //  [adaptor impl] int QCommonStyle::pixelMetric(QStyle::PixelMetric m, const QStyleOption *opt, const QWidget *widget)
  int cbs_pixelMetric_c6642_2(const qt_gsi::Converter<QStyle::PixelMetric>::target_type & m, const QStyleOption *opt, const QWidget *widget) const
  {
    return QCommonStyle::pixelMetric(qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(m).cref(), opt, widget);
  }

  virtual int pixelMetric(QStyle::PixelMetric m, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_pixelMetric_c6642_2.can_issue()) {
      return cb_pixelMetric_c6642_2.issue<QCommonStyle_Adaptor, int, const qt_gsi::Converter<QStyle::PixelMetric>::target_type &, const QStyleOption *, const QWidget *>(&QCommonStyle_Adaptor::cbs_pixelMetric_c6642_2, qt_gsi::CppToQtAdaptor<QStyle::PixelMetric>(m), opt, widget);
    } else {
      return QCommonStyle::pixelMetric(m, opt, widget);
    }
  }

  //  [adaptor impl] void QCommonStyle::polish(QPalette &)
  void cbs_polish_1418_0(QPalette &arg1)
  {
    QCommonStyle::polish(arg1);
  }

  virtual void polish(QPalette &arg1)
  {
    if (cb_polish_1418_0.can_issue()) {
      cb_polish_1418_0.issue<QCommonStyle_Adaptor, QPalette &>(&QCommonStyle_Adaptor::cbs_polish_1418_0, arg1);
    } else {
      QCommonStyle::polish(arg1);
    }
  }

  //  [adaptor impl] void QCommonStyle::polish(QApplication *app)
  void cbs_polish_1843_0(QApplication *app)
  {
    QCommonStyle::polish(app);
  }

  virtual void polish(QApplication *app)
  {
    if (cb_polish_1843_0.can_issue()) {
      cb_polish_1843_0.issue<QCommonStyle_Adaptor, QApplication *>(&QCommonStyle_Adaptor::cbs_polish_1843_0, app);
    } else {
      QCommonStyle::polish(app);
    }
  }

  //  [adaptor impl] void QCommonStyle::polish(QWidget *widget)
  void cbs_polish_1315_0(QWidget *widget)
  {
    QCommonStyle::polish(widget);
  }

  virtual void polish(QWidget *widget)
  {
    if (cb_polish_1315_0.can_issue()) {
      cb_polish_1315_0.issue<QCommonStyle_Adaptor, QWidget *>(&QCommonStyle_Adaptor::cbs_polish_1315_0, widget);
    } else {
      QCommonStyle::polish(widget);
    }
  }

  //  [adaptor impl] QSize QCommonStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)
  QSize cbs_sizeFromContents_c8477_1(const qt_gsi::Converter<QStyle::ContentsType>::target_type & ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget) const
  {
    return QCommonStyle::sizeFromContents(qt_gsi::QtToCppAdaptor<QStyle::ContentsType>(ct).cref(), opt, contentsSize, widget);
  }

  virtual QSize sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget) const
  {
    if (cb_sizeFromContents_c8477_1.can_issue()) {
      return cb_sizeFromContents_c8477_1.issue<QCommonStyle_Adaptor, QSize, const qt_gsi::Converter<QStyle::ContentsType>::target_type &, const QStyleOption *, const QSize &, const QWidget *>(&QCommonStyle_Adaptor::cbs_sizeFromContents_c8477_1, qt_gsi::CppToQtAdaptor<QStyle::ContentsType>(ct), opt, contentsSize, widget);
    } else {
      return QCommonStyle::sizeFromContents(ct, opt, contentsSize, widget);
    }
  }

  //  [adaptor impl] QIcon QCommonStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)
  QIcon cbs_standardIcon_c6956_2(const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & _standardIcon, const QStyleOption *opt, const QWidget *widget) const
  {
    return QCommonStyle::standardIcon(qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(_standardIcon).cref(), opt, widget);
  }

  virtual QIcon standardIcon(QStyle::StandardPixmap _standardIcon, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_standardIcon_c6956_2.can_issue()) {
      return cb_standardIcon_c6956_2.issue<QCommonStyle_Adaptor, QIcon, const qt_gsi::Converter<QStyle::StandardPixmap>::target_type &, const QStyleOption *, const QWidget *>(&QCommonStyle_Adaptor::cbs_standardIcon_c6956_2, qt_gsi::CppToQtAdaptor<QStyle::StandardPixmap>(_standardIcon), opt, widget);
    } else {
      return QCommonStyle::standardIcon(_standardIcon, opt, widget);
    }
  }

  //  [adaptor impl] QPalette QCommonStyle::standardPalette()
  QPalette cbs_standardPalette_c0_0() const
  {
    return QCommonStyle::standardPalette();
  }

  virtual QPalette standardPalette() const
  {
    if (cb_standardPalette_c0_0.can_issue()) {
      return cb_standardPalette_c0_0.issue<QCommonStyle_Adaptor, QPalette>(&QCommonStyle_Adaptor::cbs_standardPalette_c0_0);
    } else {
      return QCommonStyle::standardPalette();
    }
  }

  //  [adaptor impl] QPixmap QCommonStyle::standardPixmap(QStyle::StandardPixmap sp, const QStyleOption *opt, const QWidget *widget)
  QPixmap cbs_standardPixmap_c6956_2(const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & sp, const QStyleOption *opt, const QWidget *widget) const
  {
    return QCommonStyle::standardPixmap(qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(sp).cref(), opt, widget);
  }

  virtual QPixmap standardPixmap(QStyle::StandardPixmap sp, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_standardPixmap_c6956_2.can_issue()) {
      return cb_standardPixmap_c6956_2.issue<QCommonStyle_Adaptor, QPixmap, const qt_gsi::Converter<QStyle::StandardPixmap>::target_type &, const QStyleOption *, const QWidget *>(&QCommonStyle_Adaptor::cbs_standardPixmap_c6956_2, qt_gsi::CppToQtAdaptor<QStyle::StandardPixmap>(sp), opt, widget);
    } else {
      return QCommonStyle::standardPixmap(sp, opt, widget);
    }
  }

  //  [adaptor impl] int QCommonStyle::styleHint(QStyle::StyleHint sh, const QStyleOption *opt, const QWidget *w, QStyleHintReturn *shret)
  int cbs_styleHint_c8615_3(const qt_gsi::Converter<QStyle::StyleHint>::target_type & sh, const QStyleOption *opt, const QWidget *w, QStyleHintReturn *shret) const
  {
    return QCommonStyle::styleHint(qt_gsi::QtToCppAdaptor<QStyle::StyleHint>(sh).cref(), opt, w, shret);
  }

  virtual int styleHint(QStyle::StyleHint sh, const QStyleOption *opt, const QWidget *w, QStyleHintReturn *shret) const
  {
    if (cb_styleHint_c8615_3.can_issue()) {
      return cb_styleHint_c8615_3.issue<QCommonStyle_Adaptor, int, const qt_gsi::Converter<QStyle::StyleHint>::target_type &, const QStyleOption *, const QWidget *, QStyleHintReturn *>(&QCommonStyle_Adaptor::cbs_styleHint_c8615_3, qt_gsi::CppToQtAdaptor<QStyle::StyleHint>(sh), opt, w, shret);
    } else {
      return QCommonStyle::styleHint(sh, opt, w, shret);
    }
  }

  //  [adaptor impl] QRect QCommonStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *w)
  QRect cbs_subControlRect_c9798_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const qt_gsi::Converter<QStyle::SubControl>::target_type & sc, const QWidget *w) const
  {
    return QCommonStyle::subControlRect(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, qt_gsi::QtToCppAdaptor<QStyle::SubControl>(sc).cref(), w);
  }

  virtual QRect subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *w) const
  {
    if (cb_subControlRect_c9798_1.can_issue()) {
      return cb_subControlRect_c9798_1.issue<QCommonStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const qt_gsi::Converter<QStyle::SubControl>::target_type &, const QWidget *>(&QCommonStyle_Adaptor::cbs_subControlRect_c9798_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, qt_gsi::CppToQtAdaptor<QStyle::SubControl>(sc), w);
    } else {
      return QCommonStyle::subControlRect(cc, opt, sc, w);
    }
  }

  //  [adaptor impl] QRect QCommonStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)
  QRect cbs_subElementRect_c6528_1(const qt_gsi::Converter<QStyle::SubElement>::target_type & r, const QStyleOption *opt, const QWidget *widget) const
  {
    return QCommonStyle::subElementRect(qt_gsi::QtToCppAdaptor<QStyle::SubElement>(r).cref(), opt, widget);
  }

  virtual QRect subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_subElementRect_c6528_1.can_issue()) {
      return cb_subElementRect_c6528_1.issue<QCommonStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::SubElement>::target_type &, const QStyleOption *, const QWidget *>(&QCommonStyle_Adaptor::cbs_subElementRect_c6528_1, qt_gsi::CppToQtAdaptor<QStyle::SubElement>(r), opt, widget);
    } else {
      return QCommonStyle::subElementRect(r, opt, widget);
    }
  }

  //  [adaptor impl] void QCommonStyle::unpolish(QWidget *widget)
  void cbs_unpolish_1315_0(QWidget *widget)
  {
    QCommonStyle::unpolish(widget);
  }

  virtual void unpolish(QWidget *widget)
  {
    if (cb_unpolish_1315_0.can_issue()) {
      cb_unpolish_1315_0.issue<QCommonStyle_Adaptor, QWidget *>(&QCommonStyle_Adaptor::cbs_unpolish_1315_0, widget);
    } else {
      QCommonStyle::unpolish(widget);
    }
  }

  //  [adaptor impl] void QCommonStyle::unpolish(QApplication *application)
  void cbs_unpolish_1843_0(QApplication *application)
  {
    QCommonStyle::unpolish(application);
  }

  virtual void unpolish(QApplication *application)
  {
    if (cb_unpolish_1843_0.can_issue()) {
      cb_unpolish_1843_0.issue<QCommonStyle_Adaptor, QApplication *>(&QCommonStyle_Adaptor::cbs_unpolish_1843_0, application);
    } else {
      QCommonStyle::unpolish(application);
    }
  }

  //  [adaptor impl] void QCommonStyle::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCommonStyle::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCommonStyle_Adaptor, QChildEvent *>(&QCommonStyle_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCommonStyle::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCommonStyle::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCommonStyle::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCommonStyle_Adaptor, QEvent *>(&QCommonStyle_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCommonStyle::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCommonStyle::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCommonStyle::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCommonStyle_Adaptor, const QMetaMethod &>(&QCommonStyle_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCommonStyle::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCommonStyle::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCommonStyle::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCommonStyle_Adaptor, QTimerEvent *>(&QCommonStyle_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCommonStyle::timerEvent(arg1);
    }
  }

  gsi::Callback cb_drawComplexControl_c9027_1;
  gsi::Callback cb_drawControl_c8285_1;
  gsi::Callback cb_drawItemPixmap_c5678_0;
  gsi::Callback cb_drawItemText_c10604_1;
  gsi::Callback cb_drawPrimitive_c8501_1;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_generatedIconPixmap_c5776_0;
  gsi::Callback cb_hitTestComplexControl_c9517_1;
  gsi::Callback cb_itemPixmapRect_c4360_0;
  gsi::Callback cb_itemTextRect_c7544_0;
  gsi::Callback cb_layoutSpacing_c11697_2;
  gsi::Callback cb_pixelMetric_c6642_2;
  gsi::Callback cb_polish_1418_0;
  gsi::Callback cb_polish_1843_0;
  gsi::Callback cb_polish_1315_0;
  gsi::Callback cb_sizeFromContents_c8477_1;
  gsi::Callback cb_standardIcon_c6956_2;
  gsi::Callback cb_standardPalette_c0_0;
  gsi::Callback cb_standardPixmap_c6956_2;
  gsi::Callback cb_styleHint_c8615_3;
  gsi::Callback cb_subControlRect_c9798_1;
  gsi::Callback cb_subElementRect_c6528_1;
  gsi::Callback cb_unpolish_1315_0;
  gsi::Callback cb_unpolish_1843_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCommonStyle_Adaptor::~QCommonStyle_Adaptor() { }

//  Constructor QCommonStyle::QCommonStyle() (adaptor class)

static void _init_ctor_QCommonStyle_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCommonStyle_Adaptor> ();
}

static void _call_ctor_QCommonStyle_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCommonStyle_Adaptor *> (new QCommonStyle_Adaptor ());
}


// void QCommonStyle::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCommonStyle::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCommonStyle::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QCommonStyle_Adaptor *)cls)->emitter_QCommonStyle_destroyed_1302 (arg1);
}


// void QCommonStyle::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QCommonStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawComplexControl_c9027_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawComplexControl_c9027_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_drawComplexControl_c9027_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawComplexControl_c9027_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_drawComplexControl_c9027_1 = cb;
}


// void QCommonStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawControl_c8285_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawControl_c8285_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_drawControl_c8285_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawControl_c8285_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_drawControl_c8285_1 = cb;
}


// void QCommonStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)

static void _init_cbs_drawItemPixmap_c5678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemPixmap_c5678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  const QPixmap &arg4 = args.read<const QPixmap & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_drawItemPixmap_c5678_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawItemPixmap_c5678_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_drawItemPixmap_c5678_0 = cb;
}


// void QCommonStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)

static void _init_cbs_drawItemText_c10604_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pal");
  decl->add_arg<const QPalette & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("enabled");
  decl->add_arg<bool > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("textRole");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemText_c10604_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  const QPalette &arg4 = args.read<const QPalette & > (heap);
  bool arg5 = args.read<bool > (heap);
  const QString &arg6 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg7 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_drawItemText_c10604_1 (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static void _set_callback_cbs_drawItemText_c10604_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_drawItemText_c10604_1 = cb;
}


// void QCommonStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawPrimitive_c8501_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawPrimitive_c8501_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_drawPrimitive_c8501_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawPrimitive_c8501_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_drawPrimitive_c8501_1 = cb;
}


// bool QCommonStyle::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCommonStyle_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCommonStyle::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCommonStyle_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QPixmap QCommonStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)

static void _init_cbs_generatedIconPixmap_c5776_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_generatedIconPixmap_c5776_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > (heap);
  const QPixmap &arg2 = args.read<const QPixmap & > (heap);
  const QStyleOption *arg3 = args.read<const QStyleOption * > (heap);
  ret.write<QPixmap > ((QPixmap)((QCommonStyle_Adaptor *)cls)->cbs_generatedIconPixmap_c5776_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_generatedIconPixmap_c5776_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_generatedIconPixmap_c5776_0 = cb;
}


// QStyle::SubControl QCommonStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)

static void _init_cbs_hitTestComplexControl_c9517_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_cbs_hitTestComplexControl_c9517_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  const QPoint &arg3 = args.read<const QPoint & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)((QCommonStyle_Adaptor *)cls)->cbs_hitTestComplexControl_c9517_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_hitTestComplexControl_c9517_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_hitTestComplexControl_c9517_1 = cb;
}


// exposed bool QCommonStyle::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCommonStyle_Adaptor *)cls)->fp_QCommonStyle_isSignalConnected_c2394 (arg1));
}


// QRect QCommonStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)

static void _init_cbs_itemPixmapRect_c4360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemPixmapRect_c4360_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  int arg2 = args.read<int > (heap);
  const QPixmap &arg3 = args.read<const QPixmap & > (heap);
  ret.write<QRect > ((QRect)((QCommonStyle_Adaptor *)cls)->cbs_itemPixmapRect_c4360_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_itemPixmapRect_c4360_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_itemPixmapRect_c4360_0 = cb;
}


// QRect QCommonStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)

static void _init_cbs_itemTextRect_c7544_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fm");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("r");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("enabled");
  decl->add_arg<bool > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text");
  decl->add_arg<const QString & > (argspec_4);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemTextRect_c7544_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFontMetrics &arg1 = args.read<const QFontMetrics & > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  bool arg4 = args.read<bool > (heap);
  const QString &arg5 = args.read<const QString & > (heap);
  ret.write<QRect > ((QRect)((QCommonStyle_Adaptor *)cls)->cbs_itemTextRect_c7544_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_itemTextRect_c7544_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_itemTextRect_c7544_0 = cb;
}


// int QCommonStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_layoutSpacing_c11697_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_cbs_layoutSpacing_c11697_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (heap);
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QStyleOption *arg4 = args.read<const QStyleOption * > (heap);
  const QWidget *arg5 = args.read<const QWidget * > (heap);
  ret.write<int > ((int)((QCommonStyle_Adaptor *)cls)->cbs_layoutSpacing_c11697_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_layoutSpacing_c11697_2 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_layoutSpacing_c11697_2 = cb;
}


// int QCommonStyle::pixelMetric(QStyle::PixelMetric m, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_pixelMetric_c6642_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_cbs_pixelMetric_c6642_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<int > ((int)((QCommonStyle_Adaptor *)cls)->cbs_pixelMetric_c6642_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_pixelMetric_c6642_2 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_pixelMetric_c6642_2 = cb;
}


// void QCommonStyle::polish(QPalette &)

static void _init_cbs_polish_1418_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1418_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPalette &arg1 = args.read<QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_polish_1418_0 (arg1);
}

static void _set_callback_cbs_polish_1418_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_polish_1418_0 = cb;
}


// void QCommonStyle::polish(QApplication *app)

static void _init_cbs_polish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("app");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = args.read<QApplication * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_polish_1843_0 (arg1);
}

static void _set_callback_cbs_polish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_polish_1843_0 = cb;
}


// void QCommonStyle::polish(QWidget *widget)

static void _init_cbs_polish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_polish_1315_0 (arg1);
}

static void _set_callback_cbs_polish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_polish_1315_0 = cb;
}


// exposed int QCommonStyle::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCommonStyle_Adaptor *)cls)->fp_QCommonStyle_receivers_c1731 (arg1));
}


// exposed QObject *QCommonStyle::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCommonStyle_Adaptor *)cls)->fp_QCommonStyle_sender_c0 ());
}


// exposed int QCommonStyle::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCommonStyle_Adaptor *)cls)->fp_QCommonStyle_senderSignalIndex_c0 ());
}


// QSize QCommonStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)

static void _init_cbs_sizeFromContents_c8477_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeFromContents_c8477_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QSize &arg3 = args.read<const QSize & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<QSize > ((QSize)((QCommonStyle_Adaptor *)cls)->cbs_sizeFromContents_c8477_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_sizeFromContents_c8477_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_sizeFromContents_c8477_1 = cb;
}


// QIcon QCommonStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_standardIcon_c6956_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_cbs_standardIcon_c6956_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QIcon > ((QIcon)((QCommonStyle_Adaptor *)cls)->cbs_standardIcon_c6956_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_standardIcon_c6956_2 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_standardIcon_c6956_2 = cb;
}


// QPalette QCommonStyle::standardPalette()

static void _init_cbs_standardPalette_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_cbs_standardPalette_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)((QCommonStyle_Adaptor *)cls)->cbs_standardPalette_c0_0 ());
}

static void _set_callback_cbs_standardPalette_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_standardPalette_c0_0 = cb;
}


// QPixmap QCommonStyle::standardPixmap(QStyle::StandardPixmap sp, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_standardPixmap_c6956_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sp");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_standardPixmap_c6956_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QPixmap > ((QPixmap)((QCommonStyle_Adaptor *)cls)->cbs_standardPixmap_c6956_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_standardPixmap_c6956_2 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_standardPixmap_c6956_2 = cb;
}


// int QCommonStyle::styleHint(QStyle::StyleHint sh, const QStyleOption *opt, const QWidget *w, QStyleHintReturn *shret)

static void _init_cbs_styleHint_c8615_3 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("shret");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_cbs_styleHint_c8615_3 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  QStyleHintReturn *arg4 = args.read<QStyleHintReturn * > (heap);
  ret.write<int > ((int)((QCommonStyle_Adaptor *)cls)->cbs_styleHint_c8615_3 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_styleHint_c8615_3 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_styleHint_c8615_3 = cb;
}


// QRect QCommonStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *w)

static void _init_cbs_subControlRect_c9798_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_cbs_subControlRect_c9798_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = args.read<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<QRect > ((QRect)((QCommonStyle_Adaptor *)cls)->cbs_subControlRect_c9798_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_subControlRect_c9798_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_subControlRect_c9798_1 = cb;
}


// QRect QCommonStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_subElementRect_c6528_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_subElementRect_c6528_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QRect > ((QRect)((QCommonStyle_Adaptor *)cls)->cbs_subElementRect_c6528_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_subElementRect_c6528_1 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_subElementRect_c6528_1 = cb;
}


// void QCommonStyle::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QCommonStyle::unpolish(QWidget *widget)

static void _init_cbs_unpolish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_unpolish_1315_0 (arg1);
}

static void _set_callback_cbs_unpolish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_unpolish_1315_0 = cb;
}


// void QCommonStyle::unpolish(QApplication *application)

static void _init_cbs_unpolish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = args.read<QApplication * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCommonStyle_Adaptor *)cls)->cbs_unpolish_1843_0 (arg1);
}

static void _set_callback_cbs_unpolish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QCommonStyle_Adaptor *)cls)->cb_unpolish_1843_0 = cb;
}


namespace gsi
{

gsi::Class<QCommonStyle> &qtdecl_QCommonStyle ();

static gsi::Methods methods_QCommonStyle_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCommonStyle::QCommonStyle()\nThis method creates an object of class QCommonStyle.", &_init_ctor_QCommonStyle_Adaptor_0, &_call_ctor_QCommonStyle_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCommonStyle::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCommonStyle::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCommonStyle::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCommonStyle::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@hide", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@brief Virtual method void QCommonStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1, &_set_callback_cbs_drawComplexControl_c9027_1);
  methods += new qt_gsi::GenericMethod ("drawControl", "@hide", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1);
  methods += new qt_gsi::GenericMethod ("drawControl", "@brief Virtual method void QCommonStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1, &_set_callback_cbs_drawControl_c8285_1);
  methods += new qt_gsi::GenericMethod ("drawItemPixmap", "@hide", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0);
  methods += new qt_gsi::GenericMethod ("drawItemPixmap", "@brief Virtual method void QCommonStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0, &_set_callback_cbs_drawItemPixmap_c5678_0);
  methods += new qt_gsi::GenericMethod ("drawItemText", "@hide", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1);
  methods += new qt_gsi::GenericMethod ("drawItemText", "@brief Virtual method void QCommonStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1, &_set_callback_cbs_drawItemText_c10604_1);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@hide", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@brief Virtual method void QCommonStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1, &_set_callback_cbs_drawPrimitive_c8501_1);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCommonStyle::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCommonStyle::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@hide", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Virtual method QPixmap QCommonStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0, &_set_callback_cbs_generatedIconPixmap_c5776_0);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@hide", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Virtual method QStyle::SubControl QCommonStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1, &_set_callback_cbs_hitTestComplexControl_c9517_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCommonStyle::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemPixmapRect", "@hide", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0);
  methods += new qt_gsi::GenericMethod ("itemPixmapRect", "@brief Virtual method QRect QCommonStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0, &_set_callback_cbs_itemPixmapRect_c4360_0);
  methods += new qt_gsi::GenericMethod ("itemTextRect", "@hide", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0);
  methods += new qt_gsi::GenericMethod ("itemTextRect", "@brief Virtual method QRect QCommonStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0, &_set_callback_cbs_itemTextRect_c7544_0);
  methods += new qt_gsi::GenericMethod ("layoutSpacing", "@hide", true, &_init_cbs_layoutSpacing_c11697_2, &_call_cbs_layoutSpacing_c11697_2);
  methods += new qt_gsi::GenericMethod ("layoutSpacing", "@brief Virtual method int QCommonStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_layoutSpacing_c11697_2, &_call_cbs_layoutSpacing_c11697_2, &_set_callback_cbs_layoutSpacing_c11697_2);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@hide", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@brief Virtual method int QCommonStyle::pixelMetric(QStyle::PixelMetric m, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2, &_set_callback_cbs_pixelMetric_c6642_2);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QCommonStyle::polish(QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0, &_set_callback_cbs_polish_1418_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QCommonStyle::polish(QApplication *app)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0, &_set_callback_cbs_polish_1843_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QCommonStyle::polish(QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0, &_set_callback_cbs_polish_1315_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCommonStyle::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCommonStyle::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCommonStyle::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@hide", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@brief Virtual method QSize QCommonStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1, &_set_callback_cbs_sizeFromContents_c8477_1);
  methods += new qt_gsi::GenericMethod ("standardIcon", "@hide", true, &_init_cbs_standardIcon_c6956_2, &_call_cbs_standardIcon_c6956_2);
  methods += new qt_gsi::GenericMethod ("standardIcon", "@brief Virtual method QIcon QCommonStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardIcon_c6956_2, &_call_cbs_standardIcon_c6956_2, &_set_callback_cbs_standardIcon_c6956_2);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@hide", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@brief Virtual method QPalette QCommonStyle::standardPalette()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0, &_set_callback_cbs_standardPalette_c0_0);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@hide", true, &_init_cbs_standardPixmap_c6956_2, &_call_cbs_standardPixmap_c6956_2);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@brief Virtual method QPixmap QCommonStyle::standardPixmap(QStyle::StandardPixmap sp, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPixmap_c6956_2, &_call_cbs_standardPixmap_c6956_2, &_set_callback_cbs_standardPixmap_c6956_2);
  methods += new qt_gsi::GenericMethod ("styleHint", "@hide", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3);
  methods += new qt_gsi::GenericMethod ("styleHint", "@brief Virtual method int QCommonStyle::styleHint(QStyle::StyleHint sh, const QStyleOption *opt, const QWidget *w, QStyleHintReturn *shret)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3, &_set_callback_cbs_styleHint_c8615_3);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@hide", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@brief Virtual method QRect QCommonStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1, &_set_callback_cbs_subControlRect_c9798_1);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@hide", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@brief Virtual method QRect QCommonStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1, &_set_callback_cbs_subElementRect_c6528_1);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCommonStyle::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QCommonStyle::unpolish(QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0, &_set_callback_cbs_unpolish_1315_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QCommonStyle::unpolish(QApplication *application)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0, &_set_callback_cbs_unpolish_1843_0);
  return methods;
}

gsi::Class<QCommonStyle_Adaptor> decl_QCommonStyle_Adaptor (qtdecl_QCommonStyle (), "QtWidgets", "QCommonStyle",
  methods_QCommonStyle_Adaptor (),
  "@qt\n@brief Binding of QCommonStyle");

}

