
#include <migration/migratemanager.h>
#include <migration/keximigrate.h>

#include <KAboutData>

#include <QApplication>
#include <QDebug>

int main(int argc, char *argv[])
{
    KAboutData aboutData("keximigratetest", 0, kxi18n("Kexi Migrate Test"), "2.0");
    KCmdLineArgs::init(argc, argv, &aboutData);
    KApplication app;

    KexiMigration::MigrateManager mm;

    qDebug() << mm.driverIds();

    //Text File Test
    KexiMigration::KexiMigrate *m = mm.driver("Text");

    KDbConnectionData cd;

    cd.setFileName("/home/piggz/tabdata.txt");

    KexiMigration::Data d;
    d.source = &cd;

    m->setData(&d);

    m->connectSource();

    KDbTableSchema ts;

    if (!m->readTableSchema("tabdata.txt", ts))
    {
      qDebug() << "Unable to read schema";
      return 0;
    }

    if (!m->readFromTable("tabdata.txt"))
    {
      qDebug() << "Unable to read from table";
      return 0;
    }

    while(m->moveNext())
    {
        qDebug() << m->value(0) << m->value(1) << m->value(2);
    }

    m->movePrevious();
    qDebug() << m->value(0) << m->value(1) << m->value(2);

    m->moveNext();
    qDebug() << m->value(0) << m->value(1) << m->value(2);

    m->movePrevious();
    qDebug() << m->value(0) << m->value(1) << m->value(2);

    m->movePrevious();
    qDebug() << m->value(0) << m->value(1) << m->value(2);

    m->movePrevious();
    qDebug() << m->value(0) << m->value(1) << m->value(2);

    m->moveNext();
    qDebug() << m->value(0) << m->value(1) << m->value(2);


    //KSpread file test

    KexiMigration::KexiMigrate *k = mm.driver("KSpread");
    cd.setFileName("/home/piggz/Documents/database.fods");
    k->setData(&d);

    k->connectSource();
    QStringList tn;
    k->tableNames(tn);

    qDebug() << tn;
    KDbTableSchema ts2;
    if (!k->readTableSchema("Names", ts2))
    {
      qDebug() << "Unable to read schema";
      return 0;
    }

    k->readFromTable("Names");

    while(k->moveNext())
    {
        qDebug() << k->value(0) << k->value(1) << k->value(2);
    }
}
