
/*!
 * \file
 * \ingroup db
 * \brief Database support for modules.
 *
 * Database support functions for modules.
 *
 * @cond
 * WARNING:
 * This file was autogenerated from the XML source file
 * ../../modules/carrierroute/kamailio-carrierroute.xml.
 * It can be regenerated by running 'make modules' in the db/schema
 * directory of the source code. You need to have xsltproc and
 * docbook-xsl stylesheets installed.
 * ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED
 * @endcond
 */

#ifndef db_carrierroute_h
#define db_carrierroute_h


/* necessary includes */
#include "../../lib/srdb1/db.h"
#include "../../core/str.h"
#include "../../core/ut.h"

#include <string.h>


/* database variables */

extern str carrierroute_db_url;
extern db1_con_t * carrierroute_dbh;
extern db_func_t carrierroute_dbf;

#define carrierroute_DB_URL { "db_url", PARAM_STR, &carrierroute_db_url },

#define carrierroute_DB_TABLE { "carrierroute_table", PARAM_STR, &carrierroute_table },

extern str carrierroute_table;

/* column names */
extern str carrierroute_id_col;
extern str carrierroute_carrier_col;
extern str carrierroute_domain_col;
extern str carrierroute_scan_prefix_col;
extern str carrierroute_flags_col;
extern str carrierroute_mask_col;
extern str carrierroute_prob_col;
extern str carrierroute_strip_col;
extern str carrierroute_rewrite_host_col;
extern str carrierroute_rewrite_prefix_col;
extern str carrierroute_rewrite_suffix_col;
extern str carrierroute_description_col;
#define carrierroute_DB_COLS \
{ "carrierroute_id_col", PARAM_STR, &carrierroute_id_col }, \
{ "carrierroute_carrier_col", PARAM_STR, &carrierroute_carrier_col }, \
{ "carrierroute_domain_col", PARAM_STR, &carrierroute_domain_col }, \
{ "carrierroute_scan_prefix_col", PARAM_STR, &carrierroute_scan_prefix_col }, \
{ "carrierroute_flags_col", PARAM_STR, &carrierroute_flags_col }, \
{ "carrierroute_mask_col", PARAM_STR, &carrierroute_mask_col }, \
{ "carrierroute_prob_col", PARAM_STR, &carrierroute_prob_col }, \
{ "carrierroute_strip_col", PARAM_STR, &carrierroute_strip_col }, \
{ "carrierroute_rewrite_host_col", PARAM_STR, &carrierroute_rewrite_host_col }, \
{ "carrierroute_rewrite_prefix_col", PARAM_STR, &carrierroute_rewrite_prefix_col }, \
{ "carrierroute_rewrite_suffix_col", PARAM_STR, &carrierroute_rewrite_suffix_col }, \
{ "carrierroute_description_col", PARAM_STR, &carrierroute_description_col }, \

/* table version */
extern const unsigned int carrierroute_version;

#define carrierfailureroute_DB_TABLE { "carrierfailureroute_table", PARAM_STR, &carrierfailureroute_table },

extern str carrierfailureroute_table;

/* column names */
extern str carrierfailureroute_id_col;
extern str carrierfailureroute_carrier_col;
extern str carrierfailureroute_domain_col;
extern str carrierfailureroute_scan_prefix_col;
extern str carrierfailureroute_host_name_col;
extern str carrierfailureroute_reply_code_col;
extern str carrierfailureroute_flags_col;
extern str carrierfailureroute_mask_col;
extern str carrierfailureroute_next_domain_col;
extern str carrierfailureroute_description_col;
#define carrierfailureroute_DB_COLS \
{ "carrierfailureroute_id_col", PARAM_STR, &carrierfailureroute_id_col }, \
{ "carrierfailureroute_carrier_col", PARAM_STR, &carrierfailureroute_carrier_col }, \
{ "carrierfailureroute_domain_col", PARAM_STR, &carrierfailureroute_domain_col }, \
{ "carrierfailureroute_scan_prefix_col", PARAM_STR, &carrierfailureroute_scan_prefix_col }, \
{ "carrierfailureroute_host_name_col", PARAM_STR, &carrierfailureroute_host_name_col }, \
{ "carrierfailureroute_reply_code_col", PARAM_STR, &carrierfailureroute_reply_code_col }, \
{ "carrierfailureroute_flags_col", PARAM_STR, &carrierfailureroute_flags_col }, \
{ "carrierfailureroute_mask_col", PARAM_STR, &carrierfailureroute_mask_col }, \
{ "carrierfailureroute_next_domain_col", PARAM_STR, &carrierfailureroute_next_domain_col }, \
{ "carrierfailureroute_description_col", PARAM_STR, &carrierfailureroute_description_col }, \

/* table version */
extern const unsigned int carrierfailureroute_version;

#define carrier_name_DB_TABLE { "carrier_name_table", PARAM_STR, &carrier_name_table },

extern str carrier_name_table;

/* column names */
extern str carrier_name_id_col;
extern str carrier_name_carrier_col;
#define carrier_name_DB_COLS \
{ "carrier_name_id_col", PARAM_STR, &carrier_name_id_col }, \
{ "carrier_name_carrier_col", PARAM_STR, &carrier_name_carrier_col }, \

/* table version */
extern const unsigned int carrier_name_version;

#define domain_name_DB_TABLE { "domain_name_table", PARAM_STR, &domain_name_table },

extern str domain_name_table;

/* column names */
extern str domain_name_id_col;
extern str domain_name_domain_col;
#define domain_name_DB_COLS \
{ "domain_name_id_col", PARAM_STR, &domain_name_id_col }, \
{ "domain_name_domain_col", PARAM_STR, &domain_name_domain_col }, \

/* table version */
extern const unsigned int domain_name_version;


/*
 * Closes the DB connection.
 */
void carrierroute_db_close(void);

/*!
 * Initialises the DB API, check the table version and closes the connection.
 * This should be called from the mod_init function.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
int carrierroute_db_init(void);

/*!
 * Initialize the DB connection without checking the table version and DB URL.
 * This should be called from child_init. An already existing database
 * connection will be closed, and a new one created.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
int carrierroute_db_open(void);

#endif
