---
title: History
permalink: "/docs/history/"
note: This file is autogenerated. Edit /History.markdown instead.
---

## 4.3.1 / 2022-10-26
{: #v4-3-1}

### Bug Fixes
{: #bug-fixes-v4-3-1}

- Respect user-defined name attribute in documents ([#9167]({{ site.repository }}/issues/9167))
- Revert &#34;Incrementally rebuild when a data file is changed&#34; ([#9170]({{ site.repository }}/issues/9170))

### Documentation

- Release post for v4.3.1 ([#9171]({{ site.repository }}/issues/9171))


## 4.3.0 / 2022-10-20
{: #v4-3-0}

### Minor Enhancements
{: #minor-enhancements-v4-3-0}

- Add webrick as a dependency ([#8524]({{ site.repository }}/issues/8524))
- Regenerate supported mime types ([#8542]({{ site.repository }}/issues/8542))
- Update include tag to be more permissive ([#8618]({{ site.repository }}/issues/8618))
- Optimize `Jekyll::Utils.parse_date` ([#8425]({{ site.repository }}/issues/8425))
- Update rubocop from 1.12 to 1.18 and min ruby from 2.4 to 2.5 ([#8741]({{ site.repository }}/issues/8741))
- Always hide cache-dir contents from Git ([#8798]({{ site.repository }}/issues/8798))
- Remove the warning about auto-regeneration on Windows ([#8821]({{ site.repository }}/issues/8821))
- Propagate _data folder from theme ([#8815]({{ site.repository }}/issues/8815))
- Support both tzinfo v1 and v2 along with non-half hour offsets. ([#8880]({{ site.repository }}/issues/8880))
- Run vendor-mimes to update mime.types ([#8940]({{ site.repository }}/issues/8940))
- Expose collection static files via `site.static_files` ([#8961]({{ site.repository }}/issues/8961))
- Expose `basename` from `document.rb` as `name` to Liquid templates ([#8761]({{ site.repository }}/issues/8761))
- Allow Configurable Converters on CSV ([#8858]({{ site.repository }}/issues/8858))
- Introduce `theme` drop to expose theme-gem details ([#9129]({{ site.repository }}/issues/9129))
- Relax version constraint to allow Rouge 4.x ([#9134]({{ site.repository }}/issues/9134))
- Incrementally rebuild when a data file is changed ([#8771]({{ site.repository }}/issues/8771))
- Support jekyll-sass-converter 3.x ([#9132]({{ site.repository }}/issues/9132))

### Bug Fixes
{: #bug-fixes-v4-3-0}

- fix: pin rubocop to 1.12 due to error with ruby 2.4 ([#8651]({{ site.repository }}/issues/8651))
- Load Jekyll plugins from BUNDLE_GEMFILE location ([#8585]({{ site.repository }}/issues/8585))
- fix(security):  CVE-2021-28834 ([#8680]({{ site.repository }}/issues/8680))
- Inject livereload script using `location.protocol` instead of `http:` ([#8718]({{ site.repository }}/issues/8718))
- Respect collections_dir config within include tag ([#8756]({{ site.repository }}/issues/8756))
- Fix regression in Convertible module from v4.2.0  ([#8786]({{ site.repository }}/issues/8786))
- Revert [#7253]({{ site.repository }}/issues/7253): &#34;Don&#39;t reset site.url to localhost:4000 by default&#34; ([#8620]({{ site.repository }}/issues/8620))
- Improve readability of CI logs ([#8877]({{ site.repository }}/issues/8877))
- Fix deprecation message for missing doc method ([#8960]({{ site.repository }}/issues/8960))
- Fix response header for content served via `jekyll serve` ([#8965]({{ site.repository }}/issues/8965))
- Trigger livereload in sites without pages ([#8337]({{ site.repository }}/issues/8337))
- Only enable BOM encoding option on UTF encodings ([#8363]({{ site.repository }}/issues/8363))
- Ensure theme config is a `Jekyll::Configuration` object ([#8988]({{ site.repository }}/issues/8988))
- Remove misleading totals row from `--profile` table ([#9039]({{ site.repository }}/issues/9039))
- Unlock Psych dependency ([#9135]({{ site.repository }}/issues/9135))
- Fix false positive conflicts for static files in a collection ([#9141]({{ site.repository }}/issues/9141))

### Development Fixes
{: #development-fixes-v4-3-0}

- style: enable new cops ([#8538]({{ site.repository }}/issues/8538))
- Allow dependabot to keep github actions up-to-date ([#8540]({{ site.repository }}/issues/8540))
- Update actions/cache requirement to v2.1.3 ([#8543]({{ site.repository }}/issues/8543))
- Pin rubocop version ([#8564]({{ site.repository }}/issues/8564))
- style: add rubocop 1.9 cops ([#8567]({{ site.repository }}/issues/8567))
- Cross Version Testing Locally and Faster CI ([#8610]({{ site.repository }}/issues/8610))
- Use official Ruby setup GH action ([#8614]({{ site.repository }}/issues/8614))
- Spell check action for markdown documentation ([#8675]({{ site.repository }}/issues/8675))
- Update expect to cover docs/_posts ([#8677]({{ site.repository }}/issues/8677))
- Bump check-spelling/check-spelling from 0.0.18 to 0.0.19 ([#8740]({{ site.repository }}/issues/8740))
- Enable Rubocop accessor grouping, fix existing offenses ([#8293]({{ site.repository }}/issues/8293))
- Tags:Highlight: Decomposed HTMLLegacy formatter ([#8623]({{ site.repository }}/issues/8623))
- Relax Rubocop Dependency ([#8831]({{ site.repository }}/issues/8831))
- Add a workflow to build gems consistently ([#8830]({{ site.repository }}/issues/8830))
- Fix random test failures in TestExcerpt #to_liquid ([#8884]({{ site.repository }}/issues/8884))
- Lock gem `psych` to `v3.x` ([#8918]({{ site.repository }}/issues/8918))
- Fix typo in Bug Report template ([#8951]({{ site.repository }}/issues/8951))
- Check symlink outside site_source without Pathutil ([#9015]({{ site.repository }}/issues/9015))
- Stop testing with Rubies older than 2.7 on non-Windows  ([#8955]({{ site.repository }}/issues/8955))
- Bump actions/checkout from 2 to 3 ([#8986]({{ site.repository }}/issues/8986))
- Remove git.io shortlinks from repo ([#9045]({{ site.repository }}/issues/9045))
- Bump rubocop to 1.32 ([#9093]({{ site.repository }}/issues/9093))
- Bump RuboCop to `1.36.x` ([#9125]({{ site.repository }}/issues/9125))
- Use check-spelling/check-spelling@v0.0.20 ([#9111]({{ site.repository }}/issues/9111))
- Disable pending cops when running rubocop ([#9136]({{ site.repository }}/issues/9136))
- Relax RDoc version dependency ([#9142]({{ site.repository }}/issues/9142))

### Documentation

- typo - do instead of don&#39;t ([#8518]({{ site.repository }}/issues/8518))
- Document support for TSV files consistently ([#8488]({{ site.repository }}/issues/8488))
- Add a disclaimer to tutorials involving Ruby code ([#8525]({{ site.repository }}/issues/8525))
- Improve documentation on developing generators ([#8527]({{ site.repository }}/issues/8527))
- Fixes typo in layouts_dir documentation ([#8532]({{ site.repository }}/issues/8532))
- Fix i.e. typos in collections.md ([#8529]({{ site.repository }}/issues/8529))
- Remove GitHub Pages content which is in GitHub docs ([#8533]({{ site.repository }}/issues/8533))
- Step By Step Instructions Review ([#8399]({{ site.repository }}/issues/8399))
- Fix typo in migrating from 3.0 to 4.0 page ([#8572]({{ site.repository }}/issues/8572))
- Fix for important missing step in macOS Installation Docs: Add the Homebrew gems directory to the PATH ([#8496]({{ site.repository }}/issues/8496))
- Use latest Jekyll-action configuration ([#8579]({{ site.repository }}/issues/8579))
- docs: troubleshoot macOS with ARM64 architecture ([#8560]({{ site.repository }}/issues/8560))
- docs: add overview of .jekyll-cache dir ([#8648]({{ site.repository }}/issues/8648))
- docs: clarify where .jekyll-metadata comes from ([#8646]({{ site.repository }}/issues/8646))
- Razorops CI/CD added ([#8656]({{ site.repository }}/issues/8656))
- Specify default port and host for serve commands in docs ([#8624]({{ site.repository }}/issues/8624))
- Update third-party.md ([#8652]({{ site.repository }}/issues/8652))
- Add documentation for Sass configuration options ([#8587]({{ site.repository }}/issues/8587))
- Add formcarry to forms section ([#8471]({{ site.repository }}/issues/8471))
- Add step to set SDKROOT ([#8478]({{ site.repository }}/issues/8478))
- Improve the &#34;Markdown Options&#34; Docs ([#8681]({{ site.repository }}/issues/8681))
- Add &#39;webrick&#39; warning note to &#34;Quickstart&#34; Docs ([#8727]({{ site.repository }}/issues/8727))
- Update windows.md ([#8701]({{ site.repository }}/issues/8701))
- IRC networks - Libera, Freenode ([#8706]({{ site.repository }}/issues/8706))
- Improve GitHub Flavored Markdown Docs ([#8684]({{ site.repository }}/issues/8684))
- Fixing URL in MacOS install for rbenv-doctor ([#8693]({{ site.repository }}/issues/8693))
- Fix adjective in `troubleshooting.md` document ([#8777]({{ site.repository }}/issues/8777))
- Goodbye Frank. We&#39;ll miss you. 💔 ([#8807]({{ site.repository }}/issues/8807))
- Update index.html: Grammar fix. ([#8803]({{ site.repository }}/issues/8803))
- Prefer Libera. Remove Freenode. ([#8811]({{ site.repository }}/issues/8811))
- Update feature_request.md ([#8797]({{ site.repository }}/issues/8797))
- Remove AWS Amplify from the showcase ([#8812]({{ site.repository }}/issues/8812))
- Move Frank to Emeritus Core Team Members ([#8813]({{ site.repository }}/issues/8813))
- Release post for v4.2.1 ([#8818]({{ site.repository }}/issues/8818))
- Update CircleCI example ([#8829]({{ site.repository }}/issues/8829))
- Fix typo ([#8835]({{ site.repository }}/issues/8835))
- Added docs for running locally ([#8852]({{ site.repository }}/issues/8852))
- Linting README.markdown ([#8900]({{ site.repository }}/issues/8900))
- Remove text on GITHUB_TOKEN which is now built-in ([#8907]({{ site.repository }}/issues/8907))
- Add Security Policy document ([#8823]({{ site.repository }}/issues/8823))
- Manage repository meta documents consistently ([#8908]({{ site.repository }}/issues/8908))
- docs: add Layer0 deployment guide ([#8915]({{ site.repository }}/issues/8915))
- docs: Update README generated by `jekyll new-theme` ([#8919]({{ site.repository }}/issues/8919))
- Update resources.md ([#8925]({{ site.repository }}/issues/8925))
- Rewrite documentation on installing plugins ([#8921]({{ site.repository }}/issues/8921))
- Improve maintainers guide on releasing a new version ([#8928]({{ site.repository }}/issues/8928))
- Fix link for &#34;CloudSh&#34; ([#8934]({{ site.repository }}/issues/8934))
- Recommend using `actions/cache` in GitHub Actions documentation ([#8948]({{ site.repository }}/issues/8948))
- Remove references to EOL hakiri.io service ([#8946]({{ site.repository }}/issues/8946))
- Release post for v4.2.2 ([#8982]({{ site.repository }}/issues/8982))
- Document releasing off `*-stable` branches ([#8984]({{ site.repository }}/issues/8984))
- Update document by fix yaml syntax error ([#8991]({{ site.repository }}/issues/8991))
- Enhance option&#39;s case for Jekyll configuration ([#8992]({{ site.repository }}/issues/8992))
- Fix typo in `_docs/deployment/manual.md` ([#8997]({{ site.repository }}/issues/8997))
- Add quiet/verbose options ([#8996]({{ site.repository }}/issues/8996))
- Update README.markdown re IRC Pointer ([#9005]({{ site.repository }}/issues/9005))
- Remove Aerobatic ([#9007]({{ site.repository }}/issues/9007))
- Add Jekyll 3.9.2 release post to &#39;master&#39; branch ([#9013]({{ site.repository }}/issues/9013))
- Simplify macOS installation docs ([#8993]({{ site.repository }}/issues/8993))
- Improve document about Github Actions section ([#8853]({{ site.repository }}/issues/8853))
- Update permalinks.md  ([#9017]({{ site.repository }}/issues/9017))
- Add clarity to docs on permalinks placeholders and built-ins ([#8995]({{ site.repository }}/issues/8995))
- Remove Ionic Framework site from showcase ([#9057]({{ site.repository }}/issues/9057))
- Windows: describe which option to choose ([#9049]({{ site.repository }}/issues/9049))
- Improve links (http -&gt; https) ([#9064]({{ site.repository }}/issues/9064))
- Update ruby version for macos guide ([#9086]({{ site.repository }}/issues/9086))
- Update posts.md ([#9151]({{ site.repository }}/issues/9151))
- Release post for v4.3.0 ([#9157]({{ site.repository }}/issues/9157))

### Site Enhancements
{: #site-enhancements-v4-3-0}

- Improvements to CSS ([#7834]({{ site.repository }}/issues/7834))
- Slightly update lang `sh` code-block styling ([#8857]({{ site.repository }}/issues/8857))


## 4.2.2 / 2022-03-03
{: #v4-2-2}

### Bug Fixes
{: #bug-fixes-v4-2-2}

- Lock `http_parser.rb` gem to `v0.6.x` on JRuby.

### Development Fixes
{: #development-fixes-v4-2-2}

- Backport [#8830]({{ site.repository }}/issues/8830) for v4.2.x: Add a workflow to build gems consistently ([#8869]({{ site.repository }}/issues/8869))
- Lock `rubocop-performance` to `v1.11.x`.


## 4.2.1 / 2021-09-27
{: #v4-2-1}

### Bug Fixes
{: #bug-fixes-v4-2-1}

- Backport [#8620]({{ site.repository }}/issues/8620) for v4.2.x: Revert [#7253]({{ site.repository }}/issues/7253): "Don't reset site.url to localhost:4000 by default" ([#8808]({{ site.repository }}/issues/8808))
- Backport [#8756]({{ site.repository }}/issues/8756) for v4.2.x: Respect collections_dir config within include tag ([#8794]({{ site.repository }}/issues/8794))
- Backport [#8786]({{ site.repository }}/issues/8786) for v4.2.x: Fix regression in Convertible module from v4.2.0 ([#8793]({{ site.repository }}/issues/8793))


## 4.2.0 / 2020-12-14
{: #v4-2-0}

### Minor Enhancements
{: #minor-enhancements-v4-2-0}

- Warn on command-line with permalink conflict ([#8342]({{ site.repository }}/issues/8342))
- Suppress warning issued for redirect pages ([#8347]({{ site.repository }}/issues/8347))
- Enhance detection of conflicting destination URLs ([#8459]({{ site.repository }}/issues/8459))
- Add `:post_convert` hook to modify HTML content before layout ([#8368]({{ site.repository }}/issues/8368))
- Allow triggering `:post_convert` events atomically ([#8465]({{ site.repository }}/issues/8465))
- Debug reading Page and Layout objects ([#8100]({{ site.repository }}/issues/8100))
- Do not reset `site.url` to `http://localhost:4000` by default ([#7253]({{ site.repository }}/issues/7253))
- Add custom debug strings for Jekyll objects ([#8473]({{ site.repository }}/issues/8473))
- Debug reading data files in a site ([#8481]({{ site.repository }}/issues/8481))

### Bug Fixes
{: #bug-fixes-v4-2-0}

- Replace nested conditional with guard clauses ([#8294]({{ site.repository }}/issues/8294))
- Fix: security bump ([#8349]({{ site.repository }}/issues/8349))
- Fix path matching regex in post_url Liquid tag ([#8375]({{ site.repository }}/issues/8375))
- Enable `Performance/ChainArrayAllocation` cop ([#8404]({{ site.repository }}/issues/8404))
- Enable Lint/NoReturnInBeginEndBlocks Cop ([#8457]({{ site.repository }}/issues/8457))
- Generate items from `site.include` list only once ([#8463]({{ site.repository }}/issues/8463))
- Explicitly return nil after site process phase ([#8472]({{ site.repository }}/issues/8472))

### Optimization Fixes
{: #optimization-fixes-v4-2-0}

- Implement custom delegators for drop methods ([#8183]({{ site.repository }}/issues/8183))
- Handle `nil` argument to `Jekyll.sanitized_path` ([#8415]({{ site.repository }}/issues/8415))
- Cache `Jekyll.sanitized_path` ([#8424]({{ site.repository }}/issues/8424))
- Memoize array of drop getter method names ([#8421]({{ site.repository }}/issues/8421))
- Reduce string allocations from the `link` tag ([#8387]({{ site.repository }}/issues/8387))
- Optimize parsing of parameters in `include` tag ([#8192]({{ site.repository }}/issues/8192))
- Stash documents `write?` attribute in a variable ([#8389]({{ site.repository }}/issues/8389))
- Reduce string allocations from generating doc URLs ([#8392]({{ site.repository }}/issues/8392))
- Check if site is in incremental mode optimally ([#8401]({{ site.repository }}/issues/8401))
- Utilize flexibility of `Site#in_dest_dir` ([#8403]({{ site.repository }}/issues/8403))
- Reduce allocations from rendering item as liquid ([#8406]({{ site.repository }}/issues/8406))
- Compute relative_path of pages using PathManager ([#8408]({{ site.repository }}/issues/8408))
- Reduce allocation from `normalize_whitespace` filter ([#8400]({{ site.repository }}/issues/8400))
- Use `Regexp#match?` when `MatchData` is not required ([#8427]({{ site.repository }}/issues/8427))
- Check default front matter scope against symbols ([#8393]({{ site.repository }}/issues/8393))
- Stash frequently used `Drop` setter keys for reuse ([#8394]({{ site.repository }}/issues/8394))
- Memoize defaults computed for Convertibles ([#8451]({{ site.repository }}/issues/8451))
- Reduce array allocations from merging categories ([#8453]({{ site.repository }}/issues/8453))
- Memoize destination of pages, documents and staticfiles ([#8458]({{ site.repository }}/issues/8458))
- Reduce allocations from computing item property ([#8485]({{ site.repository }}/issues/8485))
- Optimize `Page#dir` with a private method ([#8489]({{ site.repository }}/issues/8489))
- Stash attribute hash for Liquid computed for pages ([#8497]({{ site.repository }}/issues/8497))

### Development Fixes
{: #development-fixes-v4-2-0}

- Update cucumber gem to version 4.1 ([#8278]({{ site.repository }}/issues/8278))
- Move permalink styles data to constant ([#8282]({{ site.repository }}/issues/8282))
- Update rubocop gem to 0.87.1 ([#8287]({{ site.repository }}/issues/8287))
- Update RuboCop to-do file ([#8296]({{ site.repository }}/issues/8296))
- Fix `rake console` generating LoadError ([#8312]({{ site.repository }}/issues/8312))
- Configure Performance cops ([#8369]({{ site.repository }}/issues/8369))
- Update rubocop gem to 0.90.0 ([#8313]({{ site.repository }}/issues/8313))
- Refactor `Jekyll::Utils::Platforms` ([#7236]({{ site.repository }}/issues/7236))
- Bump RuboCop to v0.91.x ([#8391]({{ site.repository }}/issues/8391))
- Add workflow to build and profile third-party repo ([#8398]({{ site.repository }}/issues/8398))
- Bump RuboCop to v0.92.x
- Update cucumber gem version to 5.1.2 ([#8413]({{ site.repository }}/issues/8413))
- Fix test suite compatibility with JRuby ([#8418]({{ site.repository }}/issues/8418))
- chore(deps): bump Rubocop to 0.93.0 ([#8430]({{ site.repository }}/issues/8430))
- Use Ruby 2.7.1 in GitHub Actions ([#8444]({{ site.repository }}/issues/8444))
- Test that Liquid expressions are not deeply evaled ([#8292]({{ site.repository }}/issues/8292))
- Test rendering arbitrary Liquid variables by default ([#7414]({{ site.repository }}/issues/7414))
- Migrate TravisCI jobs to GitHub Actions ([#8492]({{ site.repository }}/issues/8492))

### Documentation

- Update pointer to special permalink variables for collections ([#8274]({{ site.repository }}/issues/8274))
- Fix special treatment for &#39;page 1&#39; in docs of pagination ([#8230]({{ site.repository }}/issues/8230))
- Add Formcake to forms section ([#8283]({{ site.repository }}/issues/8283))
- Add a note on the rendering process in the docs ([#8291]({{ site.repository }}/issues/8291))
- Add refactoring type to PULL_REQUEST_TEMPLATE ([#8297]({{ site.repository }}/issues/8297))
- Update resources.md ([#7864]({{ site.repository }}/issues/7864))
- Extra apostrophes in an URL ([#8319]({{ site.repository }}/issues/8319))
- Clarify target of subordinate clause ([#8320]({{ site.repository }}/issues/8320))
- Cherry-pick commits from conflicting branch `docs-40`
- Update documentation on third party site ([#8352]({{ site.repository }}/issues/8352))
- Update default.md with info requested in [#8314]({{ site.repository }}/issues/8314) ([#8353]({{ site.repository }}/issues/8353))
- Clarify description of `safe` option ([#8354]({{ site.repository }}/issues/8354))
- Simplifying the Git post-receive hook-example ([#8358]({{ site.repository }}/issues/8358))
- Add missing doc for build and serve commands ([#8365]({{ site.repository }}/issues/8365))
- Docs Review: Getting Started ([#8372]({{ site.repository }}/issues/8372))
- Add note about rebooting system after installation ([#8359]({{ site.repository }}/issues/8359))
- Use data file to render table at `/docs/configuration/options/#global-configuration` ([#8377]({{ site.repository }}/issues/8377))
- Use data file(s) to render table(s) at `/docs/configuration/options/` ([#8380]({{ site.repository }}/issues/8380))
- Improve maintainability of config option data ([#8383]({{ site.repository }}/issues/8383))
- Remove CircleCI v1 docs ([#8410]({{ site.repository }}/issues/8410))
- Remove `NOKOGIRI_USE_SYSTEM_LIBRARIES` from Travis CI docs ([#8409]({{ site.repository }}/issues/8409))
- Add links to all Jekyll themes on GitHub tagged with #jekyll-theme ([#8447]({{ site.repository }}/issues/8447))
- Document initializing project Gemfile from scratch ([#8450]({{ site.repository }}/issues/8450))
- Document installation of additional dependencies for installing Jekyll on Fedora ([#8456]({{ site.repository }}/issues/8456))
- Improve documentation on Hooks in Jekyll ([#8467]({{ site.repository }}/issues/8467))
- Build docs site with GitHub Actions ([#8201]({{ site.repository }}/issues/8201))
- Add link to Assets page from `_sass` section in `_docs/structure.md` ([#8486]({{ site.repository }}/issues/8486))

### Site Enhancements
{: #site-enhancements-v4-2-0}

- Fix rendering of *showcase* images ([#8504]({{ site.repository }}/issues/8504))


## 4.1.1 / 2020-06-24
{: #v4-1-1}

### Bug Fixes
{: #bug-fixes-v4-1-1}

- Disable page excerpts by default ([#8222]({{ site.repository }}/issues/8222))
- Revert introduction of PageDrop ([#8221]({{ site.repository }}/issues/8221))
- Don&#39;t generate excerpts for non-html pages ([#8234]({{ site.repository }}/issues/8234))
- Make page excerpts consistent with doc excerpts ([#8236]({{ site.repository }}/issues/8236))

### Documentation

- Replace deprecated &#39;show&#39; command with &#39;info&#39; ([#8235]({{ site.repository }}/issues/8235))
- Change name to ▲Vercel ([#8247]({{ site.repository }}/issues/8247))
- Add language and examples to describe how to use the configuration op… ([#8249]({{ site.repository }}/issues/8249))
- Fix missing yaml front matter colon and adjust/add clarifying language. ([#8250]({{ site.repository }}/issues/8250))
- correct typo ([#8261]({{ site.repository }}/issues/8261))
- Allow hyperlinks to specific filter documentation ([#8231]({{ site.repository }}/issues/8231))
- Update link to Netlify step-by-step guide ([#8264]({{ site.repository }}/issues/8264))
- Fix grammar in documentation section ([#8265]({{ site.repository }}/issues/8265))

### Site Enhancements
{: #site-enhancements-v4-1-1}

- Including correct Sketch website ([#8241]({{ site.repository }}/issues/8241))
- Release post for v4.1.1 ([#8243]({{ site.repository }}/issues/8243))

### Development Fixes
{: #development-fixes-v4-1-1}

- Bump RuboCop to v0.85.x ([#8223]({{ site.repository }}/issues/8223))
- Expect drive letter only on vanilla windows ([#8227]({{ site.repository }}/issues/8227))


## 4.1.0 / 2020-05-27
{: #v4-1-0}

### Bug Fixes
{: #bug-fixes-v4-1-0}

- Memoize `absolute_url` and `relative_url` filters ([#7793]({{ site.repository }}/issues/7793))
- Fix documentation comment for `Jekyll::Converters::Identity` ([#7883]({{ site.repository }}/issues/7883))
- Optimize `Jekyll::Filters#item_property` ([#7696]({{ site.repository }}/issues/7696))
- Allow multiple binary operators in `where_exp` filter ([#8047]({{ site.repository }}/issues/8047))
- Fix documents custom-ordering logic ([#8028]({{ site.repository }}/issues/8028))
- Use `layout.path` when rendering the Liquid layout ([#8069]({{ site.repository }}/issues/8069))
- Reduce array allocations from `StaticFile#path` ([#8083]({{ site.repository }}/issues/8083))
- Simplify `Jekyll::Renderer#validate_layout` ([#8064]({{ site.repository }}/issues/8064))
- Add static file's basename to its `url_placeholder` ([#7908]({{ site.repository }}/issues/7908))
- Clear cached Liquid template scope before render ([#7967]({{ site.repository }}/issues/7967))
- Cache `URLFilter` results of string inputs per site ([#7990]({{ site.repository }}/issues/7990))
- Use `platforms` instead of `install_if` in Gemfile ([#8140]({{ site.repository }}/issues/8140))
- Config include trailing slash ([#8113]({{ site.repository }}/issues/8113))
- Improve path normalization in liquid_renderer ([#8075]({{ site.repository }}/issues/8075))
- Switch slugify regex to support more Unicode character groups ([#8167]({{ site.repository }}/issues/8167))
- Check if entry is a directory once per enumerator ([#8177]({{ site.repository }}/issues/8177))
- Filter out exclusively excluded entries sooner ([#7482]({{ site.repository }}/issues/7482))
- Return `relative_url` if site.url is an empty string ([#7988]({{ site.repository }}/issues/7988))
- Configure kramdown toc_levels as array by default ([#8015]({{ site.repository }}/issues/8015))
- Reduce `Pathname` objects from front matter defaults ([#8067]({{ site.repository }}/issues/8067))
- Simplify `Jekyll::Hooks.trigger` logic ([#8044]({{ site.repository }}/issues/8044))
- Quicker categories for documents without superdirs ([#7987]({{ site.repository }}/issues/7987))
- Reduce `Jekyll::Renderer` instances during a build ([#7570]({{ site.repository }}/issues/7570))
- Escape regex characters in paths to match ([#8138]({{ site.repository }}/issues/8138))
- Provide invokables for common drop query keys ([#8165]({{ site.repository }}/issues/8165))
- Optimize path sanitization of default front matter ([#8154]({{ site.repository }}/issues/8154))
- Initialize static files' data hash only if needed ([#8188]({{ site.repository }}/issues/8188))
- Initialize include-files as Jekyll objects ([#8158]({{ site.repository }}/issues/8158))

### Minor Enhancements
{: #minor-enhancements-v4-1-0}

- serve: add support for ECC certificates ([#7768]({{ site.repository }}/issues/7768))
- Update `item_property` to recognize integers ([#7878]({{ site.repository }}/issues/7878))
- Include `_config.yml` in a new theme's gemspec ([#7865]({{ site.repository }}/issues/7865))
- Add an option to easily disable disk-cache ([#7928]({{ site.repository }}/issues/7928))
- Optimize markdown parsing with Kramdown by reusing the options and parser objects ([#8013]({{ site.repository }}/issues/8013))
- Add `PageDrop` to provide Liquid templates with data ([#7992]({{ site.repository }}/issues/7992))
- Optimize `Kramdown::JekyllDocument#to_html` calls ([#8041]({{ site.repository }}/issues/8041))
- Configure default language for syntax-highlighting ([#8035]({{ site.repository }}/issues/8035))
- Remove dev dependencies from new theme-gem gemspec ([#8042]({{ site.repository }}/issues/8042))
- Allow disabling import of theme configuration ([#8131]({{ site.repository }}/issues/8131))
- Allow excerpts to be generated for `Page` objects ([#7642]({{ site.repository }}/issues/7642))
- Profile various stages of a site's build process ([#6760]({{ site.repository }}/issues/6760))
- Add find filters to optimize where-first chains ([#8171]({{ site.repository }}/issues/8171))
- Make `number_of_words` filter respect CJK characters ([#7813]({{ site.repository }}/issues/7813))
- Allow extensionless document in a strict site ([#7950]({{ site.repository }}/issues/7950))
- Add `:slugified_categories` URL placeholder ([#8094]({{ site.repository }}/issues/8094))

### Documentation

- Add dropped 'title: Staff' to the code ([#7805]({{ site.repository }}/issues/7805))
- Clarify docs for static files in collection ([#7812]({{ site.repository }}/issues/7812))
- Rephrase the CircleCI v2 section ([#7815]({{ site.repository }}/issues/7815))
- Update old GitHub wiki URL with new one ([#7823]({{ site.repository }}/issues/7823))
- Update JekyllConf page with 2019 talks ([#7826]({{ site.repository }}/issues/7826))
- link for memberships ([#7825]({{ site.repository }}/issues/7825))
- Doc: minor fix, should be greater or equal to min version ([#7856]({{ site.repository }}/issues/7856))
- Update third-party.md - Fix broken link ([#7857]({{ site.repository }}/issues/7857))
- clarify _config.yml/collections type ([#7873]({{ site.repository }}/issues/7873))
- Replace backticks with HTML tags in data file ([#7879]({{ site.repository }}/issues/7879))
- add new theme source ([#7875]({{ site.repository }}/issues/7875))
- fixed grammatical error (it&#39;s --&gt; its) ([#7887]({{ site.repository }}/issues/7887))
- Docs: Clarify organizing pages into subfolders ([#7896]({{ site.repository }}/issues/7896))
- Disambiguate the placeholder of permalink ([#7906]({{ site.repository }}/issues/7906))
- docs: add short serve command for livereload ([#7919]({{ site.repository }}/issues/7919))
- docs: add options for watch and force polling ([#7918]({{ site.repository }}/issues/7918))
- add install instructions for ArchLinux and openSUSE ([#7920]({{ site.repository }}/issues/7920))
- Improve index page of Jekyll documentation  ([#7926]({{ site.repository }}/issues/7926))
- Include path in `jekyll new` commands (Usage docs) ([#7931]({{ site.repository }}/issues/7931))
- Change `affect` to `effect` in the collections docs ([#7937]({{ site.repository }}/issues/7937))
- Changed deprecated command in themes documentation ([#7941]({{ site.repository }}/issues/7941))
- Adds some documentation for the `:clean`, `:on_obsolete` hook ([#7954]({{ site.repository }}/issues/7954))
- docs: fix broken link ([#7955]({{ site.repository }}/issues/7955))
- Corrected typo ([#7975]({{ site.repository }}/issues/7975))
- docs: remove watch option in config ([#7940]({{ site.repository }}/issues/7940))
- Correct a sentence in the documentation ([#7978]({{ site.repository }}/issues/7978))
- Fix YAML representation of `group_by` result ([#7979]({{ site.repository }}/issues/7979))
- Move `--baseurl` to build command options ([#7985]({{ site.repository }}/issues/7985))
- Correct documentation of filters ([#7989]({{ site.repository }}/issues/7989))
- Document sorting two documents by their `date` ([#7870]({{ site.repository }}/issues/7870))
- Fix English grammar error ([#7994]({{ site.repository }}/issues/7994))
- Update 03-front-matter.md ([#7996]({{ site.repository }}/issues/7996))
- Add Kentico Kontent CMS integration to resources ([#8000]({{ site.repository }}/issues/8000))
- Update 07-assets.md ([#7413]({{ site.repository }}/issues/7413))
- Fix file references in Step by Step Tutorial's Assets step ([#8007]({{ site.repository }}/issues/8007))
- docs: improve highlighting of code blocks ([#8017]({{ site.repository }}/issues/8017))
- remove leading slash from Sass file location ([#8021]({{ site.repository }}/issues/8021))
- [Docs] Fix asset link ref in step-by-step tutorial ([#8026]({{ site.repository }}/issues/8026))
- Corrected command to modify PATH ([#8029]({{ site.repository }}/issues/8029))
- Corrected command to modify PATH ([#8030]({{ site.repository }}/issues/8030))
- Docs: Render full contents of just the latest post ([#8032]({{ site.repository }}/issues/8032))
- docs: improvements for note boxes ([#8037]({{ site.repository }}/issues/8037))
- Non-deprecated `vendor/bundle` path configuration ([#8048]({{ site.repository }}/issues/8048))
- Update 09-collections.md ([#8060]({{ site.repository }}/issues/8060))
- Remove extra paragraph tags ([#8063]({{ site.repository }}/issues/8063))
- Add default front matter for tutorials collection ([#8081]({{ site.repository }}/issues/8081))
- Create CSV to table tutorial ([#8090]({{ site.repository }}/issues/8090))
- Add version badge for Custom Sorting of Documents ([#8098]({{ site.repository }}/issues/8098))
- Docs: Fix grammar in `_docs/front-matter.md` ([#8097]({{ site.repository }}/issues/8097))
- Update variables.md ([#8106]({{ site.repository }}/issues/8106))
- Add help about Gentoo/Linux ([#8002]({{ site.repository }}/issues/8002))
- Update documentation on third party site ([#8122]({{ site.repository }}/issues/8122))
- Added Clear Linux ([#8132]({{ site.repository }}/issues/8132))
- Added note about OS specific installation instructions. ([#8135]({{ site.repository }}/issues/8135))
- Fix broken URL in the Resources Page on the Documentation Site ([#8136]({{ site.repository }}/issues/8136))
- Docs: Deploy Jekyll site with GitHub Actions ([#8119]({{ site.repository }}/issues/8119))
- Clarify `bundle config` in Bundler tutorial ([#8150]({{ site.repository }}/issues/8150))
- docs: update your-first-plugin.md ([#8147]({{ site.repository }}/issues/8147))
- Fix typo in documentation on GitHub Actions ([#8162]({{ site.repository }}/issues/8162))
- Ease discovery of CLI commands (in their entirety) ([#8178]({{ site.repository }}/issues/8178))
- Remove `sudo` from Travis CI tutorial ([#8187]({{ site.repository }}/issues/8187))
- Add GitLab Pages to 3rd party list ([#8191]({{ site.repository }}/issues/8191))
- docs: add 21yunbox for deployment ([#8193]({{ site.repository }}/issues/8193))
- Improve documentation on tags and categories ([#8196]({{ site.repository }}/issues/8196))

### Development Fixes
{: #development-fixes-v4-1-0}

- Ci/GitHub actions ([#7822]({{ site.repository }}/issues/7822))
- Rubocop version upgrade ([#7846]({{ site.repository }}/issues/7846))
- Split action steps to avoid using `&&` on Windows ([#7885]({{ site.repository }}/issues/7885))
- Upgrade rake to use version 13 ([#7910]({{ site.repository }}/issues/7910))
- Update dependency constraint to allow RuboCop v0.76 ([#7893]({{ site.repository }}/issues/7893))
- Use bash executable consistently ([#7909]({{ site.repository }}/issues/7909))
- Test with JRuby 9.2.9.0 ([#7779]({{ site.repository }}/issues/7779))
- Bump RuboCop to v0.79.x ([#7970]({{ site.repository }}/issues/7970))
- Remove post-install message from gemspec ([#7974]({{ site.repository }}/issues/7974))
- Attain Ruby 3.0 compatibility ([#7948]({{ site.repository }}/issues/7948))
- Test `where` filter handling numeric property values ([#7821]({{ site.repository }}/issues/7821))
- chore(deps): rubocop 0.80.0 ([#8012]({{ site.repository }}/issues/8012))
- Update unit tests for Kramdown-based converter ([#8014]({{ site.repository }}/issues/8014))
- Add Visual Studio Code Development Container ([#8016]({{ site.repository }}/issues/8016))
- chore: simplify require for `Jekyll::VERSION` ([#8057]({{ site.repository }}/issues/8057))
- Remove version-constraint relaxation for i18n gem ([#8055]({{ site.repository }}/issues/8055))
- Mirror `spec.homepage` as `metadata["homepage_uri"]` ([#8056]({{ site.repository }}/issues/8056))
- Bump Ruby versions on Travis builds ([#8088]({{ site.repository }}/issues/8088))
- chore(ci): cache dependencies ([#8168]({{ site.repository }}/issues/8168))

### Site Enhancements
{: #site-enhancements-v4-1-0}

- Optimize rendering of the documentation site ([#8020]({{ site.repository }}/issues/8020))
- Utilize `relative_url` filter in documentation site ([#8089]({{ site.repository }}/issues/8089))
- Render tutorial metadata in documentation site ([#8092]({{ site.repository }}/issues/8092))
- Improve syntax-highlighting in documentation site ([#8079]({{ site.repository }}/issues/8079))
- Site: Filter through just the *docs* collection ([#8170]({{ site.repository }}/issues/8170))


## 4.0.1 / 2020-05-08
{: #v4-0-1}

### Bug Fixes
{: #bug-fixes-v4-0-1}

- Prevent console warning with Ruby 2.7 ([#8124]({{ site.repository }}/issues/8124))
- Clear cached Liquid template scope before render ([#8141]({{ site.repository }}/issues/8141))
- Add static file's basename to its url_placeholder ([#8142]({{ site.repository }}/issues/8142))
- Update item_property to recognize integers ([#8160]({{ site.repository }}/issues/8160))

### Development Fixes
{: #development-fixes-v4-0-1}

- Fix Kramdown converter based tests for v4.0.x ([#8143]({{ site.repository }}/issues/8143))


## 3.9.2 / 2022-03-27
{: #v3-9-2}

### Bug Fixes
{: #bug-fixes-v3-9-2}

- Lock `http_parser.rb` gem to `v0.6.x` on JRuby ([#8943]({{ site.repository }}/issues/8943))
- Backport [#8756]({{ site.repository }}/issues/8756) for v3.9.x: Respect collections_dir config within include tag ([#8795]({{ site.repository }}/issues/8795))
- Backport [#8965]({{ site.repository }}/issues/8965) for v3.9.x: Fix response header for content served via `jekyll serve` ([#8976]({{ site.repository }}/issues/8976))

### Development Fixes
{: #development-fixes-v3-9-2}

- Update and fix CI for `3.9-stable` on Ruby 3.x ([#8942]({{ site.repository }}/issues/8942))
- Fix CI for commits to `3.9-stable` branch ([#8788]({{ site.repository }}/issues/8788))


## 3.9.1 / 2021-04-08
{: #v3-9-1}

### Bug Fixes
{: #bug-fixes-v3-9-1}

- Backport [#8618]({{ site.repository }}/issues/8618) for v3.9.x: Update include tag to be more permissive ([#8629]({{ site.repository }}/issues/8629))


## 3.9.0 / 2020-08-05
{: #v3-9-0}

### Minor Enhancements
{: #minor-enhancements-v3-9-0}

- Allow use of kramdown v2 ([#8322]({{ site.repository }}/issues/8322))
- Add default language for kramdown syntax highlighting ([#8325]({{ site.repository }}/issues/8325))


## 3.8.7 / 2020-05-08
{: #v3-8-7}

### Bug Fixes
{: #bug-fixes-v3-8-7}

- Prevent console warnings with Ruby 2.7 ([#8125]({{ site.repository }}/issues/8125))


## 4.0.0 / 2019-08-19
{: #v4-0-0}

### Major Enhancements
{: #major-enhancements-v4-0-0}

- Drop ruby 2.3 ([#7454]({{ site.repository }}/issues/7454))
- Drop support for Ruby 2.1 and 2.2 ([#6560]({{ site.repository }}/issues/6560))
- Drop support for older versions of Rouge ([#6978]({{ site.repository }}/issues/6978))
- Drop support for pygments as syntax-highlighter ([#7118]({{ site.repository }}/issues/7118))
- Drop support for Redcarpet ([#6987]({{ site.repository }}/issues/6987))
- Drop support for rdiscount ([#6988]({{ site.repository }}/issues/6988))
- Drop support for `jekyll-watch-1.4.0` and older ([#7287]({{ site.repository }}/issues/7287))
- Incorporate `relative_url` filter in `link` tag ([#6727]({{ site.repository }}/issues/6727))
- Upgrade kramdown dependency to v2.x ([#7492]({{ site.repository }}/issues/7492))
- Upgrade jekyll-sass-converter to v2.x - Sassc + sourcemaps ([#7778]({{ site.repository }}/issues/7778))
- Upgrade i18n to v1.x ([#6931]({{ site.repository }}/issues/6931))
- Add `Jekyll::Cache` class to handle caching on disk ([#7169]({{ site.repository }}/issues/7169))
- Cache converted markdown ([#7159]({{ site.repository }}/issues/7159))
- Cache: Do not dump undumpable objects ([#7190]({{ site.repository }}/issues/7190))
- Cache matched defaults sets for given parameters ([#6888]({{ site.repository }}/issues/6888))
- Ignore cache directory ([#7184]({{ site.repository }}/issues/7184))
- Add `Site#in_cache_dir` helper method ([#7160]({{ site.repository }}/issues/7160))
- Remove &#39;cache_dir&#39; during `jekyll clean` ([#7158]({{ site.repository }}/issues/7158))
- Cache parsed Liquid templates in memory ([#7136]({{ site.repository }}/issues/7136))
- Only read layouts from source_dir or theme_dir ([#6788]({{ site.repository }}/issues/6788))
- Allow custom sorting of collection documents ([#7427]({{ site.repository }}/issues/7427))
- Always exclude certain paths from being processed ([#7188]({{ site.repository }}/issues/7188))
- Remove Jekyll::Utils#strip_heredoc in favor of a Ruby &gt; 2.3 built in ([#7584]({{ site.repository }}/issues/7584))
- Incorporate `relative_url` within `post_url` tag ([#7589]({{ site.repository }}/issues/7589))
- Remove patch to modify config for kramdown ([#7699]({{ site.repository }}/issues/7699))

### Minor Enhancements
{: #minor-enhancements-v4-0-0}

- Enhance `--blank` scaffolding ([#7310]({{ site.repository }}/issues/7310))
- Use `jekyll-compose` if installed ([#6932]({{ site.repository }}/issues/6932))
- Disable Liquid via front matter ([#6824]({{ site.repository }}/issues/6824))
- Configure cache_dir ([#7232]({{ site.repository }}/issues/7232))
- ISO week date drops ([#5981]({{ site.repository }}/issues/5981))
- Fix custom 404 page for GitHub pages ([#7132]({{ site.repository }}/issues/7132))
- Load config file from within current theme-gem ([#7304]({{ site.repository }}/issues/7304))
- Suggest re-running command with `--trace` on fail ([#6551]({{ site.repository }}/issues/6551))
- Support for binary operators in where_exp filter ([#6998]({{ site.repository }}/issues/6998))
- Automatically load `_config.toml` ([#7299]({{ site.repository }}/issues/7299))
- Add vendor folder to a newly installed site&#39;s .gitignore ([#6968]({{ site.repository }}/issues/6968))
- Output Jekyll Version while debugging ([#7173]({{ site.repository }}/issues/7173))
- Memoize computing excerpt&#39;s relative_path ([#6951]({{ site.repository }}/issues/6951))
- Skip processing posts that can not be read ([#7302]({{ site.repository }}/issues/7302))
- Memoize the return value of Site#documents ([#7273]({{ site.repository }}/issues/7273))
- Cache globbed paths in front matter defaults ([#7345]({{ site.repository }}/issues/7345))
- Cache computed item property ([#7301]({{ site.repository }}/issues/7301))
- Cleanup Markdown converter ([#7519]({{ site.repository }}/issues/7519))
- Do not process Liquid in post excerpt when disabled in front matter ([#7146]({{ site.repository }}/issues/7146))
- Liquefied link tag ([#6269]({{ site.repository }}/issues/6269))
- Update item_property to return numbers as numbers instead of strings ([#6608]({{ site.repository }}/issues/6608))
- Use `.markdown` extension for page templates ([#7126]({{ site.repository }}/issues/7126))
- Add support for `*.xhtml` files ([#6854]({{ site.repository }}/issues/6854))
- Allow i18n v0.9.5 and higher ([#7044]({{ site.repository }}/issues/7044))
- Ignore permission error of /proc/version ([#7267]({{ site.repository }}/issues/7267))
- Strip extra slashes via `Jekyll.sanitized_path` ([#7182]({{ site.repository }}/issues/7182))
- Site template: remove default config for markdown ([#7285]({{ site.repository }}/issues/7285))
- Add a custom inspect string for StaticFile objects ([#7422]({{ site.repository }}/issues/7422))
- Remind user to include gem in the Gemfile on error ([#7476]({{ site.repository }}/issues/7476))
- Search Front matter defaults for Page objects with relative_path ([#7261]({{ site.repository }}/issues/7261))
- Lock use of `tzinfo` gem to v1.x ([#7521]({{ site.repository }}/issues/7521), [#7562]({{ site.repository }}/issues/7562))
- Utilize absolute paths of user-provided file paths ([#7450]({{ site.repository }}/issues/7450))
- Detect `nil` and empty values in objects with `where` filter ([#7580]({{ site.repository }}/issues/7580))
- Initialize mutations for Drops only if necessary ([#7657]({{ site.repository }}/issues/7657))
- Reduce Array allocations via Jekyll::Cleaner ([#7659]({{ site.repository }}/issues/7659))
- Encode and unencode urls only as required ([#7654]({{ site.repository }}/issues/7654))
- Reduce string allocations with better alternatives ([#7643]({{ site.repository }}/issues/7643))
- Reduce allocations from Jekyll::Document instances ([#7625]({{ site.repository }}/issues/7625))
- Add `type` attribute to Document instances ([#7406]({{ site.repository }}/issues/7406))
- Reduce allocations from where-filter ([#7653]({{ site.repository }}/issues/7653))
- Memoize SiteDrop#documents to reduce allocations ([#7697]({{ site.repository }}/issues/7697))
- Add PathManager class to cache interim paths ([#7732]({{ site.repository }}/issues/7732))
- Remove warnings and fixes for deprecated config ([#7440]({{ site.repository }}/issues/7440))
- Delegate --profile tabulation to `terminal-table` ([#7627]({{ site.repository }}/issues/7627))

### Bug Fixes
{: #bug-fixes-v4-0-0}

- Security: fix `include` bypass of `EntryFilter#filter` symlink check ([#7226]({{ site.repository }}/issues/7226))
- Theme gems: ensure directories aren&#39;t symlinks ([#7419]({{ site.repository }}/issues/7419))
- Add call to unused method `validate_options` in `commands/serve.rb` ([#7122]({{ site.repository }}/issues/7122))
- Check if scope applies to type before given path ([#7263]({{ site.repository }}/issues/7263))
- Document two methods, simplify one of the methods ([#7270]({{ site.repository }}/issues/7270))
- Check key in collections only if it isn&#39;t &#34;posts&#34; ([#7277]({{ site.repository }}/issues/7277))
- Interpolate Jekyll::Page subclass on inspection ([#7203]({{ site.repository }}/issues/7203))
- Measure the no. of times a template gets rendered ([#7316]({{ site.repository }}/issues/7316))
- Reduce array traversal in Jekyll::Reader ([#7157]({{ site.repository }}/issues/7157))
- Re-implement handling Liquid blocks in excerpts ([#7250]({{ site.repository }}/issues/7250))
- Documents should be able to render their date ([#7404]({{ site.repository }}/issues/7404))
- Fix Interpreter warning from Jekyll::Renderer ([#7448]({{ site.repository }}/issues/7448))
- Loggers should accept both numbers and symbols ([#6967]({{ site.repository }}/issues/6967))
- Replace regex arg to :gsub with a string arg ([#7189]({{ site.repository }}/issues/7189))
- Dont write static files from unrendered collection ([#7410]({{ site.repository }}/issues/7410))
- Excerpt handling of custom and intermediate tags ([#7382]({{ site.repository }}/issues/7382))
- Change future post loglevel to warn to help user narrow down issues ([#7527]({{ site.repository }}/issues/7527))
- Handle files with trailing dots in their basename ([#7315]({{ site.repository }}/issues/7315))
- Fix unnecessary allocations via StaticFileReader ([#7572]({{ site.repository }}/issues/7572))
- Don&#39;t check if site URL is absolute if it is nil ([#7498]({{ site.repository }}/issues/7498))
- Avoid unnecessary duplication of pages array ([#7272]({{ site.repository }}/issues/7272))
- Memoize Site#post_attr_hash ([#7276]({{ site.repository }}/issues/7276))
- Memoize Document#excerpt_separator ([#7569]({{ site.repository }}/issues/7569))
- Optimize Document::DATE_FILENAME_MATCHER to match valid filenames ([#7292]({{ site.repository }}/issues/7292))
- Escape valid special chars in a site&#39;s path name ([#7568]({{ site.repository }}/issues/7568))
- Replace `name` in Page#inspect with relative_path ([#7434]({{ site.repository }}/issues/7434))
- Log a warning when the slug is empty ([#7357]({{ site.repository }}/issues/7357))
- Push Markdown link refs to excerpt only as required ([#7577]({{ site.repository }}/issues/7577))
- Fix broken include_relative usage in excerpt ([#7633]({{ site.repository }}/issues/7633))
- Initialize and reset glob_cache only as necessary ([#7658]({{ site.repository }}/issues/7658))
- Revert memoizing Site#docs_to_write and #documents ([#7684]({{ site.repository }}/issues/7684))
- Backport [#7684]({{ site.repository }}/issues/7684) for v3.8.x: Revert memoizing Site#docs_to_write and refactor #documents ([#7689]({{ site.repository }}/issues/7689))
- Backport [#7213]({{ site.repository }}/issues/7213) and [#7633]({{ site.repository }}/issues/7633) for v3.8.x: Fix broken include_relative usage in excerpt ([#7690]({{ site.repository }}/issues/7690))
- Don&#39;t read symlinks in site.include in safe mode ([#7711]({{ site.repository }}/issues/7711))
- Replace `String#=~` with `String#match?` ([#7723]({{ site.repository }}/issues/7723))
- Update log output for an invalid theme directory ([#7679]({{ site.repository }}/issues/7679))
- Remove configuration of theme sass files from Core ([#7290]({{ site.repository }}/issues/7290))
- Actually conditionally include liquid-c ([#7792]({{ site.repository }}/issues/7792))
- Test number_like regex on stringified property ([#7788]({{ site.repository }}/issues/7788))

### Development Fixes
{: #development-fixes-v4-0-0}

- Upgrade liquid-c to v4.0 ([#7375]({{ site.repository }}/issues/7375))
- Bump RuboCop to v0.71.0 ([#7687]({{ site.repository }}/issues/7687))
- Target Ruby 2.4 syntax ([#7583]({{ site.repository }}/issues/7583))
- Fix: RuboCop offenses ([#7769]({{ site.repository }}/issues/7769))
- Use communicative method parameters ([#7566]({{ site.repository }}/issues/7566))
- Scan `assert_equal` methods and rectify any offenses with a custom RuboCop cop ([#7130]({{ site.repository }}/issues/7130))
- CI: Test with Ruby 2.6 ([#7438]({{ site.repository }}/issues/7438))
- CI: Test with Ruby 2.6 on AppVeyor ([#7518]({{ site.repository }}/issues/7518))
- CI: Update RuboCop config ([#7050]({{ site.repository }}/issues/7050))
- CI: Add a script to profile docs ([#7540]({{ site.repository }}/issues/7540))
- CI(Appveyor): shallow clone with 5 last commits ([#7312]({{ site.repository }}/issues/7312))
- CI: Test with oldest and latest Ruby only ([#7412]({{ site.repository }}/issues/7412))
- CI: Update excludes for CodeClimate Analyses ([#7365]({{ site.repository }}/issues/7365))
- CI: Lock Travis to Bundler-1.16.2 ([#7144]({{ site.repository }}/issues/7144))
- CI: Bump tested version of JRuby to 9.2.7.0 ([#7612]({{ site.repository }}/issues/7612))
- CI: Do not install docs on updating gems on Travis ([#7706]({{ site.repository }}/issues/7706))
- Update gemspec ([#7425]({{ site.repository }}/issues/7425))
- deps: relax version constraint on classifier-reborn gem ([#7471]({{ site.repository }}/issues/7471))
- deps: update yajl-ruby ([#7278]({{ site.repository }}/issues/7278))
- deps: bump yajl-ruby to v1.4.0 ([#6976]({{ site.repository }}/issues/6976))
- Create symlink only if target is accessible ([#7429]({{ site.repository }}/issues/7429))
- Switch to `:install_if` for wdm gem ([#7372]({{ site.repository }}/issues/7372))
- Add cucumber feature to test include_relative tag ([#7213]({{ site.repository }}/issues/7213))
- Small benchmark refactoring ([#7211]({{ site.repository }}/issues/7211))
- Fix incorrectly passed arguments to assert_equal ([#7134]({{ site.repository }}/issues/7134))
- fix up refute_equal call ([#7133]({{ site.repository }}/issues/7133))
- Fix RuboCop offences in test files ([#7128]({{ site.repository }}/issues/7128))
- Use assert_include ([#7093]({{ site.repository }}/issues/7093))
- Remember to release docs gem ([#7066]({{ site.repository }}/issues/7066))
- Useless privates removed ([#6768]({{ site.repository }}/issues/6768))
- Load Rouge for TestKramdown ([#7007]({{ site.repository }}/issues/7007))
- Update instructions for releasing docs Gem ([#6975]({{ site.repository }}/issues/6975))
- We are not using Ruby 2.2 anymore ([#6977]({{ site.repository }}/issues/6977))
- Remove unnecessary Jekyll::Page constant ([#6770]({{ site.repository }}/issues/6770))
- Remove unused error class ([#6511]({{ site.repository }}/issues/6511))
- Add a Cucumber feature for post_url tag ([#7586]({{ site.repository }}/issues/7586))
- Generate a &#34;TOTAL&#34; row for build-profile table ([#7614]({{ site.repository }}/issues/7614))
- Refactor Jekyll::Cache ([#7532]({{ site.repository }}/issues/7532))
- Store list of expected extnames in a constant ([#7638]({{ site.repository }}/issues/7638))
- Profile allocations from a build session ([#7646]({{ site.repository }}/issues/7646))
- Update small typo in contributing.md ([#7671]({{ site.repository }}/issues/7671))
- Remove override to Jekyll::Document#respond_to? ([#7695]({{ site.repository }}/issues/7695))
- Update TestTags in sync with Rouge v3.4 ([#7709]({{ site.repository }}/issues/7709))
- Use regexp to filter special entries ([#7702]({{ site.repository }}/issues/7702))
- Reduce Array objects generated from utility method ([#7749]({{ site.repository }}/issues/7749))
- Update mime.types ([#7756]({{ site.repository }}/issues/7756))
- Replace redundant Array#map with Array#each ([#7761]({{ site.repository }}/issues/7761))
- Reduce allocations by using #each_with_object ([#7758]({{ site.repository }}/issues/7758))
- Memoize fallback_data for Drop ([#7728]({{ site.repository }}/issues/7728))
- Use String#end_with? to check if entry is a backup ([#7701]({{ site.repository }}/issues/7701))

### Documentation

- Refactor docs ([#7205]({{ site.repository }}/issues/7205))
- Add a link to Giraffe Academy&#39;s tutorial ([#7325]({{ site.repository }}/issues/7325))
- Do not advise users to install Jekyll outside of Bundler ([#6927]({{ site.repository }}/issues/6927))
- Remove documentation for using Redcarpet ([#6990]({{ site.repository }}/issues/6990))
- Install Docs that Work on MacOS 10.14 ([#7561]({{ site.repository }}/issues/7561))
- Add Installation Instructions for Ubuntu ([#6925]({{ site.repository }}/issues/6925))
- Don&#39;t prompt for sudo when installing with Ubuntu WSL ([#6781]({{ site.repository }}/issues/6781))
- Installation instructions for Fedora ([#7198]({{ site.repository }}/issues/7198))
- Update Windows install docs ([#6926]({{ site.repository }}/issues/6926))
- List all standard liquid filters ([#7333]({{ site.repository }}/issues/7333))
- List all static files variables ([#7002]({{ site.repository }}/issues/7002))
- Improve how to include Rouge stylesheets ([#7752]({{ site.repository }}/issues/7752))
- Mention CommonMark plugins ([#7418]({{ site.repository }}/issues/7418))
- Add TSV to list of supported _data files. ([#7168]({{ site.repository }}/issues/7168))
- How to deploy using pre-push git hook ([#7179]({{ site.repository }}/issues/7179))
- Hosting with AWS Amplify ([#7510]({{ site.repository }}/issues/7510))
- CircleCI deployment through CircleCI v2 ([#7024]({{ site.repository }}/issues/7024))
- GitHub Pages: use themes from other repos ([#7112]({{ site.repository }}/issues/7112))
- Document page.dir and page.name ([#7373]({{ site.repository }}/issues/7373))
- Document custom tag blocks ([#7359]({{ site.repository }}/issues/7359))
- Document converter methods ([#7289]({{ site.repository }}/issues/7289))
- Document {% raw %}`{{ page.collection }}`{% endraw %} ([#7430]({{ site.repository }}/issues/7430))
- Document Jekyll Filters with YAML data ([#7335]({{ site.repository }}/issues/7335))
- Document where Jekyll looks for layouts in a site ([#7564]({{ site.repository }}/issues/7564))
- plugin: liquid tag jekyll-flickr ([#6946]({{ site.repository }}/issues/6946))
- plugin: jekyll-target-blank ([#7046]({{ site.repository }}/issues/7046))
- plugin: json-get. ([#7086]({{ site.repository }}/issues/7086))
- plugin: `jekyll-info` ([#7091]({{ site.repository }}/issues/7091))
- plugin: jekyll-xml-source ([#7114]({{ site.repository }}/issues/7114))
- plugin: jekyll-firstimage filter ([#7127]({{ site.repository }}/issues/7127))
- plugin: CAT ([#7011]({{ site.repository }}/issues/7011))
- Resources: Statictastic ([#7593]({{ site.repository }}/issues/7593))
- Resources: Bonsai Search ([#7543]({{ site.repository }}/issues/7543))
- Resources: Formspark ([#7601]({{ site.repository }}/issues/7601))
- Resources: Jekpack([#7598]({{ site.repository }}/issues/7598))
- Resources: formX ([#7536]({{ site.repository }}/issues/7536))
- Resources: 99inbound&#39;s Jekyll post ([#7348]({{ site.repository }}/issues/7348))
- Resources: CloudSh ([#7497]({{ site.repository }}/issues/7497))
- Community:  DEV Community&#39;s Jekyll tag ([#7139]({{ site.repository }}/issues/7139))
- Showcase: developer.spotify.com ([#7217]({{ site.repository }}/issues/7217))
- Showcase: Isomer ([#7300]({{ site.repository }}/issues/7300))
- Add version number for group_by_exp doc ([#6956]({{ site.repository }}/issues/6956))
- Updated nginx configuration for custom-404-page documentation ([#6994]({{ site.repository }}/issues/6994))
- Clarify definition of &#39;draft&#39; ([#7037]({{ site.repository }}/issues/7037))
- _drafts need to be contained within the custom collection directory ([#6985]({{ site.repository }}/issues/6985))
- Updated to supported version ([#7031]({{ site.repository }}/issues/7031))
- Add Hints for some Improved Travis Config in Doc ([#7049]({{ site.repository }}/issues/7049))
- Update travis-ci.md to point out &#34;this is an example Gemfile&#34; ([#7089]({{ site.repository }}/issues/7089))
- Instructions to view theme’s files under Linux ([#7095]({{ site.repository }}/issues/7095))
- Use a real theme in the example ([#7125]({{ site.repository }}/issues/7125))
- Update docs about post creation ([#7138]({{ site.repository }}/issues/7138))
- Initialize upgrading doc for v4.0 ([#7140]({{ site.repository }}/issues/7140))
- Add version badge for date filters with ordinal ([#7162]({{ site.repository }}/issues/7162))
- Corrected sample usage of postfiles ([#7181]({{ site.repository }}/issues/7181))
- Resolve &#34;Unable to locate package ruby2.4&#34; error ([#7196]({{ site.repository }}/issues/7196))
- Correct stylesheet url in tutorial step 7 ([#7210]({{ site.repository }}/issues/7210))
- Removes quotes from markdown for assets ([#7223]({{ site.repository }}/issues/7223))
- Clarified front matter requirement ([#7234]({{ site.repository }}/issues/7234))
- Explicit location of where to create blog.html ([#7241]({{ site.repository }}/issues/7241))
- Reference the build command options that allows multiple config files ([#7266]({{ site.repository }}/issues/7266))
- Add more issue template(s) and pull request template ([#7269]({{ site.repository }}/issues/7269))
- Suggest sites use OpenSSL instead of GnuTLS for their site&#39;s CI ([#7010]({{ site.repository }}/issues/7010))
- Fix broken Contributors link in README.markdown ([#7200]({{ site.repository }}/issues/7200))
- Add title tag to item in RSS template ([#7282]({{ site.repository }}/issues/7282))
- Add link tag to item in RSS template ([#7291]({{ site.repository }}/issues/7291))
- Remove redundant instruction comment ([#7342]({{ site.repository }}/issues/7342))
- Textile is only supported through a converter plugin ([#7003]({{ site.repository }}/issues/7003))
- Add recursive navigation tutorial ([#7720]({{ site.repository }}/issues/7720))
- Remove installation instructions with Homebrew ([#7381]({{ site.repository }}/issues/7381))
- Fix dead link and misleading prose ([#7383]({{ site.repository }}/issues/7383))
- Fix content management section ([#7385]({{ site.repository }}/issues/7385))
- Apply ruby official guide documents ([#7393]({{ site.repository }}/issues/7393))
- Fix group_by_exp filter example ([#7394]({{ site.repository }}/issues/7394))
- Remove alt attribute from a tags ([#7407]({{ site.repository }}/issues/7407))
- Fix BASH code-block in ubuntu.md ([#7420]({{ site.repository }}/issues/7420))
- zlib is missing ([#7428]({{ site.repository }}/issues/7428))
- Fixed unnecessary articles and pronouns ([#7466]({{ site.repository }}/issues/7466))
- Store SSL key and cert in site source ([#7473]({{ site.repository }}/issues/7473))
- Fix typo in tutorial for converting existing site ([#7524]({{ site.repository }}/issues/7524))
- Check if var exists before include tag ([#7530]({{ site.repository }}/issues/7530))
- Clarify docs on collections regarding the need for front matter ([#7538]({{ site.repository }}/issues/7538))
- Fix incorrect Windows path in themes.md ([#7525]({{ site.repository }}/issues/7525))
- Addresses bundle not found. ([#7351]({{ site.repository }}/issues/7351))
- Update the contribution docs for draft pull requests ([#7619]({{ site.repository }}/issues/7619))
- Data file section adds TSV ([#7640]({{ site.repository }}/issues/7640))
- Indicate where the _sass folder is by default ([#7644]({{ site.repository }}/issues/7644))
- Docs: add version tags to new placeholders ([#5981]({{ site.repository }}/issues/5981)) for permalinks ([#7647]({{ site.repository }}/issues/7647))
- Solve &#34;GitHub Page build failure&#34; in 10-deployment.md ([#7648]({{ site.repository }}/issues/7648))
- fix link to Site Source config ([#7708]({{ site.repository }}/issues/7708))
- Introduce frontmatter in step 2 ([#7704]({{ site.repository }}/issues/7704))
- Add @ashmaroli to Core Team listing ([#7398]({{ site.repository }}/issues/7398))
- Link to Tidelift in site&#39;s footer ([#7377]({{ site.repository }}/issues/7377))
- Link to OpenCollective backing ([#7378]({{ site.repository }}/issues/7378)
- Link to sponsor listing in README ([#7405]({{ site.repository }}/issues/7405))
- Adjust team page listings ([#7395]({{ site.repository }}/issues/7395))
- Updates to CODE OF CONDUCT (v1.4.0) ([#7105]({{ site.repository }}/issues/7105))
- More inclusive writing ([#7283]({{ site.repository }}/issues/7283))
- Update Ruby version used in Travis-CI example ([#7783]({{ site.repository }}/issues/7783))
- Documentation for binary operators in where_exp ([#7786]({{ site.repository }}/issues/7786))
- Adding SmartForms as Forms service ([#7794]({{ site.repository }}/issues/7794))

### Site Enhancements
{: #site-enhancements-v4-0-0}

- Better Performance ([#7388]({{ site.repository }}/issues/7388))
- Add some minor improvements to image loading in Showcase page ([#7214]({{ site.repository }}/issues/7214))
- Simplify assigning classname to docs&#39; aside-links ([#7609]({{ site.repository }}/issues/7609))
- Simplify couple of includes in the docs site ([#7607]({{ site.repository }}/issues/7607))
- Avoid generating empty classnames ([#7610]({{ site.repository }}/issues/7610))
- Minimize rendering count ([#7343]({{ site.repository }}/issues/7343))

### Release

- Jekyll v4.0 release ([#7782]({{ site.repository }}/issues/7782))
- Release post for v4.0.0 beta1 ([#7716]({{ site.repository }}/issues/7716))
- Release post for v4.0.0.pre.alpha1 ([#7574]({{ site.repository }}/issues/7574))
- Release post for v3.8.0 ([#6849]({{ site.repository }}/issues/6849))
- Release post for v3.6.3, v3.7.4 and v3.8.4 ([#7259]({{ site.repository }}/issues/7259))
- Post: v4.0 development ([#6934]({{ site.repository }}/issues/6934))


## 3.8.6 / 2019-07-02
{: #v3-8-6}

### Bug Fixes
{: #bug-fixes-v3-8-6}

- Update log output for an invalid theme directory ([#7734]({{ site.repository }}/issues/7734))
- Memoize `SiteDrop#documents` to reduce allocations ([#7722]({{ site.repository }}/issues/7722))
- Excerpt handling of custom and intermediate tags ([#7467]({{ site.repository }}/issues/7467))
- Escape valid special chars in a site's path name ([#7573]({{ site.repository }}/issues/7573))
- Revert memoizing `Site#docs_to_write` and refactor `#documents` ([#7689]({{ site.repository }}/issues/7689))
- Fix broken `include_relative` usage in excerpt ([#7690]({{ site.repository }}/issues/7690))
- Install platform-specific gems as required (3c06609406)

### Security Fixes
{: #security-fixes-v3-8-6}

- Theme gems: ensure directories aren't symlinks ([#7424]({{ site.repository }}/issues/7424))


## 3.8.5 / 2018-11-04
{: #v3-8-5}

### Bug Fixes
{: #bug-fixes-v3-8-5}

- Re-implement handling Liquid blocks in excerpts ([#7250]({{ site.repository }}/issues/7250))


## 3.8.4 / 2018-09-18
{: #v3-8-4}

### Bug Fixes
{: #bug-fixes-v3-8-4}

- 3.8.x: security: fix `include` bypass of `EntryFilter#filter` symlink check ([#7228]({{ site.repository }}/issues/7228))


## 3.8.3 / 2018-06-05
{: #v3-8-3}

### Bug Fixes
{: #bug-fixes-v3-8-3}

- Fix --unpublished not affecting collection documents ([#7027]({{ site.repository }}/issues/7027))


## 3.8.2 / 2018-05-18
{: #v3-8-2}

### Development Fixes
{: #development-fixes-v3-8-2}

- Update rubocop version ([#7016]({{ site.repository }}/issues/7016))

### Bug Fixes
{: #bug-fixes-v3-8-2}

- Add whitespace control to LIQUID_TAG_REGEX ([#7015]({{ site.repository }}/issues/7015))


## 3.8.1 / 2018-05-01
{: #v3-8-1}

### Bug Fixes
{: #bug-fixes-v3-8-1}

- Fix rendering Liquid constructs in excerpts ([#6945]({{ site.repository }}/issues/6945))
- Liquify documents unless published == false ([#6959]({{ site.repository }}/issues/6959))


## 3.8.0 / 2018-04-19
{: #v3-8-0}

### Development Fixes
{: #development-fixes-v3-8-0}

- move duplicate code to a single private method ([#6593]({{ site.repository }}/issues/6593))
- Test against Ruby 2.5 on AppVeyor ([#6668]({{ site.repository }}/issues/6668))
- Replace simple regex with a native Ruby method ([#6732]({{ site.repository }}/issues/6732))
- Codeclimate: exclude livereload.js ([#6776]({{ site.repository }}/issues/6776))
- Add a cucumber feature to test link tag ([#6777]({{ site.repository }}/issues/6777))
- Fix theme gem feature ([#6784]({{ site.repository }}/issues/6784))
- Replace simple regex with equivalent Ruby methods ([#6736]({{ site.repository }}/issues/6736))
- Rewrite `script/rubyprof` as a Ruby script ([#6813]({{ site.repository }}/issues/6813))
- Add debug output to theme rendering ([#5195]({{ site.repository }}/issues/5195))
- fix minitest deprecation warning in test ([#6839]({{ site.repository }}/issues/6839))
- Memoize `Site#site_data` ([#6809]({{ site.repository }}/issues/6809))
- Memoize document output extension ([#6814]({{ site.repository }}/issues/6814))
- Access document permalink attribute efficiently ([#6740]({{ site.repository }}/issues/6740))
- Minimize array allocations in the `where` filter ([#6860]({{ site.repository }}/issues/6860))
- Bump JRuby ([#6878]({{ site.repository }}/issues/6878))
- Assert existence of &lt;collection&gt;.files ([#6907]({{ site.repository }}/issues/6907))
- Bump RuboCop to 0.54.x ([#6915]({{ site.repository }}/issues/6915))
- Regenerate unconditionally unless its an incremental build ([#6917]({{ site.repository }}/issues/6917))
- Centralize require statements ([#6910]({{ site.repository }}/issues/6910))
- Bump to RuboCop 0.55 ([#6929]({{ site.repository }}/issues/6929))
- Refactor private method `HighlightBlock#parse_options` ([#6822]({{ site.repository }}/issues/6822))

### Minor Enhancements
{: #minor-enhancements-v3-8-0}

- Two massive performance improvements for large sites ([#6730]({{ site.repository }}/issues/6730))
- Cache the list of documents to be written ([#6741]({{ site.repository }}/issues/6741))
- Allow Jekyll Doctor to detect stray posts dir ([#6681]({{ site.repository }}/issues/6681))
- Excerpt relative-path should match its path ([#6597]({{ site.repository }}/issues/6597))
- Remind user to resolve conflict in `jekyll new` with `--force` ([#6801]({{ site.repository }}/issues/6801))
- Memoize helper methods in site-cleaner ([#6808]({{ site.repository }}/issues/6808))
- Compute document&#39;s relative_path faster ([#6767]({{ site.repository }}/issues/6767))
- Create a single instance of PostReader per site ([#6759]({{ site.repository }}/issues/6759))
- Allow date filters to output ordinal days ([#6773]({{ site.repository }}/issues/6773))
- Change regex to sanitize and normalize filenames passed to LiquidRenderer ([#6610]({{ site.repository }}/issues/6610))
- Allow passing :strict_variables and :strict_filters options to Liquid&#39;s renderer ([#6726]({{ site.repository }}/issues/6726))
- Debug writing files during the build process ([#6696]({{ site.repository }}/issues/6696))
- Improve regex usage in `Tags::IncludeTag` ([#6848]({{ site.repository }}/issues/6848))
- Improve comment included in the starter index.md ([#6916]({{ site.repository }}/issues/6916))
- Store and retrieve converter instances for Jekyll::Filters via a hash ([#6856]({{ site.repository }}/issues/6856))
- Implement a cache within the `where` filter ([#6868]({{ site.repository }}/issues/6868))
- Store regexp in a constant ([#6887]({{ site.repository }}/issues/6887))
- Optimize computing filename in LiquidRenderer ([#6841]({{ site.repository }}/issues/6841))

### Documentation

- Adding the jekyll-algolia plugin to the list of plugins ([#6737]({{ site.repository }}/issues/6737))
- Added Premonition plugin to list of plugins ([#6750]({{ site.repository }}/issues/6750))
- Add document on releasing a new version ([#6745]({{ site.repository }}/issues/6745))
- Mention Talkyard, a new commenting system for Jekyll and others. ([#6752]({{ site.repository }}/issues/6752))
- Add &#39;jekyll-fontello&#39; to plugins ([#6757]({{ site.repository }}/issues/6757))
- Install dh-autoreconf on Windows ([#6765]({{ site.repository }}/issues/6765))
- Fix common typos ([#6764]({{ site.repository }}/issues/6764))
- Fix documentation for {% raw %}`{{ page.excerpt }}`{% endraw %} ([#6779]({{ site.repository }}/issues/6779))
- Update docs on permalink configuration ([#6775]({{ site.repository }}/issues/6775))
- Propose fix some typos ([#6785]({{ site.repository }}/issues/6785))
- Say hello to Jekyll&#39;s New Lead Developer ([#6790]({{ site.repository }}/issues/6790))
- Add reference to Liquid to plugin docs ([#6794]({{ site.repository }}/issues/6794))
- Draft a release post for v3.7.3 ([#6803]({{ site.repository }}/issues/6803))
- add missing step for gem-based theme conversion ([#6802]({{ site.repository }}/issues/6802))
- Update windows.md to explain an issue with jekyll new. ([#6838]({{ site.repository }}/issues/6838))
- Add Bundler Installation Instructions ([#6828]({{ site.repository }}/issues/6828))
- Docs: describe difference between tags and categories ([#6882]({{ site.repository }}/issues/6882))
- Add `jekyll-random` plugin to docs ([#6833]({{ site.repository }}/issues/6833))
- Fixed typo in description of categories and tags ([#6896]({{ site.repository }}/issues/6896))
- Add missing ul-tag ([#6897]({{ site.repository }}/issues/6897))
- doc: add liquid tag plugin jekyll-onebox for html previews ([#6898]({{ site.repository }}/issues/6898))
- Add `jekyll-w2m` to plugins ([#6855]({{ site.repository }}/issues/6855))
- Fix tutorials navigation HTML ([#6919]({{ site.repository }}/issues/6919))
- add Arch Linux installation troubleshoot ([#6782]({{ site.repository }}/issues/6782))
- Docs: Install Jekyll on macOS ([#6881]({{ site.repository }}/issues/6881))
- Fix CodeClimate badges [ci skip] ([#6930]({{ site.repository }}/issues/6930))
- Update index.md ([#6933]({{ site.repository }}/issues/6933))

### Site Enhancements
{: #site-enhancements-v3-8-0}

- Remove links to Gists ([#6751]({{ site.repository }}/issues/6751))
- Always load Google Fonts over HTTPS ([#6792]({{ site.repository }}/issues/6792))
- always load analytics.js over HTTPS ([#6807]({{ site.repository }}/issues/6807))

### Bug Fixes
{: #bug-fixes-v3-8-0}

- Append appropriate closing tag to Liquid block in an excerpt ### -minor ([#6724]({{ site.repository }}/issues/6724))
- Bypass rendering via Liquid unless required ([#6735]({{ site.repository }}/issues/6735))
- Delegated methods after `private` keyword are meant to be private ([#6819]({{ site.repository }}/issues/6819))
- Improve handling non-default collection documents rendering and writing ([#6795]({{ site.repository }}/issues/6795))
- Fix passing multiline params to include tag when using the variable syntax  ([#6858]({{ site.repository }}/issues/6858))
- `include_relative` tag should find related documents in collections gathered within custom `collections_dir` ([#6818]({{ site.repository }}/issues/6818))
- Handle liquid tags in excerpts robustly ([#6891]({{ site.repository }}/issues/6891))
- Allow front matter defaults to be applied properly to documents gathered under custom `collections_dir` ([#6885]({{ site.repository }}/issues/6885))


## 3.7.4 / 2018-09-07
{: #v3-7-4}

### Bug Fixes
{: #bug-fixes-v3-7-4}

- Security: fix `include` bypass of EntryFilter#filter symlink check ([#7224]({{ site.repository }}/issues/7224))


## 3.7.3 / 2018-02-25
{: #v3-7-3}

### Bug Fixes
{: #bug-fixes-v3-7-3}

- Do not hardcode locale unless certainly necessary ([#6791]({{ site.repository }}/issues/6791))


## 3.7.2 / 2018-01-25
{: #v3-7-2}

### Development Fixes
{: #development-fixes-v3-7-2}

- CI: Test against Ruby 2.5.0 ([#6664]({{ site.repository }}/issues/6664))
- Bump rdoc to 6.0 ([#6600]({{ site.repository }}/issues/6600))
- Lint file and bump theme dependencies ([#6698]({{ site.repository }}/issues/6698))
- Write a Rubocop Cop to ensure no `#p` or `#puts` calls get committed to master. ([#6615]({{ site.repository }}/issues/6615))
- Remove redgreen gem ([#6720]({{ site.repository }}/issues/6720))

### Site Enhancements
{: #site-enhancements-v3-7-2}

- Display latest version in header ([#6676]({{ site.repository }}/issues/6676))
- Update version in `config.yml` via YAML load / dump ([#6677]({{ site.repository }}/issues/6677))

### Documentation

- Fix: Add note about posts in context of collections_dir ([#6680]({{ site.repository }}/issues/6680))
- Update deploy-script in documentation ([#6666]({{ site.repository }}/issues/6666))
- Add note about naming of collections_dir ([#6703]({{ site.repository }}/issues/6703))
- Update installation.md ([#6694]({{ site.repository }}/issues/6694))
- Add `jekyll-html` to plugins. ([#6654]({{ site.repository }}/issues/6654))
- Update plugins.md ([#6716]({{ site.repository }}/issues/6716))
- Release v3.7.1 ([#6695]({{ site.repository }}/issues/6695))

### Bug Fixes
{: #bug-fixes-v3-7-2}

- inform that symlinks are not allowed in safe mode ([#6670]({{ site.repository }}/issues/6670))
- Glob scope path only if configured with a pattern ([#6692]({{ site.repository }}/issues/6692))
- Add gem &#34;wdm&#34; to all newly generated Gemfiles ([#6711]({{ site.repository }}/issues/6711))
- Fix timezone inconsistencies between different ruby version ([#6697]({{ site.repository }}/issues/6697))
- Refactor collections_dir feature for consistency ([#6685]({{ site.repository }}/issues/6685))

### Minor Enhancements
{: #minor-enhancements-v3-7-2}

- Require external library only if necessary ([#6596]({{ site.repository }}/issues/6596))


## 3.7.0 / 2018-01-02
{: #v3-7-0}

### Minor Enhancements
{: #minor-enhancements-v3-7-0}

- Add LiveReload functionality to Jekyll. ([#5142]({{ site.repository }}/issues/5142))
- Add Utils::Internet.connected? to determine whether host machine has internet connection. ([#5870]({{ site.repository }}/issues/5870))
- Disable default layouts for Pages with a `layout: none` declaration ([#6182]({{ site.repository }}/issues/6182))
- Scope path glob ([#6268]({{ site.repository }}/issues/6268))
- Allow the user to set collections_dir to put all collections under one subdirectory ([#6331]({{ site.repository }}/issues/6331))
- Upgrade to Rouge 3 ([#6381]({{ site.repository }}/issues/6381))
- Allow URL filters to work directly with documents ([#6478]({{ site.repository }}/issues/6478))
- filter relative_url should keep absolute urls with scheme/authority ([#6490]({{ site.repository }}/issues/6490))
- `.sass-cache` doesn&#39;t *always* land in `options[&#39;source&#39;]` ([#6500]({{ site.repository }}/issues/6500))
- Allow plugins to modify the obsolete files. ([#6502]({{ site.repository }}/issues/6502))
- Add latin mode to `slugify` ([#6509]({{ site.repository }}/issues/6509))
- Log Kramdown warnings if log level is WARN ([#6522]({{ site.repository }}/issues/6522))
- Add an option to configure kramdown warning output ([#6554]({{ site.repository }}/issues/6554))
- Add `json` extension to list of directory indices ([#6550]({{ site.repository }}/issues/6550))
- Dependency: Bump jekyll-watch to 2.0 ([#6589]({{ site.repository }}/issues/6589))
- Remove paginate check ([#6606]({{ site.repository }}/issues/6606))
- update classifier-reborn to 2.2.0 ([#6631]({{ site.repository }}/issues/6631))
- Switch to an actively-maintained TOML parser. ([#6652]({{ site.repository }}/issues/6652))
- Do not coerce layout paths in theme-gem to the source directory ([#6603]({{ site.repository }}/issues/6603))

### Bug Fixes
{: #bug-fixes-v3-7-0}

- Raise when theme root directory is not available ([#6455]({{ site.repository }}/issues/6455))
- Avoid block parser warning in SmartyPants ([#6565]({{ site.repository }}/issues/6565))
- Fail gracefully if &#34;sass&#34; gem cannot be loaded ([#6573]({{ site.repository }}/issues/6573))
- return correct file in dir if dir has same name as file ([#6569]({{ site.repository }}/issues/6569))
- Register reload hooks in Server#process ([#6605]({{ site.repository }}/issues/6605))
- Memoize path to metadata file ([#6602]({{ site.repository }}/issues/6602))
- Use `require_relative` to load Jekyll classes ([#6609]({{ site.repository }}/issues/6609))

### Development Fixes
{: #development-fixes-v3-7-0}

- Added direct collection access to future collection item feature test([#6151]({{ site.repository }}/issues/6151))
- add failing test for non-utf8 encoding ([#6339]({{ site.repository }}/issues/6339))
- Upgrade to Cucumber 3.0 ([#6395]({{ site.repository }}/issues/6395))
- Provide a better default hash for tracking liquid stats ([#6417]({{ site.repository }}/issues/6417))
- Add configuration for first-timers bot ([#6431]({{ site.repository }}/issues/6431))
- Do not linkify escaped characters as PRs in History ([#6468]({{ site.repository }}/issues/6468))
- Rely on jekyll-mentions for linking usernames ([#6469]({{ site.repository }}/issues/6469))
- Update first-timers-issue-template.md ([#6472]({{ site.repository }}/issues/6472))
- Enable `Lint/RescueWithoutErrorClass` Cop ([#6482]({{ site.repository }}/issues/6482))
- Clean up Rubocop config ([#6495]({{ site.repository }}/issues/6495))
- Use Gem to discover the location of bundler ([#6499]({{ site.repository }}/issues/6499))
- Remove unnecessary encoding comment ([#6513]({{ site.repository }}/issues/6513))
- Suggest using Rubocop to automatically fix errors ([#6514]({{ site.repository }}/issues/6514))
- Assert raising Psych::SyntaxError when`&#34;strict_front_matter&#34;=&gt;true` ([#6520]({{ site.repository }}/issues/6520))
- Use Kernel#Array instead of explicit Array check ([#6525]({{ site.repository }}/issues/6525))
- RuboCop: Enable `Style/UnneededCapitalW` cop ([#6526]({{ site.repository }}/issues/6526))
- Refactor method to reduce ABC Metric size ([#6529]({{ site.repository }}/issues/6529))
- Remove parentheses around arguments to raise ([#6532]({{ site.repository }}/issues/6532))
- Use double-quotes around gem name ([#6535]({{ site.repository }}/issues/6535))
- Dependencies: upgrade to toml 0.2.0 ([#6541]({{ site.repository }}/issues/6541))
- Lock to cucumber 3.0.1 on Ruby 2.1 ([#6546]({{ site.repository }}/issues/6546))
- Bump JRuby version in Travis config ([#6561]({{ site.repository }}/issues/6561))
- Rescue from Psych::SyntaxError instead of SyntaxError after parsing YAML([#5828]({{ site.repository }}/issues/5828))
- Drop forwarding to private methods by exposing those methods as public([#6577]({{ site.repository }}/issues/6577))
- Upgrade pygments to v1.x ([#5937]({{ site.repository }}/issues/5937))
- Bump yajl-ruby ([#6582]({{ site.repository }}/issues/6582))
- Cleanup test_redcarpet.rb ([#6584]({{ site.repository }}/issues/6584))
- Add PageWithoutAFile class from jekyll plugins ([#6556]({{ site.repository }}/issues/6556))
- Cleanup LiveReloadReactor ([#6607]({{ site.repository }}/issues/6607))

### Documentation

- Add formester to the list of saas form backend ([#6059]({{ site.repository }}/issues/6059))
- GitHub Pages instructions ([#6384]({{ site.repository }}/issues/6384))
- Improve documentation for theme-gem installation ([#6387]({{ site.repository }}/issues/6387))
- Fix diff syntax-highlighting ([#6388]({{ site.repository }}/issues/6388))
- Update instructions ([#6396]({{ site.repository }}/issues/6396))
- Fix code-block highlighting in docs ([#6398]({{ site.repository }}/issues/6398))
- Filtering Posts with categories, tags, or other variables ([#6399]({{ site.repository }}/issues/6399))
- Fixes formatting on pre-formatted text. ([#6405]({{ site.repository }}/issues/6405))
- Added new tutorial to tutorials section on docs ([#6406]({{ site.repository }}/issues/6406))
- Updates ([#6407]({{ site.repository }}/issues/6407))
- Fix `collections_dir` example ([#6408]({{ site.repository }}/issues/6408))
- Renaming duplicate of &#34;Scenario 6&#34; to &#34;Scenario 7&#34; ([#6411]({{ site.repository }}/issues/6411))
- Mark `collection_dir` as unreleased ([#6412]({{ site.repository }}/issues/6412))
- Fix link to SUPPORT ([#6415]({{ site.repository }}/issues/6415))
- Fix list appearance by adding missing `ol` tag ([#6421]({{ site.repository }}/issues/6421))
- Explain how to override output collection index page ([#6424]({{ site.repository }}/issues/6424))
- Added github-cards to the list of plugins ([#6425]({{ site.repository }}/issues/6425))
- CoC violation correspondents ([#6429]({{ site.repository }}/issues/6429))
- Add a note about Liquid and syntax highlighting ([#6466]({{ site.repository }}/issues/6466))
- Remove `sudo` from macOS troubleshooting instructions ([#6486]({{ site.repository }}/issues/6486))
- Add a note on `:jekyll_plugins` group in the docs ([#6488]({{ site.repository }}/issues/6488))
- Updated custom-404-page.md ([#6489]({{ site.repository }}/issues/6489))
- Fix a few minor issues in the docs ([#6494]({{ site.repository }}/issues/6494))
- Add jekyll-pwa-plugin ([#6533]({{ site.repository }}/issues/6533))
- Remove Jekyll-Smartify from plugins directory ([#6548]({{ site.repository }}/issues/6548))
- Updated Jekyll-Pug listing to include official website ([#6555]({{ site.repository }}/issues/6555))
- Remove link to severely outdated asset plugin ([#6613]({{ site.repository }}/issues/6613))
- Default time zone depends upon server ([#6617]({{ site.repository }}/issues/6617))
- Add `disqus-for-jekyll` to plugins. ([#6618]({{ site.repository }}/issues/6618))
- Update &#34;Requirements&#34; for Ruby version ([#6623]({{ site.repository }}/issues/6623))
- Fix: Update link to i18n_filter plugin ([#6638]({{ site.repository }}/issues/6638))
- Correct WordPress capitalization ([#6645]({{ site.repository }}/issues/6645))
- Add Tweetsert, Stickyposts, Paginate::Content ([#6651]({{ site.repository }}/issues/6651))
- Post: Jekyll 3.7.0 released ([#6634]({{ site.repository }}/issues/6634))

### Site Enhancements
{: #site-enhancements-v3-7-0}

- Add special styling for code-blocks run in shell ([#6389]({{ site.repository }}/issues/6389))
- Add post about diversity ([#6447]({{ site.repository }}/issues/6447))
- Update list of files excluded from Docs site ([#6457]({{ site.repository }}/issues/6457))
- Update site History ([#6460]({{ site.repository }}/issues/6460))
- Add default twitter card image ([#6476]({{ site.repository }}/issues/6476))
- Update normalize.css to v7.0.0 ([#6491]({{ site.repository }}/issues/6491))
- Optimize images ([#6519]({{ site.repository }}/issues/6519))
- Back to original main navigation ([#6544]({{ site.repository }}/issues/6544))
- Styles: mobile-docs select element ([#6545]({{ site.repository }}/issues/6545))
- Search with DocSearch by @Algolia ([#6557]({{ site.repository }}/issues/6557))
- Site header redesign ([#6567]({{ site.repository }}/issues/6567))
- Move logo above site navigation on small screens ([#6570]({{ site.repository }}/issues/6570))
- Docs: Include version badge for latest features ([#6574]({{ site.repository }}/issues/6574))
- Use version-badge on an existing feature intro ([#6575]({{ site.repository }}/issues/6575))
- Add jekyll-category-pages plugin ([#6632]({{ site.repository }}/issues/6632))
- Improve docs styling for code to be run in shell ([#6641]({{ site.repository }}/issues/6641))
- Fix permalink icon markup in news-item layout ([#6639]({{ site.repository }}/issues/6639))


## 3.6.3 / 2018-09-18
{: #v3-6-3}

### Bug Fixes
{: #bug-fixes-v3-6-3}

- 3.6.x: security: fix `include` bypass of `EntryFilter#filter` symlink check ([#7229]({{ site.repository }}/issues/7229))


## 3.6.2 / 2017-10-21
{: #v3-6-2}

### Development Fixes
{: #development-fixes-v3-6-2}

- Update Rubocop to 0.51.0 ([#6444]({{ site.repository }}/issues/6444))
- Add test for layout as string ([#6445]({{ site.repository }}/issues/6445))

### Bug Fixes
{: #bug-fixes-v3-6-2}

- Problematic UTF+bom files ([#6322]({{ site.repository }}/issues/6322))
- Always treat `data.layout` as a string ([#6442]({{ site.repository }}/issues/6442))


## 3.6.1 / 2017-10-20
{: #v3-6-1}

### Documentation

- Doc y_day in docs/permalinks ([#6244]({{ site.repository }}/issues/6244))
- Update frontmatter.md ([#6371]({{ site.repository }}/issues/6371))
- Elaborate on excluding items from processing ([#6136]({{ site.repository }}/issues/6136))
- Style lists in tables ([#6379]({{ site.repository }}/issues/6379))
- Remove duplicate &#34;available&#34; ([#6380]({{ site.repository }}/issues/6380))

### Development Fixes
{: #development-fixes-v3-6-1}

- Bump rubocop to use `v0.50.x` ([#6368]({{ site.repository }}/issues/6368))


## 3.6.0 / 2017-09-21
{: #v3-6-0}

### Minor Enhancements
{: #minor-enhancements-v3-6-0}

- Ignore final newline in folded YAML string ([#6054]({{ site.repository }}/issues/6054))
- Add URL checks to Doctor ([#5760]({{ site.repository }}/issues/5760))
- Fix serving files that clash with directories ([#6222]({{ site.repository }}/issues/6222)) ([#6231]({{ site.repository }}/issues/6231))
- Bump supported Ruby version to `>= 2.1.0` ([#6220]({{ site.repository }}/issues/6220))
- set `LiquidError#template_name` for errors in included file ([#6206]({{ site.repository }}/issues/6206))
- Access custom config array throughout session ([#6200]({{ site.repository }}/issues/6200))
- Add support for Rouge 2, in addition to Rouge 1 ([#5919]({{ site.repository }}/issues/5919))
- Allow `yield` to logger methods &amp; bail early on no-op messages ([#6315]({{ site.repository }}/issues/6315))
- Update mime-types. ([#6336]({{ site.repository }}/issues/6336))
- Use a Schwartzian transform with custom sorting ([#6342]({{ site.repository }}/issues/6342))
- Alias `Drop#invoke_drop` to `Drop#[]` ([#6338]({{ site.repository }}/issues/6338))

### Bug Fixes
{: #bug-fixes-v3-6-0}

- `Deprecator`: fix typo for `--serve` command ([#6229]({{ site.repository }}/issues/6229))
- `Reader#read_directories`: guard against an entry not being a directory ([#6226]({{ site.repository }}/issues/6226))
- kramdown: symbolize keys in-place ([#6247]({{ site.repository }}/issues/6247))
- Call `to_s` on site.url before attempting to concatenate strings ([#6253]({{ site.repository }}/issues/6253))
- Enforce Style/FrozenStringLiteralComment ([#6265]({{ site.repository }}/issues/6265))
- Update theme-template README to note &#39;assets&#39; directory ([#6257]({{ site.repository }}/issues/6257))
- Memoize the return value of `Document#url` ([#6266]({{ site.repository }}/issues/6266))
- delegate `StaticFile#to_json` to `StaticFile#to_liquid` ([#6273]({{ site.repository }}/issues/6273))
- Fix `Drop#key?` so it can handle a nil argument ([#6281]({{ site.repository }}/issues/6281))
- Guard against type error in absolute url ([#6280]({{ site.repository }}/issues/6280))
- Mutable drops should fallback to their own methods when a mutation isn&#39;t present ([#6350]({{ site.repository }}/issues/6350))
- Skip adding binary files as posts ([#6344]({{ site.repository }}/issues/6344))
- Don&#39;t break if bundler is not installed ([#6377]({{ site.repository }}/issues/6377))

### Documentation

- Fix a typo in `custom-404-page.md` ([#6218]({{ site.repository }}/issues/6218))
- Docs: fix links to issues in History.markdown ([#6255]({{ site.repository }}/issues/6255))
- Update deprecated gems key to plugins. ([#6262]({{ site.repository }}/issues/6262))
- Fixes minor typo in post text ([#6283]({{ site.repository }}/issues/6283))
- Execute build command using bundle. ([#6274]({{ site.repository }}/issues/6274))
- name unification - buddy details ([#6317]({{ site.repository }}/issues/6317))
- name unification - application index ([#6318]({{ site.repository }}/issues/6318))
- trim and relocate plugin info across docs ([#6311]({{ site.repository }}/issues/6311))
- update Jekyll&#39;s README ([#6321]({{ site.repository }}/issues/6321))
- add SUPPORT file for GitHub ([#6324]({{ site.repository }}/issues/6324))
- Rename CODE_OF_CONDUCT to show in banner ([#6325]({{ site.repository }}/issues/6325))
- Docs : illustrate page.id for a collection&#39;s document ([#6329]({{ site.repository }}/issues/6329))
- Docs: post&#39;s date can be overridden in front matter ([#6334]({{ site.repository }}/issues/6334))
- Docs: `site.url` behavior on development and production environments ([#6270]({{ site.repository }}/issues/6270))
- Fix typo in site.url section of variables.md :-[ ([#6337]({{ site.repository }}/issues/6337))
- Docs: updates ([#6343]({{ site.repository }}/issues/6343))
- Fix precedence docs ([#6346]({{ site.repository }}/issues/6346))
- add note to contributing docs about `script/console` ([#6349]({{ site.repository }}/issues/6349))
- Docs: Fix permalink example ([#6375]({{ site.repository }}/issues/6375))

### Site Enhancements
{: #site-enhancements-v3-6-0}

- Adding DevKit helpers ([#6225]({{ site.repository }}/issues/6225))
- Customizing url in collection elements clarified ([#6264]({{ site.repository }}/issues/6264))
- Plugins is the new gems ([#6326]({{ site.repository }}/issues/6326))

### Development Fixes
{: #development-fixes-v3-6-0}

- Strip unnecessary leading whitespace in template ([#6228]({{ site.repository }}/issues/6228))
- Users should be installing patch versions. ([#6198]({{ site.repository }}/issues/6198))
- Fix tests ([#6240]({{ site.repository }}/issues/6240))
- Define path with `__dir__` ([#6087]({{ site.repository }}/issues/6087))
- exit site.process sooner ([#6239]({{ site.repository }}/issues/6239))
- make flakey test more robust ([#6277]({{ site.repository }}/issues/6277))
- Add a quick test for DataReader ([#6284]({{ site.repository }}/issues/6284))
- script/backport-pr: commit message no longer includes the `#` ([#6289]({{ site.repository }}/issues/6289))
- Add Add CODEOWNERS file to help automate reviews. ([#6320]({{ site.repository }}/issues/6320))
- Fix builds on codeclimate ([#6333]({{ site.repository }}/issues/6333))
- Bump rubies on Travis ([#6366]({{ site.repository }}/issues/6366))


## 3.5.2 / 2017-08-12
{: #v3-5-2}

### Bug Fixes
{: #bug-fixes-v3-5-2}

- Backport [#6281]({{ site.repository }}/issues/6281) for v3.5.x: Fix `Drop#key?` so it can handle a nil argument ([#6288]({{ site.repository }}/issues/6288))
- Backport [#6280]({{ site.repository }}/issues/6280) for v3.5.x: Guard against type error in `absolute_url` ([#6287]({{ site.repository }}/issues/6287))
- Backport [#6266]({{ site.repository }}/issues/6266) for v3.5.x: Memoize the return value of `Document#url` ([#6301]({{ site.repository }}/issues/6301))
- Backport [#6273]({{ site.repository }}/issues/6273) for v3.5.x: delegate `StaticFile#to_json` to `StaticFile#to_liquid` ([#6302]({{ site.repository }}/issues/6302))
- Backport [#6226]({{ site.repository }}/issues/6226) for v3.5.x: `Reader#read_directories`: guard against an entry not being a directory ([#6304]({{ site.repository }}/issues/6304))
- Backport [#6247]({{ site.repository }}/issues/6247) for v3.5.x: kramdown: symbolize keys in-place ([#6303]({{ site.repository }}/issues/6303))


## 3.5.1 / 2017-07-17
{: #v3-5-1}

### Minor Enhancements
{: #minor-enhancements-v3-5-1}

- Use Warn for deprecation messages ([#6192]({{ site.repository }}/issues/6192))
- site template: Use plugins key instead of gems  ([#6045]({{ site.repository }}/issues/6045))

### Bug Fixes
{: #bug-fixes-v3-5-1}

- Backward compatibilize URLFilters module ([#6163]({{ site.repository }}/issues/6163))
- Static files contain front matter default keys when `to_liquid`'d  ([#6162]({{ site.repository }}/issues/6162))
- Always normalize the result of the `relative_url` filter ([#6185]({{ site.repository }}/issues/6185))

### Documentation

- Update reference to trouble with OS X/macOS ([#6139]({{ site.repository }}/issues/6139))
- added BibSonomy plugin ([#6143]({{ site.repository }}/issues/6143))
- add plugins for multiple page pagination ([#6055]({{ site.repository }}/issues/6055))
- Update minimum Ruby version in installation.md ([#6164]({{ site.repository }}/issues/6164))
- Add information about finding a collection in `site.collections` ([#6165]({{ site.repository }}/issues/6165))
- Add {% raw %}`{% raw %}`{% endraw %} to Liquid example on site ([#6179]({{ site.repository }}/issues/6179))
- Added improved Pug plugin - removed 404 Jade plugin ([#6174]({{ site.repository }}/issues/6174))
- Linking the link ([#6210]({{ site.repository }}/issues/6210))
- Small correction in documentation for includes ([#6193]({{ site.repository }}/issues/6193))
- Fix docs site page margin ([#6214]({{ site.repository }}/issues/6214))

### Development Fixes
{: #development-fixes-v3-5-1}

- Add jekyll doctor to GitHub Issue Template ([#6169]({{ site.repository }}/issues/6169))
- Test with Ruby 2.4.1-1 on AppVeyor ([#6176]({{ site.repository }}/issues/6176))
- set minimum requirement for jekyll-feed ([#6184]({{ site.repository }}/issues/6184))


## 3.5.0 / 2017-06-18
{: #v3-5-0}

### Minor Enhancements
{: #minor-enhancements-v3-5-0}

- Upgrade to Liquid v4 ([#4362]({{ site.repository }}/issues/4362))
- Convert StaticFile liquid representation to a Drop & add front matter defaults support to StaticFiles ([#5871]({{ site.repository }}/issues/5871))
- Add support for Tab-Separated Values data files (`*.tsv`) ([#5985]({{ site.repository }}/issues/5985))
- Specify version constraint in subcommand error message. ([#5974]({{ site.repository }}/issues/5974))
- Add a template for custom 404 page ([#5945]({{ site.repository }}/issues/5945))
- Require `runtime_dependencies` of a Gem-based theme from its `.gemspec` file ([#5914]({{ site.repository }}/issues/5914))
- Don't raise an error if URL contains a colon ([#5889]({{ site.repository }}/issues/5889))
- Date filters should never raise an exception ([#5722]({{ site.repository }}/issues/5722))
- add `plugins` config key as replacement for `gems` ([#5130]({{ site.repository }}/issues/5130))
- create configuration from options only once in the boot process ([#5487]({{ site.repository }}/issues/5487))
- Add option to fail a build with front matter syntax errors ([#5832]({{ site.repository }}/issues/5832))
- Disable default layouts for documents with a `layout: none` declaration ([#5933]({{ site.repository }}/issues/5933))
- In `jekyll new`, make copied site template user-writable ([#6072]({{ site.repository }}/issues/6072))
- Add top-level `layout` liquid variable to Documents ([#6073]({{ site.repository }}/issues/6073))
- Address reading non-binary static files in themes ([#5918]({{ site.repository }}/issues/5918))
- Allow filters to sort & select based on subvalues ([#5622]({{ site.repository }}/issues/5622))
- Add strip_index filter ([#6075]({{ site.repository }}/issues/6075))

### Documentation

- Install troubleshooting on Ubuntu ([#5817]({{ site.repository }}/issues/5817))
- Add Termux section on troubleshooting ([#5837]({{ site.repository }}/issues/5837))
- fix ial css classes in theme doc ([#5876]({{ site.repository }}/issues/5876))
- Update installation.md ([#5880]({{ site.repository }}/issues/5880))
- Update Aerobatic docs ([#5883]({{ site.repository }}/issues/5883))
- Add note to collections doc on hard-coded collections. ([#5882]({{ site.repository }}/issues/5882))
- Makes uri_escape template docs more specific. ([#5887]({{ site.repository }}/issues/5887))
- Remove duplicate footnote_nr from default config ([#5891]({{ site.repository }}/issues/5891))
- Fixed tutorial for publishing gem to include repo. ([#5900]({{ site.repository }}/issues/5900))
- update broken links ([#5905]({{ site.repository }}/issues/5905))
- Fix typo in contribution information ([#5910]({{ site.repository }}/issues/5910))
- update plugin repo URL to reflect repo move ([#5916]({{ site.repository }}/issues/5916))
- Update exclude array in configuration.md ([#5947]({{ site.repository }}/issues/5947))
- Fixed path in "Improve this page" link in Tutorials section ([#5951]({{ site.repository }}/issues/5951))
- Corrected permalink ([#5949]({{ site.repository }}/issues/5949))
- Included more details about adding defaults to static files ([#5971]({{ site.repository }}/issues/5971))
- Create buddyworks ([#5962]({{ site.repository }}/issues/5962))
- added (buddyworks) to ci list ([#5965]({{ site.repository }}/issues/5965))
- Add a tutorial on serving custom Error 404 page ([#5946]({{ site.repository }}/issues/5946))
- add custom 404 to tutorial navigation ([#5978]({{ site.repository }}/issues/5978))
- Add link to order of interpretation tutorial in Tutorials nav ([#5952]({{ site.repository }}/issues/5952))
- Document Jekyll's Philosophy ([#5792]({{ site.repository }}/issues/5792))
- Require Ruby > 2.1.0 ([#5983]({{ site.repository }}/issues/5983))
- Fix broken link ([#5994]({{ site.repository }}/issues/5994))
- Default options for script/proof ([#5995]({{ site.repository }}/issues/5995))
- Mention Bash on Ubuntu on Windows ([#5960]({{ site.repository }}/issues/5960))
- Document `--unpublished` flag introduced in 91e9ecf ([#5959]({{ site.repository }}/issues/5959))
- Update upgrading.md to mention usage of `bundle update` ([#5604]({{ site.repository }}/issues/5604))
- Fix missing quotation mark ([#6002]({{ site.repository }}/issues/6002))
- New tutorial: Convert an HTML site to Jekyll ([#5881]({{ site.repository }}/issues/5881))
- Revamp Permalink section ([#5912]({{ site.repository }}/issues/5912))
- Fixup tutorial on creating theme from existing HTML templates ([#6006]({{ site.repository }}/issues/6006))
- Standardise on "URLs" without apostrophe in docs ([#6018]({{ site.repository }}/issues/6018))
- Added txtpen in tutorial ([#6021]({{ site.repository }}/issues/6021))
- fix typo using past participle ([#6026]({{ site.repository }}/issues/6026))
- changed formatting to fit the style of the documentation ([#6027]({{ site.repository }}/issues/6027))
- doc fix typo word usage ([#6028]({{ site.repository }}/issues/6028))
- corrected reference to layout in index.md ([#6032]({{ site.repository }}/issues/6032))
- (Minor) Update MathJax CDN ([#6013]({{ site.repository }}/issues/6013))
- Add MvvmCross to samples ([#6035]({{ site.repository }}/issues/6035))
- Update travis-ci.md to correct procedure ([#6043]({{ site.repository }}/issues/6043))
- fix sentence in documentation ([#6048]({{ site.repository }}/issues/6048))
- rephrase a sentence in posts.md to be more direct ([#6049]({{ site.repository }}/issues/6049))
- Compress Website Sass output ([#6009]({{ site.repository }}/issues/6009))
- doc correct spelling error ([#6050]({{ site.repository }}/issues/6050))
- adjusted date-format in sitemap ([#6053]({{ site.repository }}/issues/6053))
- Typo fix (welcomed change -> welcome change). ([#6070]({{ site.repository }}/issues/6070))
- Fixed documentation inconsistency ([#6068]({{ site.repository }}/issues/6068))
- Add own plugin -> Jekyll Brand Social Wall ([#6064]({{ site.repository }}/issues/6064))
- Added plugin jekyll-analytics ([#6042]({{ site.repository }}/issues/6042))
- Use more precise language when explaining links ([#6078]({{ site.repository }}/issues/6078))
- Update plugins.md ([#6088]({{ site.repository }}/issues/6088))
- windows 10 tutorial ([#6100]({{ site.repository }}/issues/6100))
- Explain how to override theme styles ([#6107]({{ site.repository }}/issues/6107))
- updated Bash on Ubuntu on Windows link in tutorial ([#6111]({{ site.repository }}/issues/6111))
- Fix wording in `_docs/templates.md` links section ([#6114]({{ site.repository }}/issues/6114))
- Update windows.md ([#6115]({{ site.repository }}/issues/6115))
- Added windows to docs.yml ([#6109]({{ site.repository }}/issues/6109))
- Be more specific on what to upload ([#6119]({{ site.repository }}/issues/6119))
- Remove Blank Newlines from "Jekyll on Windows" Page ([#6126]({{ site.repository }}/issues/6126))
- Link the troubleshooting page in the quickstart page ([#6134]({{ site.repository }}/issues/6134))
- add documentation about the &#34;pinned&#34; label ([#6147]({{ site.repository }}/issues/6147))
- docs(JekyllOnWindows): Add a new Installation way ([#6141]({{ site.repository }}/issues/6141))
- corrected windows.md ([#6149]({{ site.repository }}/issues/6149))
- Refine documentation for Windows ([#6153]({{ site.repository }}/issues/6153))

### Development Fixes
{: #development-fixes-v3-5-0}

- Rubocop: add missing comma ([#5835]({{ site.repository }}/issues/5835))
- Appease classifier-reborn ([#5934]({{ site.repository }}/issues/5934))
- Allow releases & development on `*-stable` branches ([#5926]({{ site.repository }}/issues/5926))
- Add script/backport-pr ([#5925]({{ site.repository }}/issues/5925))
- Prefer .yaml over .toml ([#5966]({{ site.repository }}/issues/5966))
- Fix Appveyor with DST-aware cucumber steps ([#5961]({{ site.repository }}/issues/5961))
- Use Rubocop v0.47.1 till we're ready for v0.48 ([#5989]({{ site.repository }}/issues/5989))
- Test against Ruby 2.4.0 ([#5687]({{ site.repository }}/issues/5687))
- rubocop: lib/jekyll/renderer.rb complexity fixes ([#5052]({{ site.repository }}/issues/5052))
- Use yajl-ruby 1.2.2 (now with 2.4 support) ([#6007]({{ site.repository }}/issues/6007))
- Bump Rubocop to v0.48 ([#5997]({{ site.repository }}/issues/5997))
- doc use example.com ([#6031]({{ site.repository }}/issues/6031))
- fix typo ([#6040]({{ site.repository }}/issues/6040))
- Fix CI  ([#6044]({{ site.repository }}/issues/6044))
- Remove `ruby RUBY_VERSION` from generated Gemfile ([#5803]({{ site.repository }}/issues/5803))
- Test if hidden collections output a document with a future date ([#6103]({{ site.repository }}/issues/6103))
- Add test for uri_escape on reserved characters ([#6086]({{ site.repository }}/issues/6086))
- Allow you to specify the rouge version via an environment variable for testing ([#6138]({{ site.repository }}/issues/6138))
- Bump Rubocop to 0.49.1 ([#6093]({{ site.repository }}/issues/6093))
- Lock nokogiri to 1.7.x for Ruby 2.1 ([#6140]({{ site.repository }}/issues/6140))

### Site Enhancements
{: #site-enhancements-v3-5-0}

- Corrected date for version 3.4.0 ([#5842]({{ site.repository }}/issues/5842))
- Add the correct year to the 3.4.0 release date ([#5858]({{ site.repository }}/issues/5858))
- Add documentation about order of interpretation ([#5834]({{ site.repository }}/issues/5834))
- Documentation on how to build navigation ([#5698]({{ site.repository }}/issues/5698))
- Navigation has been moved out from docs ([#5927]({{ site.repository }}/issues/5927))
- Make links in sidebar for current page more prominent ([#5820]({{ site.repository }}/issues/5820))
- Update normalize.css to v6.0.0 ([#6008]({{ site.repository }}/issues/6008))
- Docs: rename `gems` to `plugins` ([#6082]({{ site.repository }}/issues/6082))
- plugins -> gems ([#6110]({{ site.repository }}/issues/6110))
- Document difference between cgi_escape and uri_escape [#5970]({{ site.repository }}/issues/5970) ([#6081]({{ site.repository }}/issues/6081))

### Bug Fixes
{: #bug-fixes-v3-5-0}

- Exclude Gemfile by default ([#5860]({{ site.repository }}/issues/5860))
- Convertible#validate_permalink!: ensure the return value of `data["permalink"]` is a string before asking if it is empty ([#5878]({{ site.repository }}/issues/5878))
- Allow abbreviated post dates ([#5920]({{ site.repository }}/issues/5920))
- Remove dependency on include from default about.md ([#5903]({{ site.repository }}/issues/5903))
- Allow colons in `uri_escape` filter ([#5957]({{ site.repository }}/issues/5957))
- Re-surface missing public methods in `Jekyll::Document` ([#5975]({{ site.repository }}/issues/5975))
- absolute_url should not mangle URL if called more than once ([#5789]({{ site.repository }}/issues/5789))
- patch URLFilters to prevent `//` ([#6058]({{ site.repository }}/issues/6058))
- add test to ensure variables work in `where_exp` condition ([#5315]({{ site.repository }}/issues/5315))
- Read explicitly included dot-files in collections. ([#6092]({{ site.repository }}/issues/6092))
- Default `baseurl` to `nil` instead of empty string ([#6137]({{ site.repository }}/issues/6137))
- Filters#time helper: Duplicate time before calling #localtime. ([#5996]({{ site.repository }}/issues/5996))


## 3.4.5 / 2017-06-30
{: #v3-4-5}

- Backport [#6185]({{ site.repository }}/issues/6185) for v3.4.x: Always normalize the result of the `relative_url` filter ([#6186]({{ site.repository }}/issues/6186))


## 3.4.4 / 2017-06-17
{: #v3-4-4}

- Backport [#6137]({{ site.repository }}/issues/6137) for v3.4.x: Default `baseurl` to `nil` instead of empty string ([#6146]({{ site.repository }}/issues/6146))


## 3.4.3 / 2017-03-21
{: #v3-4-3}

- Backport [#5957]({{ site.repository }}/issues/5957) for v3.4.x: Allow colons in `uri_escape` filter ([#5968]({{ site.repository }}/issues/5968))


## 3.4.2 / 2017-03-09
{: #v3-4-2}

- Backport [#5871]({{ site.repository }}/issues/5871) for v3.4.x: Convert StaticFile liquid representation to a Drop & add front matter defaults support to StaticFiles ([#5940]({{ site.repository }}/issues/5940))


## 3.4.1 / 2017-03-02
{: #v3-4-1}

- Backport [#5920]({{ site.repository }}/issues/5920) for v3.4.x: Allow abbreviated post dates ([#5924]({{ site.repository }}/issues/5924))


## 3.4.0 / 2017-01-27
{: #v3-4-0}

### Minor Enhancements
{: #minor-enhancements-v3-4-0}

- Add connector param to `array_to_sentence_string` filter ([#5597]({{ site.repository }}/issues/5597))
- Adds `group_by_exp` filter ([#5513]({{ site.repository }}/issues/5513))
- Use Addressable instead of URI to decode ([#5726]({{ site.repository }}/issues/5726))
- throw IncludeTagError if error occurs in included file ([#5767]({{ site.repository }}/issues/5767))
- Write Jekyll::Utils::Exec.run for running shell commands. ([#5640]({{ site.repository }}/issues/5640))
- Use the current year for the LICENSE of theme ([#5712]({{ site.repository }}/issues/5712))
- Update License ([#5713]({{ site.repository }}/issues/5713))

### Bug Fixes
{: #bug-fixes-v3-4-0}

- Escaped regular expressions when using `post_url`. ([#5605]({{ site.repository }}/issues/5605))
- fix date parsing in file names to be stricter ([#5609]({{ site.repository }}/issues/5609))
- Add a module to re-define `ENV["TZ"]` in Windows ([#5612]({{ site.repository }}/issues/5612))
- Use each instead of map to actually return nothing ([#5668]({{ site.repository }}/issues/5668))
- include: fix 'no implicit conversion of nil to String' ([#5750]({{ site.repository }}/issues/5750))
- Don't include the theme's includes_path if it is nil. ([#5780]({{ site.repository }}/issues/5780))
- test double slash when input = '/' ([#5542]({{ site.repository }}/issues/5542))
- use logger.info for related posts ([#5822]({{ site.repository }}/issues/5822))

### Site Enhancements
{: #site-enhancements-v3-4-0}

- Use only the used Font Awesome icons. ([#5530]({{ site.repository }}/issues/5530))
- Switch to `https` when possible. ([#5611]({{ site.repository }}/issues/5611))
- Update `_font-awesome.scss` to move .woff file before .ttf ([#5614]({{ site.repository }}/issues/5614))
- Update documentation on updating FontAwesome Iconset ([#5655]({{ site.repository }}/issues/5655))
- Use defaults for docs and news-items ([#5744]({{ site.repository }}/issues/5744))
- Sort gems in `docs/_config.yml` ([#5746]({{ site.repository }}/issues/5746))
- Add missing class ([#5791]({{ site.repository }}/issues/5791))
- Improve template docs ([#5694]({{ site.repository }}/issues/5694))

### Development Fixes
{: #development-fixes-v3-4-0}

- clean unit-test names in `test/test_tags.rb` ([#5608]({{ site.repository }}/issues/5608))
- Add cucumber feature to test for bonafide theme gems ([#5384]({{ site.repository }}/issues/5384))
- Use `assert_nil` instead of `assert_equal nil` ([#5652]({{ site.repository }}/issues/5652))
- Rubocop -a on lib/jekyll ([#5666]({{ site.repository }}/issues/5666))
- Bump to rake 12.0 ([#5670]({{ site.repository }}/issues/5670))
- Rubocop Gemfile ([#5671]({{ site.repository }}/issues/5671))
- update Classifier-Reborn to 2.1.0 ([#5711]({{ site.repository }}/issues/5711))
- Rubocop: fix Rakefile and gemspec ([#5745]({{ site.repository }}/issues/5745))
- Use `assert_nil` ([#5725]({{ site.repository }}/issues/5725))
- Sort gems in `jekyll.gemspec` ([#5746]({{ site.repository }}/issues/5746))
- Rubocop: Require consistent comma in multiline literals ([#5761]({{ site.repository }}/issues/5761))
- Bump rubocop ([#5765]({{ site.repository }}/issues/5765))
- New rubocop security checks ([#5768]({{ site.repository }}/issues/5768))
- test/helper: fix flaky plugin path test by removing calls to Dir.chdir without a block ([#5779]({{ site.repository }}/issues/5779))
- Use latest jemoji gem ([#5782]({{ site.repository }}/issues/5782))
- Bump htmlproofer ([#5781]({{ site.repository }}/issues/5781))
- Bump rubies we test against ([#5784]({{ site.repository }}/issues/5784))
- Bump rdoc to v5.0 ([#5797]({{ site.repository }}/issues/5797))
- Bump codeclimate-test-reporter to v1.0.5 ([#5798]({{ site.repository }}/issues/5798))

### Documentation

- Improve quickstart docs ([#5689]({{ site.repository }}/issues/5689))
- Add Jekyll-Post to list of plugins ([#5705]({{ site.repository }}/issues/5705))
- Add jekyll-numbered-headings ([#5688]({{ site.repository }}/issues/5688))
- Docs: move permalinks from documents into config ([#5544]({{ site.repository }}/issues/5544))
- Improve collections docs ([#5691]({{ site.repository }}/issues/5691))
- Fix [#5730]({{ site.repository }}/issues/5730): add gcc and make to the list of requirements ([#5731]({{ site.repository }}/issues/5731))
- Remove instructions to install Jekyll 2 on Windows ([#5582]({{ site.repository }}/issues/5582))
- Fix example URL inconsistency ([#5592]({{ site.repository }}/issues/5592))
- Replace backticks within HTML blocks with HTML tags ([#5435]({{ site.repository }}/issues/5435))
- Add jekyll-migrate-permalink ([#5600]({{ site.repository }}/issues/5600))
- Fix bad config YAML in collections example ([#5587]({{ site.repository }}/issues/5587))
- Bring documentation on 'Directory Structure' up-to-date ([#5573]({{ site.repository }}/issues/5573))
- Fixed typo ([#5632]({{ site.repository }}/issues/5632))
- use backticks for Gemfile for consistency since in the next sentence … ([#5641]({{ site.repository }}/issues/5641))
- Update Core team list in the README file ([#5643]({{ site.repository }}/issues/5643))
- Improve Permalinks documentation. ([#5653]({{ site.repository }}/issues/5653))
- Fix typo in Variables doc page ([#5657]({{ site.repository }}/issues/5657))
- Fix a couple of typos in the docs ([#5658]({{ site.repository }}/issues/5658))
- Update windows.md ([#5683]({{ site.repository }}/issues/5683))
- Improve permalinks docs ([#5693]({{ site.repository }}/issues/5693))
- Document --unpublished build option ([#5720]({{ site.repository }}/issues/5720))
- Improve pages docs ([#5692]({{ site.repository }}/issues/5692))
- Added new includes.md topic to docs ([#5696]({{ site.repository }}/issues/5696))
- Replace a dead link with a web-archived one ([#5738]({{ site.repository }}/issues/5738))
- Remove duplicate paragraph. ([#5740]({{ site.repository }}/issues/5740))
- Addition of a sample "typical post" ([#5473]({{ site.repository }}/issues/5473))
- Fix a minor grammatical mistake on themes' document ### -dev ([#5748]({{ site.repository }}/issues/5748))
- Correct comments in data_reader.rb ([#5621]({{ site.repository }}/issues/5621))
- Add jekyll-pre-commit to plugins list ([#5752]({{ site.repository }}/issues/5752))
- Update quickstart.md ([#5758]({{ site.repository }}/issues/5758))
- Correct minor typo ([#5764]({{ site.repository }}/issues/5764))
- Fix a markdown link to look properly on the web ([#5769]({{ site.repository }}/issues/5769))
- Info about the help command usage ([#5312]({{ site.repository }}/issues/5312))
- Add missing merge labels for jekyllbot ([#5753]({{ site.repository }}/issues/5753))
- Fix broken links in documentation ([#5736]({{ site.repository }}/issues/5736))
- Docs: add `match_regex` and `replace_regex` filters ([#5799]({{ site.repository }}/issues/5799))
- Got that diaper money? ([#5810]({{ site.repository }}/issues/5810))
- Sort content by popularity using Google Analytics ([#5812]({{ site.repository }}/issues/5812))
- Rework CI doc to include multiple providers. ([#5815]({{ site.repository }}/issues/5815))
- Improve theme docs ([#5690]({{ site.repository }}/issues/5690))
- Add mention of classifier-reborn for LSI ([#5811]({{ site.repository }}/issues/5811))
- Added note about --blank flag ([#5802]({{ site.repository }}/issues/5802))
- Fixed inaccuracy in "Built-in permalink styles" docs ([#5819]({{ site.repository }}/issues/5819))


## 3.3.1 / 2016-11-14
{: #v3-3-1}

### Minor Enhancements
{: #minor-enhancements-v3-3-1}

- Collapse `gsub` for performance ([#5494]({{ site.repository }}/issues/5494))
- URL: warn if key doesn't exist in url drop ([#5524]({{ site.repository }}/issues/5524))

### Bug Fixes
{: #bug-fixes-v3-3-1}

- Fix typo in `theme_template` README ([#5472]({{ site.repository }}/issues/5472))
- Do not swallow all exceptions on render ([#5495]({{ site.repository }}/issues/5495))
- Site template: fixed `_config.yml` comment typo ([#5511]({{ site.repository }}/issues/5511))
- `jekyll new-theme` should specify Jekyll as a runtime dependency for the theme ([#5457]({{ site.repository }}/issues/5457))
- Be much more specific about ignoring specific vendored directories. ([#5564]({{ site.repository }}/issues/5564))
- Only warn about auto-regeneration bug on Bash On Windows. ([#5464]({{ site.repository }}/issues/5464))
- Allow permalink template to have underscores ([#5572]({{ site.repository }}/issues/5572))

### Site Enhancements
{: #site-enhancements-v3-3-1}

- Documentation: `link` Liquid tag  ([#5449]({{ site.repository }}/issues/5449))
- Updating install instruction link for Jekyll 3 on Windows ([#5475]({{ site.repository }}/issues/5475))
- Update normalize.css to v5.0.0 ([#5471]({{ site.repository }}/issues/5471))
- Add jekyll-data to the list of plugins ([#5491]({{ site.repository }}/issues/5491))
- Add info about checking version + updating ([#5497]({{ site.repository }}/issues/5497))
- Add jekyll-include-absolute-plugin to list of third-party plugins ([#5492]({{ site.repository }}/issues/5492))
- Remove jekyll-hook from deployment methods ([#5502]({{ site.repository }}/issues/5502))
- Update deployment-methods.md ([#5504]({{ site.repository }}/issues/5504))
- Ubuntu users should install ruby2.3-dev ([#5512]({{ site.repository }}/issues/5512))
- Remove Glynn as deployment option ([#5519]({{ site.repository }}/issues/5519))
- Fix broken forum link ([#5466]({{ site.repository }}/issues/5466))
- Move documentation to docs folder ([#5459]({{ site.repository }}/issues/5459))
- Fix broken links in CONTRIBUTING ([#5533]({{ site.repository }}/issues/5533))
- Update documentation on jekyllrb.com ([#5540]({{ site.repository }}/issues/5540))
- Fix HTML rendering ([#5536]({{ site.repository }}/issues/5536))
- Remove outdated deployment information ([#5557]({{ site.repository }}/issues/5557))
- no more invalid US-ASCII on lines 30 and 97 ([#5520]({{ site.repository }}/issues/5520))
- Add permalinks to docs in '/maintaining/' ([#5532]({{ site.repository }}/issues/5532))
- Add jekyll-pinboard to list of third-party plugins ([#5514]({{ site.repository }}/issues/5514))
- Fix formatting in 2-to-3.md ([#5507]({{ site.repository }}/issues/5507))
- Add two plugins to the plugins page ([#5493]({{ site.repository }}/issues/5493))
- Use site.baseurl before link and post_url tags ([#5559]({{ site.repository }}/issues/5559))
- Fix link to jekyll-pinboard plugin ([#5570]({{ site.repository }}/issues/5570))
- mention `docs` folder as a way to deploy on GitHub Pages ([#5571]({{ site.repository }}/issues/5571))

### Development Fixes
{: #development-fixes-v3-3-1}

- fix rubocop errors on testing with Rubocop 0.44 ([#5489]({{ site.repository }}/issues/5489))
- script/test: add missing whitespace ([#5479]({{ site.repository }}/issues/5479))
- Restrict Rubocop version ([#5496]({{ site.repository }}/issues/5496))
- include a hashbang for all benchmark scripts & make them executable ([#5505]({{ site.repository }}/issues/5505))
- Update source in script/proof ([#5538]({{ site.repository }}/issues/5538))
- Collections.feature: conditional steps to have it pass on Windows ([#5546]({{ site.repository }}/issues/5546))
- Fix tests to get script/test to pass on Windows ([#5526]({{ site.repository }}/issues/5526))


## 3.3.0 / 2016-10-06
{: #v3-3-0}

### Minor Enhancements
{: #minor-enhancements-v3-3-0}

- Colorize interpolated output in logger.info ([#5239]({{ site.repository }}/issues/5239))
- Site template: exclude Gemfile and Gemfile.lock in site config ([#5293]({{ site.repository }}/issues/5293))
- Fix [#5233]({{ site.repository }}/issues/5233): Increase our ability to detect Windows. ([#5235]({{ site.repository }}/issues/5235))
- update gitignore template to ignore theme gems built by user ([#5326]({{ site.repository }}/issues/5326))
- Adds ability to link to all files ([#5199]({{ site.repository }}/issues/5199))
- Exclude vendor by default ([#5361]({{ site.repository }}/issues/5361))
- Add ThemeAssetsReader which reads assets from a theme ([#5364]({{ site.repository }}/issues/5364))
- Add bundle install to jekyll new command ([#5237]({{ site.repository }}/issues/5237))
- Add absolute_url and relative_url filters. ([#5399]({{ site.repository }}/issues/5399))
- Site template: remove `css/` from new site scaffolding ([#5402]({{ site.repository }}/issues/5402))
- Site template: Move contents of the index.html page to the 'home' layout ([#5420]({{ site.repository }}/issues/5420))
- Exclude node_modules by default ([#5210]({{ site.repository }}/issues/5210))
- Run hooks in priority order. ([#5157]({{ site.repository }}/issues/5157))
- Add `static_file.name` and `.basename` Liquid attributes ([#5264]({{ site.repository }}/issues/5264))
- set site.url in dev environment to `http://localhost:4000` ([#5431]({{ site.repository }}/issues/5431))
- Add support for indented link references on excerpt ([#5212]({{ site.repository }}/issues/5212))

### Bug Fixes
{: #bug-fixes-v3-3-0}

- Use jekyll-feed to generate the default site's RSS feed ([#5196]({{ site.repository }}/issues/5196))
- Site#configure_theme: do not set theme unless it's a string ([#5189]({{ site.repository }}/issues/5189))
- Convertible: set self.output in #render_all_layouts and #do_layout ([#5337]({{ site.repository }}/issues/5337))
- Only complain about `kramdown.coderay` if it is actually in the config ([#5380]({{ site.repository }}/issues/5380))
- Clarify documentation in theme gem's README template ([#5376]({{ site.repository }}/issues/5376))
- Allow underscore in highlighter language ([#5375]({{ site.repository }}/issues/5375))
- Site template: set empty url in config file by default ([#5338]({{ site.repository }}/issues/5338))
- Site template config: prepend 'jekyll serve' with 'bundle exec' ([#5430]({{ site.repository }}/issues/5430))
- Don't call `File.utime` for StaticFiles if it's a symlink ([#5427]({{ site.repository }}/issues/5427))
- Fix handling of non-ASCII characters in new `*_url` filters ([#5410]({{ site.repository }}/issues/5410))
- Remove autoload of Draft which no longer exists. ([#5441]({{ site.repository }}/issues/5441))
- Fix issue where Windows drive name is stripped from Jekyll.sanitized_path incorrectly ([#5256]({{ site.repository }}/issues/5256))
- Fix bug where `post_url` tag matched incorrect post with subdirectory ([#4873]({{ site.repository }}/issues/4873))
- Fix loading data from subdir with a period in name ([#5433]({{ site.repository }}/issues/5433))
- Revert Commands::Serve#server_address signature change. ([#5456]({{ site.repository }}/issues/5456))

### Site Enhancements
{: #site-enhancements-v3-3-0}

- Document `to_integer` and `inspect` filters ([#5185]({{ site.repository }}/issues/5185))
- Fix path in the prompt ([#5194]({{ site.repository }}/issues/5194))
- need subcommand build ([#5190]({{ site.repository }}/issues/5190))
- Add the Jekyll Cloudinary plugin ([#5183]({{ site.repository }}/issues/5183))
- Documentation : `new-theme` command ([#5205]({{ site.repository }}/issues/5205))
- Document `link` Liquid tag ([#5182]({{ site.repository }}/issues/5182))
- Remove mention of page for link tag in release post ([#5214]({{ site.repository }}/issues/5214))
- fixed typo ([#5226]({{ site.repository }}/issues/5226))
- Add missing comma ([#5222]({{ site.repository }}/issues/5222))
- Maintain aspect ratio with `height: auto;` ([#5254]({{ site.repository }}/issues/5254))
- Fix a link in deployment-methods.md ([#5244]({{ site.repository }}/issues/5244))
- Documentation: improve highlight in `Creating a theme` ([#5249]({{ site.repository }}/issues/5249))
- Bundler isn't installed by default ([#5258]({{ site.repository }}/issues/5258))
- Update troubleshooting documentation to include fix for issue with vendored gems ([#5271]({{ site.repository }}/issues/5271))
- Link `--lsi` option's description to Wikipedia docs on LSI ([#5274]({{ site.repository }}/issues/5274))
- Document `--profile` option on the configuration page ([#5279]({{ site.repository }}/issues/5279))
- Update homepage to sync with merge of [#5258]({{ site.repository }}/issues/5258) ([#5287]({{ site.repository }}/issues/5287))
- Add post about Jekyll Admin initial release ([#5291]({{ site.repository }}/issues/5291))
- Replace liquid highlight tag with backticks ([#5262]({{ site.repository }}/issues/5262))
- Word update ([#5294]({{ site.repository }}/issues/5294))
- Site documentation section links always point to https://jekyllrb.com ([#5281]({{ site.repository }}/issues/5281))
- Missing `:site, :post_render` payload documentation on site ([#5280]({{ site.repository }}/issues/5280))
- Site: exclude README.md and .gitignore ([#5304]({{ site.repository }}/issues/5304))
- Add link to Staticman ([#5224]({{ site.repository }}/issues/5224))
- Update url for OpenShift ([#5320]({{ site.repository }}/issues/5320))
- Add help for missing static_file e.g. on heroku ([#5334]({{ site.repository }}/issues/5334))
- Add a line about updating theme-gems in the docs ([#5318]({{ site.repository }}/issues/5318))
- Explain how to copy a theme's files ([#5335]({{ site.repository }}/issues/5335))
- .md as default extension in examples ([#5316]({{ site.repository }}/issues/5316))
- Fix small typo in docs ([#5347]({{ site.repository }}/issues/5347))
- Add missing period to sentence in first paragraph. ([#5372]({{ site.repository }}/issues/5372))
- added jekyll-spotify plugin ([#5369]({{ site.repository }}/issues/5369))
- Add jekyll-menus to the list of plugins. ([#5397]({{ site.repository }}/issues/5397))
- macOS and one grammar fix ([#5403]({{ site.repository }}/issues/5403))
- Add documentation for `relative_url` and `absolute_url` ([#5405]({{ site.repository }}/issues/5405))
- Bugfix on logo in JSON-LD ([#5421]({{ site.repository }}/issues/5421))
- Fix Travis.ci documentation ([#5413]({{ site.repository }}/issues/5413))
- Update documentation regarding `bundle install` after `jekyll new` ([#5428]({{ site.repository }}/issues/5428))
- Replace classic box-sizing reset with inheritance reset ([#5411]({{ site.repository }}/issues/5411))
- Update Wikipedia YAML list link ([#5452]({{ site.repository }}/issues/5452))
- Add Jekyll 3.3 release post ([#5442]({{ site.repository }}/issues/5442))

### Development Fixes
{: #development-fixes-v3-3-0}

- Update appveyor.yml and fix optional deps for Ruby x64 ([#5180]({{ site.repository }}/issues/5180))
- Improve tests for Jekyll::PluginManager ([#5167]({{ site.repository }}/issues/5167))
- Update Ruby versions in travis.yml ([#5221]({{ site.repository }}/issues/5221))
- Avoid installing unnecessary gems for site testing ([#5272]({{ site.repository }}/issues/5272))
- Proposal: Affinity teams and their captains ([#5273]({{ site.repository }}/issues/5273))
- Replace duplicate with positive local test in issue template ([#5286]({{ site.repository }}/issues/5286))
- Update AppVeyor config. ([#5240]({{ site.repository }}/issues/5240))
- Execute jekyll from clone instead of defined binary when running 'script/default-site' ([#5295]({{ site.repository }}/issues/5295))
- rubocop: lib/jekyll/document.rb complexity fixes ([#5045]({{ site.repository }}/issues/5045))
- Proxy a number of Convertible methods to Renderer ([#5308]({{ site.repository }}/issues/5308))
- Run executable for Cucumber via Ruby instead of Shell ([#5383]({{ site.repository }}/issues/5383))
- Appease Rubocop ([#5381]({{ site.repository }}/issues/5381))
- remove features' directories on windows with proper access ([#5389]({{ site.repository }}/issues/5389))
- `site_configuration.feature`: use UTC format in timezone ([#5416]({{ site.repository }}/issues/5416))
- swallow bundle output from `jekyll new` while in CI ([#5408]({{ site.repository }}/issues/5408))
- Add .editorconfig ([#5412]({{ site.repository }}/issues/5412))


## 3.2.1 / 2016-08-02
{: #v3-2-1}

### Bug Fixes
{: #bug-fixes-v3-2-1}

- Include theme directories in default gemspec ([#5152]({{ site.repository }}/issues/5152))
- Fix for symlinked themes ([#5156]({{ site.repository }}/issues/5156))
- Layout: set `relative_path` without using Pathname ([#5164]({{ site.repository }}/issues/5164))

### Development Fixes
{: #development-fixes-v3-2-1}

- Add test to build the default site ([#5154]({{ site.repository }}/issues/5154))
- script/default-site: specify `BUNDLE_GEMFILE` for new site ([#5178]({{ site.repository }}/issues/5178))
- script/default-site: read Jekyll source from local clone ([#5188]({{ site.repository }}/issues/5188))

### Site Enhancements
{: #site-enhancements-v3-2-1}

- Enable site excerpts ([#5150]({{ site.repository }}/issues/5150))
- Initial 404 page ([#5143]({{ site.repository }}/issues/5143))
- Remove the "this feature is unreleased" warning from the theme docs ([#5158]({{ site.repository }}/issues/5158))
- Future True on GitHub Pages note ([#5173]({{ site.repository }}/issues/5173))
- Minor updates and corrections ([#5177]({{ site.repository }}/issues/5177))
- index.html: update instructions to require bundler  ([#5169]({{ site.repository }}/issues/5169))
- docs/quickstart: update instructions to require bundler ([#5168]({{ site.repository }}/issues/5168))


## 3.2.0 / 2016-07-26
{: #v3-2-0}

### Minor Enhancements
{: #minor-enhancements-v3-2-0}

- Stop testing with Ruby 2.0.x EOL ([#4381]({{ site.repository }}/issues/4381))
- Allow collections to have documents that have no file extension ([#4545]({{ site.repository }}/issues/4545))
- Add size property to `group_by` result ([#4557]({{ site.repository }}/issues/4557))
- Site Template: Removed unnecessary nesting from `_base.scss` ([#4637]({{ site.repository }}/issues/4637))
- Adding a debug log statement for skipped future documents. ([#4558]({{ site.repository }}/issues/4558))
- Site Template: Changed main `<div>` to `<main>` and added accessibility info ([#4636]({{ site.repository }}/issues/4636))
- Add array support to `where` filter ([#4555]({{ site.repository }}/issues/4555))
- 'jekyll clean': also remove .sass-cache ([#4652]({{ site.repository }}/issues/4652))
- Clean up `Tags::PostUrl` a bit, including better errors and date parsing ([#4670]({{ site.repository }}/issues/4670))
- Use `String#encode` for `xml_escape` filter instead of `CGI.escapeHTML` ([#4694]({{ site.repository }}/issues/4694))
- Add `show_dir_listing` option for serve command and fix index file names ([#4533]({{ site.repository }}/issues/4533))
- Site Template: write a Gemfile which is educational to the new site ([#4542]({{ site.repository }}/issues/4542))
- Site template: add explanation of site variables in the example `_config.yml` ([#4704]({{ site.repository }}/issues/4704))
- Adds `link` Liquid tag to make generation of URLs easier ([#4624]({{ site.repository }}/issues/4624))
- Allow static files to be symlinked in unsafe mode or non-prod environments ([#4640]({{ site.repository }}/issues/4640))
- Add `:after_init` hook & add `Site#config=` to make resetting config easy ([#4703]({{ site.repository }}/issues/4703))
- DocumentDrop: add `#<=>` which sorts by date (falling back to path) ([#4741]({{ site.repository }}/issues/4741))
- Add a `where_exp` filter for filtering by expression ([#4478]({{ site.repository }}/issues/4478))
- Globalize Jekyll's Filters. ([#4792]({{ site.repository }}/issues/4792))
- Gem-based themes ([#4595]({{ site.repository }}/issues/4595))
- Allow symlinks if they point to stuff inside `site.source` ([#4710]({{ site.repository }}/issues/4710))
- Update colorator dependency to v1.x ([#4855]({{ site.repository }}/issues/4855))
- Move EntryFilter to use Pathutil & fix `glob_include?` ([#4859]({{ site.repository }}/issues/4859))
- Add 'jekyll new-theme' command to help users get up and running creating a theme ([#4848]({{ site.repository }}/issues/4848))
- `markdownify` and `smartify` should convert input to string before conversion ([#4958]({{ site.repository }}/issues/4958))
- Run `Site#generate` for 'jekyll doctor' to catch plugin issues ([#5005]({{ site.repository }}/issues/5005))
- Add `normalize_whitespace` filter ([#4917]({{ site.repository }}/issues/4917))
- Move bin/jekyll to exe/jekyll to prevent collision with binstubs ([#5014]({{ site.repository }}/issues/5014))
- Cleaning up site template & theme updates. ([#4922]({{ site.repository }}/issues/4922))
- Add fetch method to Drops ([#5056]({{ site.repository }}/issues/5056))
- Extract tag name to class method ([#5063]({{ site.repository }}/issues/5063))
- check if relative URL contains a colon ([#5069]({{ site.repository }}/issues/5069))
- Enable strict (or lax) liquid parsing via a config variable. ([#5053]({{ site.repository }}/issues/5053))
- Add filter: `to_integer` ([#5101]({{ site.repository }}/issues/5101))
- watcher: pass site instance to watch plugin ([#5109]({{ site.repository }}/issues/5109))
- Show liquid warnings. ([#5129]({{ site.repository }}/issues/5129))
- Add `--baseurl` to `build` subcommand ([#5135]({{ site.repository }}/issues/5135))

### Bug Fixes
{: #bug-fixes-v3-2-0}

- Site Template: Added a default lang attribute ([#4633]({{ site.repository }}/issues/4633))
- Site template: Escape title and description where it is used in HTML ([#4606]({{ site.repository }}/issues/4606))
- `Document#date`: drafts which have no date should use source file mtime ([#4611]({{ site.repository }}/issues/4611))
- `Filters#time`: clone an input Time so as to be non-destructive ([#4590]({{ site.repository }}/issues/4590))
- Doctor: fix issue where `--config` wasn't a recognized flag ([#4598]({{ site.repository }}/issues/4598))
- Ensures `related_posts` are only set for a post ([#4620]({{ site.repository }}/issues/4620))
- `EntryFilter#special?`: ignore filenames which begin with `~` ([#4491]({{ site.repository }}/issues/4491))
- Cleaner: `keep_files` should only apply to the beginning of paths, not substrings with index > 0 ([#3849]({{ site.repository }}/issues/3849))
- Use SSLEnable instead of EnableSSL and make URL HTTPS. ([#4693]({{ site.repository }}/issues/4693))
- convertible: use `Document::YAML_FRONT_MATTER_REGEXP` to parse transformable files ([#4786]({{ site.repository }}/issues/4786))
- Example in the site template should be IANA-approved example.com ([#4793]({{ site.repository }}/issues/4793))
- 3.2.x/master: Fix defaults for Documents (posts/collection docs) ([#4808]({{ site.repository }}/issues/4808))
- Don't rescue LoadError or bundler load errors for Bundler. ([#4857]({{ site.repository }}/issues/4857))
- `Serve.process` should receive same config as `Build.process` ([#4953]({{ site.repository }}/issues/4953))
- Prevent reset of page in Liquid payload right before rendering layouts ([#5009]({{ site.repository }}/issues/5009))
- Add missing fields to ExcerptDrop ([#5067]({{ site.repository }}/issues/5067))
- Stringify configuration overrides before first use ([#5060]({{ site.repository }}/issues/5060))
- hooks: move `after_init` hook call at the end of `Site#initialize` ([#5106]({{ site.repository }}/issues/5106))
- filters: raise error if no input given to date filters ([#5127]({{ site.repository }}/issues/5127))
- `where_exp` filter should filter posts ([#4860]({{ site.repository }}/issues/4860))

### Forward Ports
{: #forward-ports-v3-2-0}

- From v3.1.4: Add ExcerptDrop and remove excerpt's ability to refer to itself in Liquid ([#4941]({{ site.repository }}/issues/4941))
- From v3.1.4: Configuration permalink fix and addition of Configuration.from and sorting `site.collections` by label ([#4942]({{ site.repository }}/issues/4942))
- From v3.1.4: Fix {% raw %}`{{ layout }}`{% endraw %} oddities (proper inheritance & fixing overflow of old data) ([#4943]({{ site.repository }}/issues/4943))
- From v3.1.5: Sort the results of the `require_all` glob ([#4944]({{ site.repository }}/issues/4944))
- From v3.1.6: Add ability to render drops as JSON ([#4945]({{ site.repository }}/issues/4945))

### Development Fixes
{: #development-fixes-v3-2-0}

- Add project maintainer profile links ([#4591]({{ site.repository }}/issues/4591))
- Fix state leakage in Kramdown test ([#4618]({{ site.repository }}/issues/4618))
- Unify method for copying special files from repo to site ([#4601]({{ site.repository }}/issues/4601))
- Refresh the contributing file ([#4596]({{ site.repository }}/issues/4596))
- change smartify doc from copy/paste of markdownify doc ([#4653]({{ site.repository }}/issues/4653))
- Update Rake & disable warnings when running tests ([#4720]({{ site.repository }}/issues/4720))
- Fix many warnings ([#4537]({{ site.repository }}/issues/4537))
- Don't blindly assume the last system when determining "open" cmd ([#4717]({{ site.repository }}/issues/4717))
- Fix "locally" typo in contributing documentation ([#4756]({{ site.repository }}/issues/4756))
- Update Rubocop rules ([#4886]({{ site.repository }}/issues/4886))
- Flesh out the issue template to be much more detailed ([#4849]({{ site.repository }}/issues/4849))
- Fixing rubocop offenses in lib/jekyll/cleaner.rb ([#4892]({{ site.repository }}/issues/4892))
- Update `jekyll/commands*` to pass rubocop rules ([#4888]({{ site.repository }}/issues/4888))
- Clean up many test files to pass Rubocop rules ([#4902]({{ site.repository }}/issues/4902))
- Rubocop cleanup for some utils and further test files ([#4916]({{ site.repository }}/issues/4916))
- Rubocop: Low hanging fruit ([#4936]({{ site.repository }}/issues/4936))
- Rubocop: `Drop` changes from v3.1 forward-ports ([#4949]({{ site.repository }}/issues/4949))
- Rubocop: cleanup for misc files ([#4946]({{ site.repository }}/issues/4946))
- Rubocop: Stevenson ([#4951]({{ site.repository }}/issues/4951))
- Rubocop: lib/jekyll/entry_filter.rb ([#4950]({{ site.repository }}/issues/4950))
- Rubocop: `test/*` ([#4947]({{ site.repository }}/issues/4947))
- Rubocop: features ([#4934]({{ site.repository }}/issues/4934))
- Rubocop: Liquid renderer ([#4933]({{ site.repository }}/issues/4933))
- Rubocop: converters ([#4931]({{ site.repository }}/issues/4931))
- Rubocop: Site Drop ([#4948]({{ site.repository }}/issues/4948))
- Rubocop: tags ([#4938]({{ site.repository }}/issues/4938))
- Rubocop: Readers ([#4932]({{ site.repository }}/issues/4932))
- rubocop: jekyll/lib/frontmatter_defaults.rb ([#4974]({{ site.repository }}/issues/4974))
- rubocop: features/step_definitions.rb ([#4956]({{ site.repository }}/issues/4956))
- Rubocop theme and url jekyll libs ([#4959]({{ site.repository }}/issues/4959))
- Rubocop jekyll.rb ([#4966]({{ site.repository }}/issues/4966))
- Rubocop: use %r for all regular expressions. ([#4979]({{ site.repository }}/issues/4979))
- Cleanup and make misc files compliant with Rubocop. ([#4940]({{ site.repository }}/issues/4940))
- Rubocop: jekyll/lib/site.rb ([#4973]({{ site.repository }}/issues/4973))
- Add timings for each scenario in cucumber & print worst offenders ([#4908]({{ site.repository }}/issues/4908))
- rubocop: jekyll/lib/filters.rb ([#4993]({{ site.repository }}/issues/4993))
- Fix rubocop offenses in exe/jekyll ([#5017]({{ site.repository }}/issues/5017))
- Rubocop: lib/jekyll/command.rb ([#5018]({{ site.repository }}/issues/5018))
- rubocop: lib/jekyll/static_file.rb ([#5019]({{ site.repository }}/issues/5019))
- rubocop: lib/jekyll/utils.rb ([#5026]({{ site.repository }}/issues/5026))
- rubocop: lib/jekyll/regenerator.rb ([#5025]({{ site.repository }}/issues/5025))
- rubocop: lib/jekyll/configuration.rb ([#5024]({{ site.repository }}/issues/5024))
- rubocop: lib/jekyll/renderer.rb style fixes ([#5032]({{ site.repository }}/issues/5032))
- rubocop: lib/jekyll/convertible.rb style fixes ([#5031]({{ site.repository }}/issues/5031))
- rubocop: lib/jekyll/document.rb style fixes ([#5030]({{ site.repository }}/issues/5030))
- Remove ruby-head from Travis matrix & fix jruby failures ([#5015]({{ site.repository }}/issues/5015))
- Remove useless statement from Configuration test ([#5065]({{ site.repository }}/issues/5065))
- Change baseurl to example.com for some test cases ([#5068]({{ site.repository }}/issues/5068))
- use activesupport < 5 if we are on a Ruby < 2.2.2 ([#5100]({{ site.repository }}/issues/5100))
- Internal documentation for working on Jekyll ([#5011]({{ site.repository }}/issues/5011))
- rubocop: lib/jekyll/collection.rb ([#5022]({{ site.repository }}/issues/5022))
- tests: Typo fixes. ([#5114]({{ site.repository }}/issues/5114))
- Normalize yml files. ([#5116]({{ site.repository }}/issues/5116))
- Whitespace cleanup. ([#5113]({{ site.repository }}/issues/5113))
- Add AppVeyor support. ([#5115]({{ site.repository }}/issues/5115))
- appveyor.yml: drop Ruby 2.0.0. ([#5119]({{ site.repository }}/issues/5119))
- Fix indentation in benchmark ([#5124]({{ site.repository }}/issues/5124))
- Style fixes for Rubocop 0.42.0 - var == 0 becomes var.zero? - when defining method_missing, also define respond_to_missing? ([#5137]({{ site.repository }}/issues/5137))

### Site Enhancements
{: #site-enhancements-v3-2-0}

- Add jekyll-seo-tag, jekyll-avatar, and jekyll-sitemap to the site ([#4553]({{ site.repository }}/issues/4553))
- Add Google search query to /docs/help/ ([#4589]({{ site.repository }}/issues/4589))
- Upgrading, documentation ([#4597]({{ site.repository }}/issues/4597))
- Add 'view source' entry ([#4602]({{ site.repository }}/issues/4602))
- Add jekyll-video-embed to list of third-party plugins. ([#4621]({{ site.repository }}/issues/4621))
- Adding Aerobatic to list of deployment options ([#4630]({{ site.repository }}/issues/4630))
- Update documentation: HTMLProofer CLI command ([#4641]({{ site.repository }}/issues/4641))
- Document that subdirectories of `_posts` are no longer categories ([#4639]({{ site.repository }}/issues/4639))
- Update continuous-integration docs with sudo: false information ([#4628]({{ site.repository }}/issues/4628))
- Blog post on refreshed contributing file and new affinity teams ([#4645]({{ site.repository }}/issues/4645))
- Fixes typo on collections ([#4647]({{ site.repository }}/issues/4647))
- Documentation: future option also works for collections ([#4682]({{ site.repository }}/issues/4682))
- Additional package needed for Fedora 23 Workspace ([#4685]({{ site.repository }}/issues/4685))
- Fix typo on Chocolatey name in Windows documentation ([#4686]({{ site.repository }}/issues/4686))
- Use the correct URL, Fixes [#4698]({{ site.repository }}/issues/4698) ([#4699]({{ site.repository }}/issues/4699))
- Add jekyll-paspagon plugin ([#4700]({{ site.repository }}/issues/4700))
- Bold-italicize note in assets documentation about needing front matter ([#4706]({{ site.repository }}/issues/4706))
- Highlight the `script/` calls in the Contributing documentation ([#4712]({{ site.repository }}/issues/4712))
- Add Hawkins to the list of third-party plugins ([#4755]({{ site.repository }}/issues/4755))
- Fix a typo in pagination doc ([#4763]({{ site.repository }}/issues/4763))
- Switch second GitHub Pages link to HTTPS ([#4760]({{ site.repository }}/issues/4760))
- Explain data file format requirements more clearly in documentation ([#4781]({{ site.repository }}/issues/4781))
- Add jekyll-i18n_tags to list of third-party plugins ([#4775]({{ site.repository }}/issues/4775))
- Remove Leonard Lamprecht's website from Sites page ([#4771]({{ site.repository }}/issues/4771))
- Updates documentation for collections to include `date` property ([#4769]({{ site.repository }}/issues/4769))
- Added an explicit rerun note to configuration.md, defaults section ([#4734]({{ site.repository }}/issues/4734))
- Update Rack-Jekyll Heroku deployment blog post url ([#4789]({{ site.repository }}/issues/4789))
- Added missing single quote on rsync client side command ([#4813]({{ site.repository }}/issues/4813))
- Organize Form Platforms-as-a-Service into unified list & add FormSpree.io ([#4754]({{ site.repository }}/issues/4754))
- Fixed typo on Configuration page ([#4804]({{ site.repository }}/issues/4804))
- Update FormKeep URL on the Resources doc ([#4844]({{ site.repository }}/issues/4844))
- site: use liquid & reduce some whitespace noise ([#4854]({{ site.repository }}/issues/4854))
- Add jekyll-breadcrumbs to list of third-party plugins ([#4874]({{ site.repository }}/issues/4874))
- Added Pug converter to list of third-party plugins ([#4872]({{ site.repository }}/issues/4872))
- Add jekyll-ideal-image-slider to list of third-party plugins ([#4863]({{ site.repository }}/issues/4863))
- Add Jekyll Tips and the Cheatsheet to the list of resources ([#4887]({{ site.repository }}/issues/4887))
- Removed extra `</p>` from `site/_docs/permalinks.md` ([#4890]({{ site.repository }}/issues/4890))
- Add pubstorm deployment instructions to docs ([#4881]({{ site.repository }}/issues/4881))
- Corrected pagination docs for hidden: true feature ([#4903]({{ site.repository }}/issues/4903))
- Remove a Broken Link for Refheap Plugin ([#4971]({{ site.repository }}/issues/4971))
- Instructions on how to install github-gem on Windows ([#4975]({{ site.repository }}/issues/4975))
- Minor tweak to fix missing apostrophe ([#4962]({{ site.repository }}/issues/4962))
- Instructions on how to install github-gem on Windows (v2) ([#4977]({{ site.repository }}/issues/4977))
- Fix inaccurate HTTP response header field name ([#4976]({{ site.repository }}/issues/4976))
- Add post about GSoC project ([#4980]({{ site.repository }}/issues/4980))
- Link to the HTML page instead of Markdown ([#4985]({{ site.repository }}/issues/4985))
- Update normalize.css to v4.0.0. ([#4989]({{ site.repository }}/issues/4989))
- Add jekyll-tags-list-plugin to list of third-party plugins ([#5000]({{ site.repository }}/issues/5000))
- Windows docs: Command needs to be called from blog path ([#5006]({{ site.repository }}/issues/5006))
- Update text to be consistent with example ([#5010]({{ site.repository }}/issues/5010))
- Update template links to point to core Liquid site ([#5012]({{ site.repository }}/issues/5012))
- Add generator-jekyllized to third-party plugins ([#5027]({{ site.repository }}/issues/5027))
- Add Jekyll Art Gallery generator plugin to list of third-party plugins ([#5043]({{ site.repository }}/issues/5043))
- Add Formingo to the list of Jekyll form SaaS ([#5054]({{ site.repository }}/issues/5054))
- Highlight help nav item when navigated to. ([#5058]({{ site.repository }}/issues/5058))
- Update normalize.css to v4.2.0. ([#5096]({{ site.repository }}/issues/5096))
- Updates html-proofer code ([#5098]({{ site.repository }}/issues/5098))
- Jekyll Community ([#5097]({{ site.repository }}/issues/5097))
- Typo in documentation file templates.md ([#5117]({{ site.repository }}/issues/5117))
- Slightly, improve PNG compression. ([#5112]({{ site.repository }}/issues/5112))
- docs: add jekyll-maps plugin reference ([#5123]({{ site.repository }}/issues/5123))
- docs: fix link to plugins page source ([#5122]({{ site.repository }}/issues/5122))
- Update the configuration docs to match the code ([#5131]({{ site.repository }}/issues/5131))
- Removed confusing word repetition. ([#5139]({{ site.repository }}/issues/5139))
- Add a note about script/fmt ([#5138]({{ site.repository }}/issues/5138))


## 3.1.6 / 2016-05-19
{: #v3-1-6}

### Bug Fixes
{: #bug-fixes-v3-1-6}

- Add ability to `jsonify` Drops such that, e.g. `site | jsonify`, works. ([#4914]({{ site.repository }}/issues/4914))


## 3.1.5 / 2016-05-18
{: #v3-1-5}

### Bug Fixes
{: #bug-fixes-v3-1-5}

- Sort the results of the `require_all` glob (affects Linux only). ([#4912]({{ site.repository }}/issues/4912))


## 3.1.4 / 2016-05-18
{: #v3-1-4}

### Bug Fixes
{: #bug-fixes-v3-1-4}

- Add `ExcerptDrop` and remove excerpt's ability to refer to itself in Liquid ([#4907]({{ site.repository }}/issues/4907))
- Configuration permalink fix where `collections.posts.permalink` inherits properly from `permalink` only when it doesn't exist ([#4910]({{ site.repository }}/issues/4910))
- Add `Configuration.from` to make it easier to build configs from just a hash
- Sorting `site.collections` in Liquid by label ([#4910]({{ site.repository }}/issues/4910))
- Fix bug where `layout` in Liquid would inherit from previously-rendered layouts' metadatas ([#4909]({{ site.repository }}/issues/4909))
- Fix bug where `layout` in Liquid would override in the wrong direction (more-specific layouts' data were overwritten by their parent layouts' data; this has now been reversed) ([#4909]({{ site.repository }}/issues/4909))


## 3.1.3 / 2016-04-18
{: #v3-1-3}

- Fix defaults for Documents to lookup defaults based on `relative_path` instead of `url` ([#4807]({{ site.repository }}/issues/4807))
- Use SSLEnable instead of EnableSSL and make URL HTTPS (WEBrick) ([#4693]({{ site.repository }}/issues/4693))


## 3.1.2 / 2016-02-19
{: #v3-1-2}

### Minor Enhancements
{: #minor-enhancements-v3-1-2}

- Include `.rubocop.yml` in Gem ([#4437]({{ site.repository }}/issues/4437))
- `LiquidRenderer#parse`: parse with line numbers. ([#4452]({{ site.repository }}/issues/4452))
- Add consistency to the no-subcommand deprecation message ([#4505]({{ site.repository }}/issues/4505))

### Bug Fixes
{: #bug-fixes-v3-1-2}

- Fix syntax highlighting in kramdown by making `@config` accessible in the Markdown converter. ([#4428]({{ site.repository }}/issues/4428))
- `Jekyll.sanitized_path`: sanitizing a questionable path should handle tildes ([#4492]({{ site.repository }}/issues/4492))
- Fix `titleize` so already capitalized words are not dropped ([#4525]({{ site.repository }}/issues/4525))
- Permalinks which end in a slash should always output HTML ([#4546]({{ site.repository }}/issues/4546))

### Development Fixes
{: #development-fixes-v3-1-2}

- Require at least cucumber version 2.1.0 ([#4514]({{ site.repository }}/issues/4514))

### Site Enhancements
{: #site-enhancements-v3-1-2}

- Add jekyll-toc plugin ([#4429]({{ site.repository }}/issues/4429))
- Docs: Quickstart - added documentation about the `--force` option ([#4410]({{ site.repository }}/issues/4410))
- Fix broken links to the Code of Conduct ([#4436]({{ site.repository }}/issues/4436))
- Upgrade notes: mention trailing slash in permalink; fixes [#4440]({{ site.repository }}/issues/4440) ([#4455]({{ site.repository }}/issues/4455))
- Add hooks to the plugin categories toc ([#4463]({{ site.repository }}/issues/4463))
- Jekyll 3 requires newer version of Ruby. ([#4461]({{ site.repository }}/issues/4461))
- Fix typo in upgrading docs ([#4473]({{ site.repository }}/issues/4473))
- Add note about upgrading documentation on jekyllrb.com/help/ ([#4484]({{ site.repository }}/issues/4484))
- Update Rake link ([#4496]({{ site.repository }}/issues/4496))
- Update & prune the short list of example sites ([#4374]({{ site.repository }}/issues/4374))
- Added amp-jekyll plugin to plugins docs ([#4517]({{ site.repository }}/issues/4517))
- A few grammar fixes ([#4512]({{ site.repository }}/issues/4512))
- Correct a couple mistakes in structure.md ([#4522]({{ site.repository }}/issues/4522))


## 3.1.1 / 2016-01-29
{: #v3-1-1}

### Meta

- Update the Code of Conduct to the latest version ([#4402]({{ site.repository }}/issues/4402))

### Bug Fixes
{: #bug-fixes-v3-1-1}

- `Page#dir`: ensure it ends in a slash ([#4403]({{ site.repository }}/issues/4403))
- Add `Utils.merged_file_read_opts` to unify reading & strip the BOM ([#4404]({{ site.repository }}/issues/4404))
- `Renderer#output_ext`: honor folders when looking for ext ([#4401]({{ site.repository }}/issues/4401))

### Development Fixes
{: #development-fixes-v3-1-1}

- Suppress stdout in liquid profiling test ([#4409]({{ site.repository }}/issues/4409))


## 3.1.0 / 2016-01-23
{: #v3-1-0}

### Minor Enhancements
{: #minor-enhancements-v3-1-0}

- Use `Liquid::Drop`s instead of `Hash`es in `#to_liquid` ([#4277]({{ site.repository }}/issues/4277))
- Add 'sample' Liquid filter Equivalent to Array#sample functionality ([#4223]({{ site.repository }}/issues/4223))
- Cache parsed include file to save liquid parsing time. ([#4120]({{ site.repository }}/issues/4120))
- Slightly speed up url sanitization and handle multiples of ///. ([#4168]({{ site.repository }}/issues/4168))
- Print debug message when a document is skipped from reading ([#4180]({{ site.repository }}/issues/4180))
- Include tag should accept multiple variables in the include name ([#4183]({{ site.repository }}/issues/4183))
- Add `-o` option to serve command which opens server URL ([#4144]({{ site.repository }}/issues/4144))
- Add CodeClimate platform for better code quality. ([#4220]({{ site.repository }}/issues/4220))
- General improvements for WEBrick via jekyll serve such as SSL & custom headers ([#4224]({{ site.repository }}/issues/4224), [#4228]({{ site.repository }}/issues/4228))
- Add a default charset to content-type on webrick. ([#4231]({{ site.repository }}/issues/4231))
- Switch `PluginManager` to use `require_with_graceful_fail` for better UX ([#4233]({{ site.repository }}/issues/4233))
- Allow quoted date in front matter defaults ([#4184]({{ site.repository }}/issues/4184))
- Add a Jekyll doctor warning for URLs that only differ by case ([#3171]({{ site.repository }}/issues/3171))
- drops: create one base Drop class which can be set as mutable or not ([#4285]({{ site.repository }}/issues/4285))
- drops: provide `#to_h` to allow for hash introspection ([#4281]({{ site.repository }}/issues/4281))
- Shim subcommands with indication of gem possibly required so users know how to use them ([#4254]({{ site.repository }}/issues/4254))
- Add smartify Liquid filter for SmartyPants ([#4323]({{ site.repository }}/issues/4323))
- Raise error on empty permalink ([#4361]({{ site.repository }}/issues/4361))
- Refactor Page#permalink method ([#4389]({{ site.repository }}/issues/4389))

### Bug Fixes
{: #bug-fixes-v3-1-0}

- Pass build options into `clean` command ([#4177]({{ site.repository }}/issues/4177))
- Allow users to use .htm and .xhtml (XHTML5.) ([#4160]({{ site.repository }}/issues/4160))
- Prevent Shell Injection. ([#4200]({{ site.repository }}/issues/4200))
- Convertible should make layout data accessible via `layout` instead of `page` ([#4205]({{ site.repository }}/issues/4205))
- Avoid using `Dir.glob` with absolute path to allow special characters in the path ([#4150]({{ site.repository }}/issues/4150))
- Handle empty config files ([#4052]({{ site.repository }}/issues/4052))
- Rename `@options` so that it does not impact Liquid. ([#4173]({{ site.repository }}/issues/4173))
- utils/drops: update Drop to support `Utils.deep_merge_hashes` ([#4289]({{ site.repository }}/issues/4289))
- Make sure jekyll/drops/drop is loaded first. ([#4292]({{ site.repository }}/issues/4292))
- Convertible/Page/Renderer: use payload hash accessor & setter syntax for backwards-compatibility ([#4311]({{ site.repository }}/issues/4311))
- Drop: fix hash setter precedence ([#4312]({{ site.repository }}/issues/4312))
- utils: `has_yaml_header?` should accept files with extraneous spaces ([#4290]({{ site.repository }}/issues/4290))
- Escape html from site.title and page.title in site template ([#4307]({{ site.repository }}/issues/4307))
- Allow custom file extensions if defined in `permalink` front matter ([#4314]({{ site.repository }}/issues/4314))
- Fix deep_merge_hashes! handling of drops and hashes ([#4359]({{ site.repository }}/issues/4359))
- Page should respect output extension of its permalink ([#4373]({{ site.repository }}/issues/4373))
- Disable auto-regeneration when running server detached ([#4376]({{ site.repository }}/issues/4376))
- Drop#: only use public_send for keys in the content_methods array ([#4388]({{ site.repository }}/issues/4388))
- Extract title from filename successfully when no date. ([#4195]({{ site.repository }}/issues/4195))

### Development Fixes
{: #development-fixes-v3-1-0}

- `jekyll-docs` should be easily release-able ([#4152]({{ site.repository }}/issues/4152))
- Allow use of Cucumber 2.1 or greater ([#4181]({{ site.repository }}/issues/4181))
- Modernize Kramdown for Markdown converter. ([#4109]({{ site.repository }}/issues/4109))
- Change TestDoctorCommand to JekyllUnitTest... ([#4263]({{ site.repository }}/issues/4263))
- Create namespaced rake tasks in separate `.rake` files under `lib/tasks` ([#4282]({{ site.repository }}/issues/4282))
- markdown: refactor for greater readability & efficiency ([#3771]({{ site.repository }}/issues/3771))
- Fix many Rubocop style errors ([#4301]({{ site.repository }}/issues/4301))
- Fix spelling of "GitHub" in docs and history ([#4322]({{ site.repository }}/issues/4322))
- Reorganize and cleanup the Gemfile, shorten required depends. ([#4318]({{ site.repository }}/issues/4318))
- Remove script/rebund. ([#4341]({{ site.repository }}/issues/4341))
- Implement codeclimate platform ([#4340]({{ site.repository }}/issues/4340))
- Remove ObjectSpace dumping and start using inherited, it's faster. ([#4342]({{ site.repository }}/issues/4342))
- Add script/travis so all people can play with Travis-CI images. ([#4338]({{ site.repository }}/issues/4338))
- Move Cucumber to using RSpec-Expectations and furthering JRuby support. ([#4343]({{ site.repository }}/issues/4343))
- Rearrange Cucumber and add some flair. ([#4347]({{ site.repository }}/issues/4347))
- Remove old FIXME ([#4349]({{ site.repository }}/issues/4349))
- Clean up the Gemfile (and keep all the necessary dependencies) ([#4350]({{ site.repository }}/issues/4350))

### Site Enhancements
{: #site-enhancements-v3-1-0}

- Add three plugins to directory ([#4163]({{ site.repository }}/issues/4163))
- Add upgrading docs from 2.x to 3.x ([#4157]({{ site.repository }}/issues/4157))
- Add `protect_email` to the plugins index. ([#4169]({{ site.repository }}/issues/4169))
- Add `jekyll-deploy` to list of third-party plugins ([#4179]({{ site.repository }}/issues/4179))
- Clarify plugin docs ([#4154]({{ site.repository }}/issues/4154))
- Add Kickster to deployment methods in documentation ([#4190]({{ site.repository }}/issues/4190))
- Add DavidBurela's tutorial for Windows to Windows docs page ([#4210]({{ site.repository }}/issues/4210))
- Change GitHub code block to highlight tag to avoid it overlaps parent div ([#4121]({{ site.repository }}/issues/4121))
- Update FormKeep link to be something more specific to Jekyll ([#4243]({{ site.repository }}/issues/4243))
- Remove example Roger Chapman site, as the domain doesn't exist ([#4249]({{ site.repository }}/issues/4249))
- Added configuration options for `draft_posts` to configuration docs ([#4251]({{ site.repository }}/issues/4251))
- Fix checklist in `_assets.md` ([#4259]({{ site.repository }}/issues/4259))
- Add Markdown examples to Pages docs ([#4275]({{ site.repository }}/issues/4275))
- Add jekyll-paginate-category to list of third-party plugins ([#4273]({{ site.repository }}/issues/4273))
- Add `jekyll-responsive_image` to list of third-party plugins ([#4286]({{ site.repository }}/issues/4286))
- Add `jekyll-commonmark` to list of third-party plugins ([#4299]({{ site.repository }}/issues/4299))
- Add documentation for incremental regeneration ([#4293]({{ site.repository }}/issues/4293))
- Add note about removal of relative permalink support in upgrading docs ([#4303]({{ site.repository }}/issues/4303))
- Add Pro Tip to use front matter variable to create clean URLs ([#4296]({{ site.repository }}/issues/4296))
- Fix grammar in the documentation for posts. ([#4330]({{ site.repository }}/issues/4330))
- Add documentation for smartify Liquid filter ([#4333]({{ site.repository }}/issues/4333))
- Fixed broken link to blog on using mathjax with jekyll ([#4344]({{ site.repository }}/issues/4344))
- Documentation: correct reference in Precedence section of Configuration docs ([#4355]({{ site.repository }}/issues/4355))
- Add @jmcglone's guide to github-pages doc page ([#4364]({{ site.repository }}/issues/4364))
- Added the Wordpress2Jekyll Wordpress plugin ([#4377]({{ site.repository }}/issues/4377))
- Add Contentful Extension to list of third-party plugins ([#4390]({{ site.repository }}/issues/4390))
- Correct Minor spelling error ([#4394]({{ site.repository }}/issues/4394))


## 3.0.5 / 2016-04-26
{: #v3-0-5}

- Remove call to `#backwards_compatibilize` in `Configuration.from` ([#4846]({{ site.repository }}/issues/4846))


## 3.0.4 / 2016-04-18
{: #v3-0-4}

- Fix defaults for Documents to lookup defaults based on `relative_path` instead of `url` ([#4806]({{ site.repository }}/issues/4806))
- Configuration: allow users to specify a `collections.posts.permalink` directly without `permalink` clobbering it ([#4753]({{ site.repository }}/issues/4753))


## 3.0.3 / 2016-02-08
{: #v3-0-3}

### Bug Fixes
{: #bug-fixes-v3-0-3}

- Fix extension weirdness with folders ([#4493]({{ site.repository }}/issues/4493))
- EntryFilter: only include 'excluded' log on excluded files ([#4479]({{ site.repository }}/issues/4479))
- `Jekyll.sanitized_path`: escape tildes before sanitizing a questionable path ([#4468]({{ site.repository }}/issues/4468))
- `LiquidRenderer#parse`: parse with line numbers ([#4453]({{ site.repository }}/issues/4453))
- `Document#<=>`: protect against nil comparison in dates. ([#4446]({{ site.repository }}/issues/4446))


## 3.0.2 / 2016-01-20
{: #v3-0-2}

### Bug Fixes
{: #bug-fixes-v3-0-2}

- Document: throw a useful error when an invalid date is given ([#4378]({{ site.repository }}/issues/4378))


## 3.0.1 / 2015-11-17
{: #v3-0-1}

### Bug Fixes
{: #bug-fixes-v3-0-1}

- Document: only superdirectories of the collection are categories ([#4110]({{ site.repository }}/issues/4110))
- `Convertible#render_liquid` should use `render!` to cause failure on bad Liquid ([#4077]({{ site.repository }}/issues/4077))
- Don't generate `.jekyll-metadata` in non-incremental build ([#4079]({{ site.repository }}/issues/4079))
- Set `highlighter` config val to `kramdown.syntax_highlighter` ([#4090]({{ site.repository }}/issues/4090))
- Align hooks implementation with documentation ([#4104]({{ site.repository }}/issues/4104))
- Fix the deprecation warning in the doctor command ([#4114]({{ site.repository }}/issues/4114))
- Fix case in `:title` and add `:slug` which is downcased ([#4100]({{ site.repository }}/issues/4100))

### Development Fixes
{: #development-fixes-v3-0-1}

- Fix test warnings when doing rake {test,spec} or script/test ([#4078]({{ site.repository }}/issues/4078))

### Site Enhancements
{: #site-enhancements-v3-0-1}

- Update normalize.css to v3.0.3. ([#4085]({{ site.repository }}/issues/4085))
- Update Font Awesome to v4.4.0. ([#4086]({{ site.repository }}/issues/4086))
- Adds a note about installing the jekyll-gist gem to make gist tag work ([#4101]({{ site.repository }}/issues/4101))
- Align hooks documentation with implementation ([#4104]({{ site.repository }}/issues/4104))
- Add Jekyll Flickr Plugin to the list of third party plugins ([#4111]({{ site.repository }}/issues/4111))
- Remove link to now-deleted blog post ([#4125]({{ site.repository }}/issues/4125))
- Update the liquid syntax in the pagination docs ([#4130]({{ site.repository }}/issues/4130))
- Add jekyll-language-plugin to plugins.md ([#4134]({{ site.repository }}/issues/4134))
- Updated to reflect feedback in [#4129]({{ site.repository }}/issues/4129) ([#4137]({{ site.repository }}/issues/4137))
- Clarify assets.md based on feedback of [#4129]({{ site.repository }}/issues/4129) ([#4142]({{ site.repository }}/issues/4142))
- Re-correct the liquid syntax in the pagination docs ([#4140]({{ site.repository }}/issues/4140))


## 3.0.0 / 2015-10-26
{: #v3-0-0}

### Major Enhancements
{: #major-enhancements-v3-0-0}

- Liquid profiler (i.e. know how fast or slow your templates render) ([#3762]({{ site.repository }}/issues/3762))
- Incremental regeneration ([#3116]({{ site.repository }}/issues/3116))
- Add Hooks: a new kind of plugin ([#3553]({{ site.repository }}/issues/3553))
- Upgrade to Liquid 3.0.0 ([#3002]({{ site.repository }}/issues/3002))
- `site.posts` is now a Collection instead of an Array ([#4055]({{ site.repository }}/issues/4055))
- Add basic support for JRuby (commit: 0f4477)
- Drop support for Ruby 1.9.3. ([#3235]({{ site.repository }}/issues/3235))
- Support Ruby v2.2 ([#3234]({{ site.repository }}/issues/3234))
- Support RDiscount 2 ([#2767]({{ site.repository }}/issues/2767))
- Remove most runtime deps ([#3323]({{ site.repository }}/issues/3323))
- Move to Rouge as default highlighter ([#3323]({{ site.repository }}/issues/3323))
- Mimic GitHub Pages `.html` extension stripping behavior in WEBrick ([#3452]({{ site.repository }}/issues/3452))
- Always include file extension on output files ([#3490]({{ site.repository }}/issues/3490))
- Improved permalinks for pages and collections ([#3538]({{ site.repository }}/issues/3538))
- Sunset (i.e. remove) Maruku ([#3655]({{ site.repository }}/issues/3655))
- Remove support for relative permalinks ([#3679]({{ site.repository }}/issues/3679))
- Iterate over `site.collections` as an array instead of a hash. ([#3670]({{ site.repository }}/issues/3670))
- Adapt StaticFile for collections, config defaults ([#3823]({{ site.repository }}/issues/3823))
- Add a Code of Conduct for the Jekyll project ([#3925]({{ site.repository }}/issues/3925))
- Added permalink time variables ([#3990]({{ site.repository }}/issues/3990))
- Add `--incremental` flag to enable incremental regen (disabled by default) ([#4059]({{ site.repository }}/issues/4059))

### Minor Enhancements
{: #minor-enhancements-v3-0-0}

- Deprecate access to Document#data properties and Collection#docs methods ([#4058]({{ site.repository }}/issues/4058))
- Sort static files just once, and call `site_payload` once for all collections ([#3204]({{ site.repository }}/issues/3204))
- Separate `jekyll docs` and optimize external gem handling ([#3241]({{ site.repository }}/issues/3241))
- Improve `Site#getConverterImpl` and call it `Site#find_converter_instance` ([#3240]({{ site.repository }}/issues/3240))
- Use relative path for `path` Liquid variable in Documents for consistency ([#2908]({{ site.repository }}/issues/2908))
- Generalize `Utils#slugify` for any scripts ([#3047]({{ site.repository }}/issues/3047))
- Added basic microdata to post template in site template ([#3189]({{ site.repository }}/issues/3189))
- Store log messages in an array of messages. ([#3244]({{ site.repository }}/issues/3244))
- Allow collection documents to override `output` property in front matter ([#3172]({{ site.repository }}/issues/3172))
- Keep file modification times between builds for static files ([#3220]({{ site.repository }}/issues/3220))
- Only downcase mixed-case categories for the URL ([#2571]({{ site.repository }}/issues/2571))
- Added per post `excerpt_separator` functionality ([#3274]({{ site.repository }}/issues/3274))
- Allow collections YAML to end with three dots ([#3134]({{ site.repository }}/issues/3134))
- Add mode parameter to `slugify` Liquid filter ([#2918]({{ site.repository }}/issues/2918))
- Perf: `Markdown#matches` should avoid regexp ([#3321]({{ site.repository }}/issues/3321))
- Perf: Use frozen regular expressions for `Utils#slugify` ([#3321]({{ site.repository }}/issues/3321))
- Split off Textile support into jekyll-textile-converter ([#3319]({{ site.repository }}/issues/3319))
- Improve the navigation menu alignment in the site template on small screens ([#3331]({{ site.repository }}/issues/3331))
- Show the regeneration time after the initial generation ([#3378]({{ site.repository }}/issues/3378))
- Site template: Switch default font to Helvetica Neue ([#3376]({{ site.repository }}/issues/3376))
- Make the `include` tag a teensy bit faster. ([#3391]({{ site.repository }}/issues/3391))
- Add `pkill -f jekyll` to ways to kill. ([#3397]({{ site.repository }}/issues/3397))
- Site template: collapsed, variable-driven font declaration ([#3360]({{ site.repository }}/issues/3360))
- Site template: Don't always show the scrollbar in code blocks ([#3419]({{ site.repository }}/issues/3419))
- Site template: Remove undefined `text` class from `p` element ([#3440]({{ site.repository }}/issues/3440))
- Site template: Optimize text rendering for legibility ([#3382]({{ site.repository }}/issues/3382))
- Add `draft?` method to identify if Post is a Draft & expose to Liquid ([#3456]({{ site.repository }}/issues/3456))
- Write regeneration metadata even on full rebuild ([#3464]({{ site.repository }}/issues/3464))
- Perf: Use `String#end_with?("/")` instead of regexp when checking paths ([#3516]({{ site.repository }}/issues/3516))
- Docs: document 'ordinal' built-in permalink style ([#3532]({{ site.repository }}/issues/3532))
- Upgrade liquid-c to 3.x ([#3531]({{ site.repository }}/issues/3531))
- Use consistent syntax for deprecation warning ([#3535]({{ site.repository }}/issues/3535))
- Added build --destination and --source flags ([#3418]({{ site.repository }}/issues/3418))
- Site template: remove unused `page.meta` attribute ([#3537]({{ site.repository }}/issues/3537))
- Improve the error message when sorting null objects ([#3520]({{ site.repository }}/issues/3520))
- Added liquid-md5 plugin ([#3598]({{ site.repository }}/issues/3598))
- Documentation: RR replaced with RSpec Mocks ([#3600]({{ site.repository }}/issues/3600))
- Documentation: Fix subpath. ([#3599]({{ site.repository }}/issues/3599))
- Create 'tmp' dir for test_tags if it doesn't exist ([#3609]({{ site.repository }}/issues/3609))
- Extract reading of data from `Site` to reduce responsibilities. ([#3545]({{ site.repository }}/issues/3545))
- Removed the word 'Jekyll' a few times from the comments ([#3617]({{ site.repository }}/issues/3617))
- `bin/jekyll`: with no args, exit with exit code 1 ([#3619]({{ site.repository }}/issues/3619))
- Incremental build if destination file missing ([#3614]({{ site.repository }}/issues/3614))
- Static files `mtime` liquid should return a `Time` obj ([#3596]({{ site.repository }}/issues/3596))
- Use `Jekyll::Post`s for both LSI indexing and lookup. ([#3629]({{ site.repository }}/issues/3629))
- Add `charset=utf-8` for HTML and XML pages in WEBrick ([#3649]({{ site.repository }}/issues/3649))
- Set log level to debug when verbose flag is set ([#3665]({{ site.repository }}/issues/3665))
- Added a mention on the Gemfile to complete the instructions ([#3671]({{ site.repository }}/issues/3671))
- Perf: Cache `Document#to_liquid` and invalidate where necessary ([#3693]({{ site.repository }}/issues/3693))
- Perf: `Jekyll::Cleaner#existing_files`: Call `keep_file_regex` and `keep_dirs` only once, not once per iteration ([#3696]({{ site.repository }}/issues/3696))
- Omit jekyll/jekyll-help from list of resources. ([#3698]({{ site.repository }}/issues/3698))
- Add basic `jekyll doctor` test to detect fsnotify (OSX) anomalies. ([#3704]({{ site.repository }}/issues/3704))
- Added talk.jekyllrb.com to "Have questions?" ([#3694]({{ site.repository }}/issues/3694))
- Performance: Sort files only once ([#3707]({{ site.repository }}/issues/3707))
- Performance: Marshal metadata ([#3706]({{ site.repository }}/issues/3706))
- Upgrade highlight wrapper from `div` to `figure` ([#3779]({{ site.repository }}/issues/3779))
- Upgrade mime-types to `~> 2.6` ([#3795]({{ site.repository }}/issues/3795))
- Update windows.md with Ruby version info ([#3818]({{ site.repository }}/issues/3818))
- Make the directory for includes configurable ([#3782]({{ site.repository }}/issues/3782))
- Rename directory configurations to match `*_dir` convention for consistency ([#3782]({{ site.repository }}/issues/3782))
- Internal: trigger hooks by owner symbol ([#3871]({{ site.repository }}/issues/3871))
- Update MIME types from mime-db ([#3933]({{ site.repository }}/issues/3933))
- Add header to site template `_config.yml` for clarity & direction ([#3997]({{ site.repository }}/issues/3997))
- Site template: add timezone offset to post date front matter ([#4001]({{ site.repository }}/issues/4001))
- Make a constant for the regex to find hidden files ([#4032]({{ site.repository }}/issues/4032))
- Site template: refactor github & twitter icons into includes ([#4049]({{ site.repository }}/issues/4049))
- Site template: add background to Kramdown Rouge-ified backtick code blocks ([#4053]({{ site.repository }}/issues/4053))

### Bug Fixes
{: #bug-fixes-v3-0-0}

- `post_url`: fix access deprecation warning & fix deprecation msg ([#4060]({{ site.repository }}/issues/4060))
- Perform jekyll-paginate deprecation warning correctly. ([#3580]({{ site.repository }}/issues/3580))
- Make permalink parsing consistent with pages ([#3014]({{ site.repository }}/issues/3014))
- `time()`pre-filter method should accept a `Date` object ([#3299]({{ site.repository }}/issues/3299))
- Remove unneeded end tag for `link` in site template ([#3236]({{ site.repository }}/issues/3236))
- Kramdown: Use `enable_coderay` key instead of `use_coderay` ([#3237]({{ site.repository }}/issues/3237))
- Unescape `Document` output path ([#2924]({{ site.repository }}/issues/2924))
- Fix nav items alignment when on multiple rows ([#3264]({{ site.repository }}/issues/3264))
- Highlight: Only Strip Newlines/Carriage Returns, not Spaces ([#3278]({{ site.repository }}/issues/3278))
- Find variables in front matter defaults by searching with relative file path. ([#2774]({{ site.repository }}/issues/2774))
- Allow variables (e.g `:categories`) in front matter permalinks ([#3320]({{ site.repository }}/issues/3320))
- Handle nil URL placeholders in permalinks ([#3325]({{ site.repository }}/issues/3325))
- Template: Fix nav items alignment when in "burger" mode ([#3329]({{ site.repository }}/issues/3329))
- Template: Remove `!important` from nav SCSS introduced in [#3329]({{ site.repository }}/issues/3329) ([#3375]({{ site.repository }}/issues/3375))
- The `:title` URL placeholder for collections should be the filename slug. ([#3383]({{ site.repository }}/issues/3383))
- Trim the generate time diff to just 3 places past the decimal place ([#3415]({{ site.repository }}/issues/3415))
- The highlight tag should only clip the newlines before and after the *entire* block, not in between ([#3401]({{ site.repository }}/issues/3401))
- highlight: fix problem with linenos and rouge. ([#3436]({{ site.repository }}/issues/3436))
- `Site#read_data_file`: read CSV's with proper file encoding ([#3455]({{ site.repository }}/issues/3455))
- Ignore `.jekyll-metadata` in site template ([#3496]({{ site.repository }}/issues/3496))
- Template: Point documentation link to the documentation pages ([#3502]({{ site.repository }}/issues/3502))
- Removed the trailing slash from the example `/blog` baseurl comment ([#3485]({{ site.repository }}/issues/3485))
- Clear the regenerator cache every time we process ([#3592]({{ site.repository }}/issues/3592))
- Readd (bring back) minitest-profile ([#3628]({{ site.repository }}/issues/3628))
- Add WOFF2 font MIME type to Jekyll server MIME types ([#3647]({{ site.repository }}/issues/3647))
- Be smarter about extracting the extname in `StaticFile` ([#3632]({{ site.repository }}/issues/3632))
- Process metadata for all dependencies ([#3608]({{ site.repository }}/issues/3608))
- Show error message if the front matter on a page/post is invalid. ([#3643]({{ site.repository }}/issues/3643))
- Upgrade redcarpet to 3.2 (Security fix: OSVDB-120415) ([#3652]({{ site.repository }}/issues/3652))
- Create #mock_expects that goes directly to RSpec Mocks. ([#3658]({{ site.repository }}/issues/3658))
- Open `.jekyll-metadata` in binary mode to read binary Marshal data ([#3713]({{ site.repository }}/issues/3713))
- Incremental regeneration: handle deleted, renamed, and moved dependencies ([#3717]({{ site.repository }}/issues/3717))
- Fix typo on line 19 of pagination.md ([#3760]({{ site.repository }}/issues/3760))
- Fix it so that 'blog.html' matches 'blog.html' ([#3732]({{ site.repository }}/issues/3732))
- Remove occasionally-problematic `ensure` in `LiquidRenderer` ([#3811]({{ site.repository }}/issues/3811))
- Fixed an unclear code comment in site template SCSS ([#3837]({{ site.repository }}/issues/3837))
- Fix reading of binary metadata file ([#3845]({{ site.repository }}/issues/3845))
- Remove var collision with site template header menu iteration variable ([#3838]({{ site.repository }}/issues/3838))
- Change non-existent `hl_linenos` to `hl_lines` to allow passthrough in safe mode ([#3787]({{ site.repository }}/issues/3787))
- Add missing flag to disable the watcher ([#3820]({{ site.repository }}/issues/3820))
- Update CI guide to include more direct explanations of the flow ([#3891]({{ site.repository }}/issues/3891))
- Set `future` to `false` in the default config ([#3892]({{ site.repository }}/issues/3892))
- filters: `where` should compare stringified versions of input & comparator ([#3935]({{ site.repository }}/issues/3935))
- Read build options for `jekyll clean` command ([#3828]({{ site.repository }}/issues/3828))
- Fix [#3970]({{ site.repository }}/issues/3970): Use Gem::Version to compare versions, not `>`.
- Abort if no subcommand. Fixes confusing message. ([#3992]({{ site.repository }}/issues/3992))
- Whole-post excerpts should match the post content ([#4004]({{ site.repository }}/issues/4004))
- Change default font weight to 400 to fix bold/strong text issues ([#4050]({{ site.repository }}/issues/4050))
- Document: Only auto-generate the excerpt if it's not overridden ([#4062]({{ site.repository }}/issues/4062))
- Utils: `deep_merge_hashes` should also merge `default_proc` (45f69bb)
- Defaults: compare paths in `applies_path?` as `String`s to avoid confusion (7b81f00)

### Development Fixes
{: #development-fixes-v3-0-0}

- Remove loader.rb and "modernize" `script/test`. ([#3574]({{ site.repository }}/issues/3574))
- Improve the grammar in the documentation ([#3233]({{ site.repository }}/issues/3233))
- Update the LICENSE text to match the MIT license exactly ([#3253]({{ site.repository }}/issues/3253))
- Update rake task `site:publish` to fix minor bugs. ([#3254]({{ site.repository }}/issues/3254))
- Switch to shields.io for the README badges. ([#3255]({{ site.repository }}/issues/3255))
- Use `FileList` instead of `Dir.glob` in `site:publish` rake task ([#3261]({{ site.repository }}/issues/3261))
- Fix test script to be platform-independent ([#3279]({{ site.repository }}/issues/3279))
- Instead of symlinking `/tmp`, create and symlink a local `tmp` in the tests ([#3258]({{ site.repository }}/issues/3258))
- Fix some spacing ([#3312]({{ site.repository }}/issues/3312))
- Fix comment typo in `lib/jekyll/frontmatter_defaults.rb` ([#3322]({{ site.repository }}/issues/3322))
- Move all `regenerate?` checking to `Regenerator` ([#3326]({{ site.repository }}/issues/3326))
- Factor out a `read_data_file` call to keep things clean ([#3380]({{ site.repository }}/issues/3380))
- Proof the site with CircleCI. ([#3427]({{ site.repository }}/issues/3427))
- Update LICENSE to 2015. ([#3477]({{ site.repository }}/issues/3477))
- Upgrade tests to use Minitest ([#3492]({{ site.repository }}/issues/3492))
- Remove trailing whitespace ([#3497]({{ site.repository }}/issues/3497))
- Use `fixture_site` for Document tests ([#3511]({{ site.repository }}/issues/3511))
- Remove adapters deprecation warning ([#3529]({{ site.repository }}/issues/3529))
- Minor fixes to `url.rb` to follow GitHub style guide ([#3544]({{ site.repository }}/issues/3544))
- Minor changes to resolve deprecation warnings ([#3547]({{ site.repository }}/issues/3547))
- Convert remaining textile test documents to markdown ([#3528]({{ site.repository }}/issues/3528))
- Migrate the tests to use rspec-mocks ([#3552]({{ site.repository }}/issues/3552))
- Remove `activesupport` ([#3612]({{ site.repository }}/issues/3612))
- Added tests for `Jekyll:StaticFile` ([#3633]({{ site.repository }}/issues/3633))
- Force minitest version to 5.5.1 ([#3657]({{ site.repository }}/issues/3657))
- Update the way cucumber accesses Minitest assertions ([#3678]({{ site.repository }}/issues/3678))
- Add `script/rubyprof` to generate cachegrind callgraphs ([#3692]({{ site.repository }}/issues/3692))
- Upgrade cucumber to 2.x ([#3795]({{ site.repository }}/issues/3795))
- Update Kramdown. ([#3853]({{ site.repository }}/issues/3853))
- Updated the scripts shebang for portability ([#3858]({{ site.repository }}/issues/3858))
- Update JRuby testing to 9K ([3ab386f](https://github.com/jekyll/jekyll/commit/3ab386f1b096be25a24fe038fc70fd0fb08d545d))
- Organize dependencies into dev and test groups. ([#3852]({{ site.repository }}/issues/3852))
- Contributing.md should refer to `script/cucumber` ([#3894]({{ site.repository }}/issues/3894))
- Update contributing documentation to reflect workflow updates ([#3895]({{ site.repository }}/issues/3895))
- Add script to vendor mime types ([#3933]({{ site.repository }}/issues/3933))
- Ignore .bundle dir in SimpleCov ([#4033]({{ site.repository }}/issues/4033))

### Site Enhancements
{: #site-enhancements-v3-0-0}

- Add 'info' labels to certain notes in collections docs ([#3601]({{ site.repository }}/issues/3601))
- Remove extra spaces, make the last sentence less awkward in permalink docs ([#3603]({{ site.repository }}/issues/3603))
- Update the permalinks documentation to reflect the updates for 3.0 ([#3556]({{ site.repository }}/issues/3556))
- Add blog post announcing Jekyll Help ([#3523]({{ site.repository }}/issues/3523))
- Add Jekyll Talk to Help page on site ([#3518]({{ site.repository }}/issues/3518))
- Change Ajax pagination resource link to use HTTPS ([#3570]({{ site.repository }}/issues/3570))
- Fixing the default host on docs ([#3229]({{ site.repository }}/issues/3229))
- Add `jekyll-thumbnail-filter` to list of third-party plugins ([#2790]({{ site.repository }}/issues/2790))
- Add link to 'Adding Ajax pagination to Jekyll' to Resources page ([#3186]({{ site.repository }}/issues/3186))
- Add a Resources link to tutorial on building dynamic navbars ([#3185]({{ site.repository }}/issues/3185))
- Semantic structure improvements to the post and page layouts ([#3251]({{ site.repository }}/issues/3251))
- Add new AsciiDoc plugin to list of third-party plugins. ([#3277]({{ site.repository }}/issues/3277))
- Specify that all transformable collection documents must contain front matter ([#3271]({{ site.repository }}/issues/3271))
- Assorted accessibility fixes ([#3256]({{ site.repository }}/issues/3256))
- Update configuration docs to mention `keep_files` for `destination` ([#3288]({{ site.repository }}/issues/3288), [#3296]({{ site.repository }}/issues/3296))
- Break when we successfully generate nav link to save CPU cycles. ([#3291]({{ site.repository }}/issues/3291))
- Update usage docs to mention `keep_files` and a warning about `destination` cleaning ([#3295]({{ site.repository }}/issues/3295))
- Add logic to automatically generate the `next_section` and `prev_section` navigation items ([#3292]({{ site.repository }}/issues/3292))
- Some small fixes for the Plugins TOC. ([#3306]({{ site.repository }}/issues/3306))
- Added versioning comment to configuration file ([#3314]({{ site.repository }}/issues/3314))
- Add `jekyll-minifier` to list of third-party plugins ([#3333]({{ site.repository }}/issues/3333))
- Add blog post about the Jekyll meet-up ([#3332]({{ site.repository }}/issues/3332))
- Use `highlight` Liquid tag instead of the four-space tabs for code ([#3336]({{ site.repository }}/issues/3336))
- 3.0.0.beta1 release post ([#3346]({{ site.repository }}/issues/3346))
- Add `twa` to the list of third-party plugins ([#3384]({{ site.repository }}/issues/3384))
- Remove extra spaces ([#3388]({{ site.repository }}/issues/3388))
- Fix small grammar errors on a couple pages ([#3396]({{ site.repository }}/issues/3396))
- Fix typo on Templates docs page ([#3420]({{ site.repository }}/issues/3420))
- s/three/four for plugin type list ([#3424]({{ site.repository }}/issues/3424))
- Release jekyllrb.com as a locally-compiled site. ([#3426]({{ site.repository }}/issues/3426))
- Add a jekyllrb.com/help page which elucidates places from which to get help ([#3428]({{ site.repository }}/issues/3428))
- Remove extraneous dash on Plugins doc page which caused a formatting error ([#3431]({{ site.repository }}/issues/3431))
- Fix broken link to Jordan Thornquest's website. ([#3438]({{ site.repository }}/issues/3438))
- Change the link to an extension ([#3457]({{ site.repository }}/issues/3457))
- Fix Twitter link on the help page ([#3466]({{ site.repository }}/issues/3466))
- Fix wording in code snippet highlighting section ([#3475]({{ site.repository }}/issues/3475))
- Add a `/` to `paginate_path` in the Pagination documentation ([#3479]({{ site.repository }}/issues/3479))
- Add a link on all the docs pages to "Improve this page". ([#3510]({{ site.repository }}/issues/3510))
- Add jekyll-auto-image generator to the list of third-party plugins ([#3489]({{ site.repository }}/issues/3489))
- Replace link to the proposed `picture` element spec ([#3530]({{ site.repository }}/issues/3530))
- Add front matter date formatting information ([#3469]({{ site.repository }}/issues/3469))
- Improve consistency and clarity of plugins options note ([#3546]({{ site.repository }}/issues/3546))
- Add permalink warning to pagination docs ([#3551]({{ site.repository }}/issues/3551))
- Fix grammar in Collections docs API stability warning ([#3560]({{ site.repository }}/issues/3560))
- Restructure `excerpt_separator` documentation for clarity ([#3550]({{ site.repository }}/issues/3550))
- Fix accidental line break in collections docs ([#3585]({{ site.repository }}/issues/3585))
- Add information about the `.jekyll-metadata` file ([#3597]({{ site.repository }}/issues/3597))
- Document addition of variable parameters to an include ([#3581]({{ site.repository }}/issues/3581))
- Add `jekyll-files` to the list of third-party plugins. ([#3586]({{ site.repository }}/issues/3586))
- Define the `install` step in the CI example `.travis.yml` ([#3622]({{ site.repository }}/issues/3622))
- Expand collections documentation. ([#3638]({{ site.repository }}/issues/3638))
- Add the "warning" note label to excluding `vendor` in the CI docs page ([#3623]({{ site.repository }}/issues/3623))
- Upgrade pieces of the Upgrading guide for Jekyll 3 ([#3607]({{ site.repository }}/issues/3607))
- Showing how to access specific data items ([#3468]({{ site.repository }}/issues/3468))
- Clarify pagination works from within HTML files ([#3467]({{ site.repository }}/issues/3467))
- Add note to `excerpt_separator` documentation that it can be set globally ([#3667]({{ site.repository }}/issues/3667))
- Fix some names on Troubleshooting page ([#3683]({{ site.repository }}/issues/3683))
- Add `remote_file_content` tag plugin to list of third-party plugins ([#3691]({{ site.repository }}/issues/3691))
- Update the Redcarpet version on the Configuration page. ([#3743]({{ site.repository }}/issues/3743))
- Update the link in the welcome post to point to Jekyll Talk ([#3745]({{ site.repository }}/issues/3745))
- Update link for navbars with data attributes tutorial ([#3728]({{ site.repository }}/issues/3728))
- Add `jekyll-asciinema` to list of third-party plugins ([#3750]({{ site.repository }}/issues/3750))
- Update pagination example to be agnostic to first pagination dir ([#3763]({{ site.repository }}/issues/3763))
- Detailed instructions for rsync deployment method ([#3848]({{ site.repository }}/issues/3848))
- Add Jekyll Portfolio Generator to list of plugins ([#3883]({{ site.repository }}/issues/3883))
- Add `site.html_files` to variables docs ([#3880]({{ site.repository }}/issues/3880))
- Add Static Publisher tool to list of deployment methods ([#3865]({{ site.repository }}/issues/3865))
- Fix a few typos. ([#3897]({{ site.repository }}/issues/3897))
- Add `jekyll-youtube` to the list of third-party plugins ([#3931]({{ site.repository }}/issues/3931))
- Add Views Router plugin ([#3950]({{ site.repository }}/issues/3950))
- Update install docs (Core dependencies, Windows reqs, etc) ([#3769]({{ site.repository }}/issues/3769))
- Use Jekyll Feed for jekyllrb.com ([#3736]({{ site.repository }}/issues/3736))
- Add jekyll-umlauts to plugins.md ($3966)
- Troubleshooting: fix broken link, add other mac-specific info ([#3968]({{ site.repository }}/issues/3968))
- Add a new site for learning purposes ([#3917]({{ site.repository }}/issues/3917))
- Added documentation for Jekyll environment variables ([#3989]({{ site.repository }}/issues/3989))
- Fix broken configuration documentation page ([#3994]({{ site.repository }}/issues/3994))
- Add troubleshooting docs for installing on El Capitan ([#3999]({{ site.repository }}/issues/3999))
- Add Lazy Tweet Embedding to the list of third-party plugins ([#4015]({{ site.repository }}/issues/4015))
- Add installation instructions for 2 of 3 options for plugins ([#4013]({{ site.repository }}/issues/4013))
- Add alternative jekyll gem installation instructions ([#4018]({{ site.repository }}/issues/4018))
- Fix a few typos and formatting problems. ([#4022]({{ site.repository }}/issues/4022))
- Fix pretty permalink example ([#4029]({{ site.repository }}/issues/4029))
- Note that `_config.yml` is not reloaded during regeneration ([#4034]({{ site.repository }}/issues/4034))
- Apply code block figure syntax to blocks in CONTRIBUTING ([#4046]({{ site.repository }}/issues/4046))
- Add jekyll-smartify to the list of third-party plugins ([#3572]({{ site.repository }}/issues/3572))


## 2.5.3 / 2014-12-22
{: #v2-5-3}

### Bug Fixes
{: #bug-fixes-v2-5-3}

- When checking a Markdown extname, include position of the `.` ([#3147]({{ site.repository }}/issues/3147))
- Fix `jsonify` Liquid filter handling of boolean values ([#3154]({{ site.repository }}/issues/3154))
- Add comma to value of `viewport` meta tag ([#3170]({{ site.repository }}/issues/3170))
- Set the link type for the RSS feed to `application/rss+xml` ([#3176]({{ site.repository }}/issues/3176))
- Refactor `#as_liquid` ([#3158]({{ site.repository }}/issues/3158))

### Development Fixes
{: #development-fixes-v2-5-3}

- Exclude built-in bundles from being added to coverage report ([#3180]({{ site.repository }}/issues/3180))

### Site Enhancements
{: #site-enhancements-v2-5-3}

- Add @alfredxing to the @jekyll/core team. :tada: ([#3218]({{ site.repository }}/issues/3218))
- Document the `-q` option for the `build` and `serve` commands ([#3149]({{ site.repository }}/issues/3149))
- Fix some minor typos/flow fixes in documentation website content ([#3165]({{ site.repository }}/issues/3165))
- Add `keep_files` to configuration documentation ([#3162]({{ site.repository }}/issues/3162))
- Repeat warning about cleaning of the `destination` directory ([#3161]({{ site.repository }}/issues/3161))
- Add jekyll-500px-embed to list of third-party plugins ([#3163]({{ site.repository }}/issues/3163))
- Simplified platform detection in Gemfile example for Windows ([#3177]({{ site.repository }}/issues/3177))
- Add the `jekyll-jalali` plugin added to the list of third-party plugins. ([#3198]({{ site.repository }}/issues/3198))
- Add Table of Contents to Troubleshooting page ([#3196]({{ site.repository }}/issues/3196))
- Add `inline_highlight` plugin to list of third-party plugins ([#3212]({{ site.repository }}/issues/3212))
- Add `jekyll-mermaid` plugin to list of third-party plugins ([#3222]({{ site.repository }}/issues/3222))


## 2.5.2 / 2014-11-17
{: #v2-5-2}

### Minor Enhancements
{: #minor-enhancements-v2-5-2}

- `post_url` should match `post.name` instead of slugs and dates ([#3058]({{ site.repository }}/issues/3058))

### Bug Fixes
{: #bug-fixes-v2-5-2}

- Fix bundle require for `:jekyll_plugins` ([#3119]({{ site.repository }}/issues/3119))
- Remove duplicate regexp phrase: `^\A` ([#3089]({{ site.repository }}/issues/3089))
- Remove duplicate `Conversion error:` message in `Convertible` ([#3088]({{ site.repository }}/issues/3088))
- Print full conversion error message in `Renderer#convert` ([#3090]({{ site.repository }}/issues/3090))

### Site Enhancements
{: #site-enhancements-v2-5-2}

- Change variable names in Google Analytics script ([#3093]({{ site.repository }}/issues/3093))
- Mention CSV files in the docs for data files ([#3101]({{ site.repository }}/issues/3101))
- Add trailing slash to `paginate_path` example. ([#3091]({{ site.repository }}/issues/3091))
- Get rid of noifniof (`excerpt_separator`) ([#3094]({{ site.repository }}/issues/3094))
- Sass improvements, around nesting mostly. ([#3123]({{ site.repository }}/issues/3123))
- Add webmentions.io plugin to the list of third-party plugins ([#3127]({{ site.repository }}/issues/3127))
- Add Sass mixins and use them. ([#2904]({{ site.repository }}/issues/2904))
- Slightly compress jekyll-sticker.jpg. ([#3133]({{ site.repository }}/issues/3133))
- Update gridism and separate out related but custom styles. ([#3132]({{ site.repository }}/issues/3132))
- Add remote-include plugin to list of third-party plugins ([#3136]({{ site.repository }}/issues/3136))


## 2.5.1 / 2014-11-09
{: #v2-5-1}

### Bug Fixes
{: #bug-fixes-v2-5-1}

- Fix path sanitation bug related to Windows drive names ([#3077]({{ site.repository }}/issues/3077))

### Development Fixes
{: #development-fixes-v2-5-1}

- Add development time dependencies on minitest and test-unit to gemspec for cygwin ([#3064]({{ site.repository }}/issues/3064))
- Use Travis's built-in caching. ([#3075]({{ site.repository }}/issues/3075))


## 2.5.0 / 2014-11-06
{: #v2-5-0}

### Minor Enhancements
{: #minor-enhancements-v2-5-0}

- Require gems in `:jekyll_plugins` Gemfile group unless `JEKYLL_NO_BUNDLER_REQUIRE` is specified in the environment. ([#2865]({{ site.repository }}/issues/2865))
- Centralize path sanitation in the `Site` object ([#2882]({{ site.repository }}/issues/2882))
- Allow placeholders in permalinks ([#3031]({{ site.repository }}/issues/3031))
- Allow users to specify the log level via `JEKYLL_LOG_LEVEL`. ([#3067]({{ site.repository }}/issues/3067))
- Fancy Indexing with WEBrick ([#3018]({{ site.repository }}/issues/3018))
- Allow Enumerables to be used with `where` filter. ([#2986]({{ site.repository }}/issues/2986))
- Meta descriptions in the site template now use `page.excerpt` if it's available ([#2964]({{ site.repository }}/issues/2964))
- Change indentation in `head.html` of site template to 2 spaces from 4 ([#2973]({{ site.repository }}/issues/2973))
- Use a `$content-width` variable instead of a fixed value in the site template CSS ([#2972]({{ site.repository }}/issues/2972))
- Strip newlines in site template `<meta>` description. ([#2982]({{ site.repository }}/issues/2982))
- Add link to atom feed in `head` of site template files ([#2996]({{ site.repository }}/issues/2996))
- Performance optimizations ([#2994]({{ site.repository }}/issues/2994))
- Use `Hash#each_key` instead of `Hash#keys.each` to speed up iteration over hash keys. ([#3017]({{ site.repository }}/issues/3017))
- Further minor performance enhancements. ([#3022]({{ site.repository }}/issues/3022))
- Add 'b' and 's' aliases for build and serve, respectively ([#3065]({{ site.repository }}/issues/3065))

### Bug Fixes
{: #bug-fixes-v2-5-0}

- Fix Rouge's RedCarpet plugin interface integration ([#2951]({{ site.repository }}/issues/2951))
- Remove `--watch` from the site template blog post since it defaults to watching in in 2.4.0 ([#2922]({{ site.repository }}/issues/2922))
- Fix code for media query mixin in site template ([#2946]({{ site.repository }}/issues/2946))
- Allow post URLs to have `.htm` extensions ([#2925]({{ site.repository }}/issues/2925))
- `Utils.slugify`: Don't create new objects when gsubbing ([#2997]({{ site.repository }}/issues/2997))
- The jsonify filter should deep-convert to Liquid when given an Array. ([#3032]({{ site.repository }}/issues/3032))
- Apply `jsonify` filter to Hashes deeply and effectively ([#3063]({{ site.repository }}/issues/3063))
- Use `127.0.0.1` as default host instead of `0.0.0.0` ([#3053]({{ site.repository }}/issues/3053))
- In the case that a Gemfile does not exist, ensure Jekyll doesn't fail on requiring the Gemfile group ([#3066]({{ site.repository }}/issues/3066))

### Development Fixes
{: #development-fixes-v2-5-0}

- Fix a typo in the doc block for `Jekyll::URL.escape_path` ([#3052]({{ site.repository }}/issues/3052))
- Add integration test for `jekyll new --blank` in TestUnit ([#2913]({{ site.repository }}/issues/2913))
- Add unit test for `jekyll new --force` logic ([#2929]({{ site.repository }}/issues/2929))
- Update outdated comment for `Convertible#transform` ([#2957]({{ site.repository }}/issues/2957))
- Add Hakiri badge to README. ([#2953]({{ site.repository }}/issues/2953))
- Add some simple benchmarking tools. ([#2993]({{ site.repository }}/issues/2993))

### Site Enhancements
{: #site-enhancements-v2-5-0}

- `NOKOGIRI_USE_SYSTEM_LIBRARIES=true` **decreases** installation time. ([#3040]({{ site.repository }}/issues/3040))
- Add FormKeep to resources as Jekyll form backend ([#3010]({{ site.repository }}/issues/3010))
- Fixing a mistake in the name of the new Liquid tag ([#2969]({{ site.repository }}/issues/2969))
- Update Font Awesome to v4.2.0. ([#2898]({{ site.repository }}/issues/2898))
- Fix link to [#2895]({{ site.repository }}/issues/2895) in 2.4.0 release post. ([#2899]({{ site.repository }}/issues/2899))
- Add Big Footnotes for Kramdown plugin to list of third-party plugins ([#2916]({{ site.repository }}/issues/2916))
- Remove warning regarding GHP use of singular types for front matter defaults ([#2919]({{ site.repository }}/issues/2919))
- Fix quote character typo in site documentation for templates ([#2917]({{ site.repository }}/issues/2917))
- Point Liquid links to Liquid’s GitHub wiki ([#2887]({{ site.repository }}/issues/2887))
- Add HTTP Basic Auth (.htaccess) plugin to list of third-party plugins ([#2931]({{ site.repository }}/issues/2931))
- (Minor) Grammar & `_config.yml` filename fixes ([#2911]({{ site.repository }}/issues/2911))
- Added `mathml.rb` to the list of third-party plugins. ([#2937]({{ site.repository }}/issues/2937))
- Add `--force_polling` to the list of configuration options ([#2943]({{ site.repository }}/issues/2943))
- Escape unicode characters in site CSS ([#2906]({{ site.repository }}/issues/2906))
- Add note about using the github-pages gem via pages.github.com/versions.json ([#2939]({{ site.repository }}/issues/2939))
- Update usage documentation to reflect 2.4 auto-enabling of `--watch`. ([#2954]({{ site.repository }}/issues/2954))
- Add `--skip-initial-build` to configuration docs ([#2949]({{ site.repository }}/issues/2949))
- Fix a minor typo in Templates docs page ([#2959]({{ site.repository }}/issues/2959))
- Add a ditaa-ditaa plugin under Other section on the Plugins page ([#2967]({{ site.repository }}/issues/2967))
- Add `build/serve -V` option to configuration documentation ([#2948]({{ site.repository }}/issues/2948))
- Add 'Jekyll Twitter Plugin' to list of third-party plugins ([#2979]({{ site.repository }}/issues/2979))
- Docs: Update normalize.css to v3.0.2. ([#2981]({{ site.repository }}/issues/2981))
- Fix typo in Continuous Integration documentation ([#2984]({{ site.repository }}/issues/2984))
- Clarify behavior of `:categories` in permalinks ([#3011]({{ site.repository }}/issues/3011))


## 2.4.0 / 2014-09-09
{: #v2-4-0}

### Minor Enhancements
{: #minor-enhancements-v2-4-0}

- Support a new `relative_include` tag ([#2870]({{ site.repository }}/issues/2870))
- Auto-enable watch on 'serve' ([#2858]({{ site.repository }}/issues/2858))
- Render Liquid in CoffeeScript files ([#2830]({{ site.repository }}/issues/2830))
- Array Liquid filters: `push`, `pop`, `unshift`, `shift` ([#2895]({{ site.repository }}/issues/2895))
- Add `:title` to collection URL template fillers ([#2864]({{ site.repository }}/issues/2864))
- Add support for CSV files in the `_data` directory ([#2761]({{ site.repository }}/issues/2761))
- Add the `name` variable to collection permalinks ([#2799]({{ site.repository }}/issues/2799))
- Add `inspect` liquid filter. ([#2867]({{ site.repository }}/issues/2867))
- Add a `slugify` Liquid filter ([#2880]({{ site.repository }}/issues/2880))

### Bug Fixes
{: #bug-fixes-v2-4-0}

- Use `Jekyll.sanitized_path` when adding static files to Collections ([#2849]({{ site.repository }}/issues/2849))
- Fix encoding of `main.scss` in site template ([#2771]({{ site.repository }}/issues/2771))
- Fix orientation bugs in default site template ([#2862]({{ site.repository }}/issues/2862))

### Development Fixes
{: #development-fixes-v2-4-0}

- Update simplecov gem to 0.9 ([#2748]({{ site.repository }}/issues/2748))
- Remove `docs/` dir ([#2768]({{ site.repository }}/issues/2768))
- add class `<< self` idiom to `New` command ([#2817]({{ site.repository }}/issues/2817))
- Allow Travis to 'parallelize' our tests ([#2859]({{ site.repository }}/issues/2859))
- Fix test for Liquid rendering in Sass ([#2856]({{ site.repository }}/issues/2856))
- Fixing "vertycal" typo in site template's `_base.scss` ([#2889]({{ site.repository }}/issues/2889))

### Site Enhancements
{: #site-enhancements-v2-4-0}

- Document the `name` variable for collection permalinks ([#2829]({{ site.repository }}/issues/2829))
- Adds info about installing jekyll in current dir ([#2839]({{ site.repository }}/issues/2839))
- Remove deprecated `jekyll-projectlist` plugin from list of third-party plugins ([#2742]({{ site.repository }}/issues/2742))
- Remove tag plugins that are built in to Jekyll ([#2751]({{ site.repository }}/issues/2751))
- Add `markdown-writer` package for Atom Editor to list of third-party plugins ([#2763]({{ site.repository }}/issues/2763))
- Fix typo in site documentation for collections ([#2764]({{ site.repository }}/issues/2764))
- Fix minor typo on plugins docs page ([#2765]({{ site.repository }}/issues/2765))
- Replace markdown with HTML in `sass_dir` note on assets page ([#2791]({{ site.repository }}/issues/2791))
- Fixed "bellow" typo in datafiles docs ([#2879]({{ site.repository }}/issues/2879))
- Fix code/markdown issue in documentation for variables ([#2877]({{ site.repository }}/issues/2877))
- Remove Good Include third-party plugin from plugins page ([#2881]({{ site.repository }}/issues/2881))
- Add some more docs on `include_relative` ([#2884]({{ site.repository }}/issues/2884))


## 2.3.0 / 2014-08-10
{: #v2-3-0}

### Minor Enhancements
{: #minor-enhancements-v2-3-0}

- Allow Convertibles to be converted by >= 1 converters ([#2704]({{ site.repository }}/issues/2704))
- Allow Sass files to be rendered in Liquid, but never place them in layouts. ([#2733]({{ site.repository }}/issues/2733))
- Add `jekyll help` command ([#2707]({{ site.repository }}/issues/2707))
- Use `.scss` for `site_template` styles. ([#2667]({{ site.repository }}/issues/2667))
- Don't require the `scope` key in front matter defaults ([#2659]({{ site.repository }}/issues/2659))
- No longer set `permalink: pretty` in the `_config.yml` for the site template ([#2680]({{ site.repository }}/issues/2680))
- Rework site template to utilize Sass ([#2687]({{ site.repository }}/issues/2687))
- Notify the user when auto-regeneration is disabled. ([#2696]({{ site.repository }}/issues/2696))
- Allow partial variables in include tag filename argument ([#2693]({{ site.repository }}/issues/2693))
- Move instances of `Time.parse` into a Utils method ([#2682]({{ site.repository }}/issues/2682))
- Ignore subfolders in the `_posts` folder ([#2705]({{ site.repository }}/issues/2705)) REVERTS ([#2633]({{ site.repository }}/issues/2633))
- Front Matter default types should always be pluralized ([#2732]({{ site.repository }}/issues/2732))
- Read in static files into `collection.files` as `StaticFile`s ([#2737]({{ site.repository }}/issues/2737))
- Add `sassify` and `scssify` Liquid filters ([#2739]({{ site.repository }}/issues/2739))
- Replace `classifier` gem with `classifier-reborn` ([#2721]({{ site.repository }}/issues/2721))

### Bug Fixes
{: #bug-fixes-v2-3-0}

- Use only the last extname when multiple converters exist ([#2722]({{ site.repository }}/issues/2722))
- Call `#to_liquid` before calling `#to_json` in jsonify filter ([#2729]({{ site.repository }}/issues/2729))
- Use non padded config in `strftime` to avoid parse string twice ([#2673]({{ site.repository }}/issues/2673))
- Replace deprecated Ruby methods with undeprecated ones ([#2664]({{ site.repository }}/issues/2664))
- Catch errors when parsing Post `date` front matter value & produce nice error message ([#2649]({{ site.repository }}/issues/2649))
- Allow static files in Collections ([#2615]({{ site.repository }}/issues/2615))
- Fixed typo in `Deprecator#gracefully_require` error message ([#2694]({{ site.repository }}/issues/2694))
- Remove preemptive loading of the 'classifier' gem. ([#2697]({{ site.repository }}/issues/2697))
- Use case-insensitive checking for the file extensions when loading config files ([#2718]({{ site.repository }}/issues/2718))
- When Reading Documents, Respect `encoding` Option ([#2720]({{ site.repository }}/issues/2720))
- Refactor based on jekyll-watch clean-up. ([#2716]({{ site.repository }}/issues/2716))
- `Document#to_s` should produce just the content of the document ([#2731]({{ site.repository }}/issues/2731))

### Development Fixes
{: #development-fixes-v2-3-0}

- Only include lib files in the gem ([#2671]({{ site.repository }}/issues/2671))
- Fix `git diff` command in `proof` script ([#2672]({{ site.repository }}/issues/2672))
- Make default rake task a multitask so tests run in parallel ([#2735]({{ site.repository }}/issues/2735))

### Site Enhancements
{: #site-enhancements-v2-3-0}

- Use Sass and a Docs Collection ([#2651]({{ site.repository }}/issues/2651))
- Add `latest_version.txt` file to the site ([#2740]({{ site.repository }}/issues/2740))
- Be more ambiguous about `page.content`. But more transparent. ([#2522]({{ site.repository }}/issues/2522))
- Streamlining front matter wording (instead of front-matter/frontmatter) ([#2674]({{ site.repository }}/issues/2674))
- Add note that source directory cannot be modified in GitHub Pages ([#2669]({{ site.repository }}/issues/2669))
- Fix links from [#2669]({{ site.repository }}/issues/2669) to be actual HTML. Whoops. ([#2679]({{ site.repository }}/issues/2679))
- Add link to `jekyll-slim` in list of third-party plugins ([#2689]({{ site.repository }}/issues/2689))
- Add Barry Clark's Smashing Magazine tutorial to resources page ([#2688]({{ site.repository }}/issues/2688))
- Reorganize and update default configuration settings ([#2456]({{ site.repository }}/issues/2456))
- Fixing indentation in the configuration docs about Redcarpet exts ([#2717]({{ site.repository }}/issues/2717))
- Use `null` in YAML instead of `nil` in default config list ([#2719]({{ site.repository }}/issues/2719))
- Fix typo in Continuous Integration docs ([#2708]({{ site.repository }}/issues/2708))


## 2.2.0 / 2014-07-29
{: #v2-2-0}

### Minor Enhancements
{: #minor-enhancements-v2-2-0}

- Throw a warning if the specified layout does not exist ([#2620]({{ site.repository }}/issues/2620))
- Whitelist Pygments options in safe mode ([#2642]({{ site.repository }}/issues/2642))

### Bug Fixes
{: #bug-fixes-v2-2-0}

- Remove unnecessary `Jekyll::Tags::IncludeTag#blank?` method ([#2625]({{ site.repository }}/issues/2625))
- Categories in the path are ignored ([#2633]({{ site.repository }}/issues/2633))

### Development Fixes
{: #development-fixes-v2-2-0}

- Refactoring Errors & Requires of Third-Party stuff ([#2591]({{ site.repository }}/issues/2591))
- Add further tests for categories ([#2584]({{ site.repository }}/issues/2584))
- Proof site with html-proofer on change ([#2605]({{ site.repository }}/issues/2605))
- Fix up bug in [#2605]({{ site.repository }}/issues/2605) which caused proofing the site not to function ([#2608]({{ site.repository }}/issues/2608))
- Use `bundle exec` in `script/proof` ([#2610]({{ site.repository }}/issues/2610))

### Site Enhancements
{: #site-enhancements-v2-2-0}

- Update Kramdown urls ([#2588]({{ site.repository }}/issues/2588))
- Add `Jekyll::AutolinkEmail` and `Jekyll::GitMetadata` to the list of third-party plugins ([#2596]({{ site.repository }}/issues/2596))
- Fix a bunch of broken links in the site ([#2601]({{ site.repository }}/issues/2601))
- Replace dead links with working links ([#2611]({{ site.repository }}/issues/2611))
- Add jekyll-hook to deployment methods ([#2617]({{ site.repository }}/issues/2617))
- Added kramdown-with-pygments plugin to the list of third-party plugins ([#2623]({{ site.repository }}/issues/2623))
- Update outdated "Extras" page and remove duplicate documentation ([#2622]({{ site.repository }}/issues/2622))
- Add co2 plugin to list of third-party plugins ([#2639]({{ site.repository }}/issues/2639))
- Attempt to clarify the way Sass imports happen ([#2642]({{ site.repository }}/issues/2642))


## 2.1.1 / 2014-07-01
{: #v2-1-1}

### Bug Fixes
{: #bug-fixes-v2-1-1}

- Patch read vulnerabilities for data & confirm none for layouts ([#2563]({{ site.repository }}/issues/2563))
- Update Maruku dependency to allow use of the latest version ([#2576]({{ site.repository }}/issues/2576))
- Remove conditional assignment from document URL to prevent stale urls ([#2575]({{ site.repository }}/issues/2575))

### Site Enhancements
{: #site-enhancements-v2-1-1}

- Add vertical margin to `highlight` to separate code blocks ([#2558]({{ site.repository }}/issues/2558))
- Add `html_pages` to Variables docs ([#2567]({{ site.repository }}/issues/2567))
- Fixed broken link to Permalinks page ([#2572]({{ site.repository }}/issues/2572))
- Update link to Windows installation guide ([#2578]({{ site.repository }}/issues/2578))


## 2.1.0 / 2014-06-28
{: #v2-1-0}

### Minor Enhancements
{: #minor-enhancements-v2-1-0}

- Bump to the latest Liquid version, 2.6.1 ([#2495]({{ site.repository }}/issues/2495))
- Add support for JSON files in the `_data` directory ([#2369]({{ site.repository }}/issues/2369))
- Allow subclasses to override `EXCERPT_ATTRIBUTES_FOR_LIQUID` ([#2408]({{ site.repository }}/issues/2408))
- Add `Jekyll.env` and `jekyll.environment` (the Liquid var) ([#2417]({{ site.repository }}/issues/2417))
- Use `_config.yaml` or `_config.yml` (`.yml` takes precedence) ([#2406]({{ site.repository }}/issues/2406))
- Override collection url template ([#2418]({{ site.repository }}/issues/2418))
- Allow subdirectories in `_data` ([#2395]({{ site.repository }}/issues/2395))
- Extract Pagination Generator into gem: `jekyll-paginate` ([#2455]({{ site.repository }}/issues/2455))
- Utilize `date_to_rfc822` filter in site template ([#2437]({{ site.repository }}/issues/2437))
- Add categories, last build datetime, and generator to site template feed ([#2438]({{ site.repository }}/issues/2438))
- Configurable, replaceable Logger-compliant logger ([#2444]({{ site.repository }}/issues/2444))
- Extract `gist` tag into a separate gem ([#2469]({{ site.repository }}/issues/2469))
- Add `collection` attribute to `Document#to_liquid` to access the document's collection label. ([#2436]({{ site.repository }}/issues/2436))
- Upgrade listen to `2.7.6 <= x < 3.0.0` ([#2492]({{ site.repository }}/issues/2492))
- Allow configuration of different Twitter and GitHub usernames in site template ([#2485]({{ site.repository }}/issues/2485))
- Bump Pygments to v0.6.0 ([#2504]({{ site.repository }}/issues/2504))
- Front matter defaults for documents in collections ([#2419]({{ site.repository }}/issues/2419))
- Include files with a url which ends in `/` in the `site.html_pages` list ([#2524]({{ site.repository }}/issues/2524))
- Make `highlight` tag use `language-` prefix in CSS class ([#2511]({{ site.repository }}/issues/2511))
- Lookup item property via `item#to_liquid` before `#data` or `#[]` in filters ([#2493]({{ site.repository }}/issues/2493))
- Skip initial build of site on serve with flag ([#2477]({{ site.repository }}/issues/2477))
- Add support for `hl_lines` in `highlight` tag ([#2532]({{ site.repository }}/issues/2532))
- Spike out `--watch` flag into a separate gem ([#2550]({{ site.repository }}/issues/2550))

### Bug Fixes
{: #bug-fixes-v2-1-0}

- Liquid `sort` filter should sort even if one of the values is `nil` ([#2345]({{ site.repository }}/issues/2345))
- Remove padding on `pre code` in the site template CSS ([#2383]({{ site.repository }}/issues/2383))
- Set `log_level` earlier to silence info level configuration output ([#2393]({{ site.repository }}/issues/2393))
- Only list pages which have `title` in site template ([#2411]({{ site.repository }}/issues/2411))
- Accept `Numeric` values for dates, not `Number` values ([#2377]({{ site.repository }}/issues/2377))
- Prevent code from overflowing container in site template ([#2429]({{ site.repository }}/issues/2429))
- Encode URLs in UTF-8 when escaping and unescaping ([#2420]({{ site.repository }}/issues/2420))
- No Layouts or Liquid for Asset Files ([#2431]({{ site.repository }}/issues/2431))
- Allow front matter defaults to set post categories ([#2373]({{ site.repository }}/issues/2373))
- Fix command in subcommand deprecation warning ([#2457]({{ site.repository }}/issues/2457))
- Keep all parent directories of files/dirs in `keep_files` ([#2458]({{ site.repository }}/issues/2458))
- When using RedCarpet and Rouge without Rouge installed, fixed erroneous error which stated that redcarpet was missing, not rouge. ([#2464]({{ site.repository }}/issues/2464))
- Ignore *all* directories and files that merit it on auto-generation ([#2459]({{ site.repository }}/issues/2459))
- Before copying file, explicitly remove the old one ([#2535]({{ site.repository }}/issues/2535))
- Merge file system categories with categories from YAML. ([#2531]({{ site.repository }}/issues/2531))
- Deep merge front matter defaults ([#2490]({{ site.repository }}/issues/2490))
- Ensure exclude and include arrays are arrays of strings ([#2542]({{ site.repository }}/issues/2542))
- Allow collections to have dots in their filenames ([#2552]({{ site.repository }}/issues/2552))
- Collections shouldn't try to read in directories as files ([#2552]({{ site.repository }}/issues/2552))
- Be quiet very quickly. ([#2520]({{ site.repository }}/issues/2520))

### Development Fixes
{: #development-fixes-v2-1-0}

- Test Ruby 2.1.2 instead of 2.1.1 ([#2374]({{ site.repository }}/issues/2374))
- Add test for sorting UTF-8 characters ([#2384]({{ site.repository }}/issues/2384))
- Use `https` for GitHub links in documentation ([#2470]({{ site.repository }}/issues/2470))
- Remove coverage reporting with Coveralls ([#2494]({{ site.repository }}/issues/2494))
- Fix a bit of missing TomDoc to `Jekyll::Commands::Build#build` ([#2554]({{ site.repository }}/issues/2554))

### Site Enhancements
{: #site-enhancements-v2-1-0}

- Set `timezone` to `America/Los_Angeles` ([#2394]({{ site.repository }}/issues/2394))
- Improve JavaScript in `anchor_links.html` ([#2368]({{ site.repository }}/issues/2368))
- Remove note on Quickstart page about default markdown converter ([#2387]({{ site.repository }}/issues/2387))
- Remove broken link in extras.md to a Maruku fork ([#2401]({{ site.repository }}/issues/2401))
- Update Font Awesome to v4.1.0. ([#2410]({{ site.repository }}/issues/2410))
- Fix broken link on Installation page to Templates page ([#2421]({{ site.repository }}/issues/2421))
- Prevent table from extending parent width in permalink style table ([#2424]({{ site.repository }}/issues/2424))
- Add collections to info about pagination support ([#2389]({{ site.repository }}/issues/2389))
- Add `jekyll_github_sample` plugin to list of third-party plugins ([#2463]({{ site.repository }}/issues/2463))
- Clarify documentation around front matter defaults and add details about defaults for collections. ([#2439]({{ site.repository }}/issues/2439))
- Add Jekyll Project Version Tag to list of third-party plugins ([#2468]({{ site.repository }}/issues/2468))
- Use `https` for GitHub links across whole site ([#2470]({{ site.repository }}/issues/2470))
- Add StickerMule + Jekyll post ([#2476]({{ site.repository }}/issues/2476))
- Add Jekyll Asset Pipeline Reborn to list of third-party plugins ([#2479]({{ site.repository }}/issues/2479))
- Add link to jekyll-compress-html to list of third-party plugins ([#2514]({{ site.repository }}/issues/2514))
- Add Piwigo Gallery to list of third-party plugins ([#2526]({{ site.repository }}/issues/2526))
- Set `show_drafts` to `false` in default configuration listing ([#2536]({{ site.repository }}/issues/2536))
- Provide an updated link for Windows installation instructions ([#2544]({{ site.repository }}/issues/2544))
- Remove `url` from configuration docs ([#2547]({{ site.repository }}/issues/2547))
- Documentation for Continuous Integration for your Jekyll Site ([#2432]({{ site.repository }}/issues/2432))


## 2.0.3 / 2014-05-08
{: #v2-0-3}

### Bug Fixes
{: #bug-fixes-v2-0-3}

- Properly prefix links in site template with URL or baseurl depending upon need. ([#2319]({{ site.repository }}/issues/2319))
- Update gist tag comments and error message to require username ([#2326]({{ site.repository }}/issues/2326))
- Fix `permalink` setting in site template ([#2331]({{ site.repository }}/issues/2331))
- Don't fail if any of the path objects are nil ([#2325]({{ site.repository }}/issues/2325))
- Instantiate all descendants for converters and generators, not just direct subclasses ([#2334]({{ site.repository }}/issues/2334))
- Replace all instances of `site.name` with `site.title` in site template ([#2324]({{ site.repository }}/issues/2324))
- `Jekyll::Filters#time` now accepts UNIX timestamps in string or number form ([#2339]({{ site.repository }}/issues/2339))
- Use `item_property` for `where` filter so it doesn't break on collections ([#2359]({{ site.repository }}/issues/2359))
- Rescue errors thrown so `--watch` doesn't fail ([#2364]({{ site.repository }}/issues/2364))

### Site Enhancements
{: #site-enhancements-v2-0-3}

- Add missing "as" to assets docs page ([#2337]({{ site.repository }}/issues/2337))
- Update docs to reflect new `baseurl` default ([#2341]({{ site.repository }}/issues/2341))
- Add links to headers who have an ID. ([#2342]({{ site.repository }}/issues/2342))
- Use symbol instead of HTML number in `upgrading.md` ([#2351]({{ site.repository }}/issues/2351))
- Fix link to front matter defaults docs ([#2353]({{ site.repository }}/issues/2353))
- Fix for `History.markdown` in order to fix history page in docs ([#2363]({{ site.repository }}/issues/2363))


## 2.0.2 / 2014-05-07
{: #v2-0-2}

### Bug Fixes
{: #bug-fixes-v2-0-2}

- Correct use of `url` and `baseurl` in the site template. ([#2317]({{ site.repository }}/issues/2317))
- Default `baseurl` to `""` ([#2317]({{ site.repository }}/issues/2317))

### Site Enhancements
{: #site-enhancements-v2-0-2}

- Correct docs for the `gist` plugin so it always includes the username. ([#2314]({{ site.repository }}/issues/2314))
- Clarify new (defaults, `where` filter) features in docs ([#2316]({{ site.repository }}/issues/2316))


## 2.0.1 / 2014-05-06
{: #v2-0-1}

### Bug Fixes
{: #bug-fixes-v2-0-1}

- Require `kramdown` gem instead of `maruku` gem


## 2.0.0 / 2014-05-06
{: #v2-0-0}

### Major Enhancements
{: #major-enhancements-v2-0-0}

- Add "Collections" feature ([#2199]({{ site.repository }}/issues/2199))
- Add gem-based plugin whitelist to safe mode ([#1657]({{ site.repository }}/issues/1657))
- Replace the commander command line parser with a more robust solution for our needs called `mercenary` ([#1706]({{ site.repository }}/issues/1706))
- Remove support for Ruby 1.8.x ([#1780]({{ site.repository }}/issues/1780))
- Move to jekyll/jekyll from mojombo/jekyll ([#1817]({{ site.repository }}/issues/1817))
- Allow custom markdown processors ([#1872]({{ site.repository }}/issues/1872))
- Provide support for the Rouge syntax highlighter ([#1859]({{ site.repository }}/issues/1859))
- Provide support for Sass ([#1932]({{ site.repository }}/issues/1932))
- Provide a 300% improvement when generating sites that use `Post#next` or `Post#previous` ([#1983]({{ site.repository }}/issues/1983))
- Provide support for CoffeeScript ([#1991]({{ site.repository }}/issues/1991))
- Replace Maruku with Kramdown as Default Markdown Processor ([#1988]({{ site.repository }}/issues/1988))
- Expose `site.static_files` to Liquid ([#2075]({{ site.repository }}/issues/2075))
- Complete redesign of the template site generated by `jekyll new` ([#2050]({{ site.repository }}/issues/2050))
- Update Listen from 1.x to 2.x ([#2097]({{ site.repository }}/issues/2097))
- Front matter defaults ([#2205]({{ site.repository }}/issues/2205))
- Deprecate `relative_permalinks` configuration option (default to `false`) ([#2307]({{ site.repository }}/issues/2307))
- Exclude files based on prefix as well as `fnmatch?` ([#2303]({{ site.repository }}/issues/2303))

### Minor Enhancements
{: #minor-enhancements-v2-0-0}

- Move the EntryFilter class into the Jekyll module to avoid polluting the global namespace ([#1800]({{ site.repository }}/issues/1800))
- Add `group_by` Liquid filter create lists of items grouped by a common property's value ([#1788]({{ site.repository }}/issues/1788))
- Add support for Maruku's `fenced_code_blocks` option ([#1799]({{ site.repository }}/issues/1799))
- Update Redcarpet dependency to ~> 3.0 ([#1815]({{ site.repository }}/issues/1815))
- Automatically sort all pages by name ([#1848]({{ site.repository }}/issues/1848))
- Better error message when time is not parseable ([#1847]({{ site.repository }}/issues/1847))
- Allow `include` tag variable arguments to use filters ([#1841]({{ site.repository }}/issues/1841))
- `post_url` tag should raise `ArgumentError` for invalid name ([#1825]({{ site.repository }}/issues/1825))
- Bump dependency `mercenary` to `~> 0.2.0` ([#1879]({{ site.repository }}/issues/1879))
- Bump dependency `safe_yaml` to `~> 1.0` ([#1886]({{ site.repository }}/issues/1886))
- Allow sorting of content by custom properties ([#1849]({{ site.repository }}/issues/1849))
- Add `--quiet` flag to silence output during build and serve ([#1898]({{ site.repository }}/issues/1898))
- Add a `where` filter to filter arrays based on a key/value pair ([#1875]({{ site.repository }}/issues/1875))
- Route 404 errors to a custom 404 page in development ([#1899]({{ site.repository }}/issues/1899))
- Excludes are now relative to the site source ([#1916]({{ site.repository }}/issues/1916))
- Bring MIME Types file for `jekyll serve` to complete parity with GH Pages servers ([#1993]({{ site.repository }}/issues/1993))
- Adding Breakpoint to make new site template more responsive ([#2038]({{ site.repository }}/issues/2038))
- Default to using the UTF-8 encoding when reading files. ([#2031]({{ site.repository }}/issues/2031))
- Update Redcarpet dependency to ~> 3.1 ([#2044]({{ site.repository }}/issues/2044))
- Remove support for Ruby 1.9.2 ([#2045]({{ site.repository }}/issues/2045))
- Add `.mkdown` as valid Markdown extension ([#2048]({{ site.repository }}/issues/2048))
- Add `index.xml` to the list of WEBrick directory index files ([#2041]({{ site.repository }}/issues/2041))
- Make the `layouts` config key relative to CWD or to source ([#2058]({{ site.repository }}/issues/2058))
- Update Kramdown to `~> 1.3` ([#1894]({{ site.repository }}/issues/1894))
- Remove unnecessary references to `self` ([#2090]({{ site.repository }}/issues/2090))
- Update to Mercenary v0.3.x ([#2085]({{ site.repository }}/issues/2085))
- Ship Sass support as a separate gem ([#2098]({{ site.repository }}/issues/2098))
- Extract core extensions into a Utils module ([#2112]({{ site.repository }}/issues/2112))
- Refactor CLI & Commands For Greater Happiness ([#2143]({{ site.repository }}/issues/2143))
- Provide useful error when Pygments returns `nil` and error out ([#2148]({{ site.repository }}/issues/2148))
- Add support for unpublished drafts ([#2164]({{ site.repository }}/issues/2164))
- Add `force_polling` option to the `serve` command ([#2165]({{ site.repository }}/issues/2165))
- Clean up the `<head>` in the site template ([#2186]({{ site.repository }}/issues/2186))
- Permit YAML blocks to end with three dots to better conform with the YAML spec ([#2110]({{ site.repository }}/issues/2110))
- Use `File.exist?` instead of deprecated `File.exists?` ([#2214]({{ site.repository }}/issues/2214))
- Require newline after start of front matter header ([#2211]({{ site.repository }}/issues/2211))
- Add the ability for pages to be marked as `published: false` ([#1492]({{ site.repository }}/issues/1492))
- Add `Jekyll::LiquidExtensions` with `.lookup_variable` method for easy looking up of variable values in a Liquid context. ([#2253]({{ site.repository }}/issues/2253))
- Remove literal lang name from class ([#2292]({{ site.repository }}/issues/2292))
- Return `utf-8` encoding in header for webrick error page response ([#2289]({{ site.repository }}/issues/2289))
- Make template site easier to customize ([#2268]({{ site.repository }}/issues/2268))
- Add two-digit year to permalink template option ([#2301]({{ site.repository }}/issues/2301))
- Add `site.documents` to Liquid payload (list of all docs) ([#2295]({{ site.repository }}/issues/2295))
- Take into account missing values in the Liquid sort filter ([#2299]({{ site.repository }}/issues/2299))

### Bug Fixes
{: #bug-fixes-v2-0-0}

- Don't allow nil entries when loading posts ([#1796]({{ site.repository }}/issues/1796))
- Remove the scrollbar that's always displayed in new sites generated from the site template ([#1805]({{ site.repository }}/issues/1805))
- Add `#path` to required methods in `Jekyll::Convertible` ([#1866]({{ site.repository }}/issues/1866))
- Default Maruku fenced code blocks to ON for 2.0.0-dev ([#1831]({{ site.repository }}/issues/1831))
- Change short opts for host and port for `jekyll docs` to be consistent with other subcommands ([#1877]({{ site.repository }}/issues/1877))
- Fix typos ([#1910]({{ site.repository }}/issues/1910))
- Lock Maruku at 0.7.0 to prevent bugs caused by Maruku 0.7.1 ([#1958]({{ site.repository }}/issues/1958))
- Fixes full path leak to source directory when using include tag ([#1951]({{ site.repository }}/issues/1951))
- Don't generate pages that aren't being published ([#1931]({{ site.repository }}/issues/1931))
- Use `SafeYAML.load` to avoid conflicts with other projects ([#1982]({{ site.repository }}/issues/1982))
- Relative posts should never fail to build ([#1976]({{ site.repository }}/issues/1976))
- Remove executable bits of non executable files ([#2056]({{ site.repository }}/issues/2056))
- `#path` for a draft is now `_drafts` instead of `_posts` ([#2042]({{ site.repository }}/issues/2042))
- Patch a couple show-stopping security vulnerabilities ([#1946]({{ site.repository }}/issues/1946))
- Sanitize paths uniformly, in a Windows-friendly way ([#2065]({{ site.repository }}/issues/2065), [#2109]({{ site.repository }}/issues/2109))
- Update gem build steps to work correctly on Windows ([#2118]({{ site.repository }}/issues/2118))
- Remove obsolete `normalize_options` method call from `bin/jekyll` ([#2121]({{ site.repository }}/issues/2121))
- Remove `+` characters from Pygments lexer names when adding as a CSS class ([#994]({{ site.repository }}/issues/994))
- Remove some code that caused Ruby interpreter warnings ([#2178]({{ site.repository }}/issues/2178))
- Only strip the drive name if it begins the string ([#2175]({{ site.repository }}/issues/2175))
- Remove default post with invalid date from site template ([#2200]({{ site.repository }}/issues/2200))
- Fix `Post#url` and `Page#url` escape ([#1568]({{ site.repository }}/issues/1568))
- Strip newlines from the {% raw %}`{% highlight %}`{% endraw %} block content ([#1823]({{ site.repository }}/issues/1823))
- Load in `rouge` only when it's been requested as the highlighter ([#2189]({{ site.repository }}/issues/2189))
- Convert input to string before XML escaping (`xml_escape` liquid filter) ([#2244]({{ site.repository }}/issues/2244))
- Modify configuration key for Collections and reset properly. ([#2238]({{ site.repository }}/issues/2238))
- Avoid duplicated output using `highlight` tag ([#2264]({{ site.repository }}/issues/2264))
- Only use Jekyll.logger for output ([#2307]({{ site.repository }}/issues/2307))
- Close the file descriptor in `has_yaml_header?` ([#2310]({{ site.repository }}/issues/2310))
- Add `output` to `Document` liquid output hash ([#2309]({{ site.repository }}/issues/2309))

### Development Fixes
{: #development-fixes-v2-0-0}

- Add a link to the site in the README.md file ([#1795]({{ site.repository }}/issues/1795))
- Add in History and site changes from `v1-stable` branch ([#1836]({{ site.repository }}/issues/1836))
- Testing additions on the Excerpt class ([#1893]({{ site.repository }}/issues/1893))
- Fix the `highlight` tag feature ([#1859]({{ site.repository }}/issues/1859))
- Test Jekyll under Ruby 2.1.0 ([#1900]({{ site.repository }}/issues/1900))
- Add script/cibuild for fun and profit ([#1912]({{ site.repository }}/issues/1912))
- Use `Forwardable` for delegation between `Excerpt` and `Post` ([#1927]({{ site.repository }}/issues/1927))
- Rename `read_things` to `read_content` ([#1928]({{ site.repository }}/issues/1928))
- Add `script/branding` script for ASCII art lovin' ([#1936]({{ site.repository }}/issues/1936))
- Update the README to reflect the repo move ([#1943]({{ site.repository }}/issues/1943))
- Add the project vision to the README ([#1935]({{ site.repository }}/issues/1935))
- Speed up Travis CI builds by using Rebund ([#1985]({{ site.repository }}/issues/1985))
- Use Yarp as a Gem proxy for Travis CI ([#1984]({{ site.repository }}/issues/1984))
- Remove Yarp as a Gem proxy for Travis CI ([#2004]({{ site.repository }}/issues/2004))
- Move the reading of layouts into its own class ([#2020]({{ site.repository }}/issues/2020))
- Test Sass import ([#2009]({{ site.repository }}/issues/2009))
- Switch Maruku and Kramdown in lists of Runtime vs. Development dependencies ([#2049]({{ site.repository }}/issues/2049))
- Clean up the gemspec for the project ([#2095]({{ site.repository }}/issues/2095))
- Add Japanese translation of README and CONTRIBUTING docs. ([#2081]({{ site.repository }}/issues/2081))
- Re-align the tables in Cucumber ([#2108]({{ site.repository }}/issues/2108))
- Trim trailing spaces and convert tabs to spaces ([#2122]({{ site.repository }}/issues/2122))
- Fix the failing Travis scenarios due to Cucumber issues ([#2155]({{ site.repository }}/issues/2155))
- Wrap `bundle install` in `travis_retry` to retry when RubyGems fails ([#2160]({{ site.repository }}/issues/2160))
- Refactor tags and categories ([#1639]({{ site.repository }}/issues/1639))
- Extract plugin management into its own class ([#2197]({{ site.repository }}/issues/2197))
- Add missing tests for `Command` ([#2216]({{ site.repository }}/issues/2216))
- Update `rr` link in CONTRIBUTING doc ([#2247]({{ site.repository }}/issues/2247))
- Streamline Cucumber execution of `jekyll` subcommands ([#2258]({{ site.repository }}/issues/2258))
- Refactor `Commands::Serve`. ([#2269]({{ site.repository }}/issues/2269))
- Refactor `highlight` tag ([#2154]({{ site.repository }}/issues/2154))
- Update `Util` hash functions with latest from Rails ([#2273]({{ site.repository }}/issues/2273))
- Workaround for Travis bug ([#2290]({{ site.repository }}/issues/2290))

### Site Enhancements
{: #site-enhancements-v2-0-0}

- Document Kramdown's GFM parser option ([#1791]({{ site.repository }}/issues/1791))
- Move CSS to includes & update normalize.css to v2.1.3 ([#1787]({{ site.repository }}/issues/1787))
- Minify CSS only in production ([#1803]({{ site.repository }}/issues/1803))
- Fix broken link to installation of Ruby on Mountain Lion blog post on Troubleshooting docs page ([#1797]({{ site.repository }}/issues/1797))
- Fix issues with 1.4.1 release blog post ([#1804]({{ site.repository }}/issues/1804))
- Add note about deploying to OpenShift ([#1812]({{ site.repository }}/issues/1812))
- Collect all Windows-related docs onto one page ([#1818]({{ site.repository }}/issues/1818))
- Fixed typo in datafiles doc page ([#1854]({{ site.repository }}/issues/1854))
- Clarify how to access `site` in docs ([#1864]({{ site.repository }}/issues/1864))
- Add closing `<code>` tag to `context.registers[:site]` note ([#1867]({{ site.repository }}/issues/1867))
- Fix link to @mojombo's site source ([#1897]({{ site.repository }}/issues/1897))
- Add `paginate: nil` to default configuration in docs ([#1896]({{ site.repository }}/issues/1896))
- Add link to our License in the site footer ([#1889]({{ site.repository }}/issues/1889))
- Add a charset note in "Writing Posts" doc page ([#1902]({{ site.repository }}/issues/1902))
- Disallow selection of path and prompt in bash examples
- Add jekyll-compass to the plugin list ([#1923]({{ site.repository }}/issues/1923))
- Add note in Posts docs about stripping `<p>` tags from excerpt ([#1933]({{ site.repository }}/issues/1933))
- Add additional info about the new exclude behavior ([#1938]({{ site.repository }}/issues/1938))
- Linkify 'awesome contributors' to point to the contributors graph on GitHub ([#1940]({{ site.repository }}/issues/1940))
- Update `docs/sites.md` link to GitHub Training materials ([#1949]({{ site.repository }}/issues/1949))
- Update `master` with the release info from 1.4.3 ([#1947]({{ site.repository }}/issues/1947))
- Define docs nav in datafile ([#1953]({{ site.repository }}/issues/1953))
- Clarify the docs around the naming convention for posts ([#1971]({{ site.repository }}/issues/1971))
- Add missing `next` and `previous` docs for post layouts and templates ([#1970]({{ site.repository }}/issues/1970))
- Add note to `Writing posts` page about how to strip html from excerpt ([#1962]({{ site.repository }}/issues/1962))
- Add `jekyll-humanize` plugin to plugin list ([#1998]({{ site.repository }}/issues/1998))
- Add `jekyll-font-awesome` plugin to plugin list ([#1999]({{ site.repository }}/issues/1999))
- Add `sublime-jekyll` to list of Editor plugins ([#2001]({{ site.repository }}/issues/2001))
- Add `vim-jekyll` to the list of Editor plugins ([#2005]({{ site.repository }}/issues/2005))
- Fix non-semantic nesting of `p` tags in `news_item` layout ([#2013]({{ site.repository }}/issues/2013))
- Document destination folder cleaning ([#2016]({{ site.repository }}/issues/2016))
- Updated instructions for NearlyFreeSpeech.NET installation ([#2015]({{ site.repository }}/issues/2015))
- Update link to rack-jekyll on "Deployment Methods" page ([#2047]({{ site.repository }}/issues/2047))
- Fix typo in /docs/configuration ([#2073]({{ site.repository }}/issues/2073))
- Fix count in docs for `site.static_files` ([#2077]({{ site.repository }}/issues/2077))
- Update configuration docs to indicate utf-8 is the default for 2.0.0 and ASCII for 1.9.3 ([#2074]({{ site.repository }}/issues/2074))
- Add info about unreleased feature to the site ([#2061]({{ site.repository }}/issues/2061))
- Add whitespace to liquid example in GitHub Pages docs ([#2084]({{ site.repository }}/issues/2084))
- Clarify the way Sass and CoffeeScript files are read in and output ([#2067]({{ site.repository }}/issues/2067))
- Add lyche gallery tag plugin link to list of plugins ([#2094]({{ site.repository }}/issues/2094))
- Add Jekyll Pages Directory plugin to list of plugins ([#2096]({{ site.repository }}/issues/2096))
- Update Configuration docs page with new markdown extension ([#2102]({{ site.repository }}/issues/2102))
- Add `jekyll-image-set` to the list of third-party plugins ([#2105]({{ site.repository }}/issues/2105))
- Losslessly compress images ([#2128]({{ site.repository }}/issues/2128))
- Update normalize.css to 3.0.0 ([#2126]({{ site.repository }}/issues/2126))
- Update modernizr to v2.7.1 ([#2129]({{ site.repository }}/issues/2129))
- Add `jekyll-ordinal` to list of third-party plugins ([#2150]({{ site.repository }}/issues/2150))
- Add `jekyll_figure` to list of third-party plugins ([#2158]({{ site.repository }}/issues/2158))
- Clarify the documentation for safe mode ([#2163]({{ site.repository }}/issues/2163))
- Some HTML tidying ([#2130]({{ site.repository }}/issues/2130))
- Remove modernizr and use html5shiv.js directly for IE less than v9 ([#2131]({{ site.repository }}/issues/2131))
- Remove unused images ([#2187]({{ site.repository }}/issues/2187))
- Use `array_to_sentence_string` filter when outputting news item categories ([#2191]({{ site.repository }}/issues/2191))
- Add link to Help repo in primary navigation bar ([#2177]({{ site.repository }}/issues/2177))
- Switch to using an ico file for the shortcut icon ([#2193]({{ site.repository }}/issues/2193))
- Use numbers to specify font weights and only bring in font weights used ([#2185]({{ site.repository }}/issues/2185))
- Add a link to the list of all tz database time zones ([#1824]({{ site.repository }}/issues/1824))
- Clean-up and improve documentation `feed.xml` ([#2192]({{ site.repository }}/issues/2192))
- Remove duplicate entry in list of third-party plugins ([#2206]({{ site.repository }}/issues/2206))
- Reduce the whitespace in the favicon. ([#2213]({{ site.repository }}/issues/2213))
- Add `jekyll-page-collections` to list of third-party plugins ([#2215]({{ site.repository }}/issues/2215))
- Add a cross-reference about `post_url` ([#2243]({{ site.repository }}/issues/2243))
- Add `jekyll-live-tiles` to list of third-party plugins ([#2250]({{ site.repository }}/issues/2250))
- Fixed broken link to GitHub training material site source ([#2257]({{ site.repository }}/issues/2257))
- Update link to help repo, now called `jekyll-help` ([#2277]({{ site.repository }}/issues/2277))
- Fix capitalization of 'Jekyll' on Deployment Methods page ([#2291]({{ site.repository }}/issues/2291))
- Include plugins by sonnym in list of third-party plugins ([#2297]({{ site.repository }}/issues/2297))
- Add deprecated articles keeper filter to list of third-party plugins ([#2300]({{ site.repository }}/issues/2300))
- Simplify and improve our CSS. ([#2127]({{ site.repository }}/issues/2127))
- Use black text color for the mobile navbar ([#2306]({{ site.repository }}/issues/2306))
- Use the built in date filter and `site.time` for the copyright year. ([#2305]({{ site.repository }}/issues/2305))
- Update html5shiv to v3.7.2 ([#2304]({{ site.repository }}/issues/2304))
- Add 2.0.0 release post ([#2298]({{ site.repository }}/issues/2298))
- Add docs for custom markdown processors ([#2298]({{ site.repository }}/issues/2298))
- Add docs for `where` and `group_by` Liquid filters ([#2298]({{ site.repository }}/issues/2298))
- Remove notes in docs for unreleased features ([#2309]({{ site.repository }}/issues/2309))


## 1.5.1 / 2014-03-27
{: #v1-5-1}

### Bug Fixes
{: #bug-fixes-v1-5-1}

- Only strip the drive name if it begins the string ([#2176]({{ site.repository }}/issues/2176))


## 1.5.0 / 2014-03-24
{: #v1-5-0}

### Minor Enhancements
{: #minor-enhancements-v1-5-0}

- Loosen `safe_yaml` dependency to `~> 1.0` ([#2167]({{ site.repository }}/issues/2167))
- Bump `safe_yaml` dependency to `~> 1.0.0` ([#1942]({{ site.repository }}/issues/1942))

### Bug Fixes
{: #bug-fixes-v1-5-0}

- Fix issue where filesystem traversal restriction broke Windows ([#2167]({{ site.repository }}/issues/2167))
- Lock `maruku` at `0.7.0` ([#2167]({{ site.repository }}/issues/2167))

### Development Fixes
{: #development-fixes-v1-5-0}

- Lock `cucumber` at `1.3.11` ([#2167]({{ site.repository }}/issues/2167))


## 1.4.3 / 2014-01-13
{: #v1-4-3}

### Bug Fixes
{: #bug-fixes-v1-4-3}

- Patch show-stopping security vulnerabilities ([#1944]({{ site.repository }}/issues/1944))


## 1.4.2 / 2013-12-16
{: #v1-4-2}

### Bug Fixes
{: #bug-fixes-v1-4-2}

- Turn on Maruku fenced code blocks by default ([#1830]({{ site.repository }}/issues/1830))


## 1.4.1 / 2013-12-09
{: #v1-4-1}

### Bug Fixes
{: #bug-fixes-v1-4-1}

- Don't allow nil entries when loading posts ([#1796]({{ site.repository }}/issues/1796))


## 1.4.0 / 2013-12-07
{: #v1-4-0}

### Major Enhancements
{: #major-enhancements-v1-4-0}

- Add support for TOML config files ([#1765]({{ site.repository }}/issues/1765))

### Minor Enhancements
{: #minor-enhancements-v1-4-0}

- Sort plugins as a way to establish a load order ([#1682]({{ site.repository }}/issues/1682))
- Update Maruku to 0.7.0 ([#1775]({{ site.repository }}/issues/1775))

### Bug Fixes
{: #bug-fixes-v1-4-0}

- Add a space between two words in a Pagination warning message ([#1769]({{ site.repository }}/issues/1769))
- Upgrade `toml` gem to `v0.1.0` to maintain compat with Ruby 1.8.7 ([#1778]({{ site.repository }}/issues/1778))

### Development Fixes
{: #development-fixes-v1-4-0}

- Remove some whitespace in the code ([#1755]({{ site.repository }}/issues/1755))
- Remove some duplication in the reading of posts and drafts ([#1779]({{ site.repository }}/issues/1779))

### Site Enhancements
{: #site-enhancements-v1-4-0}

- Fixed case of a word in the Jekyll v1.3.0 release post ([#1762]({{ site.repository }}/issues/1762))
- Fixed the mime type for the favicon ([#1772]({{ site.repository }}/issues/1772))


## 1.3.1 / 2013-11-26
{: #v1-3-1}

### Minor Enhancements
{: #minor-enhancements-v1-3-1}

- Add a `--prefix` option to passthrough for the importers ([#1669]({{ site.repository }}/issues/1669))
- Push the paginator plugin lower in the plugin priority order so other plugins run before it ([#1759]({{ site.repository }}/issues/1759))

### Bug Fixes
{: #bug-fixes-v1-3-1}

- Fix the include tag when ran in a loop ([#1726]({{ site.repository }}/issues/1726))
- Fix errors when using `--watch` on 1.8.7 ([#1730]({{ site.repository }}/issues/1730))
- Specify where the include is called from if an included file is missing ([#1746]({{ site.repository }}/issues/1746))

### Development Fixes
{: #development-fixes-v1-3-1}

- Extract `Site#filter_entries` into its own object ([#1697]({{ site.repository }}/issues/1697))
- Enable Travis' bundle caching ([#1734]({{ site.repository }}/issues/1734))
- Remove trailing whitespace in some files ([#1736]({{ site.repository }}/issues/1736))
- Fix a duplicate test name ([#1754]({{ site.repository }}/issues/1754))

### Site Enhancements
{: #site-enhancements-v1-3-1}

- Update link to example Rakefile to point to specific commit ([#1741]({{ site.repository }}/issues/1741))
- Fix drafts docs to indicate that draft time is based on file modification time, not `Time.now` ([#1695]({{ site.repository }}/issues/1695))
- Add `jekyll-monthly-archive-plugin` and `jekyll-category-archive-plugin` to list of third-party plugins ([#1693]({{ site.repository }}/issues/1693))
- Add `jekyll-asset-path-plugin` to list of third-party plugins ([#1670]({{ site.repository }}/issues/1670))
- Add `emoji-for-jekyll` to list of third-part plugins ([#1708]({{ site.repository }}/issues/1708))
- Fix previous section link on plugins page to point to pagination page ([#1707]({{ site.repository }}/issues/1707))
- Add `org-mode` converter plugin to third-party plugins ([#1711]({{ site.repository }}/issues/1711))
- Point "Blog migrations" page to http://import.jekyllrb.com ([#1732]({{ site.repository }}/issues/1732))
- Add docs for `post_url` when posts are in subdirectories ([#1718]({{ site.repository }}/issues/1718))
- Update the docs to point to `example.com` ([#1448]({{ site.repository }}/issues/1448))


## 1.3.0 / 2013-11-04
{: #v1-3-0}

### Major Enhancements
{: #major-enhancements-v1-3-0}

- Add support for adding data as YAML files under a site's `_data` directory ([#1003]({{ site.repository }}/issues/1003))
- Allow variables to be used with `include` tags ([#1495]({{ site.repository }}/issues/1495))
- Allow using gems for plugin management ([#1557]({{ site.repository }}/issues/1557))

### Minor Enhancements
{: #minor-enhancements-v1-3-0}

- Decrease the specificity in the site template CSS ([#1574]({{ site.repository }}/issues/1574))
- Add `encoding` configuration option ([#1449]({{ site.repository }}/issues/1449))
- Provide better error handling for Jekyll's custom Liquid tags ([#1514]({{ site.repository }}/issues/1514))
- If an included file causes a Liquid error, add the path to the include file that caused the error to the error message ([#1596]({{ site.repository }}/issues/1596))
- If a layout causes a Liquid error, change the error message so that we know it comes from the layout ([#1601]({{ site.repository }}/issues/1601))
- Update Kramdown dependency to `~> 1.2` ([#1610]({{ site.repository }}/issues/1610))
- Update `safe_yaml` dependency to `~> 0.9.7` ([#1602]({{ site.repository }}/issues/1602))
- Allow layouts to be in subfolders like includes ([#1622]({{ site.repository }}/issues/1622))
- Switch to listen for site watching while serving ([#1589]({{ site.repository }}/issues/1589))
- Add a `json` liquid filter to be used in sites ([#1651]({{ site.repository }}/issues/1651))
- Point people to the migration docs when the `jekyll-import` gem is missing ([#1662]({{ site.repository }}/issues/1662))

### Bug Fixes
{: #bug-fixes-v1-3-0}

- Fix up matching against source and destination when the two locations are similar ([#1556]({{ site.repository }}/issues/1556))
- Fix the missing `pathname` require in certain cases ([#1255]({{ site.repository }}/issues/1255))
- Use `+` instead of `Array#concat` when building `Post` attribute list ([#1571]({{ site.repository }}/issues/1571))
- Print server address when launching a server ([#1586]({{ site.repository }}/issues/1586))
- Downgrade to Maruku `~> 0.6.0` in order to avoid changes in rendering ([#1598]({{ site.repository }}/issues/1598))
- Fix error with failing include tag when variable was file name ([#1613]({{ site.repository }}/issues/1613))
- Downcase lexers before passing them to pygments ([#1615]({{ site.repository }}/issues/1615))
- Capitalize the short verbose switch because it conflicts with the built-in Commander switch ([#1660]({{ site.repository }}/issues/1660))
- Fix compatibility with 1.8.x ([#1665]({{ site.repository }}/issues/1665))
- Fix an error with the new file watching code due to library version incompatibilities ([#1687]({{ site.repository }}/issues/1687))

### Development Fixes
{: #development-fixes-v1-3-0}

- Add coverage reporting with Coveralls ([#1539]({{ site.repository }}/issues/1539))
- Refactor the Liquid `include` tag ([#1490]({{ site.repository }}/issues/1490))
- Update launchy dependency to `~> 2.3` ([#1608]({{ site.repository }}/issues/1608))
- Update rr dependency to `~> 1.1` ([#1604]({{ site.repository }}/issues/1604))
- Update cucumber dependency to `~> 1.3` ([#1607]({{ site.repository }}/issues/1607))
- Update coveralls dependency to `~> 0.7.0` ([#1606]({{ site.repository }}/issues/1606))
- Update rake dependency to `~> 10.1` ([#1603]({{ site.repository }}/issues/1603))
- Clean up `site.rb` comments to be more concise/uniform ([#1616]({{ site.repository }}/issues/1616))
- Use the master branch for the build badge in the readme ([#1636]({{ site.repository }}/issues/1636))
- Refactor Site#render ([#1638]({{ site.repository }}/issues/1638))
- Remove duplication in command line options ([#1637]({{ site.repository }}/issues/1637))
- Add tests for all the coderay options ([#1543]({{ site.repository }}/issues/1543))
- Improve some of the Cucumber test code ([#1493]({{ site.repository }}/issues/1493))
- Improve comparisons of timestamps by ignoring the seconds ([#1582]({{ site.repository }}/issues/1582))

### Site Enhancements
{: #site-enhancements-v1-3-0}

- Fix params for `JekyllImport::WordPress.process` arguments ([#1554]({{ site.repository }}/issues/1554))
- Add `jekyll-suggested-tweet` to list of third-party plugins ([#1555]({{ site.repository }}/issues/1555))
- Link to Liquid's docs for tags and filters ([#1553]({{ site.repository }}/issues/1553))
- Add note about installing Xcode on the Mac in the Installation docs ([#1561]({{ site.repository }}/issues/1561))
- Simplify/generalize pagination docs ([#1577]({{ site.repository }}/issues/1577))
- Add documentation for the new data sources feature ([#1503]({{ site.repository }}/issues/1503))
- Add more information on how to create generators ([#1590]({{ site.repository }}/issues/1590), [#1592]({{ site.repository }}/issues/1592))
- Improve the instructions for mimicking GitHub Flavored Markdown ([#1614]({{ site.repository }}/issues/1614))
- Add `jekyll-import` warning note of missing dependencies ([#1626]({{ site.repository }}/issues/1626))
- Fix grammar in the Usage section ([#1635]({{ site.repository }}/issues/1635))
- Add documentation for the use of gems as plugins ([#1656]({{ site.repository }}/issues/1656))
- Document the existence of a few additional plugins ([#1405]({{ site.repository }}/issues/1405))
- Document that the `date_to_string` always returns a two digit day ([#1663]({{ site.repository }}/issues/1663))
- Fix navigation in the "Working with Drafts" page ([#1667]({{ site.repository }}/issues/1667))
- Fix an error with the data documentation ([#1691]({{ site.repository }}/issues/1691))


## 1.2.1 / 2013-09-14
{: #v1-2-1}

### Minor Enhancements
{: #minor-enhancements-v1-2-1}

- Print better messages for detached server. Mute output on detach. ([#1518]({{ site.repository }}/issues/1518))
- Disable reverse lookup when running `jekyll serve` ([#1363]({{ site.repository }}/issues/1363))
- Upgrade RedCarpet dependency to `~> 2.3.0` ([#1515]({{ site.repository }}/issues/1515))
- Upgrade to Liquid `>= 2.5.2, < 2.6` ([#1536]({{ site.repository }}/issues/1536))

### Bug Fixes
{: #bug-fixes-v1-2-1}

- Fix file discrepancy in gemspec ([#1522]({{ site.repository }}/issues/1522))
- Force rendering of Include tag ([#1525]({{ site.repository }}/issues/1525))

### Development Fixes
{: #development-fixes-v1-2-1}

- Add a rake task to generate a new release post ([#1404]({{ site.repository }}/issues/1404))
- Mute LSI output in tests ([#1531]({{ site.repository }}/issues/1531))
- Update contributor documentation ([#1537]({{ site.repository }}/issues/1537))

### Site Enhancements
{: #site-enhancements-v1-2-1}

- Fix a couple of validation errors on the site ([#1511]({{ site.repository }}/issues/1511))
- Make navigation menus reusable ([#1507]({{ site.repository }}/issues/1507))
- Fix link to History page from Release v1.2.0 notes post.
- Fix markup in History file for command line options ([#1512]({{ site.repository }}/issues/1512))
- Expand 1.2 release post title to 1.2.0 ([#1516]({{ site.repository }}/issues/1516))


## 1.2.0 / 2013-09-06
{: #v1-2-0}

### Major Enhancements
{: #major-enhancements-v1-2-0}

- Disable automatically-generated excerpts when `excerpt_separator` is `""`. ([#1386]({{ site.repository }}/issues/1386))
- Add checking for URL conflicts when running `jekyll doctor` ([#1389]({{ site.repository }}/issues/1389))

### Minor Enhancements
{: #minor-enhancements-v1-2-0}

- Catch and fix invalid `paginate` values ([#1390]({{ site.repository }}/issues/1390))
- Remove superfluous `div.container` from the default html template for `jekyll new` ([#1315]({{ site.repository }}/issues/1315))
- Add `-D` short-form switch for the drafts option ([#1394]({{ site.repository }}/issues/1394))
- Update the links in the site template for Twitter and GitHub ([#1400]({{ site.repository }}/issues/1400))
- Update dummy email address to example.com domain ([#1408]({{ site.repository }}/issues/1408))
- Update normalize.css to v2.1.2 and minify; add rake task to update normalize.css with greater ease. ([#1430]({{ site.repository }}/issues/1430))
- Add the ability to detach the server ran by `jekyll serve` from it's controlling terminal ([#1443]({{ site.repository }}/issues/1443))
- Improve permalink generation for URLs with special characters ([#944]({{ site.repository }}/issues/944))
- Expose the current Jekyll version to posts and pages via a new `jekyll.version` variable ([#1481]({{ site.repository }}/issues/1481))

### Bug Fixes
{: #bug-fixes-v1-2-0}

- Markdown extension matching matches only exact matches ([#1382]({{ site.repository }}/issues/1382))
- Fixed NoMethodError when message passed to `Stevenson#message` is nil ([#1388]({{ site.repository }}/issues/1388))
- Use binary mode when writing file ([#1364]({{ site.repository }}/issues/1364))
- Fix 'undefined method `encoding` for "mailto"' errors w/ Ruby 1.8 and Kramdown > 0.14.0 ([#1397]({{ site.repository }}/issues/1397))
- Do not force the permalink to be a dir if it ends on .html ([#963]({{ site.repository }}/issues/963))
- When a Liquid Exception is caught, show the full path rel. to site source ([#1415]({{ site.repository }}/issues/1415))
- Properly read in the config options when serving the docs locally ([#1444]({{ site.repository }}/issues/1444))
- Fixed `--layouts` option for `build` and `serve` commands ([#1458]({{ site.repository }}/issues/1458))
- Remove kramdown as a runtime dependency since it's optional ([#1498]({{ site.repository }}/issues/1498))
- Provide proper error handling for invalid file names in the include tag ([#1494]({{ site.repository }}/issues/1494))

### Development Fixes
{: #development-fixes-v1-2-0}

- Remove redundant argument to Jekyll::Commands::New#scaffold_post_content ([#1356]({{ site.repository }}/issues/1356))
- Add new dependencies to the README ([#1360]({{ site.repository }}/issues/1360))
- Fix link to contributing page in README ([#1424]({{ site.repository }}/issues/1424))
- Update TomDoc in Pager#initialize to match params ([#1441]({{ site.repository }}/issues/1441))
- Refactor `Site#cleanup` into `Jekyll::Site::Cleaner` class ([#1429]({{ site.repository }}/issues/1429))
- Several other small minor refactorings ([#1341]({{ site.repository }}/issues/1341))
- Ignore `_site` in jekyllrb.com deploy ([#1480]({{ site.repository }}/issues/1480))
- Add Gem version and dependency badge to README ([#1497]({{ site.repository }}/issues/1497))

### Site Enhancements
{: #site-enhancements-v1-2-0}

- Add info about new releases ([#1353]({{ site.repository }}/issues/1353))
- Update plugin list with jekyll-rss plugin ([#1354]({{ site.repository }}/issues/1354))
- Update the site list page with Ruby's official site ([#1358]({{ site.repository }}/issues/1358))
- Add `jekyll-ditaa` to list of third-party plugins ([#1370]({{ site.repository }}/issues/1370))
- Add `postfiles` to list of third-party plugins ([#1373]({{ site.repository }}/issues/1373))
- For internal links, use full path including trailing `/` ([#1411]({{ site.repository }}/issues/1411))
- Use curly apostrophes in the docs ([#1419]({{ site.repository }}/issues/1419))
- Update the docs for Redcarpet in Jekyll ([#1418]({{ site.repository }}/issues/1418))
- Add `pluralize` and `reading_time` filters to docs ([#1439]({{ site.repository }}/issues/1439))
- Fix markup for the Kramdown options ([#1445]({{ site.repository }}/issues/1445))
- Fix typos in the History file ([#1454]({{ site.repository }}/issues/1454))
- Add trailing slash to site's post URL ([#1462]({{ site.repository }}/issues/1462))
- Clarify that `--config` will take multiple files ([#1474]({{ site.repository }}/issues/1474))
- Fix docs/templates.md private gist example ([#1477]({{ site.repository }}/issues/1477))
- Use `site.repository` for Jekyll's GitHub URL ([#1463]({{ site.repository }}/issues/1463))
- Add `jekyll-pageless-redirects` to list of third-party plugins ([#1486]({{ site.repository }}/issues/1486))
- Clarify that `date_to_xmlschema` returns an ISO 8601 string ([#1488]({{ site.repository }}/issues/1488))
- Add `jekyll-good-include` to list of third-party plugins ([#1491]({{ site.repository }}/issues/1491))
- XML escape the blog post title in our feed ([#1501]({{ site.repository }}/issues/1501))
- Add `jekyll-toc-generator` to list of third-party plugins ([#1506]({{ site.repository }}/issues/1506))


## 1.1.2 / 2013-07-25
{: #v1-1-2}

### Bug Fixes
{: #bug-fixes-v1-1-2}

- Require Liquid 2.5.1 ([#1349]({{ site.repository }}/issues/1349))


## 1.1.1 / 2013-07-24
{: #v1-1-1}

### Minor Enhancements
{: #minor-enhancements-v1-1-1}

- Remove superfluous `table` selector from main.css in `jekyll new` template ([#1328]({{ site.repository }}/issues/1328))
- Abort with non-zero exit codes ([#1338]({{ site.repository }}/issues/1338))

### Bug Fixes
{: #bug-fixes-v1-1-1}

- Fix up the rendering of excerpts ([#1339]({{ site.repository }}/issues/1339))

### Site Enhancements
{: #site-enhancements-v1-1-1}

- Add Jekyll Image Tag to the plugins list ([#1306]({{ site.repository }}/issues/1306))
- Remove erroneous statement that `site.pages` are sorted alphabetically.
- Add info about the `_drafts` directory to the directory structure docs ([#1320]({{ site.repository }}/issues/1320))
- Improve the layout of the plugin listing by organizing it into categories ([#1310]({{ site.repository }}/issues/1310))
- Add generator-jekyllrb and grunt-jekyll to plugins page ([#1330]({{ site.repository }}/issues/1330))
- Mention Kramdown as option for markdown parser on Extras page ([#1318]({{ site.repository }}/issues/1318))
- Update Quick-Start page to include reminder that all requirements must be installed ([#1327]({{ site.repository }}/issues/1327))
- Change filename in `include` example to an HTML file so as not to indicate that Jekyll will automatically convert them. ([#1303]({{ site.repository }}/issues/1303))
- Add an RSS feed for commits to Jekyll ([#1343]({{ site.repository }}/issues/1343))


## 1.1.0 / 2013-07-14
{: #v1-1-0}

### Major Enhancements
{: #major-enhancements-v1-1-0}

- Add `docs` subcommand to read Jekyll's docs when offline. ([#1046]({{ site.repository }}/issues/1046))
- Support passing parameters to templates in `include` tag ([#1204]({{ site.repository }}/issues/1204))
- Add support for Liquid tags to post excerpts ([#1302]({{ site.repository }}/issues/1302))

### Minor Enhancements
{: #minor-enhancements-v1-1-0}

- Search the hierarchy of pagination path up to site root to determine template page for pagination. ([#1198]({{ site.repository }}/issues/1198))
- Add the ability to generate a new Jekyll site without a template ([#1171]({{ site.repository }}/issues/1171))
- Use redcarpet as the default markdown engine in newly generated sites ([#1245]({{ site.repository }}/issues/1245), [#1247]({{ site.repository }}/issues/1247))
- Add `redcarpet` as a runtime dependency so `jekyll build` works out-of-the-box for new sites. ([#1247]({{ site.repository }}/issues/1247))
- In the generated site, remove files that will be replaced by a directory ([#1118]({{ site.repository }}/issues/1118))
- Fail loudly if a user-specified configuration file doesn't exist ([#1098]({{ site.repository }}/issues/1098))
- Allow for all options for Kramdown HTML Converter ([#1201]({{ site.repository }}/issues/1201))

### Bug Fixes
{: #bug-fixes-v1-1-0}

- Fix pagination in subdirectories. ([#1198]({{ site.repository }}/issues/1198))
- Fix an issue with directories and permalinks that have a plus sign (+) in them ([#1215]({{ site.repository }}/issues/1215))
- Provide better error reporting when generating sites ([#1253]({{ site.repository }}/issues/1253))
- Latest posts first in non-LSI `related_posts` ([#1271]({{ site.repository }}/issues/1271))

### Development Fixes
{: #development-fixes-v1-1-0}

- Merge the theme and layout Cucumber steps into one step ([#1151]({{ site.repository }}/issues/1151))
- Restrict activesupport dependency to pre-4.0.0 to maintain compatibility with `<= 1.9.2`
- Include/exclude deprecation handling simplification ([#1284]({{ site.repository }}/issues/1284))
- Convert README to Markdown. ([#1267]({{ site.repository }}/issues/1267))
- Refactor Jekyll::Site ([#1144]({{ site.repository }}/issues/1144))

### Site Enhancements
{: #site-enhancements-v1-1-0}

- Add "News" section for release notes, along with an RSS feed ([#1093]({{ site.repository }}/issues/1093), [#1285]({{ site.repository }}/issues/1285), [#1286]({{ site.repository }}/issues/1286))
- Add "History" page.
- Restructured docs sections to include "Meta" section.
- Add message to "Templates" page that specifies that Python must be installed in order to use Pygments. ([#1182]({{ site.repository }}/issues/1182))
- Update link to the official Maruku repo ([#1175]({{ site.repository }}/issues/1175))
- Add documentation about `paginate_path` to "Templates" page in docs ([#1129]({{ site.repository }}/issues/1129))
- Give the quick-start guide its own page ([#1191]({{ site.repository }}/issues/1191))
- Update ProTip on Installation page in docs to point to all the info about Pygments and the 'highlight' tag. ([#1196]({{ site.repository }}/issues/1196))
- Run `site/img` through ImageOptim (thanks @qrush!) ([#1208]({{ site.repository }}/issues/1208))
- Added Jade Converter to `site/docs/plugins` ([#1210]({{ site.repository }}/issues/1210))
- Fix location of docs pages in Contributing pages ([#1214]({{ site.repository }}/issues/1214))
- Add ReadInXMinutes plugin to the plugin list ([#1222]({{ site.repository }}/issues/1222))
- Remove plugins from the plugin list that have equivalents in Jekyll proper ([#1223]({{ site.repository }}/issues/1223))
- Add jekyll-assets to the plugin list ([#1225]({{ site.repository }}/issues/1225))
- Add jekyll-pandoc-multiple-formats to the plugin list ([#1229]({{ site.repository }}/issues/1229))
- Remove dead link to "Using Git to maintain your blog" ([#1227]({{ site.repository }}/issues/1227))
- Tidy up the third-party plugins listing ([#1228]({{ site.repository }}/issues/1228))
- Update contributor information ([#1192]({{ site.repository }}/issues/1192))
- Update URL of article about Blogger migration ([#1242]({{ site.repository }}/issues/1242))
- Specify that RedCarpet is the default for new Jekyll sites on Quickstart page ([#1247]({{ site.repository }}/issues/1247))
- Added `site.pages` to Variables page in docs ([#1251]({{ site.repository }}/issues/1251))
- Add Youku and Tudou Embed link on Plugins page. ([#1250]({{ site.repository }}/issues/1250))
- Add note that `gist` tag supports private gists. ([#1248]({{ site.repository }}/issues/1248))
- Add `jekyll-timeago` to list of third-party plugins. ([#1260]({{ site.repository }}/issues/1260))
- Add `jekyll-swfobject` to list of third-party plugins. ([#1263]({{ site.repository }}/issues/1263))
- Add `jekyll-picture-tag` to list of third-party plugins. ([#1280]({{ site.repository }}/issues/1280))
- Update the GitHub Pages documentation regarding relative URLs ([#1291]({{ site.repository }}/issues/1291))
- Update the S3 deployment documentation ([#1294]({{ site.repository }}/issues/1294))
- Add suggestion for Xcode CLT install to troubleshooting page in docs ([#1296]({{ site.repository }}/issues/1296))
- Add 'Working with drafts' page to docs ([#1289]({{ site.repository }}/issues/1289))
- Add information about time zones to the documentation for a page's date ([#1304]({{ site.repository }}/issues/1304))


## 1.0.3 / 2013-06-07
{: #v1-0-3}

### Minor Enhancements
{: #minor-enhancements-v1-0-3}

- Add support to gist tag for private gists. ([#1189]({{ site.repository }}/issues/1189))
- Fail loudly when Maruku errors out ([#1190]({{ site.repository }}/issues/1190))
- Move the building of related posts into their own class ([#1057]({{ site.repository }}/issues/1057))
- Removed trailing spaces in several places throughout the code ([#1116]({{ site.repository }}/issues/1116))
- Add a `--force` option to `jekyll new` ([#1115]({{ site.repository }}/issues/1115))
- Convert IDs in the site template to classes ([#1170]({{ site.repository }}/issues/1170))

### Bug Fixes
{: #bug-fixes-v1-0-3}

- Fix typo in Stevenson constant "ERROR". ([#1166]({{ site.repository }}/issues/1166))
- Rename Jekyll::Logger to Jekyll::Stevenson to fix inheritance issue ([#1106]({{ site.repository }}/issues/1106))
- Exit with a non-zero exit code when dealing with a Liquid error ([#1121]({{ site.repository }}/issues/1121))
- Make the `exclude` and `include` options backwards compatible with versions of Jekyll prior to 1.0 ([#1114]({{ site.repository }}/issues/1114))
- Fix pagination on Windows ([#1063]({{ site.repository }}/issues/1063))
- Fix the application of Pygments' Generic Output style to Go code ([#1156]({{ site.repository }}/issues/1156))

### Site Enhancements
{: #site-enhancements-v1-0-3}

- Add a Pro Tip to docs about front matter variables being optional ([#1147]({{ site.repository }}/issues/1147))
- Add changelog to site as History page in /docs/ ([#1065]({{ site.repository }}/issues/1065))
- Add note to Upgrading page about new config options in 1.0.x ([#1146]({{ site.repository }}/issues/1146))
- Documentation for `date_to_rfc822` and `uri_escape` ([#1142]({{ site.repository }}/issues/1142))
- Documentation highlight boxes shouldn't show scrollbars if not necessary ([#1123]({{ site.repository }}/issues/1123))
- Add link to jekyll-minibundle in the doc's plugins list ([#1035]({{ site.repository }}/issues/1035))
- Quick patch for importers documentation
- Fix prefix for WordpressDotCom importer in docs ([#1107]({{ site.repository }}/issues/1107))
- Add jekyll-contentblocks plugin to docs ([#1068]({{ site.repository }}/issues/1068))
- Make code bits in notes look more natural, more readable ([#1089]({{ site.repository }}/issues/1089))
- Fix logic for `relative_permalinks` instructions on Upgrading page ([#1101]({{ site.repository }}/issues/1101))
- Add docs for post excerpt ([#1072]({{ site.repository }}/issues/1072))
- Add docs for gist tag ([#1072]({{ site.repository }}/issues/1072))
- Add docs indicating that Pygments does not need to be installed separately ([#1099]({{ site.repository }}/issues/1099), [#1119]({{ site.repository }}/issues/1119))
- Update the migrator docs to be current ([#1136]({{ site.repository }}/issues/1136))
- Add the Jekyll Gallery Plugin to the plugin list ([#1143]({{ site.repository }}/issues/1143))

### Development Fixes
{: #development-fixes-v1-0-3}

- Use Jekyll.logger instead of Jekyll::Stevenson to log things ([#1149]({{ site.repository }}/issues/1149))
- Fix pesky Cucumber infinite loop ([#1139]({{ site.repository }}/issues/1139))
- Do not write posts with timezones in Cucumber tests ([#1124]({{ site.repository }}/issues/1124))
- Use ISO formatted dates in Cucumber features ([#1150]({{ site.repository }}/issues/1150))


## 1.0.2 / 2013-05-12
{: #v1-0-2}

### Major Enhancements
{: #major-enhancements-v1-0-2}

- Add `jekyll doctor` command to check site for any known compatibility problems ([#1081]({{ site.repository }}/issues/1081))
- Backwards-compatibilize relative permalinks ([#1081]({{ site.repository }}/issues/1081))

### Minor Enhancements
{: #minor-enhancements-v1-0-2}

- Add a `data-lang="<lang>"` attribute to Redcarpet code blocks ([#1066]({{ site.repository }}/issues/1066))
- Deprecate old config `server_port`, match to `port` if `port` isn't set ([#1084]({{ site.repository }}/issues/1084))
- Update pygments.rb version to 0.5.0 ([#1061]({{ site.repository }}/issues/1061))
- Update Kramdown version to 1.0.2 ([#1067]({{ site.repository }}/issues/1067))

### Bug Fixes
{: #bug-fixes-v1-0-2}

- Fix issue when categories are numbers ([#1078]({{ site.repository }}/issues/1078))
- Catching that Redcarpet gem isn't installed ([#1059]({{ site.repository }}/issues/1059))

### Site Enhancements
{: #site-enhancements-v1-0-2}

- Add documentation about `relative_permalinks` ([#1081]({{ site.repository }}/issues/1081))
- Remove pygments-installation instructions, as pygments.rb is bundled with it ([#1079]({{ site.repository }}/issues/1079))
- Move pages to be Pages for realz ([#985]({{ site.repository }}/issues/985))
- Updated links to Liquid documentation ([#1073]({{ site.repository }}/issues/1073))


## 1.0.1 / 2013-05-08
{: #v1-0-1}

### Minor Enhancements
{: #minor-enhancements-v1-0-1}

- Do not force use of `toc_token` when using `generate_tok` in RDiscount ([#1048]({{ site.repository }}/issues/1048))
- Add newer `language-` class name prefix to code blocks ([#1037]({{ site.repository }}/issues/1037))
- Commander error message now preferred over process abort with incorrect args ([#1040]({{ site.repository }}/issues/1040))

### Bug Fixes
{: #bug-fixes-v1-0-1}

- Make Redcarpet respect the pygments configuration option ([#1053]({{ site.repository }}/issues/1053))
- Fix the index build with LSI ([#1045]({{ site.repository }}/issues/1045))
- Don't print deprecation warning when no arguments are specified. ([#1041]({{ site.repository }}/issues/1041))
- Add missing `</div>` to site template used by `new` subcommand, fixed typos in code ([#1032]({{ site.repository }}/issues/1032))

### Site Enhancements
{: #site-enhancements-v1-0-1}

- Changed https to http in the GitHub Pages link ([#1051]({{ site.repository }}/issues/1051))
- Remove CSS cruft, fix typos, fix HTML errors ([#1028]({{ site.repository }}/issues/1028))
- Removing manual install of Pip and Distribute ([#1025]({{ site.repository }}/issues/1025))
- Updated URL for Markdown references plugin ([#1022]({{ site.repository }}/issues/1022))

### Development Fixes
{: #development-fixes-v1-0-1}

- Markdownify history file ([#1027]({{ site.repository }}/issues/1027))
- Update links on README to point to new jekyllrb.com ([#1018]({{ site.repository }}/issues/1018))


## 1.0.0 / 2013-05-06
{: #v1-0-0}

### Major Enhancements
{: #major-enhancements-v1-0-0}

- Add `jekyll new` subcommand: generate a Jekyll scaffold ([#764]({{ site.repository }}/issues/764))
- Refactored Jekyll commands into subcommands: build, serve, and migrate. ([#690]({{ site.repository }}/issues/690))
- Removed importers/migrators from main project, migrated to jekyll-import sub-gem ([#793]({{ site.repository }}/issues/793))
- Added ability to render drafts in `_drafts` folder via command line ([#833]({{ site.repository }}/issues/833))
- Add ordinal date permalink style (/:categories/:year/:y_day/:title.html) ([#928]({{ site.repository }}/issues/928))

### Minor Enhancements
{: #minor-enhancements-v1-0-0}

- Site template HTML5-ified ([#964]({{ site.repository }}/issues/964))
- Use post's directory path when matching for the `post_url` tag ([#998]({{ site.repository }}/issues/998))
- Loosen dependency on Pygments so it's only required when it's needed ([#1015]({{ site.repository }}/issues/1015))
- Parse strings into Time objects for date-related Liquid filters ([#1014]({{ site.repository }}/issues/1014))
- Tell the user if there is no subcommand specified ([#1008]({{ site.repository }}/issues/1008))
- Freak out if the destination of `jekyll new` exists and is non-empty ([#981]({{ site.repository }}/issues/981))
- Add `timezone` configuration option for compilation ([#957]({{ site.repository }}/issues/957))
- Add deprecation messages for pre-1.0 CLI options ([#959]({{ site.repository }}/issues/959))
- Refactor and colorize logging ([#959]({{ site.repository }}/issues/959))
- Refactor Markdown parsing ([#955]({{ site.repository }}/issues/955))
- Added application/vnd.apple.pkpass to mime.types served by WEBrick ([#907]({{ site.repository }}/issues/907))
- Move template site to default markdown renderer ([#961]({{ site.repository }}/issues/961))
- Expose new attribute to Liquid via `page`: `page.path` ([#951]({{ site.repository }}/issues/951))
- Accept multiple config files from command line ([#945]({{ site.repository }}/issues/945))
- Add page variable to liquid custom tags and blocks ([#413]({{ site.repository }}/issues/413))
- Add `paginator.previous_page_path` and `paginator.next_page_path` ([#942]({{ site.repository }}/issues/942))
- Backwards compatibility for 'auto' ([#821]({{ site.repository }}/issues/821), [#934]({{ site.repository }}/issues/934))
- Added date_to_rfc822 used on RSS feeds ([#892]({{ site.repository }}/issues/892))
- Upgrade version of pygments.rb to 0.4.2 ([#927]({{ site.repository }}/issues/927))
- Added short month (e.g. "Sep") to permalink style options for posts ([#890]({{ site.repository }}/issues/890))
- Expose site.baseurl to Liquid templates ([#869]({{ site.repository }}/issues/869))
- Adds excerpt attribute to posts which contains first paragraph of content ([#837]({{ site.repository }}/issues/837))
- Accept custom configuration file via CLI ([#863]({{ site.repository }}/issues/863))
- Load in GitHub Pages MIME Types on `jekyll serve` ([#847]({{ site.repository }}/issues/847), [#871]({{ site.repository }}/issues/871))
- Improve debuggability of error message for a malformed highlight tag ([#785]({{ site.repository }}/issues/785))
- Allow symlinked files in unsafe mode ([#824]({{ site.repository }}/issues/824))
- Add 'gist' Liquid tag to core ([#822]({{ site.repository }}/issues/822), [#861]({{ site.repository }}/issues/861))
- New format of Jekyll output ([#795]({{ site.repository }}/issues/795))
- Reinstate `--limit_posts` and `--future` switches ([#788]({{ site.repository }}/issues/788))
- Remove ambiguity from command descriptions ([#815]({{ site.repository }}/issues/815))
- Fix SafeYAML Warnings ([#807]({{ site.repository }}/issues/807))
- Relaxed Kramdown version to 0.14 ([#808]({{ site.repository }}/issues/808))
- Aliased `jekyll server` to `jekyll serve`. ([#792]({{ site.repository }}/issues/792))
- Updated gem versions for Kramdown, Rake, Shoulda, Cucumber, and RedCarpet. ([#744]({{ site.repository }}/issues/744))
- Refactored Jekyll subcommands into Jekyll::Commands submodule, which now contains them ([#768]({{ site.repository }}/issues/768))
- Rescue from import errors in Wordpress.com migrator ([#671]({{ site.repository }}/issues/671))
- Massively accelerate LSI performance ([#664]({{ site.repository }}/issues/664))
- Truncate post slugs when importing from Tumblr ([#496]({{ site.repository }}/issues/496))
- Add glob support to include, exclude option ([#743]({{ site.repository }}/issues/743))
- Layout of Page or Post defaults to 'page' or 'post', respectively ([#580]({{ site.repository }}/issues/580)) REPEALED by ([#977]({{ site.repository }}/issues/977))
- "Keep files" feature ([#685]({{ site.repository }}/issues/685))
- Output full path & name for files that don't parse ([#745]({{ site.repository }}/issues/745))
- Add source and destination directory protection ([#535]({{ site.repository }}/issues/535))
- Better YAML error message ([#718]({{ site.repository }}/issues/718))
- Bug Fixes
- Paginate in subdirectories properly ([#1016]({{ site.repository }}/issues/1016))
- Ensure post and page URLs have a leading slash ([#992]({{ site.repository }}/issues/992))
- Catch all exceptions, not just StandardError descendents ([#1007]({{ site.repository }}/issues/1007))
- Bullet-proof `limit_posts` option ([#1004]({{ site.repository }}/issues/1004))
- Read in YAML as UTF-8 to accept non-ASCII chars ([#836]({{ site.repository }}/issues/836))
- Fix the CLI option `--plugins` to actually accept dirs and files ([#993]({{ site.repository }}/issues/993))
- Allow 'excerpt' in front matter to override the extracted excerpt ([#946]({{ site.repository }}/issues/946))
- Fix cascade problem with site.baseurl, site.port and site.host. ([#935]({{ site.repository }}/issues/935))
- Filter out directories with valid post names ([#875]({{ site.repository }}/issues/875))
- Fix symlinked static files not being correctly built in unsafe mode ([#909]({{ site.repository }}/issues/909))
- Fix integration with directory_watcher 1.4.x ([#916]({{ site.repository }}/issues/916))
- Accepting strings as arguments to jekyll-import command ([#910]({{ site.repository }}/issues/910))
- Force usage of older directory_watcher gem as 1.5 is broken ([#883]({{ site.repository }}/issues/883))
- Ensure all Post categories are downcase ([#842]({{ site.repository }}/issues/842), [#872]({{ site.repository }}/issues/872))
- Force encoding of the rdiscount TOC to UTF8 to avoid conversion errors ([#555]({{ site.repository }}/issues/555))
- Patch for multibyte URI problem with `jekyll serve` ([#723]({{ site.repository }}/issues/723))
- Order plugin execution by priority ([#864]({{ site.repository }}/issues/864))
- Fixed Page#dir and Page#url for edge cases ([#536]({{ site.repository }}/issues/536))
- Fix broken `post_url` with posts with a time in their front matter ([#831]({{ site.repository }}/issues/831))
- Look for plugins under the source directory ([#654]({{ site.repository }}/issues/654))
- Tumblr Migrator: finds `_posts` dir correctly, fixes truncation of long post names ([#775]({{ site.repository }}/issues/775))
- Force Categories to be Strings ([#767]({{ site.repository }}/issues/767))
- Safe YAML plugin to prevent vulnerability ([#777]({{ site.repository }}/issues/777))
- Add SVG support to Jekyll/WEBrick. ([#407]({{ site.repository }}/issues/407), [#406]({{ site.repository }}/issues/406))
- Prevent custom destination from causing continuous regen on watch ([#528]({{ site.repository }}/issues/528), [#820]({{ site.repository }}/issues/820), [#862]({{ site.repository }}/issues/862))

### Site Enhancements
{: #site-enhancements-v1-0-0}

- Responsify ([#860]({{ site.repository }}/issues/860))
- Fix spelling, punctuation and phrasal errors ([#989]({{ site.repository }}/issues/989))
- Update quickstart instructions with `new` command ([#966]({{ site.repository }}/issues/966))
- Add docs for page.excerpt ([#956]({{ site.repository }}/issues/956))
- Add docs for page.path ([#951]({{ site.repository }}/issues/951))
- Clean up site docs to prepare for 1.0 release ([#918]({{ site.repository }}/issues/918))
- Bring site into master branch with better preview/deploy ([#709]({{ site.repository }}/issues/709))
- Redesigned site ([#583]({{ site.repository }}/issues/583))

### Development Fixes
{: #development-fixes-v1-0-0}

- Exclude Cucumber 1.2.4, which causes tests to fail in 1.9.2 ([#938]({{ site.repository }}/issues/938))
- Added "features:html" rake task for debugging purposes, cleaned up Cucumber profiles ([#832]({{ site.repository }}/issues/832))
- Explicitly require HTTPS rubygems source in Gemfile ([#826]({{ site.repository }}/issues/826))
- Changed Ruby version for development to 1.9.3-p374 from p362 ([#801]({{ site.repository }}/issues/801))
- Including a link to the GitHub Ruby style guide in CONTRIBUTING.md ([#806]({{ site.repository }}/issues/806))
- Added script/bootstrap ([#776]({{ site.repository }}/issues/776))
- Running Simplecov under 2 conditions: ENV(COVERAGE)=true and with Ruby version of greater than 1.9 ([#771]({{ site.repository }}/issues/771))
- Switch to Simplecov for coverage report ([#765]({{ site.repository }}/issues/765))


## 0.12.1 / 2013-02-19
{: #v0-12-1}

### Minor Enhancements
{: #minor-enhancements-v0-12-1}

- Update Kramdown version to 0.14.1 ([#744]({{ site.repository }}/issues/744))
- Test Enhancements
- Update Rake version to 10.0.3 ([#744]({{ site.repository }}/issues/744))
- Update Shoulda version to 3.3.2 ([#744]({{ site.repository }}/issues/744))
- Update Redcarpet version to 2.2.2 ([#744]({{ site.repository }}/issues/744))


## 0.12.0 / 2012-12-22
{: #v0-12-0}

### Minor Enhancements
{: #minor-enhancements-v0-12-0}

- Add ability to explicitly specify included files ([#261]({{ site.repository }}/issues/261))
- Add `--default-mimetype` option ([#279]({{ site.repository }}/issues/279))
- Allow setting of RedCloth options ([#284]({{ site.repository }}/issues/284))
- Add `post_url` Liquid tag for internal post linking ([#369]({{ site.repository }}/issues/369))
- Allow multiple plugin dirs to be specified ([#438]({{ site.repository }}/issues/438))
- Inline TOC token support for RDiscount ([#333]({{ site.repository }}/issues/333))
- Add the option to specify the paginated url format ([#342]({{ site.repository }}/issues/342))
- Swap out albino for pygments.rb ([#569]({{ site.repository }}/issues/569))
- Support Redcarpet 2 and fenced code blocks ([#619]({{ site.repository }}/issues/619))
- Better reporting of Liquid errors ([#624]({{ site.repository }}/issues/624))
- Bug Fixes
- Allow some special characters in highlight names
- URL escape category names in URL generation ([#360]({{ site.repository }}/issues/360))
- Fix error with `limit_posts` ([#442]({{ site.repository }}/issues/442))
- Properly select dotfile during directory scan ([#363]({{ site.repository }}/issues/363), [#431]({{ site.repository }}/issues/431), [#377]({{ site.repository }}/issues/377))
- Allow setting of Kramdown `smart_quotes` ([#482]({{ site.repository }}/issues/482))
- Ensure front matter is at start of file ([#562]({{ site.repository }}/issues/562))


## 0.11.2 / 2011-12-27
{: #v0-11-2}

- Bug Fixes
- Fix gemspec


## 0.11.1 / 2011-12-27
{: #v0-11-1}

- Bug Fixes
- Fix extra blank line in highlight blocks ([#409]({{ site.repository }}/issues/409))
- Update dependencies


## 0.11.0 / 2011-07-10
{: #v0-11-0}

### Major Enhancements
{: #major-enhancements-v0-11-0}

- Add command line importer functionality ([#253]({{ site.repository }}/issues/253))
- Add Redcarpet Markdown support ([#318]({{ site.repository }}/issues/318))
- Make markdown/textile extensions configurable ([#312]({{ site.repository }}/issues/312))
- Add `markdownify` filter

### Minor Enhancements
{: #minor-enhancements-v0-11-0}

- Switch to Albino gem
- Bundler support
- Use English library to avoid hoops ([#292]({{ site.repository }}/issues/292))
- Add Posterous importer ([#254]({{ site.repository }}/issues/254))
- Fixes for Wordpress importer ([#274]({{ site.repository }}/issues/274), [#252]({{ site.repository }}/issues/252), [#271]({{ site.repository }}/issues/271))
- Better error message for invalid post date ([#291]({{ site.repository }}/issues/291))
- Print formatted fatal exceptions to stdout on build failure
- Add Tumblr importer ([#323]({{ site.repository }}/issues/323))
- Add Enki importer ([#320]({{ site.repository }}/issues/320))
- Bug Fixes
- Secure additional path exploits


## 0.10.0 / 2010-12-16
{: #v0-10-0}

- Bug Fixes
- Add `--no-server` option.


## 0.9.0 / 2010-12-15
{: #v0-9-0}

### Minor Enhancements
{: #minor-enhancements-v0-9-0}

- Use OptionParser's `[no-]` functionality for better boolean parsing.
- Add Drupal migrator ([#245]({{ site.repository }}/issues/245))
- Complain about YAML and Liquid errors ([#249]({{ site.repository }}/issues/249))
- Remove orphaned files during regeneration ([#247]({{ site.repository }}/issues/247))
- Add Marley migrator ([#28]({{ site.repository }}/issues/28))


## 0.8.0 / 2010-11-22
{: #v0-8-0}

### Minor Enhancements
{: #minor-enhancements-v0-8-0}

- Add wordpress.com importer ([#207]({{ site.repository }}/issues/207))
- Add `--limit-posts` cli option ([#212]({{ site.repository }}/issues/212))
- Add `uri_escape` filter ([#234]({{ site.repository }}/issues/234))
- Add `--base-url` cli option ([#235]({{ site.repository }}/issues/235))
- Improve MT migrator ([#238]({{ site.repository }}/issues/238))
- Add kramdown support ([#239]({{ site.repository }}/issues/239))
- Bug Fixes
- Fixed filename basename generation ([#208]({{ site.repository }}/issues/208))
- Set mode to UTF8 on Sequel connections ([#237]({{ site.repository }}/issues/237))
- Prevent `_includes` dir from being a symlink


## 0.7.0 / 2010-08-24
{: #v0-7-0}

### Minor Enhancements
{: #minor-enhancements-v0-7-0}

- Add support for rdiscount extensions ([#173]({{ site.repository }}/issues/173))
- Bug Fixes
- Highlight should not be able to render local files
- The site configuration may not always provide a 'time' setting ([#184]({{ site.repository }}/issues/184))


## 0.6.2 / 2010-06-25
{: #v0-6-2}

- Bug Fixes
- Fix Rakefile 'release' task (tag pushing was missing origin)
- Ensure that RedCloth is loaded when textilize filter is used ([#183]({{ site.repository }}/issues/183))
- Expand source, destination, and plugin paths ([#180]({{ site.repository }}/issues/180))
- Fix `page.url` to include full relative path ([#181]({{ site.repository }}/issues/181))


## 0.6.1 / 2010-06-24
{: #v0-6-1}

- Bug Fixes
- Fix Markdown Pygments prefix and suffix ([#178]({{ site.repository }}/issues/178))


## 0.6.0 / 2010-06-23
{: #v0-6-0}

### Major Enhancements
{: #major-enhancements-v0-6-0}

- Proper plugin system ([#19]({{ site.repository }}/issues/19), [#100]({{ site.repository }}/issues/100))
- Add safe mode so unsafe converters/generators can be added
- Maruku is now the only processor dependency installed by default. Other processors will be lazy-loaded when necessary (and prompt the user to install them when necessary) ([#57]({{ site.repository }}/issues/57))

### Minor Enhancements
{: #minor-enhancements-v0-6-0}

- Inclusion/exclusion of future dated posts ([#59]({{ site.repository }}/issues/59))
- Generation for a specific time ([#59]({{ site.repository }}/issues/59))
- Allocate `site.time` on render not per site_payload invocation ([#59]({{ site.repository }}/issues/59))
- Pages now present in the site payload and can be used through the `site.pages` and `site.html_pages` variables
- Generate phase added to site#process and pagination is now a generator
- Switch to RakeGem for build/test process
- Only regenerate static files when they have changed ([#142]({{ site.repository }}/issues/142))
- Allow arbitrary options to Pygments ([#31]({{ site.repository }}/issues/31))
- Allow URL to be set via command line option ([#147]({{ site.repository }}/issues/147))
- Bug Fixes
- Render highlighted code for non markdown/textile pages ([#116]({{ site.repository }}/issues/116))
- Fix highlighting on Ruby 1.9 ([#65]({{ site.repository }}/issues/65))
- Fix extension munging when pretty permalinks are enabled ([#64]({{ site.repository }}/issues/64))
- Stop sorting categories ([#33]({{ site.repository }}/issues/33))
- Preserve generated attributes over front matter ([#119]({{ site.repository }}/issues/119))
- Fix source directory binding using `Dir.pwd` ([#75]({{ site.repository }}/issues/75))


## 0.5.7 / 2010-01-12
{: #v0-5-7}

### Minor Enhancements
{: #minor-enhancements-v0-5-7}

- Allow overriding of post date in the front matter ([#62]({{ site.repository }}/issues/62), [#38]({{ site.repository }}/issues/38))
- Bug Fixes
- Categories isn't always an array ([#73]({{ site.repository }}/issues/73))
- Empty tags causes error in read_posts ([#84]({{ site.repository }}/issues/84))
- Fix pagination to adhere to read/render/write paradigm
- Test Enhancement
- Cucumber features no longer use site.posts.first where a better alternative is available


## 0.5.6 / 2010-01-08
{: #v0-5-6}

- Bug Fixes
- Require redcloth >= 4.2.1 in tests ([#92]({{ site.repository }}/issues/92))
- Don't break on triple dashes in front matter ([#93]({{ site.repository }}/issues/93))

### Minor Enhancements
{: #minor-enhancements-v0-5-6}

- Allow .mkd as markdown extension
- Use $stdout/err instead of constants ([#99]({{ site.repository }}/issues/99))
- Properly wrap code blocks ([#91]({{ site.repository }}/issues/91))
- Add javascript mime type for webrick ([#98]({{ site.repository }}/issues/98))


## 0.5.5 / 2010-01-08
{: #v0-5-5}

- Bug Fixes
- Fix pagination % 0 bug ([#78]({{ site.repository }}/issues/78))
- Ensure all posts are processed first ([#71]({{ site.repository }}/issues/71))
- After this point I will no longer be giving credit in the history; that is what the commit log is for.


## 0.5.4 / 2009-08-23
{: #v0-5-4}

- Bug Fixes
- Do not allow symlinks (security vulnerability)


## 0.5.3 / 2009-07-14
{: #v0-5-3}

- Bug Fixes
- Solving the permalink bug where non-html files wouldn't work (@jeffrydegrande)


## 0.5.2 / 2009-06-24
{: #v0-5-2}

- Enhancements
- Added --paginate option to the executable along with a paginator object for the payload (@calavera)
- Upgraded RedCloth to 4.2.1, which makes `<notextile>` tags work once again.
- Configuration options set in config.yml are now available through the site payload (@vilcans)
- Posts can now have an empty front matter or none at all (@ bahuvrihi)
- Bug Fixes
- Fixing Ruby 1.9 issue that requires `#to_s` on the err object (@Chrononaut)
- Fixes for pagination and ordering posts on the same day (@ujh)
- Made pages respect permalinks style and permalinks in yml front matter (@eugenebolshakov)
- Index.html file should always have index.html permalink (@eugenebolshakov)
- Added trailing slash to pretty permalink style so Apache is happy (@eugenebolshakov)
- Bad markdown processor in config fails sooner and with better message (@ gcnovus)
- Allow CRLFs in front matter (@juretta)
- Added Date#xmlschema for Ruby versions < 1.9


## 0.5.1 / 2009-05-06
{: #v0-5-1}

### Major Enhancements
{: #major-enhancements-v0-5-1}

- Next/previous posts in site payload (@pantulis, @tomo)
- Permalink templating system
- Moved most of the README out to the GitHub wiki
- Exclude option in configuration so specified files won't be brought over with generated site (@duritong)
- Bug Fixes
- Making sure config.yaml references are all gone, using only config.yml
- Fixed syntax highlighting breaking for UTF-8 code (@henrik)
- Worked around RDiscount bug that prevents Markdown from getting parsed after highlight (@henrik)
- CGI escaped post titles (@Chrononaut)


## 0.5.0 / 2009-04-07
{: #v0-5-0}

### Minor Enhancements
{: #minor-enhancements-v0-5-0}

- Ability to set post categories via YAML (@qrush)
- Ability to set prevent a post from publishing via YAML (@qrush)
- Add textilize filter (@willcodeforfoo)
- Add 'pretty' permalink style for wordpress-like urls (@dysinger)
- Made it possible to enter categories from YAML as an array (@Chrononaut)
- Ignore Emacs autosave files (@Chrononaut)
- Bug Fixes
- Use block syntax of popen4 to ensure that subprocesses are properly disposed (@jqr)
- Close open4 streams to prevent zombies (@rtomayko)
- Only query required fields from the WP Database (@ariejan)
- Prevent `_posts` from being copied to the destination directory (@bdimcheff)
- Refactors
- Factored the filtering code into a method (@Chrononaut)
- Fix tests and convert to Shoulda (@qrush, @technicalpickles)
- Add Cucumber acceptance test suite (@qrush, @technicalpickles)


## 0.4.1

### Minor Enhancements
{: #minor-enhancements-v--}

- Changed date format on wordpress converter (zeropadding) (@dysinger)
- Bug Fixes
- Add Jekyll binary as executable to gemspec (@dysinger)


## 0.4.0 / 2009-02-03
{: #v0-4-0}

### Major Enhancements
{: #major-enhancements-v0-4-0}

- Switch to Jeweler for packaging tasks

### Minor Enhancements
{: #minor-enhancements-v0-4-0}

- Type importer (@codeslinger)
- `site.topics` accessor (@baz)
- Add `array_to_sentence_string` filter (@mchung)
- Add a converter for textpattern (@PerfectlyNormal)
- Add a working Mephisto / MySQL converter (@ivey)
- Allowing .htaccess files to be copied over into the generated site (@briandoll)
- Add option to not put file date in permalink URL (@mreid)
- Add line number capabilities to highlight blocks (@jcon)
- Bug Fixes
- Fix permalink behavior (@cavalle)
- Fixed an issue with pygments, markdown, and newlines (@zpinter)
- Ampersands need to be escaped (@pufuwozu, @ap)
- Test and fix the site.categories hash (@zzot)
- Fix site payload available to files (@matrix9180)


## 0.3.0 / 2008-12-24
{: #v0-3-0}

### Major Enhancements
{: #major-enhancements-v0-3-0}

- Added `--server` option to start a simple WEBrick server on destination directory (@johnreilly and @mchung)

### Minor Enhancements
{: #minor-enhancements-v0-3-0}

- Added post categories based on directories containing `_posts` (@mreid)
- Added post topics based on directories underneath `_posts`
- Added new date filter that shows the full month name (@mreid)
- Merge Post's front matter into its to_liquid payload (@remi)
- Restrict includes to regular files underneath `_includes`
- Bug Fixes
- Change YAML delimiter matcher so as to not chew up 2nd level markdown headers (@mreid)
- Fix bug that meant page data (such as the date) was not available in templates (@mreid)
- Properly reject directories in `_layouts`


## 0.2.1 / 2008-12-15
{: #v0-2-1}

- Major Changes
- Use Maruku (pure Ruby) for Markdown by default (@mreid)
- Allow use of RDiscount with `--rdiscount` flag

### Minor Enhancements
{: #minor-enhancements-v0-2-1}

- Don't load directory_watcher unless it's needed (@pjhyett)


## 0.2.0 / 2008-12-14
{: #v0-2-0}

- Major Changes
- related_posts is now found in `site.related_posts`


## 0.1.6 / 2008-12-13
{: #v0-1-6}

- Major Features
- Include files in `_includes` with {% raw %}`{% include x.textile %}`{% endraw %}


## 0.1.5 / 2008-12-12
{: #v0-1-5}

### Major Enhancements
{: #major-enhancements-v0-1-5}

- Code highlighting with Pygments if `--pygments` is specified
- Disable true LSI by default, enable with `--lsi`

### Minor Enhancements
{: #minor-enhancements-v0-1-5}

- Output informative message if RDiscount is not available (@JackDanger)
- Bug Fixes
- Prevent Jekyll from picking up the output directory as a source (@JackDanger)
- Skip `related_posts` when there is only one post (@JackDanger)


## 0.1.4 / 2008-12-08
{: #v0-1-4}

- Bug Fixes
- DATA does not work properly with rubygems


## 0.1.3 / 2008-12-06
{: #v0-1-3}

- Major Features
- Markdown support (@vanpelt)
- Mephisto and CSV converters (@vanpelt)
- Code hilighting (@vanpelt)
- Autobuild
- Bug Fixes
- Accept both `\r\n` and `\n` in YAML header (@vanpelt)


## 0.1.2 / 2008-11-22
{: #v0-1-2}

- Major Features
- Add a real "related posts" implementation using Classifier
- Command Line Changes
- Allow cli to be called with 0, 1, or 2 args intuiting dir paths if they are omitted


## 0.1.1 / 2008-11-22
{: #v0-1-1}

- Minor Additions
- Posts now support introspectional data e.g. {% raw %}`{{ page.url }}`{% endraw %}


## 0.1.0 / 2008-11-05
{: #v0-1-0}

- First release
- Converts posts written in Textile
- Converts regular site pages
- Simple copy of binary files


## 0.0.0 / 2008-10-19
{: #v0-0-0}

- Birthday!
