# Copyright(c) 1986 Association of Universities for Research in Astronomy Inc.

# SYS_RUNTASK -- Called by the IRAF Main to run one of the tasks in a
# process.  This file is the template for the actual procedure, which
# is generated by the compiler in processing the TASK statement.
# The special statements TN$DECL and TN$DICT are replaced, respectively, by
# the code to declare the task name strings, and the code to search the
# dictionary and execute a task.  The dictionary consists of the string buffer
# DICT, containing the EOS delimited task name strings, and a array DP
# containing the indices of the individual strings.

int procedure sys_runtask (task, cmd, ruk_argoff, ruk_interact)

char	task[ARB]		#I task name
char	cmd[ARB]		#I command line
int	ruk_argoff		#I offset of argument list in CMD
int	ruk_interact		#I we were called interactively

int	i, ntasks
int	lmarg, rmarg, maxch, ncol, ruk_eawarn
int	envgeti(), envscan()
bool	streq()

TN$DECL	# task name declarations (DP, DICT)
data	lmarg /5/, maxch /0/, ncol /0/, ruk_eawarn /3/
data	ntasks /0/

begin
	# Upon the first entry, count the number of tasks (the DP array
	# containing the indices of the strings is NULL delimited).

	if (ntasks == 0) {
	    for (i=1;  dp[i] != NULL;  i=i+1)
		;
	    ntasks = i - 1
	}

	# Search the dictionary for the named task and execute it.  The
	# special builtin task "?" prints the contents of the dictionary.
	# CHDIR changes the working directory; SET adds set declarations
	# to the environment list.  If a SET or CHDIR cannot be processed
	# for some reason when we are run as a connected subprocess (i.e.,
	# noninteractively), it is a fatal error.  This is done because
	# STDERR is redirected into the nullfile during process startup,
	# hence any warning messages would not be seen by the parent.

	if (task[1] == '?') {					# ?
	    # Print a menu listing all available tasks.
	    iferr (rmarg = envgeti ("ttyncols"))
		rmarg = 80
	    call strtbl (STDOUT, dict, dp, ntasks, lmarg, rmarg, maxch, ncol)
	    return (OK)

	} else if (streq(task,"chdir") || streq(task,"cd")) {	# CHDIR
	    # Change the current working directory.
	    iferr {
		if (cmd[ruk_argoff] == EOS) {
		    iferr (call fchdir ("home$"))
			call fchdir ("HOME$")
		} else
		    call fchdir (cmd[ruk_argoff])
	    } then if (ruk_interact == YES) {
		call erract (ruk_eawarn)
	    } else
		; # call sys_panic (0, "invalid CHDIR in IRAF Main")
	    return (OK)

	} else if (streq(task,"set") || streq(task,"reset")) {	# SET
	    # Set the value of an environment variable.  If called
	    # with no args print the current environment list.

	    iferr {
		if (cmd[ruk_argoff] == EOS) {
		    call envlist (STDOUT, "\t", YES)
		    call flush (STDOUT)
		} else if (envscan (cmd) <= 0) {
		    if (ruk_interact == YES) {
			call eprintf ("invalid set statement: '%s'\n")
			    call pargstr (cmd)
		    } else
			goto 91
		}
	    } then if (ruk_interact == YES) {
		call erract (ruk_eawarn)
	    } else
 91		call sys_panic (0, "invalid SET in IRAF Main")
	    return (OK)
	}

	# The following symbol is expanded into the interpreter code for
	# the dictionary of user tasks.

	TN$INTERP

	# If we get here the named task could not be found.
	return (ERR)
end
