/*************************************************************************
 * Copyright (C) 2019-2024 Intel Corporation
 *
 * Licensed under the Apache License,  Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law  or agreed  to  in  writing,  software
 * distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the  specific  language  governing  permissions  and
 * limitations under the License.
 *************************************************************************/

#include <internal/common/ifma_defs.h>

#if (_MBX >= _MBX_K1)

#include <internal/common/ifma_math.h>

void AMS52x79_diagonal_mb8(int64u* out_mb,
                           const int64u* inpA_mb,
                           const int64u* inpM_mb,
                           const int64u* k0_mb)
{

    __ALIGN64 U64 res[160];
    __ALIGN64 U64 u[80];
    U64 k;
    U64* a = (U64*)inpA_mb;
    U64* m = (U64*)inpM_mb;
    U64* r = (U64*)out_mb;

    k = loadu64((U64*)k0_mb);
    int i;
    for (i = 0; i < 160; ++i)
        res[i] = get_zero64();

    // Calculate full square
    res[1]   = fma52lo(res[1], a[0], a[1]);     // Sum(1)
    res[2]   = fma52hi(res[2], a[0], a[1]);     // Sum(1)
    res[2]   = fma52lo(res[2], a[0], a[2]);     // Sum(2)
    res[3]   = fma52hi(res[3], a[0], a[2]);     // Sum(2)
    res[3]   = fma52lo(res[3], a[1], a[2]);     // Sum(3)
    res[4]   = fma52hi(res[4], a[1], a[2]);     // Sum(3)
    res[3]   = fma52lo(res[3], a[0], a[3]);     // Sum(3)
    res[4]   = fma52hi(res[4], a[0], a[3]);     // Sum(3)
    res[4]   = fma52lo(res[4], a[1], a[3]);     // Sum(4)
    res[5]   = fma52hi(res[5], a[1], a[3]);     // Sum(4)
    res[5]   = fma52lo(res[5], a[2], a[3]);     // Sum(5)
    res[6]   = fma52hi(res[6], a[2], a[3]);     // Sum(5)
    res[4]   = fma52lo(res[4], a[0], a[4]);     // Sum(4)
    res[5]   = fma52hi(res[5], a[0], a[4]);     // Sum(4)
    res[5]   = fma52lo(res[5], a[1], a[4]);     // Sum(5)
    res[6]   = fma52hi(res[6], a[1], a[4]);     // Sum(5)
    res[6]   = fma52lo(res[6], a[2], a[4]);     // Sum(6)
    res[7]   = fma52hi(res[7], a[2], a[4]);     // Sum(6)
    res[7]   = fma52lo(res[7], a[3], a[4]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[3], a[4]);     // Sum(7)
    res[5]   = fma52lo(res[5], a[0], a[5]);     // Sum(5)
    res[6]   = fma52hi(res[6], a[0], a[5]);     // Sum(5)
    res[6]   = fma52lo(res[6], a[1], a[5]);     // Sum(6)
    res[7]   = fma52hi(res[7], a[1], a[5]);     // Sum(6)
    res[7]   = fma52lo(res[7], a[2], a[5]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[2], a[5]);     // Sum(7)
    res[8]   = fma52lo(res[8], a[3], a[5]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[3], a[5]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[4], a[5]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[4], a[5]);    // Sum(9)
    res[6]   = fma52lo(res[6], a[0], a[6]);     // Sum(6)
    res[7]   = fma52hi(res[7], a[0], a[6]);     // Sum(6)
    res[7]   = fma52lo(res[7], a[1], a[6]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[1], a[6]);     // Sum(7)
    res[8]   = fma52lo(res[8], a[2], a[6]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[2], a[6]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[3], a[6]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[3], a[6]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[4], a[6]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[4], a[6]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[5], a[6]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[5], a[6]);    // Sum(11)
    res[7]   = fma52lo(res[7], a[0], a[7]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[0], a[7]);     // Sum(7)
    res[8]   = fma52lo(res[8], a[1], a[7]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[1], a[7]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[2], a[7]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[2], a[7]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[3], a[7]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[3], a[7]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[4], a[7]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[4], a[7]);    // Sum(11)
    res[8]   = fma52lo(res[8], a[0], a[8]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[0], a[8]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[1], a[8]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[1], a[8]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[2], a[8]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[2], a[8]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[3], a[8]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[3], a[8]);    // Sum(11)
    res[9]   = fma52lo(res[9], a[0], a[9]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[0], a[9]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[1], a[9]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[1], a[9]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[2], a[9]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[2], a[9]);    // Sum(11)
    res[10]  = fma52lo(res[10], a[0], a[10]);   // Sum(10)
    res[11]  = fma52hi(res[11], a[0], a[10]);   // Sum(10)
    res[11]  = fma52lo(res[11], a[1], a[10]);   // Sum(11)
    res[12]  = fma52hi(res[12], a[1], a[10]);   // Sum(11)
    res[11]  = fma52lo(res[11], a[0], a[11]);   // Sum(11)
    res[12]  = fma52hi(res[12], a[0], a[11]);   // Sum(11)
    res[0]   = add64(res[0], res[0]);           // Double(0)
    res[1]   = add64(res[1], res[1]);           // Double(1)
    res[2]   = add64(res[2], res[2]);           // Double(2)
    res[3]   = add64(res[3], res[3]);           // Double(3)
    res[4]   = add64(res[4], res[4]);           // Double(4)
    res[5]   = add64(res[5], res[5]);           // Double(5)
    res[6]   = add64(res[6], res[6]);           // Double(6)
    res[7]   = add64(res[7], res[7]);           // Double(7)
    res[8]   = add64(res[8], res[8]);           // Double(8)
    res[9]   = add64(res[9], res[9]);           // Double(9)
    res[10]  = add64(res[10], res[10]);         // Double(10)
    res[11]  = add64(res[11], res[11]);         // Double(11)
    res[0]   = fma52lo(res[0], a[0], a[0]);     // Add sqr(0)
    res[1]   = fma52hi(res[1], a[0], a[0]);     // Add sqr(0)
    res[2]   = fma52lo(res[2], a[1], a[1]);     // Add sqr(2)
    res[3]   = fma52hi(res[3], a[1], a[1]);     // Add sqr(2)
    res[4]   = fma52lo(res[4], a[2], a[2]);     // Add sqr(4)
    res[5]   = fma52hi(res[5], a[2], a[2]);     // Add sqr(4)
    res[6]   = fma52lo(res[6], a[3], a[3]);     // Add sqr(6)
    res[7]   = fma52hi(res[7], a[3], a[3]);     // Add sqr(6)
    res[8]   = fma52lo(res[8], a[4], a[4]);     // Add sqr(8)
    res[9]   = fma52hi(res[9], a[4], a[4]);     // Add sqr(8)
    res[10]  = fma52lo(res[10], a[5], a[5]);    // Add sqr(10)
    res[11]  = fma52hi(res[11], a[5], a[5]);    // Add sqr(10)
    res[12]  = fma52lo(res[12], a[5], a[7]);    // Sum(12)
    res[13]  = fma52hi(res[13], a[5], a[7]);    // Sum(12)
    res[13]  = fma52lo(res[13], a[6], a[7]);    // Sum(13)
    res[14]  = fma52hi(res[14], a[6], a[7]);    // Sum(13)
    res[12]  = fma52lo(res[12], a[4], a[8]);    // Sum(12)
    res[13]  = fma52hi(res[13], a[4], a[8]);    // Sum(12)
    res[13]  = fma52lo(res[13], a[5], a[8]);    // Sum(13)
    res[14]  = fma52hi(res[14], a[5], a[8]);    // Sum(13)
    res[14]  = fma52lo(res[14], a[6], a[8]);    // Sum(14)
    res[15]  = fma52hi(res[15], a[6], a[8]);    // Sum(14)
    res[15]  = fma52lo(res[15], a[7], a[8]);    // Sum(15)
    res[16]  = fma52hi(res[16], a[7], a[8]);    // Sum(15)
    res[12]  = fma52lo(res[12], a[3], a[9]);    // Sum(12)
    res[13]  = fma52hi(res[13], a[3], a[9]);    // Sum(12)
    res[13]  = fma52lo(res[13], a[4], a[9]);    // Sum(13)
    res[14]  = fma52hi(res[14], a[4], a[9]);    // Sum(13)
    res[14]  = fma52lo(res[14], a[5], a[9]);    // Sum(14)
    res[15]  = fma52hi(res[15], a[5], a[9]);    // Sum(14)
    res[15]  = fma52lo(res[15], a[6], a[9]);    // Sum(15)
    res[16]  = fma52hi(res[16], a[6], a[9]);    // Sum(15)
    res[16]  = fma52lo(res[16], a[7], a[9]);    // Sum(16)
    res[17]  = fma52hi(res[17], a[7], a[9]);    // Sum(16)
    res[17]  = fma52lo(res[17], a[8], a[9]);    // Sum(17)
    res[18]  = fma52hi(res[18], a[8], a[9]);    // Sum(17)
    res[12]  = fma52lo(res[12], a[2], a[10]);   // Sum(12)
    res[13]  = fma52hi(res[13], a[2], a[10]);   // Sum(12)
    res[13]  = fma52lo(res[13], a[3], a[10]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[3], a[10]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[4], a[10]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[4], a[10]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[5], a[10]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[5], a[10]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[6], a[10]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[6], a[10]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[7], a[10]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[7], a[10]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[8], a[10]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[8], a[10]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[9], a[10]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[9], a[10]);   // Sum(19)
    res[12]  = fma52lo(res[12], a[1], a[11]);   // Sum(12)
    res[13]  = fma52hi(res[13], a[1], a[11]);   // Sum(12)
    res[13]  = fma52lo(res[13], a[2], a[11]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[2], a[11]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[3], a[11]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[3], a[11]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[4], a[11]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[4], a[11]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[5], a[11]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[5], a[11]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[6], a[11]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[6], a[11]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[7], a[11]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[7], a[11]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[8], a[11]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[8], a[11]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[9], a[11]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[9], a[11]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[10], a[11]);  // Sum(21)
    res[22]  = fma52hi(res[22], a[10], a[11]);  // Sum(21)
    res[12]  = fma52lo(res[12], a[0], a[12]);   // Sum(12)
    res[13]  = fma52hi(res[13], a[0], a[12]);   // Sum(12)
    res[13]  = fma52lo(res[13], a[1], a[12]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[1], a[12]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[2], a[12]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[2], a[12]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[3], a[12]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[3], a[12]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[4], a[12]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[4], a[12]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[5], a[12]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[5], a[12]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[6], a[12]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[6], a[12]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[7], a[12]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[7], a[12]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[8], a[12]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[8], a[12]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[9], a[12]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[9], a[12]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[10], a[12]);  // Sum(22)
    res[23]  = fma52hi(res[23], a[10], a[12]);  // Sum(22)
    res[23]  = fma52lo(res[23], a[11], a[12]);  // Sum(23)
    res[24]  = fma52hi(res[24], a[11], a[12]);  // Sum(23)
    res[13]  = fma52lo(res[13], a[0], a[13]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[0], a[13]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[1], a[13]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[1], a[13]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[2], a[13]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[2], a[13]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[3], a[13]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[3], a[13]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[4], a[13]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[4], a[13]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[5], a[13]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[5], a[13]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[6], a[13]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[6], a[13]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[7], a[13]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[7], a[13]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[8], a[13]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[8], a[13]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[9], a[13]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[9], a[13]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[10], a[13]);  // Sum(23)
    res[24]  = fma52hi(res[24], a[10], a[13]);  // Sum(23)
    res[14]  = fma52lo(res[14], a[0], a[14]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[0], a[14]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[1], a[14]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[1], a[14]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[2], a[14]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[2], a[14]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[3], a[14]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[3], a[14]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[4], a[14]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[4], a[14]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[5], a[14]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[5], a[14]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[6], a[14]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[6], a[14]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[7], a[14]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[7], a[14]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[8], a[14]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[8], a[14]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[9], a[14]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[9], a[14]);   // Sum(23)
    res[15]  = fma52lo(res[15], a[0], a[15]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[0], a[15]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[1], a[15]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[1], a[15]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[2], a[15]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[2], a[15]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[3], a[15]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[3], a[15]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[4], a[15]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[4], a[15]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[5], a[15]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[5], a[15]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[6], a[15]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[6], a[15]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[7], a[15]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[7], a[15]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[8], a[15]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[8], a[15]);   // Sum(23)
    res[16]  = fma52lo(res[16], a[0], a[16]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[0], a[16]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[1], a[16]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[1], a[16]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[2], a[16]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[2], a[16]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[3], a[16]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[3], a[16]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[4], a[16]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[4], a[16]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[5], a[16]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[5], a[16]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[6], a[16]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[6], a[16]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[7], a[16]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[7], a[16]);   // Sum(23)
    res[17]  = fma52lo(res[17], a[0], a[17]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[0], a[17]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[1], a[17]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[1], a[17]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[2], a[17]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[2], a[17]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[3], a[17]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[3], a[17]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[4], a[17]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[4], a[17]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[5], a[17]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[5], a[17]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[6], a[17]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[6], a[17]);   // Sum(23)
    res[18]  = fma52lo(res[18], a[0], a[18]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[0], a[18]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[1], a[18]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[1], a[18]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[2], a[18]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[2], a[18]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[3], a[18]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[3], a[18]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[4], a[18]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[4], a[18]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[5], a[18]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[5], a[18]);   // Sum(23)
    res[19]  = fma52lo(res[19], a[0], a[19]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[0], a[19]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[1], a[19]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[1], a[19]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[2], a[19]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[2], a[19]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[3], a[19]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[3], a[19]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[4], a[19]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[4], a[19]);   // Sum(23)
    res[20]  = fma52lo(res[20], a[0], a[20]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[0], a[20]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[1], a[20]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[1], a[20]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[2], a[20]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[2], a[20]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[3], a[20]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[3], a[20]);   // Sum(23)
    res[21]  = fma52lo(res[21], a[0], a[21]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[0], a[21]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[1], a[21]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[1], a[21]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[2], a[21]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[2], a[21]);   // Sum(23)
    res[22]  = fma52lo(res[22], a[0], a[22]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[0], a[22]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[1], a[22]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[1], a[22]);   // Sum(23)
    res[23]  = fma52lo(res[23], a[0], a[23]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[0], a[23]);   // Sum(23)
    res[12]  = add64(res[12], res[12]);         // Double(12)
    res[13]  = add64(res[13], res[13]);         // Double(13)
    res[14]  = add64(res[14], res[14]);         // Double(14)
    res[15]  = add64(res[15], res[15]);         // Double(15)
    res[16]  = add64(res[16], res[16]);         // Double(16)
    res[17]  = add64(res[17], res[17]);         // Double(17)
    res[18]  = add64(res[18], res[18]);         // Double(18)
    res[19]  = add64(res[19], res[19]);         // Double(19)
    res[20]  = add64(res[20], res[20]);         // Double(20)
    res[21]  = add64(res[21], res[21]);         // Double(21)
    res[22]  = add64(res[22], res[22]);         // Double(22)
    res[23]  = add64(res[23], res[23]);         // Double(23)
    res[12]  = fma52lo(res[12], a[6], a[6]);    // Add sqr(12)
    res[13]  = fma52hi(res[13], a[6], a[6]);    // Add sqr(12)
    res[14]  = fma52lo(res[14], a[7], a[7]);    // Add sqr(14)
    res[15]  = fma52hi(res[15], a[7], a[7]);    // Add sqr(14)
    res[16]  = fma52lo(res[16], a[8], a[8]);    // Add sqr(16)
    res[17]  = fma52hi(res[17], a[8], a[8]);    // Add sqr(16)
    res[18]  = fma52lo(res[18], a[9], a[9]);    // Add sqr(18)
    res[19]  = fma52hi(res[19], a[9], a[9]);    // Add sqr(18)
    res[20]  = fma52lo(res[20], a[10], a[10]);  // Add sqr(20)
    res[21]  = fma52hi(res[21], a[10], a[10]);  // Add sqr(20)
    res[22]  = fma52lo(res[22], a[11], a[11]);  // Add sqr(22)
    res[23]  = fma52hi(res[23], a[11], a[11]);  // Add sqr(22)
    res[24]  = fma52lo(res[24], a[11], a[13]);  // Sum(24)
    res[25]  = fma52hi(res[25], a[11], a[13]);  // Sum(24)
    res[25]  = fma52lo(res[25], a[12], a[13]);  // Sum(25)
    res[26]  = fma52hi(res[26], a[12], a[13]);  // Sum(25)
    res[24]  = fma52lo(res[24], a[10], a[14]);  // Sum(24)
    res[25]  = fma52hi(res[25], a[10], a[14]);  // Sum(24)
    res[25]  = fma52lo(res[25], a[11], a[14]);  // Sum(25)
    res[26]  = fma52hi(res[26], a[11], a[14]);  // Sum(25)
    res[26]  = fma52lo(res[26], a[12], a[14]);  // Sum(26)
    res[27]  = fma52hi(res[27], a[12], a[14]);  // Sum(26)
    res[27]  = fma52lo(res[27], a[13], a[14]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[13], a[14]);  // Sum(27)
    res[24]  = fma52lo(res[24], a[9], a[15]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[9], a[15]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[10], a[15]);  // Sum(25)
    res[26]  = fma52hi(res[26], a[10], a[15]);  // Sum(25)
    res[26]  = fma52lo(res[26], a[11], a[15]);  // Sum(26)
    res[27]  = fma52hi(res[27], a[11], a[15]);  // Sum(26)
    res[27]  = fma52lo(res[27], a[12], a[15]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[12], a[15]);  // Sum(27)
    res[28]  = fma52lo(res[28], a[13], a[15]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[13], a[15]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[14], a[15]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[14], a[15]);  // Sum(29)
    res[24]  = fma52lo(res[24], a[8], a[16]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[8], a[16]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[9], a[16]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[9], a[16]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[10], a[16]);  // Sum(26)
    res[27]  = fma52hi(res[27], a[10], a[16]);  // Sum(26)
    res[27]  = fma52lo(res[27], a[11], a[16]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[11], a[16]);  // Sum(27)
    res[28]  = fma52lo(res[28], a[12], a[16]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[12], a[16]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[13], a[16]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[13], a[16]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[14], a[16]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[14], a[16]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[15], a[16]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[15], a[16]);  // Sum(31)
    res[24]  = fma52lo(res[24], a[7], a[17]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[7], a[17]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[8], a[17]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[8], a[17]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[9], a[17]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[9], a[17]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[10], a[17]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[10], a[17]);  // Sum(27)
    res[28]  = fma52lo(res[28], a[11], a[17]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[11], a[17]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[12], a[17]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[12], a[17]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[13], a[17]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[13], a[17]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[14], a[17]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[14], a[17]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[15], a[17]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[15], a[17]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[16], a[17]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[16], a[17]);  // Sum(33)
    res[24]  = fma52lo(res[24], a[6], a[18]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[6], a[18]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[7], a[18]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[7], a[18]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[8], a[18]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[8], a[18]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[9], a[18]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[9], a[18]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[10], a[18]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[10], a[18]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[11], a[18]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[11], a[18]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[12], a[18]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[12], a[18]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[13], a[18]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[13], a[18]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[14], a[18]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[14], a[18]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[15], a[18]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[15], a[18]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[16], a[18]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[16], a[18]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[17], a[18]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[17], a[18]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[5], a[19]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[5], a[19]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[6], a[19]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[6], a[19]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[7], a[19]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[7], a[19]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[8], a[19]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[8], a[19]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[9], a[19]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[9], a[19]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[10], a[19]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[10], a[19]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[11], a[19]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[11], a[19]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[12], a[19]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[12], a[19]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[13], a[19]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[13], a[19]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[14], a[19]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[14], a[19]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[15], a[19]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[15], a[19]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[16], a[19]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[16], a[19]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[4], a[20]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[4], a[20]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[5], a[20]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[5], a[20]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[6], a[20]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[6], a[20]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[7], a[20]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[7], a[20]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[8], a[20]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[8], a[20]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[9], a[20]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[9], a[20]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[10], a[20]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[10], a[20]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[11], a[20]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[11], a[20]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[12], a[20]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[12], a[20]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[13], a[20]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[13], a[20]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[14], a[20]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[14], a[20]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[15], a[20]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[15], a[20]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[3], a[21]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[3], a[21]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[4], a[21]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[4], a[21]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[5], a[21]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[5], a[21]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[6], a[21]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[6], a[21]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[7], a[21]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[7], a[21]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[8], a[21]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[8], a[21]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[9], a[21]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[9], a[21]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[10], a[21]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[10], a[21]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[11], a[21]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[11], a[21]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[12], a[21]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[12], a[21]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[13], a[21]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[13], a[21]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[14], a[21]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[14], a[21]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[2], a[22]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[2], a[22]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[3], a[22]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[3], a[22]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[4], a[22]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[4], a[22]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[5], a[22]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[5], a[22]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[6], a[22]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[6], a[22]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[7], a[22]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[7], a[22]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[8], a[22]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[8], a[22]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[9], a[22]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[9], a[22]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[10], a[22]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[10], a[22]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[11], a[22]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[11], a[22]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[12], a[22]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[12], a[22]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[13], a[22]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[13], a[22]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[1], a[23]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[1], a[23]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[2], a[23]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[2], a[23]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[3], a[23]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[3], a[23]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[4], a[23]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[4], a[23]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[5], a[23]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[5], a[23]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[6], a[23]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[6], a[23]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[7], a[23]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[7], a[23]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[8], a[23]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[8], a[23]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[9], a[23]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[9], a[23]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[10], a[23]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[10], a[23]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[11], a[23]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[11], a[23]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[12], a[23]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[12], a[23]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[0], a[24]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[0], a[24]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[1], a[24]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[1], a[24]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[2], a[24]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[2], a[24]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[3], a[24]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[3], a[24]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[4], a[24]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[4], a[24]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[5], a[24]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[5], a[24]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[6], a[24]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[6], a[24]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[7], a[24]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[7], a[24]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[8], a[24]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[8], a[24]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[9], a[24]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[9], a[24]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[10], a[24]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[10], a[24]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[11], a[24]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[11], a[24]);  // Sum(35)
    res[25]  = fma52lo(res[25], a[0], a[25]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[0], a[25]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[1], a[25]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[1], a[25]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[2], a[25]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[2], a[25]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[3], a[25]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[3], a[25]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[4], a[25]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[4], a[25]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[5], a[25]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[5], a[25]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[6], a[25]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[6], a[25]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[7], a[25]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[7], a[25]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[8], a[25]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[8], a[25]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[9], a[25]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[9], a[25]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[10], a[25]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[10], a[25]);  // Sum(35)
    res[26]  = fma52lo(res[26], a[0], a[26]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[0], a[26]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[1], a[26]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[1], a[26]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[2], a[26]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[2], a[26]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[3], a[26]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[3], a[26]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[4], a[26]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[4], a[26]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[5], a[26]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[5], a[26]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[6], a[26]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[6], a[26]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[7], a[26]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[7], a[26]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[8], a[26]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[8], a[26]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[9], a[26]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[9], a[26]);   // Sum(35)
    res[27]  = fma52lo(res[27], a[0], a[27]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[0], a[27]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[1], a[27]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[1], a[27]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[2], a[27]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[2], a[27]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[3], a[27]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[3], a[27]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[4], a[27]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[4], a[27]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[5], a[27]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[5], a[27]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[6], a[27]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[6], a[27]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[7], a[27]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[7], a[27]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[8], a[27]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[8], a[27]);   // Sum(35)
    res[28]  = fma52lo(res[28], a[0], a[28]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[0], a[28]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[1], a[28]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[1], a[28]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[2], a[28]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[2], a[28]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[3], a[28]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[3], a[28]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[4], a[28]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[4], a[28]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[5], a[28]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[5], a[28]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[6], a[28]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[6], a[28]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[7], a[28]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[7], a[28]);   // Sum(35)
    res[29]  = fma52lo(res[29], a[0], a[29]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[0], a[29]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[1], a[29]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[1], a[29]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[2], a[29]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[2], a[29]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[3], a[29]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[3], a[29]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[4], a[29]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[4], a[29]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[5], a[29]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[5], a[29]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[6], a[29]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[6], a[29]);   // Sum(35)
    res[30]  = fma52lo(res[30], a[0], a[30]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[0], a[30]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[1], a[30]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[1], a[30]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[2], a[30]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[2], a[30]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[3], a[30]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[3], a[30]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[4], a[30]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[4], a[30]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[5], a[30]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[5], a[30]);   // Sum(35)
    res[31]  = fma52lo(res[31], a[0], a[31]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[0], a[31]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[1], a[31]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[1], a[31]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[2], a[31]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[2], a[31]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[3], a[31]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[3], a[31]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[4], a[31]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[4], a[31]);   // Sum(35)
    res[32]  = fma52lo(res[32], a[0], a[32]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[0], a[32]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[1], a[32]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[1], a[32]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[2], a[32]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[2], a[32]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[3], a[32]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[3], a[32]);   // Sum(35)
    res[33]  = fma52lo(res[33], a[0], a[33]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[0], a[33]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[1], a[33]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[1], a[33]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[2], a[33]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[2], a[33]);   // Sum(35)
    res[34]  = fma52lo(res[34], a[0], a[34]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[0], a[34]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[1], a[34]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[1], a[34]);   // Sum(35)
    res[35]  = fma52lo(res[35], a[0], a[35]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[0], a[35]);   // Sum(35)
    res[24]  = add64(res[24], res[24]);         // Double(24)
    res[25]  = add64(res[25], res[25]);         // Double(25)
    res[26]  = add64(res[26], res[26]);         // Double(26)
    res[27]  = add64(res[27], res[27]);         // Double(27)
    res[28]  = add64(res[28], res[28]);         // Double(28)
    res[29]  = add64(res[29], res[29]);         // Double(29)
    res[30]  = add64(res[30], res[30]);         // Double(30)
    res[31]  = add64(res[31], res[31]);         // Double(31)
    res[32]  = add64(res[32], res[32]);         // Double(32)
    res[33]  = add64(res[33], res[33]);         // Double(33)
    res[34]  = add64(res[34], res[34]);         // Double(34)
    res[35]  = add64(res[35], res[35]);         // Double(35)
    res[24]  = fma52lo(res[24], a[12], a[12]);  // Add sqr(24)
    res[25]  = fma52hi(res[25], a[12], a[12]);  // Add sqr(24)
    res[26]  = fma52lo(res[26], a[13], a[13]);  // Add sqr(26)
    res[27]  = fma52hi(res[27], a[13], a[13]);  // Add sqr(26)
    res[28]  = fma52lo(res[28], a[14], a[14]);  // Add sqr(28)
    res[29]  = fma52hi(res[29], a[14], a[14]);  // Add sqr(28)
    res[30]  = fma52lo(res[30], a[15], a[15]);  // Add sqr(30)
    res[31]  = fma52hi(res[31], a[15], a[15]);  // Add sqr(30)
    res[32]  = fma52lo(res[32], a[16], a[16]);  // Add sqr(32)
    res[33]  = fma52hi(res[33], a[16], a[16]);  // Add sqr(32)
    res[34]  = fma52lo(res[34], a[17], a[17]);  // Add sqr(34)
    res[35]  = fma52hi(res[35], a[17], a[17]);  // Add sqr(34)
    res[36]  = fma52lo(res[36], a[17], a[19]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[17], a[19]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[18], a[19]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[18], a[19]);  // Sum(37)
    res[36]  = fma52lo(res[36], a[16], a[20]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[16], a[20]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[17], a[20]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[17], a[20]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[18], a[20]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[18], a[20]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[19], a[20]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[19], a[20]);  // Sum(39)
    res[36]  = fma52lo(res[36], a[15], a[21]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[15], a[21]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[16], a[21]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[16], a[21]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[17], a[21]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[17], a[21]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[18], a[21]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[18], a[21]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[19], a[21]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[19], a[21]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[20], a[21]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[20], a[21]);  // Sum(41)
    res[36]  = fma52lo(res[36], a[14], a[22]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[14], a[22]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[15], a[22]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[15], a[22]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[16], a[22]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[16], a[22]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[17], a[22]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[17], a[22]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[18], a[22]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[18], a[22]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[19], a[22]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[19], a[22]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[20], a[22]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[20], a[22]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[21], a[22]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[21], a[22]);  // Sum(43)
    res[36]  = fma52lo(res[36], a[13], a[23]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[13], a[23]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[14], a[23]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[14], a[23]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[15], a[23]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[15], a[23]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[16], a[23]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[16], a[23]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[17], a[23]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[17], a[23]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[18], a[23]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[18], a[23]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[19], a[23]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[19], a[23]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[20], a[23]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[20], a[23]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[21], a[23]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[21], a[23]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[22], a[23]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[22], a[23]);  // Sum(45)
    res[36]  = fma52lo(res[36], a[12], a[24]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[12], a[24]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[13], a[24]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[13], a[24]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[14], a[24]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[14], a[24]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[15], a[24]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[15], a[24]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[16], a[24]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[16], a[24]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[17], a[24]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[17], a[24]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[18], a[24]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[18], a[24]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[19], a[24]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[19], a[24]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[20], a[24]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[20], a[24]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[21], a[24]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[21], a[24]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[22], a[24]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[22], a[24]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[23], a[24]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[23], a[24]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[11], a[25]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[11], a[25]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[12], a[25]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[12], a[25]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[13], a[25]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[13], a[25]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[14], a[25]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[14], a[25]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[15], a[25]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[15], a[25]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[16], a[25]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[16], a[25]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[17], a[25]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[17], a[25]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[18], a[25]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[18], a[25]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[19], a[25]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[19], a[25]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[20], a[25]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[20], a[25]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[21], a[25]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[21], a[25]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[22], a[25]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[22], a[25]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[10], a[26]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[10], a[26]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[11], a[26]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[11], a[26]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[12], a[26]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[12], a[26]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[13], a[26]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[13], a[26]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[14], a[26]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[14], a[26]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[15], a[26]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[15], a[26]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[16], a[26]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[16], a[26]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[17], a[26]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[17], a[26]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[18], a[26]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[18], a[26]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[19], a[26]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[19], a[26]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[20], a[26]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[20], a[26]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[21], a[26]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[21], a[26]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[9], a[27]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[9], a[27]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[10], a[27]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[10], a[27]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[11], a[27]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[11], a[27]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[12], a[27]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[12], a[27]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[13], a[27]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[13], a[27]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[14], a[27]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[14], a[27]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[15], a[27]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[15], a[27]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[16], a[27]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[16], a[27]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[17], a[27]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[17], a[27]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[18], a[27]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[18], a[27]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[19], a[27]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[19], a[27]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[20], a[27]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[20], a[27]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[8], a[28]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[8], a[28]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[9], a[28]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[9], a[28]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[10], a[28]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[10], a[28]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[11], a[28]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[11], a[28]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[12], a[28]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[12], a[28]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[13], a[28]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[13], a[28]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[14], a[28]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[14], a[28]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[15], a[28]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[15], a[28]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[16], a[28]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[16], a[28]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[17], a[28]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[17], a[28]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[18], a[28]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[18], a[28]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[19], a[28]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[19], a[28]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[7], a[29]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[7], a[29]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[8], a[29]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[8], a[29]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[9], a[29]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[9], a[29]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[10], a[29]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[10], a[29]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[11], a[29]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[11], a[29]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[12], a[29]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[12], a[29]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[13], a[29]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[13], a[29]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[14], a[29]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[14], a[29]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[15], a[29]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[15], a[29]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[16], a[29]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[16], a[29]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[17], a[29]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[17], a[29]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[18], a[29]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[18], a[29]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[6], a[30]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[6], a[30]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[7], a[30]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[7], a[30]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[8], a[30]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[8], a[30]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[9], a[30]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[9], a[30]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[10], a[30]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[10], a[30]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[11], a[30]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[11], a[30]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[12], a[30]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[12], a[30]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[13], a[30]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[13], a[30]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[14], a[30]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[14], a[30]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[15], a[30]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[15], a[30]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[16], a[30]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[16], a[30]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[17], a[30]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[17], a[30]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[5], a[31]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[5], a[31]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[6], a[31]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[6], a[31]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[7], a[31]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[7], a[31]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[8], a[31]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[8], a[31]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[9], a[31]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[9], a[31]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[10], a[31]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[10], a[31]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[11], a[31]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[11], a[31]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[12], a[31]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[12], a[31]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[13], a[31]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[13], a[31]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[14], a[31]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[14], a[31]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[15], a[31]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[15], a[31]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[16], a[31]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[16], a[31]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[4], a[32]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[4], a[32]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[5], a[32]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[5], a[32]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[6], a[32]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[6], a[32]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[7], a[32]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[7], a[32]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[8], a[32]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[8], a[32]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[9], a[32]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[9], a[32]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[10], a[32]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[10], a[32]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[11], a[32]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[11], a[32]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[12], a[32]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[12], a[32]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[13], a[32]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[13], a[32]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[14], a[32]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[14], a[32]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[15], a[32]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[15], a[32]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[3], a[33]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[3], a[33]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[4], a[33]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[4], a[33]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[5], a[33]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[5], a[33]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[6], a[33]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[6], a[33]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[7], a[33]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[7], a[33]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[8], a[33]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[8], a[33]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[9], a[33]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[9], a[33]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[10], a[33]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[10], a[33]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[11], a[33]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[11], a[33]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[12], a[33]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[12], a[33]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[13], a[33]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[13], a[33]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[14], a[33]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[14], a[33]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[2], a[34]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[2], a[34]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[3], a[34]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[3], a[34]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[4], a[34]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[4], a[34]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[5], a[34]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[5], a[34]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[6], a[34]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[6], a[34]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[7], a[34]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[7], a[34]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[8], a[34]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[8], a[34]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[9], a[34]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[9], a[34]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[10], a[34]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[10], a[34]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[11], a[34]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[11], a[34]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[12], a[34]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[12], a[34]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[13], a[34]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[13], a[34]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[1], a[35]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[1], a[35]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[2], a[35]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[2], a[35]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[3], a[35]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[3], a[35]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[4], a[35]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[4], a[35]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[5], a[35]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[5], a[35]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[6], a[35]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[6], a[35]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[7], a[35]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[7], a[35]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[8], a[35]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[8], a[35]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[9], a[35]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[9], a[35]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[10], a[35]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[10], a[35]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[11], a[35]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[11], a[35]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[12], a[35]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[12], a[35]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[0], a[36]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[0], a[36]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[1], a[36]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[1], a[36]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[2], a[36]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[2], a[36]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[3], a[36]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[3], a[36]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[4], a[36]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[4], a[36]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[5], a[36]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[5], a[36]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[6], a[36]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[6], a[36]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[7], a[36]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[7], a[36]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[8], a[36]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[8], a[36]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[9], a[36]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[9], a[36]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[10], a[36]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[10], a[36]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[11], a[36]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[11], a[36]);  // Sum(47)
    res[37]  = fma52lo(res[37], a[0], a[37]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[0], a[37]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[1], a[37]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[1], a[37]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[2], a[37]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[2], a[37]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[3], a[37]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[3], a[37]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[4], a[37]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[4], a[37]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[5], a[37]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[5], a[37]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[6], a[37]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[6], a[37]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[7], a[37]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[7], a[37]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[8], a[37]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[8], a[37]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[9], a[37]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[9], a[37]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[10], a[37]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[10], a[37]);  // Sum(47)
    res[38]  = fma52lo(res[38], a[0], a[38]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[0], a[38]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[1], a[38]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[1], a[38]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[2], a[38]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[2], a[38]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[3], a[38]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[3], a[38]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[4], a[38]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[4], a[38]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[5], a[38]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[5], a[38]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[6], a[38]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[6], a[38]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[7], a[38]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[7], a[38]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[8], a[38]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[8], a[38]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[9], a[38]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[9], a[38]);   // Sum(47)
    res[39]  = fma52lo(res[39], a[0], a[39]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[0], a[39]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[1], a[39]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[1], a[39]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[2], a[39]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[2], a[39]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[3], a[39]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[3], a[39]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[4], a[39]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[4], a[39]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[5], a[39]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[5], a[39]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[6], a[39]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[6], a[39]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[7], a[39]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[7], a[39]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[8], a[39]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[8], a[39]);   // Sum(47)
    res[40]  = fma52lo(res[40], a[0], a[40]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[0], a[40]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[1], a[40]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[1], a[40]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[2], a[40]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[2], a[40]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[3], a[40]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[3], a[40]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[4], a[40]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[4], a[40]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[5], a[40]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[5], a[40]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[6], a[40]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[6], a[40]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[7], a[40]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[7], a[40]);   // Sum(47)
    res[41]  = fma52lo(res[41], a[0], a[41]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[0], a[41]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[1], a[41]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[1], a[41]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[2], a[41]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[2], a[41]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[3], a[41]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[3], a[41]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[4], a[41]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[4], a[41]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[5], a[41]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[5], a[41]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[6], a[41]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[6], a[41]);   // Sum(47)
    res[42]  = fma52lo(res[42], a[0], a[42]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[0], a[42]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[1], a[42]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[1], a[42]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[2], a[42]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[2], a[42]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[3], a[42]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[3], a[42]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[4], a[42]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[4], a[42]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[5], a[42]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[5], a[42]);   // Sum(47)
    res[43]  = fma52lo(res[43], a[0], a[43]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[0], a[43]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[1], a[43]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[1], a[43]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[2], a[43]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[2], a[43]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[3], a[43]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[3], a[43]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[4], a[43]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[4], a[43]);   // Sum(47)
    res[44]  = fma52lo(res[44], a[0], a[44]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[0], a[44]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[1], a[44]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[1], a[44]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[2], a[44]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[2], a[44]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[3], a[44]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[3], a[44]);   // Sum(47)
    res[45]  = fma52lo(res[45], a[0], a[45]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[0], a[45]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[1], a[45]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[1], a[45]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[2], a[45]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[2], a[45]);   // Sum(47)
    res[46]  = fma52lo(res[46], a[0], a[46]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[0], a[46]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[1], a[46]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[1], a[46]);   // Sum(47)
    res[47]  = fma52lo(res[47], a[0], a[47]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[0], a[47]);   // Sum(47)
    res[36]  = add64(res[36], res[36]);         // Double(36)
    res[37]  = add64(res[37], res[37]);         // Double(37)
    res[38]  = add64(res[38], res[38]);         // Double(38)
    res[39]  = add64(res[39], res[39]);         // Double(39)
    res[40]  = add64(res[40], res[40]);         // Double(40)
    res[41]  = add64(res[41], res[41]);         // Double(41)
    res[42]  = add64(res[42], res[42]);         // Double(42)
    res[43]  = add64(res[43], res[43]);         // Double(43)
    res[44]  = add64(res[44], res[44]);         // Double(44)
    res[45]  = add64(res[45], res[45]);         // Double(45)
    res[46]  = add64(res[46], res[46]);         // Double(46)
    res[47]  = add64(res[47], res[47]);         // Double(47)
    res[36]  = fma52lo(res[36], a[18], a[18]);  // Add sqr(36)
    res[37]  = fma52hi(res[37], a[18], a[18]);  // Add sqr(36)
    res[38]  = fma52lo(res[38], a[19], a[19]);  // Add sqr(38)
    res[39]  = fma52hi(res[39], a[19], a[19]);  // Add sqr(38)
    res[40]  = fma52lo(res[40], a[20], a[20]);  // Add sqr(40)
    res[41]  = fma52hi(res[41], a[20], a[20]);  // Add sqr(40)
    res[42]  = fma52lo(res[42], a[21], a[21]);  // Add sqr(42)
    res[43]  = fma52hi(res[43], a[21], a[21]);  // Add sqr(42)
    res[44]  = fma52lo(res[44], a[22], a[22]);  // Add sqr(44)
    res[45]  = fma52hi(res[45], a[22], a[22]);  // Add sqr(44)
    res[46]  = fma52lo(res[46], a[23], a[23]);  // Add sqr(46)
    res[47]  = fma52hi(res[47], a[23], a[23]);  // Add sqr(46)
    res[48]  = fma52lo(res[48], a[23], a[25]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[23], a[25]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[24], a[25]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[24], a[25]);  // Sum(49)
    res[48]  = fma52lo(res[48], a[22], a[26]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[22], a[26]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[23], a[26]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[23], a[26]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[24], a[26]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[24], a[26]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[25], a[26]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[25], a[26]);  // Sum(51)
    res[48]  = fma52lo(res[48], a[21], a[27]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[21], a[27]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[22], a[27]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[22], a[27]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[23], a[27]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[23], a[27]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[24], a[27]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[24], a[27]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[25], a[27]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[25], a[27]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[26], a[27]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[26], a[27]);  // Sum(53)
    res[48]  = fma52lo(res[48], a[20], a[28]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[20], a[28]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[21], a[28]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[21], a[28]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[22], a[28]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[22], a[28]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[23], a[28]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[23], a[28]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[24], a[28]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[24], a[28]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[25], a[28]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[25], a[28]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[26], a[28]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[26], a[28]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[27], a[28]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[27], a[28]);  // Sum(55)
    res[48]  = fma52lo(res[48], a[19], a[29]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[19], a[29]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[20], a[29]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[20], a[29]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[21], a[29]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[21], a[29]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[22], a[29]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[22], a[29]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[23], a[29]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[23], a[29]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[24], a[29]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[24], a[29]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[25], a[29]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[25], a[29]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[26], a[29]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[26], a[29]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[27], a[29]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[27], a[29]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[28], a[29]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[28], a[29]);  // Sum(57)
    res[48]  = fma52lo(res[48], a[18], a[30]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[18], a[30]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[19], a[30]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[19], a[30]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[20], a[30]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[20], a[30]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[21], a[30]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[21], a[30]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[22], a[30]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[22], a[30]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[23], a[30]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[23], a[30]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[24], a[30]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[24], a[30]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[25], a[30]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[25], a[30]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[26], a[30]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[26], a[30]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[27], a[30]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[27], a[30]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[28], a[30]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[28], a[30]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[29], a[30]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[29], a[30]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[17], a[31]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[17], a[31]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[18], a[31]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[18], a[31]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[19], a[31]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[19], a[31]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[20], a[31]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[20], a[31]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[21], a[31]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[21], a[31]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[22], a[31]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[22], a[31]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[23], a[31]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[23], a[31]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[24], a[31]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[24], a[31]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[25], a[31]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[25], a[31]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[26], a[31]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[26], a[31]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[27], a[31]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[27], a[31]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[28], a[31]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[28], a[31]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[16], a[32]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[16], a[32]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[17], a[32]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[17], a[32]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[18], a[32]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[18], a[32]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[19], a[32]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[19], a[32]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[20], a[32]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[20], a[32]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[21], a[32]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[21], a[32]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[22], a[32]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[22], a[32]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[23], a[32]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[23], a[32]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[24], a[32]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[24], a[32]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[25], a[32]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[25], a[32]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[26], a[32]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[26], a[32]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[27], a[32]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[27], a[32]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[15], a[33]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[15], a[33]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[16], a[33]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[16], a[33]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[17], a[33]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[17], a[33]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[18], a[33]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[18], a[33]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[19], a[33]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[19], a[33]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[20], a[33]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[20], a[33]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[21], a[33]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[21], a[33]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[22], a[33]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[22], a[33]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[23], a[33]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[23], a[33]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[24], a[33]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[24], a[33]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[25], a[33]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[25], a[33]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[26], a[33]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[26], a[33]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[14], a[34]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[14], a[34]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[15], a[34]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[15], a[34]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[16], a[34]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[16], a[34]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[17], a[34]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[17], a[34]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[18], a[34]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[18], a[34]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[19], a[34]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[19], a[34]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[20], a[34]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[20], a[34]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[21], a[34]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[21], a[34]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[22], a[34]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[22], a[34]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[23], a[34]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[23], a[34]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[24], a[34]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[24], a[34]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[25], a[34]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[25], a[34]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[13], a[35]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[13], a[35]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[14], a[35]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[14], a[35]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[15], a[35]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[15], a[35]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[16], a[35]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[16], a[35]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[17], a[35]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[17], a[35]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[18], a[35]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[18], a[35]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[19], a[35]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[19], a[35]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[20], a[35]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[20], a[35]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[21], a[35]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[21], a[35]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[22], a[35]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[22], a[35]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[23], a[35]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[23], a[35]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[24], a[35]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[24], a[35]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[12], a[36]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[12], a[36]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[13], a[36]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[13], a[36]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[14], a[36]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[14], a[36]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[15], a[36]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[15], a[36]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[16], a[36]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[16], a[36]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[17], a[36]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[17], a[36]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[18], a[36]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[18], a[36]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[19], a[36]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[19], a[36]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[20], a[36]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[20], a[36]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[21], a[36]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[21], a[36]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[22], a[36]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[22], a[36]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[23], a[36]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[23], a[36]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[11], a[37]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[11], a[37]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[12], a[37]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[12], a[37]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[13], a[37]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[13], a[37]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[14], a[37]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[14], a[37]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[15], a[37]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[15], a[37]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[16], a[37]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[16], a[37]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[17], a[37]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[17], a[37]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[18], a[37]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[18], a[37]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[19], a[37]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[19], a[37]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[20], a[37]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[20], a[37]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[21], a[37]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[21], a[37]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[22], a[37]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[22], a[37]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[10], a[38]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[10], a[38]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[11], a[38]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[11], a[38]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[12], a[38]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[12], a[38]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[13], a[38]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[13], a[38]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[14], a[38]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[14], a[38]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[15], a[38]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[15], a[38]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[16], a[38]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[16], a[38]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[17], a[38]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[17], a[38]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[18], a[38]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[18], a[38]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[19], a[38]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[19], a[38]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[20], a[38]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[20], a[38]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[21], a[38]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[21], a[38]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[9], a[39]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[9], a[39]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[10], a[39]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[10], a[39]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[11], a[39]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[11], a[39]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[12], a[39]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[12], a[39]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[13], a[39]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[13], a[39]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[14], a[39]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[14], a[39]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[15], a[39]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[15], a[39]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[16], a[39]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[16], a[39]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[17], a[39]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[17], a[39]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[18], a[39]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[18], a[39]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[19], a[39]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[19], a[39]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[20], a[39]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[20], a[39]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[8], a[40]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[8], a[40]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[9], a[40]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[9], a[40]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[10], a[40]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[10], a[40]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[11], a[40]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[11], a[40]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[12], a[40]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[12], a[40]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[13], a[40]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[13], a[40]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[14], a[40]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[14], a[40]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[15], a[40]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[15], a[40]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[16], a[40]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[16], a[40]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[17], a[40]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[17], a[40]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[18], a[40]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[18], a[40]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[19], a[40]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[19], a[40]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[7], a[41]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[7], a[41]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[8], a[41]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[8], a[41]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[9], a[41]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[9], a[41]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[10], a[41]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[10], a[41]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[11], a[41]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[11], a[41]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[12], a[41]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[12], a[41]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[13], a[41]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[13], a[41]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[14], a[41]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[14], a[41]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[15], a[41]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[15], a[41]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[16], a[41]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[16], a[41]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[17], a[41]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[17], a[41]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[18], a[41]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[18], a[41]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[6], a[42]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[6], a[42]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[7], a[42]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[7], a[42]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[8], a[42]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[8], a[42]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[9], a[42]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[9], a[42]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[10], a[42]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[10], a[42]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[11], a[42]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[11], a[42]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[12], a[42]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[12], a[42]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[13], a[42]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[13], a[42]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[14], a[42]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[14], a[42]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[15], a[42]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[15], a[42]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[16], a[42]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[16], a[42]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[17], a[42]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[17], a[42]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[5], a[43]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[5], a[43]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[6], a[43]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[6], a[43]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[7], a[43]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[7], a[43]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[8], a[43]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[8], a[43]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[9], a[43]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[9], a[43]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[10], a[43]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[10], a[43]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[11], a[43]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[11], a[43]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[12], a[43]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[12], a[43]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[13], a[43]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[13], a[43]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[14], a[43]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[14], a[43]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[15], a[43]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[15], a[43]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[16], a[43]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[16], a[43]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[4], a[44]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[4], a[44]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[5], a[44]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[5], a[44]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[6], a[44]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[6], a[44]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[7], a[44]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[7], a[44]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[8], a[44]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[8], a[44]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[9], a[44]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[9], a[44]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[10], a[44]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[10], a[44]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[11], a[44]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[11], a[44]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[12], a[44]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[12], a[44]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[13], a[44]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[13], a[44]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[14], a[44]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[14], a[44]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[15], a[44]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[15], a[44]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[3], a[45]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[3], a[45]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[4], a[45]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[4], a[45]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[5], a[45]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[5], a[45]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[6], a[45]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[6], a[45]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[7], a[45]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[7], a[45]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[8], a[45]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[8], a[45]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[9], a[45]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[9], a[45]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[10], a[45]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[10], a[45]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[11], a[45]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[11], a[45]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[12], a[45]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[12], a[45]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[13], a[45]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[13], a[45]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[14], a[45]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[14], a[45]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[2], a[46]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[2], a[46]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[3], a[46]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[3], a[46]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[4], a[46]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[4], a[46]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[5], a[46]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[5], a[46]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[6], a[46]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[6], a[46]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[7], a[46]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[7], a[46]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[8], a[46]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[8], a[46]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[9], a[46]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[9], a[46]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[10], a[46]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[10], a[46]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[11], a[46]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[11], a[46]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[12], a[46]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[12], a[46]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[13], a[46]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[13], a[46]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[1], a[47]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[1], a[47]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[2], a[47]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[2], a[47]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[3], a[47]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[3], a[47]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[4], a[47]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[4], a[47]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[5], a[47]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[5], a[47]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[6], a[47]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[6], a[47]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[7], a[47]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[7], a[47]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[8], a[47]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[8], a[47]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[9], a[47]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[9], a[47]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[10], a[47]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[10], a[47]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[11], a[47]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[11], a[47]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[12], a[47]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[12], a[47]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[0], a[48]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[0], a[48]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[1], a[48]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[1], a[48]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[2], a[48]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[2], a[48]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[3], a[48]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[3], a[48]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[4], a[48]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[4], a[48]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[5], a[48]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[5], a[48]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[6], a[48]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[6], a[48]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[7], a[48]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[7], a[48]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[8], a[48]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[8], a[48]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[9], a[48]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[9], a[48]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[10], a[48]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[10], a[48]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[11], a[48]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[11], a[48]);  // Sum(59)
    res[49]  = fma52lo(res[49], a[0], a[49]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[0], a[49]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[1], a[49]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[1], a[49]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[2], a[49]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[2], a[49]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[3], a[49]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[3], a[49]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[4], a[49]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[4], a[49]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[5], a[49]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[5], a[49]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[6], a[49]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[6], a[49]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[7], a[49]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[7], a[49]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[8], a[49]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[8], a[49]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[9], a[49]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[9], a[49]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[10], a[49]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[10], a[49]);  // Sum(59)
    res[50]  = fma52lo(res[50], a[0], a[50]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[0], a[50]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[1], a[50]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[1], a[50]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[2], a[50]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[2], a[50]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[3], a[50]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[3], a[50]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[4], a[50]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[4], a[50]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[5], a[50]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[5], a[50]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[6], a[50]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[6], a[50]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[7], a[50]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[7], a[50]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[8], a[50]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[8], a[50]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[9], a[50]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[9], a[50]);   // Sum(59)
    res[51]  = fma52lo(res[51], a[0], a[51]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[0], a[51]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[1], a[51]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[1], a[51]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[2], a[51]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[2], a[51]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[3], a[51]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[3], a[51]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[4], a[51]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[4], a[51]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[5], a[51]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[5], a[51]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[6], a[51]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[6], a[51]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[7], a[51]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[7], a[51]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[8], a[51]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[8], a[51]);   // Sum(59)
    res[52]  = fma52lo(res[52], a[0], a[52]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[0], a[52]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[1], a[52]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[1], a[52]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[2], a[52]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[2], a[52]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[3], a[52]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[3], a[52]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[4], a[52]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[4], a[52]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[5], a[52]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[5], a[52]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[6], a[52]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[6], a[52]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[7], a[52]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[7], a[52]);   // Sum(59)
    res[53]  = fma52lo(res[53], a[0], a[53]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[0], a[53]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[1], a[53]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[1], a[53]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[2], a[53]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[2], a[53]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[3], a[53]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[3], a[53]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[4], a[53]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[4], a[53]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[5], a[53]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[5], a[53]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[6], a[53]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[6], a[53]);   // Sum(59)
    res[54]  = fma52lo(res[54], a[0], a[54]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[0], a[54]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[1], a[54]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[1], a[54]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[2], a[54]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[2], a[54]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[3], a[54]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[3], a[54]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[4], a[54]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[4], a[54]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[5], a[54]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[5], a[54]);   // Sum(59)
    res[55]  = fma52lo(res[55], a[0], a[55]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[0], a[55]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[1], a[55]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[1], a[55]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[2], a[55]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[2], a[55]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[3], a[55]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[3], a[55]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[4], a[55]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[4], a[55]);   // Sum(59)
    res[56]  = fma52lo(res[56], a[0], a[56]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[0], a[56]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[1], a[56]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[1], a[56]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[2], a[56]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[2], a[56]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[3], a[56]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[3], a[56]);   // Sum(59)
    res[57]  = fma52lo(res[57], a[0], a[57]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[0], a[57]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[1], a[57]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[1], a[57]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[2], a[57]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[2], a[57]);   // Sum(59)
    res[58]  = fma52lo(res[58], a[0], a[58]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[0], a[58]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[1], a[58]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[1], a[58]);   // Sum(59)
    res[59]  = fma52lo(res[59], a[0], a[59]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[0], a[59]);   // Sum(59)
    res[48]  = add64(res[48], res[48]);         // Double(48)
    res[49]  = add64(res[49], res[49]);         // Double(49)
    res[50]  = add64(res[50], res[50]);         // Double(50)
    res[51]  = add64(res[51], res[51]);         // Double(51)
    res[52]  = add64(res[52], res[52]);         // Double(52)
    res[53]  = add64(res[53], res[53]);         // Double(53)
    res[54]  = add64(res[54], res[54]);         // Double(54)
    res[55]  = add64(res[55], res[55]);         // Double(55)
    res[56]  = add64(res[56], res[56]);         // Double(56)
    res[57]  = add64(res[57], res[57]);         // Double(57)
    res[58]  = add64(res[58], res[58]);         // Double(58)
    res[59]  = add64(res[59], res[59]);         // Double(59)
    res[48]  = fma52lo(res[48], a[24], a[24]);  // Add sqr(48)
    res[49]  = fma52hi(res[49], a[24], a[24]);  // Add sqr(48)
    res[50]  = fma52lo(res[50], a[25], a[25]);  // Add sqr(50)
    res[51]  = fma52hi(res[51], a[25], a[25]);  // Add sqr(50)
    res[52]  = fma52lo(res[52], a[26], a[26]);  // Add sqr(52)
    res[53]  = fma52hi(res[53], a[26], a[26]);  // Add sqr(52)
    res[54]  = fma52lo(res[54], a[27], a[27]);  // Add sqr(54)
    res[55]  = fma52hi(res[55], a[27], a[27]);  // Add sqr(54)
    res[56]  = fma52lo(res[56], a[28], a[28]);  // Add sqr(56)
    res[57]  = fma52hi(res[57], a[28], a[28]);  // Add sqr(56)
    res[58]  = fma52lo(res[58], a[29], a[29]);  // Add sqr(58)
    res[59]  = fma52hi(res[59], a[29], a[29]);  // Add sqr(58)
    res[60]  = fma52lo(res[60], a[29], a[31]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[29], a[31]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[30], a[31]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[30], a[31]);  // Sum(61)
    res[60]  = fma52lo(res[60], a[28], a[32]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[28], a[32]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[29], a[32]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[29], a[32]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[30], a[32]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[30], a[32]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[31], a[32]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[31], a[32]);  // Sum(63)
    res[60]  = fma52lo(res[60], a[27], a[33]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[27], a[33]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[28], a[33]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[28], a[33]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[29], a[33]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[29], a[33]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[30], a[33]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[30], a[33]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[31], a[33]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[31], a[33]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[32], a[33]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[32], a[33]);  // Sum(65)
    res[60]  = fma52lo(res[60], a[26], a[34]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[26], a[34]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[27], a[34]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[27], a[34]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[28], a[34]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[28], a[34]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[29], a[34]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[29], a[34]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[30], a[34]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[30], a[34]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[31], a[34]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[31], a[34]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[32], a[34]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[32], a[34]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[33], a[34]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[33], a[34]);  // Sum(67)
    res[60]  = fma52lo(res[60], a[25], a[35]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[25], a[35]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[26], a[35]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[26], a[35]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[27], a[35]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[27], a[35]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[28], a[35]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[28], a[35]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[29], a[35]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[29], a[35]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[30], a[35]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[30], a[35]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[31], a[35]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[31], a[35]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[32], a[35]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[32], a[35]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[33], a[35]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[33], a[35]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[34], a[35]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[34], a[35]);  // Sum(69)
    res[60]  = fma52lo(res[60], a[24], a[36]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[24], a[36]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[25], a[36]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[25], a[36]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[26], a[36]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[26], a[36]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[27], a[36]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[27], a[36]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[28], a[36]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[28], a[36]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[29], a[36]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[29], a[36]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[30], a[36]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[30], a[36]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[31], a[36]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[31], a[36]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[32], a[36]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[32], a[36]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[33], a[36]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[33], a[36]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[34], a[36]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[34], a[36]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[35], a[36]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[35], a[36]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[23], a[37]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[23], a[37]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[24], a[37]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[24], a[37]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[25], a[37]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[25], a[37]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[26], a[37]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[26], a[37]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[27], a[37]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[27], a[37]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[28], a[37]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[28], a[37]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[29], a[37]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[29], a[37]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[30], a[37]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[30], a[37]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[31], a[37]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[31], a[37]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[32], a[37]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[32], a[37]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[33], a[37]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[33], a[37]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[34], a[37]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[34], a[37]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[22], a[38]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[22], a[38]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[23], a[38]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[23], a[38]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[24], a[38]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[24], a[38]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[25], a[38]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[25], a[38]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[26], a[38]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[26], a[38]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[27], a[38]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[27], a[38]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[28], a[38]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[28], a[38]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[29], a[38]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[29], a[38]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[30], a[38]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[30], a[38]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[31], a[38]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[31], a[38]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[32], a[38]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[32], a[38]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[33], a[38]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[33], a[38]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[21], a[39]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[21], a[39]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[22], a[39]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[22], a[39]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[23], a[39]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[23], a[39]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[24], a[39]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[24], a[39]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[25], a[39]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[25], a[39]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[26], a[39]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[26], a[39]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[27], a[39]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[27], a[39]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[28], a[39]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[28], a[39]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[29], a[39]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[29], a[39]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[30], a[39]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[30], a[39]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[31], a[39]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[31], a[39]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[32], a[39]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[32], a[39]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[20], a[40]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[20], a[40]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[21], a[40]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[21], a[40]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[22], a[40]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[22], a[40]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[23], a[40]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[23], a[40]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[24], a[40]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[24], a[40]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[25], a[40]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[25], a[40]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[26], a[40]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[26], a[40]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[27], a[40]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[27], a[40]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[28], a[40]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[28], a[40]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[29], a[40]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[29], a[40]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[30], a[40]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[30], a[40]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[31], a[40]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[31], a[40]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[19], a[41]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[19], a[41]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[20], a[41]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[20], a[41]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[21], a[41]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[21], a[41]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[22], a[41]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[22], a[41]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[23], a[41]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[23], a[41]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[24], a[41]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[24], a[41]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[25], a[41]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[25], a[41]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[26], a[41]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[26], a[41]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[27], a[41]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[27], a[41]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[28], a[41]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[28], a[41]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[29], a[41]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[29], a[41]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[30], a[41]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[30], a[41]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[18], a[42]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[18], a[42]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[19], a[42]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[19], a[42]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[20], a[42]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[20], a[42]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[21], a[42]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[21], a[42]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[22], a[42]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[22], a[42]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[23], a[42]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[23], a[42]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[24], a[42]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[24], a[42]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[25], a[42]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[25], a[42]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[26], a[42]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[26], a[42]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[27], a[42]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[27], a[42]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[28], a[42]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[28], a[42]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[29], a[42]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[29], a[42]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[17], a[43]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[17], a[43]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[18], a[43]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[18], a[43]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[19], a[43]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[19], a[43]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[20], a[43]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[20], a[43]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[21], a[43]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[21], a[43]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[22], a[43]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[22], a[43]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[23], a[43]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[23], a[43]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[24], a[43]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[24], a[43]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[25], a[43]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[25], a[43]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[26], a[43]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[26], a[43]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[27], a[43]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[27], a[43]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[28], a[43]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[28], a[43]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[16], a[44]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[16], a[44]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[17], a[44]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[17], a[44]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[18], a[44]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[18], a[44]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[19], a[44]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[19], a[44]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[20], a[44]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[20], a[44]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[21], a[44]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[21], a[44]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[22], a[44]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[22], a[44]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[23], a[44]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[23], a[44]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[24], a[44]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[24], a[44]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[25], a[44]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[25], a[44]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[26], a[44]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[26], a[44]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[27], a[44]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[27], a[44]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[15], a[45]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[15], a[45]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[16], a[45]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[16], a[45]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[17], a[45]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[17], a[45]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[18], a[45]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[18], a[45]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[19], a[45]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[19], a[45]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[20], a[45]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[20], a[45]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[21], a[45]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[21], a[45]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[22], a[45]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[22], a[45]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[23], a[45]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[23], a[45]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[24], a[45]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[24], a[45]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[25], a[45]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[25], a[45]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[26], a[45]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[26], a[45]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[14], a[46]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[14], a[46]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[15], a[46]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[15], a[46]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[16], a[46]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[16], a[46]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[17], a[46]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[17], a[46]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[18], a[46]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[18], a[46]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[19], a[46]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[19], a[46]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[20], a[46]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[20], a[46]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[21], a[46]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[21], a[46]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[22], a[46]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[22], a[46]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[23], a[46]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[23], a[46]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[24], a[46]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[24], a[46]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[25], a[46]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[25], a[46]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[13], a[47]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[13], a[47]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[14], a[47]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[14], a[47]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[15], a[47]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[15], a[47]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[16], a[47]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[16], a[47]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[17], a[47]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[17], a[47]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[18], a[47]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[18], a[47]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[19], a[47]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[19], a[47]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[20], a[47]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[20], a[47]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[21], a[47]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[21], a[47]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[22], a[47]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[22], a[47]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[23], a[47]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[23], a[47]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[24], a[47]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[24], a[47]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[12], a[48]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[12], a[48]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[13], a[48]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[13], a[48]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[14], a[48]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[14], a[48]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[15], a[48]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[15], a[48]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[16], a[48]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[16], a[48]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[17], a[48]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[17], a[48]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[18], a[48]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[18], a[48]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[19], a[48]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[19], a[48]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[20], a[48]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[20], a[48]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[21], a[48]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[21], a[48]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[22], a[48]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[22], a[48]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[23], a[48]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[23], a[48]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[11], a[49]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[11], a[49]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[12], a[49]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[12], a[49]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[13], a[49]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[13], a[49]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[14], a[49]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[14], a[49]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[15], a[49]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[15], a[49]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[16], a[49]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[16], a[49]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[17], a[49]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[17], a[49]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[18], a[49]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[18], a[49]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[19], a[49]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[19], a[49]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[20], a[49]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[20], a[49]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[21], a[49]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[21], a[49]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[22], a[49]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[22], a[49]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[10], a[50]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[10], a[50]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[11], a[50]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[11], a[50]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[12], a[50]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[12], a[50]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[13], a[50]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[13], a[50]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[14], a[50]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[14], a[50]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[15], a[50]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[15], a[50]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[16], a[50]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[16], a[50]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[17], a[50]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[17], a[50]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[18], a[50]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[18], a[50]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[19], a[50]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[19], a[50]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[20], a[50]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[20], a[50]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[21], a[50]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[21], a[50]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[9], a[51]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[9], a[51]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[10], a[51]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[10], a[51]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[11], a[51]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[11], a[51]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[12], a[51]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[12], a[51]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[13], a[51]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[13], a[51]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[14], a[51]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[14], a[51]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[15], a[51]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[15], a[51]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[16], a[51]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[16], a[51]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[17], a[51]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[17], a[51]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[18], a[51]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[18], a[51]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[19], a[51]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[19], a[51]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[20], a[51]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[20], a[51]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[8], a[52]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[8], a[52]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[9], a[52]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[9], a[52]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[10], a[52]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[10], a[52]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[11], a[52]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[11], a[52]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[12], a[52]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[12], a[52]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[13], a[52]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[13], a[52]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[14], a[52]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[14], a[52]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[15], a[52]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[15], a[52]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[16], a[52]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[16], a[52]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[17], a[52]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[17], a[52]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[18], a[52]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[18], a[52]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[19], a[52]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[19], a[52]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[7], a[53]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[7], a[53]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[8], a[53]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[8], a[53]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[9], a[53]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[9], a[53]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[10], a[53]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[10], a[53]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[11], a[53]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[11], a[53]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[12], a[53]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[12], a[53]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[13], a[53]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[13], a[53]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[14], a[53]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[14], a[53]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[15], a[53]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[15], a[53]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[16], a[53]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[16], a[53]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[17], a[53]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[17], a[53]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[18], a[53]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[18], a[53]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[6], a[54]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[6], a[54]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[7], a[54]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[7], a[54]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[8], a[54]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[8], a[54]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[9], a[54]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[9], a[54]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[10], a[54]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[10], a[54]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[11], a[54]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[11], a[54]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[12], a[54]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[12], a[54]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[13], a[54]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[13], a[54]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[14], a[54]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[14], a[54]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[15], a[54]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[15], a[54]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[16], a[54]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[16], a[54]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[17], a[54]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[17], a[54]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[5], a[55]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[5], a[55]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[6], a[55]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[6], a[55]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[7], a[55]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[7], a[55]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[8], a[55]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[8], a[55]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[9], a[55]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[9], a[55]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[10], a[55]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[10], a[55]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[11], a[55]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[11], a[55]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[12], a[55]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[12], a[55]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[13], a[55]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[13], a[55]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[14], a[55]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[14], a[55]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[15], a[55]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[15], a[55]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[16], a[55]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[16], a[55]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[4], a[56]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[4], a[56]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[5], a[56]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[5], a[56]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[6], a[56]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[6], a[56]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[7], a[56]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[7], a[56]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[8], a[56]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[8], a[56]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[9], a[56]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[9], a[56]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[10], a[56]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[10], a[56]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[11], a[56]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[11], a[56]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[12], a[56]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[12], a[56]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[13], a[56]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[13], a[56]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[14], a[56]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[14], a[56]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[15], a[56]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[15], a[56]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[3], a[57]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[3], a[57]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[4], a[57]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[4], a[57]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[5], a[57]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[5], a[57]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[6], a[57]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[6], a[57]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[7], a[57]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[7], a[57]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[8], a[57]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[8], a[57]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[9], a[57]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[9], a[57]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[10], a[57]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[10], a[57]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[11], a[57]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[11], a[57]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[12], a[57]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[12], a[57]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[13], a[57]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[13], a[57]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[14], a[57]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[14], a[57]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[2], a[58]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[2], a[58]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[3], a[58]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[3], a[58]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[4], a[58]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[4], a[58]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[5], a[58]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[5], a[58]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[6], a[58]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[6], a[58]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[7], a[58]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[7], a[58]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[8], a[58]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[8], a[58]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[9], a[58]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[9], a[58]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[10], a[58]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[10], a[58]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[11], a[58]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[11], a[58]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[12], a[58]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[12], a[58]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[13], a[58]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[13], a[58]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[1], a[59]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[1], a[59]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[2], a[59]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[2], a[59]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[3], a[59]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[3], a[59]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[4], a[59]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[4], a[59]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[5], a[59]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[5], a[59]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[6], a[59]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[6], a[59]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[7], a[59]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[7], a[59]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[8], a[59]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[8], a[59]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[9], a[59]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[9], a[59]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[10], a[59]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[10], a[59]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[11], a[59]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[11], a[59]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[12], a[59]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[12], a[59]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[0], a[60]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[0], a[60]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[1], a[60]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[1], a[60]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[2], a[60]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[2], a[60]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[3], a[60]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[3], a[60]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[4], a[60]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[4], a[60]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[5], a[60]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[5], a[60]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[6], a[60]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[6], a[60]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[7], a[60]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[7], a[60]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[8], a[60]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[8], a[60]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[9], a[60]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[9], a[60]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[10], a[60]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[10], a[60]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[11], a[60]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[11], a[60]);  // Sum(71)
    res[61]  = fma52lo(res[61], a[0], a[61]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[0], a[61]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[1], a[61]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[1], a[61]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[2], a[61]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[2], a[61]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[3], a[61]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[3], a[61]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[4], a[61]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[4], a[61]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[5], a[61]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[5], a[61]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[6], a[61]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[6], a[61]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[7], a[61]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[7], a[61]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[8], a[61]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[8], a[61]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[9], a[61]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[9], a[61]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[10], a[61]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[10], a[61]);  // Sum(71)
    res[62]  = fma52lo(res[62], a[0], a[62]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[0], a[62]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[1], a[62]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[1], a[62]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[2], a[62]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[2], a[62]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[3], a[62]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[3], a[62]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[4], a[62]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[4], a[62]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[5], a[62]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[5], a[62]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[6], a[62]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[6], a[62]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[7], a[62]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[7], a[62]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[8], a[62]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[8], a[62]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[9], a[62]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[9], a[62]);   // Sum(71)
    res[63]  = fma52lo(res[63], a[0], a[63]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[0], a[63]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[1], a[63]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[1], a[63]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[2], a[63]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[2], a[63]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[3], a[63]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[3], a[63]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[4], a[63]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[4], a[63]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[5], a[63]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[5], a[63]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[6], a[63]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[6], a[63]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[7], a[63]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[7], a[63]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[8], a[63]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[8], a[63]);   // Sum(71)
    res[64]  = fma52lo(res[64], a[0], a[64]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[0], a[64]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[1], a[64]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[1], a[64]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[2], a[64]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[2], a[64]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[3], a[64]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[3], a[64]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[4], a[64]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[4], a[64]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[5], a[64]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[5], a[64]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[6], a[64]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[6], a[64]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[7], a[64]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[7], a[64]);   // Sum(71)
    res[65]  = fma52lo(res[65], a[0], a[65]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[0], a[65]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[1], a[65]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[1], a[65]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[2], a[65]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[2], a[65]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[3], a[65]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[3], a[65]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[4], a[65]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[4], a[65]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[5], a[65]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[5], a[65]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[6], a[65]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[6], a[65]);   // Sum(71)
    res[66]  = fma52lo(res[66], a[0], a[66]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[0], a[66]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[1], a[66]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[1], a[66]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[2], a[66]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[2], a[66]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[3], a[66]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[3], a[66]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[4], a[66]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[4], a[66]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[5], a[66]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[5], a[66]);   // Sum(71)
    res[67]  = fma52lo(res[67], a[0], a[67]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[0], a[67]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[1], a[67]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[1], a[67]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[2], a[67]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[2], a[67]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[3], a[67]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[3], a[67]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[4], a[67]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[4], a[67]);   // Sum(71)
    res[68]  = fma52lo(res[68], a[0], a[68]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[0], a[68]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[1], a[68]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[1], a[68]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[2], a[68]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[2], a[68]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[3], a[68]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[3], a[68]);   // Sum(71)
    res[69]  = fma52lo(res[69], a[0], a[69]);   // Sum(69)
    res[70]  = fma52hi(res[70], a[0], a[69]);   // Sum(69)
    res[70]  = fma52lo(res[70], a[1], a[69]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[1], a[69]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[2], a[69]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[2], a[69]);   // Sum(71)
    res[70]  = fma52lo(res[70], a[0], a[70]);   // Sum(70)
    res[71]  = fma52hi(res[71], a[0], a[70]);   // Sum(70)
    res[71]  = fma52lo(res[71], a[1], a[70]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[1], a[70]);   // Sum(71)
    res[71]  = fma52lo(res[71], a[0], a[71]);   // Sum(71)
    res[72]  = fma52hi(res[72], a[0], a[71]);   // Sum(71)
    res[60]  = add64(res[60], res[60]);         // Double(60)
    res[61]  = add64(res[61], res[61]);         // Double(61)
    res[62]  = add64(res[62], res[62]);         // Double(62)
    res[63]  = add64(res[63], res[63]);         // Double(63)
    res[64]  = add64(res[64], res[64]);         // Double(64)
    res[65]  = add64(res[65], res[65]);         // Double(65)
    res[66]  = add64(res[66], res[66]);         // Double(66)
    res[67]  = add64(res[67], res[67]);         // Double(67)
    res[68]  = add64(res[68], res[68]);         // Double(68)
    res[69]  = add64(res[69], res[69]);         // Double(69)
    res[70]  = add64(res[70], res[70]);         // Double(70)
    res[71]  = add64(res[71], res[71]);         // Double(71)
    res[60]  = fma52lo(res[60], a[30], a[30]);  // Add sqr(60)
    res[61]  = fma52hi(res[61], a[30], a[30]);  // Add sqr(60)
    res[62]  = fma52lo(res[62], a[31], a[31]);  // Add sqr(62)
    res[63]  = fma52hi(res[63], a[31], a[31]);  // Add sqr(62)
    res[64]  = fma52lo(res[64], a[32], a[32]);  // Add sqr(64)
    res[65]  = fma52hi(res[65], a[32], a[32]);  // Add sqr(64)
    res[66]  = fma52lo(res[66], a[33], a[33]);  // Add sqr(66)
    res[67]  = fma52hi(res[67], a[33], a[33]);  // Add sqr(66)
    res[68]  = fma52lo(res[68], a[34], a[34]);  // Add sqr(68)
    res[69]  = fma52hi(res[69], a[34], a[34]);  // Add sqr(68)
    res[70]  = fma52lo(res[70], a[35], a[35]);  // Add sqr(70)
    res[71]  = fma52hi(res[71], a[35], a[35]);  // Add sqr(70)
    res[72]  = fma52lo(res[72], a[35], a[37]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[35], a[37]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[36], a[37]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[36], a[37]);  // Sum(73)
    res[72]  = fma52lo(res[72], a[34], a[38]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[34], a[38]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[35], a[38]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[35], a[38]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[36], a[38]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[36], a[38]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[37], a[38]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[37], a[38]);  // Sum(75)
    res[72]  = fma52lo(res[72], a[33], a[39]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[33], a[39]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[34], a[39]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[34], a[39]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[35], a[39]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[35], a[39]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[36], a[39]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[36], a[39]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[37], a[39]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[37], a[39]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[38], a[39]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[38], a[39]);  // Sum(77)
    res[72]  = fma52lo(res[72], a[32], a[40]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[32], a[40]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[33], a[40]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[33], a[40]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[34], a[40]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[34], a[40]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[35], a[40]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[35], a[40]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[36], a[40]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[36], a[40]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[37], a[40]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[37], a[40]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[38], a[40]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[38], a[40]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[39], a[40]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[39], a[40]);  // Sum(79)
    res[72]  = fma52lo(res[72], a[31], a[41]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[31], a[41]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[32], a[41]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[32], a[41]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[33], a[41]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[33], a[41]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[34], a[41]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[34], a[41]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[35], a[41]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[35], a[41]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[36], a[41]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[36], a[41]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[37], a[41]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[37], a[41]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[38], a[41]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[38], a[41]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[39], a[41]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[39], a[41]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[40], a[41]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[40], a[41]);  // Sum(81)
    res[72]  = fma52lo(res[72], a[30], a[42]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[30], a[42]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[31], a[42]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[31], a[42]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[32], a[42]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[32], a[42]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[33], a[42]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[33], a[42]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[34], a[42]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[34], a[42]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[35], a[42]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[35], a[42]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[36], a[42]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[36], a[42]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[37], a[42]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[37], a[42]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[38], a[42]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[38], a[42]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[39], a[42]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[39], a[42]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[40], a[42]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[40], a[42]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[41], a[42]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[41], a[42]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[29], a[43]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[29], a[43]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[30], a[43]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[30], a[43]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[31], a[43]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[31], a[43]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[32], a[43]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[32], a[43]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[33], a[43]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[33], a[43]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[34], a[43]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[34], a[43]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[35], a[43]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[35], a[43]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[36], a[43]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[36], a[43]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[37], a[43]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[37], a[43]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[38], a[43]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[38], a[43]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[39], a[43]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[39], a[43]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[40], a[43]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[40], a[43]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[28], a[44]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[28], a[44]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[29], a[44]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[29], a[44]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[30], a[44]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[30], a[44]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[31], a[44]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[31], a[44]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[32], a[44]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[32], a[44]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[33], a[44]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[33], a[44]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[34], a[44]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[34], a[44]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[35], a[44]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[35], a[44]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[36], a[44]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[36], a[44]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[37], a[44]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[37], a[44]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[38], a[44]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[38], a[44]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[39], a[44]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[39], a[44]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[27], a[45]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[27], a[45]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[28], a[45]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[28], a[45]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[29], a[45]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[29], a[45]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[30], a[45]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[30], a[45]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[31], a[45]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[31], a[45]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[32], a[45]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[32], a[45]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[33], a[45]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[33], a[45]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[34], a[45]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[34], a[45]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[35], a[45]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[35], a[45]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[36], a[45]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[36], a[45]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[37], a[45]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[37], a[45]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[38], a[45]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[38], a[45]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[26], a[46]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[26], a[46]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[27], a[46]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[27], a[46]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[28], a[46]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[28], a[46]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[29], a[46]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[29], a[46]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[30], a[46]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[30], a[46]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[31], a[46]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[31], a[46]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[32], a[46]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[32], a[46]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[33], a[46]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[33], a[46]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[34], a[46]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[34], a[46]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[35], a[46]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[35], a[46]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[36], a[46]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[36], a[46]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[37], a[46]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[37], a[46]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[25], a[47]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[25], a[47]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[26], a[47]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[26], a[47]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[27], a[47]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[27], a[47]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[28], a[47]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[28], a[47]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[29], a[47]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[29], a[47]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[30], a[47]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[30], a[47]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[31], a[47]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[31], a[47]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[32], a[47]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[32], a[47]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[33], a[47]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[33], a[47]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[34], a[47]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[34], a[47]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[35], a[47]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[35], a[47]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[36], a[47]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[36], a[47]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[24], a[48]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[24], a[48]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[25], a[48]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[25], a[48]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[26], a[48]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[26], a[48]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[27], a[48]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[27], a[48]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[28], a[48]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[28], a[48]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[29], a[48]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[29], a[48]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[30], a[48]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[30], a[48]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[31], a[48]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[31], a[48]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[32], a[48]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[32], a[48]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[33], a[48]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[33], a[48]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[34], a[48]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[34], a[48]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[35], a[48]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[35], a[48]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[23], a[49]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[23], a[49]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[24], a[49]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[24], a[49]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[25], a[49]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[25], a[49]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[26], a[49]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[26], a[49]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[27], a[49]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[27], a[49]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[28], a[49]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[28], a[49]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[29], a[49]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[29], a[49]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[30], a[49]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[30], a[49]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[31], a[49]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[31], a[49]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[32], a[49]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[32], a[49]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[33], a[49]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[33], a[49]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[34], a[49]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[34], a[49]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[22], a[50]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[22], a[50]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[23], a[50]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[23], a[50]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[24], a[50]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[24], a[50]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[25], a[50]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[25], a[50]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[26], a[50]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[26], a[50]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[27], a[50]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[27], a[50]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[28], a[50]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[28], a[50]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[29], a[50]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[29], a[50]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[30], a[50]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[30], a[50]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[31], a[50]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[31], a[50]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[32], a[50]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[32], a[50]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[33], a[50]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[33], a[50]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[21], a[51]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[21], a[51]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[22], a[51]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[22], a[51]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[23], a[51]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[23], a[51]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[24], a[51]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[24], a[51]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[25], a[51]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[25], a[51]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[26], a[51]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[26], a[51]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[27], a[51]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[27], a[51]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[28], a[51]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[28], a[51]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[29], a[51]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[29], a[51]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[30], a[51]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[30], a[51]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[31], a[51]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[31], a[51]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[32], a[51]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[32], a[51]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[20], a[52]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[20], a[52]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[21], a[52]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[21], a[52]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[22], a[52]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[22], a[52]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[23], a[52]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[23], a[52]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[24], a[52]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[24], a[52]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[25], a[52]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[25], a[52]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[26], a[52]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[26], a[52]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[27], a[52]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[27], a[52]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[28], a[52]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[28], a[52]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[29], a[52]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[29], a[52]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[30], a[52]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[30], a[52]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[31], a[52]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[31], a[52]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[19], a[53]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[19], a[53]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[20], a[53]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[20], a[53]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[21], a[53]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[21], a[53]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[22], a[53]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[22], a[53]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[23], a[53]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[23], a[53]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[24], a[53]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[24], a[53]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[25], a[53]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[25], a[53]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[26], a[53]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[26], a[53]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[27], a[53]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[27], a[53]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[28], a[53]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[28], a[53]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[29], a[53]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[29], a[53]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[30], a[53]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[30], a[53]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[18], a[54]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[18], a[54]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[19], a[54]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[19], a[54]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[20], a[54]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[20], a[54]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[21], a[54]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[21], a[54]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[22], a[54]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[22], a[54]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[23], a[54]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[23], a[54]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[24], a[54]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[24], a[54]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[25], a[54]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[25], a[54]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[26], a[54]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[26], a[54]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[27], a[54]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[27], a[54]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[28], a[54]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[28], a[54]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[29], a[54]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[29], a[54]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[17], a[55]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[17], a[55]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[18], a[55]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[18], a[55]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[19], a[55]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[19], a[55]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[20], a[55]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[20], a[55]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[21], a[55]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[21], a[55]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[22], a[55]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[22], a[55]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[23], a[55]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[23], a[55]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[24], a[55]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[24], a[55]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[25], a[55]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[25], a[55]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[26], a[55]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[26], a[55]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[27], a[55]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[27], a[55]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[28], a[55]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[28], a[55]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[16], a[56]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[16], a[56]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[17], a[56]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[17], a[56]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[18], a[56]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[18], a[56]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[19], a[56]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[19], a[56]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[20], a[56]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[20], a[56]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[21], a[56]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[21], a[56]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[22], a[56]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[22], a[56]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[23], a[56]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[23], a[56]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[24], a[56]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[24], a[56]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[25], a[56]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[25], a[56]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[26], a[56]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[26], a[56]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[27], a[56]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[27], a[56]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[15], a[57]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[15], a[57]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[16], a[57]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[16], a[57]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[17], a[57]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[17], a[57]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[18], a[57]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[18], a[57]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[19], a[57]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[19], a[57]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[20], a[57]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[20], a[57]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[21], a[57]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[21], a[57]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[22], a[57]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[22], a[57]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[23], a[57]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[23], a[57]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[24], a[57]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[24], a[57]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[25], a[57]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[25], a[57]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[26], a[57]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[26], a[57]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[14], a[58]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[14], a[58]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[15], a[58]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[15], a[58]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[16], a[58]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[16], a[58]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[17], a[58]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[17], a[58]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[18], a[58]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[18], a[58]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[19], a[58]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[19], a[58]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[20], a[58]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[20], a[58]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[21], a[58]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[21], a[58]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[22], a[58]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[22], a[58]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[23], a[58]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[23], a[58]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[24], a[58]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[24], a[58]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[25], a[58]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[25], a[58]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[13], a[59]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[13], a[59]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[14], a[59]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[14], a[59]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[15], a[59]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[15], a[59]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[16], a[59]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[16], a[59]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[17], a[59]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[17], a[59]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[18], a[59]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[18], a[59]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[19], a[59]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[19], a[59]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[20], a[59]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[20], a[59]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[21], a[59]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[21], a[59]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[22], a[59]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[22], a[59]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[23], a[59]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[23], a[59]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[24], a[59]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[24], a[59]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[12], a[60]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[12], a[60]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[13], a[60]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[13], a[60]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[14], a[60]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[14], a[60]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[15], a[60]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[15], a[60]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[16], a[60]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[16], a[60]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[17], a[60]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[17], a[60]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[18], a[60]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[18], a[60]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[19], a[60]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[19], a[60]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[20], a[60]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[20], a[60]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[21], a[60]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[21], a[60]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[22], a[60]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[22], a[60]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[23], a[60]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[23], a[60]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[11], a[61]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[11], a[61]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[12], a[61]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[12], a[61]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[13], a[61]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[13], a[61]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[14], a[61]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[14], a[61]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[15], a[61]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[15], a[61]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[16], a[61]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[16], a[61]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[17], a[61]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[17], a[61]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[18], a[61]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[18], a[61]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[19], a[61]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[19], a[61]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[20], a[61]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[20], a[61]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[21], a[61]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[21], a[61]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[22], a[61]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[22], a[61]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[10], a[62]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[10], a[62]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[11], a[62]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[11], a[62]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[12], a[62]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[12], a[62]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[13], a[62]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[13], a[62]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[14], a[62]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[14], a[62]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[15], a[62]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[15], a[62]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[16], a[62]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[16], a[62]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[17], a[62]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[17], a[62]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[18], a[62]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[18], a[62]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[19], a[62]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[19], a[62]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[20], a[62]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[20], a[62]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[21], a[62]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[21], a[62]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[9], a[63]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[9], a[63]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[10], a[63]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[10], a[63]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[11], a[63]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[11], a[63]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[12], a[63]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[12], a[63]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[13], a[63]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[13], a[63]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[14], a[63]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[14], a[63]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[15], a[63]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[15], a[63]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[16], a[63]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[16], a[63]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[17], a[63]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[17], a[63]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[18], a[63]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[18], a[63]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[19], a[63]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[19], a[63]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[20], a[63]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[20], a[63]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[8], a[64]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[8], a[64]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[9], a[64]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[9], a[64]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[10], a[64]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[10], a[64]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[11], a[64]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[11], a[64]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[12], a[64]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[12], a[64]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[13], a[64]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[13], a[64]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[14], a[64]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[14], a[64]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[15], a[64]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[15], a[64]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[16], a[64]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[16], a[64]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[17], a[64]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[17], a[64]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[18], a[64]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[18], a[64]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[19], a[64]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[19], a[64]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[7], a[65]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[7], a[65]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[8], a[65]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[8], a[65]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[9], a[65]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[9], a[65]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[10], a[65]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[10], a[65]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[11], a[65]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[11], a[65]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[12], a[65]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[12], a[65]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[13], a[65]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[13], a[65]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[14], a[65]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[14], a[65]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[15], a[65]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[15], a[65]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[16], a[65]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[16], a[65]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[17], a[65]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[17], a[65]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[18], a[65]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[18], a[65]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[6], a[66]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[6], a[66]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[7], a[66]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[7], a[66]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[8], a[66]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[8], a[66]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[9], a[66]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[9], a[66]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[10], a[66]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[10], a[66]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[11], a[66]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[11], a[66]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[12], a[66]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[12], a[66]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[13], a[66]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[13], a[66]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[14], a[66]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[14], a[66]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[15], a[66]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[15], a[66]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[16], a[66]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[16], a[66]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[17], a[66]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[17], a[66]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[5], a[67]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[5], a[67]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[6], a[67]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[6], a[67]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[7], a[67]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[7], a[67]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[8], a[67]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[8], a[67]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[9], a[67]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[9], a[67]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[10], a[67]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[10], a[67]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[11], a[67]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[11], a[67]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[12], a[67]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[12], a[67]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[13], a[67]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[13], a[67]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[14], a[67]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[14], a[67]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[15], a[67]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[15], a[67]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[16], a[67]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[16], a[67]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[4], a[68]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[4], a[68]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[5], a[68]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[5], a[68]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[6], a[68]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[6], a[68]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[7], a[68]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[7], a[68]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[8], a[68]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[8], a[68]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[9], a[68]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[9], a[68]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[10], a[68]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[10], a[68]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[11], a[68]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[11], a[68]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[12], a[68]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[12], a[68]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[13], a[68]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[13], a[68]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[14], a[68]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[14], a[68]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[15], a[68]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[15], a[68]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[3], a[69]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[3], a[69]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[4], a[69]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[4], a[69]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[5], a[69]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[5], a[69]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[6], a[69]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[6], a[69]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[7], a[69]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[7], a[69]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[8], a[69]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[8], a[69]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[9], a[69]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[9], a[69]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[10], a[69]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[10], a[69]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[11], a[69]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[11], a[69]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[12], a[69]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[12], a[69]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[13], a[69]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[13], a[69]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[14], a[69]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[14], a[69]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[2], a[70]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[2], a[70]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[3], a[70]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[3], a[70]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[4], a[70]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[4], a[70]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[5], a[70]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[5], a[70]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[6], a[70]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[6], a[70]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[7], a[70]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[7], a[70]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[8], a[70]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[8], a[70]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[9], a[70]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[9], a[70]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[10], a[70]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[10], a[70]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[11], a[70]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[11], a[70]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[12], a[70]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[12], a[70]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[13], a[70]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[13], a[70]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[1], a[71]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[1], a[71]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[2], a[71]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[2], a[71]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[3], a[71]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[3], a[71]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[4], a[71]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[4], a[71]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[5], a[71]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[5], a[71]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[6], a[71]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[6], a[71]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[7], a[71]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[7], a[71]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[8], a[71]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[8], a[71]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[9], a[71]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[9], a[71]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[10], a[71]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[10], a[71]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[11], a[71]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[11], a[71]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[12], a[71]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[12], a[71]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[0], a[72]);   // Sum(72)
    res[73]  = fma52hi(res[73], a[0], a[72]);   // Sum(72)
    res[73]  = fma52lo(res[73], a[1], a[72]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[1], a[72]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[2], a[72]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[2], a[72]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[3], a[72]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[3], a[72]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[4], a[72]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[4], a[72]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[5], a[72]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[5], a[72]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[6], a[72]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[6], a[72]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[7], a[72]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[7], a[72]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[8], a[72]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[8], a[72]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[9], a[72]);   // Sum(81)
    res[82]  = fma52hi(res[82], a[9], a[72]);   // Sum(81)
    res[82]  = fma52lo(res[82], a[10], a[72]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[10], a[72]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[11], a[72]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[11], a[72]);  // Sum(83)
    res[73]  = fma52lo(res[73], a[0], a[73]);   // Sum(73)
    res[74]  = fma52hi(res[74], a[0], a[73]);   // Sum(73)
    res[74]  = fma52lo(res[74], a[1], a[73]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[1], a[73]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[2], a[73]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[2], a[73]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[3], a[73]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[3], a[73]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[4], a[73]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[4], a[73]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[5], a[73]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[5], a[73]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[6], a[73]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[6], a[73]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[7], a[73]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[7], a[73]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[8], a[73]);   // Sum(81)
    res[82]  = fma52hi(res[82], a[8], a[73]);   // Sum(81)
    res[82]  = fma52lo(res[82], a[9], a[73]);   // Sum(82)
    res[83]  = fma52hi(res[83], a[9], a[73]);   // Sum(82)
    res[83]  = fma52lo(res[83], a[10], a[73]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[10], a[73]);  // Sum(83)
    res[74]  = fma52lo(res[74], a[0], a[74]);   // Sum(74)
    res[75]  = fma52hi(res[75], a[0], a[74]);   // Sum(74)
    res[75]  = fma52lo(res[75], a[1], a[74]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[1], a[74]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[2], a[74]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[2], a[74]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[3], a[74]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[3], a[74]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[4], a[74]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[4], a[74]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[5], a[74]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[5], a[74]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[6], a[74]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[6], a[74]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[7], a[74]);   // Sum(81)
    res[82]  = fma52hi(res[82], a[7], a[74]);   // Sum(81)
    res[82]  = fma52lo(res[82], a[8], a[74]);   // Sum(82)
    res[83]  = fma52hi(res[83], a[8], a[74]);   // Sum(82)
    res[83]  = fma52lo(res[83], a[9], a[74]);   // Sum(83)
    res[84]  = fma52hi(res[84], a[9], a[74]);   // Sum(83)
    res[75]  = fma52lo(res[75], a[0], a[75]);   // Sum(75)
    res[76]  = fma52hi(res[76], a[0], a[75]);   // Sum(75)
    res[76]  = fma52lo(res[76], a[1], a[75]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[1], a[75]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[2], a[75]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[2], a[75]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[3], a[75]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[3], a[75]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[4], a[75]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[4], a[75]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[5], a[75]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[5], a[75]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[6], a[75]);   // Sum(81)
    res[82]  = fma52hi(res[82], a[6], a[75]);   // Sum(81)
    res[82]  = fma52lo(res[82], a[7], a[75]);   // Sum(82)
    res[83]  = fma52hi(res[83], a[7], a[75]);   // Sum(82)
    res[83]  = fma52lo(res[83], a[8], a[75]);   // Sum(83)
    res[84]  = fma52hi(res[84], a[8], a[75]);   // Sum(83)
    res[76]  = fma52lo(res[76], a[0], a[76]);   // Sum(76)
    res[77]  = fma52hi(res[77], a[0], a[76]);   // Sum(76)
    res[77]  = fma52lo(res[77], a[1], a[76]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[1], a[76]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[2], a[76]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[2], a[76]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[3], a[76]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[3], a[76]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[4], a[76]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[4], a[76]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[5], a[76]);   // Sum(81)
    res[82]  = fma52hi(res[82], a[5], a[76]);   // Sum(81)
    res[82]  = fma52lo(res[82], a[6], a[76]);   // Sum(82)
    res[83]  = fma52hi(res[83], a[6], a[76]);   // Sum(82)
    res[83]  = fma52lo(res[83], a[7], a[76]);   // Sum(83)
    res[84]  = fma52hi(res[84], a[7], a[76]);   // Sum(83)
    res[77]  = fma52lo(res[77], a[0], a[77]);   // Sum(77)
    res[78]  = fma52hi(res[78], a[0], a[77]);   // Sum(77)
    res[78]  = fma52lo(res[78], a[1], a[77]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[1], a[77]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[2], a[77]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[2], a[77]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[3], a[77]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[3], a[77]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[4], a[77]);   // Sum(81)
    res[82]  = fma52hi(res[82], a[4], a[77]);   // Sum(81)
    res[82]  = fma52lo(res[82], a[5], a[77]);   // Sum(82)
    res[83]  = fma52hi(res[83], a[5], a[77]);   // Sum(82)
    res[83]  = fma52lo(res[83], a[6], a[77]);   // Sum(83)
    res[84]  = fma52hi(res[84], a[6], a[77]);   // Sum(83)
    res[78]  = fma52lo(res[78], a[0], a[78]);   // Sum(78)
    res[79]  = fma52hi(res[79], a[0], a[78]);   // Sum(78)
    res[79]  = fma52lo(res[79], a[1], a[78]);   // Sum(79)
    res[80]  = fma52hi(res[80], a[1], a[78]);   // Sum(79)
    res[80]  = fma52lo(res[80], a[2], a[78]);   // Sum(80)
    res[81]  = fma52hi(res[81], a[2], a[78]);   // Sum(80)
    res[81]  = fma52lo(res[81], a[3], a[78]);   // Sum(81)
    res[82]  = fma52hi(res[82], a[3], a[78]);   // Sum(81)
    res[82]  = fma52lo(res[82], a[4], a[78]);   // Sum(82)
    res[83]  = fma52hi(res[83], a[4], a[78]);   // Sum(82)
    res[83]  = fma52lo(res[83], a[5], a[78]);   // Sum(83)
    res[84]  = fma52hi(res[84], a[5], a[78]);   // Sum(83)
    res[72]  = add64(res[72], res[72]);         // Double(72)
    res[73]  = add64(res[73], res[73]);         // Double(73)
    res[74]  = add64(res[74], res[74]);         // Double(74)
    res[75]  = add64(res[75], res[75]);         // Double(75)
    res[76]  = add64(res[76], res[76]);         // Double(76)
    res[77]  = add64(res[77], res[77]);         // Double(77)
    res[78]  = add64(res[78], res[78]);         // Double(78)
    res[79]  = add64(res[79], res[79]);         // Double(79)
    res[80]  = add64(res[80], res[80]);         // Double(80)
    res[81]  = add64(res[81], res[81]);         // Double(81)
    res[82]  = add64(res[82], res[82]);         // Double(82)
    res[83]  = add64(res[83], res[83]);         // Double(83)
    res[72]  = fma52lo(res[72], a[36], a[36]);  // Add sqr(72)
    res[73]  = fma52hi(res[73], a[36], a[36]);  // Add sqr(72)
    res[74]  = fma52lo(res[74], a[37], a[37]);  // Add sqr(74)
    res[75]  = fma52hi(res[75], a[37], a[37]);  // Add sqr(74)
    res[76]  = fma52lo(res[76], a[38], a[38]);  // Add sqr(76)
    res[77]  = fma52hi(res[77], a[38], a[38]);  // Add sqr(76)
    res[78]  = fma52lo(res[78], a[39], a[39]);  // Add sqr(78)
    res[79]  = fma52hi(res[79], a[39], a[39]);  // Add sqr(78)
    res[80]  = fma52lo(res[80], a[40], a[40]);  // Add sqr(80)
    res[81]  = fma52hi(res[81], a[40], a[40]);  // Add sqr(80)
    res[82]  = fma52lo(res[82], a[41], a[41]);  // Add sqr(82)
    res[83]  = fma52hi(res[83], a[41], a[41]);  // Add sqr(82)
    res[84]  = fma52lo(res[84], a[41], a[43]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[41], a[43]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[42], a[43]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[42], a[43]);  // Sum(85)
    res[84]  = fma52lo(res[84], a[40], a[44]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[40], a[44]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[41], a[44]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[41], a[44]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[42], a[44]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[42], a[44]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[43], a[44]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[43], a[44]);  // Sum(87)
    res[84]  = fma52lo(res[84], a[39], a[45]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[39], a[45]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[40], a[45]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[40], a[45]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[41], a[45]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[41], a[45]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[42], a[45]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[42], a[45]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[43], a[45]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[43], a[45]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[44], a[45]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[44], a[45]);  // Sum(89)
    res[84]  = fma52lo(res[84], a[38], a[46]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[38], a[46]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[39], a[46]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[39], a[46]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[40], a[46]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[40], a[46]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[41], a[46]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[41], a[46]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[42], a[46]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[42], a[46]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[43], a[46]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[43], a[46]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[44], a[46]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[44], a[46]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[45], a[46]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[45], a[46]);  // Sum(91)
    res[84]  = fma52lo(res[84], a[37], a[47]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[37], a[47]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[38], a[47]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[38], a[47]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[39], a[47]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[39], a[47]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[40], a[47]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[40], a[47]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[41], a[47]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[41], a[47]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[42], a[47]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[42], a[47]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[43], a[47]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[43], a[47]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[44], a[47]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[44], a[47]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[45], a[47]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[45], a[47]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[46], a[47]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[46], a[47]);  // Sum(93)
    res[84]  = fma52lo(res[84], a[36], a[48]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[36], a[48]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[37], a[48]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[37], a[48]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[38], a[48]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[38], a[48]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[39], a[48]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[39], a[48]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[40], a[48]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[40], a[48]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[41], a[48]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[41], a[48]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[42], a[48]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[42], a[48]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[43], a[48]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[43], a[48]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[44], a[48]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[44], a[48]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[45], a[48]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[45], a[48]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[46], a[48]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[46], a[48]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[47], a[48]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[47], a[48]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[35], a[49]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[35], a[49]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[36], a[49]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[36], a[49]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[37], a[49]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[37], a[49]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[38], a[49]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[38], a[49]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[39], a[49]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[39], a[49]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[40], a[49]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[40], a[49]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[41], a[49]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[41], a[49]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[42], a[49]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[42], a[49]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[43], a[49]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[43], a[49]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[44], a[49]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[44], a[49]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[45], a[49]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[45], a[49]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[46], a[49]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[46], a[49]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[34], a[50]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[34], a[50]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[35], a[50]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[35], a[50]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[36], a[50]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[36], a[50]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[37], a[50]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[37], a[50]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[38], a[50]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[38], a[50]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[39], a[50]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[39], a[50]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[40], a[50]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[40], a[50]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[41], a[50]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[41], a[50]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[42], a[50]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[42], a[50]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[43], a[50]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[43], a[50]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[44], a[50]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[44], a[50]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[45], a[50]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[45], a[50]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[33], a[51]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[33], a[51]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[34], a[51]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[34], a[51]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[35], a[51]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[35], a[51]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[36], a[51]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[36], a[51]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[37], a[51]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[37], a[51]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[38], a[51]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[38], a[51]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[39], a[51]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[39], a[51]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[40], a[51]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[40], a[51]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[41], a[51]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[41], a[51]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[42], a[51]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[42], a[51]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[43], a[51]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[43], a[51]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[44], a[51]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[44], a[51]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[32], a[52]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[32], a[52]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[33], a[52]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[33], a[52]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[34], a[52]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[34], a[52]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[35], a[52]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[35], a[52]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[36], a[52]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[36], a[52]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[37], a[52]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[37], a[52]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[38], a[52]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[38], a[52]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[39], a[52]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[39], a[52]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[40], a[52]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[40], a[52]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[41], a[52]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[41], a[52]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[42], a[52]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[42], a[52]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[43], a[52]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[43], a[52]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[31], a[53]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[31], a[53]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[32], a[53]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[32], a[53]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[33], a[53]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[33], a[53]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[34], a[53]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[34], a[53]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[35], a[53]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[35], a[53]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[36], a[53]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[36], a[53]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[37], a[53]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[37], a[53]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[38], a[53]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[38], a[53]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[39], a[53]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[39], a[53]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[40], a[53]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[40], a[53]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[41], a[53]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[41], a[53]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[42], a[53]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[42], a[53]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[30], a[54]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[30], a[54]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[31], a[54]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[31], a[54]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[32], a[54]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[32], a[54]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[33], a[54]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[33], a[54]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[34], a[54]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[34], a[54]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[35], a[54]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[35], a[54]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[36], a[54]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[36], a[54]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[37], a[54]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[37], a[54]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[38], a[54]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[38], a[54]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[39], a[54]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[39], a[54]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[40], a[54]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[40], a[54]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[41], a[54]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[41], a[54]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[29], a[55]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[29], a[55]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[30], a[55]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[30], a[55]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[31], a[55]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[31], a[55]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[32], a[55]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[32], a[55]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[33], a[55]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[33], a[55]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[34], a[55]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[34], a[55]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[35], a[55]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[35], a[55]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[36], a[55]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[36], a[55]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[37], a[55]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[37], a[55]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[38], a[55]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[38], a[55]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[39], a[55]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[39], a[55]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[40], a[55]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[40], a[55]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[28], a[56]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[28], a[56]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[29], a[56]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[29], a[56]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[30], a[56]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[30], a[56]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[31], a[56]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[31], a[56]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[32], a[56]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[32], a[56]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[33], a[56]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[33], a[56]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[34], a[56]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[34], a[56]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[35], a[56]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[35], a[56]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[36], a[56]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[36], a[56]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[37], a[56]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[37], a[56]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[38], a[56]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[38], a[56]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[39], a[56]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[39], a[56]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[27], a[57]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[27], a[57]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[28], a[57]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[28], a[57]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[29], a[57]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[29], a[57]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[30], a[57]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[30], a[57]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[31], a[57]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[31], a[57]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[32], a[57]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[32], a[57]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[33], a[57]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[33], a[57]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[34], a[57]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[34], a[57]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[35], a[57]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[35], a[57]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[36], a[57]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[36], a[57]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[37], a[57]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[37], a[57]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[38], a[57]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[38], a[57]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[26], a[58]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[26], a[58]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[27], a[58]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[27], a[58]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[28], a[58]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[28], a[58]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[29], a[58]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[29], a[58]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[30], a[58]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[30], a[58]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[31], a[58]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[31], a[58]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[32], a[58]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[32], a[58]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[33], a[58]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[33], a[58]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[34], a[58]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[34], a[58]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[35], a[58]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[35], a[58]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[36], a[58]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[36], a[58]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[37], a[58]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[37], a[58]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[25], a[59]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[25], a[59]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[26], a[59]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[26], a[59]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[27], a[59]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[27], a[59]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[28], a[59]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[28], a[59]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[29], a[59]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[29], a[59]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[30], a[59]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[30], a[59]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[31], a[59]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[31], a[59]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[32], a[59]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[32], a[59]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[33], a[59]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[33], a[59]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[34], a[59]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[34], a[59]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[35], a[59]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[35], a[59]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[36], a[59]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[36], a[59]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[24], a[60]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[24], a[60]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[25], a[60]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[25], a[60]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[26], a[60]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[26], a[60]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[27], a[60]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[27], a[60]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[28], a[60]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[28], a[60]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[29], a[60]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[29], a[60]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[30], a[60]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[30], a[60]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[31], a[60]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[31], a[60]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[32], a[60]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[32], a[60]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[33], a[60]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[33], a[60]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[34], a[60]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[34], a[60]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[35], a[60]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[35], a[60]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[23], a[61]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[23], a[61]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[24], a[61]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[24], a[61]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[25], a[61]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[25], a[61]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[26], a[61]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[26], a[61]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[27], a[61]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[27], a[61]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[28], a[61]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[28], a[61]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[29], a[61]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[29], a[61]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[30], a[61]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[30], a[61]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[31], a[61]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[31], a[61]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[32], a[61]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[32], a[61]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[33], a[61]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[33], a[61]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[34], a[61]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[34], a[61]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[22], a[62]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[22], a[62]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[23], a[62]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[23], a[62]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[24], a[62]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[24], a[62]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[25], a[62]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[25], a[62]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[26], a[62]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[26], a[62]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[27], a[62]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[27], a[62]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[28], a[62]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[28], a[62]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[29], a[62]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[29], a[62]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[30], a[62]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[30], a[62]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[31], a[62]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[31], a[62]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[32], a[62]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[32], a[62]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[33], a[62]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[33], a[62]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[21], a[63]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[21], a[63]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[22], a[63]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[22], a[63]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[23], a[63]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[23], a[63]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[24], a[63]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[24], a[63]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[25], a[63]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[25], a[63]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[26], a[63]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[26], a[63]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[27], a[63]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[27], a[63]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[28], a[63]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[28], a[63]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[29], a[63]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[29], a[63]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[30], a[63]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[30], a[63]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[31], a[63]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[31], a[63]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[32], a[63]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[32], a[63]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[20], a[64]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[20], a[64]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[21], a[64]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[21], a[64]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[22], a[64]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[22], a[64]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[23], a[64]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[23], a[64]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[24], a[64]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[24], a[64]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[25], a[64]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[25], a[64]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[26], a[64]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[26], a[64]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[27], a[64]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[27], a[64]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[28], a[64]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[28], a[64]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[29], a[64]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[29], a[64]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[30], a[64]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[30], a[64]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[31], a[64]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[31], a[64]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[19], a[65]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[19], a[65]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[20], a[65]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[20], a[65]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[21], a[65]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[21], a[65]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[22], a[65]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[22], a[65]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[23], a[65]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[23], a[65]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[24], a[65]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[24], a[65]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[25], a[65]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[25], a[65]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[26], a[65]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[26], a[65]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[27], a[65]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[27], a[65]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[28], a[65]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[28], a[65]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[29], a[65]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[29], a[65]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[30], a[65]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[30], a[65]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[18], a[66]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[18], a[66]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[19], a[66]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[19], a[66]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[20], a[66]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[20], a[66]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[21], a[66]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[21], a[66]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[22], a[66]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[22], a[66]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[23], a[66]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[23], a[66]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[24], a[66]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[24], a[66]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[25], a[66]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[25], a[66]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[26], a[66]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[26], a[66]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[27], a[66]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[27], a[66]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[28], a[66]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[28], a[66]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[29], a[66]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[29], a[66]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[17], a[67]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[17], a[67]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[18], a[67]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[18], a[67]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[19], a[67]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[19], a[67]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[20], a[67]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[20], a[67]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[21], a[67]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[21], a[67]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[22], a[67]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[22], a[67]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[23], a[67]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[23], a[67]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[24], a[67]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[24], a[67]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[25], a[67]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[25], a[67]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[26], a[67]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[26], a[67]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[27], a[67]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[27], a[67]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[28], a[67]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[28], a[67]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[16], a[68]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[16], a[68]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[17], a[68]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[17], a[68]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[18], a[68]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[18], a[68]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[19], a[68]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[19], a[68]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[20], a[68]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[20], a[68]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[21], a[68]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[21], a[68]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[22], a[68]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[22], a[68]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[23], a[68]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[23], a[68]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[24], a[68]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[24], a[68]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[25], a[68]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[25], a[68]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[26], a[68]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[26], a[68]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[27], a[68]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[27], a[68]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[15], a[69]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[15], a[69]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[16], a[69]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[16], a[69]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[17], a[69]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[17], a[69]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[18], a[69]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[18], a[69]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[19], a[69]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[19], a[69]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[20], a[69]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[20], a[69]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[21], a[69]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[21], a[69]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[22], a[69]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[22], a[69]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[23], a[69]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[23], a[69]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[24], a[69]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[24], a[69]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[25], a[69]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[25], a[69]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[26], a[69]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[26], a[69]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[14], a[70]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[14], a[70]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[15], a[70]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[15], a[70]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[16], a[70]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[16], a[70]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[17], a[70]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[17], a[70]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[18], a[70]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[18], a[70]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[19], a[70]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[19], a[70]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[20], a[70]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[20], a[70]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[21], a[70]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[21], a[70]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[22], a[70]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[22], a[70]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[23], a[70]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[23], a[70]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[24], a[70]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[24], a[70]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[25], a[70]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[25], a[70]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[13], a[71]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[13], a[71]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[14], a[71]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[14], a[71]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[15], a[71]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[15], a[71]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[16], a[71]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[16], a[71]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[17], a[71]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[17], a[71]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[18], a[71]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[18], a[71]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[19], a[71]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[19], a[71]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[20], a[71]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[20], a[71]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[21], a[71]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[21], a[71]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[22], a[71]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[22], a[71]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[23], a[71]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[23], a[71]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[24], a[71]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[24], a[71]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[12], a[72]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[12], a[72]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[13], a[72]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[13], a[72]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[14], a[72]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[14], a[72]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[15], a[72]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[15], a[72]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[16], a[72]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[16], a[72]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[17], a[72]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[17], a[72]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[18], a[72]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[18], a[72]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[19], a[72]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[19], a[72]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[20], a[72]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[20], a[72]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[21], a[72]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[21], a[72]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[22], a[72]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[22], a[72]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[23], a[72]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[23], a[72]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[11], a[73]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[11], a[73]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[12], a[73]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[12], a[73]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[13], a[73]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[13], a[73]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[14], a[73]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[14], a[73]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[15], a[73]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[15], a[73]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[16], a[73]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[16], a[73]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[17], a[73]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[17], a[73]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[18], a[73]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[18], a[73]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[19], a[73]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[19], a[73]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[20], a[73]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[20], a[73]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[21], a[73]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[21], a[73]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[22], a[73]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[22], a[73]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[10], a[74]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[10], a[74]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[11], a[74]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[11], a[74]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[12], a[74]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[12], a[74]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[13], a[74]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[13], a[74]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[14], a[74]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[14], a[74]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[15], a[74]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[15], a[74]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[16], a[74]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[16], a[74]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[17], a[74]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[17], a[74]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[18], a[74]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[18], a[74]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[19], a[74]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[19], a[74]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[20], a[74]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[20], a[74]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[21], a[74]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[21], a[74]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[9], a[75]);   // Sum(84)
    res[85]  = fma52hi(res[85], a[9], a[75]);   // Sum(84)
    res[85]  = fma52lo(res[85], a[10], a[75]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[10], a[75]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[11], a[75]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[11], a[75]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[12], a[75]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[12], a[75]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[13], a[75]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[13], a[75]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[14], a[75]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[14], a[75]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[15], a[75]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[15], a[75]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[16], a[75]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[16], a[75]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[17], a[75]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[17], a[75]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[18], a[75]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[18], a[75]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[19], a[75]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[19], a[75]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[20], a[75]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[20], a[75]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[8], a[76]);   // Sum(84)
    res[85]  = fma52hi(res[85], a[8], a[76]);   // Sum(84)
    res[85]  = fma52lo(res[85], a[9], a[76]);   // Sum(85)
    res[86]  = fma52hi(res[86], a[9], a[76]);   // Sum(85)
    res[86]  = fma52lo(res[86], a[10], a[76]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[10], a[76]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[11], a[76]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[11], a[76]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[12], a[76]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[12], a[76]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[13], a[76]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[13], a[76]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[14], a[76]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[14], a[76]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[15], a[76]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[15], a[76]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[16], a[76]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[16], a[76]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[17], a[76]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[17], a[76]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[18], a[76]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[18], a[76]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[19], a[76]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[19], a[76]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[7], a[77]);   // Sum(84)
    res[85]  = fma52hi(res[85], a[7], a[77]);   // Sum(84)
    res[85]  = fma52lo(res[85], a[8], a[77]);   // Sum(85)
    res[86]  = fma52hi(res[86], a[8], a[77]);   // Sum(85)
    res[86]  = fma52lo(res[86], a[9], a[77]);   // Sum(86)
    res[87]  = fma52hi(res[87], a[9], a[77]);   // Sum(86)
    res[87]  = fma52lo(res[87], a[10], a[77]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[10], a[77]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[11], a[77]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[11], a[77]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[12], a[77]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[12], a[77]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[13], a[77]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[13], a[77]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[14], a[77]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[14], a[77]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[15], a[77]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[15], a[77]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[16], a[77]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[16], a[77]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[17], a[77]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[17], a[77]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[18], a[77]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[18], a[77]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[6], a[78]);   // Sum(84)
    res[85]  = fma52hi(res[85], a[6], a[78]);   // Sum(84)
    res[85]  = fma52lo(res[85], a[7], a[78]);   // Sum(85)
    res[86]  = fma52hi(res[86], a[7], a[78]);   // Sum(85)
    res[86]  = fma52lo(res[86], a[8], a[78]);   // Sum(86)
    res[87]  = fma52hi(res[87], a[8], a[78]);   // Sum(86)
    res[87]  = fma52lo(res[87], a[9], a[78]);   // Sum(87)
    res[88]  = fma52hi(res[88], a[9], a[78]);   // Sum(87)
    res[88]  = fma52lo(res[88], a[10], a[78]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[10], a[78]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[11], a[78]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[11], a[78]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[12], a[78]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[12], a[78]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[13], a[78]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[13], a[78]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[14], a[78]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[14], a[78]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[15], a[78]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[15], a[78]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[16], a[78]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[16], a[78]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[17], a[78]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[17], a[78]);  // Sum(95)
    res[84]  = add64(res[84], res[84]);         // Double(84)
    res[85]  = add64(res[85], res[85]);         // Double(85)
    res[86]  = add64(res[86], res[86]);         // Double(86)
    res[87]  = add64(res[87], res[87]);         // Double(87)
    res[88]  = add64(res[88], res[88]);         // Double(88)
    res[89]  = add64(res[89], res[89]);         // Double(89)
    res[90]  = add64(res[90], res[90]);         // Double(90)
    res[91]  = add64(res[91], res[91]);         // Double(91)
    res[92]  = add64(res[92], res[92]);         // Double(92)
    res[93]  = add64(res[93], res[93]);         // Double(93)
    res[94]  = add64(res[94], res[94]);         // Double(94)
    res[95]  = add64(res[95], res[95]);         // Double(95)
    res[84]  = fma52lo(res[84], a[42], a[42]);  // Add sqr(84)
    res[85]  = fma52hi(res[85], a[42], a[42]);  // Add sqr(84)
    res[86]  = fma52lo(res[86], a[43], a[43]);  // Add sqr(86)
    res[87]  = fma52hi(res[87], a[43], a[43]);  // Add sqr(86)
    res[88]  = fma52lo(res[88], a[44], a[44]);  // Add sqr(88)
    res[89]  = fma52hi(res[89], a[44], a[44]);  // Add sqr(88)
    res[90]  = fma52lo(res[90], a[45], a[45]);  // Add sqr(90)
    res[91]  = fma52hi(res[91], a[45], a[45]);  // Add sqr(90)
    res[92]  = fma52lo(res[92], a[46], a[46]);  // Add sqr(92)
    res[93]  = fma52hi(res[93], a[46], a[46]);  // Add sqr(92)
    res[94]  = fma52lo(res[94], a[47], a[47]);  // Add sqr(94)
    res[95]  = fma52hi(res[95], a[47], a[47]);  // Add sqr(94)
    res[96]  = fma52lo(res[96], a[47], a[49]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[47], a[49]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[48], a[49]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[48], a[49]);  // Sum(97)
    res[96]  = fma52lo(res[96], a[46], a[50]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[46], a[50]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[47], a[50]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[47], a[50]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[48], a[50]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[48], a[50]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[49], a[50]);  // Sum(99)
    res[100] = fma52hi(res[100], a[49], a[50]); // Sum(99)
    res[96]  = fma52lo(res[96], a[45], a[51]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[45], a[51]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[46], a[51]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[46], a[51]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[47], a[51]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[47], a[51]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[48], a[51]);  // Sum(99)
    res[100] = fma52hi(res[100], a[48], a[51]); // Sum(99)
    res[100] = fma52lo(res[100], a[49], a[51]); // Sum(100)
    res[101] = fma52hi(res[101], a[49], a[51]); // Sum(100)
    res[101] = fma52lo(res[101], a[50], a[51]); // Sum(101)
    res[102] = fma52hi(res[102], a[50], a[51]); // Sum(101)
    res[96]  = fma52lo(res[96], a[44], a[52]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[44], a[52]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[45], a[52]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[45], a[52]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[46], a[52]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[46], a[52]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[47], a[52]);  // Sum(99)
    res[100] = fma52hi(res[100], a[47], a[52]); // Sum(99)
    res[100] = fma52lo(res[100], a[48], a[52]); // Sum(100)
    res[101] = fma52hi(res[101], a[48], a[52]); // Sum(100)
    res[101] = fma52lo(res[101], a[49], a[52]); // Sum(101)
    res[102] = fma52hi(res[102], a[49], a[52]); // Sum(101)
    res[102] = fma52lo(res[102], a[50], a[52]); // Sum(102)
    res[103] = fma52hi(res[103], a[50], a[52]); // Sum(102)
    res[103] = fma52lo(res[103], a[51], a[52]); // Sum(103)
    res[104] = fma52hi(res[104], a[51], a[52]); // Sum(103)
    res[96]  = fma52lo(res[96], a[43], a[53]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[43], a[53]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[44], a[53]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[44], a[53]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[45], a[53]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[45], a[53]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[46], a[53]);  // Sum(99)
    res[100] = fma52hi(res[100], a[46], a[53]); // Sum(99)
    res[100] = fma52lo(res[100], a[47], a[53]); // Sum(100)
    res[101] = fma52hi(res[101], a[47], a[53]); // Sum(100)
    res[101] = fma52lo(res[101], a[48], a[53]); // Sum(101)
    res[102] = fma52hi(res[102], a[48], a[53]); // Sum(101)
    res[102] = fma52lo(res[102], a[49], a[53]); // Sum(102)
    res[103] = fma52hi(res[103], a[49], a[53]); // Sum(102)
    res[103] = fma52lo(res[103], a[50], a[53]); // Sum(103)
    res[104] = fma52hi(res[104], a[50], a[53]); // Sum(103)
    res[104] = fma52lo(res[104], a[51], a[53]); // Sum(104)
    res[105] = fma52hi(res[105], a[51], a[53]); // Sum(104)
    res[105] = fma52lo(res[105], a[52], a[53]); // Sum(105)
    res[106] = fma52hi(res[106], a[52], a[53]); // Sum(105)
    res[96]  = fma52lo(res[96], a[42], a[54]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[42], a[54]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[43], a[54]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[43], a[54]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[44], a[54]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[44], a[54]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[45], a[54]);  // Sum(99)
    res[100] = fma52hi(res[100], a[45], a[54]); // Sum(99)
    res[100] = fma52lo(res[100], a[46], a[54]); // Sum(100)
    res[101] = fma52hi(res[101], a[46], a[54]); // Sum(100)
    res[101] = fma52lo(res[101], a[47], a[54]); // Sum(101)
    res[102] = fma52hi(res[102], a[47], a[54]); // Sum(101)
    res[102] = fma52lo(res[102], a[48], a[54]); // Sum(102)
    res[103] = fma52hi(res[103], a[48], a[54]); // Sum(102)
    res[103] = fma52lo(res[103], a[49], a[54]); // Sum(103)
    res[104] = fma52hi(res[104], a[49], a[54]); // Sum(103)
    res[104] = fma52lo(res[104], a[50], a[54]); // Sum(104)
    res[105] = fma52hi(res[105], a[50], a[54]); // Sum(104)
    res[105] = fma52lo(res[105], a[51], a[54]); // Sum(105)
    res[106] = fma52hi(res[106], a[51], a[54]); // Sum(105)
    res[106] = fma52lo(res[106], a[52], a[54]); // Sum(106)
    res[107] = fma52hi(res[107], a[52], a[54]); // Sum(106)
    res[107] = fma52lo(res[107], a[53], a[54]); // Sum(107)
    res[108] = fma52hi(res[108], a[53], a[54]); // Sum(107)
    res[96]  = fma52lo(res[96], a[41], a[55]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[41], a[55]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[42], a[55]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[42], a[55]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[43], a[55]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[43], a[55]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[44], a[55]);  // Sum(99)
    res[100] = fma52hi(res[100], a[44], a[55]); // Sum(99)
    res[100] = fma52lo(res[100], a[45], a[55]); // Sum(100)
    res[101] = fma52hi(res[101], a[45], a[55]); // Sum(100)
    res[101] = fma52lo(res[101], a[46], a[55]); // Sum(101)
    res[102] = fma52hi(res[102], a[46], a[55]); // Sum(101)
    res[102] = fma52lo(res[102], a[47], a[55]); // Sum(102)
    res[103] = fma52hi(res[103], a[47], a[55]); // Sum(102)
    res[103] = fma52lo(res[103], a[48], a[55]); // Sum(103)
    res[104] = fma52hi(res[104], a[48], a[55]); // Sum(103)
    res[104] = fma52lo(res[104], a[49], a[55]); // Sum(104)
    res[105] = fma52hi(res[105], a[49], a[55]); // Sum(104)
    res[105] = fma52lo(res[105], a[50], a[55]); // Sum(105)
    res[106] = fma52hi(res[106], a[50], a[55]); // Sum(105)
    res[106] = fma52lo(res[106], a[51], a[55]); // Sum(106)
    res[107] = fma52hi(res[107], a[51], a[55]); // Sum(106)
    res[107] = fma52lo(res[107], a[52], a[55]); // Sum(107)
    res[108] = fma52hi(res[108], a[52], a[55]); // Sum(107)
    res[96]  = fma52lo(res[96], a[40], a[56]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[40], a[56]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[41], a[56]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[41], a[56]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[42], a[56]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[42], a[56]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[43], a[56]);  // Sum(99)
    res[100] = fma52hi(res[100], a[43], a[56]); // Sum(99)
    res[100] = fma52lo(res[100], a[44], a[56]); // Sum(100)
    res[101] = fma52hi(res[101], a[44], a[56]); // Sum(100)
    res[101] = fma52lo(res[101], a[45], a[56]); // Sum(101)
    res[102] = fma52hi(res[102], a[45], a[56]); // Sum(101)
    res[102] = fma52lo(res[102], a[46], a[56]); // Sum(102)
    res[103] = fma52hi(res[103], a[46], a[56]); // Sum(102)
    res[103] = fma52lo(res[103], a[47], a[56]); // Sum(103)
    res[104] = fma52hi(res[104], a[47], a[56]); // Sum(103)
    res[104] = fma52lo(res[104], a[48], a[56]); // Sum(104)
    res[105] = fma52hi(res[105], a[48], a[56]); // Sum(104)
    res[105] = fma52lo(res[105], a[49], a[56]); // Sum(105)
    res[106] = fma52hi(res[106], a[49], a[56]); // Sum(105)
    res[106] = fma52lo(res[106], a[50], a[56]); // Sum(106)
    res[107] = fma52hi(res[107], a[50], a[56]); // Sum(106)
    res[107] = fma52lo(res[107], a[51], a[56]); // Sum(107)
    res[108] = fma52hi(res[108], a[51], a[56]); // Sum(107)
    res[96]  = fma52lo(res[96], a[39], a[57]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[39], a[57]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[40], a[57]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[40], a[57]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[41], a[57]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[41], a[57]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[42], a[57]);  // Sum(99)
    res[100] = fma52hi(res[100], a[42], a[57]); // Sum(99)
    res[100] = fma52lo(res[100], a[43], a[57]); // Sum(100)
    res[101] = fma52hi(res[101], a[43], a[57]); // Sum(100)
    res[101] = fma52lo(res[101], a[44], a[57]); // Sum(101)
    res[102] = fma52hi(res[102], a[44], a[57]); // Sum(101)
    res[102] = fma52lo(res[102], a[45], a[57]); // Sum(102)
    res[103] = fma52hi(res[103], a[45], a[57]); // Sum(102)
    res[103] = fma52lo(res[103], a[46], a[57]); // Sum(103)
    res[104] = fma52hi(res[104], a[46], a[57]); // Sum(103)
    res[104] = fma52lo(res[104], a[47], a[57]); // Sum(104)
    res[105] = fma52hi(res[105], a[47], a[57]); // Sum(104)
    res[105] = fma52lo(res[105], a[48], a[57]); // Sum(105)
    res[106] = fma52hi(res[106], a[48], a[57]); // Sum(105)
    res[106] = fma52lo(res[106], a[49], a[57]); // Sum(106)
    res[107] = fma52hi(res[107], a[49], a[57]); // Sum(106)
    res[107] = fma52lo(res[107], a[50], a[57]); // Sum(107)
    res[108] = fma52hi(res[108], a[50], a[57]); // Sum(107)
    res[96]  = fma52lo(res[96], a[38], a[58]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[38], a[58]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[39], a[58]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[39], a[58]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[40], a[58]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[40], a[58]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[41], a[58]);  // Sum(99)
    res[100] = fma52hi(res[100], a[41], a[58]); // Sum(99)
    res[100] = fma52lo(res[100], a[42], a[58]); // Sum(100)
    res[101] = fma52hi(res[101], a[42], a[58]); // Sum(100)
    res[101] = fma52lo(res[101], a[43], a[58]); // Sum(101)
    res[102] = fma52hi(res[102], a[43], a[58]); // Sum(101)
    res[102] = fma52lo(res[102], a[44], a[58]); // Sum(102)
    res[103] = fma52hi(res[103], a[44], a[58]); // Sum(102)
    res[103] = fma52lo(res[103], a[45], a[58]); // Sum(103)
    res[104] = fma52hi(res[104], a[45], a[58]); // Sum(103)
    res[104] = fma52lo(res[104], a[46], a[58]); // Sum(104)
    res[105] = fma52hi(res[105], a[46], a[58]); // Sum(104)
    res[105] = fma52lo(res[105], a[47], a[58]); // Sum(105)
    res[106] = fma52hi(res[106], a[47], a[58]); // Sum(105)
    res[106] = fma52lo(res[106], a[48], a[58]); // Sum(106)
    res[107] = fma52hi(res[107], a[48], a[58]); // Sum(106)
    res[107] = fma52lo(res[107], a[49], a[58]); // Sum(107)
    res[108] = fma52hi(res[108], a[49], a[58]); // Sum(107)
    res[96]  = fma52lo(res[96], a[37], a[59]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[37], a[59]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[38], a[59]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[38], a[59]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[39], a[59]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[39], a[59]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[40], a[59]);  // Sum(99)
    res[100] = fma52hi(res[100], a[40], a[59]); // Sum(99)
    res[100] = fma52lo(res[100], a[41], a[59]); // Sum(100)
    res[101] = fma52hi(res[101], a[41], a[59]); // Sum(100)
    res[101] = fma52lo(res[101], a[42], a[59]); // Sum(101)
    res[102] = fma52hi(res[102], a[42], a[59]); // Sum(101)
    res[102] = fma52lo(res[102], a[43], a[59]); // Sum(102)
    res[103] = fma52hi(res[103], a[43], a[59]); // Sum(102)
    res[103] = fma52lo(res[103], a[44], a[59]); // Sum(103)
    res[104] = fma52hi(res[104], a[44], a[59]); // Sum(103)
    res[104] = fma52lo(res[104], a[45], a[59]); // Sum(104)
    res[105] = fma52hi(res[105], a[45], a[59]); // Sum(104)
    res[105] = fma52lo(res[105], a[46], a[59]); // Sum(105)
    res[106] = fma52hi(res[106], a[46], a[59]); // Sum(105)
    res[106] = fma52lo(res[106], a[47], a[59]); // Sum(106)
    res[107] = fma52hi(res[107], a[47], a[59]); // Sum(106)
    res[107] = fma52lo(res[107], a[48], a[59]); // Sum(107)
    res[108] = fma52hi(res[108], a[48], a[59]); // Sum(107)
    res[96]  = fma52lo(res[96], a[36], a[60]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[36], a[60]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[37], a[60]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[37], a[60]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[38], a[60]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[38], a[60]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[39], a[60]);  // Sum(99)
    res[100] = fma52hi(res[100], a[39], a[60]); // Sum(99)
    res[100] = fma52lo(res[100], a[40], a[60]); // Sum(100)
    res[101] = fma52hi(res[101], a[40], a[60]); // Sum(100)
    res[101] = fma52lo(res[101], a[41], a[60]); // Sum(101)
    res[102] = fma52hi(res[102], a[41], a[60]); // Sum(101)
    res[102] = fma52lo(res[102], a[42], a[60]); // Sum(102)
    res[103] = fma52hi(res[103], a[42], a[60]); // Sum(102)
    res[103] = fma52lo(res[103], a[43], a[60]); // Sum(103)
    res[104] = fma52hi(res[104], a[43], a[60]); // Sum(103)
    res[104] = fma52lo(res[104], a[44], a[60]); // Sum(104)
    res[105] = fma52hi(res[105], a[44], a[60]); // Sum(104)
    res[105] = fma52lo(res[105], a[45], a[60]); // Sum(105)
    res[106] = fma52hi(res[106], a[45], a[60]); // Sum(105)
    res[106] = fma52lo(res[106], a[46], a[60]); // Sum(106)
    res[107] = fma52hi(res[107], a[46], a[60]); // Sum(106)
    res[107] = fma52lo(res[107], a[47], a[60]); // Sum(107)
    res[108] = fma52hi(res[108], a[47], a[60]); // Sum(107)
    res[96]  = fma52lo(res[96], a[35], a[61]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[35], a[61]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[36], a[61]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[36], a[61]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[37], a[61]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[37], a[61]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[38], a[61]);  // Sum(99)
    res[100] = fma52hi(res[100], a[38], a[61]); // Sum(99)
    res[100] = fma52lo(res[100], a[39], a[61]); // Sum(100)
    res[101] = fma52hi(res[101], a[39], a[61]); // Sum(100)
    res[101] = fma52lo(res[101], a[40], a[61]); // Sum(101)
    res[102] = fma52hi(res[102], a[40], a[61]); // Sum(101)
    res[102] = fma52lo(res[102], a[41], a[61]); // Sum(102)
    res[103] = fma52hi(res[103], a[41], a[61]); // Sum(102)
    res[103] = fma52lo(res[103], a[42], a[61]); // Sum(103)
    res[104] = fma52hi(res[104], a[42], a[61]); // Sum(103)
    res[104] = fma52lo(res[104], a[43], a[61]); // Sum(104)
    res[105] = fma52hi(res[105], a[43], a[61]); // Sum(104)
    res[105] = fma52lo(res[105], a[44], a[61]); // Sum(105)
    res[106] = fma52hi(res[106], a[44], a[61]); // Sum(105)
    res[106] = fma52lo(res[106], a[45], a[61]); // Sum(106)
    res[107] = fma52hi(res[107], a[45], a[61]); // Sum(106)
    res[107] = fma52lo(res[107], a[46], a[61]); // Sum(107)
    res[108] = fma52hi(res[108], a[46], a[61]); // Sum(107)
    res[96]  = fma52lo(res[96], a[34], a[62]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[34], a[62]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[35], a[62]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[35], a[62]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[36], a[62]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[36], a[62]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[37], a[62]);  // Sum(99)
    res[100] = fma52hi(res[100], a[37], a[62]); // Sum(99)
    res[100] = fma52lo(res[100], a[38], a[62]); // Sum(100)
    res[101] = fma52hi(res[101], a[38], a[62]); // Sum(100)
    res[101] = fma52lo(res[101], a[39], a[62]); // Sum(101)
    res[102] = fma52hi(res[102], a[39], a[62]); // Sum(101)
    res[102] = fma52lo(res[102], a[40], a[62]); // Sum(102)
    res[103] = fma52hi(res[103], a[40], a[62]); // Sum(102)
    res[103] = fma52lo(res[103], a[41], a[62]); // Sum(103)
    res[104] = fma52hi(res[104], a[41], a[62]); // Sum(103)
    res[104] = fma52lo(res[104], a[42], a[62]); // Sum(104)
    res[105] = fma52hi(res[105], a[42], a[62]); // Sum(104)
    res[105] = fma52lo(res[105], a[43], a[62]); // Sum(105)
    res[106] = fma52hi(res[106], a[43], a[62]); // Sum(105)
    res[106] = fma52lo(res[106], a[44], a[62]); // Sum(106)
    res[107] = fma52hi(res[107], a[44], a[62]); // Sum(106)
    res[107] = fma52lo(res[107], a[45], a[62]); // Sum(107)
    res[108] = fma52hi(res[108], a[45], a[62]); // Sum(107)
    res[96]  = fma52lo(res[96], a[33], a[63]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[33], a[63]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[34], a[63]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[34], a[63]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[35], a[63]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[35], a[63]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[36], a[63]);  // Sum(99)
    res[100] = fma52hi(res[100], a[36], a[63]); // Sum(99)
    res[100] = fma52lo(res[100], a[37], a[63]); // Sum(100)
    res[101] = fma52hi(res[101], a[37], a[63]); // Sum(100)
    res[101] = fma52lo(res[101], a[38], a[63]); // Sum(101)
    res[102] = fma52hi(res[102], a[38], a[63]); // Sum(101)
    res[102] = fma52lo(res[102], a[39], a[63]); // Sum(102)
    res[103] = fma52hi(res[103], a[39], a[63]); // Sum(102)
    res[103] = fma52lo(res[103], a[40], a[63]); // Sum(103)
    res[104] = fma52hi(res[104], a[40], a[63]); // Sum(103)
    res[104] = fma52lo(res[104], a[41], a[63]); // Sum(104)
    res[105] = fma52hi(res[105], a[41], a[63]); // Sum(104)
    res[105] = fma52lo(res[105], a[42], a[63]); // Sum(105)
    res[106] = fma52hi(res[106], a[42], a[63]); // Sum(105)
    res[106] = fma52lo(res[106], a[43], a[63]); // Sum(106)
    res[107] = fma52hi(res[107], a[43], a[63]); // Sum(106)
    res[107] = fma52lo(res[107], a[44], a[63]); // Sum(107)
    res[108] = fma52hi(res[108], a[44], a[63]); // Sum(107)
    res[96]  = fma52lo(res[96], a[32], a[64]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[32], a[64]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[33], a[64]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[33], a[64]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[34], a[64]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[34], a[64]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[35], a[64]);  // Sum(99)
    res[100] = fma52hi(res[100], a[35], a[64]); // Sum(99)
    res[100] = fma52lo(res[100], a[36], a[64]); // Sum(100)
    res[101] = fma52hi(res[101], a[36], a[64]); // Sum(100)
    res[101] = fma52lo(res[101], a[37], a[64]); // Sum(101)
    res[102] = fma52hi(res[102], a[37], a[64]); // Sum(101)
    res[102] = fma52lo(res[102], a[38], a[64]); // Sum(102)
    res[103] = fma52hi(res[103], a[38], a[64]); // Sum(102)
    res[103] = fma52lo(res[103], a[39], a[64]); // Sum(103)
    res[104] = fma52hi(res[104], a[39], a[64]); // Sum(103)
    res[104] = fma52lo(res[104], a[40], a[64]); // Sum(104)
    res[105] = fma52hi(res[105], a[40], a[64]); // Sum(104)
    res[105] = fma52lo(res[105], a[41], a[64]); // Sum(105)
    res[106] = fma52hi(res[106], a[41], a[64]); // Sum(105)
    res[106] = fma52lo(res[106], a[42], a[64]); // Sum(106)
    res[107] = fma52hi(res[107], a[42], a[64]); // Sum(106)
    res[107] = fma52lo(res[107], a[43], a[64]); // Sum(107)
    res[108] = fma52hi(res[108], a[43], a[64]); // Sum(107)
    res[96]  = fma52lo(res[96], a[31], a[65]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[31], a[65]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[32], a[65]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[32], a[65]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[33], a[65]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[33], a[65]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[34], a[65]);  // Sum(99)
    res[100] = fma52hi(res[100], a[34], a[65]); // Sum(99)
    res[100] = fma52lo(res[100], a[35], a[65]); // Sum(100)
    res[101] = fma52hi(res[101], a[35], a[65]); // Sum(100)
    res[101] = fma52lo(res[101], a[36], a[65]); // Sum(101)
    res[102] = fma52hi(res[102], a[36], a[65]); // Sum(101)
    res[102] = fma52lo(res[102], a[37], a[65]); // Sum(102)
    res[103] = fma52hi(res[103], a[37], a[65]); // Sum(102)
    res[103] = fma52lo(res[103], a[38], a[65]); // Sum(103)
    res[104] = fma52hi(res[104], a[38], a[65]); // Sum(103)
    res[104] = fma52lo(res[104], a[39], a[65]); // Sum(104)
    res[105] = fma52hi(res[105], a[39], a[65]); // Sum(104)
    res[105] = fma52lo(res[105], a[40], a[65]); // Sum(105)
    res[106] = fma52hi(res[106], a[40], a[65]); // Sum(105)
    res[106] = fma52lo(res[106], a[41], a[65]); // Sum(106)
    res[107] = fma52hi(res[107], a[41], a[65]); // Sum(106)
    res[107] = fma52lo(res[107], a[42], a[65]); // Sum(107)
    res[108] = fma52hi(res[108], a[42], a[65]); // Sum(107)
    res[96]  = fma52lo(res[96], a[30], a[66]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[30], a[66]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[31], a[66]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[31], a[66]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[32], a[66]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[32], a[66]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[33], a[66]);  // Sum(99)
    res[100] = fma52hi(res[100], a[33], a[66]); // Sum(99)
    res[100] = fma52lo(res[100], a[34], a[66]); // Sum(100)
    res[101] = fma52hi(res[101], a[34], a[66]); // Sum(100)
    res[101] = fma52lo(res[101], a[35], a[66]); // Sum(101)
    res[102] = fma52hi(res[102], a[35], a[66]); // Sum(101)
    res[102] = fma52lo(res[102], a[36], a[66]); // Sum(102)
    res[103] = fma52hi(res[103], a[36], a[66]); // Sum(102)
    res[103] = fma52lo(res[103], a[37], a[66]); // Sum(103)
    res[104] = fma52hi(res[104], a[37], a[66]); // Sum(103)
    res[104] = fma52lo(res[104], a[38], a[66]); // Sum(104)
    res[105] = fma52hi(res[105], a[38], a[66]); // Sum(104)
    res[105] = fma52lo(res[105], a[39], a[66]); // Sum(105)
    res[106] = fma52hi(res[106], a[39], a[66]); // Sum(105)
    res[106] = fma52lo(res[106], a[40], a[66]); // Sum(106)
    res[107] = fma52hi(res[107], a[40], a[66]); // Sum(106)
    res[107] = fma52lo(res[107], a[41], a[66]); // Sum(107)
    res[108] = fma52hi(res[108], a[41], a[66]); // Sum(107)
    res[96]  = fma52lo(res[96], a[29], a[67]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[29], a[67]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[30], a[67]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[30], a[67]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[31], a[67]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[31], a[67]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[32], a[67]);  // Sum(99)
    res[100] = fma52hi(res[100], a[32], a[67]); // Sum(99)
    res[100] = fma52lo(res[100], a[33], a[67]); // Sum(100)
    res[101] = fma52hi(res[101], a[33], a[67]); // Sum(100)
    res[101] = fma52lo(res[101], a[34], a[67]); // Sum(101)
    res[102] = fma52hi(res[102], a[34], a[67]); // Sum(101)
    res[102] = fma52lo(res[102], a[35], a[67]); // Sum(102)
    res[103] = fma52hi(res[103], a[35], a[67]); // Sum(102)
    res[103] = fma52lo(res[103], a[36], a[67]); // Sum(103)
    res[104] = fma52hi(res[104], a[36], a[67]); // Sum(103)
    res[104] = fma52lo(res[104], a[37], a[67]); // Sum(104)
    res[105] = fma52hi(res[105], a[37], a[67]); // Sum(104)
    res[105] = fma52lo(res[105], a[38], a[67]); // Sum(105)
    res[106] = fma52hi(res[106], a[38], a[67]); // Sum(105)
    res[106] = fma52lo(res[106], a[39], a[67]); // Sum(106)
    res[107] = fma52hi(res[107], a[39], a[67]); // Sum(106)
    res[107] = fma52lo(res[107], a[40], a[67]); // Sum(107)
    res[108] = fma52hi(res[108], a[40], a[67]); // Sum(107)
    res[96]  = fma52lo(res[96], a[28], a[68]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[28], a[68]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[29], a[68]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[29], a[68]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[30], a[68]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[30], a[68]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[31], a[68]);  // Sum(99)
    res[100] = fma52hi(res[100], a[31], a[68]); // Sum(99)
    res[100] = fma52lo(res[100], a[32], a[68]); // Sum(100)
    res[101] = fma52hi(res[101], a[32], a[68]); // Sum(100)
    res[101] = fma52lo(res[101], a[33], a[68]); // Sum(101)
    res[102] = fma52hi(res[102], a[33], a[68]); // Sum(101)
    res[102] = fma52lo(res[102], a[34], a[68]); // Sum(102)
    res[103] = fma52hi(res[103], a[34], a[68]); // Sum(102)
    res[103] = fma52lo(res[103], a[35], a[68]); // Sum(103)
    res[104] = fma52hi(res[104], a[35], a[68]); // Sum(103)
    res[104] = fma52lo(res[104], a[36], a[68]); // Sum(104)
    res[105] = fma52hi(res[105], a[36], a[68]); // Sum(104)
    res[105] = fma52lo(res[105], a[37], a[68]); // Sum(105)
    res[106] = fma52hi(res[106], a[37], a[68]); // Sum(105)
    res[106] = fma52lo(res[106], a[38], a[68]); // Sum(106)
    res[107] = fma52hi(res[107], a[38], a[68]); // Sum(106)
    res[107] = fma52lo(res[107], a[39], a[68]); // Sum(107)
    res[108] = fma52hi(res[108], a[39], a[68]); // Sum(107)
    res[96]  = fma52lo(res[96], a[27], a[69]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[27], a[69]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[28], a[69]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[28], a[69]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[29], a[69]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[29], a[69]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[30], a[69]);  // Sum(99)
    res[100] = fma52hi(res[100], a[30], a[69]); // Sum(99)
    res[100] = fma52lo(res[100], a[31], a[69]); // Sum(100)
    res[101] = fma52hi(res[101], a[31], a[69]); // Sum(100)
    res[101] = fma52lo(res[101], a[32], a[69]); // Sum(101)
    res[102] = fma52hi(res[102], a[32], a[69]); // Sum(101)
    res[102] = fma52lo(res[102], a[33], a[69]); // Sum(102)
    res[103] = fma52hi(res[103], a[33], a[69]); // Sum(102)
    res[103] = fma52lo(res[103], a[34], a[69]); // Sum(103)
    res[104] = fma52hi(res[104], a[34], a[69]); // Sum(103)
    res[104] = fma52lo(res[104], a[35], a[69]); // Sum(104)
    res[105] = fma52hi(res[105], a[35], a[69]); // Sum(104)
    res[105] = fma52lo(res[105], a[36], a[69]); // Sum(105)
    res[106] = fma52hi(res[106], a[36], a[69]); // Sum(105)
    res[106] = fma52lo(res[106], a[37], a[69]); // Sum(106)
    res[107] = fma52hi(res[107], a[37], a[69]); // Sum(106)
    res[107] = fma52lo(res[107], a[38], a[69]); // Sum(107)
    res[108] = fma52hi(res[108], a[38], a[69]); // Sum(107)
    res[96]  = fma52lo(res[96], a[26], a[70]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[26], a[70]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[27], a[70]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[27], a[70]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[28], a[70]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[28], a[70]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[29], a[70]);  // Sum(99)
    res[100] = fma52hi(res[100], a[29], a[70]); // Sum(99)
    res[100] = fma52lo(res[100], a[30], a[70]); // Sum(100)
    res[101] = fma52hi(res[101], a[30], a[70]); // Sum(100)
    res[101] = fma52lo(res[101], a[31], a[70]); // Sum(101)
    res[102] = fma52hi(res[102], a[31], a[70]); // Sum(101)
    res[102] = fma52lo(res[102], a[32], a[70]); // Sum(102)
    res[103] = fma52hi(res[103], a[32], a[70]); // Sum(102)
    res[103] = fma52lo(res[103], a[33], a[70]); // Sum(103)
    res[104] = fma52hi(res[104], a[33], a[70]); // Sum(103)
    res[104] = fma52lo(res[104], a[34], a[70]); // Sum(104)
    res[105] = fma52hi(res[105], a[34], a[70]); // Sum(104)
    res[105] = fma52lo(res[105], a[35], a[70]); // Sum(105)
    res[106] = fma52hi(res[106], a[35], a[70]); // Sum(105)
    res[106] = fma52lo(res[106], a[36], a[70]); // Sum(106)
    res[107] = fma52hi(res[107], a[36], a[70]); // Sum(106)
    res[107] = fma52lo(res[107], a[37], a[70]); // Sum(107)
    res[108] = fma52hi(res[108], a[37], a[70]); // Sum(107)
    res[96]  = fma52lo(res[96], a[25], a[71]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[25], a[71]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[26], a[71]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[26], a[71]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[27], a[71]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[27], a[71]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[28], a[71]);  // Sum(99)
    res[100] = fma52hi(res[100], a[28], a[71]); // Sum(99)
    res[100] = fma52lo(res[100], a[29], a[71]); // Sum(100)
    res[101] = fma52hi(res[101], a[29], a[71]); // Sum(100)
    res[101] = fma52lo(res[101], a[30], a[71]); // Sum(101)
    res[102] = fma52hi(res[102], a[30], a[71]); // Sum(101)
    res[102] = fma52lo(res[102], a[31], a[71]); // Sum(102)
    res[103] = fma52hi(res[103], a[31], a[71]); // Sum(102)
    res[103] = fma52lo(res[103], a[32], a[71]); // Sum(103)
    res[104] = fma52hi(res[104], a[32], a[71]); // Sum(103)
    res[104] = fma52lo(res[104], a[33], a[71]); // Sum(104)
    res[105] = fma52hi(res[105], a[33], a[71]); // Sum(104)
    res[105] = fma52lo(res[105], a[34], a[71]); // Sum(105)
    res[106] = fma52hi(res[106], a[34], a[71]); // Sum(105)
    res[106] = fma52lo(res[106], a[35], a[71]); // Sum(106)
    res[107] = fma52hi(res[107], a[35], a[71]); // Sum(106)
    res[107] = fma52lo(res[107], a[36], a[71]); // Sum(107)
    res[108] = fma52hi(res[108], a[36], a[71]); // Sum(107)
    res[96]  = fma52lo(res[96], a[24], a[72]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[24], a[72]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[25], a[72]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[25], a[72]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[26], a[72]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[26], a[72]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[27], a[72]);  // Sum(99)
    res[100] = fma52hi(res[100], a[27], a[72]); // Sum(99)
    res[100] = fma52lo(res[100], a[28], a[72]); // Sum(100)
    res[101] = fma52hi(res[101], a[28], a[72]); // Sum(100)
    res[101] = fma52lo(res[101], a[29], a[72]); // Sum(101)
    res[102] = fma52hi(res[102], a[29], a[72]); // Sum(101)
    res[102] = fma52lo(res[102], a[30], a[72]); // Sum(102)
    res[103] = fma52hi(res[103], a[30], a[72]); // Sum(102)
    res[103] = fma52lo(res[103], a[31], a[72]); // Sum(103)
    res[104] = fma52hi(res[104], a[31], a[72]); // Sum(103)
    res[104] = fma52lo(res[104], a[32], a[72]); // Sum(104)
    res[105] = fma52hi(res[105], a[32], a[72]); // Sum(104)
    res[105] = fma52lo(res[105], a[33], a[72]); // Sum(105)
    res[106] = fma52hi(res[106], a[33], a[72]); // Sum(105)
    res[106] = fma52lo(res[106], a[34], a[72]); // Sum(106)
    res[107] = fma52hi(res[107], a[34], a[72]); // Sum(106)
    res[107] = fma52lo(res[107], a[35], a[72]); // Sum(107)
    res[108] = fma52hi(res[108], a[35], a[72]); // Sum(107)
    res[96]  = fma52lo(res[96], a[23], a[73]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[23], a[73]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[24], a[73]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[24], a[73]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[25], a[73]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[25], a[73]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[26], a[73]);  // Sum(99)
    res[100] = fma52hi(res[100], a[26], a[73]); // Sum(99)
    res[100] = fma52lo(res[100], a[27], a[73]); // Sum(100)
    res[101] = fma52hi(res[101], a[27], a[73]); // Sum(100)
    res[101] = fma52lo(res[101], a[28], a[73]); // Sum(101)
    res[102] = fma52hi(res[102], a[28], a[73]); // Sum(101)
    res[102] = fma52lo(res[102], a[29], a[73]); // Sum(102)
    res[103] = fma52hi(res[103], a[29], a[73]); // Sum(102)
    res[103] = fma52lo(res[103], a[30], a[73]); // Sum(103)
    res[104] = fma52hi(res[104], a[30], a[73]); // Sum(103)
    res[104] = fma52lo(res[104], a[31], a[73]); // Sum(104)
    res[105] = fma52hi(res[105], a[31], a[73]); // Sum(104)
    res[105] = fma52lo(res[105], a[32], a[73]); // Sum(105)
    res[106] = fma52hi(res[106], a[32], a[73]); // Sum(105)
    res[106] = fma52lo(res[106], a[33], a[73]); // Sum(106)
    res[107] = fma52hi(res[107], a[33], a[73]); // Sum(106)
    res[107] = fma52lo(res[107], a[34], a[73]); // Sum(107)
    res[108] = fma52hi(res[108], a[34], a[73]); // Sum(107)
    res[96]  = fma52lo(res[96], a[22], a[74]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[22], a[74]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[23], a[74]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[23], a[74]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[24], a[74]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[24], a[74]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[25], a[74]);  // Sum(99)
    res[100] = fma52hi(res[100], a[25], a[74]); // Sum(99)
    res[100] = fma52lo(res[100], a[26], a[74]); // Sum(100)
    res[101] = fma52hi(res[101], a[26], a[74]); // Sum(100)
    res[101] = fma52lo(res[101], a[27], a[74]); // Sum(101)
    res[102] = fma52hi(res[102], a[27], a[74]); // Sum(101)
    res[102] = fma52lo(res[102], a[28], a[74]); // Sum(102)
    res[103] = fma52hi(res[103], a[28], a[74]); // Sum(102)
    res[103] = fma52lo(res[103], a[29], a[74]); // Sum(103)
    res[104] = fma52hi(res[104], a[29], a[74]); // Sum(103)
    res[104] = fma52lo(res[104], a[30], a[74]); // Sum(104)
    res[105] = fma52hi(res[105], a[30], a[74]); // Sum(104)
    res[105] = fma52lo(res[105], a[31], a[74]); // Sum(105)
    res[106] = fma52hi(res[106], a[31], a[74]); // Sum(105)
    res[106] = fma52lo(res[106], a[32], a[74]); // Sum(106)
    res[107] = fma52hi(res[107], a[32], a[74]); // Sum(106)
    res[107] = fma52lo(res[107], a[33], a[74]); // Sum(107)
    res[108] = fma52hi(res[108], a[33], a[74]); // Sum(107)
    res[96]  = fma52lo(res[96], a[21], a[75]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[21], a[75]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[22], a[75]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[22], a[75]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[23], a[75]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[23], a[75]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[24], a[75]);  // Sum(99)
    res[100] = fma52hi(res[100], a[24], a[75]); // Sum(99)
    res[100] = fma52lo(res[100], a[25], a[75]); // Sum(100)
    res[101] = fma52hi(res[101], a[25], a[75]); // Sum(100)
    res[101] = fma52lo(res[101], a[26], a[75]); // Sum(101)
    res[102] = fma52hi(res[102], a[26], a[75]); // Sum(101)
    res[102] = fma52lo(res[102], a[27], a[75]); // Sum(102)
    res[103] = fma52hi(res[103], a[27], a[75]); // Sum(102)
    res[103] = fma52lo(res[103], a[28], a[75]); // Sum(103)
    res[104] = fma52hi(res[104], a[28], a[75]); // Sum(103)
    res[104] = fma52lo(res[104], a[29], a[75]); // Sum(104)
    res[105] = fma52hi(res[105], a[29], a[75]); // Sum(104)
    res[105] = fma52lo(res[105], a[30], a[75]); // Sum(105)
    res[106] = fma52hi(res[106], a[30], a[75]); // Sum(105)
    res[106] = fma52lo(res[106], a[31], a[75]); // Sum(106)
    res[107] = fma52hi(res[107], a[31], a[75]); // Sum(106)
    res[107] = fma52lo(res[107], a[32], a[75]); // Sum(107)
    res[108] = fma52hi(res[108], a[32], a[75]); // Sum(107)
    res[96]  = fma52lo(res[96], a[20], a[76]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[20], a[76]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[21], a[76]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[21], a[76]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[22], a[76]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[22], a[76]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[23], a[76]);  // Sum(99)
    res[100] = fma52hi(res[100], a[23], a[76]); // Sum(99)
    res[100] = fma52lo(res[100], a[24], a[76]); // Sum(100)
    res[101] = fma52hi(res[101], a[24], a[76]); // Sum(100)
    res[101] = fma52lo(res[101], a[25], a[76]); // Sum(101)
    res[102] = fma52hi(res[102], a[25], a[76]); // Sum(101)
    res[102] = fma52lo(res[102], a[26], a[76]); // Sum(102)
    res[103] = fma52hi(res[103], a[26], a[76]); // Sum(102)
    res[103] = fma52lo(res[103], a[27], a[76]); // Sum(103)
    res[104] = fma52hi(res[104], a[27], a[76]); // Sum(103)
    res[104] = fma52lo(res[104], a[28], a[76]); // Sum(104)
    res[105] = fma52hi(res[105], a[28], a[76]); // Sum(104)
    res[105] = fma52lo(res[105], a[29], a[76]); // Sum(105)
    res[106] = fma52hi(res[106], a[29], a[76]); // Sum(105)
    res[106] = fma52lo(res[106], a[30], a[76]); // Sum(106)
    res[107] = fma52hi(res[107], a[30], a[76]); // Sum(106)
    res[107] = fma52lo(res[107], a[31], a[76]); // Sum(107)
    res[108] = fma52hi(res[108], a[31], a[76]); // Sum(107)
    res[96]  = fma52lo(res[96], a[19], a[77]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[19], a[77]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[20], a[77]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[20], a[77]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[21], a[77]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[21], a[77]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[22], a[77]);  // Sum(99)
    res[100] = fma52hi(res[100], a[22], a[77]); // Sum(99)
    res[100] = fma52lo(res[100], a[23], a[77]); // Sum(100)
    res[101] = fma52hi(res[101], a[23], a[77]); // Sum(100)
    res[101] = fma52lo(res[101], a[24], a[77]); // Sum(101)
    res[102] = fma52hi(res[102], a[24], a[77]); // Sum(101)
    res[102] = fma52lo(res[102], a[25], a[77]); // Sum(102)
    res[103] = fma52hi(res[103], a[25], a[77]); // Sum(102)
    res[103] = fma52lo(res[103], a[26], a[77]); // Sum(103)
    res[104] = fma52hi(res[104], a[26], a[77]); // Sum(103)
    res[104] = fma52lo(res[104], a[27], a[77]); // Sum(104)
    res[105] = fma52hi(res[105], a[27], a[77]); // Sum(104)
    res[105] = fma52lo(res[105], a[28], a[77]); // Sum(105)
    res[106] = fma52hi(res[106], a[28], a[77]); // Sum(105)
    res[106] = fma52lo(res[106], a[29], a[77]); // Sum(106)
    res[107] = fma52hi(res[107], a[29], a[77]); // Sum(106)
    res[107] = fma52lo(res[107], a[30], a[77]); // Sum(107)
    res[108] = fma52hi(res[108], a[30], a[77]); // Sum(107)
    res[96]  = fma52lo(res[96], a[18], a[78]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[18], a[78]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[19], a[78]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[19], a[78]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[20], a[78]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[20], a[78]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[21], a[78]);  // Sum(99)
    res[100] = fma52hi(res[100], a[21], a[78]); // Sum(99)
    res[100] = fma52lo(res[100], a[22], a[78]); // Sum(100)
    res[101] = fma52hi(res[101], a[22], a[78]); // Sum(100)
    res[101] = fma52lo(res[101], a[23], a[78]); // Sum(101)
    res[102] = fma52hi(res[102], a[23], a[78]); // Sum(101)
    res[102] = fma52lo(res[102], a[24], a[78]); // Sum(102)
    res[103] = fma52hi(res[103], a[24], a[78]); // Sum(102)
    res[103] = fma52lo(res[103], a[25], a[78]); // Sum(103)
    res[104] = fma52hi(res[104], a[25], a[78]); // Sum(103)
    res[104] = fma52lo(res[104], a[26], a[78]); // Sum(104)
    res[105] = fma52hi(res[105], a[26], a[78]); // Sum(104)
    res[105] = fma52lo(res[105], a[27], a[78]); // Sum(105)
    res[106] = fma52hi(res[106], a[27], a[78]); // Sum(105)
    res[106] = fma52lo(res[106], a[28], a[78]); // Sum(106)
    res[107] = fma52hi(res[107], a[28], a[78]); // Sum(106)
    res[107] = fma52lo(res[107], a[29], a[78]); // Sum(107)
    res[108] = fma52hi(res[108], a[29], a[78]); // Sum(107)
    res[96]  = add64(res[96], res[96]);         // Double(96)
    res[97]  = add64(res[97], res[97]);         // Double(97)
    res[98]  = add64(res[98], res[98]);         // Double(98)
    res[99]  = add64(res[99], res[99]);         // Double(99)
    res[100] = add64(res[100], res[100]);       // Double(100)
    res[101] = add64(res[101], res[101]);       // Double(101)
    res[102] = add64(res[102], res[102]);       // Double(102)
    res[103] = add64(res[103], res[103]);       // Double(103)
    res[104] = add64(res[104], res[104]);       // Double(104)
    res[105] = add64(res[105], res[105]);       // Double(105)
    res[106] = add64(res[106], res[106]);       // Double(106)
    res[107] = add64(res[107], res[107]);       // Double(107)
    res[96]  = fma52lo(res[96], a[48], a[48]);  // Add sqr(96)
    res[97]  = fma52hi(res[97], a[48], a[48]);  // Add sqr(96)
    res[98]  = fma52lo(res[98], a[49], a[49]);  // Add sqr(98)
    res[99]  = fma52hi(res[99], a[49], a[49]);  // Add sqr(98)
    res[100] = fma52lo(res[100], a[50], a[50]); // Add sqr(100)
    res[101] = fma52hi(res[101], a[50], a[50]); // Add sqr(100)
    res[102] = fma52lo(res[102], a[51], a[51]); // Add sqr(102)
    res[103] = fma52hi(res[103], a[51], a[51]); // Add sqr(102)
    res[104] = fma52lo(res[104], a[52], a[52]); // Add sqr(104)
    res[105] = fma52hi(res[105], a[52], a[52]); // Add sqr(104)
    res[106] = fma52lo(res[106], a[53], a[53]); // Add sqr(106)
    res[107] = fma52hi(res[107], a[53], a[53]); // Add sqr(106)
    res[108] = fma52lo(res[108], a[53], a[55]); // Sum(108)
    res[109] = fma52hi(res[109], a[53], a[55]); // Sum(108)
    res[109] = fma52lo(res[109], a[54], a[55]); // Sum(109)
    res[110] = fma52hi(res[110], a[54], a[55]); // Sum(109)
    res[108] = fma52lo(res[108], a[52], a[56]); // Sum(108)
    res[109] = fma52hi(res[109], a[52], a[56]); // Sum(108)
    res[109] = fma52lo(res[109], a[53], a[56]); // Sum(109)
    res[110] = fma52hi(res[110], a[53], a[56]); // Sum(109)
    res[110] = fma52lo(res[110], a[54], a[56]); // Sum(110)
    res[111] = fma52hi(res[111], a[54], a[56]); // Sum(110)
    res[111] = fma52lo(res[111], a[55], a[56]); // Sum(111)
    res[112] = fma52hi(res[112], a[55], a[56]); // Sum(111)
    res[108] = fma52lo(res[108], a[51], a[57]); // Sum(108)
    res[109] = fma52hi(res[109], a[51], a[57]); // Sum(108)
    res[109] = fma52lo(res[109], a[52], a[57]); // Sum(109)
    res[110] = fma52hi(res[110], a[52], a[57]); // Sum(109)
    res[110] = fma52lo(res[110], a[53], a[57]); // Sum(110)
    res[111] = fma52hi(res[111], a[53], a[57]); // Sum(110)
    res[111] = fma52lo(res[111], a[54], a[57]); // Sum(111)
    res[112] = fma52hi(res[112], a[54], a[57]); // Sum(111)
    res[112] = fma52lo(res[112], a[55], a[57]); // Sum(112)
    res[113] = fma52hi(res[113], a[55], a[57]); // Sum(112)
    res[113] = fma52lo(res[113], a[56], a[57]); // Sum(113)
    res[114] = fma52hi(res[114], a[56], a[57]); // Sum(113)
    res[108] = fma52lo(res[108], a[50], a[58]); // Sum(108)
    res[109] = fma52hi(res[109], a[50], a[58]); // Sum(108)
    res[109] = fma52lo(res[109], a[51], a[58]); // Sum(109)
    res[110] = fma52hi(res[110], a[51], a[58]); // Sum(109)
    res[110] = fma52lo(res[110], a[52], a[58]); // Sum(110)
    res[111] = fma52hi(res[111], a[52], a[58]); // Sum(110)
    res[111] = fma52lo(res[111], a[53], a[58]); // Sum(111)
    res[112] = fma52hi(res[112], a[53], a[58]); // Sum(111)
    res[112] = fma52lo(res[112], a[54], a[58]); // Sum(112)
    res[113] = fma52hi(res[113], a[54], a[58]); // Sum(112)
    res[113] = fma52lo(res[113], a[55], a[58]); // Sum(113)
    res[114] = fma52hi(res[114], a[55], a[58]); // Sum(113)
    res[114] = fma52lo(res[114], a[56], a[58]); // Sum(114)
    res[115] = fma52hi(res[115], a[56], a[58]); // Sum(114)
    res[115] = fma52lo(res[115], a[57], a[58]); // Sum(115)
    res[116] = fma52hi(res[116], a[57], a[58]); // Sum(115)
    res[108] = fma52lo(res[108], a[49], a[59]); // Sum(108)
    res[109] = fma52hi(res[109], a[49], a[59]); // Sum(108)
    res[109] = fma52lo(res[109], a[50], a[59]); // Sum(109)
    res[110] = fma52hi(res[110], a[50], a[59]); // Sum(109)
    res[110] = fma52lo(res[110], a[51], a[59]); // Sum(110)
    res[111] = fma52hi(res[111], a[51], a[59]); // Sum(110)
    res[111] = fma52lo(res[111], a[52], a[59]); // Sum(111)
    res[112] = fma52hi(res[112], a[52], a[59]); // Sum(111)
    res[112] = fma52lo(res[112], a[53], a[59]); // Sum(112)
    res[113] = fma52hi(res[113], a[53], a[59]); // Sum(112)
    res[113] = fma52lo(res[113], a[54], a[59]); // Sum(113)
    res[114] = fma52hi(res[114], a[54], a[59]); // Sum(113)
    res[114] = fma52lo(res[114], a[55], a[59]); // Sum(114)
    res[115] = fma52hi(res[115], a[55], a[59]); // Sum(114)
    res[115] = fma52lo(res[115], a[56], a[59]); // Sum(115)
    res[116] = fma52hi(res[116], a[56], a[59]); // Sum(115)
    res[116] = fma52lo(res[116], a[57], a[59]); // Sum(116)
    res[117] = fma52hi(res[117], a[57], a[59]); // Sum(116)
    res[117] = fma52lo(res[117], a[58], a[59]); // Sum(117)
    res[118] = fma52hi(res[118], a[58], a[59]); // Sum(117)
    res[108] = fma52lo(res[108], a[48], a[60]); // Sum(108)
    res[109] = fma52hi(res[109], a[48], a[60]); // Sum(108)
    res[109] = fma52lo(res[109], a[49], a[60]); // Sum(109)
    res[110] = fma52hi(res[110], a[49], a[60]); // Sum(109)
    res[110] = fma52lo(res[110], a[50], a[60]); // Sum(110)
    res[111] = fma52hi(res[111], a[50], a[60]); // Sum(110)
    res[111] = fma52lo(res[111], a[51], a[60]); // Sum(111)
    res[112] = fma52hi(res[112], a[51], a[60]); // Sum(111)
    res[112] = fma52lo(res[112], a[52], a[60]); // Sum(112)
    res[113] = fma52hi(res[113], a[52], a[60]); // Sum(112)
    res[113] = fma52lo(res[113], a[53], a[60]); // Sum(113)
    res[114] = fma52hi(res[114], a[53], a[60]); // Sum(113)
    res[114] = fma52lo(res[114], a[54], a[60]); // Sum(114)
    res[115] = fma52hi(res[115], a[54], a[60]); // Sum(114)
    res[115] = fma52lo(res[115], a[55], a[60]); // Sum(115)
    res[116] = fma52hi(res[116], a[55], a[60]); // Sum(115)
    res[116] = fma52lo(res[116], a[56], a[60]); // Sum(116)
    res[117] = fma52hi(res[117], a[56], a[60]); // Sum(116)
    res[117] = fma52lo(res[117], a[57], a[60]); // Sum(117)
    res[118] = fma52hi(res[118], a[57], a[60]); // Sum(117)
    res[118] = fma52lo(res[118], a[58], a[60]); // Sum(118)
    res[119] = fma52hi(res[119], a[58], a[60]); // Sum(118)
    res[119] = fma52lo(res[119], a[59], a[60]); // Sum(119)
    res[120] = fma52hi(res[120], a[59], a[60]); // Sum(119)
    res[108] = fma52lo(res[108], a[47], a[61]); // Sum(108)
    res[109] = fma52hi(res[109], a[47], a[61]); // Sum(108)
    res[109] = fma52lo(res[109], a[48], a[61]); // Sum(109)
    res[110] = fma52hi(res[110], a[48], a[61]); // Sum(109)
    res[110] = fma52lo(res[110], a[49], a[61]); // Sum(110)
    res[111] = fma52hi(res[111], a[49], a[61]); // Sum(110)
    res[111] = fma52lo(res[111], a[50], a[61]); // Sum(111)
    res[112] = fma52hi(res[112], a[50], a[61]); // Sum(111)
    res[112] = fma52lo(res[112], a[51], a[61]); // Sum(112)
    res[113] = fma52hi(res[113], a[51], a[61]); // Sum(112)
    res[113] = fma52lo(res[113], a[52], a[61]); // Sum(113)
    res[114] = fma52hi(res[114], a[52], a[61]); // Sum(113)
    res[114] = fma52lo(res[114], a[53], a[61]); // Sum(114)
    res[115] = fma52hi(res[115], a[53], a[61]); // Sum(114)
    res[115] = fma52lo(res[115], a[54], a[61]); // Sum(115)
    res[116] = fma52hi(res[116], a[54], a[61]); // Sum(115)
    res[116] = fma52lo(res[116], a[55], a[61]); // Sum(116)
    res[117] = fma52hi(res[117], a[55], a[61]); // Sum(116)
    res[117] = fma52lo(res[117], a[56], a[61]); // Sum(117)
    res[118] = fma52hi(res[118], a[56], a[61]); // Sum(117)
    res[118] = fma52lo(res[118], a[57], a[61]); // Sum(118)
    res[119] = fma52hi(res[119], a[57], a[61]); // Sum(118)
    res[119] = fma52lo(res[119], a[58], a[61]); // Sum(119)
    res[120] = fma52hi(res[120], a[58], a[61]); // Sum(119)
    res[108] = fma52lo(res[108], a[46], a[62]); // Sum(108)
    res[109] = fma52hi(res[109], a[46], a[62]); // Sum(108)
    res[109] = fma52lo(res[109], a[47], a[62]); // Sum(109)
    res[110] = fma52hi(res[110], a[47], a[62]); // Sum(109)
    res[110] = fma52lo(res[110], a[48], a[62]); // Sum(110)
    res[111] = fma52hi(res[111], a[48], a[62]); // Sum(110)
    res[111] = fma52lo(res[111], a[49], a[62]); // Sum(111)
    res[112] = fma52hi(res[112], a[49], a[62]); // Sum(111)
    res[112] = fma52lo(res[112], a[50], a[62]); // Sum(112)
    res[113] = fma52hi(res[113], a[50], a[62]); // Sum(112)
    res[113] = fma52lo(res[113], a[51], a[62]); // Sum(113)
    res[114] = fma52hi(res[114], a[51], a[62]); // Sum(113)
    res[114] = fma52lo(res[114], a[52], a[62]); // Sum(114)
    res[115] = fma52hi(res[115], a[52], a[62]); // Sum(114)
    res[115] = fma52lo(res[115], a[53], a[62]); // Sum(115)
    res[116] = fma52hi(res[116], a[53], a[62]); // Sum(115)
    res[116] = fma52lo(res[116], a[54], a[62]); // Sum(116)
    res[117] = fma52hi(res[117], a[54], a[62]); // Sum(116)
    res[117] = fma52lo(res[117], a[55], a[62]); // Sum(117)
    res[118] = fma52hi(res[118], a[55], a[62]); // Sum(117)
    res[118] = fma52lo(res[118], a[56], a[62]); // Sum(118)
    res[119] = fma52hi(res[119], a[56], a[62]); // Sum(118)
    res[119] = fma52lo(res[119], a[57], a[62]); // Sum(119)
    res[120] = fma52hi(res[120], a[57], a[62]); // Sum(119)
    res[108] = fma52lo(res[108], a[45], a[63]); // Sum(108)
    res[109] = fma52hi(res[109], a[45], a[63]); // Sum(108)
    res[109] = fma52lo(res[109], a[46], a[63]); // Sum(109)
    res[110] = fma52hi(res[110], a[46], a[63]); // Sum(109)
    res[110] = fma52lo(res[110], a[47], a[63]); // Sum(110)
    res[111] = fma52hi(res[111], a[47], a[63]); // Sum(110)
    res[111] = fma52lo(res[111], a[48], a[63]); // Sum(111)
    res[112] = fma52hi(res[112], a[48], a[63]); // Sum(111)
    res[112] = fma52lo(res[112], a[49], a[63]); // Sum(112)
    res[113] = fma52hi(res[113], a[49], a[63]); // Sum(112)
    res[113] = fma52lo(res[113], a[50], a[63]); // Sum(113)
    res[114] = fma52hi(res[114], a[50], a[63]); // Sum(113)
    res[114] = fma52lo(res[114], a[51], a[63]); // Sum(114)
    res[115] = fma52hi(res[115], a[51], a[63]); // Sum(114)
    res[115] = fma52lo(res[115], a[52], a[63]); // Sum(115)
    res[116] = fma52hi(res[116], a[52], a[63]); // Sum(115)
    res[116] = fma52lo(res[116], a[53], a[63]); // Sum(116)
    res[117] = fma52hi(res[117], a[53], a[63]); // Sum(116)
    res[117] = fma52lo(res[117], a[54], a[63]); // Sum(117)
    res[118] = fma52hi(res[118], a[54], a[63]); // Sum(117)
    res[118] = fma52lo(res[118], a[55], a[63]); // Sum(118)
    res[119] = fma52hi(res[119], a[55], a[63]); // Sum(118)
    res[119] = fma52lo(res[119], a[56], a[63]); // Sum(119)
    res[120] = fma52hi(res[120], a[56], a[63]); // Sum(119)
    res[108] = fma52lo(res[108], a[44], a[64]); // Sum(108)
    res[109] = fma52hi(res[109], a[44], a[64]); // Sum(108)
    res[109] = fma52lo(res[109], a[45], a[64]); // Sum(109)
    res[110] = fma52hi(res[110], a[45], a[64]); // Sum(109)
    res[110] = fma52lo(res[110], a[46], a[64]); // Sum(110)
    res[111] = fma52hi(res[111], a[46], a[64]); // Sum(110)
    res[111] = fma52lo(res[111], a[47], a[64]); // Sum(111)
    res[112] = fma52hi(res[112], a[47], a[64]); // Sum(111)
    res[112] = fma52lo(res[112], a[48], a[64]); // Sum(112)
    res[113] = fma52hi(res[113], a[48], a[64]); // Sum(112)
    res[113] = fma52lo(res[113], a[49], a[64]); // Sum(113)
    res[114] = fma52hi(res[114], a[49], a[64]); // Sum(113)
    res[114] = fma52lo(res[114], a[50], a[64]); // Sum(114)
    res[115] = fma52hi(res[115], a[50], a[64]); // Sum(114)
    res[115] = fma52lo(res[115], a[51], a[64]); // Sum(115)
    res[116] = fma52hi(res[116], a[51], a[64]); // Sum(115)
    res[116] = fma52lo(res[116], a[52], a[64]); // Sum(116)
    res[117] = fma52hi(res[117], a[52], a[64]); // Sum(116)
    res[117] = fma52lo(res[117], a[53], a[64]); // Sum(117)
    res[118] = fma52hi(res[118], a[53], a[64]); // Sum(117)
    res[118] = fma52lo(res[118], a[54], a[64]); // Sum(118)
    res[119] = fma52hi(res[119], a[54], a[64]); // Sum(118)
    res[119] = fma52lo(res[119], a[55], a[64]); // Sum(119)
    res[120] = fma52hi(res[120], a[55], a[64]); // Sum(119)
    res[108] = fma52lo(res[108], a[43], a[65]); // Sum(108)
    res[109] = fma52hi(res[109], a[43], a[65]); // Sum(108)
    res[109] = fma52lo(res[109], a[44], a[65]); // Sum(109)
    res[110] = fma52hi(res[110], a[44], a[65]); // Sum(109)
    res[110] = fma52lo(res[110], a[45], a[65]); // Sum(110)
    res[111] = fma52hi(res[111], a[45], a[65]); // Sum(110)
    res[111] = fma52lo(res[111], a[46], a[65]); // Sum(111)
    res[112] = fma52hi(res[112], a[46], a[65]); // Sum(111)
    res[112] = fma52lo(res[112], a[47], a[65]); // Sum(112)
    res[113] = fma52hi(res[113], a[47], a[65]); // Sum(112)
    res[113] = fma52lo(res[113], a[48], a[65]); // Sum(113)
    res[114] = fma52hi(res[114], a[48], a[65]); // Sum(113)
    res[114] = fma52lo(res[114], a[49], a[65]); // Sum(114)
    res[115] = fma52hi(res[115], a[49], a[65]); // Sum(114)
    res[115] = fma52lo(res[115], a[50], a[65]); // Sum(115)
    res[116] = fma52hi(res[116], a[50], a[65]); // Sum(115)
    res[116] = fma52lo(res[116], a[51], a[65]); // Sum(116)
    res[117] = fma52hi(res[117], a[51], a[65]); // Sum(116)
    res[117] = fma52lo(res[117], a[52], a[65]); // Sum(117)
    res[118] = fma52hi(res[118], a[52], a[65]); // Sum(117)
    res[118] = fma52lo(res[118], a[53], a[65]); // Sum(118)
    res[119] = fma52hi(res[119], a[53], a[65]); // Sum(118)
    res[119] = fma52lo(res[119], a[54], a[65]); // Sum(119)
    res[120] = fma52hi(res[120], a[54], a[65]); // Sum(119)
    res[108] = fma52lo(res[108], a[42], a[66]); // Sum(108)
    res[109] = fma52hi(res[109], a[42], a[66]); // Sum(108)
    res[109] = fma52lo(res[109], a[43], a[66]); // Sum(109)
    res[110] = fma52hi(res[110], a[43], a[66]); // Sum(109)
    res[110] = fma52lo(res[110], a[44], a[66]); // Sum(110)
    res[111] = fma52hi(res[111], a[44], a[66]); // Sum(110)
    res[111] = fma52lo(res[111], a[45], a[66]); // Sum(111)
    res[112] = fma52hi(res[112], a[45], a[66]); // Sum(111)
    res[112] = fma52lo(res[112], a[46], a[66]); // Sum(112)
    res[113] = fma52hi(res[113], a[46], a[66]); // Sum(112)
    res[113] = fma52lo(res[113], a[47], a[66]); // Sum(113)
    res[114] = fma52hi(res[114], a[47], a[66]); // Sum(113)
    res[114] = fma52lo(res[114], a[48], a[66]); // Sum(114)
    res[115] = fma52hi(res[115], a[48], a[66]); // Sum(114)
    res[115] = fma52lo(res[115], a[49], a[66]); // Sum(115)
    res[116] = fma52hi(res[116], a[49], a[66]); // Sum(115)
    res[116] = fma52lo(res[116], a[50], a[66]); // Sum(116)
    res[117] = fma52hi(res[117], a[50], a[66]); // Sum(116)
    res[117] = fma52lo(res[117], a[51], a[66]); // Sum(117)
    res[118] = fma52hi(res[118], a[51], a[66]); // Sum(117)
    res[118] = fma52lo(res[118], a[52], a[66]); // Sum(118)
    res[119] = fma52hi(res[119], a[52], a[66]); // Sum(118)
    res[119] = fma52lo(res[119], a[53], a[66]); // Sum(119)
    res[120] = fma52hi(res[120], a[53], a[66]); // Sum(119)
    res[108] = fma52lo(res[108], a[41], a[67]); // Sum(108)
    res[109] = fma52hi(res[109], a[41], a[67]); // Sum(108)
    res[109] = fma52lo(res[109], a[42], a[67]); // Sum(109)
    res[110] = fma52hi(res[110], a[42], a[67]); // Sum(109)
    res[110] = fma52lo(res[110], a[43], a[67]); // Sum(110)
    res[111] = fma52hi(res[111], a[43], a[67]); // Sum(110)
    res[111] = fma52lo(res[111], a[44], a[67]); // Sum(111)
    res[112] = fma52hi(res[112], a[44], a[67]); // Sum(111)
    res[112] = fma52lo(res[112], a[45], a[67]); // Sum(112)
    res[113] = fma52hi(res[113], a[45], a[67]); // Sum(112)
    res[113] = fma52lo(res[113], a[46], a[67]); // Sum(113)
    res[114] = fma52hi(res[114], a[46], a[67]); // Sum(113)
    res[114] = fma52lo(res[114], a[47], a[67]); // Sum(114)
    res[115] = fma52hi(res[115], a[47], a[67]); // Sum(114)
    res[115] = fma52lo(res[115], a[48], a[67]); // Sum(115)
    res[116] = fma52hi(res[116], a[48], a[67]); // Sum(115)
    res[116] = fma52lo(res[116], a[49], a[67]); // Sum(116)
    res[117] = fma52hi(res[117], a[49], a[67]); // Sum(116)
    res[117] = fma52lo(res[117], a[50], a[67]); // Sum(117)
    res[118] = fma52hi(res[118], a[50], a[67]); // Sum(117)
    res[118] = fma52lo(res[118], a[51], a[67]); // Sum(118)
    res[119] = fma52hi(res[119], a[51], a[67]); // Sum(118)
    res[119] = fma52lo(res[119], a[52], a[67]); // Sum(119)
    res[120] = fma52hi(res[120], a[52], a[67]); // Sum(119)
    res[108] = fma52lo(res[108], a[40], a[68]); // Sum(108)
    res[109] = fma52hi(res[109], a[40], a[68]); // Sum(108)
    res[109] = fma52lo(res[109], a[41], a[68]); // Sum(109)
    res[110] = fma52hi(res[110], a[41], a[68]); // Sum(109)
    res[110] = fma52lo(res[110], a[42], a[68]); // Sum(110)
    res[111] = fma52hi(res[111], a[42], a[68]); // Sum(110)
    res[111] = fma52lo(res[111], a[43], a[68]); // Sum(111)
    res[112] = fma52hi(res[112], a[43], a[68]); // Sum(111)
    res[112] = fma52lo(res[112], a[44], a[68]); // Sum(112)
    res[113] = fma52hi(res[113], a[44], a[68]); // Sum(112)
    res[113] = fma52lo(res[113], a[45], a[68]); // Sum(113)
    res[114] = fma52hi(res[114], a[45], a[68]); // Sum(113)
    res[114] = fma52lo(res[114], a[46], a[68]); // Sum(114)
    res[115] = fma52hi(res[115], a[46], a[68]); // Sum(114)
    res[115] = fma52lo(res[115], a[47], a[68]); // Sum(115)
    res[116] = fma52hi(res[116], a[47], a[68]); // Sum(115)
    res[116] = fma52lo(res[116], a[48], a[68]); // Sum(116)
    res[117] = fma52hi(res[117], a[48], a[68]); // Sum(116)
    res[117] = fma52lo(res[117], a[49], a[68]); // Sum(117)
    res[118] = fma52hi(res[118], a[49], a[68]); // Sum(117)
    res[118] = fma52lo(res[118], a[50], a[68]); // Sum(118)
    res[119] = fma52hi(res[119], a[50], a[68]); // Sum(118)
    res[119] = fma52lo(res[119], a[51], a[68]); // Sum(119)
    res[120] = fma52hi(res[120], a[51], a[68]); // Sum(119)
    res[108] = fma52lo(res[108], a[39], a[69]); // Sum(108)
    res[109] = fma52hi(res[109], a[39], a[69]); // Sum(108)
    res[109] = fma52lo(res[109], a[40], a[69]); // Sum(109)
    res[110] = fma52hi(res[110], a[40], a[69]); // Sum(109)
    res[110] = fma52lo(res[110], a[41], a[69]); // Sum(110)
    res[111] = fma52hi(res[111], a[41], a[69]); // Sum(110)
    res[111] = fma52lo(res[111], a[42], a[69]); // Sum(111)
    res[112] = fma52hi(res[112], a[42], a[69]); // Sum(111)
    res[112] = fma52lo(res[112], a[43], a[69]); // Sum(112)
    res[113] = fma52hi(res[113], a[43], a[69]); // Sum(112)
    res[113] = fma52lo(res[113], a[44], a[69]); // Sum(113)
    res[114] = fma52hi(res[114], a[44], a[69]); // Sum(113)
    res[114] = fma52lo(res[114], a[45], a[69]); // Sum(114)
    res[115] = fma52hi(res[115], a[45], a[69]); // Sum(114)
    res[115] = fma52lo(res[115], a[46], a[69]); // Sum(115)
    res[116] = fma52hi(res[116], a[46], a[69]); // Sum(115)
    res[116] = fma52lo(res[116], a[47], a[69]); // Sum(116)
    res[117] = fma52hi(res[117], a[47], a[69]); // Sum(116)
    res[117] = fma52lo(res[117], a[48], a[69]); // Sum(117)
    res[118] = fma52hi(res[118], a[48], a[69]); // Sum(117)
    res[118] = fma52lo(res[118], a[49], a[69]); // Sum(118)
    res[119] = fma52hi(res[119], a[49], a[69]); // Sum(118)
    res[119] = fma52lo(res[119], a[50], a[69]); // Sum(119)
    res[120] = fma52hi(res[120], a[50], a[69]); // Sum(119)
    res[108] = fma52lo(res[108], a[38], a[70]); // Sum(108)
    res[109] = fma52hi(res[109], a[38], a[70]); // Sum(108)
    res[109] = fma52lo(res[109], a[39], a[70]); // Sum(109)
    res[110] = fma52hi(res[110], a[39], a[70]); // Sum(109)
    res[110] = fma52lo(res[110], a[40], a[70]); // Sum(110)
    res[111] = fma52hi(res[111], a[40], a[70]); // Sum(110)
    res[111] = fma52lo(res[111], a[41], a[70]); // Sum(111)
    res[112] = fma52hi(res[112], a[41], a[70]); // Sum(111)
    res[112] = fma52lo(res[112], a[42], a[70]); // Sum(112)
    res[113] = fma52hi(res[113], a[42], a[70]); // Sum(112)
    res[113] = fma52lo(res[113], a[43], a[70]); // Sum(113)
    res[114] = fma52hi(res[114], a[43], a[70]); // Sum(113)
    res[114] = fma52lo(res[114], a[44], a[70]); // Sum(114)
    res[115] = fma52hi(res[115], a[44], a[70]); // Sum(114)
    res[115] = fma52lo(res[115], a[45], a[70]); // Sum(115)
    res[116] = fma52hi(res[116], a[45], a[70]); // Sum(115)
    res[116] = fma52lo(res[116], a[46], a[70]); // Sum(116)
    res[117] = fma52hi(res[117], a[46], a[70]); // Sum(116)
    res[117] = fma52lo(res[117], a[47], a[70]); // Sum(117)
    res[118] = fma52hi(res[118], a[47], a[70]); // Sum(117)
    res[118] = fma52lo(res[118], a[48], a[70]); // Sum(118)
    res[119] = fma52hi(res[119], a[48], a[70]); // Sum(118)
    res[119] = fma52lo(res[119], a[49], a[70]); // Sum(119)
    res[120] = fma52hi(res[120], a[49], a[70]); // Sum(119)
    res[108] = fma52lo(res[108], a[37], a[71]); // Sum(108)
    res[109] = fma52hi(res[109], a[37], a[71]); // Sum(108)
    res[109] = fma52lo(res[109], a[38], a[71]); // Sum(109)
    res[110] = fma52hi(res[110], a[38], a[71]); // Sum(109)
    res[110] = fma52lo(res[110], a[39], a[71]); // Sum(110)
    res[111] = fma52hi(res[111], a[39], a[71]); // Sum(110)
    res[111] = fma52lo(res[111], a[40], a[71]); // Sum(111)
    res[112] = fma52hi(res[112], a[40], a[71]); // Sum(111)
    res[112] = fma52lo(res[112], a[41], a[71]); // Sum(112)
    res[113] = fma52hi(res[113], a[41], a[71]); // Sum(112)
    res[113] = fma52lo(res[113], a[42], a[71]); // Sum(113)
    res[114] = fma52hi(res[114], a[42], a[71]); // Sum(113)
    res[114] = fma52lo(res[114], a[43], a[71]); // Sum(114)
    res[115] = fma52hi(res[115], a[43], a[71]); // Sum(114)
    res[115] = fma52lo(res[115], a[44], a[71]); // Sum(115)
    res[116] = fma52hi(res[116], a[44], a[71]); // Sum(115)
    res[116] = fma52lo(res[116], a[45], a[71]); // Sum(116)
    res[117] = fma52hi(res[117], a[45], a[71]); // Sum(116)
    res[117] = fma52lo(res[117], a[46], a[71]); // Sum(117)
    res[118] = fma52hi(res[118], a[46], a[71]); // Sum(117)
    res[118] = fma52lo(res[118], a[47], a[71]); // Sum(118)
    res[119] = fma52hi(res[119], a[47], a[71]); // Sum(118)
    res[119] = fma52lo(res[119], a[48], a[71]); // Sum(119)
    res[120] = fma52hi(res[120], a[48], a[71]); // Sum(119)
    res[108] = fma52lo(res[108], a[36], a[72]); // Sum(108)
    res[109] = fma52hi(res[109], a[36], a[72]); // Sum(108)
    res[109] = fma52lo(res[109], a[37], a[72]); // Sum(109)
    res[110] = fma52hi(res[110], a[37], a[72]); // Sum(109)
    res[110] = fma52lo(res[110], a[38], a[72]); // Sum(110)
    res[111] = fma52hi(res[111], a[38], a[72]); // Sum(110)
    res[111] = fma52lo(res[111], a[39], a[72]); // Sum(111)
    res[112] = fma52hi(res[112], a[39], a[72]); // Sum(111)
    res[112] = fma52lo(res[112], a[40], a[72]); // Sum(112)
    res[113] = fma52hi(res[113], a[40], a[72]); // Sum(112)
    res[113] = fma52lo(res[113], a[41], a[72]); // Sum(113)
    res[114] = fma52hi(res[114], a[41], a[72]); // Sum(113)
    res[114] = fma52lo(res[114], a[42], a[72]); // Sum(114)
    res[115] = fma52hi(res[115], a[42], a[72]); // Sum(114)
    res[115] = fma52lo(res[115], a[43], a[72]); // Sum(115)
    res[116] = fma52hi(res[116], a[43], a[72]); // Sum(115)
    res[116] = fma52lo(res[116], a[44], a[72]); // Sum(116)
    res[117] = fma52hi(res[117], a[44], a[72]); // Sum(116)
    res[117] = fma52lo(res[117], a[45], a[72]); // Sum(117)
    res[118] = fma52hi(res[118], a[45], a[72]); // Sum(117)
    res[118] = fma52lo(res[118], a[46], a[72]); // Sum(118)
    res[119] = fma52hi(res[119], a[46], a[72]); // Sum(118)
    res[119] = fma52lo(res[119], a[47], a[72]); // Sum(119)
    res[120] = fma52hi(res[120], a[47], a[72]); // Sum(119)
    res[108] = fma52lo(res[108], a[35], a[73]); // Sum(108)
    res[109] = fma52hi(res[109], a[35], a[73]); // Sum(108)
    res[109] = fma52lo(res[109], a[36], a[73]); // Sum(109)
    res[110] = fma52hi(res[110], a[36], a[73]); // Sum(109)
    res[110] = fma52lo(res[110], a[37], a[73]); // Sum(110)
    res[111] = fma52hi(res[111], a[37], a[73]); // Sum(110)
    res[111] = fma52lo(res[111], a[38], a[73]); // Sum(111)
    res[112] = fma52hi(res[112], a[38], a[73]); // Sum(111)
    res[112] = fma52lo(res[112], a[39], a[73]); // Sum(112)
    res[113] = fma52hi(res[113], a[39], a[73]); // Sum(112)
    res[113] = fma52lo(res[113], a[40], a[73]); // Sum(113)
    res[114] = fma52hi(res[114], a[40], a[73]); // Sum(113)
    res[114] = fma52lo(res[114], a[41], a[73]); // Sum(114)
    res[115] = fma52hi(res[115], a[41], a[73]); // Sum(114)
    res[115] = fma52lo(res[115], a[42], a[73]); // Sum(115)
    res[116] = fma52hi(res[116], a[42], a[73]); // Sum(115)
    res[116] = fma52lo(res[116], a[43], a[73]); // Sum(116)
    res[117] = fma52hi(res[117], a[43], a[73]); // Sum(116)
    res[117] = fma52lo(res[117], a[44], a[73]); // Sum(117)
    res[118] = fma52hi(res[118], a[44], a[73]); // Sum(117)
    res[118] = fma52lo(res[118], a[45], a[73]); // Sum(118)
    res[119] = fma52hi(res[119], a[45], a[73]); // Sum(118)
    res[119] = fma52lo(res[119], a[46], a[73]); // Sum(119)
    res[120] = fma52hi(res[120], a[46], a[73]); // Sum(119)
    res[108] = fma52lo(res[108], a[34], a[74]); // Sum(108)
    res[109] = fma52hi(res[109], a[34], a[74]); // Sum(108)
    res[109] = fma52lo(res[109], a[35], a[74]); // Sum(109)
    res[110] = fma52hi(res[110], a[35], a[74]); // Sum(109)
    res[110] = fma52lo(res[110], a[36], a[74]); // Sum(110)
    res[111] = fma52hi(res[111], a[36], a[74]); // Sum(110)
    res[111] = fma52lo(res[111], a[37], a[74]); // Sum(111)
    res[112] = fma52hi(res[112], a[37], a[74]); // Sum(111)
    res[112] = fma52lo(res[112], a[38], a[74]); // Sum(112)
    res[113] = fma52hi(res[113], a[38], a[74]); // Sum(112)
    res[113] = fma52lo(res[113], a[39], a[74]); // Sum(113)
    res[114] = fma52hi(res[114], a[39], a[74]); // Sum(113)
    res[114] = fma52lo(res[114], a[40], a[74]); // Sum(114)
    res[115] = fma52hi(res[115], a[40], a[74]); // Sum(114)
    res[115] = fma52lo(res[115], a[41], a[74]); // Sum(115)
    res[116] = fma52hi(res[116], a[41], a[74]); // Sum(115)
    res[116] = fma52lo(res[116], a[42], a[74]); // Sum(116)
    res[117] = fma52hi(res[117], a[42], a[74]); // Sum(116)
    res[117] = fma52lo(res[117], a[43], a[74]); // Sum(117)
    res[118] = fma52hi(res[118], a[43], a[74]); // Sum(117)
    res[118] = fma52lo(res[118], a[44], a[74]); // Sum(118)
    res[119] = fma52hi(res[119], a[44], a[74]); // Sum(118)
    res[119] = fma52lo(res[119], a[45], a[74]); // Sum(119)
    res[120] = fma52hi(res[120], a[45], a[74]); // Sum(119)
    res[108] = fma52lo(res[108], a[33], a[75]); // Sum(108)
    res[109] = fma52hi(res[109], a[33], a[75]); // Sum(108)
    res[109] = fma52lo(res[109], a[34], a[75]); // Sum(109)
    res[110] = fma52hi(res[110], a[34], a[75]); // Sum(109)
    res[110] = fma52lo(res[110], a[35], a[75]); // Sum(110)
    res[111] = fma52hi(res[111], a[35], a[75]); // Sum(110)
    res[111] = fma52lo(res[111], a[36], a[75]); // Sum(111)
    res[112] = fma52hi(res[112], a[36], a[75]); // Sum(111)
    res[112] = fma52lo(res[112], a[37], a[75]); // Sum(112)
    res[113] = fma52hi(res[113], a[37], a[75]); // Sum(112)
    res[113] = fma52lo(res[113], a[38], a[75]); // Sum(113)
    res[114] = fma52hi(res[114], a[38], a[75]); // Sum(113)
    res[114] = fma52lo(res[114], a[39], a[75]); // Sum(114)
    res[115] = fma52hi(res[115], a[39], a[75]); // Sum(114)
    res[115] = fma52lo(res[115], a[40], a[75]); // Sum(115)
    res[116] = fma52hi(res[116], a[40], a[75]); // Sum(115)
    res[116] = fma52lo(res[116], a[41], a[75]); // Sum(116)
    res[117] = fma52hi(res[117], a[41], a[75]); // Sum(116)
    res[117] = fma52lo(res[117], a[42], a[75]); // Sum(117)
    res[118] = fma52hi(res[118], a[42], a[75]); // Sum(117)
    res[118] = fma52lo(res[118], a[43], a[75]); // Sum(118)
    res[119] = fma52hi(res[119], a[43], a[75]); // Sum(118)
    res[119] = fma52lo(res[119], a[44], a[75]); // Sum(119)
    res[120] = fma52hi(res[120], a[44], a[75]); // Sum(119)
    res[108] = fma52lo(res[108], a[32], a[76]); // Sum(108)
    res[109] = fma52hi(res[109], a[32], a[76]); // Sum(108)
    res[109] = fma52lo(res[109], a[33], a[76]); // Sum(109)
    res[110] = fma52hi(res[110], a[33], a[76]); // Sum(109)
    res[110] = fma52lo(res[110], a[34], a[76]); // Sum(110)
    res[111] = fma52hi(res[111], a[34], a[76]); // Sum(110)
    res[111] = fma52lo(res[111], a[35], a[76]); // Sum(111)
    res[112] = fma52hi(res[112], a[35], a[76]); // Sum(111)
    res[112] = fma52lo(res[112], a[36], a[76]); // Sum(112)
    res[113] = fma52hi(res[113], a[36], a[76]); // Sum(112)
    res[113] = fma52lo(res[113], a[37], a[76]); // Sum(113)
    res[114] = fma52hi(res[114], a[37], a[76]); // Sum(113)
    res[114] = fma52lo(res[114], a[38], a[76]); // Sum(114)
    res[115] = fma52hi(res[115], a[38], a[76]); // Sum(114)
    res[115] = fma52lo(res[115], a[39], a[76]); // Sum(115)
    res[116] = fma52hi(res[116], a[39], a[76]); // Sum(115)
    res[116] = fma52lo(res[116], a[40], a[76]); // Sum(116)
    res[117] = fma52hi(res[117], a[40], a[76]); // Sum(116)
    res[117] = fma52lo(res[117], a[41], a[76]); // Sum(117)
    res[118] = fma52hi(res[118], a[41], a[76]); // Sum(117)
    res[118] = fma52lo(res[118], a[42], a[76]); // Sum(118)
    res[119] = fma52hi(res[119], a[42], a[76]); // Sum(118)
    res[119] = fma52lo(res[119], a[43], a[76]); // Sum(119)
    res[120] = fma52hi(res[120], a[43], a[76]); // Sum(119)
    res[108] = fma52lo(res[108], a[31], a[77]); // Sum(108)
    res[109] = fma52hi(res[109], a[31], a[77]); // Sum(108)
    res[109] = fma52lo(res[109], a[32], a[77]); // Sum(109)
    res[110] = fma52hi(res[110], a[32], a[77]); // Sum(109)
    res[110] = fma52lo(res[110], a[33], a[77]); // Sum(110)
    res[111] = fma52hi(res[111], a[33], a[77]); // Sum(110)
    res[111] = fma52lo(res[111], a[34], a[77]); // Sum(111)
    res[112] = fma52hi(res[112], a[34], a[77]); // Sum(111)
    res[112] = fma52lo(res[112], a[35], a[77]); // Sum(112)
    res[113] = fma52hi(res[113], a[35], a[77]); // Sum(112)
    res[113] = fma52lo(res[113], a[36], a[77]); // Sum(113)
    res[114] = fma52hi(res[114], a[36], a[77]); // Sum(113)
    res[114] = fma52lo(res[114], a[37], a[77]); // Sum(114)
    res[115] = fma52hi(res[115], a[37], a[77]); // Sum(114)
    res[115] = fma52lo(res[115], a[38], a[77]); // Sum(115)
    res[116] = fma52hi(res[116], a[38], a[77]); // Sum(115)
    res[116] = fma52lo(res[116], a[39], a[77]); // Sum(116)
    res[117] = fma52hi(res[117], a[39], a[77]); // Sum(116)
    res[117] = fma52lo(res[117], a[40], a[77]); // Sum(117)
    res[118] = fma52hi(res[118], a[40], a[77]); // Sum(117)
    res[118] = fma52lo(res[118], a[41], a[77]); // Sum(118)
    res[119] = fma52hi(res[119], a[41], a[77]); // Sum(118)
    res[119] = fma52lo(res[119], a[42], a[77]); // Sum(119)
    res[120] = fma52hi(res[120], a[42], a[77]); // Sum(119)
    res[108] = fma52lo(res[108], a[30], a[78]); // Sum(108)
    res[109] = fma52hi(res[109], a[30], a[78]); // Sum(108)
    res[109] = fma52lo(res[109], a[31], a[78]); // Sum(109)
    res[110] = fma52hi(res[110], a[31], a[78]); // Sum(109)
    res[110] = fma52lo(res[110], a[32], a[78]); // Sum(110)
    res[111] = fma52hi(res[111], a[32], a[78]); // Sum(110)
    res[111] = fma52lo(res[111], a[33], a[78]); // Sum(111)
    res[112] = fma52hi(res[112], a[33], a[78]); // Sum(111)
    res[112] = fma52lo(res[112], a[34], a[78]); // Sum(112)
    res[113] = fma52hi(res[113], a[34], a[78]); // Sum(112)
    res[113] = fma52lo(res[113], a[35], a[78]); // Sum(113)
    res[114] = fma52hi(res[114], a[35], a[78]); // Sum(113)
    res[114] = fma52lo(res[114], a[36], a[78]); // Sum(114)
    res[115] = fma52hi(res[115], a[36], a[78]); // Sum(114)
    res[115] = fma52lo(res[115], a[37], a[78]); // Sum(115)
    res[116] = fma52hi(res[116], a[37], a[78]); // Sum(115)
    res[116] = fma52lo(res[116], a[38], a[78]); // Sum(116)
    res[117] = fma52hi(res[117], a[38], a[78]); // Sum(116)
    res[117] = fma52lo(res[117], a[39], a[78]); // Sum(117)
    res[118] = fma52hi(res[118], a[39], a[78]); // Sum(117)
    res[118] = fma52lo(res[118], a[40], a[78]); // Sum(118)
    res[119] = fma52hi(res[119], a[40], a[78]); // Sum(118)
    res[119] = fma52lo(res[119], a[41], a[78]); // Sum(119)
    res[120] = fma52hi(res[120], a[41], a[78]); // Sum(119)
    res[108] = add64(res[108], res[108]);       // Double(108)
    res[109] = add64(res[109], res[109]);       // Double(109)
    res[110] = add64(res[110], res[110]);       // Double(110)
    res[111] = add64(res[111], res[111]);       // Double(111)
    res[112] = add64(res[112], res[112]);       // Double(112)
    res[113] = add64(res[113], res[113]);       // Double(113)
    res[114] = add64(res[114], res[114]);       // Double(114)
    res[115] = add64(res[115], res[115]);       // Double(115)
    res[116] = add64(res[116], res[116]);       // Double(116)
    res[117] = add64(res[117], res[117]);       // Double(117)
    res[118] = add64(res[118], res[118]);       // Double(118)
    res[119] = add64(res[119], res[119]);       // Double(119)
    res[108] = fma52lo(res[108], a[54], a[54]); // Add sqr(108)
    res[109] = fma52hi(res[109], a[54], a[54]); // Add sqr(108)
    res[110] = fma52lo(res[110], a[55], a[55]); // Add sqr(110)
    res[111] = fma52hi(res[111], a[55], a[55]); // Add sqr(110)
    res[112] = fma52lo(res[112], a[56], a[56]); // Add sqr(112)
    res[113] = fma52hi(res[113], a[56], a[56]); // Add sqr(112)
    res[114] = fma52lo(res[114], a[57], a[57]); // Add sqr(114)
    res[115] = fma52hi(res[115], a[57], a[57]); // Add sqr(114)
    res[116] = fma52lo(res[116], a[58], a[58]); // Add sqr(116)
    res[117] = fma52hi(res[117], a[58], a[58]); // Add sqr(116)
    res[118] = fma52lo(res[118], a[59], a[59]); // Add sqr(118)
    res[119] = fma52hi(res[119], a[59], a[59]); // Add sqr(118)
    res[120] = fma52lo(res[120], a[59], a[61]); // Sum(120)
    res[121] = fma52hi(res[121], a[59], a[61]); // Sum(120)
    res[121] = fma52lo(res[121], a[60], a[61]); // Sum(121)
    res[122] = fma52hi(res[122], a[60], a[61]); // Sum(121)
    res[120] = fma52lo(res[120], a[58], a[62]); // Sum(120)
    res[121] = fma52hi(res[121], a[58], a[62]); // Sum(120)
    res[121] = fma52lo(res[121], a[59], a[62]); // Sum(121)
    res[122] = fma52hi(res[122], a[59], a[62]); // Sum(121)
    res[122] = fma52lo(res[122], a[60], a[62]); // Sum(122)
    res[123] = fma52hi(res[123], a[60], a[62]); // Sum(122)
    res[123] = fma52lo(res[123], a[61], a[62]); // Sum(123)
    res[124] = fma52hi(res[124], a[61], a[62]); // Sum(123)
    res[120] = fma52lo(res[120], a[57], a[63]); // Sum(120)
    res[121] = fma52hi(res[121], a[57], a[63]); // Sum(120)
    res[121] = fma52lo(res[121], a[58], a[63]); // Sum(121)
    res[122] = fma52hi(res[122], a[58], a[63]); // Sum(121)
    res[122] = fma52lo(res[122], a[59], a[63]); // Sum(122)
    res[123] = fma52hi(res[123], a[59], a[63]); // Sum(122)
    res[123] = fma52lo(res[123], a[60], a[63]); // Sum(123)
    res[124] = fma52hi(res[124], a[60], a[63]); // Sum(123)
    res[124] = fma52lo(res[124], a[61], a[63]); // Sum(124)
    res[125] = fma52hi(res[125], a[61], a[63]); // Sum(124)
    res[125] = fma52lo(res[125], a[62], a[63]); // Sum(125)
    res[126] = fma52hi(res[126], a[62], a[63]); // Sum(125)
    res[120] = fma52lo(res[120], a[56], a[64]); // Sum(120)
    res[121] = fma52hi(res[121], a[56], a[64]); // Sum(120)
    res[121] = fma52lo(res[121], a[57], a[64]); // Sum(121)
    res[122] = fma52hi(res[122], a[57], a[64]); // Sum(121)
    res[122] = fma52lo(res[122], a[58], a[64]); // Sum(122)
    res[123] = fma52hi(res[123], a[58], a[64]); // Sum(122)
    res[123] = fma52lo(res[123], a[59], a[64]); // Sum(123)
    res[124] = fma52hi(res[124], a[59], a[64]); // Sum(123)
    res[124] = fma52lo(res[124], a[60], a[64]); // Sum(124)
    res[125] = fma52hi(res[125], a[60], a[64]); // Sum(124)
    res[125] = fma52lo(res[125], a[61], a[64]); // Sum(125)
    res[126] = fma52hi(res[126], a[61], a[64]); // Sum(125)
    res[126] = fma52lo(res[126], a[62], a[64]); // Sum(126)
    res[127] = fma52hi(res[127], a[62], a[64]); // Sum(126)
    res[127] = fma52lo(res[127], a[63], a[64]); // Sum(127)
    res[128] = fma52hi(res[128], a[63], a[64]); // Sum(127)
    res[120] = fma52lo(res[120], a[55], a[65]); // Sum(120)
    res[121] = fma52hi(res[121], a[55], a[65]); // Sum(120)
    res[121] = fma52lo(res[121], a[56], a[65]); // Sum(121)
    res[122] = fma52hi(res[122], a[56], a[65]); // Sum(121)
    res[122] = fma52lo(res[122], a[57], a[65]); // Sum(122)
    res[123] = fma52hi(res[123], a[57], a[65]); // Sum(122)
    res[123] = fma52lo(res[123], a[58], a[65]); // Sum(123)
    res[124] = fma52hi(res[124], a[58], a[65]); // Sum(123)
    res[124] = fma52lo(res[124], a[59], a[65]); // Sum(124)
    res[125] = fma52hi(res[125], a[59], a[65]); // Sum(124)
    res[125] = fma52lo(res[125], a[60], a[65]); // Sum(125)
    res[126] = fma52hi(res[126], a[60], a[65]); // Sum(125)
    res[126] = fma52lo(res[126], a[61], a[65]); // Sum(126)
    res[127] = fma52hi(res[127], a[61], a[65]); // Sum(126)
    res[127] = fma52lo(res[127], a[62], a[65]); // Sum(127)
    res[128] = fma52hi(res[128], a[62], a[65]); // Sum(127)
    res[128] = fma52lo(res[128], a[63], a[65]); // Sum(128)
    res[129] = fma52hi(res[129], a[63], a[65]); // Sum(128)
    res[129] = fma52lo(res[129], a[64], a[65]); // Sum(129)
    res[130] = fma52hi(res[130], a[64], a[65]); // Sum(129)
    res[120] = fma52lo(res[120], a[54], a[66]); // Sum(120)
    res[121] = fma52hi(res[121], a[54], a[66]); // Sum(120)
    res[121] = fma52lo(res[121], a[55], a[66]); // Sum(121)
    res[122] = fma52hi(res[122], a[55], a[66]); // Sum(121)
    res[122] = fma52lo(res[122], a[56], a[66]); // Sum(122)
    res[123] = fma52hi(res[123], a[56], a[66]); // Sum(122)
    res[123] = fma52lo(res[123], a[57], a[66]); // Sum(123)
    res[124] = fma52hi(res[124], a[57], a[66]); // Sum(123)
    res[124] = fma52lo(res[124], a[58], a[66]); // Sum(124)
    res[125] = fma52hi(res[125], a[58], a[66]); // Sum(124)
    res[125] = fma52lo(res[125], a[59], a[66]); // Sum(125)
    res[126] = fma52hi(res[126], a[59], a[66]); // Sum(125)
    res[126] = fma52lo(res[126], a[60], a[66]); // Sum(126)
    res[127] = fma52hi(res[127], a[60], a[66]); // Sum(126)
    res[127] = fma52lo(res[127], a[61], a[66]); // Sum(127)
    res[128] = fma52hi(res[128], a[61], a[66]); // Sum(127)
    res[128] = fma52lo(res[128], a[62], a[66]); // Sum(128)
    res[129] = fma52hi(res[129], a[62], a[66]); // Sum(128)
    res[129] = fma52lo(res[129], a[63], a[66]); // Sum(129)
    res[130] = fma52hi(res[130], a[63], a[66]); // Sum(129)
    res[130] = fma52lo(res[130], a[64], a[66]); // Sum(130)
    res[131] = fma52hi(res[131], a[64], a[66]); // Sum(130)
    res[131] = fma52lo(res[131], a[65], a[66]); // Sum(131)
    res[132] = fma52hi(res[132], a[65], a[66]); // Sum(131)
    res[120] = fma52lo(res[120], a[53], a[67]); // Sum(120)
    res[121] = fma52hi(res[121], a[53], a[67]); // Sum(120)
    res[121] = fma52lo(res[121], a[54], a[67]); // Sum(121)
    res[122] = fma52hi(res[122], a[54], a[67]); // Sum(121)
    res[122] = fma52lo(res[122], a[55], a[67]); // Sum(122)
    res[123] = fma52hi(res[123], a[55], a[67]); // Sum(122)
    res[123] = fma52lo(res[123], a[56], a[67]); // Sum(123)
    res[124] = fma52hi(res[124], a[56], a[67]); // Sum(123)
    res[124] = fma52lo(res[124], a[57], a[67]); // Sum(124)
    res[125] = fma52hi(res[125], a[57], a[67]); // Sum(124)
    res[125] = fma52lo(res[125], a[58], a[67]); // Sum(125)
    res[126] = fma52hi(res[126], a[58], a[67]); // Sum(125)
    res[126] = fma52lo(res[126], a[59], a[67]); // Sum(126)
    res[127] = fma52hi(res[127], a[59], a[67]); // Sum(126)
    res[127] = fma52lo(res[127], a[60], a[67]); // Sum(127)
    res[128] = fma52hi(res[128], a[60], a[67]); // Sum(127)
    res[128] = fma52lo(res[128], a[61], a[67]); // Sum(128)
    res[129] = fma52hi(res[129], a[61], a[67]); // Sum(128)
    res[129] = fma52lo(res[129], a[62], a[67]); // Sum(129)
    res[130] = fma52hi(res[130], a[62], a[67]); // Sum(129)
    res[130] = fma52lo(res[130], a[63], a[67]); // Sum(130)
    res[131] = fma52hi(res[131], a[63], a[67]); // Sum(130)
    res[131] = fma52lo(res[131], a[64], a[67]); // Sum(131)
    res[132] = fma52hi(res[132], a[64], a[67]); // Sum(131)
    res[120] = fma52lo(res[120], a[52], a[68]); // Sum(120)
    res[121] = fma52hi(res[121], a[52], a[68]); // Sum(120)
    res[121] = fma52lo(res[121], a[53], a[68]); // Sum(121)
    res[122] = fma52hi(res[122], a[53], a[68]); // Sum(121)
    res[122] = fma52lo(res[122], a[54], a[68]); // Sum(122)
    res[123] = fma52hi(res[123], a[54], a[68]); // Sum(122)
    res[123] = fma52lo(res[123], a[55], a[68]); // Sum(123)
    res[124] = fma52hi(res[124], a[55], a[68]); // Sum(123)
    res[124] = fma52lo(res[124], a[56], a[68]); // Sum(124)
    res[125] = fma52hi(res[125], a[56], a[68]); // Sum(124)
    res[125] = fma52lo(res[125], a[57], a[68]); // Sum(125)
    res[126] = fma52hi(res[126], a[57], a[68]); // Sum(125)
    res[126] = fma52lo(res[126], a[58], a[68]); // Sum(126)
    res[127] = fma52hi(res[127], a[58], a[68]); // Sum(126)
    res[127] = fma52lo(res[127], a[59], a[68]); // Sum(127)
    res[128] = fma52hi(res[128], a[59], a[68]); // Sum(127)
    res[128] = fma52lo(res[128], a[60], a[68]); // Sum(128)
    res[129] = fma52hi(res[129], a[60], a[68]); // Sum(128)
    res[129] = fma52lo(res[129], a[61], a[68]); // Sum(129)
    res[130] = fma52hi(res[130], a[61], a[68]); // Sum(129)
    res[130] = fma52lo(res[130], a[62], a[68]); // Sum(130)
    res[131] = fma52hi(res[131], a[62], a[68]); // Sum(130)
    res[131] = fma52lo(res[131], a[63], a[68]); // Sum(131)
    res[132] = fma52hi(res[132], a[63], a[68]); // Sum(131)
    res[120] = fma52lo(res[120], a[51], a[69]); // Sum(120)
    res[121] = fma52hi(res[121], a[51], a[69]); // Sum(120)
    res[121] = fma52lo(res[121], a[52], a[69]); // Sum(121)
    res[122] = fma52hi(res[122], a[52], a[69]); // Sum(121)
    res[122] = fma52lo(res[122], a[53], a[69]); // Sum(122)
    res[123] = fma52hi(res[123], a[53], a[69]); // Sum(122)
    res[123] = fma52lo(res[123], a[54], a[69]); // Sum(123)
    res[124] = fma52hi(res[124], a[54], a[69]); // Sum(123)
    res[124] = fma52lo(res[124], a[55], a[69]); // Sum(124)
    res[125] = fma52hi(res[125], a[55], a[69]); // Sum(124)
    res[125] = fma52lo(res[125], a[56], a[69]); // Sum(125)
    res[126] = fma52hi(res[126], a[56], a[69]); // Sum(125)
    res[126] = fma52lo(res[126], a[57], a[69]); // Sum(126)
    res[127] = fma52hi(res[127], a[57], a[69]); // Sum(126)
    res[127] = fma52lo(res[127], a[58], a[69]); // Sum(127)
    res[128] = fma52hi(res[128], a[58], a[69]); // Sum(127)
    res[128] = fma52lo(res[128], a[59], a[69]); // Sum(128)
    res[129] = fma52hi(res[129], a[59], a[69]); // Sum(128)
    res[129] = fma52lo(res[129], a[60], a[69]); // Sum(129)
    res[130] = fma52hi(res[130], a[60], a[69]); // Sum(129)
    res[130] = fma52lo(res[130], a[61], a[69]); // Sum(130)
    res[131] = fma52hi(res[131], a[61], a[69]); // Sum(130)
    res[131] = fma52lo(res[131], a[62], a[69]); // Sum(131)
    res[132] = fma52hi(res[132], a[62], a[69]); // Sum(131)
    res[120] = fma52lo(res[120], a[50], a[70]); // Sum(120)
    res[121] = fma52hi(res[121], a[50], a[70]); // Sum(120)
    res[121] = fma52lo(res[121], a[51], a[70]); // Sum(121)
    res[122] = fma52hi(res[122], a[51], a[70]); // Sum(121)
    res[122] = fma52lo(res[122], a[52], a[70]); // Sum(122)
    res[123] = fma52hi(res[123], a[52], a[70]); // Sum(122)
    res[123] = fma52lo(res[123], a[53], a[70]); // Sum(123)
    res[124] = fma52hi(res[124], a[53], a[70]); // Sum(123)
    res[124] = fma52lo(res[124], a[54], a[70]); // Sum(124)
    res[125] = fma52hi(res[125], a[54], a[70]); // Sum(124)
    res[125] = fma52lo(res[125], a[55], a[70]); // Sum(125)
    res[126] = fma52hi(res[126], a[55], a[70]); // Sum(125)
    res[126] = fma52lo(res[126], a[56], a[70]); // Sum(126)
    res[127] = fma52hi(res[127], a[56], a[70]); // Sum(126)
    res[127] = fma52lo(res[127], a[57], a[70]); // Sum(127)
    res[128] = fma52hi(res[128], a[57], a[70]); // Sum(127)
    res[128] = fma52lo(res[128], a[58], a[70]); // Sum(128)
    res[129] = fma52hi(res[129], a[58], a[70]); // Sum(128)
    res[129] = fma52lo(res[129], a[59], a[70]); // Sum(129)
    res[130] = fma52hi(res[130], a[59], a[70]); // Sum(129)
    res[130] = fma52lo(res[130], a[60], a[70]); // Sum(130)
    res[131] = fma52hi(res[131], a[60], a[70]); // Sum(130)
    res[131] = fma52lo(res[131], a[61], a[70]); // Sum(131)
    res[132] = fma52hi(res[132], a[61], a[70]); // Sum(131)
    res[120] = fma52lo(res[120], a[49], a[71]); // Sum(120)
    res[121] = fma52hi(res[121], a[49], a[71]); // Sum(120)
    res[121] = fma52lo(res[121], a[50], a[71]); // Sum(121)
    res[122] = fma52hi(res[122], a[50], a[71]); // Sum(121)
    res[122] = fma52lo(res[122], a[51], a[71]); // Sum(122)
    res[123] = fma52hi(res[123], a[51], a[71]); // Sum(122)
    res[123] = fma52lo(res[123], a[52], a[71]); // Sum(123)
    res[124] = fma52hi(res[124], a[52], a[71]); // Sum(123)
    res[124] = fma52lo(res[124], a[53], a[71]); // Sum(124)
    res[125] = fma52hi(res[125], a[53], a[71]); // Sum(124)
    res[125] = fma52lo(res[125], a[54], a[71]); // Sum(125)
    res[126] = fma52hi(res[126], a[54], a[71]); // Sum(125)
    res[126] = fma52lo(res[126], a[55], a[71]); // Sum(126)
    res[127] = fma52hi(res[127], a[55], a[71]); // Sum(126)
    res[127] = fma52lo(res[127], a[56], a[71]); // Sum(127)
    res[128] = fma52hi(res[128], a[56], a[71]); // Sum(127)
    res[128] = fma52lo(res[128], a[57], a[71]); // Sum(128)
    res[129] = fma52hi(res[129], a[57], a[71]); // Sum(128)
    res[129] = fma52lo(res[129], a[58], a[71]); // Sum(129)
    res[130] = fma52hi(res[130], a[58], a[71]); // Sum(129)
    res[130] = fma52lo(res[130], a[59], a[71]); // Sum(130)
    res[131] = fma52hi(res[131], a[59], a[71]); // Sum(130)
    res[131] = fma52lo(res[131], a[60], a[71]); // Sum(131)
    res[132] = fma52hi(res[132], a[60], a[71]); // Sum(131)
    res[120] = fma52lo(res[120], a[48], a[72]); // Sum(120)
    res[121] = fma52hi(res[121], a[48], a[72]); // Sum(120)
    res[121] = fma52lo(res[121], a[49], a[72]); // Sum(121)
    res[122] = fma52hi(res[122], a[49], a[72]); // Sum(121)
    res[122] = fma52lo(res[122], a[50], a[72]); // Sum(122)
    res[123] = fma52hi(res[123], a[50], a[72]); // Sum(122)
    res[123] = fma52lo(res[123], a[51], a[72]); // Sum(123)
    res[124] = fma52hi(res[124], a[51], a[72]); // Sum(123)
    res[124] = fma52lo(res[124], a[52], a[72]); // Sum(124)
    res[125] = fma52hi(res[125], a[52], a[72]); // Sum(124)
    res[125] = fma52lo(res[125], a[53], a[72]); // Sum(125)
    res[126] = fma52hi(res[126], a[53], a[72]); // Sum(125)
    res[126] = fma52lo(res[126], a[54], a[72]); // Sum(126)
    res[127] = fma52hi(res[127], a[54], a[72]); // Sum(126)
    res[127] = fma52lo(res[127], a[55], a[72]); // Sum(127)
    res[128] = fma52hi(res[128], a[55], a[72]); // Sum(127)
    res[128] = fma52lo(res[128], a[56], a[72]); // Sum(128)
    res[129] = fma52hi(res[129], a[56], a[72]); // Sum(128)
    res[129] = fma52lo(res[129], a[57], a[72]); // Sum(129)
    res[130] = fma52hi(res[130], a[57], a[72]); // Sum(129)
    res[130] = fma52lo(res[130], a[58], a[72]); // Sum(130)
    res[131] = fma52hi(res[131], a[58], a[72]); // Sum(130)
    res[131] = fma52lo(res[131], a[59], a[72]); // Sum(131)
    res[132] = fma52hi(res[132], a[59], a[72]); // Sum(131)
    res[120] = fma52lo(res[120], a[47], a[73]); // Sum(120)
    res[121] = fma52hi(res[121], a[47], a[73]); // Sum(120)
    res[121] = fma52lo(res[121], a[48], a[73]); // Sum(121)
    res[122] = fma52hi(res[122], a[48], a[73]); // Sum(121)
    res[122] = fma52lo(res[122], a[49], a[73]); // Sum(122)
    res[123] = fma52hi(res[123], a[49], a[73]); // Sum(122)
    res[123] = fma52lo(res[123], a[50], a[73]); // Sum(123)
    res[124] = fma52hi(res[124], a[50], a[73]); // Sum(123)
    res[124] = fma52lo(res[124], a[51], a[73]); // Sum(124)
    res[125] = fma52hi(res[125], a[51], a[73]); // Sum(124)
    res[125] = fma52lo(res[125], a[52], a[73]); // Sum(125)
    res[126] = fma52hi(res[126], a[52], a[73]); // Sum(125)
    res[126] = fma52lo(res[126], a[53], a[73]); // Sum(126)
    res[127] = fma52hi(res[127], a[53], a[73]); // Sum(126)
    res[127] = fma52lo(res[127], a[54], a[73]); // Sum(127)
    res[128] = fma52hi(res[128], a[54], a[73]); // Sum(127)
    res[128] = fma52lo(res[128], a[55], a[73]); // Sum(128)
    res[129] = fma52hi(res[129], a[55], a[73]); // Sum(128)
    res[129] = fma52lo(res[129], a[56], a[73]); // Sum(129)
    res[130] = fma52hi(res[130], a[56], a[73]); // Sum(129)
    res[130] = fma52lo(res[130], a[57], a[73]); // Sum(130)
    res[131] = fma52hi(res[131], a[57], a[73]); // Sum(130)
    res[131] = fma52lo(res[131], a[58], a[73]); // Sum(131)
    res[132] = fma52hi(res[132], a[58], a[73]); // Sum(131)
    res[120] = fma52lo(res[120], a[46], a[74]); // Sum(120)
    res[121] = fma52hi(res[121], a[46], a[74]); // Sum(120)
    res[121] = fma52lo(res[121], a[47], a[74]); // Sum(121)
    res[122] = fma52hi(res[122], a[47], a[74]); // Sum(121)
    res[122] = fma52lo(res[122], a[48], a[74]); // Sum(122)
    res[123] = fma52hi(res[123], a[48], a[74]); // Sum(122)
    res[123] = fma52lo(res[123], a[49], a[74]); // Sum(123)
    res[124] = fma52hi(res[124], a[49], a[74]); // Sum(123)
    res[124] = fma52lo(res[124], a[50], a[74]); // Sum(124)
    res[125] = fma52hi(res[125], a[50], a[74]); // Sum(124)
    res[125] = fma52lo(res[125], a[51], a[74]); // Sum(125)
    res[126] = fma52hi(res[126], a[51], a[74]); // Sum(125)
    res[126] = fma52lo(res[126], a[52], a[74]); // Sum(126)
    res[127] = fma52hi(res[127], a[52], a[74]); // Sum(126)
    res[127] = fma52lo(res[127], a[53], a[74]); // Sum(127)
    res[128] = fma52hi(res[128], a[53], a[74]); // Sum(127)
    res[128] = fma52lo(res[128], a[54], a[74]); // Sum(128)
    res[129] = fma52hi(res[129], a[54], a[74]); // Sum(128)
    res[129] = fma52lo(res[129], a[55], a[74]); // Sum(129)
    res[130] = fma52hi(res[130], a[55], a[74]); // Sum(129)
    res[130] = fma52lo(res[130], a[56], a[74]); // Sum(130)
    res[131] = fma52hi(res[131], a[56], a[74]); // Sum(130)
    res[131] = fma52lo(res[131], a[57], a[74]); // Sum(131)
    res[132] = fma52hi(res[132], a[57], a[74]); // Sum(131)
    res[120] = fma52lo(res[120], a[45], a[75]); // Sum(120)
    res[121] = fma52hi(res[121], a[45], a[75]); // Sum(120)
    res[121] = fma52lo(res[121], a[46], a[75]); // Sum(121)
    res[122] = fma52hi(res[122], a[46], a[75]); // Sum(121)
    res[122] = fma52lo(res[122], a[47], a[75]); // Sum(122)
    res[123] = fma52hi(res[123], a[47], a[75]); // Sum(122)
    res[123] = fma52lo(res[123], a[48], a[75]); // Sum(123)
    res[124] = fma52hi(res[124], a[48], a[75]); // Sum(123)
    res[124] = fma52lo(res[124], a[49], a[75]); // Sum(124)
    res[125] = fma52hi(res[125], a[49], a[75]); // Sum(124)
    res[125] = fma52lo(res[125], a[50], a[75]); // Sum(125)
    res[126] = fma52hi(res[126], a[50], a[75]); // Sum(125)
    res[126] = fma52lo(res[126], a[51], a[75]); // Sum(126)
    res[127] = fma52hi(res[127], a[51], a[75]); // Sum(126)
    res[127] = fma52lo(res[127], a[52], a[75]); // Sum(127)
    res[128] = fma52hi(res[128], a[52], a[75]); // Sum(127)
    res[128] = fma52lo(res[128], a[53], a[75]); // Sum(128)
    res[129] = fma52hi(res[129], a[53], a[75]); // Sum(128)
    res[129] = fma52lo(res[129], a[54], a[75]); // Sum(129)
    res[130] = fma52hi(res[130], a[54], a[75]); // Sum(129)
    res[130] = fma52lo(res[130], a[55], a[75]); // Sum(130)
    res[131] = fma52hi(res[131], a[55], a[75]); // Sum(130)
    res[131] = fma52lo(res[131], a[56], a[75]); // Sum(131)
    res[132] = fma52hi(res[132], a[56], a[75]); // Sum(131)
    res[120] = fma52lo(res[120], a[44], a[76]); // Sum(120)
    res[121] = fma52hi(res[121], a[44], a[76]); // Sum(120)
    res[121] = fma52lo(res[121], a[45], a[76]); // Sum(121)
    res[122] = fma52hi(res[122], a[45], a[76]); // Sum(121)
    res[122] = fma52lo(res[122], a[46], a[76]); // Sum(122)
    res[123] = fma52hi(res[123], a[46], a[76]); // Sum(122)
    res[123] = fma52lo(res[123], a[47], a[76]); // Sum(123)
    res[124] = fma52hi(res[124], a[47], a[76]); // Sum(123)
    res[124] = fma52lo(res[124], a[48], a[76]); // Sum(124)
    res[125] = fma52hi(res[125], a[48], a[76]); // Sum(124)
    res[125] = fma52lo(res[125], a[49], a[76]); // Sum(125)
    res[126] = fma52hi(res[126], a[49], a[76]); // Sum(125)
    res[126] = fma52lo(res[126], a[50], a[76]); // Sum(126)
    res[127] = fma52hi(res[127], a[50], a[76]); // Sum(126)
    res[127] = fma52lo(res[127], a[51], a[76]); // Sum(127)
    res[128] = fma52hi(res[128], a[51], a[76]); // Sum(127)
    res[128] = fma52lo(res[128], a[52], a[76]); // Sum(128)
    res[129] = fma52hi(res[129], a[52], a[76]); // Sum(128)
    res[129] = fma52lo(res[129], a[53], a[76]); // Sum(129)
    res[130] = fma52hi(res[130], a[53], a[76]); // Sum(129)
    res[130] = fma52lo(res[130], a[54], a[76]); // Sum(130)
    res[131] = fma52hi(res[131], a[54], a[76]); // Sum(130)
    res[131] = fma52lo(res[131], a[55], a[76]); // Sum(131)
    res[132] = fma52hi(res[132], a[55], a[76]); // Sum(131)
    res[120] = fma52lo(res[120], a[43], a[77]); // Sum(120)
    res[121] = fma52hi(res[121], a[43], a[77]); // Sum(120)
    res[121] = fma52lo(res[121], a[44], a[77]); // Sum(121)
    res[122] = fma52hi(res[122], a[44], a[77]); // Sum(121)
    res[122] = fma52lo(res[122], a[45], a[77]); // Sum(122)
    res[123] = fma52hi(res[123], a[45], a[77]); // Sum(122)
    res[123] = fma52lo(res[123], a[46], a[77]); // Sum(123)
    res[124] = fma52hi(res[124], a[46], a[77]); // Sum(123)
    res[124] = fma52lo(res[124], a[47], a[77]); // Sum(124)
    res[125] = fma52hi(res[125], a[47], a[77]); // Sum(124)
    res[125] = fma52lo(res[125], a[48], a[77]); // Sum(125)
    res[126] = fma52hi(res[126], a[48], a[77]); // Sum(125)
    res[126] = fma52lo(res[126], a[49], a[77]); // Sum(126)
    res[127] = fma52hi(res[127], a[49], a[77]); // Sum(126)
    res[127] = fma52lo(res[127], a[50], a[77]); // Sum(127)
    res[128] = fma52hi(res[128], a[50], a[77]); // Sum(127)
    res[128] = fma52lo(res[128], a[51], a[77]); // Sum(128)
    res[129] = fma52hi(res[129], a[51], a[77]); // Sum(128)
    res[129] = fma52lo(res[129], a[52], a[77]); // Sum(129)
    res[130] = fma52hi(res[130], a[52], a[77]); // Sum(129)
    res[130] = fma52lo(res[130], a[53], a[77]); // Sum(130)
    res[131] = fma52hi(res[131], a[53], a[77]); // Sum(130)
    res[131] = fma52lo(res[131], a[54], a[77]); // Sum(131)
    res[132] = fma52hi(res[132], a[54], a[77]); // Sum(131)
    res[120] = fma52lo(res[120], a[42], a[78]); // Sum(120)
    res[121] = fma52hi(res[121], a[42], a[78]); // Sum(120)
    res[121] = fma52lo(res[121], a[43], a[78]); // Sum(121)
    res[122] = fma52hi(res[122], a[43], a[78]); // Sum(121)
    res[122] = fma52lo(res[122], a[44], a[78]); // Sum(122)
    res[123] = fma52hi(res[123], a[44], a[78]); // Sum(122)
    res[123] = fma52lo(res[123], a[45], a[78]); // Sum(123)
    res[124] = fma52hi(res[124], a[45], a[78]); // Sum(123)
    res[124] = fma52lo(res[124], a[46], a[78]); // Sum(124)
    res[125] = fma52hi(res[125], a[46], a[78]); // Sum(124)
    res[125] = fma52lo(res[125], a[47], a[78]); // Sum(125)
    res[126] = fma52hi(res[126], a[47], a[78]); // Sum(125)
    res[126] = fma52lo(res[126], a[48], a[78]); // Sum(126)
    res[127] = fma52hi(res[127], a[48], a[78]); // Sum(126)
    res[127] = fma52lo(res[127], a[49], a[78]); // Sum(127)
    res[128] = fma52hi(res[128], a[49], a[78]); // Sum(127)
    res[128] = fma52lo(res[128], a[50], a[78]); // Sum(128)
    res[129] = fma52hi(res[129], a[50], a[78]); // Sum(128)
    res[129] = fma52lo(res[129], a[51], a[78]); // Sum(129)
    res[130] = fma52hi(res[130], a[51], a[78]); // Sum(129)
    res[130] = fma52lo(res[130], a[52], a[78]); // Sum(130)
    res[131] = fma52hi(res[131], a[52], a[78]); // Sum(130)
    res[131] = fma52lo(res[131], a[53], a[78]); // Sum(131)
    res[132] = fma52hi(res[132], a[53], a[78]); // Sum(131)
    res[120] = add64(res[120], res[120]);       // Double(120)
    res[121] = add64(res[121], res[121]);       // Double(121)
    res[122] = add64(res[122], res[122]);       // Double(122)
    res[123] = add64(res[123], res[123]);       // Double(123)
    res[124] = add64(res[124], res[124]);       // Double(124)
    res[125] = add64(res[125], res[125]);       // Double(125)
    res[126] = add64(res[126], res[126]);       // Double(126)
    res[127] = add64(res[127], res[127]);       // Double(127)
    res[128] = add64(res[128], res[128]);       // Double(128)
    res[129] = add64(res[129], res[129]);       // Double(129)
    res[130] = add64(res[130], res[130]);       // Double(130)
    res[131] = add64(res[131], res[131]);       // Double(131)
    res[120] = fma52lo(res[120], a[60], a[60]); // Add sqr(120)
    res[121] = fma52hi(res[121], a[60], a[60]); // Add sqr(120)
    res[122] = fma52lo(res[122], a[61], a[61]); // Add sqr(122)
    res[123] = fma52hi(res[123], a[61], a[61]); // Add sqr(122)
    res[124] = fma52lo(res[124], a[62], a[62]); // Add sqr(124)
    res[125] = fma52hi(res[125], a[62], a[62]); // Add sqr(124)
    res[126] = fma52lo(res[126], a[63], a[63]); // Add sqr(126)
    res[127] = fma52hi(res[127], a[63], a[63]); // Add sqr(126)
    res[128] = fma52lo(res[128], a[64], a[64]); // Add sqr(128)
    res[129] = fma52hi(res[129], a[64], a[64]); // Add sqr(128)
    res[130] = fma52lo(res[130], a[65], a[65]); // Add sqr(130)
    res[131] = fma52hi(res[131], a[65], a[65]); // Add sqr(130)
    res[132] = fma52lo(res[132], a[65], a[67]); // Sum(132)
    res[133] = fma52hi(res[133], a[65], a[67]); // Sum(132)
    res[133] = fma52lo(res[133], a[66], a[67]); // Sum(133)
    res[134] = fma52hi(res[134], a[66], a[67]); // Sum(133)
    res[132] = fma52lo(res[132], a[64], a[68]); // Sum(132)
    res[133] = fma52hi(res[133], a[64], a[68]); // Sum(132)
    res[133] = fma52lo(res[133], a[65], a[68]); // Sum(133)
    res[134] = fma52hi(res[134], a[65], a[68]); // Sum(133)
    res[134] = fma52lo(res[134], a[66], a[68]); // Sum(134)
    res[135] = fma52hi(res[135], a[66], a[68]); // Sum(134)
    res[135] = fma52lo(res[135], a[67], a[68]); // Sum(135)
    res[136] = fma52hi(res[136], a[67], a[68]); // Sum(135)
    res[132] = fma52lo(res[132], a[63], a[69]); // Sum(132)
    res[133] = fma52hi(res[133], a[63], a[69]); // Sum(132)
    res[133] = fma52lo(res[133], a[64], a[69]); // Sum(133)
    res[134] = fma52hi(res[134], a[64], a[69]); // Sum(133)
    res[134] = fma52lo(res[134], a[65], a[69]); // Sum(134)
    res[135] = fma52hi(res[135], a[65], a[69]); // Sum(134)
    res[135] = fma52lo(res[135], a[66], a[69]); // Sum(135)
    res[136] = fma52hi(res[136], a[66], a[69]); // Sum(135)
    res[136] = fma52lo(res[136], a[67], a[69]); // Sum(136)
    res[137] = fma52hi(res[137], a[67], a[69]); // Sum(136)
    res[137] = fma52lo(res[137], a[68], a[69]); // Sum(137)
    res[138] = fma52hi(res[138], a[68], a[69]); // Sum(137)
    res[132] = fma52lo(res[132], a[62], a[70]); // Sum(132)
    res[133] = fma52hi(res[133], a[62], a[70]); // Sum(132)
    res[133] = fma52lo(res[133], a[63], a[70]); // Sum(133)
    res[134] = fma52hi(res[134], a[63], a[70]); // Sum(133)
    res[134] = fma52lo(res[134], a[64], a[70]); // Sum(134)
    res[135] = fma52hi(res[135], a[64], a[70]); // Sum(134)
    res[135] = fma52lo(res[135], a[65], a[70]); // Sum(135)
    res[136] = fma52hi(res[136], a[65], a[70]); // Sum(135)
    res[136] = fma52lo(res[136], a[66], a[70]); // Sum(136)
    res[137] = fma52hi(res[137], a[66], a[70]); // Sum(136)
    res[137] = fma52lo(res[137], a[67], a[70]); // Sum(137)
    res[138] = fma52hi(res[138], a[67], a[70]); // Sum(137)
    res[138] = fma52lo(res[138], a[68], a[70]); // Sum(138)
    res[139] = fma52hi(res[139], a[68], a[70]); // Sum(138)
    res[139] = fma52lo(res[139], a[69], a[70]); // Sum(139)
    res[140] = fma52hi(res[140], a[69], a[70]); // Sum(139)
    res[132] = fma52lo(res[132], a[61], a[71]); // Sum(132)
    res[133] = fma52hi(res[133], a[61], a[71]); // Sum(132)
    res[133] = fma52lo(res[133], a[62], a[71]); // Sum(133)
    res[134] = fma52hi(res[134], a[62], a[71]); // Sum(133)
    res[134] = fma52lo(res[134], a[63], a[71]); // Sum(134)
    res[135] = fma52hi(res[135], a[63], a[71]); // Sum(134)
    res[135] = fma52lo(res[135], a[64], a[71]); // Sum(135)
    res[136] = fma52hi(res[136], a[64], a[71]); // Sum(135)
    res[136] = fma52lo(res[136], a[65], a[71]); // Sum(136)
    res[137] = fma52hi(res[137], a[65], a[71]); // Sum(136)
    res[137] = fma52lo(res[137], a[66], a[71]); // Sum(137)
    res[138] = fma52hi(res[138], a[66], a[71]); // Sum(137)
    res[138] = fma52lo(res[138], a[67], a[71]); // Sum(138)
    res[139] = fma52hi(res[139], a[67], a[71]); // Sum(138)
    res[139] = fma52lo(res[139], a[68], a[71]); // Sum(139)
    res[140] = fma52hi(res[140], a[68], a[71]); // Sum(139)
    res[140] = fma52lo(res[140], a[69], a[71]); // Sum(140)
    res[141] = fma52hi(res[141], a[69], a[71]); // Sum(140)
    res[141] = fma52lo(res[141], a[70], a[71]); // Sum(141)
    res[142] = fma52hi(res[142], a[70], a[71]); // Sum(141)
    res[132] = fma52lo(res[132], a[60], a[72]); // Sum(132)
    res[133] = fma52hi(res[133], a[60], a[72]); // Sum(132)
    res[133] = fma52lo(res[133], a[61], a[72]); // Sum(133)
    res[134] = fma52hi(res[134], a[61], a[72]); // Sum(133)
    res[134] = fma52lo(res[134], a[62], a[72]); // Sum(134)
    res[135] = fma52hi(res[135], a[62], a[72]); // Sum(134)
    res[135] = fma52lo(res[135], a[63], a[72]); // Sum(135)
    res[136] = fma52hi(res[136], a[63], a[72]); // Sum(135)
    res[136] = fma52lo(res[136], a[64], a[72]); // Sum(136)
    res[137] = fma52hi(res[137], a[64], a[72]); // Sum(136)
    res[137] = fma52lo(res[137], a[65], a[72]); // Sum(137)
    res[138] = fma52hi(res[138], a[65], a[72]); // Sum(137)
    res[138] = fma52lo(res[138], a[66], a[72]); // Sum(138)
    res[139] = fma52hi(res[139], a[66], a[72]); // Sum(138)
    res[139] = fma52lo(res[139], a[67], a[72]); // Sum(139)
    res[140] = fma52hi(res[140], a[67], a[72]); // Sum(139)
    res[140] = fma52lo(res[140], a[68], a[72]); // Sum(140)
    res[141] = fma52hi(res[141], a[68], a[72]); // Sum(140)
    res[141] = fma52lo(res[141], a[69], a[72]); // Sum(141)
    res[142] = fma52hi(res[142], a[69], a[72]); // Sum(141)
    res[142] = fma52lo(res[142], a[70], a[72]); // Sum(142)
    res[143] = fma52hi(res[143], a[70], a[72]); // Sum(142)
    res[143] = fma52lo(res[143], a[71], a[72]); // Sum(143)
    res[144] = fma52hi(res[144], a[71], a[72]); // Sum(143)
    res[132] = fma52lo(res[132], a[59], a[73]); // Sum(132)
    res[133] = fma52hi(res[133], a[59], a[73]); // Sum(132)
    res[133] = fma52lo(res[133], a[60], a[73]); // Sum(133)
    res[134] = fma52hi(res[134], a[60], a[73]); // Sum(133)
    res[134] = fma52lo(res[134], a[61], a[73]); // Sum(134)
    res[135] = fma52hi(res[135], a[61], a[73]); // Sum(134)
    res[135] = fma52lo(res[135], a[62], a[73]); // Sum(135)
    res[136] = fma52hi(res[136], a[62], a[73]); // Sum(135)
    res[136] = fma52lo(res[136], a[63], a[73]); // Sum(136)
    res[137] = fma52hi(res[137], a[63], a[73]); // Sum(136)
    res[137] = fma52lo(res[137], a[64], a[73]); // Sum(137)
    res[138] = fma52hi(res[138], a[64], a[73]); // Sum(137)
    res[138] = fma52lo(res[138], a[65], a[73]); // Sum(138)
    res[139] = fma52hi(res[139], a[65], a[73]); // Sum(138)
    res[139] = fma52lo(res[139], a[66], a[73]); // Sum(139)
    res[140] = fma52hi(res[140], a[66], a[73]); // Sum(139)
    res[140] = fma52lo(res[140], a[67], a[73]); // Sum(140)
    res[141] = fma52hi(res[141], a[67], a[73]); // Sum(140)
    res[141] = fma52lo(res[141], a[68], a[73]); // Sum(141)
    res[142] = fma52hi(res[142], a[68], a[73]); // Sum(141)
    res[142] = fma52lo(res[142], a[69], a[73]); // Sum(142)
    res[143] = fma52hi(res[143], a[69], a[73]); // Sum(142)
    res[143] = fma52lo(res[143], a[70], a[73]); // Sum(143)
    res[144] = fma52hi(res[144], a[70], a[73]); // Sum(143)
    res[132] = fma52lo(res[132], a[58], a[74]); // Sum(132)
    res[133] = fma52hi(res[133], a[58], a[74]); // Sum(132)
    res[133] = fma52lo(res[133], a[59], a[74]); // Sum(133)
    res[134] = fma52hi(res[134], a[59], a[74]); // Sum(133)
    res[134] = fma52lo(res[134], a[60], a[74]); // Sum(134)
    res[135] = fma52hi(res[135], a[60], a[74]); // Sum(134)
    res[135] = fma52lo(res[135], a[61], a[74]); // Sum(135)
    res[136] = fma52hi(res[136], a[61], a[74]); // Sum(135)
    res[136] = fma52lo(res[136], a[62], a[74]); // Sum(136)
    res[137] = fma52hi(res[137], a[62], a[74]); // Sum(136)
    res[137] = fma52lo(res[137], a[63], a[74]); // Sum(137)
    res[138] = fma52hi(res[138], a[63], a[74]); // Sum(137)
    res[138] = fma52lo(res[138], a[64], a[74]); // Sum(138)
    res[139] = fma52hi(res[139], a[64], a[74]); // Sum(138)
    res[139] = fma52lo(res[139], a[65], a[74]); // Sum(139)
    res[140] = fma52hi(res[140], a[65], a[74]); // Sum(139)
    res[140] = fma52lo(res[140], a[66], a[74]); // Sum(140)
    res[141] = fma52hi(res[141], a[66], a[74]); // Sum(140)
    res[141] = fma52lo(res[141], a[67], a[74]); // Sum(141)
    res[142] = fma52hi(res[142], a[67], a[74]); // Sum(141)
    res[142] = fma52lo(res[142], a[68], a[74]); // Sum(142)
    res[143] = fma52hi(res[143], a[68], a[74]); // Sum(142)
    res[143] = fma52lo(res[143], a[69], a[74]); // Sum(143)
    res[144] = fma52hi(res[144], a[69], a[74]); // Sum(143)
    res[132] = fma52lo(res[132], a[57], a[75]); // Sum(132)
    res[133] = fma52hi(res[133], a[57], a[75]); // Sum(132)
    res[133] = fma52lo(res[133], a[58], a[75]); // Sum(133)
    res[134] = fma52hi(res[134], a[58], a[75]); // Sum(133)
    res[134] = fma52lo(res[134], a[59], a[75]); // Sum(134)
    res[135] = fma52hi(res[135], a[59], a[75]); // Sum(134)
    res[135] = fma52lo(res[135], a[60], a[75]); // Sum(135)
    res[136] = fma52hi(res[136], a[60], a[75]); // Sum(135)
    res[136] = fma52lo(res[136], a[61], a[75]); // Sum(136)
    res[137] = fma52hi(res[137], a[61], a[75]); // Sum(136)
    res[137] = fma52lo(res[137], a[62], a[75]); // Sum(137)
    res[138] = fma52hi(res[138], a[62], a[75]); // Sum(137)
    res[138] = fma52lo(res[138], a[63], a[75]); // Sum(138)
    res[139] = fma52hi(res[139], a[63], a[75]); // Sum(138)
    res[139] = fma52lo(res[139], a[64], a[75]); // Sum(139)
    res[140] = fma52hi(res[140], a[64], a[75]); // Sum(139)
    res[140] = fma52lo(res[140], a[65], a[75]); // Sum(140)
    res[141] = fma52hi(res[141], a[65], a[75]); // Sum(140)
    res[141] = fma52lo(res[141], a[66], a[75]); // Sum(141)
    res[142] = fma52hi(res[142], a[66], a[75]); // Sum(141)
    res[142] = fma52lo(res[142], a[67], a[75]); // Sum(142)
    res[143] = fma52hi(res[143], a[67], a[75]); // Sum(142)
    res[143] = fma52lo(res[143], a[68], a[75]); // Sum(143)
    res[144] = fma52hi(res[144], a[68], a[75]); // Sum(143)
    res[132] = fma52lo(res[132], a[56], a[76]); // Sum(132)
    res[133] = fma52hi(res[133], a[56], a[76]); // Sum(132)
    res[133] = fma52lo(res[133], a[57], a[76]); // Sum(133)
    res[134] = fma52hi(res[134], a[57], a[76]); // Sum(133)
    res[134] = fma52lo(res[134], a[58], a[76]); // Sum(134)
    res[135] = fma52hi(res[135], a[58], a[76]); // Sum(134)
    res[135] = fma52lo(res[135], a[59], a[76]); // Sum(135)
    res[136] = fma52hi(res[136], a[59], a[76]); // Sum(135)
    res[136] = fma52lo(res[136], a[60], a[76]); // Sum(136)
    res[137] = fma52hi(res[137], a[60], a[76]); // Sum(136)
    res[137] = fma52lo(res[137], a[61], a[76]); // Sum(137)
    res[138] = fma52hi(res[138], a[61], a[76]); // Sum(137)
    res[138] = fma52lo(res[138], a[62], a[76]); // Sum(138)
    res[139] = fma52hi(res[139], a[62], a[76]); // Sum(138)
    res[139] = fma52lo(res[139], a[63], a[76]); // Sum(139)
    res[140] = fma52hi(res[140], a[63], a[76]); // Sum(139)
    res[140] = fma52lo(res[140], a[64], a[76]); // Sum(140)
    res[141] = fma52hi(res[141], a[64], a[76]); // Sum(140)
    res[141] = fma52lo(res[141], a[65], a[76]); // Sum(141)
    res[142] = fma52hi(res[142], a[65], a[76]); // Sum(141)
    res[142] = fma52lo(res[142], a[66], a[76]); // Sum(142)
    res[143] = fma52hi(res[143], a[66], a[76]); // Sum(142)
    res[143] = fma52lo(res[143], a[67], a[76]); // Sum(143)
    res[144] = fma52hi(res[144], a[67], a[76]); // Sum(143)
    res[132] = fma52lo(res[132], a[55], a[77]); // Sum(132)
    res[133] = fma52hi(res[133], a[55], a[77]); // Sum(132)
    res[133] = fma52lo(res[133], a[56], a[77]); // Sum(133)
    res[134] = fma52hi(res[134], a[56], a[77]); // Sum(133)
    res[134] = fma52lo(res[134], a[57], a[77]); // Sum(134)
    res[135] = fma52hi(res[135], a[57], a[77]); // Sum(134)
    res[135] = fma52lo(res[135], a[58], a[77]); // Sum(135)
    res[136] = fma52hi(res[136], a[58], a[77]); // Sum(135)
    res[136] = fma52lo(res[136], a[59], a[77]); // Sum(136)
    res[137] = fma52hi(res[137], a[59], a[77]); // Sum(136)
    res[137] = fma52lo(res[137], a[60], a[77]); // Sum(137)
    res[138] = fma52hi(res[138], a[60], a[77]); // Sum(137)
    res[138] = fma52lo(res[138], a[61], a[77]); // Sum(138)
    res[139] = fma52hi(res[139], a[61], a[77]); // Sum(138)
    res[139] = fma52lo(res[139], a[62], a[77]); // Sum(139)
    res[140] = fma52hi(res[140], a[62], a[77]); // Sum(139)
    res[140] = fma52lo(res[140], a[63], a[77]); // Sum(140)
    res[141] = fma52hi(res[141], a[63], a[77]); // Sum(140)
    res[141] = fma52lo(res[141], a[64], a[77]); // Sum(141)
    res[142] = fma52hi(res[142], a[64], a[77]); // Sum(141)
    res[142] = fma52lo(res[142], a[65], a[77]); // Sum(142)
    res[143] = fma52hi(res[143], a[65], a[77]); // Sum(142)
    res[143] = fma52lo(res[143], a[66], a[77]); // Sum(143)
    res[144] = fma52hi(res[144], a[66], a[77]); // Sum(143)
    res[132] = fma52lo(res[132], a[54], a[78]); // Sum(132)
    res[133] = fma52hi(res[133], a[54], a[78]); // Sum(132)
    res[133] = fma52lo(res[133], a[55], a[78]); // Sum(133)
    res[134] = fma52hi(res[134], a[55], a[78]); // Sum(133)
    res[134] = fma52lo(res[134], a[56], a[78]); // Sum(134)
    res[135] = fma52hi(res[135], a[56], a[78]); // Sum(134)
    res[135] = fma52lo(res[135], a[57], a[78]); // Sum(135)
    res[136] = fma52hi(res[136], a[57], a[78]); // Sum(135)
    res[136] = fma52lo(res[136], a[58], a[78]); // Sum(136)
    res[137] = fma52hi(res[137], a[58], a[78]); // Sum(136)
    res[137] = fma52lo(res[137], a[59], a[78]); // Sum(137)
    res[138] = fma52hi(res[138], a[59], a[78]); // Sum(137)
    res[138] = fma52lo(res[138], a[60], a[78]); // Sum(138)
    res[139] = fma52hi(res[139], a[60], a[78]); // Sum(138)
    res[139] = fma52lo(res[139], a[61], a[78]); // Sum(139)
    res[140] = fma52hi(res[140], a[61], a[78]); // Sum(139)
    res[140] = fma52lo(res[140], a[62], a[78]); // Sum(140)
    res[141] = fma52hi(res[141], a[62], a[78]); // Sum(140)
    res[141] = fma52lo(res[141], a[63], a[78]); // Sum(141)
    res[142] = fma52hi(res[142], a[63], a[78]); // Sum(141)
    res[142] = fma52lo(res[142], a[64], a[78]); // Sum(142)
    res[143] = fma52hi(res[143], a[64], a[78]); // Sum(142)
    res[143] = fma52lo(res[143], a[65], a[78]); // Sum(143)
    res[144] = fma52hi(res[144], a[65], a[78]); // Sum(143)
    res[132] = add64(res[132], res[132]);       // Double(132)
    res[133] = add64(res[133], res[133]);       // Double(133)
    res[134] = add64(res[134], res[134]);       // Double(134)
    res[135] = add64(res[135], res[135]);       // Double(135)
    res[136] = add64(res[136], res[136]);       // Double(136)
    res[137] = add64(res[137], res[137]);       // Double(137)
    res[138] = add64(res[138], res[138]);       // Double(138)
    res[139] = add64(res[139], res[139]);       // Double(139)
    res[140] = add64(res[140], res[140]);       // Double(140)
    res[141] = add64(res[141], res[141]);       // Double(141)
    res[142] = add64(res[142], res[142]);       // Double(142)
    res[143] = add64(res[143], res[143]);       // Double(143)
    res[132] = fma52lo(res[132], a[66], a[66]); // Add sqr(132)
    res[133] = fma52hi(res[133], a[66], a[66]); // Add sqr(132)
    res[134] = fma52lo(res[134], a[67], a[67]); // Add sqr(134)
    res[135] = fma52hi(res[135], a[67], a[67]); // Add sqr(134)
    res[136] = fma52lo(res[136], a[68], a[68]); // Add sqr(136)
    res[137] = fma52hi(res[137], a[68], a[68]); // Add sqr(136)
    res[138] = fma52lo(res[138], a[69], a[69]); // Add sqr(138)
    res[139] = fma52hi(res[139], a[69], a[69]); // Add sqr(138)
    res[140] = fma52lo(res[140], a[70], a[70]); // Add sqr(140)
    res[141] = fma52hi(res[141], a[70], a[70]); // Add sqr(140)
    res[142] = fma52lo(res[142], a[71], a[71]); // Add sqr(142)
    res[143] = fma52hi(res[143], a[71], a[71]); // Add sqr(142)
    res[144] = fma52lo(res[144], a[71], a[73]); // Sum(144)
    res[145] = fma52hi(res[145], a[71], a[73]); // Sum(144)
    res[145] = fma52lo(res[145], a[72], a[73]); // Sum(145)
    res[146] = fma52hi(res[146], a[72], a[73]); // Sum(145)
    res[144] = fma52lo(res[144], a[70], a[74]); // Sum(144)
    res[145] = fma52hi(res[145], a[70], a[74]); // Sum(144)
    res[145] = fma52lo(res[145], a[71], a[74]); // Sum(145)
    res[146] = fma52hi(res[146], a[71], a[74]); // Sum(145)
    res[146] = fma52lo(res[146], a[72], a[74]); // Sum(146)
    res[147] = fma52hi(res[147], a[72], a[74]); // Sum(146)
    res[147] = fma52lo(res[147], a[73], a[74]); // Sum(147)
    res[148] = fma52hi(res[148], a[73], a[74]); // Sum(147)
    res[144] = fma52lo(res[144], a[69], a[75]); // Sum(144)
    res[145] = fma52hi(res[145], a[69], a[75]); // Sum(144)
    res[145] = fma52lo(res[145], a[70], a[75]); // Sum(145)
    res[146] = fma52hi(res[146], a[70], a[75]); // Sum(145)
    res[146] = fma52lo(res[146], a[71], a[75]); // Sum(146)
    res[147] = fma52hi(res[147], a[71], a[75]); // Sum(146)
    res[147] = fma52lo(res[147], a[72], a[75]); // Sum(147)
    res[148] = fma52hi(res[148], a[72], a[75]); // Sum(147)
    res[148] = fma52lo(res[148], a[73], a[75]); // Sum(148)
    res[149] = fma52hi(res[149], a[73], a[75]); // Sum(148)
    res[149] = fma52lo(res[149], a[74], a[75]); // Sum(149)
    res[150] = fma52hi(res[150], a[74], a[75]); // Sum(149)
    res[144] = fma52lo(res[144], a[68], a[76]); // Sum(144)
    res[145] = fma52hi(res[145], a[68], a[76]); // Sum(144)
    res[145] = fma52lo(res[145], a[69], a[76]); // Sum(145)
    res[146] = fma52hi(res[146], a[69], a[76]); // Sum(145)
    res[146] = fma52lo(res[146], a[70], a[76]); // Sum(146)
    res[147] = fma52hi(res[147], a[70], a[76]); // Sum(146)
    res[147] = fma52lo(res[147], a[71], a[76]); // Sum(147)
    res[148] = fma52hi(res[148], a[71], a[76]); // Sum(147)
    res[148] = fma52lo(res[148], a[72], a[76]); // Sum(148)
    res[149] = fma52hi(res[149], a[72], a[76]); // Sum(148)
    res[149] = fma52lo(res[149], a[73], a[76]); // Sum(149)
    res[150] = fma52hi(res[150], a[73], a[76]); // Sum(149)
    res[150] = fma52lo(res[150], a[74], a[76]); // Sum(150)
    res[151] = fma52hi(res[151], a[74], a[76]); // Sum(150)
    res[151] = fma52lo(res[151], a[75], a[76]); // Sum(151)
    res[152] = fma52hi(res[152], a[75], a[76]); // Sum(151)
    res[144] = fma52lo(res[144], a[67], a[77]); // Sum(144)
    res[145] = fma52hi(res[145], a[67], a[77]); // Sum(144)
    res[145] = fma52lo(res[145], a[68], a[77]); // Sum(145)
    res[146] = fma52hi(res[146], a[68], a[77]); // Sum(145)
    res[146] = fma52lo(res[146], a[69], a[77]); // Sum(146)
    res[147] = fma52hi(res[147], a[69], a[77]); // Sum(146)
    res[147] = fma52lo(res[147], a[70], a[77]); // Sum(147)
    res[148] = fma52hi(res[148], a[70], a[77]); // Sum(147)
    res[148] = fma52lo(res[148], a[71], a[77]); // Sum(148)
    res[149] = fma52hi(res[149], a[71], a[77]); // Sum(148)
    res[149] = fma52lo(res[149], a[72], a[77]); // Sum(149)
    res[150] = fma52hi(res[150], a[72], a[77]); // Sum(149)
    res[150] = fma52lo(res[150], a[73], a[77]); // Sum(150)
    res[151] = fma52hi(res[151], a[73], a[77]); // Sum(150)
    res[151] = fma52lo(res[151], a[74], a[77]); // Sum(151)
    res[152] = fma52hi(res[152], a[74], a[77]); // Sum(151)
    res[152] = fma52lo(res[152], a[75], a[77]); // Sum(152)
    res[153] = fma52hi(res[153], a[75], a[77]); // Sum(152)
    res[153] = fma52lo(res[153], a[76], a[77]); // Sum(153)
    res[154] = fma52hi(res[154], a[76], a[77]); // Sum(153)
    res[144] = fma52lo(res[144], a[66], a[78]); // Sum(144)
    res[145] = fma52hi(res[145], a[66], a[78]); // Sum(144)
    res[145] = fma52lo(res[145], a[67], a[78]); // Sum(145)
    res[146] = fma52hi(res[146], a[67], a[78]); // Sum(145)
    res[146] = fma52lo(res[146], a[68], a[78]); // Sum(146)
    res[147] = fma52hi(res[147], a[68], a[78]); // Sum(146)
    res[147] = fma52lo(res[147], a[69], a[78]); // Sum(147)
    res[148] = fma52hi(res[148], a[69], a[78]); // Sum(147)
    res[148] = fma52lo(res[148], a[70], a[78]); // Sum(148)
    res[149] = fma52hi(res[149], a[70], a[78]); // Sum(148)
    res[149] = fma52lo(res[149], a[71], a[78]); // Sum(149)
    res[150] = fma52hi(res[150], a[71], a[78]); // Sum(149)
    res[150] = fma52lo(res[150], a[72], a[78]); // Sum(150)
    res[151] = fma52hi(res[151], a[72], a[78]); // Sum(150)
    res[151] = fma52lo(res[151], a[73], a[78]); // Sum(151)
    res[152] = fma52hi(res[152], a[73], a[78]); // Sum(151)
    res[152] = fma52lo(res[152], a[74], a[78]); // Sum(152)
    res[153] = fma52hi(res[153], a[74], a[78]); // Sum(152)
    res[153] = fma52lo(res[153], a[75], a[78]); // Sum(153)
    res[154] = fma52hi(res[154], a[75], a[78]); // Sum(153)
    res[154] = fma52lo(res[154], a[76], a[78]); // Sum(154)
    res[155] = fma52hi(res[155], a[76], a[78]); // Sum(154)
    res[155] = fma52lo(res[155], a[77], a[78]); // Sum(155)
    res[156] = fma52hi(res[156], a[77], a[78]); // Sum(155)
    res[144] = add64(res[144], res[144]);       // Double(144)
    res[145] = add64(res[145], res[145]);       // Double(145)
    res[146] = add64(res[146], res[146]);       // Double(146)
    res[147] = add64(res[147], res[147]);       // Double(147)
    res[148] = add64(res[148], res[148]);       // Double(148)
    res[149] = add64(res[149], res[149]);       // Double(149)
    res[150] = add64(res[150], res[150]);       // Double(150)
    res[151] = add64(res[151], res[151]);       // Double(151)
    res[152] = add64(res[152], res[152]);       // Double(152)
    res[153] = add64(res[153], res[153]);       // Double(153)
    res[154] = add64(res[154], res[154]);       // Double(154)
    res[155] = add64(res[155], res[155]);       // Double(155)
    res[144] = fma52lo(res[144], a[72], a[72]); // Add sqr(144)
    res[145] = fma52hi(res[145], a[72], a[72]); // Add sqr(144)
    res[146] = fma52lo(res[146], a[73], a[73]); // Add sqr(146)
    res[147] = fma52hi(res[147], a[73], a[73]); // Add sqr(146)
    res[148] = fma52lo(res[148], a[74], a[74]); // Add sqr(148)
    res[149] = fma52hi(res[149], a[74], a[74]); // Add sqr(148)
    res[150] = fma52lo(res[150], a[75], a[75]); // Add sqr(150)
    res[151] = fma52hi(res[151], a[75], a[75]); // Add sqr(150)
    res[152] = fma52lo(res[152], a[76], a[76]); // Add sqr(152)
    res[153] = fma52hi(res[153], a[76], a[76]); // Add sqr(152)
    res[154] = fma52lo(res[154], a[77], a[77]); // Add sqr(154)
    res[155] = fma52hi(res[155], a[77], a[77]); // Add sqr(154)
    res[156] = add64(res[156], res[156]);       // Double(156)
    res[156] = fma52lo(res[156], a[78], a[78]); // Add sqr(156)
    res[157] = fma52hi(res[157], a[78], a[78]); // Add sqr(156)

    // Montgomery Reduction
    int it;
    for (it = 0; it < 80; it += 10) { // Reduction step
        int jt = 0;
        if ((it + 0) > 0)
            res[it + 0] = add64(res[it + 0], srli64(res[it + -1], DIGIT_SIZE));
        u[it + 0]         = mul52lo(res[it + 0], k);
        res[it + jt + 0]  = fma52lo(res[it + jt + 0], u[it + 0], m[jt + 0]);
        res[it + jt + 1]  = fma52hi(res[it + jt + 1], u[it + 0], m[jt + 0]);
        res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 0], m[jt + 1]);
        res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 0], m[jt + 1]);
        res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 0], m[jt + 2]);
        res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 0], m[jt + 2]);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 0], m[jt + 3]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 0], m[jt + 3]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 0], m[jt + 4]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 0], m[jt + 4]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 0], m[jt + 5]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 0], m[jt + 5]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 0], m[jt + 6]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 0], m[jt + 6]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 0], m[jt + 7]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 0], m[jt + 7]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 0], m[jt + 8]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 0], m[jt + 8]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 0], m[jt + 9]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 0], m[jt + 9]);
        res[it + 1]       = add64(res[it + 1], srli64(res[it + 0], DIGIT_SIZE));
        u[it + 1]         = mul52lo(res[it + 1], k);
        res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 1], m[jt + 0]);
        res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 1], m[jt + 0]);
        res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 1], m[jt + 1]);
        res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 1], m[jt + 1]);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 1], m[jt + 2]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 1], m[jt + 2]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 1], m[jt + 3]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 1], m[jt + 3]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 1], m[jt + 4]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 1], m[jt + 4]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 1], m[jt + 5]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 1], m[jt + 5]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 1], m[jt + 6]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 1], m[jt + 6]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 1], m[jt + 7]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 1], m[jt + 7]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 1], m[jt + 8]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 1], m[jt + 8]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 1], m[jt + 9]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 1], m[jt + 9]);
        res[it + 2]       = add64(res[it + 2], srli64(res[it + 1], DIGIT_SIZE));
        u[it + 2]         = mul52lo(res[it + 2], k);
        res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 2], m[jt + 0]);
        res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 2], m[jt + 0]);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 2], m[jt + 1]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 2], m[jt + 1]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 2], m[jt + 2]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 2], m[jt + 2]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 2], m[jt + 3]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 2], m[jt + 3]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 2], m[jt + 4]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 2], m[jt + 4]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 2], m[jt + 5]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 2], m[jt + 5]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 2], m[jt + 6]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 2], m[jt + 6]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 2], m[jt + 7]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 2], m[jt + 7]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 2], m[jt + 8]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 2], m[jt + 8]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 2], m[jt + 9]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 2], m[jt + 9]);
        res[it + 3]       = add64(res[it + 3], srli64(res[it + 2], DIGIT_SIZE));
        u[it + 3]         = mul52lo(res[it + 3], k);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 3], m[jt + 0]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 3], m[jt + 0]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 3], m[jt + 1]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 3], m[jt + 1]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 3], m[jt + 2]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 3], m[jt + 2]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 3], m[jt + 3]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 3], m[jt + 3]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 3], m[jt + 4]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 3], m[jt + 4]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 3], m[jt + 5]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 3], m[jt + 5]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 3], m[jt + 6]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 3], m[jt + 6]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 3], m[jt + 7]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 3], m[jt + 7]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 3], m[jt + 8]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 3], m[jt + 8]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 3], m[jt + 9]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 3], m[jt + 9]);
        res[it + 4]       = add64(res[it + 4], srli64(res[it + 3], DIGIT_SIZE));
        u[it + 4]         = mul52lo(res[it + 4], k);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 4], m[jt + 0]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 4], m[jt + 0]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 4], m[jt + 1]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 4], m[jt + 1]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 4], m[jt + 2]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 4], m[jt + 2]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 4], m[jt + 3]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 4], m[jt + 3]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 4], m[jt + 4]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 4], m[jt + 4]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 4], m[jt + 5]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 4], m[jt + 5]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 4], m[jt + 6]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 4], m[jt + 6]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 4], m[jt + 7]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 4], m[jt + 7]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 4], m[jt + 8]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 4], m[jt + 8]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 4], m[jt + 9]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 4], m[jt + 9]);
        res[it + 5]       = add64(res[it + 5], srli64(res[it + 4], DIGIT_SIZE));
        u[it + 5]         = mul52lo(res[it + 5], k);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 5], m[jt + 0]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 5], m[jt + 0]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 5], m[jt + 1]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 5], m[jt + 1]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 5], m[jt + 2]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 5], m[jt + 2]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 5], m[jt + 3]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 5], m[jt + 3]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 5], m[jt + 4]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 5], m[jt + 4]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 5], m[jt + 5]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 5], m[jt + 5]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 5], m[jt + 6]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 5], m[jt + 6]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 5], m[jt + 7]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 5], m[jt + 7]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 5], m[jt + 8]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 5], m[jt + 8]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 5], m[jt + 9]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 5], m[jt + 9]);
        res[it + 6]       = add64(res[it + 6], srli64(res[it + 5], DIGIT_SIZE));
        u[it + 6]         = mul52lo(res[it + 6], k);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 6], m[jt + 0]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 6], m[jt + 0]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 6], m[jt + 1]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 6], m[jt + 1]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 6], m[jt + 2]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 6], m[jt + 2]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 6], m[jt + 3]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 6], m[jt + 3]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 6], m[jt + 4]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 6], m[jt + 4]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 6], m[jt + 5]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 6], m[jt + 5]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 6], m[jt + 6]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 6], m[jt + 6]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 6], m[jt + 7]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 6], m[jt + 7]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 6], m[jt + 8]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 6], m[jt + 8]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 6], m[jt + 9]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 6], m[jt + 9]);
        res[it + 7]       = add64(res[it + 7], srli64(res[it + 6], DIGIT_SIZE));
        u[it + 7]         = mul52lo(res[it + 7], k);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 7], m[jt + 0]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 7], m[jt + 0]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 7], m[jt + 1]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 7], m[jt + 1]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 7], m[jt + 2]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 7], m[jt + 2]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 7], m[jt + 3]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 7], m[jt + 3]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 7], m[jt + 4]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 7], m[jt + 4]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 7], m[jt + 5]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 7], m[jt + 5]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 7], m[jt + 6]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 7], m[jt + 6]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 7], m[jt + 7]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 7], m[jt + 7]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 7], m[jt + 8]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 7], m[jt + 8]);
        res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 7], m[jt + 9]);
        res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 7], m[jt + 9]);
        res[it + 8]       = add64(res[it + 8], srli64(res[it + 7], DIGIT_SIZE));
        u[it + 8]         = mul52lo(res[it + 8], k);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 8], m[jt + 0]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 8], m[jt + 0]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 8], m[jt + 1]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 8], m[jt + 1]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 8], m[jt + 2]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 8], m[jt + 2]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 8], m[jt + 3]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 8], m[jt + 3]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 8], m[jt + 4]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 8], m[jt + 4]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 8], m[jt + 5]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 8], m[jt + 5]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 8], m[jt + 6]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 8], m[jt + 6]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 8], m[jt + 7]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 8], m[jt + 7]);
        res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 8], m[jt + 8]);
        res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 8], m[jt + 8]);
        res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 8], m[jt + 9]);
        res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 8], m[jt + 9]);
        res[it + 9]       = add64(res[it + 9], srli64(res[it + 8], DIGIT_SIZE));
        u[it + 9]         = (it + 9 < 79) ? mul52lo(res[it + 9], k) : get_zero64();
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 9], m[jt + 0]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 9], m[jt + 0]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 9], m[jt + 1]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 9], m[jt + 1]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 9], m[jt + 2]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 9], m[jt + 2]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 9], m[jt + 3]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 9], m[jt + 3]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 9], m[jt + 4]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 9], m[jt + 4]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 9], m[jt + 5]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 9], m[jt + 5]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 9], m[jt + 6]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 9], m[jt + 6]);
        res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 9], m[jt + 7]);
        res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 9], m[jt + 7]);
        res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 9], m[jt + 8]);
        res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 9], m[jt + 8]);
        res[it + jt + 18] = fma52lo(res[it + jt + 18], u[it + 9], m[jt + 9]);
        res[it + jt + 19] = fma52hi(res[it + jt + 19], u[it + 9], m[jt + 9]);

        for (jt = 10; jt < 80; jt += 10) { // Poly tile
            res[it + jt + 0]  = fma52lo(res[it + jt + 0], u[it + 0], m[jt + 0]);
            res[it + jt + 1]  = fma52hi(res[it + jt + 1], u[it + 0], m[jt + 0]);
            res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 0], m[jt + 1]);
            res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 0], m[jt + 1]);
            res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 0], m[jt + 2]);
            res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 0], m[jt + 2]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 0], m[jt + 3]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 0], m[jt + 3]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 0], m[jt + 4]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 0], m[jt + 4]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 0], m[jt + 5]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 0], m[jt + 5]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 0], m[jt + 6]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 0], m[jt + 6]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 0], m[jt + 7]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 0], m[jt + 7]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 0], m[jt + 8]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 0], m[jt + 8]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 0], m[jt + 9]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 0], m[jt + 9]);
            res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 1], m[jt + 0]);
            res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 1], m[jt + 0]);
            res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 1], m[jt + 1]);
            res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 1], m[jt + 1]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 1], m[jt + 2]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 1], m[jt + 2]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 1], m[jt + 3]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 1], m[jt + 3]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 1], m[jt + 4]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 1], m[jt + 4]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 1], m[jt + 5]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 1], m[jt + 5]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 1], m[jt + 6]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 1], m[jt + 6]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 1], m[jt + 7]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 1], m[jt + 7]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 1], m[jt + 8]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 1], m[jt + 8]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 1], m[jt + 9]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 1], m[jt + 9]);
            res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 2], m[jt + 0]);
            res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 2], m[jt + 0]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 2], m[jt + 1]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 2], m[jt + 1]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 2], m[jt + 2]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 2], m[jt + 2]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 2], m[jt + 3]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 2], m[jt + 3]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 2], m[jt + 4]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 2], m[jt + 4]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 2], m[jt + 5]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 2], m[jt + 5]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 2], m[jt + 6]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 2], m[jt + 6]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 2], m[jt + 7]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 2], m[jt + 7]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 2], m[jt + 8]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 2], m[jt + 8]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 2], m[jt + 9]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 2], m[jt + 9]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 3], m[jt + 0]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 3], m[jt + 0]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 3], m[jt + 1]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 3], m[jt + 1]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 3], m[jt + 2]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 3], m[jt + 2]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 3], m[jt + 3]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 3], m[jt + 3]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 3], m[jt + 4]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 3], m[jt + 4]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 3], m[jt + 5]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 3], m[jt + 5]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 3], m[jt + 6]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 3], m[jt + 6]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 3], m[jt + 7]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 3], m[jt + 7]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 3], m[jt + 8]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 3], m[jt + 8]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 3], m[jt + 9]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 3], m[jt + 9]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 4], m[jt + 0]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 4], m[jt + 0]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 4], m[jt + 1]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 4], m[jt + 1]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 4], m[jt + 2]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 4], m[jt + 2]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 4], m[jt + 3]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 4], m[jt + 3]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 4], m[jt + 4]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 4], m[jt + 4]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 4], m[jt + 5]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 4], m[jt + 5]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 4], m[jt + 6]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 4], m[jt + 6]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 4], m[jt + 7]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 4], m[jt + 7]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 4], m[jt + 8]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 4], m[jt + 8]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 4], m[jt + 9]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 4], m[jt + 9]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 5], m[jt + 0]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 5], m[jt + 0]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 5], m[jt + 1]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 5], m[jt + 1]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 5], m[jt + 2]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 5], m[jt + 2]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 5], m[jt + 3]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 5], m[jt + 3]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 5], m[jt + 4]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 5], m[jt + 4]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 5], m[jt + 5]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 5], m[jt + 5]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 5], m[jt + 6]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 5], m[jt + 6]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 5], m[jt + 7]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 5], m[jt + 7]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 5], m[jt + 8]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 5], m[jt + 8]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 5], m[jt + 9]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 5], m[jt + 9]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 6], m[jt + 0]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 6], m[jt + 0]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 6], m[jt + 1]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 6], m[jt + 1]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 6], m[jt + 2]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 6], m[jt + 2]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 6], m[jt + 3]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 6], m[jt + 3]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 6], m[jt + 4]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 6], m[jt + 4]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 6], m[jt + 5]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 6], m[jt + 5]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 6], m[jt + 6]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 6], m[jt + 6]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 6], m[jt + 7]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 6], m[jt + 7]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 6], m[jt + 8]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 6], m[jt + 8]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 6], m[jt + 9]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 6], m[jt + 9]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 7], m[jt + 0]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 7], m[jt + 0]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 7], m[jt + 1]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 7], m[jt + 1]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 7], m[jt + 2]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 7], m[jt + 2]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 7], m[jt + 3]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 7], m[jt + 3]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 7], m[jt + 4]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 7], m[jt + 4]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 7], m[jt + 5]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 7], m[jt + 5]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 7], m[jt + 6]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 7], m[jt + 6]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 7], m[jt + 7]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 7], m[jt + 7]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 7], m[jt + 8]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 7], m[jt + 8]);
            res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 7], m[jt + 9]);
            res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 7], m[jt + 9]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 8], m[jt + 0]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 8], m[jt + 0]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 8], m[jt + 1]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 8], m[jt + 1]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 8], m[jt + 2]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 8], m[jt + 2]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 8], m[jt + 3]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 8], m[jt + 3]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 8], m[jt + 4]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 8], m[jt + 4]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 8], m[jt + 5]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 8], m[jt + 5]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 8], m[jt + 6]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 8], m[jt + 6]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 8], m[jt + 7]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 8], m[jt + 7]);
            res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 8], m[jt + 8]);
            res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 8], m[jt + 8]);
            res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 8], m[jt + 9]);
            res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 8], m[jt + 9]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 9], m[jt + 0]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 9], m[jt + 0]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 9], m[jt + 1]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 9], m[jt + 1]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 9], m[jt + 2]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 9], m[jt + 2]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 9], m[jt + 3]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 9], m[jt + 3]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 9], m[jt + 4]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 9], m[jt + 4]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 9], m[jt + 5]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 9], m[jt + 5]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 9], m[jt + 6]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 9], m[jt + 6]);
            res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 9], m[jt + 7]);
            res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 9], m[jt + 7]);
            res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 9], m[jt + 8]);
            res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 9], m[jt + 8]);
            res[it + jt + 18] = fma52lo(res[it + jt + 18], u[it + 9], m[jt + 9]);
            res[it + jt + 19] = fma52hi(res[it + jt + 19], u[it + 9], m[jt + 9]);
        }
    }

    // Normalization
    r[0]     = and64_const(res[79], DIGIT_MASK);
    res[80]  = add64(res[80], srli64(res[79], DIGIT_SIZE));
    r[1]     = and64_const(res[80], DIGIT_MASK);
    res[81]  = add64(res[81], srli64(res[80], DIGIT_SIZE));
    r[2]     = and64_const(res[81], DIGIT_MASK);
    res[82]  = add64(res[82], srli64(res[81], DIGIT_SIZE));
    r[3]     = and64_const(res[82], DIGIT_MASK);
    res[83]  = add64(res[83], srli64(res[82], DIGIT_SIZE));
    r[4]     = and64_const(res[83], DIGIT_MASK);
    res[84]  = add64(res[84], srli64(res[83], DIGIT_SIZE));
    r[5]     = and64_const(res[84], DIGIT_MASK);
    res[85]  = add64(res[85], srli64(res[84], DIGIT_SIZE));
    r[6]     = and64_const(res[85], DIGIT_MASK);
    res[86]  = add64(res[86], srli64(res[85], DIGIT_SIZE));
    r[7]     = and64_const(res[86], DIGIT_MASK);
    res[87]  = add64(res[87], srli64(res[86], DIGIT_SIZE));
    r[8]     = and64_const(res[87], DIGIT_MASK);
    res[88]  = add64(res[88], srli64(res[87], DIGIT_SIZE));
    r[9]     = and64_const(res[88], DIGIT_MASK);
    res[89]  = add64(res[89], srli64(res[88], DIGIT_SIZE));
    r[10]    = and64_const(res[89], DIGIT_MASK);
    res[90]  = add64(res[90], srli64(res[89], DIGIT_SIZE));
    r[11]    = and64_const(res[90], DIGIT_MASK);
    res[91]  = add64(res[91], srli64(res[90], DIGIT_SIZE));
    r[12]    = and64_const(res[91], DIGIT_MASK);
    res[92]  = add64(res[92], srli64(res[91], DIGIT_SIZE));
    r[13]    = and64_const(res[92], DIGIT_MASK);
    res[93]  = add64(res[93], srli64(res[92], DIGIT_SIZE));
    r[14]    = and64_const(res[93], DIGIT_MASK);
    res[94]  = add64(res[94], srli64(res[93], DIGIT_SIZE));
    r[15]    = and64_const(res[94], DIGIT_MASK);
    res[95]  = add64(res[95], srli64(res[94], DIGIT_SIZE));
    r[16]    = and64_const(res[95], DIGIT_MASK);
    res[96]  = add64(res[96], srli64(res[95], DIGIT_SIZE));
    r[17]    = and64_const(res[96], DIGIT_MASK);
    res[97]  = add64(res[97], srli64(res[96], DIGIT_SIZE));
    r[18]    = and64_const(res[97], DIGIT_MASK);
    res[98]  = add64(res[98], srli64(res[97], DIGIT_SIZE));
    r[19]    = and64_const(res[98], DIGIT_MASK);
    res[99]  = add64(res[99], srli64(res[98], DIGIT_SIZE));
    r[20]    = and64_const(res[99], DIGIT_MASK);
    res[100] = add64(res[100], srli64(res[99], DIGIT_SIZE));
    r[21]    = and64_const(res[100], DIGIT_MASK);
    res[101] = add64(res[101], srli64(res[100], DIGIT_SIZE));
    r[22]    = and64_const(res[101], DIGIT_MASK);
    res[102] = add64(res[102], srli64(res[101], DIGIT_SIZE));
    r[23]    = and64_const(res[102], DIGIT_MASK);
    res[103] = add64(res[103], srli64(res[102], DIGIT_SIZE));
    r[24]    = and64_const(res[103], DIGIT_MASK);
    res[104] = add64(res[104], srli64(res[103], DIGIT_SIZE));
    r[25]    = and64_const(res[104], DIGIT_MASK);
    res[105] = add64(res[105], srli64(res[104], DIGIT_SIZE));
    r[26]    = and64_const(res[105], DIGIT_MASK);
    res[106] = add64(res[106], srli64(res[105], DIGIT_SIZE));
    r[27]    = and64_const(res[106], DIGIT_MASK);
    res[107] = add64(res[107], srli64(res[106], DIGIT_SIZE));
    r[28]    = and64_const(res[107], DIGIT_MASK);
    res[108] = add64(res[108], srli64(res[107], DIGIT_SIZE));
    r[29]    = and64_const(res[108], DIGIT_MASK);
    res[109] = add64(res[109], srli64(res[108], DIGIT_SIZE));
    r[30]    = and64_const(res[109], DIGIT_MASK);
    res[110] = add64(res[110], srli64(res[109], DIGIT_SIZE));
    r[31]    = and64_const(res[110], DIGIT_MASK);
    res[111] = add64(res[111], srli64(res[110], DIGIT_SIZE));
    r[32]    = and64_const(res[111], DIGIT_MASK);
    res[112] = add64(res[112], srli64(res[111], DIGIT_SIZE));
    r[33]    = and64_const(res[112], DIGIT_MASK);
    res[113] = add64(res[113], srli64(res[112], DIGIT_SIZE));
    r[34]    = and64_const(res[113], DIGIT_MASK);
    res[114] = add64(res[114], srli64(res[113], DIGIT_SIZE));
    r[35]    = and64_const(res[114], DIGIT_MASK);
    res[115] = add64(res[115], srli64(res[114], DIGIT_SIZE));
    r[36]    = and64_const(res[115], DIGIT_MASK);
    res[116] = add64(res[116], srli64(res[115], DIGIT_SIZE));
    r[37]    = and64_const(res[116], DIGIT_MASK);
    res[117] = add64(res[117], srli64(res[116], DIGIT_SIZE));
    r[38]    = and64_const(res[117], DIGIT_MASK);
    res[118] = add64(res[118], srli64(res[117], DIGIT_SIZE));
    r[39]    = and64_const(res[118], DIGIT_MASK);
    res[119] = add64(res[119], srli64(res[118], DIGIT_SIZE));
    r[40]    = and64_const(res[119], DIGIT_MASK);
    res[120] = add64(res[120], srli64(res[119], DIGIT_SIZE));
    r[41]    = and64_const(res[120], DIGIT_MASK);
    res[121] = add64(res[121], srli64(res[120], DIGIT_SIZE));
    r[42]    = and64_const(res[121], DIGIT_MASK);
    res[122] = add64(res[122], srli64(res[121], DIGIT_SIZE));
    r[43]    = and64_const(res[122], DIGIT_MASK);
    res[123] = add64(res[123], srli64(res[122], DIGIT_SIZE));
    r[44]    = and64_const(res[123], DIGIT_MASK);
    res[124] = add64(res[124], srli64(res[123], DIGIT_SIZE));
    r[45]    = and64_const(res[124], DIGIT_MASK);
    res[125] = add64(res[125], srli64(res[124], DIGIT_SIZE));
    r[46]    = and64_const(res[125], DIGIT_MASK);
    res[126] = add64(res[126], srli64(res[125], DIGIT_SIZE));
    r[47]    = and64_const(res[126], DIGIT_MASK);
    res[127] = add64(res[127], srli64(res[126], DIGIT_SIZE));
    r[48]    = and64_const(res[127], DIGIT_MASK);
    res[128] = add64(res[128], srli64(res[127], DIGIT_SIZE));
    r[49]    = and64_const(res[128], DIGIT_MASK);
    res[129] = add64(res[129], srli64(res[128], DIGIT_SIZE));
    r[50]    = and64_const(res[129], DIGIT_MASK);
    res[130] = add64(res[130], srli64(res[129], DIGIT_SIZE));
    r[51]    = and64_const(res[130], DIGIT_MASK);
    res[131] = add64(res[131], srli64(res[130], DIGIT_SIZE));
    r[52]    = and64_const(res[131], DIGIT_MASK);
    res[132] = add64(res[132], srli64(res[131], DIGIT_SIZE));
    r[53]    = and64_const(res[132], DIGIT_MASK);
    res[133] = add64(res[133], srli64(res[132], DIGIT_SIZE));
    r[54]    = and64_const(res[133], DIGIT_MASK);
    res[134] = add64(res[134], srli64(res[133], DIGIT_SIZE));
    r[55]    = and64_const(res[134], DIGIT_MASK);
    res[135] = add64(res[135], srli64(res[134], DIGIT_SIZE));
    r[56]    = and64_const(res[135], DIGIT_MASK);
    res[136] = add64(res[136], srli64(res[135], DIGIT_SIZE));
    r[57]    = and64_const(res[136], DIGIT_MASK);
    res[137] = add64(res[137], srli64(res[136], DIGIT_SIZE));
    r[58]    = and64_const(res[137], DIGIT_MASK);
    res[138] = add64(res[138], srli64(res[137], DIGIT_SIZE));
    r[59]    = and64_const(res[138], DIGIT_MASK);
    res[139] = add64(res[139], srli64(res[138], DIGIT_SIZE));
    r[60]    = and64_const(res[139], DIGIT_MASK);
    res[140] = add64(res[140], srli64(res[139], DIGIT_SIZE));
    r[61]    = and64_const(res[140], DIGIT_MASK);
    res[141] = add64(res[141], srli64(res[140], DIGIT_SIZE));
    r[62]    = and64_const(res[141], DIGIT_MASK);
    res[142] = add64(res[142], srli64(res[141], DIGIT_SIZE));
    r[63]    = and64_const(res[142], DIGIT_MASK);
    res[143] = add64(res[143], srli64(res[142], DIGIT_SIZE));
    r[64]    = and64_const(res[143], DIGIT_MASK);
    res[144] = add64(res[144], srli64(res[143], DIGIT_SIZE));
    r[65]    = and64_const(res[144], DIGIT_MASK);
    res[145] = add64(res[145], srli64(res[144], DIGIT_SIZE));
    r[66]    = and64_const(res[145], DIGIT_MASK);
    res[146] = add64(res[146], srli64(res[145], DIGIT_SIZE));
    r[67]    = and64_const(res[146], DIGIT_MASK);
    res[147] = add64(res[147], srli64(res[146], DIGIT_SIZE));
    r[68]    = and64_const(res[147], DIGIT_MASK);
    res[148] = add64(res[148], srli64(res[147], DIGIT_SIZE));
    r[69]    = and64_const(res[148], DIGIT_MASK);
    res[149] = add64(res[149], srli64(res[148], DIGIT_SIZE));
    r[70]    = and64_const(res[149], DIGIT_MASK);
    res[150] = add64(res[150], srli64(res[149], DIGIT_SIZE));
    r[71]    = and64_const(res[150], DIGIT_MASK);
    res[151] = add64(res[151], srli64(res[150], DIGIT_SIZE));
    r[72]    = and64_const(res[151], DIGIT_MASK);
    res[152] = add64(res[152], srli64(res[151], DIGIT_SIZE));
    r[73]    = and64_const(res[152], DIGIT_MASK);
    res[153] = add64(res[153], srli64(res[152], DIGIT_SIZE));
    r[74]    = and64_const(res[153], DIGIT_MASK);
    res[154] = add64(res[154], srli64(res[153], DIGIT_SIZE));
    r[75]    = and64_const(res[154], DIGIT_MASK);
    res[155] = add64(res[155], srli64(res[154], DIGIT_SIZE));
    r[76]    = and64_const(res[155], DIGIT_MASK);
    res[156] = add64(res[156], srli64(res[155], DIGIT_SIZE));
    r[77]    = and64_const(res[156], DIGIT_MASK);
    res[157] = add64(res[157], srli64(res[156], DIGIT_SIZE));
    r[78]    = and64_const(res[157], DIGIT_MASK);
}

#endif /* #if (_MBX>=_MBX_K1) */
