.\" -*-nroff-*-
.\"
.\"     Copyright (c) 1999-2001 Robert CHERAMY <robert@cheramy.net>
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH IPFM.CONF 5 "Last change: 26 October 2000"

.SH NAME
ipfm.conf \- IP Flow Meter configuration file

.SH DESCRIPTION
.B ipfm.conf
is
.BR ipfm (8)
configuration file.

A hash mark (``#'') indicates that the end of the line is a comment
and it will be ignored.

The configuration rules will be interpreted from the end, and the first
matching rule will be used, unless specified here.

.BR IPFM
uses local and global variables, so it can manage multiple logs (different
time delay, different hosts, different log filename ...) at the same time.

Global variables will be used for all logs and local variables will only be used in the log beeing defined.

.SH GLOBAL VARIABLES
.SS
.I NETWORK DEVICE
.B Syntax :
DEVICE <device-name>
.TP
<device-name>
is the device on witch ipfm will log packets. IPFM monitors only one device.

.SS
.I Time Coordinates
.B Syntax :
[UTC|local]

This decides if IPFM will use UTC or local time in its outputs (log filename andthe timesamp inside the file). Default is local.

Note that IPFM works internally with UTC, and that the dates entered in the config file are UTC (see AFTER Syntax).

.SS
.I NEW LOG
.B Syntax :
NEWLOG

This creates a new log entry, where you can define new local variables.

.SH LOCAL VARIABLES
.SS
.I HOSTS TO LOG
.BR ipfm
logs only specified hosts.

.B Syntax:
LOG [[NONE|FROM|TO|BOTH] <host>] [[NOT] WITH <host>]
.TP
NONE
do not log anything from or to this <host>
.TP
FROM
do log packets from this <host>
.TP
TO
do log packets to this <host>
.TP
BOTH
(default) do log packets from and to this <host>
.TP
<host> can be :
x.x.x.x           : an IP.
x.x.x.x/x.x.x.x : an IP followed by a subnet mask.
.TP
WITH
specifies if the packet is ignored (NOT WITH) or logged (WITH), in function of the second IP present in the packet.
.TP
.B Examples :
LOG 10.10.10.0/255.255.255.0 NOT WITH 10.10.10.1
 will log any packets from or to hosts in subnet 10.10.10.0/255.255.255.0, except packets involving host 10.10.10.1 .

LOG WITH 10.10.10.23
 will log any packets in relation with host 10.10.10.23

LOG
 will log everything.

.SS
.I OUTPUT TIME DELAY
.B ipfm
outputs its statistics every fixed period, with the ability to fix an exact time origin and offset, in Coordinated Universal Time (UTC).

.B Syntax:
DUMP EVERY <time> [AFTER <time>]
.TP
<time> is composed of :
 <number> second(s)
 <number> minute(s)
 <number> hour(s)
 <number> day(s)

Default DUMP time is 24 hours

Default AFTER time is 0 seconds

.TP
.B Examples:
DUMP EVERY 30 minutes
 will dump the stats every 30 minutes at x:00 and x:30.

DUMP EVERY 1 hour AFTER 7 minutes
 will dump the stats every hour, at 0:07, 1:07, 2:07, and so on, regardless of the time at which ipfm was launched.

DUMP EVERY 1 day AFTER 14 hours
 will dump data every day, at 14:00:00 UTC (for France localtime (during the summer), at 16:00:00 +0200)

.SS
.I CLEARING STATS
You may want to clear your statistics sometimes, or after each dump.

.B Syntax :
CLEAR [ ALWAYS | NEVER | EVERY <time> [AFTER <time>] ]
.TP
<time> is composed of :
 <number> second(s)
 <number> minute(s)
 <number> hour(s)
 <number> day(s)

Default CLEAR mode is ALWAYS. Default AFTER time is 0 seconds. Note that both time values MUST be a multiple of the DUMP delay. Also, this line MUST come after the DUMP line.
.TP
.B Examples
CLEAR ALWAYS
 will clear the stats after every DUMP.

CLEAR NEVER
 will never clear the stats, which means you are doing incremental statistics.

CLEAR EVERY 30 minutes
 will clear the stats every 30 minutes at x:00 and x:30. Note that if your DUMP line had an AFTER value such as 3 minutes, this rule will clear the stats at x:03 and x:33.

CLEAR EVERY 1 hour AFTER 10 minutes
 will clear the stats every hour, at 0:10, 1:10, 2:10, and so on. Note that if your DUMP line had an AFTER value such as 3 minutes, this rule will clear the stats at 0:13, 1:13, 2:13 and so on.

.SS
.I LOG FILENAME
Every delay,
.B ipfm
writes its output into a file, which name is specified by the rule
.I FILENAME

.B Syntax:
FILENAME <filemask>
.TP
<filemask>
is a quoted string (eg. "/path/to/filename") that is parsed using
.BR strftime(3)
syntax.
.TP
Default FILENAME is __LOGFILE
NOTE : The file will be overwritten without any check.

.SS
.I REVERSE DNS
You can activate or deactivate reverse DNS in the output file.

.B WARNING
: activating reverse DNS can delay a lot the production of the log
file, due to DNS timeouts.

.B Syntax :
[RESOLVE|NORESOLVE]
.TP
Default is NORESOLVE

.SS
.I SORT OUTPUT FILE
.B ipfm
can sort output file depending on IN, OUT or TOTAL.

.B Syntax :
SORT IN|OUT|TOTAL
.TP
Default is to sort nothing. Please note that this option could delay a bit
the production of the log file.

.SS
.I SET PROMISCUOUS MODE
You can choose to log all packets on the network (default) or only packets
which destination is your network device.

This option could also be useful if you wish to set the promiscuous mode
yourself (ifconfig eth0 [-]promisc), as the promisc mode is very badly
handled under Linux.

Please note that under Linux, if you run a program that sets the
promiscuous mode (for example tcpdump),
.B ipfm
will also see its network interface set into promiscuous mode.

.B Syntax
[NO]PROMISC
.TP
Default is PROMISC

.SS
APPEND OR REPLACE LOG FILES
You can choose to append the output to an existing logfile or to replace
the old file by a new one.

.B Syntax :
APPEND|REPLACE
.TP
Default is REPLACE

.SH SEE ALSO
.BR strftime(3),
.BR ipfm(8)

.SH AUTHORS
 Robert CHERAMY <tibob@via.ecp.fr>
 Andres KRAPF   <dae@via.ecp.fr>
