/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcCoordinateReferenceSystem.h"
#include "ifcpp/IFC4/include/IfcCoordinateReferenceSystemSelect.h"
#include "ifcpp/IFC4/include/IfcLengthMeasure.h"
#include "ifcpp/IFC4/include/IfcMapConversion.h"
#include "ifcpp/IFC4/include/IfcReal.h"

// ENTITY IfcMapConversion 
IfcMapConversion::IfcMapConversion( int id ) { m_entity_id = id; }
IfcMapConversion::~IfcMapConversion() {}
shared_ptr<BuildingObject> IfcMapConversion::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcMapConversion> copy_self( new IfcMapConversion() );
	if( m_SourceCRS ) { copy_self->m_SourceCRS = dynamic_pointer_cast<IfcCoordinateReferenceSystemSelect>( m_SourceCRS->getDeepCopy(options) ); }
	if( m_TargetCRS ) { copy_self->m_TargetCRS = dynamic_pointer_cast<IfcCoordinateReferenceSystem>( m_TargetCRS->getDeepCopy(options) ); }
	if( m_Eastings ) { copy_self->m_Eastings = dynamic_pointer_cast<IfcLengthMeasure>( m_Eastings->getDeepCopy(options) ); }
	if( m_Northings ) { copy_self->m_Northings = dynamic_pointer_cast<IfcLengthMeasure>( m_Northings->getDeepCopy(options) ); }
	if( m_OrthogonalHeight ) { copy_self->m_OrthogonalHeight = dynamic_pointer_cast<IfcLengthMeasure>( m_OrthogonalHeight->getDeepCopy(options) ); }
	if( m_XAxisAbscissa ) { copy_self->m_XAxisAbscissa = dynamic_pointer_cast<IfcReal>( m_XAxisAbscissa->getDeepCopy(options) ); }
	if( m_XAxisOrdinate ) { copy_self->m_XAxisOrdinate = dynamic_pointer_cast<IfcReal>( m_XAxisOrdinate->getDeepCopy(options) ); }
	if( m_Scale ) { copy_self->m_Scale = dynamic_pointer_cast<IfcReal>( m_Scale->getDeepCopy(options) ); }
	return copy_self;
}
void IfcMapConversion::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCMAPCONVERSION" << "(";
	if( m_SourceCRS ) { m_SourceCRS->getStepParameter( stream, true ); } else { stream << "$" ; }
	stream << ",";
	if( m_TargetCRS ) { stream << "#" << m_TargetCRS->m_entity_id; } else { stream << "$"; }
	stream << ",";
	if( m_Eastings ) { m_Eastings->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Northings ) { m_Northings->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_OrthogonalHeight ) { m_OrthogonalHeight->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_XAxisAbscissa ) { m_XAxisAbscissa->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_XAxisOrdinate ) { m_XAxisOrdinate->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Scale ) { m_Scale->getStepParameter( stream ); } else { stream << "$"; }
	stream << ");";
}
void IfcMapConversion::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcMapConversion::toString() const { return L"IfcMapConversion"; }
void IfcMapConversion::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 8 ){ std::stringstream err; err << "Wrong parameter count for entity IfcMapConversion, expecting 8, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	m_SourceCRS = IfcCoordinateReferenceSystemSelect::createObjectFromSTEP( args[0], map );
	readEntityReference( args[1], m_TargetCRS, map );
	m_Eastings = IfcLengthMeasure::createObjectFromSTEP( args[2], map );
	m_Northings = IfcLengthMeasure::createObjectFromSTEP( args[3], map );
	m_OrthogonalHeight = IfcLengthMeasure::createObjectFromSTEP( args[4], map );
	m_XAxisAbscissa = IfcReal::createObjectFromSTEP( args[5], map );
	m_XAxisOrdinate = IfcReal::createObjectFromSTEP( args[6], map );
	m_Scale = IfcReal::createObjectFromSTEP( args[7], map );
}
void IfcMapConversion::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcCoordinateOperation::getAttributes( vec_attributes );
	vec_attributes.emplace_back( std::make_pair( "Eastings", m_Eastings ) );
	vec_attributes.emplace_back( std::make_pair( "Northings", m_Northings ) );
	vec_attributes.emplace_back( std::make_pair( "OrthogonalHeight", m_OrthogonalHeight ) );
	vec_attributes.emplace_back( std::make_pair( "XAxisAbscissa", m_XAxisAbscissa ) );
	vec_attributes.emplace_back( std::make_pair( "XAxisOrdinate", m_XAxisOrdinate ) );
	vec_attributes.emplace_back( std::make_pair( "Scale", m_Scale ) );
}
void IfcMapConversion::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcCoordinateOperation::getAttributesInverse( vec_attributes_inverse );
}
void IfcMapConversion::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcCoordinateOperation::setInverseCounterparts( ptr_self_entity );
}
void IfcMapConversion::unlinkFromInverseCounterparts()
{
	IfcCoordinateOperation::unlinkFromInverseCounterparts();
}
