% ===================================================================== %
% HOL TRAINING COURSE: solutions to the exercises on forward proof.	%
% ===================================================================== %

% ===================================================================== %
% Prove the following theorem using the HOL derived inference rules.	%
%									%
%   |- (t1 /\ (t1 ==> t2) /\ (t3:bool = t2)) ==> t3			%
% ===================================================================== %

% --------------------------------------------------------------------- %
% The required theorem is an implication, so we begin by assuming the 	%
% antecedent, from which we shal then to prove the consequent. The 	%
% derived rule for making this assumption is ASSUME.  			%
% --------------------------------------------------------------------- %
let th1 = ASSUME "t1 /\ (t1 ==> t2) /\ (t3 = t2)";;

% --------------------------------------------------------------------- %
% We now break th1 into its three conjuncts using the CONJUCTS rule.    %
% The resulting three theorems are bound to th2, th3 and th4.		%
% --------------------------------------------------------------------- %
let [th2;th3;th4] = CONJUNCTS th1;;

% --------------------------------------------------------------------- %
% It is now straightforward to prove A |- t3, where A is the assumption %
% of theorem th1.  The proof is:					%
%									%
%   1)  |- t1			[theorem th2]				%
%   2)  |- t1 ==> t2	        [theorem th3]				%
%   3)  |- t2 			[modus ponens: 1 and 2]			%
%   4)  |- t2 = t3		[symmetric form of th4]			%
%   5)  |- t3			[substituting t3 for t2 in 3 using 4]	%
%									%
% This final theorem inherits the original assumption of th1.		%
% --------------------------------------------------------------------- %
let th5 = SUBS [SYM th4] (MP th3 th2);;

% --------------------------------------------------------------------- %
% Finally, discharge the assumption to get the required result.		%
% --------------------------------------------------------------------- %
let thm0 = DISCH  "t1 /\ (t1 ==> t2) /\ (t3 = t2)" th5;;

% ===================================================================== %
% Prove the following theorem using derived inference rules:		%
%									%
%    |- (b1 ==> (b2 /\ b3)) = ((b1 ==> b2) /\ (b1 ==> b3))		%
%									%
% HINT: Prove implication in each direction, then use IMP_ANTISYM_RULE.	%
% ===================================================================== %

% --------------------------------------------------------------------- %
% We begin by proving the left-to-right implication:			%
%									%
%   |- (b1 ==> (b2 /\ b3)) ==> ((b1 ==> b2) /\ (b1 ==> b3))		%
%                                                                       %
% The first step is to assume the antecedent:				%
% --------------------------------------------------------------------- %
let th1 = ASSUME "b1 ==> (b2 /\ b3)";;

% --------------------------------------------------------------------- %
% We now move "b1" into the assumptions, to get |- b2 /\ b3		%
% --------------------------------------------------------------------- %
let th2 = UNDISCH th1;;

% --------------------------------------------------------------------- %
% From |- b2 /\ b3 we may deduce |- b2 and |- b3.			%
% --------------------------------------------------------------------- %
let th3 = CONJUNCTS th2;;

% --------------------------------------------------------------------- %
% Now discharge "b1" from each and conjoin the resulting theorems.	%
% --------------------------------------------------------------------- %
let th4 = LIST_CONJ (map (DISCH "b1:bool") th3);;

% --------------------------------------------------------------------- %
% Finally, discharge the remaining assumption.				%
% --------------------------------------------------------------------- %
let th5 = DISCH "b1 ==> (b2 /\ b3)" th4;;

% --------------------------------------------------------------------- %
% We now prove the right-to-left implication:				%
%									%
%    |-  ((b1 ==> b2) /\ (b1 ==> b3)) ==> (b1 ==> (b2 /\ b3))		%
%									%
% Again, we begin by assuming the antecedent.				%
% --------------------------------------------------------------------- %
let th6 = ASSUME "(b1 ==> b2) /\ (b1 ==> b3)";;

% --------------------------------------------------------------------- %
% Now split into two conjuncts and undischarge "b1" in each one.	%
% --------------------------------------------------------------------- %
let th7 = map UNDISCH (CONJUNCTS th6);;

% --------------------------------------------------------------------- %
% Conjoin the resulting theorems and discharge assumptions.		%
% --------------------------------------------------------------------- %
let th8 = DISCH_ALL (DISCH "b1:bool" (LIST_CONJ th7));;

% --------------------------------------------------------------------- %
% To complete the proof, simply put the two implications together to 	%
% get the required equivalence.						%
% --------------------------------------------------------------------- %
let thm1 = IMP_ANTISYM_RULE th5 th8;;

% ===================================================================== %
% Prove the following theorem using derived inference rules:		%
% 									%
%    |- ((b1 /\ b2) ==> b3) = (b1 ==> (b2 ==> b3))			%
% ===================================================================== %

% --------------------------------------------------------------------- %
% As in the previous example, we'll prove the required equivalence by	%
% proving implication in both directions. We start by proving:		%
%									%
%   |- ((b1 /\ b2) ==> b3) ==> (b1 ==> (b2 ==> b3))			%
%									%
% Again, the first step is to assume the antecedent:			%
% --------------------------------------------------------------------- %
let th1 = ASSUME "(b1 /\ b2) ==> b3";;

% --------------------------------------------------------------------- %
% Now, assume "b1" and assume "b2"					%
% --------------------------------------------------------------------- %
let th2 = ASSUME "b1:bool" and th3 = ASSUME "b2:bool";;

% --------------------------------------------------------------------- %
% From these assumptions, we can construct |- b1 /\ b2.			%
% --------------------------------------------------------------------- %
let th4 = CONJ th2 th3;;

% --------------------------------------------------------------------- %
% Now, use modus ponens to conclude |- b3.				%
% --------------------------------------------------------------------- %
let th5 = MP th1 th4;;

% --------------------------------------------------------------------- %
% Now, discharge the assumptions in the correct order to get the 	%
% desired implication.							%
% --------------------------------------------------------------------- %
let th6 = DISCH "b1 /\ b2 ==> b3" (DISCH "b1:bool" (DISCH "b2:bool" th5));;

% --------------------------------------------------------------------- %
% Now for the other direction of the implication:			%
%									%
%   |- (b1 ==> (b2 ==> b3)) ==> ((b1 /\ b2) ==> b3) 			%
%									%
% Begin, as usual, by assuming the antecedent.				%
% --------------------------------------------------------------------- %
let th7 = ASSUME "b1 ==> b2 ==> b3";;

% --------------------------------------------------------------------- %
% Now assume the antecedent of the implication to be proved, namely	%
% the term "b1 /\ b2".							%
% --------------------------------------------------------------------- %
let th8 = ASSUME "b1 /\ b2";;

% --------------------------------------------------------------------- %
% From th8 we get |- b1 and |- b2.					%
% --------------------------------------------------------------------- %
let th9 = CONJUNCTS th8;;

% --------------------------------------------------------------------- %
% Now, conclude b3 using repeated modus ponens.				%
% --------------------------------------------------------------------- %
let th10 = LIST_MP th9 th7;;

% --------------------------------------------------------------------- %
% Discharge all assumptions in the correct order.			%
% --------------------------------------------------------------------- %
let th11 = DISCH "b1 ==> b2 ==> b3" (DISCH "b1 /\ b2" th10);;

% --------------------------------------------------------------------- %
% Put the two implications together to get the final result.		%
% --------------------------------------------------------------------- %
let thm1 = IMP_ANTISYM_RULE th6 th11;;

% ===================================================================== %
% Prove the following theorem by forward proof:				%
%									%
%   |- ((!x. P x ==> R x) \/ (!x. P x ==> Q x))		    	        %
%       ==>								%
%      (!x:*. P x ==> R x \/ Q x)					%
%									%
% HINT: Consider the two cases of the antecedent separately, then use   %
% the rule DISJ_CASES to put the two results together.			%
% ===================================================================== %

% --------------------------------------------------------------------- %
% Begin by assuming the left disjunct of the antecedent. Then take x to %
% be just "x", and move P x into the assumptions.			%
% --------------------------------------------------------------------- %
let th1 = UNDISCH (SPEC "x:*" (ASSUME "!x:*. P x ==> R x"));;

% --------------------------------------------------------------------- %
% Now, since R x holds, we also have  "R x \/ Q x" to the conclusion.	%
% --------------------------------------------------------------------- %
let th2 = DISJ1 th1 "(Q:*->bool) x";;

% --------------------------------------------------------------------- %
% Discharge "P x".							%
% --------------------------------------------------------------------- %
let th3 = DISCH "(P:*->bool) x" th2;;

% --------------------------------------------------------------------- %
% Repeat the above process for the right disjunct.			%
% --------------------------------------------------------------------- %
let th6 = let th = UNDISCH (SPEC_ALL (ASSUME "!x:*. P x ==> Q x")) in
          DISCH "(P:*->bool) x" (DISJ2 "(R:*->bool) x" th);;

% --------------------------------------------------------------------- %
% Now assume the antecedent.						%
% --------------------------------------------------------------------- %
let th7 = ASSUME ("(!x:*. P x ==> R x) \/ (!x. P x ==> Q x)");;

% --------------------------------------------------------------------- %
% And use DISJ_CASES to get the conclusion.				%
% --------------------------------------------------------------------- %
let th8 = DISJ_CASES th7 th3 th6;;

% --------------------------------------------------------------------- %
% Finally, generalize and discharge the sole assumption.		%
% --------------------------------------------------------------------- %
let thm2 = DISCH_ALL(GEN "x:*" th8);;


% ===================================================================== %
% Prove the following theorem by forward inference.			%
%									%
%   |- ?x. x ==> ~x 							%
% 									%
% HINT: first prove that |- F ==> ~F using CONTR and then use EXISTS.	%
% ===================================================================== %

% --------------------------------------------------------------------- %
% We first prove |- F ==> ~F.						%
% --------------------------------------------------------------------- %
let th1 = DISCH "F" (CONTR "~F" (ASSUME "F"));;

% --------------------------------------------------------------------- %
% Now, since |- F ==> ~F then there certainly exists an x (namely F) 	%
% such that x ==> ~x.							%
% --------------------------------------------------------------------- %
let thm3 = EXISTS ("?x. x ==> ~x", "F") th1;;

% ===================================================================== %
% Prove the following theorem: 						%
%									%
%   |- (!x:*.f(x)=x) ==> (f = \x:*.x)					%
%									%
% HINTS: you may find SUBST_OCCS, RIGHT_BETA and EXT useful.		%
% ===================================================================== %

% --------------------------------------------------------------------- %
% Start, as usual, by assuming the antecedent.				%
% --------------------------------------------------------------------- %
let th1 = ASSUME "!x:*.f(x)=x";;

% --------------------------------------------------------------------- %
% construct the theorem |- (\x.x)x = (\x.x)x				%
% --------------------------------------------------------------------- %
let th2 = REFL "(\x:*.x)x";;

% --------------------------------------------------------------------- %
% substitute f(x) for x on the RHS of th2				%
% --------------------------------------------------------------------- %
let th3 = SUBS_OCCS [[2],SYM(SPEC "x:*" th1)] th2;;

% --------------------------------------------------------------------- %
% Beta-reduce the right hand side of th3 and swap rhs and lhs.		%
% --------------------------------------------------------------------- %
let th4 = SYM(RIGHT_BETA  th3);;

% --------------------------------------------------------------------- %
% Use EXT to prove the functions equal.					%
% --------------------------------------------------------------------- %
let th5 = EXT (GEN "x:*" th4);;

% --------------------------------------------------------------------- %
% Discharge the assumption, giving the required theorem.		%
% --------------------------------------------------------------------- %
let thm4 = DISCH_ALL th5;;

% ===================================================================== %
% Prove the following theorem using derived inference rules:		%
% 									%
%    |- !P:(*#**)->bool. (!x y. P(x,y)) = (!y x. P(x,y))		%
% ===================================================================== %

% --------------------------------------------------------------------- %
% We first prove the following implication:				%
% 									%
%   |- (!x y. P(x:*,y:**)) ==> (!y x. P(x,y))				%
% 									%
% The proof begins (as usual) by assuming the antecedent.		%
% --------------------------------------------------------------------- %
let th1 = ASSUME "!x y. P(x:*,y:**)";;

% --------------------------------------------------------------------- %
% Now, specialize the two variables.					%
% --------------------------------------------------------------------- %
let th2 = SPEC "y:**" (SPEC "x:*" th1);;

% --------------------------------------------------------------------- %
% and generalize them in the reverse order.				%
% --------------------------------------------------------------------- %
let th3 = GEN "y:**" (GEN "x:*" th2);;

% --------------------------------------------------------------------- %
% Discharge the assumption to get the first implication.		%
% --------------------------------------------------------------------- %
let th4 = DISCH "!x y. P(x:*,y:**)" th3;;

% --------------------------------------------------------------------- %
% The proof of implication in the other direction is similar:		%
% --------------------------------------------------------------------- %
let th5 =
    let asm = ASSUME "!y x. P(x:*,y:**)" in
    let thm = GENL ["x:*";"y:**"] (SPECL  ["y:**";"x:*"] asm) in
	DISCH "!y x. P(x:*,y:**)"  thm;;

% --------------------------------------------------------------------- %
% Now, put the two implications together to get the equivalence.	%
% --------------------------------------------------------------------- %
let thm5 = GEN "P:(*#**)->bool" (IMP_ANTISYM_RULE th4 th5);;

% ===================================================================== %
% Prove that every irreflexive and transitive binary relation 		%
% is asymmetric. I.e. use forward proof to deduce the theorem:		%
%									%
%   |- !R:(*#*)->bool.							%
%      (!x. ~R(x,x)) /\ (!x y z. R(x,y) /\ R(y,z) ==> R(x,z)) ==>	%
%      (!x y. R(x,y) ==> ~R(y,x))					%
% ===================================================================== %

% --------------------------------------------------------------------- %
% Begin by assuming that R is irreflexive and transitive.		%
% --------------------------------------------------------------------- %
let th1 = ASSUME "(!x:*. ~ R(x,x)) /\ !x y z. (R(x,y) /\ R(y,z)) ==> R(x,z)";;

% --------------------------------------------------------------------- %
% Get the two parts of this assumption as separate theorems.		%
% --------------------------------------------------------------------- %
let th2 = CONJUNCT1 th1 and th3 = CONJUNCT2 th1;;

% --------------------------------------------------------------------- %
% Specialise th3 to get the consequence "R(x,x)".			%
% --------------------------------------------------------------------- %
let th4 = SPECL ["x:*";"y:*";"x:*"] th3;;

% --------------------------------------------------------------------- %
% Change "~R(x,x)" to "R(x,x) ==> F"					%
% --------------------------------------------------------------------- %
let th5 = NOT_ELIM (SPEC "x:*" th2);;

% --------------------------------------------------------------------- %
% Use transitivity of implication to get "R(x,y) /\ R(y,x) ==> F"	%
% --------------------------------------------------------------------- %
let th6 = IMP_TRANS th4 th5;;

% --------------------------------------------------------------------- %
% Reintroduce negation.							%
% --------------------------------------------------------------------- %
let th7 = NOT_INTRO th6;;

% --------------------------------------------------------------------- %
% Change to a disjunction using de Morgan's laws			%
% --------------------------------------------------------------------- %
let th8 = 
  let thm = SPECL ["R(x:*,y:*):bool";"R(y:*,x:*):bool"] DE_MORGAN_THM in
      SUBS [CONJUNCT1 thm] th7;;

% --------------------------------------------------------------------- %
% Change the disjunction to implication					%
% --------------------------------------------------------------------- %
let th9 = DISJ_IMP th8;;

% --------------------------------------------------------------------- %
% Simplify "~~tm" to "tm"						%
% --------------------------------------------------------------------- %
let th10 = 
  let thm = SPEC "R(x:*,y:*):bool" (CONJUNCT1 NOT_CLAUSES) in
      SUBS [thm] th9;;

% --------------------------------------------------------------------- %
% Generalize and discharge assumptions.					%
% --------------------------------------------------------------------- %
let thm6 = 
    GEN "R:(*#*)->bool" (DISCH (concl th1) (GENL ["x:*";"y:*"] th10));;

% ===================================================================== %
% Prove the following theorem using derived inference rules:		%
% 									%
%   |- ((?x:*.t1(x)) ==> t2) = (!x. t1(x) ==> t2)			%
%									%
% HINT: you'll have to use EXISTS and CHOOSE.  Prove it by proving 	%
% implication in both directions, using EXISTS for one direction and	%
% CHOOSE for the other.							%
% ===================================================================== %

% --------------------------------------------------------------------- %
% We'll first prove the implication:					%
%									%
%    |- ((?x:*.t1(x) ==> t2) ==> (!x. t1(x) ==> t2)			%
%									%
% Start by assuming the antecedant.					%
% --------------------------------------------------------------------- %
let th1 = ASSUME "(?x:*.t1(x)) ==> t2";;

% --------------------------------------------------------------------- %
% Now, assume "t1(x)".  This will mean that ?x.t1(x).			%
% --------------------------------------------------------------------- %
let th2 = ASSUME "t1(x:*):bool";;

% --------------------------------------------------------------------- %
% Conclude "?x.t1(x)" under this assumption.				%
% --------------------------------------------------------------------- %
let th3 = EXISTS ("?x:*.t1(x)", "x:*") th2;;

% --------------------------------------------------------------------- %
% Thus, t2 is true by modus ponens					%
% --------------------------------------------------------------------- %
let th4 = MP th1 th3;;

% --------------------------------------------------------------------- %
% Now, discharge the assumption that "t1(x)".				%
% --------------------------------------------------------------------- %
let th5 = DISCH "t1(x:*):bool" th4;;

% --------------------------------------------------------------------- %
% Generalize to get !x.t1(x) ==> t2 and discharge remaining assumption.	%
% --------------------------------------------------------------------- %
let th6 = DISCH "(?x:*. t1 x) ==> t2"  (GEN "x:*" th5);;

% --------------------------------------------------------------------- %
% Now the other direction. First assume !x.t1(x) ==> t2.		%
% --------------------------------------------------------------------- %
let th7 = ASSUME "!x:*.t1(x) ==> t2";;

% --------------------------------------------------------------------- %
% Specialize  to x and move t1(x) into the assumptions (for CHOOSE)	%
% --------------------------------------------------------------------- %
let th8 = UNDISCH (SPEC "x:*" th7);;

% --------------------------------------------------------------------- %
% Now, assume ?x.t1(x).							%
% --------------------------------------------------------------------- %
let th9 = ASSUME "?x:*. t1(x)";;

% --------------------------------------------------------------------- %
% Now, use CHOOSE to conclude t2.					%
% --------------------------------------------------------------------- %
let th10 = CHOOSE ("x:*", th9) th8;;

% --------------------------------------------------------------------- %
% Bring out the assumption that "?x.t1(x)".				%
% --------------------------------------------------------------------- %
let th11 = DISCH "?x:*.t1(x)" th10;;

% --------------------------------------------------------------------- %
% Bring out remaining assumption.					%
% --------------------------------------------------------------------- %
let th12 = DISCH "!x:*. t1 x ==> t2" th11;;

% --------------------------------------------------------------------- %
% Put the two implications together to get the required equivalence.	%
% --------------------------------------------------------------------- %
let thm7 = IMP_ANTISYM_RULE th6 th12;;

% ===================================================================== %
% Prove the following theorem:						%
%									%
%    |- (?x y. t(x,y)) ==> (?y x. t(x,y))				%
%									%
% HINT: use SELECT_RULE first and then EXISTS --- be careful.		%
% ===================================================================== %

% --------------------------------------------------------------------- %
% First, assume ?x y.t(x,y) and use SELECT_RULE:			%
% --------------------------------------------------------------------- %
let th1 = SELECT_RULE (ASSUME "?x y.t(x:*,y:**)");;

% --------------------------------------------------------------------- %
% Use SELECT_RULE again.						%`
% --------------------------------------------------------------------- %
let th2 = SELECT_RULE th1;;

% --------------------------------------------------------------------- %
% Now, use EXISTS to quantify in the reverse order.			%
% --------------------------------------------------------------------- %
let th3 = 
  EXISTS("?x:*.t(x,@y:**.(t((@x.?y.t(x,y)),y)))","@x:*.?y:**.t(x,y)") th2;;

% --------------------------------------------------------------------- %
% And use EXISTS again.							%
% --------------------------------------------------------------------- %
let th4 = EXISTS("?y x.t(x:*,y:**)", "@y:**. t((@x:*. ?y. t(x,y)),y)") th3;;

% --------------------------------------------------------------------- %
% Now, discharge the assumption to get the required implication.	%
% --------------------------------------------------------------------- %
let thm8 = DISCH "?x:*. ?y:**. t(x,y)" th4;;

quit();;
