
/***************************************************************************
 *            ho_recognize_font_1.h
 *
 *  Fri Aug 12 20:13:33 2005
 *  Copyright  2005-2008  Yaacov Zamir
 *  <kzamir@walla.co.il>
 ****************************************************************************/

/*  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** @file ho_recognize_font_1.h
    @brief libhocr C language header.
    
    libhocr - LIBrary for Hebrew Optical Character Recognition 
*/

#ifndef HO_RECOGNIZE_FONT_1_H
#define HO_RECOGNIZE_FONT_1_H 1

double ho_recognize_font_1_zero (const double *array_in);

double ho_recognize_font_1_one (const double *array_in);

double ho_recognize_font_1_two (const double *array_in);

double ho_recognize_font_1_three (const double *array_in);

double ho_recognize_font_1_four (const double *array_in);

double ho_recognize_font_1_five (const double *array_in);

double ho_recognize_font_1_six (const double *array_in);

double ho_recognize_font_1_seven (const double *array_in);

double ho_recognize_font_1_eight (const double *array_in);

double ho_recognize_font_1_nine (const double *array_in);

double ho_recognize_font_1_dot (const double *array_in);

double ho_recognize_font_1_comma (const double *array_in);

double ho_recognize_font_1_open (const double *array_in);

double ho_recognize_font_1_close (const double *array_in);

double ho_recognize_font_1_minus (const double *array_in);

double ho_recognize_font_1_plus (const double *array_in);

double ho_recognize_font_1_div (const double *array_in);

double ho_recognize_font_1_tag (const double *array_in);

double ho_recognize_font_1_two_tags (const double *array_in);

double ho_recognize_font_1_question (const double *array_in);

double ho_recognize_font_1_exclem (const double *array_in);

double ho_recognize_font_1_dot_dot (const double *array_in);

double ho_recognize_font_1_dot_comma (const double *array_in);

double ho_recognize_font_1_alef (const double *array_in);

double ho_recognize_font_1_bet (const double *array_in);

double ho_recognize_font_1_gimal (const double *array_in);

double ho_recognize_font_1_dalet (const double *array_in);

double ho_recognize_font_1_hey (const double *array_in);

double ho_recognize_font_1_vav (const double *array_in);

double ho_recognize_font_1_zayin (const double *array_in);

double ho_recognize_font_1_het (const double *array_in);

double ho_recognize_font_1_tet (const double *array_in);

double ho_recognize_font_1_yud (const double *array_in);

double ho_recognize_font_1_caf (const double *array_in);

double ho_recognize_font_1_caf_sofit (const double *array_in);

double ho_recognize_font_1_lamed (const double *array_in);

double ho_recognize_font_1_mem (const double *array_in);

double ho_recognize_font_1_mem_sofit (const double *array_in);

double ho_recognize_font_1_nun (const double *array_in);

double ho_recognize_font_1_nun_sofit (const double *array_in);

double ho_recognize_font_1_samech (const double *array_in);

double ho_recognize_font_1_ayin (const double *array_in);

double ho_recognize_font_1_pey (const double *array_in);

double ho_recognize_font_1_pey_sofit (const double *array_in);

double ho_recognize_font_1_tzadi (const double *array_in);

double ho_recognize_font_1_tzadi_sofit (const double *array_in);

double ho_recognize_font_1_kuf (const double *array_in);

double ho_recognize_font_1_resh (const double *array_in);

double ho_recognize_font_1_shin (const double *array_in);

double ho_recognize_font_1_tav (const double *array_in);

#endif /* HO_RECOGNIZE_FONT_1_H */
