/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.sheet;

import java.awt.Graphics2D;

public class DocumentPart extends AbstractPart {

    private DocumentCursor cursor;

	public DocumentPart(Sheet sheet) {
        super(sheet);
        cursor = new DocumentCursor(sheet.getBodyLeft(), sheet.getBodyRight());
    }

    public Part deepCopy(Sheet sheet) {
        
        AbstractPart copy = new DocumentPart(sheet);
        
        for (Part child : getChildren()) {
            copy.appendChild(child.deepCopy(sheet));
        }
        
        return copy;
    }

	public DocumentCursor getCursor() {
		return cursor;
	}

	public void paintPart(Graphics2D g2d) {

        // paintLayoutInfo(g2d, Color.CYAN, "DOCUMENT");
        paintContainer(g2d);
    }

}
