<h1 align="center">Tech Interview Handbook</h1>

<div align="center">
  <a href="https://dribbble.com/shots/3831443-Tech-Interview-Handbook">
    <img src="https://cdn.rawgit.com/yangshun/tech-interview-handbook/master/assets/book.svg" alt="Tech Interview Handbook" width="400"/>
    </a>
  <br>
  <p>
    <em>Credits: <a href="https://dribbble.com/shots/3831443-Tech-Interview-Handbook">Illustration</a> by <a href="https://dribbble.com/yangheng">@yangheng</a>
    </em>
  </p>
</div>

## What is this?

Carefully curated content to help you ace your next technical interview, with a focus on algorithms. System design questions are in-progress. Besides the usual algorithm questions, other **awesome** stuff includes:

* [How to prepare](preparing) for coding interviews
* [Interview Cheatsheet](preparing/cheatsheet.md) - Straight-to-the-point Do's and Don'ts 🆕
* [Algorithm tips and the best practice questions](algorithms) categorized by topic
* ["Front-end Job Interview Questions" answers](https://github.com/yangshun/front-end-interview-handbook)
* [Interview formats](non-technical/interview-formats.md) of the top tech companies
* [Behavioral questions](non-technical/behavioral.md) categorized by companies
* [Good questions to ask your interviewers](non-technical/questions-to-ask.md) at the end of the interviews
* [Helpful resume tips](non-technical/resume.md) to get your resume noticed and the Do's and Don'ts

This handbook is pretty new and help from you in contributing content would be very much appreciated!

## Why do I want this?

This repository has _practical_ content that covers all phases of a technical interview, from applying for a job to passing the interviews to offer negotiation. Technically competent candidates might still find the non-technical content helpful as well.

## Who is this for?

Anybody who wants to land a job at a tech company but is new to technical interviews, seasoned engineers who have not been on the other side of the interviewing table in a while and want to get back into the game, or anyone who wants to be better at technical interviewing.

## How is this repository different?

There are so many awesome books like [Cracking the Coding Interview](http://www.crackingthecodinginterview.com/) and interview-related repositories out there on GitHub, what makes this repository different? The difference is that many existing interview repositories contain mainly links to external resources whereas this repository contains top quality curated content directly for your consumption.

Also, existing resources focus mainly on algorithm questions and lack coverage for more domain-specific and non-technical questions. This handbook aims to cover content beyond the typical algorithmic coding questions. 😎

## Looking for Front End content?

Front end-related content have been extracted out into a separate repository - [Front End Interview Handbook](https://github.com/yangshun/front-end-interview-handbook).

## Contents

* **[Preparing for a Coding Interview](preparing)**
  * [Interview cheatsheet](preparing/cheatsheet.md) - Straight-to-the-point Do's and Don'ts
* **[Algorithm Questions](algorithms)** - Questions categorized by topics
* **[Design Questions](design)**
* **[Front-end Job Interview Questions and Answers](https://github.com/yangshun/front-end-interview-handbook) 🔥⭐** - Answers to the famous "Front-end Job Interview Questions"
* **[Non-Technical Tips](non-technical)** - Random non-technical tips that cover behavioral and psychological aspects, interview formats and "Do you have any questions for me?"
  * [Resume Tips](non-technical/resume.md)
  * [Behavioral Questions](non-technical/behavioral.md)
  * [Interview Formats](non-technical/interview-formats.md)
  * [Psychological Tricks](non-technical/psychological-tricks.md)
  * [Questions to Ask](non-technical/questions-to-ask.md)
  * [Negotiation Tips](non-technical/negotiation.md)
* **[Utilities](utilities)** - Snippets of algorithms/code that will help in coding questions
  * **UPDATE** - Check out [Lago](https://github.com/yangshun/lago), which is a Data Structures and Algorithms library that contains more high-quality implementations with 100% test coverage.

## Related

If you are interested in how data structures are implemented, check out [Lago](https://github.com/yangshun/lago), a Data Structures and Algorithms library for JavaScript. It is pretty much still WIP but I intend to make it into a library that is able to be used in production and also a reference resource for revising Data Structures and Algorithms.

## Contributing

There are no formal contributing guidelines at the moment as things are still in flux and we might find a better approach to structure content as we go along. You are welcome to contribute whatever you think will be helpful to fellow engineers. If you would like to contribute content for different domains, feel free to create an issue or submit a pull request and we can discuss further.

## Maintainers

* [Yangshun Tay](https://github.com/yangshun)
* [Louie Tan](https://github.com/louietyj)
