// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspacesthinclient

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentRequest method.
//	req, resp := client.CreateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/CreateEnvironment
func (c *WorkSpacesThinClient) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/environments",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateEnvironment API operation for Amazon WorkSpaces Thin Client.
//
// Creates an environment for your thin client devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Your request exceeds a service quota.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/CreateEnvironment
func (c *WorkSpacesThinClient) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDevice = "DeleteDevice"

// DeleteDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDevice for more information on using the DeleteDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDeviceRequest method.
//	req, resp := client.DeleteDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/DeleteDevice
func (c *WorkSpacesThinClient) DeleteDeviceRequest(input *DeleteDeviceInput) (req *request.Request, output *DeleteDeviceOutput) {
	op := &request.Operation{
		Name:       opDeleteDevice,
		HTTPMethod: "DELETE",
		HTTPPath:   "/devices/{id}",
	}

	if input == nil {
		input = &DeleteDeviceInput{}
	}

	output = &DeleteDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteDevice API operation for Amazon WorkSpaces Thin Client.
//
// Deletes a thin client device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation DeleteDevice for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/DeleteDevice
func (c *WorkSpacesThinClient) DeleteDevice(input *DeleteDeviceInput) (*DeleteDeviceOutput, error) {
	req, out := c.DeleteDeviceRequest(input)
	return out, req.Send()
}

// DeleteDeviceWithContext is the same as DeleteDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) DeleteDeviceWithContext(ctx aws.Context, input *DeleteDeviceInput, opts ...request.Option) (*DeleteDeviceOutput, error) {
	req, out := c.DeleteDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentRequest method.
//	req, resp := client.DeleteEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/DeleteEnvironment
func (c *WorkSpacesThinClient) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environments/{id}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteEnvironment API operation for Amazon WorkSpaces Thin Client.
//
// Deletes an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/DeleteEnvironment
func (c *WorkSpacesThinClient) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterDevice = "DeregisterDevice"

// DeregisterDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterDevice for more information on using the DeregisterDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterDeviceRequest method.
//	req, resp := client.DeregisterDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/DeregisterDevice
func (c *WorkSpacesThinClient) DeregisterDeviceRequest(input *DeregisterDeviceInput) (req *request.Request, output *DeregisterDeviceOutput) {
	op := &request.Operation{
		Name:       opDeregisterDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/deregister-device/{id}",
	}

	if input == nil {
		input = &DeregisterDeviceInput{}
	}

	output = &DeregisterDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeregisterDevice API operation for Amazon WorkSpaces Thin Client.
//
// Deregisters a thin client device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation DeregisterDevice for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/DeregisterDevice
func (c *WorkSpacesThinClient) DeregisterDevice(input *DeregisterDeviceInput) (*DeregisterDeviceOutput, error) {
	req, out := c.DeregisterDeviceRequest(input)
	return out, req.Send()
}

// DeregisterDeviceWithContext is the same as DeregisterDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) DeregisterDeviceWithContext(ctx aws.Context, input *DeregisterDeviceInput, opts ...request.Option) (*DeregisterDeviceOutput, error) {
	req, out := c.DeregisterDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevice for more information on using the GetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeviceRequest method.
//	req, resp := client.GetDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/GetDevice
func (c *WorkSpacesThinClient) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/devices/{id}",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetDevice API operation for Amazon WorkSpaces Thin Client.
//
// Returns information for a thin client device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation GetDevice for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/GetDevice
func (c *WorkSpacesThinClient) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	return out, req.Send()
}

// GetDeviceWithContext is the same as GetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) GetDeviceWithContext(ctx aws.Context, input *GetDeviceInput, opts ...request.Option) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentRequest method.
//	req, resp := client.GetEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/GetEnvironment
func (c *WorkSpacesThinClient) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{id}",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetEnvironment API operation for Amazon WorkSpaces Thin Client.
//
// Returns information for an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/GetEnvironment
func (c *WorkSpacesThinClient) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSoftwareSet = "GetSoftwareSet"

// GetSoftwareSetRequest generates a "aws/request.Request" representing the
// client's request for the GetSoftwareSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSoftwareSet for more information on using the GetSoftwareSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSoftwareSetRequest method.
//	req, resp := client.GetSoftwareSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/GetSoftwareSet
func (c *WorkSpacesThinClient) GetSoftwareSetRequest(input *GetSoftwareSetInput) (req *request.Request, output *GetSoftwareSetOutput) {
	op := &request.Operation{
		Name:       opGetSoftwareSet,
		HTTPMethod: "GET",
		HTTPPath:   "/softwaresets/{id}",
	}

	if input == nil {
		input = &GetSoftwareSetInput{}
	}

	output = &GetSoftwareSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetSoftwareSet API operation for Amazon WorkSpaces Thin Client.
//
// Returns information for a software set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation GetSoftwareSet for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/GetSoftwareSet
func (c *WorkSpacesThinClient) GetSoftwareSet(input *GetSoftwareSetInput) (*GetSoftwareSetOutput, error) {
	req, out := c.GetSoftwareSetRequest(input)
	return out, req.Send()
}

// GetSoftwareSetWithContext is the same as GetSoftwareSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetSoftwareSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) GetSoftwareSetWithContext(ctx aws.Context, input *GetSoftwareSetInput, opts ...request.Option) (*GetSoftwareSetOutput, error) {
	req, out := c.GetSoftwareSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDevicesRequest method.
//	req, resp := client.ListDevicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListDevices
func (c *WorkSpacesThinClient) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/devices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListDevices API operation for Amazon WorkSpaces Thin Client.
//
// Returns a list of thin client devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation ListDevices for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListDevices
func (c *WorkSpacesThinClient) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicesPages iterates over the pages of a ListDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDevices operation.
//	pageNum := 0
//	err := client.ListDevicesPages(params,
//	    func(page *workspacesthinclient.ListDevicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesThinClient) ListDevicesPages(input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool) error {
	return c.ListDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicesPagesWithContext same as ListDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) ListDevicesPagesWithContext(ctx aws.Context, input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentsRequest method.
//	req, resp := client.ListEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListEnvironments
func (c *WorkSpacesThinClient) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListEnvironments API operation for Amazon WorkSpaces Thin Client.
//
// Returns a list of environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListEnvironments
func (c *WorkSpacesThinClient) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironments operation.
//	pageNum := 0
//	err := client.ListEnvironmentsPages(params,
//	    func(page *workspacesthinclient.ListEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesThinClient) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSoftwareSets = "ListSoftwareSets"

// ListSoftwareSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSoftwareSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSoftwareSets for more information on using the ListSoftwareSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSoftwareSetsRequest method.
//	req, resp := client.ListSoftwareSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListSoftwareSets
func (c *WorkSpacesThinClient) ListSoftwareSetsRequest(input *ListSoftwareSetsInput) (req *request.Request, output *ListSoftwareSetsOutput) {
	op := &request.Operation{
		Name:       opListSoftwareSets,
		HTTPMethod: "GET",
		HTTPPath:   "/softwaresets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSoftwareSetsInput{}
	}

	output = &ListSoftwareSetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSoftwareSets API operation for Amazon WorkSpaces Thin Client.
//
// Returns a list of software sets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation ListSoftwareSets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListSoftwareSets
func (c *WorkSpacesThinClient) ListSoftwareSets(input *ListSoftwareSetsInput) (*ListSoftwareSetsOutput, error) {
	req, out := c.ListSoftwareSetsRequest(input)
	return out, req.Send()
}

// ListSoftwareSetsWithContext is the same as ListSoftwareSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSoftwareSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) ListSoftwareSetsWithContext(ctx aws.Context, input *ListSoftwareSetsInput, opts ...request.Option) (*ListSoftwareSetsOutput, error) {
	req, out := c.ListSoftwareSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSoftwareSetsPages iterates over the pages of a ListSoftwareSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSoftwareSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSoftwareSets operation.
//	pageNum := 0
//	err := client.ListSoftwareSetsPages(params,
//	    func(page *workspacesthinclient.ListSoftwareSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesThinClient) ListSoftwareSetsPages(input *ListSoftwareSetsInput, fn func(*ListSoftwareSetsOutput, bool) bool) error {
	return c.ListSoftwareSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSoftwareSetsPagesWithContext same as ListSoftwareSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) ListSoftwareSetsPagesWithContext(ctx aws.Context, input *ListSoftwareSetsInput, fn func(*ListSoftwareSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSoftwareSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSoftwareSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSoftwareSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListTagsForResource
func (c *WorkSpacesThinClient) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for Amazon WorkSpaces Thin Client.
//
// Returns a list of tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - InternalServiceException
//     Request processing failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/ListTagsForResource
func (c *WorkSpacesThinClient) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/TagResource
func (c *WorkSpacesThinClient) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for Amazon WorkSpaces Thin Client.
//
// Assigns one or more tags (key-value pairs) to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - InternalServiceException
//     Request processing failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/TagResource
func (c *WorkSpacesThinClient) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UntagResource
func (c *WorkSpacesThinClient) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for Amazon WorkSpaces Thin Client.
//
// Removes a tag or tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - InternalServiceException
//     Request processing failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UntagResource
func (c *WorkSpacesThinClient) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevice = "UpdateDevice"

// UpdateDeviceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevice for more information on using the UpdateDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDeviceRequest method.
//	req, resp := client.UpdateDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UpdateDevice
func (c *WorkSpacesThinClient) UpdateDeviceRequest(input *UpdateDeviceInput) (req *request.Request, output *UpdateDeviceOutput) {
	op := &request.Operation{
		Name:       opUpdateDevice,
		HTTPMethod: "PATCH",
		HTTPPath:   "/devices/{id}",
	}

	if input == nil {
		input = &UpdateDeviceInput{}
	}

	output = &UpdateDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateDevice API operation for Amazon WorkSpaces Thin Client.
//
// Updates a thin client device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation UpdateDevice for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UpdateDevice
func (c *WorkSpacesThinClient) UpdateDevice(input *UpdateDeviceInput) (*UpdateDeviceOutput, error) {
	req, out := c.UpdateDeviceRequest(input)
	return out, req.Send()
}

// UpdateDeviceWithContext is the same as UpdateDevice with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) UpdateDeviceWithContext(ctx aws.Context, input *UpdateDeviceInput, opts ...request.Option) (*UpdateDeviceOutput, error) {
	req, out := c.UpdateDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentRequest method.
//	req, resp := client.UpdateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UpdateEnvironment
func (c *WorkSpacesThinClient) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/environments/{id}",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateEnvironment API operation for Amazon WorkSpaces Thin Client.
//
// Updates an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UpdateEnvironment
func (c *WorkSpacesThinClient) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSoftwareSet = "UpdateSoftwareSet"

// UpdateSoftwareSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSoftwareSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSoftwareSet for more information on using the UpdateSoftwareSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSoftwareSetRequest method.
//	req, resp := client.UpdateSoftwareSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UpdateSoftwareSet
func (c *WorkSpacesThinClient) UpdateSoftwareSetRequest(input *UpdateSoftwareSetInput) (req *request.Request, output *UpdateSoftwareSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSoftwareSet,
		HTTPMethod: "PATCH",
		HTTPPath:   "/softwaresets/{id}",
	}

	if input == nil {
		input = &UpdateSoftwareSetInput{}
	}

	output = &UpdateSoftwareSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateSoftwareSet API operation for Amazon WorkSpaces Thin Client.
//
// Updates a software set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Thin Client's
// API operation UpdateSoftwareSet for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-thin-client-2023-08-22/UpdateSoftwareSet
func (c *WorkSpacesThinClient) UpdateSoftwareSet(input *UpdateSoftwareSetInput) (*UpdateSoftwareSetOutput, error) {
	req, out := c.UpdateSoftwareSetRequest(input)
	return out, req.Send()
}

// UpdateSoftwareSetWithContext is the same as UpdateSoftwareSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSoftwareSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesThinClient) UpdateSoftwareSetWithContext(ctx aws.Context, input *UpdateSoftwareSetInput, opts ...request.Option) (*UpdateSoftwareSetOutput, error) {
	req, out := c.UpdateSoftwareSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource associated with the request.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource associated with the request.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the software set to apply.
	DesiredSoftwareSetId *string `locationName:"desiredSoftwareSetId" type:"string"`

	// The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces,
	// WorkSpaces Web, or AppStream 2.0.
	//
	// DesktopArn is a required field
	DesktopArn *string `locationName:"desktopArn" min:"20" type:"string" required:"true"`

	// The URL for the identity provider login (only for environments that use AppStream
	// 2.0).
	//
	// DesktopEndpoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentInput's
	// String and GoString methods.
	DesktopEndpoint *string `locationName:"desktopEndpoint" min:"1" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the Key Management Service key to use to
	// encrypt the environment.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// A specification for a time window to apply software updates.
	MaintenanceWindow *MaintenanceWindow `locationName:"maintenanceWindow" type:"structure"`

	// The name for the environment.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentInput's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// An option to define which software updates to apply.
	SoftwareSetUpdateMode *string `locationName:"softwareSetUpdateMode" type:"string" enum:"SoftwareSetUpdateMode"`

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule *string `locationName:"softwareSetUpdateSchedule" type:"string" enum:"SoftwareSetUpdateSchedule"`

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DesktopArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DesktopArn"))
	}
	if s.DesktopArn != nil && len(*s.DesktopArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DesktopArn", 20))
	}
	if s.DesktopEndpoint != nil && len(*s.DesktopEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesktopEndpoint", 1))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.MaintenanceWindow != nil {
		if err := s.MaintenanceWindow.Validate(); err != nil {
			invalidParams.AddNested("MaintenanceWindow", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEnvironmentInput) SetClientToken(v string) *CreateEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetDesiredSoftwareSetId sets the DesiredSoftwareSetId field's value.
func (s *CreateEnvironmentInput) SetDesiredSoftwareSetId(v string) *CreateEnvironmentInput {
	s.DesiredSoftwareSetId = &v
	return s
}

// SetDesktopArn sets the DesktopArn field's value.
func (s *CreateEnvironmentInput) SetDesktopArn(v string) *CreateEnvironmentInput {
	s.DesktopArn = &v
	return s
}

// SetDesktopEndpoint sets the DesktopEndpoint field's value.
func (s *CreateEnvironmentInput) SetDesktopEndpoint(v string) *CreateEnvironmentInput {
	s.DesktopEndpoint = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateEnvironmentInput) SetKmsKeyArn(v string) *CreateEnvironmentInput {
	s.KmsKeyArn = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *CreateEnvironmentInput) SetMaintenanceWindow(v *MaintenanceWindow) *CreateEnvironmentInput {
	s.MaintenanceWindow = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetSoftwareSetUpdateMode sets the SoftwareSetUpdateMode field's value.
func (s *CreateEnvironmentInput) SetSoftwareSetUpdateMode(v string) *CreateEnvironmentInput {
	s.SoftwareSetUpdateMode = &v
	return s
}

// SetSoftwareSetUpdateSchedule sets the SoftwareSetUpdateSchedule field's value.
func (s *CreateEnvironmentInput) SetSoftwareSetUpdateSchedule(v string) *CreateEnvironmentInput {
	s.SoftwareSetUpdateSchedule = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v map[string]*string) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// Describes an environment.
	Environment *EnvironmentSummary `locationName:"environment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *CreateEnvironmentOutput) SetEnvironment(v *EnvironmentSummary) *CreateEnvironmentOutput {
	s.Environment = v
	return s
}

type DeleteDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the device to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeviceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteDeviceInput) SetClientToken(v string) *DeleteDeviceInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteDeviceInput) SetId(v string) *DeleteDeviceInput {
	s.Id = &v
	return s
}

type DeleteDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceOutput) GoString() string {
	return s.String()
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the environment to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteEnvironmentInput) SetClientToken(v string) *DeleteEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteEnvironmentInput) SetId(v string) *DeleteEnvironmentInput {
	s.Id = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

type DeregisterDeviceInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the device to deregister.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The desired new status for the device.
	TargetDeviceStatus *string `locationName:"targetDeviceStatus" type:"string" enum:"TargetDeviceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterDeviceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeregisterDeviceInput) SetClientToken(v string) *DeregisterDeviceInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeregisterDeviceInput) SetId(v string) *DeregisterDeviceInput {
	s.Id = &v
	return s
}

// SetTargetDeviceStatus sets the TargetDeviceStatus field's value.
func (s *DeregisterDeviceInput) SetTargetDeviceStatus(v string) *DeregisterDeviceInput {
	s.TargetDeviceStatus = &v
	return s
}

type DeregisterDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDeviceOutput) GoString() string {
	return s.String()
}

// Describes a thin client device.
type Device struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the device.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The timestamp of when the device was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the software set currently installed on the device.
	CurrentSoftwareSetId *string `locationName:"currentSoftwareSetId" type:"string"`

	// The version of the software set currently installed on the device.
	CurrentSoftwareSetVersion *string `locationName:"currentSoftwareSetVersion" type:"string"`

	// The ID of the software set which the device has been set to.
	DesiredSoftwareSetId *string `locationName:"desiredSoftwareSetId" type:"string"`

	// The ID of the environment the device is associated with.
	EnvironmentId *string `locationName:"environmentId" type:"string"`

	// The ID of the device.
	Id *string `locationName:"id" type:"string"`

	// The Amazon Resource Name (ARN) of the Key Management Service key used to
	// encrypt the device.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The timestamp of the most recent session on the device.
	LastConnectedAt *time.Time `locationName:"lastConnectedAt" type:"timestamp"`

	// The timestamp of the most recent check-in of the device.
	LastPostureAt *time.Time `locationName:"lastPostureAt" type:"timestamp"`

	// The model number of the device.
	Model *string `locationName:"model" type:"string"`

	// The name of the device.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Device's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The ID of the software set that is pending to be installed on the device.
	PendingSoftwareSetId *string `locationName:"pendingSoftwareSetId" type:"string"`

	// The version of the software set that is pending to be installed on the device.
	PendingSoftwareSetVersion *string `locationName:"pendingSoftwareSetVersion" type:"string"`

	// The hardware serial number of the device.
	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// Describes if the software currently installed on the device is a supported
	// version.
	SoftwareSetComplianceStatus *string `locationName:"softwareSetComplianceStatus" type:"string" enum:"DeviceSoftwareSetComplianceStatus"`

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule *string `locationName:"softwareSetUpdateSchedule" type:"string" enum:"SoftwareSetUpdateSchedule"`

	// Describes if the device has a supported version of software installed.
	SoftwareSetUpdateStatus *string `locationName:"softwareSetUpdateStatus" type:"string" enum:"SoftwareSetUpdateStatus"`

	// The status of the device.
	Status *string `locationName:"status" type:"string" enum:"DeviceStatus"`

	// The tag keys and optional values for the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Device's
	// String and GoString methods.
	Tags *EmbeddedTag `locationName:"tags" type:"structure" sensitive:"true"`

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Device) SetArn(v string) *Device {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Device) SetCreatedAt(v time.Time) *Device {
	s.CreatedAt = &v
	return s
}

// SetCurrentSoftwareSetId sets the CurrentSoftwareSetId field's value.
func (s *Device) SetCurrentSoftwareSetId(v string) *Device {
	s.CurrentSoftwareSetId = &v
	return s
}

// SetCurrentSoftwareSetVersion sets the CurrentSoftwareSetVersion field's value.
func (s *Device) SetCurrentSoftwareSetVersion(v string) *Device {
	s.CurrentSoftwareSetVersion = &v
	return s
}

// SetDesiredSoftwareSetId sets the DesiredSoftwareSetId field's value.
func (s *Device) SetDesiredSoftwareSetId(v string) *Device {
	s.DesiredSoftwareSetId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *Device) SetEnvironmentId(v string) *Device {
	s.EnvironmentId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Device) SetId(v string) *Device {
	s.Id = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *Device) SetKmsKeyArn(v string) *Device {
	s.KmsKeyArn = &v
	return s
}

// SetLastConnectedAt sets the LastConnectedAt field's value.
func (s *Device) SetLastConnectedAt(v time.Time) *Device {
	s.LastConnectedAt = &v
	return s
}

// SetLastPostureAt sets the LastPostureAt field's value.
func (s *Device) SetLastPostureAt(v time.Time) *Device {
	s.LastPostureAt = &v
	return s
}

// SetModel sets the Model field's value.
func (s *Device) SetModel(v string) *Device {
	s.Model = &v
	return s
}

// SetName sets the Name field's value.
func (s *Device) SetName(v string) *Device {
	s.Name = &v
	return s
}

// SetPendingSoftwareSetId sets the PendingSoftwareSetId field's value.
func (s *Device) SetPendingSoftwareSetId(v string) *Device {
	s.PendingSoftwareSetId = &v
	return s
}

// SetPendingSoftwareSetVersion sets the PendingSoftwareSetVersion field's value.
func (s *Device) SetPendingSoftwareSetVersion(v string) *Device {
	s.PendingSoftwareSetVersion = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *Device) SetSerialNumber(v string) *Device {
	s.SerialNumber = &v
	return s
}

// SetSoftwareSetComplianceStatus sets the SoftwareSetComplianceStatus field's value.
func (s *Device) SetSoftwareSetComplianceStatus(v string) *Device {
	s.SoftwareSetComplianceStatus = &v
	return s
}

// SetSoftwareSetUpdateSchedule sets the SoftwareSetUpdateSchedule field's value.
func (s *Device) SetSoftwareSetUpdateSchedule(v string) *Device {
	s.SoftwareSetUpdateSchedule = &v
	return s
}

// SetSoftwareSetUpdateStatus sets the SoftwareSetUpdateStatus field's value.
func (s *Device) SetSoftwareSetUpdateStatus(v string) *Device {
	s.SoftwareSetUpdateStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Device) SetStatus(v string) *Device {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Device) SetTags(v *EmbeddedTag) *Device {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Device) SetUpdatedAt(v time.Time) *Device {
	s.UpdatedAt = &v
	return s
}

// Describes a thin client device.
type DeviceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the device.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The timestamp of when the device was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the software set currently installed on the device.
	CurrentSoftwareSetId *string `locationName:"currentSoftwareSetId" type:"string"`

	// The ID of the software set which the device has been set to.
	DesiredSoftwareSetId *string `locationName:"desiredSoftwareSetId" type:"string"`

	// The ID of the environment the device is associated with.
	EnvironmentId *string `locationName:"environmentId" type:"string"`

	// The ID of the device.
	Id *string `locationName:"id" type:"string"`

	// The timestamp of the most recent session on the device.
	LastConnectedAt *time.Time `locationName:"lastConnectedAt" type:"timestamp"`

	// The timestamp of the most recent check-in of the device.
	LastPostureAt *time.Time `locationName:"lastPostureAt" type:"timestamp"`

	// The model number of the device.
	Model *string `locationName:"model" type:"string"`

	// The name of the device.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeviceSummary's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The ID of the software set that is pending to be installed on the device.
	PendingSoftwareSetId *string `locationName:"pendingSoftwareSetId" type:"string"`

	// The hardware serial number of the device.
	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule *string `locationName:"softwareSetUpdateSchedule" type:"string" enum:"SoftwareSetUpdateSchedule"`

	// The status of the device.
	Status *string `locationName:"status" type:"string" enum:"DeviceStatus"`

	// The tag keys and optional values for the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeviceSummary's
	// String and GoString methods.
	Tags *EmbeddedTag `locationName:"tags" type:"structure" sensitive:"true"`

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeviceSummary) SetArn(v string) *DeviceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeviceSummary) SetCreatedAt(v time.Time) *DeviceSummary {
	s.CreatedAt = &v
	return s
}

// SetCurrentSoftwareSetId sets the CurrentSoftwareSetId field's value.
func (s *DeviceSummary) SetCurrentSoftwareSetId(v string) *DeviceSummary {
	s.CurrentSoftwareSetId = &v
	return s
}

// SetDesiredSoftwareSetId sets the DesiredSoftwareSetId field's value.
func (s *DeviceSummary) SetDesiredSoftwareSetId(v string) *DeviceSummary {
	s.DesiredSoftwareSetId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeviceSummary) SetEnvironmentId(v string) *DeviceSummary {
	s.EnvironmentId = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeviceSummary) SetId(v string) *DeviceSummary {
	s.Id = &v
	return s
}

// SetLastConnectedAt sets the LastConnectedAt field's value.
func (s *DeviceSummary) SetLastConnectedAt(v time.Time) *DeviceSummary {
	s.LastConnectedAt = &v
	return s
}

// SetLastPostureAt sets the LastPostureAt field's value.
func (s *DeviceSummary) SetLastPostureAt(v time.Time) *DeviceSummary {
	s.LastPostureAt = &v
	return s
}

// SetModel sets the Model field's value.
func (s *DeviceSummary) SetModel(v string) *DeviceSummary {
	s.Model = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeviceSummary) SetName(v string) *DeviceSummary {
	s.Name = &v
	return s
}

// SetPendingSoftwareSetId sets the PendingSoftwareSetId field's value.
func (s *DeviceSummary) SetPendingSoftwareSetId(v string) *DeviceSummary {
	s.PendingSoftwareSetId = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *DeviceSummary) SetSerialNumber(v string) *DeviceSummary {
	s.SerialNumber = &v
	return s
}

// SetSoftwareSetUpdateSchedule sets the SoftwareSetUpdateSchedule field's value.
func (s *DeviceSummary) SetSoftwareSetUpdateSchedule(v string) *DeviceSummary {
	s.SoftwareSetUpdateSchedule = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeviceSummary) SetStatus(v string) *DeviceSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeviceSummary) SetTags(v *EmbeddedTag) *DeviceSummary {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DeviceSummary) SetUpdatedAt(v time.Time) *DeviceSummary {
	s.UpdatedAt = &v
	return s
}

// The resource and internal ID of a resource to tag.
type EmbeddedTag struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The internal ID of a resource to tag.
	InternalId *string `locationName:"internalId" type:"string"`

	// The Amazon Resource Name (ARN) of a resource to tag.
	ResourceArn *string `locationName:"resourceArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedTag) GoString() string {
	return s.String()
}

// SetInternalId sets the InternalId field's value.
func (s *EmbeddedTag) SetInternalId(v string) *EmbeddedTag {
	s.InternalId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *EmbeddedTag) SetResourceArn(v string) *EmbeddedTag {
	s.ResourceArn = &v
	return s
}

// Describes an environment.
type Environment struct {
	_ struct{} `type:"structure"`

	// The activation code to register a device to the environment.
	ActivationCode *string `locationName:"activationCode" type:"string"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The timestamp of when the environment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the software set to apply.
	DesiredSoftwareSetId *string `locationName:"desiredSoftwareSetId" type:"string"`

	// The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces,
	// WorkSpaces Web, or AppStream 2.0.
	DesktopArn *string `locationName:"desktopArn" min:"20" type:"string"`

	// The URL for the identity provider login (only for environments that use AppStream
	// 2.0).
	//
	// DesktopEndpoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Environment's
	// String and GoString methods.
	DesktopEndpoint *string `locationName:"desktopEndpoint" min:"1" type:"string" sensitive:"true"`

	// The type of streaming desktop for the environment.
	DesktopType *string `locationName:"desktopType" type:"string" enum:"DesktopType"`

	// The ID of the environment.
	Id *string `locationName:"id" type:"string"`

	// The Amazon Resource Name (ARN) of the Key Management Service key used to
	// encrypt the environment.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// A specification for a time window to apply software updates.
	MaintenanceWindow *MaintenanceWindow `locationName:"maintenanceWindow" type:"structure"`

	// The name of the environment.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Environment's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The ID of the software set that is pending to be installed.
	PendingSoftwareSetId *string `locationName:"pendingSoftwareSetId" type:"string"`

	// The version of the software set that is pending to be installed.
	PendingSoftwareSetVersion *string `locationName:"pendingSoftwareSetVersion" type:"string"`

	// The number of devices registered to the environment.
	RegisteredDevicesCount *int64 `locationName:"registeredDevicesCount" type:"integer"`

	// Describes if the software currently installed on all devices in the environment
	// is a supported version.
	SoftwareSetComplianceStatus *string `locationName:"softwareSetComplianceStatus" type:"string" enum:"EnvironmentSoftwareSetComplianceStatus"`

	// An option to define which software updates to apply.
	SoftwareSetUpdateMode *string `locationName:"softwareSetUpdateMode" type:"string" enum:"SoftwareSetUpdateMode"`

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule *string `locationName:"softwareSetUpdateSchedule" type:"string" enum:"SoftwareSetUpdateSchedule"`

	// The tag keys and optional values for the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Environment's
	// String and GoString methods.
	Tags *EmbeddedTag `locationName:"tags" type:"structure" sensitive:"true"`

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) GoString() string {
	return s.String()
}

// SetActivationCode sets the ActivationCode field's value.
func (s *Environment) SetActivationCode(v string) *Environment {
	s.ActivationCode = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Environment) SetArn(v string) *Environment {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Environment) SetCreatedAt(v time.Time) *Environment {
	s.CreatedAt = &v
	return s
}

// SetDesiredSoftwareSetId sets the DesiredSoftwareSetId field's value.
func (s *Environment) SetDesiredSoftwareSetId(v string) *Environment {
	s.DesiredSoftwareSetId = &v
	return s
}

// SetDesktopArn sets the DesktopArn field's value.
func (s *Environment) SetDesktopArn(v string) *Environment {
	s.DesktopArn = &v
	return s
}

// SetDesktopEndpoint sets the DesktopEndpoint field's value.
func (s *Environment) SetDesktopEndpoint(v string) *Environment {
	s.DesktopEndpoint = &v
	return s
}

// SetDesktopType sets the DesktopType field's value.
func (s *Environment) SetDesktopType(v string) *Environment {
	s.DesktopType = &v
	return s
}

// SetId sets the Id field's value.
func (s *Environment) SetId(v string) *Environment {
	s.Id = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *Environment) SetKmsKeyArn(v string) *Environment {
	s.KmsKeyArn = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *Environment) SetMaintenanceWindow(v *MaintenanceWindow) *Environment {
	s.MaintenanceWindow = v
	return s
}

// SetName sets the Name field's value.
func (s *Environment) SetName(v string) *Environment {
	s.Name = &v
	return s
}

// SetPendingSoftwareSetId sets the PendingSoftwareSetId field's value.
func (s *Environment) SetPendingSoftwareSetId(v string) *Environment {
	s.PendingSoftwareSetId = &v
	return s
}

// SetPendingSoftwareSetVersion sets the PendingSoftwareSetVersion field's value.
func (s *Environment) SetPendingSoftwareSetVersion(v string) *Environment {
	s.PendingSoftwareSetVersion = &v
	return s
}

// SetRegisteredDevicesCount sets the RegisteredDevicesCount field's value.
func (s *Environment) SetRegisteredDevicesCount(v int64) *Environment {
	s.RegisteredDevicesCount = &v
	return s
}

// SetSoftwareSetComplianceStatus sets the SoftwareSetComplianceStatus field's value.
func (s *Environment) SetSoftwareSetComplianceStatus(v string) *Environment {
	s.SoftwareSetComplianceStatus = &v
	return s
}

// SetSoftwareSetUpdateMode sets the SoftwareSetUpdateMode field's value.
func (s *Environment) SetSoftwareSetUpdateMode(v string) *Environment {
	s.SoftwareSetUpdateMode = &v
	return s
}

// SetSoftwareSetUpdateSchedule sets the SoftwareSetUpdateSchedule field's value.
func (s *Environment) SetSoftwareSetUpdateSchedule(v string) *Environment {
	s.SoftwareSetUpdateSchedule = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Environment) SetTags(v *EmbeddedTag) *Environment {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Environment) SetUpdatedAt(v time.Time) *Environment {
	s.UpdatedAt = &v
	return s
}

// Describes an environment.
type EnvironmentSummary struct {
	_ struct{} `type:"structure"`

	// The activation code to register a device to the environment.
	ActivationCode *string `locationName:"activationCode" type:"string"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The timestamp of when the environment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the software set to apply.
	DesiredSoftwareSetId *string `locationName:"desiredSoftwareSetId" type:"string"`

	// The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces,
	// WorkSpaces Web, or AppStream 2.0.
	DesktopArn *string `locationName:"desktopArn" min:"20" type:"string"`

	// The URL for the identity provider login (only for environments that use AppStream
	// 2.0).
	//
	// DesktopEndpoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	DesktopEndpoint *string `locationName:"desktopEndpoint" min:"1" type:"string" sensitive:"true"`

	// The type of streaming desktop for the environment.
	DesktopType *string `locationName:"desktopType" type:"string" enum:"DesktopType"`

	// The ID of the environment.
	Id *string `locationName:"id" type:"string"`

	// A specification for a time window to apply software updates.
	MaintenanceWindow *MaintenanceWindow `locationName:"maintenanceWindow" type:"structure"`

	// The name of the environment.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The ID of the software set that is pending to be installed.
	PendingSoftwareSetId *string `locationName:"pendingSoftwareSetId" type:"string"`

	// An option to define which software updates to apply.
	SoftwareSetUpdateMode *string `locationName:"softwareSetUpdateMode" type:"string" enum:"SoftwareSetUpdateMode"`

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule *string `locationName:"softwareSetUpdateSchedule" type:"string" enum:"SoftwareSetUpdateSchedule"`

	// The tag keys and optional values for the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	Tags *EmbeddedTag `locationName:"tags" type:"structure" sensitive:"true"`

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) GoString() string {
	return s.String()
}

// SetActivationCode sets the ActivationCode field's value.
func (s *EnvironmentSummary) SetActivationCode(v string) *EnvironmentSummary {
	s.ActivationCode = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *EnvironmentSummary) SetArn(v string) *EnvironmentSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentSummary) SetCreatedAt(v time.Time) *EnvironmentSummary {
	s.CreatedAt = &v
	return s
}

// SetDesiredSoftwareSetId sets the DesiredSoftwareSetId field's value.
func (s *EnvironmentSummary) SetDesiredSoftwareSetId(v string) *EnvironmentSummary {
	s.DesiredSoftwareSetId = &v
	return s
}

// SetDesktopArn sets the DesktopArn field's value.
func (s *EnvironmentSummary) SetDesktopArn(v string) *EnvironmentSummary {
	s.DesktopArn = &v
	return s
}

// SetDesktopEndpoint sets the DesktopEndpoint field's value.
func (s *EnvironmentSummary) SetDesktopEndpoint(v string) *EnvironmentSummary {
	s.DesktopEndpoint = &v
	return s
}

// SetDesktopType sets the DesktopType field's value.
func (s *EnvironmentSummary) SetDesktopType(v string) *EnvironmentSummary {
	s.DesktopType = &v
	return s
}

// SetId sets the Id field's value.
func (s *EnvironmentSummary) SetId(v string) *EnvironmentSummary {
	s.Id = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *EnvironmentSummary) SetMaintenanceWindow(v *MaintenanceWindow) *EnvironmentSummary {
	s.MaintenanceWindow = v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentSummary) SetName(v string) *EnvironmentSummary {
	s.Name = &v
	return s
}

// SetPendingSoftwareSetId sets the PendingSoftwareSetId field's value.
func (s *EnvironmentSummary) SetPendingSoftwareSetId(v string) *EnvironmentSummary {
	s.PendingSoftwareSetId = &v
	return s
}

// SetSoftwareSetUpdateMode sets the SoftwareSetUpdateMode field's value.
func (s *EnvironmentSummary) SetSoftwareSetUpdateMode(v string) *EnvironmentSummary {
	s.SoftwareSetUpdateMode = &v
	return s
}

// SetSoftwareSetUpdateSchedule sets the SoftwareSetUpdateSchedule field's value.
func (s *EnvironmentSummary) SetSoftwareSetUpdateSchedule(v string) *EnvironmentSummary {
	s.SoftwareSetUpdateSchedule = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EnvironmentSummary) SetTags(v *EmbeddedTag) *EnvironmentSummary {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *EnvironmentSummary) SetUpdatedAt(v time.Time) *EnvironmentSummary {
	s.UpdatedAt = &v
	return s
}

type GetDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the device for which to return information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetDeviceInput) SetId(v string) *GetDeviceInput {
	s.Id = &v
	return s
}

type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Describes an device.
	Device *Device `locationName:"device" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *GetDeviceOutput) SetDevice(v *Device) *GetDeviceOutput {
	s.Device = v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the environment for which to return information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetEnvironmentInput) SetId(v string) *GetEnvironmentInput {
	s.Id = &v
	return s
}

type GetEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// Describes an environment.
	Environment *Environment `locationName:"environment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *GetEnvironmentOutput) SetEnvironment(v *Environment) *GetEnvironmentOutput {
	s.Environment = v
	return s
}

type GetSoftwareSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the software set for which to return information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSoftwareSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSoftwareSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSoftwareSetInput) SetId(v string) *GetSoftwareSetInput {
	s.Id = &v
	return s
}

type GetSoftwareSetOutput struct {
	_ struct{} `type:"structure"`

	// Describes a software set.
	SoftwareSet *SoftwareSet `locationName:"softwareSet" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareSetOutput) GoString() string {
	return s.String()
}

// SetSoftwareSet sets the SoftwareSet field's value.
func (s *GetSoftwareSetOutput) SetSoftwareSet(v *SoftwareSet) *GetSoftwareSetOutput {
	s.SoftwareSet = v
	return s
}

// The server encountered an internal error and is unable to complete the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the next request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request processing failed due to some unknown error, exception, or failure.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the next request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDevicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevicesInput) SetMaxResults(v int64) *ListDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesInput) SetNextToken(v string) *ListDevicesInput {
	s.NextToken = &v
	return s
}

type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// Describes devices.
	Devices []*DeviceSummary `locationName:"devices" type:"list"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*DeviceSummary) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesOutput) SetNextToken(v string) *ListDevicesOutput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// Describes environments.
	Environments []*EnvironmentSummary `locationName:"environments" type:"list"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *ListEnvironmentsOutput) SetEnvironments(v []*EnvironmentSummary) *ListEnvironmentsOutput {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListSoftwareSetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSoftwareSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSoftwareSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSoftwareSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSoftwareSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSoftwareSetsInput) SetMaxResults(v int64) *ListSoftwareSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSoftwareSetsInput) SetNextToken(v string) *ListSoftwareSetsInput {
	s.NextToken = &v
	return s
}

type ListSoftwareSetsOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Describes software sets.
	SoftwareSets []*SoftwareSetSummary `locationName:"softwareSets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSoftwareSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSoftwareSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSoftwareSetsOutput) SetNextToken(v string) *ListSoftwareSetsOutput {
	s.NextToken = &v
	return s
}

// SetSoftwareSets sets the SoftwareSets field's value.
func (s *ListSoftwareSetsOutput) SetSoftwareSets(v []*SoftwareSetSummary) *ListSoftwareSetsOutput {
	s.SoftwareSets = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource for which you want to retrieve
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map of the key-value pairs for the tag or tags assigned to the specified
	// resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Describes the maintenance window for a thin client device.
type MaintenanceWindow struct {
	_ struct{} `type:"structure"`

	// The option to set the maintenance window during the device local time or
	// Universal Coordinated Time (UTC).
	ApplyTimeOf *string `locationName:"applyTimeOf" type:"string" enum:"ApplyTimeOf"`

	// The days of the week during which the maintenance window is open.
	DaysOfTheWeek []*string `locationName:"daysOfTheWeek" min:"1" type:"list" enum:"DayOfWeek"`

	// The hour for the maintenance window end (00-23).
	EndTimeHour *int64 `locationName:"endTimeHour" type:"integer"`

	// The minutes for the maintenance window end (00-59).
	EndTimeMinute *int64 `locationName:"endTimeMinute" type:"integer"`

	// The hour for the maintenance window start (00-23).
	StartTimeHour *int64 `locationName:"startTimeHour" type:"integer"`

	// The minutes past the hour for the maintenance window start (00-59).
	StartTimeMinute *int64 `locationName:"startTimeMinute" type:"integer"`

	// An option to select the default or custom maintenance window.
	Type *string `locationName:"type" type:"string" enum:"MaintenanceWindowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaintenanceWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaintenanceWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaintenanceWindow"}
	if s.DaysOfTheWeek != nil && len(s.DaysOfTheWeek) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DaysOfTheWeek", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyTimeOf sets the ApplyTimeOf field's value.
func (s *MaintenanceWindow) SetApplyTimeOf(v string) *MaintenanceWindow {
	s.ApplyTimeOf = &v
	return s
}

// SetDaysOfTheWeek sets the DaysOfTheWeek field's value.
func (s *MaintenanceWindow) SetDaysOfTheWeek(v []*string) *MaintenanceWindow {
	s.DaysOfTheWeek = v
	return s
}

// SetEndTimeHour sets the EndTimeHour field's value.
func (s *MaintenanceWindow) SetEndTimeHour(v int64) *MaintenanceWindow {
	s.EndTimeHour = &v
	return s
}

// SetEndTimeMinute sets the EndTimeMinute field's value.
func (s *MaintenanceWindow) SetEndTimeMinute(v int64) *MaintenanceWindow {
	s.EndTimeMinute = &v
	return s
}

// SetStartTimeHour sets the StartTimeHour field's value.
func (s *MaintenanceWindow) SetStartTimeHour(v int64) *MaintenanceWindow {
	s.StartTimeHour = &v
	return s
}

// SetStartTimeMinute sets the StartTimeMinute field's value.
func (s *MaintenanceWindow) SetStartTimeMinute(v int64) *MaintenanceWindow {
	s.StartTimeMinute = &v
	return s
}

// SetType sets the Type field's value.
func (s *MaintenanceWindow) SetType(v string) *MaintenanceWindow {
	s.Type = &v
	return s
}

// The resource specified in the request was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource associated with the request.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource associated with the request.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code for the quota in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The ID of the resource that exceeds the service quota.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource that exceeds the service quota.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The code for the service in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes software.
type Software struct {
	_ struct{} `type:"structure"`

	// The name of the software component.
	Name *string `locationName:"name" type:"string"`

	// The version of the software component.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Software) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Software) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Software) SetName(v string) *Software {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Software) SetVersion(v string) *Software {
	s.Version = &v
	return s
}

// Describes a software set.
type SoftwareSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the software set.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the software set.
	Id *string `locationName:"id" type:"string"`

	// The timestamp of when the software set was released.
	ReleasedAt *time.Time `locationName:"releasedAt" type:"timestamp"`

	// A list of the software components in the software set.
	Software []*Software `locationName:"software" type:"list"`

	// The timestamp of the end of support for the software set.
	SupportedUntil *time.Time `locationName:"supportedUntil" type:"timestamp"`

	// An option to define if the software set has been validated.
	ValidationStatus *string `locationName:"validationStatus" type:"string" enum:"SoftwareSetValidationStatus"`

	// The version of the software set.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareSet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SoftwareSet) SetArn(v string) *SoftwareSet {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *SoftwareSet) SetId(v string) *SoftwareSet {
	s.Id = &v
	return s
}

// SetReleasedAt sets the ReleasedAt field's value.
func (s *SoftwareSet) SetReleasedAt(v time.Time) *SoftwareSet {
	s.ReleasedAt = &v
	return s
}

// SetSoftware sets the Software field's value.
func (s *SoftwareSet) SetSoftware(v []*Software) *SoftwareSet {
	s.Software = v
	return s
}

// SetSupportedUntil sets the SupportedUntil field's value.
func (s *SoftwareSet) SetSupportedUntil(v time.Time) *SoftwareSet {
	s.SupportedUntil = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *SoftwareSet) SetValidationStatus(v string) *SoftwareSet {
	s.ValidationStatus = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SoftwareSet) SetVersion(v string) *SoftwareSet {
	s.Version = &v
	return s
}

// Describes a software set.
type SoftwareSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the software set.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the software set.
	Id *string `locationName:"id" type:"string"`

	// The timestamp of when the software set was released.
	ReleasedAt *time.Time `locationName:"releasedAt" type:"timestamp"`

	// The timestamp of the end of support for the software set.
	SupportedUntil *time.Time `locationName:"supportedUntil" type:"timestamp"`

	// An option to define if the software set has been validated.
	ValidationStatus *string `locationName:"validationStatus" type:"string" enum:"SoftwareSetValidationStatus"`

	// The version of the software set.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareSetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SoftwareSetSummary) SetArn(v string) *SoftwareSetSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *SoftwareSetSummary) SetId(v string) *SoftwareSetSummary {
	s.Id = &v
	return s
}

// SetReleasedAt sets the ReleasedAt field's value.
func (s *SoftwareSetSummary) SetReleasedAt(v time.Time) *SoftwareSetSummary {
	s.ReleasedAt = &v
	return s
}

// SetSupportedUntil sets the SupportedUntil field's value.
func (s *SoftwareSetSummary) SetSupportedUntil(v time.Time) *SoftwareSetSummary {
	s.SupportedUntil = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *SoftwareSetSummary) SetValidationStatus(v string) *SoftwareSetSummary {
	s.ValidationStatus = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SoftwareSetSummary) SetVersion(v string) *SoftwareSetSummary {
	s.Version = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code for the quota in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The number of seconds to wait before retrying the next request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code for the service in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource that you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the key-value pairs for the tag or tags you want to remove from
	// the specified resource.
	//
	// TagKeys is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the software set to apply.
	DesiredSoftwareSetId *string `locationName:"desiredSoftwareSetId" type:"string"`

	// The ID of the device to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Key Management Service key to use for
	// the update.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The name of the device to update.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateDeviceInput's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule *string `locationName:"softwareSetUpdateSchedule" type:"string" enum:"SoftwareSetUpdateSchedule"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredSoftwareSetId sets the DesiredSoftwareSetId field's value.
func (s *UpdateDeviceInput) SetDesiredSoftwareSetId(v string) *UpdateDeviceInput {
	s.DesiredSoftwareSetId = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDeviceInput) SetId(v string) *UpdateDeviceInput {
	s.Id = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *UpdateDeviceInput) SetKmsKeyArn(v string) *UpdateDeviceInput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDeviceInput) SetName(v string) *UpdateDeviceInput {
	s.Name = &v
	return s
}

// SetSoftwareSetUpdateSchedule sets the SoftwareSetUpdateSchedule field's value.
func (s *UpdateDeviceInput) SetSoftwareSetUpdateSchedule(v string) *UpdateDeviceInput {
	s.SoftwareSetUpdateSchedule = &v
	return s
}

type UpdateDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Describes a device.
	Device *DeviceSummary `locationName:"device" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *UpdateDeviceOutput) SetDevice(v *DeviceSummary) *UpdateDeviceOutput {
	s.Device = v
	return s
}

type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the software set to apply.
	DesiredSoftwareSetId *string `locationName:"desiredSoftwareSetId" type:"string"`

	// The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces,
	// WorkSpaces Web, or AppStream 2.0.
	DesktopArn *string `locationName:"desktopArn" min:"20" type:"string"`

	// The URL for the identity provider login (only for environments that use AppStream
	// 2.0).
	//
	// DesktopEndpoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateEnvironmentInput's
	// String and GoString methods.
	DesktopEndpoint *string `locationName:"desktopEndpoint" min:"1" type:"string" sensitive:"true"`

	// The ID of the environment to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// A specification for a time window to apply software updates.
	MaintenanceWindow *MaintenanceWindow `locationName:"maintenanceWindow" type:"structure"`

	// The name of the environment to update.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateEnvironmentInput's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// An option to define which software updates to apply.
	SoftwareSetUpdateMode *string `locationName:"softwareSetUpdateMode" type:"string" enum:"SoftwareSetUpdateMode"`

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule *string `locationName:"softwareSetUpdateSchedule" type:"string" enum:"SoftwareSetUpdateSchedule"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.DesktopArn != nil && len(*s.DesktopArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DesktopArn", 20))
	}
	if s.DesktopEndpoint != nil && len(*s.DesktopEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesktopEndpoint", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.MaintenanceWindow != nil {
		if err := s.MaintenanceWindow.Validate(); err != nil {
			invalidParams.AddNested("MaintenanceWindow", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredSoftwareSetId sets the DesiredSoftwareSetId field's value.
func (s *UpdateEnvironmentInput) SetDesiredSoftwareSetId(v string) *UpdateEnvironmentInput {
	s.DesiredSoftwareSetId = &v
	return s
}

// SetDesktopArn sets the DesktopArn field's value.
func (s *UpdateEnvironmentInput) SetDesktopArn(v string) *UpdateEnvironmentInput {
	s.DesktopArn = &v
	return s
}

// SetDesktopEndpoint sets the DesktopEndpoint field's value.
func (s *UpdateEnvironmentInput) SetDesktopEndpoint(v string) *UpdateEnvironmentInput {
	s.DesktopEndpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateEnvironmentInput) SetId(v string) *UpdateEnvironmentInput {
	s.Id = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *UpdateEnvironmentInput) SetMaintenanceWindow(v *MaintenanceWindow) *UpdateEnvironmentInput {
	s.MaintenanceWindow = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentInput) SetName(v string) *UpdateEnvironmentInput {
	s.Name = &v
	return s
}

// SetSoftwareSetUpdateMode sets the SoftwareSetUpdateMode field's value.
func (s *UpdateEnvironmentInput) SetSoftwareSetUpdateMode(v string) *UpdateEnvironmentInput {
	s.SoftwareSetUpdateMode = &v
	return s
}

// SetSoftwareSetUpdateSchedule sets the SoftwareSetUpdateSchedule field's value.
func (s *UpdateEnvironmentInput) SetSoftwareSetUpdateSchedule(v string) *UpdateEnvironmentInput {
	s.SoftwareSetUpdateSchedule = &v
	return s
}

type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// Describes an environment.
	Environment *EnvironmentSummary `locationName:"environment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateEnvironmentOutput) SetEnvironment(v *EnvironmentSummary) *UpdateEnvironmentOutput {
	s.Environment = v
	return s
}

type UpdateSoftwareSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the software set to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// An option to define if the software set has been validated.
	//
	// ValidationStatus is a required field
	ValidationStatus *string `locationName:"validationStatus" type:"string" required:"true" enum:"SoftwareSetValidationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSoftwareSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSoftwareSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSoftwareSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSoftwareSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.ValidationStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateSoftwareSetInput) SetId(v string) *UpdateSoftwareSetInput {
	s.Id = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *UpdateSoftwareSetInput) SetValidationStatus(v string) *UpdateSoftwareSetInput {
	s.ValidationStatus = &v
	return s
}

type UpdateSoftwareSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSoftwareSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSoftwareSetOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the specified constraints.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of fields that didn't validate.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the exception.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message that describes the reason for the exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// ApplyTimeOfUtc is a ApplyTimeOf enum value
	ApplyTimeOfUtc = "UTC"

	// ApplyTimeOfDevice is a ApplyTimeOf enum value
	ApplyTimeOfDevice = "DEVICE"
)

// ApplyTimeOf_Values returns all elements of the ApplyTimeOf enum
func ApplyTimeOf_Values() []string {
	return []string{
		ApplyTimeOfUtc,
		ApplyTimeOfDevice,
	}
}

const (
	// DayOfWeekMonday is a DayOfWeek enum value
	DayOfWeekMonday = "MONDAY"

	// DayOfWeekTuesday is a DayOfWeek enum value
	DayOfWeekTuesday = "TUESDAY"

	// DayOfWeekWednesday is a DayOfWeek enum value
	DayOfWeekWednesday = "WEDNESDAY"

	// DayOfWeekThursday is a DayOfWeek enum value
	DayOfWeekThursday = "THURSDAY"

	// DayOfWeekFriday is a DayOfWeek enum value
	DayOfWeekFriday = "FRIDAY"

	// DayOfWeekSaturday is a DayOfWeek enum value
	DayOfWeekSaturday = "SATURDAY"

	// DayOfWeekSunday is a DayOfWeek enum value
	DayOfWeekSunday = "SUNDAY"
)

// DayOfWeek_Values returns all elements of the DayOfWeek enum
func DayOfWeek_Values() []string {
	return []string{
		DayOfWeekMonday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
		DayOfWeekThursday,
		DayOfWeekFriday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
	}
}

const (
	// DesktopTypeWorkspaces is a DesktopType enum value
	DesktopTypeWorkspaces = "workspaces"

	// DesktopTypeAppstream is a DesktopType enum value
	DesktopTypeAppstream = "appstream"

	// DesktopTypeWorkspacesWeb is a DesktopType enum value
	DesktopTypeWorkspacesWeb = "workspaces-web"
)

// DesktopType_Values returns all elements of the DesktopType enum
func DesktopType_Values() []string {
	return []string{
		DesktopTypeWorkspaces,
		DesktopTypeAppstream,
		DesktopTypeWorkspacesWeb,
	}
}

const (
	// DeviceSoftwareSetComplianceStatusNone is a DeviceSoftwareSetComplianceStatus enum value
	DeviceSoftwareSetComplianceStatusNone = "NONE"

	// DeviceSoftwareSetComplianceStatusCompliant is a DeviceSoftwareSetComplianceStatus enum value
	DeviceSoftwareSetComplianceStatusCompliant = "COMPLIANT"

	// DeviceSoftwareSetComplianceStatusNotCompliant is a DeviceSoftwareSetComplianceStatus enum value
	DeviceSoftwareSetComplianceStatusNotCompliant = "NOT_COMPLIANT"
)

// DeviceSoftwareSetComplianceStatus_Values returns all elements of the DeviceSoftwareSetComplianceStatus enum
func DeviceSoftwareSetComplianceStatus_Values() []string {
	return []string{
		DeviceSoftwareSetComplianceStatusNone,
		DeviceSoftwareSetComplianceStatusCompliant,
		DeviceSoftwareSetComplianceStatusNotCompliant,
	}
}

const (
	// DeviceStatusRegistered is a DeviceStatus enum value
	DeviceStatusRegistered = "REGISTERED"

	// DeviceStatusDeregistering is a DeviceStatus enum value
	DeviceStatusDeregistering = "DEREGISTERING"

	// DeviceStatusDeregistered is a DeviceStatus enum value
	DeviceStatusDeregistered = "DEREGISTERED"

	// DeviceStatusArchived is a DeviceStatus enum value
	DeviceStatusArchived = "ARCHIVED"
)

// DeviceStatus_Values returns all elements of the DeviceStatus enum
func DeviceStatus_Values() []string {
	return []string{
		DeviceStatusRegistered,
		DeviceStatusDeregistering,
		DeviceStatusDeregistered,
		DeviceStatusArchived,
	}
}

const (
	// EnvironmentSoftwareSetComplianceStatusNoRegisteredDevices is a EnvironmentSoftwareSetComplianceStatus enum value
	EnvironmentSoftwareSetComplianceStatusNoRegisteredDevices = "NO_REGISTERED_DEVICES"

	// EnvironmentSoftwareSetComplianceStatusCompliant is a EnvironmentSoftwareSetComplianceStatus enum value
	EnvironmentSoftwareSetComplianceStatusCompliant = "COMPLIANT"

	// EnvironmentSoftwareSetComplianceStatusNotCompliant is a EnvironmentSoftwareSetComplianceStatus enum value
	EnvironmentSoftwareSetComplianceStatusNotCompliant = "NOT_COMPLIANT"
)

// EnvironmentSoftwareSetComplianceStatus_Values returns all elements of the EnvironmentSoftwareSetComplianceStatus enum
func EnvironmentSoftwareSetComplianceStatus_Values() []string {
	return []string{
		EnvironmentSoftwareSetComplianceStatusNoRegisteredDevices,
		EnvironmentSoftwareSetComplianceStatusCompliant,
		EnvironmentSoftwareSetComplianceStatusNotCompliant,
	}
}

const (
	// MaintenanceWindowTypeSystem is a MaintenanceWindowType enum value
	MaintenanceWindowTypeSystem = "SYSTEM"

	// MaintenanceWindowTypeCustom is a MaintenanceWindowType enum value
	MaintenanceWindowTypeCustom = "CUSTOM"
)

// MaintenanceWindowType_Values returns all elements of the MaintenanceWindowType enum
func MaintenanceWindowType_Values() []string {
	return []string{
		MaintenanceWindowTypeSystem,
		MaintenanceWindowTypeCustom,
	}
}

const (
	// SoftwareSetUpdateModeUseLatest is a SoftwareSetUpdateMode enum value
	SoftwareSetUpdateModeUseLatest = "USE_LATEST"

	// SoftwareSetUpdateModeUseDesired is a SoftwareSetUpdateMode enum value
	SoftwareSetUpdateModeUseDesired = "USE_DESIRED"
)

// SoftwareSetUpdateMode_Values returns all elements of the SoftwareSetUpdateMode enum
func SoftwareSetUpdateMode_Values() []string {
	return []string{
		SoftwareSetUpdateModeUseLatest,
		SoftwareSetUpdateModeUseDesired,
	}
}

const (
	// SoftwareSetUpdateScheduleUseMaintenanceWindow is a SoftwareSetUpdateSchedule enum value
	SoftwareSetUpdateScheduleUseMaintenanceWindow = "USE_MAINTENANCE_WINDOW"

	// SoftwareSetUpdateScheduleApplyImmediately is a SoftwareSetUpdateSchedule enum value
	SoftwareSetUpdateScheduleApplyImmediately = "APPLY_IMMEDIATELY"
)

// SoftwareSetUpdateSchedule_Values returns all elements of the SoftwareSetUpdateSchedule enum
func SoftwareSetUpdateSchedule_Values() []string {
	return []string{
		SoftwareSetUpdateScheduleUseMaintenanceWindow,
		SoftwareSetUpdateScheduleApplyImmediately,
	}
}

const (
	// SoftwareSetUpdateStatusAvailable is a SoftwareSetUpdateStatus enum value
	SoftwareSetUpdateStatusAvailable = "AVAILABLE"

	// SoftwareSetUpdateStatusInProgress is a SoftwareSetUpdateStatus enum value
	SoftwareSetUpdateStatusInProgress = "IN_PROGRESS"

	// SoftwareSetUpdateStatusUpToDate is a SoftwareSetUpdateStatus enum value
	SoftwareSetUpdateStatusUpToDate = "UP_TO_DATE"
)

// SoftwareSetUpdateStatus_Values returns all elements of the SoftwareSetUpdateStatus enum
func SoftwareSetUpdateStatus_Values() []string {
	return []string{
		SoftwareSetUpdateStatusAvailable,
		SoftwareSetUpdateStatusInProgress,
		SoftwareSetUpdateStatusUpToDate,
	}
}

const (
	// SoftwareSetValidationStatusValidated is a SoftwareSetValidationStatus enum value
	SoftwareSetValidationStatusValidated = "VALIDATED"

	// SoftwareSetValidationStatusNotValidated is a SoftwareSetValidationStatus enum value
	SoftwareSetValidationStatusNotValidated = "NOT_VALIDATED"
)

// SoftwareSetValidationStatus_Values returns all elements of the SoftwareSetValidationStatus enum
func SoftwareSetValidationStatus_Values() []string {
	return []string{
		SoftwareSetValidationStatusValidated,
		SoftwareSetValidationStatusNotValidated,
	}
}

const (
	// TargetDeviceStatusDeregistered is a TargetDeviceStatus enum value
	TargetDeviceStatusDeregistered = "DEREGISTERED"

	// TargetDeviceStatusArchived is a TargetDeviceStatus enum value
	TargetDeviceStatusArchived = "ARCHIVED"
)

// TargetDeviceStatus_Values returns all elements of the TargetDeviceStatus enum
func TargetDeviceStatus_Values() []string {
	return []string{
		TargetDeviceStatusDeregistered,
		TargetDeviceStatusArchived,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
