// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The request was rejected because the requester does not have permission to
// perform the requested operation.
type CloudHsmAccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudHsmAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmAccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmAccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudHsmAccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudHsmAccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because of an CloudHSM internal failure. The request
// can be retried.
type CloudHsmInternalFailureException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudHsmInternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmInternalFailureException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmInternalFailureException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudHsmInternalFailureException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudHsmInternalFailureException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The request was rejected because it is not a valid request.
type CloudHsmInvalidRequestException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudHsmInvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmInvalidRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmInvalidRequestException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudHsmInvalidRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudHsmInvalidRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it refers to a resource that cannot be found.
type CloudHsmResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudHsmResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudHsmResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudHsmResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because an error occurred.
type CloudHsmServiceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudHsmServiceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmServiceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmServiceException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudHsmServiceException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudHsmServiceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because of a tagging failure. Verify the tag
// conditions in all applicable policies, and then retry the request.
type CloudHsmTagException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudHsmTagException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmTagException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmTagException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudHsmTagException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudHsmTagException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
