// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Exception thrown when the customer does not have a valid subscription for the
// product.
type CustomerNotEntitledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomerNotEntitledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomerNotEntitledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomerNotEntitledException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomerNotEntitledException"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomerNotEntitledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The API is disabled in the Region.
type DisabledApiException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DisabledApiException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DisabledApiException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DisabledApiException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DisabledApiException"
	}
	return *e.ErrorCodeOverride
}
func (e *DisabledApiException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A metering record has already been emitted by the same EC2 instance, ECS task,
// or EKS pod for the given { usageDimension , timestamp } with a different
// usageQuantity .
type DuplicateRequestException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateRequestException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The submitted registration token has expired. This can happen if the buyer's
// browser takes too long to redirect to your page, the buyer has resubmitted the
// registration token, or your application has held on to the registration token
// for too long. Your SaaS registration website should redeem this token as soon as
// it is submitted by the buyer's browser.
type ExpiredTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ExpiredTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ExpiredTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ExpiredTokenException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ExpiredTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *ExpiredTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An internal error has occurred. Retry your request. If the problem persists,
// post a message with details on the AWS forums.
type InternalServiceErrorException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServiceErrorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServiceErrorException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalServiceErrorException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalServiceErrorException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// You have metered usage for a CustomerIdentifier that does not exist.
type InvalidCustomerIdentifierException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCustomerIdentifierException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCustomerIdentifierException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCustomerIdentifierException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCustomerIdentifierException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCustomerIdentifierException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The endpoint being called is in a AWS Region different from your EC2 instance,
// ECS task, or EKS pod. The Region of the Metering Service endpoint and the AWS
// Region of the resource must match.
type InvalidEndpointRegionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEndpointRegionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEndpointRegionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEndpointRegionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidEndpointRegionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEndpointRegionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The product code passed does not match the product code used for publishing the
// product.
type InvalidProductCodeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidProductCodeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidProductCodeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidProductCodeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidProductCodeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidProductCodeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Public Key version is invalid.
type InvalidPublicKeyVersionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPublicKeyVersionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPublicKeyVersionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPublicKeyVersionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPublicKeyVersionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPublicKeyVersionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// RegisterUsage must be called in the same AWS Region the ECS task was launched
// in. This prevents a container from hardcoding a Region (e.g.
// withRegion(“us-east-1”) when calling RegisterUsage .
type InvalidRegionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRegionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRegionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRegionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRegionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRegionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tag is invalid, or the number of tags is greater than 5.
type InvalidTagException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTagException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTagException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTagException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Registration token is invalid.
type InvalidTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTokenException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The usage allocation objects are invalid, or the number of allocations is
// greater than 500 for a single usage record.
type InvalidUsageAllocationsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidUsageAllocationsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUsageAllocationsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUsageAllocationsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidUsageAllocationsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidUsageAllocationsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The usage dimension does not match one of the UsageDimensions associated with
// products.
type InvalidUsageDimensionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidUsageDimensionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUsageDimensionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUsageDimensionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidUsageDimensionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidUsageDimensionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// AWS Marketplace does not support metering usage from the underlying platform.
// Currently, Amazon ECS, Amazon EKS, and AWS Fargate are supported.
type PlatformNotSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PlatformNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PlatformNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PlatformNotSupportedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PlatformNotSupportedException"
	}
	return *e.ErrorCodeOverride
}
func (e *PlatformNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The calls to the API are throttled.
type ThrottlingException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottlingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The timestamp value passed in the UsageRecord is out of allowed range.
//
// For BatchMeterUsage , if any of the records are outside of the allowed range,
// the entire batch is not processed. You must remove invalid records and try
// again.
type TimestampOutOfBoundsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TimestampOutOfBoundsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TimestampOutOfBoundsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TimestampOutOfBoundsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TimestampOutOfBoundsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TimestampOutOfBoundsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
