// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the directory for a particular update type.
func (c *Client) UpdateDirectorySetup(ctx context.Context, params *UpdateDirectorySetupInput, optFns ...func(*Options)) (*UpdateDirectorySetupOutput, error) {
	if params == nil {
		params = &UpdateDirectorySetupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDirectorySetup", params, optFns, c.addOperationUpdateDirectorySetupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDirectorySetupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDirectorySetupInput struct {

	// The identifier of the directory on which you want to perform the update.
	//
	// This member is required.
	DirectoryId *string

	// The type of update that needs to be performed on the directory. For example, OS.
	//
	// This member is required.
	UpdateType types.UpdateType

	// The boolean that specifies if a snapshot for the directory needs to be taken
	// before updating the directory.
	CreateSnapshotBeforeUpdate *bool

	// The settings for the OS update that needs to be performed on the directory.
	OSUpdateSettings *types.OSUpdateSettings

	noSmithyDocumentSerde
}

type UpdateDirectorySetupOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDirectorySetupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateDirectorySetup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateDirectorySetup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateDirectorySetupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDirectorySetup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDirectorySetup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ds",
		OperationName: "UpdateDirectorySetup",
	}
}
