// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package repository

import (
	"context"
	"testing"

	"code.forgejo.org/f3/gof3/v3/f3"
	helpers_repository "code.forgejo.org/f3/gof3/v3/forges/helpers/repository"
	"code.forgejo.org/f3/gof3/v3/logger"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
	"code.forgejo.org/f3/gof3/v3/util"

	"github.com/stretchr/testify/assert"
)

type repositoryMock struct {
	logger.Logger
	url string
}

func newRepositoryMock(url string) *repositoryMock {
	r := &repositoryMock{
		url: url,
	}
	r.SetLogger(logger.NewLogger())
	return r
}

func (o *repositoryMock) GetNode() generic.NodeInterface   { return nil }
func (o *repositoryMock) GetRepositoryInternalRef() string { return "" }
func (o *repositoryMock) GetRepositoryURL() string         { return o.url }
func (o *repositoryMock) ToFormat() f3.Interface           { return nil }
func (o *repositoryMock) SetFetchFunc(func(ctx context.Context, destination, internalRef string)) {
}

func (o *repositoryMock) GetPullRequestBranch(pr *f3.PullRequestBranch) *f3.PullRequestBranch {
	panic("")
}
func (o *repositoryMock) CreatePullRequestBranch(pr *f3.PullRequestBranch) {}
func (o *repositoryMock) DeletePullRequestBranch(pr *f3.PullRequestBranch) {}

func TestRepositoryHelper(t *testing.T) {
	url := t.TempDir()
	repositoryHelper := NewTestHelper(t, url, nil)
	repositoryHelper.CreateRepositoryContent("").PushMirror()

	h := helpers_repository.NewHelper(newRepositoryMock(url))
	assert.True(t, util.FileExists(h.Fetch(context.Background())))
}
