// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package filesystem

import (
	"context"

	filesystem_options "code.forgejo.org/f3/gof3/v3/forges/filesystem/options"
	"code.forgejo.org/f3/gof3/v3/kind"
	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
)

type treeDriver struct {
	generic.NullTreeDriver

	options *filesystem_options.Options
}

func newTreeDriver(tree generic.TreeInterface, anyOptions any) generic.TreeDriverInterface {
	driver := &treeDriver{
		options: anyOptions.(*filesystem_options.Options),
	}
	driver.SetTree(tree)
	driver.Init()
	return driver
}

func (o *treeDriver) AllocateID() bool { return false }

func (o *treeDriver) Factory(ctx context.Context, k kind.Kind) generic.NodeDriverInterface {
	content := o.GetTree().(f3_tree.TreeInterface).NewFormat(k)
	switch k {
	case f3_tree.KindRepository:
		return newRepositoryDriver(content)
	case f3_tree.KindAttachment:
		return newAttachmentDriver(content)
	case f3_tree.KindPullRequest:
		return newPullRequestDriver(ctx, content)
	default:
		return newNodeDriver(content)
	}
}
