/* gmpc-metadata-backdrop.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-metadata-backdrop.vala, do not modify */

/* Gnome Music Player Client
 * Copyright (C) 2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <metadata.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include "gmpc-extras.h"
#include <plugin.h>
#include <config1.h>
#include <main.h>
#include <gmpc-meta-watcher.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>


#define GMPC_META_DATA_WIDGETS_TYPE_BACKDROP (gmpc_meta_data_widgets_backdrop_get_type ())
#define GMPC_META_DATA_WIDGETS_BACKDROP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, GmpcMetaDataWidgetsBackdrop))
#define GMPC_META_DATA_WIDGETS_BACKDROP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, GmpcMetaDataWidgetsBackdropClass))
#define GMPC_META_DATA_WIDGETS_IS_BACKDROP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP))
#define GMPC_META_DATA_WIDGETS_IS_BACKDROP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP))
#define GMPC_META_DATA_WIDGETS_BACKDROP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, GmpcMetaDataWidgetsBackdropClass))

typedef struct _GmpcMetaDataWidgetsBackdrop GmpcMetaDataWidgetsBackdrop;
typedef struct _GmpcMetaDataWidgetsBackdropClass GmpcMetaDataWidgetsBackdropClass;
typedef struct _GmpcMetaDataWidgetsBackdropPrivate GmpcMetaDataWidgetsBackdropPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GmpcMetaDataWidgetsBackdrop {
	GtkEventBox parent_instance;
	GmpcMetaDataWidgetsBackdropPrivate * priv;
};

struct _GmpcMetaDataWidgetsBackdropClass {
	GtkEventBoxClass parent_class;
};

struct _GmpcMetaDataWidgetsBackdropPrivate {
	gchar* song_checksum;
	mpd_Song* cur_song;
	MetaDataType cur_type;
	GdkPixbuf* pb;
	GmpcModificationType mod_type;
	GmpcPixbufLoaderAsync* loader;
};


static gpointer gmpc_meta_data_widgets_backdrop_parent_class = NULL;

#define log_domain_mdbd "Gmpc.Widgets.MetaData.Backdrop"
GType gmpc_meta_data_widgets_backdrop_get_type (void) G_GNUC_CONST;
#define GMPC_META_DATA_WIDGETS_BACKDROP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, GmpcMetaDataWidgetsBackdropPrivate))
enum  {
	GMPC_META_DATA_WIDGETS_BACKDROP_DUMMY_PROPERTY
};
static void gmpc_meta_data_widgets_backdrop_set_from_item (GmpcMetaDataWidgetsBackdrop* self, const MetaData* item);
static void _lambda25_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaDataWidgetsBackdrop* self);
static void __lambda25__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self);
void gmpc_meta_data_widgets_backdrop_set_song (GmpcMetaDataWidgetsBackdrop* self, const mpd_Song* song);
GmpcMetaDataWidgetsBackdrop* gmpc_meta_data_widgets_backdrop_new (MetaDataType type);
GmpcMetaDataWidgetsBackdrop* gmpc_meta_data_widgets_backdrop_construct (GType object_type, MetaDataType type);
static void _lambda26_ (GtkWidget* source, GmpcMetaDataWidgetsBackdrop* self);
static void __lambda26__gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void _lambda27_ (const mpd_Song* csong, MetaDataType type, MetaDataResult _result_, const MetaData* met, GmpcMetaDataWidgetsBackdrop* self);
static void __lambda27__gmpc_meta_watcher_data_changed (GmpcMetaWatcher* _sender, const mpd_Song* song, MetaDataType type, MetaDataResult _result_, const MetaData* met, gpointer self);
static gboolean gmpc_meta_data_widgets_backdrop_container_expose (GmpcMetaDataWidgetsBackdrop* self, GtkWidget* ev, GdkEventExpose* event);
static gboolean _gmpc_meta_data_widgets_backdrop_container_expose_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static gboolean gmpc_meta_data_widgets_backdrop_button_press_event_callback (GmpcMetaDataWidgetsBackdrop* self, GdkEventButton* event);
static gboolean _gmpc_meta_data_widgets_backdrop_button_press_event_callback_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _lambda28_ (GtkMenuItem* source, GmpcMetaDataWidgetsBackdrop* self);
static void __lambda28__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void gmpc_meta_data_widgets_backdrop_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda25_ (GmpcPixbufLoaderAsync* source, GdkPixbuf* pixbuf, GmpcMetaDataWidgetsBackdrop* self) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->priv->pb);
	self->priv->pb = _tmp0_;
	g_log (log_domain_mdbd, G_LOG_LEVEL_DEBUG, "gmpc-metadata-backdrop.vala:63: Updating background");
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __lambda25__gmpc_pixbuf_loader_async_pixbuf_update (GmpcPixbufLoaderAsync* _sender, GdkPixbuf* pixbuf, gpointer self) {
	_lambda25_ (_sender, pixbuf, self);
}


static void gmpc_meta_data_widgets_backdrop_set_from_item (GmpcMetaDataWidgetsBackdrop* self, const MetaData* item) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->pb);
	self->priv->pb = NULL;
	if (item == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->song_checksum == NULL;
	}
	if (_tmp0_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
		return;
	}
	if (item->content_type == META_DATA_CONTENT_URI) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* uri;
		_tmp1_ = meta_data_get_uri (item);
		_tmp2_ = g_strdup (_tmp1_);
		uri = _tmp2_;
		if (uri != NULL) {
			GtkAllocation req = {0};
			gint width = 0;
			GtkAllocation _tmp3_ = {0};
			gint _tmp4_;
			gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
			req = _tmp3_;
			_tmp4_ = MAX (req.width, 400);
			width = _tmp4_;
			g_log (log_domain_mdbd, G_LOG_LEVEL_DEBUG, "gmpc-metadata-backdrop.vala:57: Getting image with size: %u", (guint) width);
			if (self->priv->loader == NULL) {
				GmpcPixbufLoaderAsync* _tmp5_ = NULL;
				_tmp5_ = gmpc_pixbuf_loader_async_new ();
				_g_object_unref0 (self->priv->loader);
				self->priv->loader = _tmp5_;
			}
			g_signal_connect_object (self->priv->loader, "pixbuf-update", (GCallback) __lambda25__gmpc_pixbuf_loader_async_pixbuf_update, self, 0);
			gmpc_pixbuf_loader_async_set_from_file (self->priv->loader, uri, width, -1, self->priv->mod_type);
		}
		_g_free0 (uri);
	}
}


/**
             * @param The #MPD.Song to set the background for or NULL to clear.
             *
             * Set the background for song, or clear the background.
             */
static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


void gmpc_meta_data_widgets_backdrop_set_song (GmpcMetaDataWidgetsBackdrop* self, const mpd_Song* song) {
	mpd_Song* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_ = NULL;
	MetaData* item;
	MetaData* _tmp5_ = NULL;
	MetaDataResult _tmp6_;
	MetaDataResult a;
	g_return_if_fail (self != NULL);
	_tmp0_ = _mpd_songDup0 (song);
	_mpd_freeSong0 (self->priv->cur_song);
	self->priv->cur_song = _tmp0_;
	if (song == NULL) {
		_g_free0 (self->priv->song_checksum);
		self->priv->song_checksum = NULL;
		gmpc_meta_data_widgets_backdrop_set_from_item (self, NULL);
		return;
	}
	_tmp1_ = mpd_song_checksum_type (song, self->priv->cur_type);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (self->priv->song_checksum, _tmp2_) == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = mpd_song_checksum_type (song, self->priv->cur_type);
	_g_free0 (self->priv->song_checksum);
	self->priv->song_checksum = _tmp4_;
	item = NULL;
	_tmp6_ = gmpc_meta_watcher_get_meta_path (gmw, song, self->priv->cur_type, &_tmp5_);
	_meta_data_free0 (item);
	item = _tmp5_;
	a = _tmp6_;
	if (a == META_DATA_AVAILABLE) {
		gmpc_meta_data_widgets_backdrop_set_from_item (self, item);
	} else {
		gmpc_meta_data_widgets_backdrop_set_from_item (self, NULL);
	}
	_meta_data_free0 (item);
}


/**
             * @param type The type of backdrop (artist or album image)
             * Create backdrop widget of type.
             * @return a new #Backdrop (of type #Gtk.Eventbox)
             */
static void _lambda26_ (GtkWidget* source, GmpcMetaDataWidgetsBackdrop* self) {
	g_return_if_fail (source != NULL);
	gdk_window_set_back_pixmap (source->window, NULL, TRUE);
}


static void __lambda26__gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	_lambda26_ (_sender, self);
}


static void _lambda27_ (const mpd_Song* csong, MetaDataType type, MetaDataResult _result_, const MetaData* met, GmpcMetaDataWidgetsBackdrop* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (csong != NULL);
	if (self->priv->song_checksum != NULL) {
		_tmp1_ = type == self->priv->cur_type;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = mpd_song_checksum_type (csong, self->priv->cur_type);
		_tmp3_ = _tmp2_;
		_tmp0_ = g_strcmp0 (self->priv->song_checksum, _tmp3_) == 0;
		_g_free0 (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp4_ = FALSE;
		if (met != NULL) {
			_tmp4_ = _result_ == META_DATA_AVAILABLE;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gmpc_meta_data_widgets_backdrop_set_from_item (self, met);
		} else {
			gmpc_meta_data_widgets_backdrop_set_from_item (self, NULL);
		}
	}
}


static void __lambda27__gmpc_meta_watcher_data_changed (GmpcMetaWatcher* _sender, const mpd_Song* song, MetaDataType type, MetaDataResult _result_, const MetaData* met, gpointer self) {
	_lambda27_ (song, type, _result_, met, self);
}


static gboolean _gmpc_meta_data_widgets_backdrop_container_expose_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = gmpc_meta_data_widgets_backdrop_container_expose (self, _sender, event);
	return result;
}


static gboolean _gmpc_meta_data_widgets_backdrop_button_press_event_callback_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_meta_data_widgets_backdrop_button_press_event_callback (self, event);
	return result;
}


GmpcMetaDataWidgetsBackdrop* gmpc_meta_data_widgets_backdrop_construct (GType object_type, MetaDataType type) {
	GmpcMetaDataWidgetsBackdrop * self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (GmpcMetaDataWidgetsBackdrop*) g_object_new (object_type, NULL);
	if (type == META_ARTIST_ART) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == META_ALBUM_ART;
	}
	g_assert (_tmp0_);
	self->priv->cur_type = type;
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __lambda26__gtk_widget_realize, self, 0);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, TRUE);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	g_signal_connect_object (gmw, "data-changed", (GCallback) __lambda27__gmpc_meta_watcher_data_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "expose-event", (GCallback) _gmpc_meta_data_widgets_backdrop_container_expose_gtk_widget_expose_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _gmpc_meta_data_widgets_backdrop_button_press_event_callback_gtk_widget_button_press_event, self, 0);
	return self;
}


GmpcMetaDataWidgetsBackdrop* gmpc_meta_data_widgets_backdrop_new (MetaDataType type) {
	return gmpc_meta_data_widgets_backdrop_construct (GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, type);
}


static void _lambda28_ (GtkMenuItem* source, GmpcMetaDataWidgetsBackdrop* self) {
	GmpcMetaDataEditWindow* _tmp0_ = NULL;
	GmpcMetaDataEditWindow* _tmp1_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gmpc_meta_data_edit_window_new (self->priv->cur_song, self->priv->cur_type);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (_tmp1_);
}


static void __lambda28__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda28_ (_sender, self);
}


static gboolean gmpc_meta_data_widgets_backdrop_button_press_event_callback (GmpcMetaDataWidgetsBackdrop* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* menu;
	const gchar* _tmp1_ = NULL;
	GtkImageMenuItem* _tmp2_ = NULL;
	GtkImageMenuItem* item;
	GtkImage* _tmp3_ = NULL;
	GtkImage* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->cur_song == NULL) {
		result = FALSE;
		return result;
	}
	if ((*event).button != 3) {
		result = FALSE;
		return result;
	}
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	menu = g_object_ref_sink (_tmp0_);
	_tmp1_ = _ ("Metadata selector");
	_tmp2_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp1_);
	item = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkImage*) gtk_image_new_from_stock ("gtk-edit", GTK_ICON_SIZE_MENU);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	gtk_image_menu_item_set_image (item, (GtkWidget*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) __lambda28__gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
	gtk_widget_show_all ((GtkWidget*) menu);
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
	result = TRUE;
	_g_object_unref0 (item);
	_g_object_unref0 (menu);
	return result;
}


/**
             * Draw the background. (only exposed part)
             */
static gboolean gmpc_meta_data_widgets_backdrop_container_expose (GmpcMetaDataWidgetsBackdrop* self, GtkWidget* ev, GdkEventExpose* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	if (self->priv->pb != NULL) {
		cairo_t* _tmp0_ = NULL;
		cairo_t* gc;
		_tmp0_ = gdk_cairo_create ((GdkDrawable*) ev->window);
		gc = _tmp0_;
		gdk_cairo_region (gc, (*event).region);
		cairo_set_source_rgb (gc, 0.0, 0.0, 0.0);
		cairo_fill_preserve (gc);
		gdk_cairo_set_source_pixbuf (gc, self->priv->pb, 0.0, 0.0);
		cairo_fill (gc);
		_cairo_destroy0 (gc);
	} else {
		cairo_t* _tmp1_ = NULL;
		cairo_t* gc;
		_tmp1_ = gdk_cairo_create ((GdkDrawable*) ev->window);
		gc = _tmp1_;
		gdk_cairo_region (gc, (*event).region);
		cairo_set_source_rgb (gc, 0.0, 0.0, 0.0);
		cairo_fill (gc);
		_cairo_destroy0 (gc);
	}
	result = FALSE;
	return result;
}


static void gmpc_meta_data_widgets_backdrop_class_init (GmpcMetaDataWidgetsBackdropClass * klass) {
	gmpc_meta_data_widgets_backdrop_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcMetaDataWidgetsBackdropPrivate));
	G_OBJECT_CLASS (klass)->finalize = gmpc_meta_data_widgets_backdrop_finalize;
}


static void gmpc_meta_data_widgets_backdrop_instance_init (GmpcMetaDataWidgetsBackdrop * self) {
	gint _tmp0_;
	self->priv = GMPC_META_DATA_WIDGETS_BACKDROP_GET_PRIVATE (self);
	self->priv->song_checksum = NULL;
	self->priv->cur_song = NULL;
	self->priv->cur_type = META_ARTIST_ART;
	self->priv->pb = NULL;
	_tmp0_ = cfg_get_single_value_as_int_with_default (config, "Backdrop", "alterations", 2);
	self->priv->mod_type = (GmpcModificationType) _tmp0_;
	self->priv->loader = NULL;
}


static void gmpc_meta_data_widgets_backdrop_finalize (GObject* obj) {
	GmpcMetaDataWidgetsBackdrop * self;
	self = GMPC_META_DATA_WIDGETS_BACKDROP (obj);
	_g_free0 (self->priv->song_checksum);
	_mpd_freeSong0 (self->priv->cur_song);
	_g_object_unref0 (self->priv->pb);
	_g_object_unref0 (self->priv->loader);
	G_OBJECT_CLASS (gmpc_meta_data_widgets_backdrop_parent_class)->finalize (obj);
}


GType gmpc_meta_data_widgets_backdrop_get_type (void) {
	static volatile gsize gmpc_meta_data_widgets_backdrop_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_meta_data_widgets_backdrop_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcMetaDataWidgetsBackdropClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_meta_data_widgets_backdrop_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcMetaDataWidgetsBackdrop), 0, (GInstanceInitFunc) gmpc_meta_data_widgets_backdrop_instance_init, NULL };
		GType gmpc_meta_data_widgets_backdrop_type_id;
		gmpc_meta_data_widgets_backdrop_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "GmpcMetaDataWidgetsBackdrop", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_meta_data_widgets_backdrop_type_id__volatile, gmpc_meta_data_widgets_backdrop_type_id);
	}
	return gmpc_meta_data_widgets_backdrop_type_id__volatile;
}



