# frozen_string_literal: true

class AddOrganizationToVulnerabilityExports < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!

  milestone '17.1'

  INDEX_NAME = 'index_vulnerability_exports_on_organization_id'

  def up
    with_lock_retries do
      add_column :vulnerability_exports, :organization_id, :bigint, null: false,
        default: Organizations::Organization::DEFAULT_ORGANIZATION_ID,
        if_not_exists: true
    end

    add_concurrent_foreign_key :vulnerability_exports, :organizations, column: :organization_id, on_delete: :cascade
    add_concurrent_index :vulnerability_exports, :organization_id, name: INDEX_NAME
  end

  def down
    with_lock_retries do
      remove_foreign_key :vulnerability_exports, column: :organization_id
    end

    remove_concurrent_index_by_name :vulnerability_exports, INDEX_NAME

    with_lock_retries do
      remove_column :vulnerability_exports, :organization_id, if_exists: true
    end
  end
end
