/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimphelp-ids.h
 * Copyright (C) 2003 Michael Natterer <mitch@gimp.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __GIMP_HELP_IDS_H__
#define __GIMP_HELP_IDS_H__


#define GIMP_HELP_MAIN                            "gimp-main"

#define GIMP_HELP_FILE_NEW                        "gimp-file-new"
#define GIMP_HELP_FILE_OPEN                       "gimp-file-open"
#define GIMP_HELP_FILE_OPEN_AS_LAYER              "gimp-file-open-as-layer"
#define GIMP_HELP_FILE_OPEN_LOCATION              "gimp-file-open-location"
#define GIMP_HELP_FILE_OPEN_BY_EXTENSION          "gimp-file-open-by-extension"
#define GIMP_HELP_FILE_OPEN_RECENT                "gimp-file-open-recent"
#define GIMP_HELP_FILE_SAVE                       "gimp-file-save"
#define GIMP_HELP_FILE_SAVE_AS                    "gimp-file-save-as"
#define GIMP_HELP_FILE_SAVE_A_COPY                "gimp-file-save-a-copy"
#define GIMP_HELP_FILE_SAVE_BY_EXTENSION          "gimp-file-save-by-extension"
#define GIMP_HELP_FILE_EXPORT                     "gimp-file-export"
#define GIMP_HELP_FILE_EXPORT_AS                  "gimp-file-export-as"
#define GIMP_HELP_FILE_OVERWRITE                  "gimp-file-overwrite"
#define GIMP_HELP_FILE_REVERT                     "gimp-file-revert"
#define GIMP_HELP_FILE_CLOSE                      "gimp-file-close"
#define GIMP_HELP_FILE_CLOSE_ALL                  "gimp-file-close-all"
#define GIMP_HELP_FILE_COPY_LOCATION              "gimp-file-copy-location"
#define GIMP_HELP_FILE_SHOW_IN_FILE_MANAGER       "gimp-file-show-in-file-manager"
#define GIMP_HELP_FILE_CREATE_TEMPLATE            "gimp-file-create-template"
#define GIMP_HELP_FILE_QUIT                       "gimp-file-quit"

#define GIMP_HELP_EDIT_UNDO                       "gimp-edit-undo"
#define GIMP_HELP_EDIT_REDO                       "gimp-edit-redo"
#define GIMP_HELP_EDIT_STRONG_UNDO                "gimp-edit-strong-undo"
#define GIMP_HELP_EDIT_STRONG_REDO                "gimp-edit-strong-redo"
#define GIMP_HELP_EDIT_UNDO_CLEAR                 "gimp-edit-undo-clear"
#define GIMP_HELP_EDIT_CUT                        "gimp-edit-cut"
#define GIMP_HELP_EDIT_COPY                       "gimp-edit-copy"
#define GIMP_HELP_EDIT_COPY_VISIBLE               "gimp-edit-copy-visible"
#define GIMP_HELP_EDIT_PASTE                      "gimp-edit-paste"
#define GIMP_HELP_EDIT_PASTE_IN_PLACE             "gimp-edit-paste-in-place"
#define GIMP_HELP_EDIT_PASTE_INTO                 "gimp-edit-paste-into"
#define GIMP_HELP_EDIT_PASTE_INTO_IN_PLACE        "gimp-edit-paste-into-in-place"
#define GIMP_HELP_EDIT_PASTE_AS_NEW_LAYER         "gimp-edit-paste-as-new-layer"
#define GIMP_HELP_EDIT_PASTE_AS_NEW_LAYER_IN_PLACE "gimp-edit-paste-as-new-layer-in-place"
#define GIMP_HELP_EDIT_PASTE_AS_NEW_IMAGE         "gimp-edit-paste-as-new-image"
#define GIMP_HELP_EDIT_PASTE_FLOAT                "gimp-edit-paste-float"
#define GIMP_HELP_EDIT_PASTE_FLOAT_IN_PLACE       "gimp-edit-paste-float-in-place"
#define GIMP_HELP_EDIT_CLEAR                      "gimp-edit-clear"
#define GIMP_HELP_EDIT_FILL_FG                    "gimp-edit-fill-fg"
#define GIMP_HELP_EDIT_FILL_BG                    "gimp-edit-fill-bg"
#define GIMP_HELP_EDIT_FILL_PATTERN               "gimp-edit-fill-pattern"

#define GIMP_HELP_SELECTION_DIALOG                "gimp-selection-dialog"
#define GIMP_HELP_SELECTION_ALL                   "gimp-selection-all"
#define GIMP_HELP_SELECTION_NONE                  "gimp-selection-none"
#define GIMP_HELP_SELECTION_INVERT                "gimp-selection-invert"
#define GIMP_HELP_SELECTION_FLOAT                 "gimp-selection-float"
#define GIMP_HELP_SELECTION_FEATHER               "gimp-selection-feather"
#define GIMP_HELP_SELECTION_SHARPEN               "gimp-selection-sharpen"
#define GIMP_HELP_SELECTION_SHRINK                "gimp-selection-shrink"
#define GIMP_HELP_SELECTION_GROW                  "gimp-selection-grow"
#define GIMP_HELP_SELECTION_BORDER                "gimp-selection-border"
#define GIMP_HELP_SELECTION_FLOOD                 "gimp-selection-flood"
#define GIMP_HELP_SELECTION_FILL                  "gimp-selection-fill"
#define GIMP_HELP_SELECTION_STROKE                "gimp-selection-stroke"
#define GIMP_HELP_SELECTION_TO_CHANNEL            "gimp-selection-to-channel"
#define GIMP_HELP_SELECTION_TO_PATH               "gimp-selection-to-path"

#define GIMP_HELP_VIEW_NEW                        "gimp-view-new"
#define GIMP_HELP_VIEW_SHOW_ALL                   "gimp-view-show-all"
#define GIMP_HELP_VIEW_DOT_FOR_DOT                "gimp-view-dot-for-dot"
#define GIMP_HELP_VIEW_RESET                      "gimp-view-reset"
#define GIMP_HELP_VIEW_SCROLL_CENTER              "gimp-view-scroll-center"
#define GIMP_HELP_VIEW_ZOOM_REVERT                "gimp-view-zoom-revert"
#define GIMP_HELP_VIEW_ZOOM_OUT                   "gimp-view-zoom-out"
#define GIMP_HELP_VIEW_ZOOM_IN                    "gimp-view-zoom-in"
#define GIMP_HELP_VIEW_ZOOM_100                   "gimp-view-zoom-100"
#define GIMP_HELP_VIEW_ZOOM_FIT_IN                "gimp-view-zoom-fit-in"
#define GIMP_HELP_VIEW_ZOOM_FILL                  "gimp-view-zoom-fill"
#define GIMP_HELP_VIEW_ZOOM_SELECTION             "gimp-view-zoom-selection"
#define GIMP_HELP_VIEW_ZOOM_OTHER                 "gimp-view-zoom-other"
#define GIMP_HELP_VIEW_FLIP                       "gimp-view-flip"
#define GIMP_HELP_VIEW_FLIP_RESET                 "gimp-view-flip-reset"
#define GIMP_HELP_VIEW_ROTATE_RESET               "gimp-view-rotate-reset"
#define GIMP_HELP_VIEW_ROTATE_15                  "gimp-view-rotate-15"
#define GIMP_HELP_VIEW_ROTATE_90                  "gimp-view-rotate-90"
#define GIMP_HELP_VIEW_ROTATE_180                 "gimp-view-rotate-180"
#define GIMP_HELP_VIEW_ROTATE_270                 "gimp-view-rotate-270"
#define GIMP_HELP_VIEW_ROTATE_345                 "gimp-view-rotate-345"
#define GIMP_HELP_VIEW_ROTATE_OTHER               "gimp-view-rotate-other"
#define GIMP_HELP_VIEW_COLOR_MANAGEMENT           "gimp-view-color-management"
#define GIMP_HELP_VIEW_COLOR_MANAGE_VIEW          "gimp-view-color-manage-view"
#define GIMP_HELP_VIEW_SOFT_PROOF_VIEW            "gimp-view-soft-proof-view"
#define GIMP_HELP_VIEW_SOFT_PROOF_RENDERING_INTENT "gimp-view-soft-proof-rendering-intent"
#define GIMP_HELP_VIEW_SOFT_PROOF_BLACK_POINT     "gimp-view-soft-proof-black-point"
#define GIMP_HELP_VIEW_MARK_OUT_OF_GAMUT          "gimp-view-soft-mark-out-of-gamut"
#define GIMP_HELP_VIEW_COLOR_MANAGEMENT_RESET     "gimp-view-color-management-reset"
#define GIMP_HELP_VIEW_SHOW_SELECTION             "gimp-view-show-selection"
#define GIMP_HELP_VIEW_SHOW_LAYER_BOUNDARY        "gimp-view-show-layer-boundary"
#define GIMP_HELP_VIEW_SHOW_CANVAS_BOUNDARY       "gimp-view-show-canvas-boundary"
#define GIMP_HELP_VIEW_SHOW_GUIDES                "gimp-view-show-guides"
#define GIMP_HELP_VIEW_SHOW_GRID                  "gimp-view-show-grid"
#define GIMP_HELP_VIEW_SHOW_SAMPLE_POINTS         "gimp-view-show-sample-points"
#define GIMP_HELP_VIEW_SNAP_TO_GUIDES             "gimp-view-snap-to-guides"
#define GIMP_HELP_VIEW_SNAP_TO_GRID               "gimp-view-snap-to-grid"
#define GIMP_HELP_VIEW_SNAP_TO_CANVAS             "gimp-view-snap-to-canvas"
#define GIMP_HELP_VIEW_SNAP_TO_VECTORS            "gimp-view-snap-to-vectors"
#define GIMP_HELP_VIEW_SNAP_TO_BBOX               "gimp-view-snap-to-bbox"
#define GIMP_HELP_VIEW_SNAP_TO_EQUIDISTANCE       "gimp-view-snap-to-equidistance"
#define GIMP_HELP_VIEW_SHOW_MENUBAR               "gimp-view-show-menubar"
#define GIMP_HELP_VIEW_SHOW_RULERS                "gimp-view-show-rulers"
#define GIMP_HELP_VIEW_SHOW_SCROLLBARS            "gimp-view-show-scrollbars"
#define GIMP_HELP_VIEW_SHOW_STATUSBAR             "gimp-view-show-statusbar"
#define GIMP_HELP_VIEW_PADDING_COLOR              "gimp-view-padding-color"
#define GIMP_HELP_VIEW_SHRINK_WRAP                "gimp-view-shrink-wrap"
#define GIMP_HELP_VIEW_FULLSCREEN                 "gimp-view-fullscreen"
#define GIMP_HELP_VIEW_CHANGE_SCREEN              "gimp-view-change-screen"

#define GIMP_HELP_IMAGE_WINDOW                    "gimp-image-window"
#define GIMP_HELP_IMAGE_WINDOW_ORIGIN             "gimp-image-window-origin"
#define GIMP_HELP_IMAGE_WINDOW_ZOOM_FOLLOW_BUTTON "gimp-image-window-zoom-follow-button"
#define GIMP_HELP_IMAGE_WINDOW_QUICK_MASK_BUTTON  "gimp-image-window-quick-mask-button"
#define GIMP_HELP_IMAGE_WINDOW_NAV_BUTTON         "gimp-image-window-nav-button"
#define GIMP_HELP_IMAGE_WINDOW_RULER              "gimp-image-window-ruler"
#define GIMP_HELP_IMAGE_WINDOW_STATUS_BAR         "gimp-image-window-status-bar"


#define GIMP_HELP_IMAGE_DIALOG                    "gimp-image-dialog"
#define GIMP_HELP_IMAGE_DUPLICATE                 "gimp-image-duplicate"
#define GIMP_HELP_IMAGE_CONVERT_RGB               "gimp-image-convert-rgb"
#define GIMP_HELP_IMAGE_CONVERT_GRAYSCALE         "gimp-image-convert-grayscale"
#define GIMP_HELP_IMAGE_CONVERT_INDEXED           "gimp-image-convert-indexed"
#define GIMP_HELP_IMAGE_CONVERT_U8                "gimp-image-convert-u8"
#define GIMP_HELP_IMAGE_CONVERT_U16               "gimp-image-convert-u16"
#define GIMP_HELP_IMAGE_CONVERT_U32               "gimp-image-convert-u32"
#define GIMP_HELP_IMAGE_CONVERT_HALF              "gimp-image-convert-half"
#define GIMP_HELP_IMAGE_CONVERT_FLOAT             "gimp-image-convert-float"
#define GIMP_HELP_IMAGE_CONVERT_DOUBLE            "gimp-image-convert-double"
#define GIMP_HELP_IMAGE_CONVERT_GAMMA             "gimp-image-convert-gamma"
#define GIMP_HELP_IMAGE_CONVERT_PRECISION         "gimp-image-convert-precision"
#define GIMP_HELP_IMAGE_FLIP_HORIZONTAL           "gimp-image-flip-horizontal"
#define GIMP_HELP_IMAGE_FLIP_VERTICAL             "gimp-image-flip-vertical"
#define GIMP_HELP_IMAGE_ROTATE_90                 "gimp-image-rotate-90"
#define GIMP_HELP_IMAGE_ROTATE_180                "gimp-image-rotate-180"
#define GIMP_HELP_IMAGE_ROTATE_270                "gimp-image-rotate-270"
#define GIMP_HELP_IMAGE_RESIZE                    "gimp-image-resize"
#define GIMP_HELP_IMAGE_RESIZE_TO_LAYERS          "gimp-image-resize-to-layers"
#define GIMP_HELP_IMAGE_RESIZE_TO_SELECTION       "gimp-image-resize-to-selection"
#define GIMP_HELP_IMAGE_PRINT_SIZE                "gimp-image-print-size"
#define GIMP_HELP_IMAGE_SCALE                     "gimp-image-scale"
#define GIMP_HELP_IMAGE_SCALE_WARNING             "gimp-image-scale-warning"
#define GIMP_HELP_IMAGE_CROP                      "gimp-image-crop"
#define GIMP_HELP_IMAGE_MERGE_LAYERS              "gimp-image-merge-layers"
#define GIMP_HELP_IMAGE_FLATTEN                   "gimp-image-flatten"
#define GIMP_HELP_IMAGE_COLOR_PROFILE_ASSIGN      "gimp-image-color-profile-assign"
#define GIMP_HELP_IMAGE_COLOR_PROFILE_CONVERT     "gimp-image-color-profile-convert"
#define GIMP_HELP_IMAGE_COLOR_PROFILE_DISCARD     "gimp-image-color-profile-discard"
#define GIMP_HELP_IMAGE_COLOR_PROFILE_USE_SRGB    "gimp-image-color-profile-use-srgb"
#define GIMP_HELP_IMAGE_COLOR_PROFILE_SAVE        "gimp-image-color-profile-save"
#define GIMP_HELP_IMAGE_COLOR_PROFILE_IMPORT      "gimp-image-color-profile-import"
#define GIMP_HELP_IMAGE_SOFT_PROOF_PROFILE_ASSIGN "gimp-image-soft-proof-profile-assign"
#define GIMP_HELP_IMAGE_SOFT_PROOF_BLACK_POINT    "gimp-image-soft-proof-black-point"
#define GIMP_HELP_IMAGE_SOFT_PROOF_RENDERING_INTENT "gimp-image-soft-proof-rendering-intent"

#define GIMP_HELP_IMAGE_METADATA_ROTATION_IMPORT  "gimp-image-metadata-rotation-import"
#define GIMP_HELP_IMAGE_GRID                      "gimp-image-grid"
#define GIMP_HELP_IMAGE_PROPERTIES                "gimp-image-properties"

#define GIMP_HELP_LAYER_DIALOG                    "gimp-layer-dialog"
#define GIMP_HELP_LAYER_DIALOG_PAINT_MODE_MENU    "gimp-layer-dialog-paint-mode-menu"
#define GIMP_HELP_LAYER_DIALOG_OPACITY_SCALE      "gimp-layer-dialog-opacity-scale"

#define GIMP_HELP_LAYER_NEW                       "gimp-layer-new"
#define GIMP_HELP_LAYER_NEW_FROM_VISIBLE          "gimp-layer-new-from-visible"
#define GIMP_HELP_LAYER_DUPLICATE                 "gimp-layer-duplicate"
#define GIMP_HELP_LAYER_ANCHOR                    "gimp-layer-anchor"
#define GIMP_HELP_LAYER_MERGE_DOWN                "gimp-layer-merge-down"
#define GIMP_HELP_LAYER_MERGE_GROUP               "gimp-layer-merge-group"
#define GIMP_HELP_LAYER_DELETE                    "gimp-layer-delete"
#define GIMP_HELP_LAYER_TEXT_DISCARD              "gimp-layer-text-discard"
#define GIMP_HELP_LAYER_TEXT_TO_PATH              "gimp-layer-text-to-path"
#define GIMP_HELP_LAYER_TEXT_ALONG_PATH           "gimp-layer-text-along-path"
#define GIMP_HELP_LAYER_PREVIOUS                  "gimp-layer-previous"
#define GIMP_HELP_LAYER_NEXT                      "gimp-layer-next"
#define GIMP_HELP_LAYER_TOP                       "gimp-layer-top"
#define GIMP_HELP_LAYER_BOTTOM                    "gimp-layer-bottom"
#define GIMP_HELP_LAYER_RAISE                     "gimp-layer-raise"
#define GIMP_HELP_LAYER_RAISE_TO_TOP              "gimp-layer-raise-to-top"
#define GIMP_HELP_LAYER_LOWER                     "gimp-layer-lower"
#define GIMP_HELP_LAYER_LOWER_TO_BOTTOM           "gimp-layer-lower-to-bottom"
#define GIMP_HELP_LAYER_WHITE_BALANCE             "gimp-layer-white-balance"
#define GIMP_HELP_LAYER_EQUALIZE                  "gimp-layer-equalize"
#define GIMP_HELP_LAYER_VISIBLE                   "gimp-layer-visible"
#define GIMP_HELP_LAYER_LINKED                    "gimp-layer-linked"
#define GIMP_HELP_LAYER_COLOR_TAG                 "gimp-layer-color-tag"
#define GIMP_HELP_LAYER_EFFECTS                   "gimp-layer-effects"
#define GIMP_HELP_LAYER_OPACITY                   "gimp-layer-opacity"
#define GIMP_HELP_LAYER_MODE                      "gimp-layer-mode"
#define GIMP_HELP_LAYER_LOCK_ALPHA                "gimp-layer-lock-alpha"
#define GIMP_HELP_LAYER_LOCK_PIXELS               "gimp-layer-lock-pixels"
#define GIMP_HELP_LAYER_LOCK_POSITION             "gimp-layer-lock-position"
#define GIMP_HELP_LAYER_LOCK_VISIBILITY           "gimp-layer-lock-visibility"
#define GIMP_HELP_LAYER_MASK_ADD                  "gimp-layer-mask-add"
#define GIMP_HELP_LAYER_MASK_APPLY                "gimp-layer-mask-apply"
#define GIMP_HELP_LAYER_MASK_DELETE               "gimp-layer-mask-delete"
#define GIMP_HELP_LAYER_MASK_EDIT                 "gimp-layer-mask-edit"
#define GIMP_HELP_LAYER_MASK_SHOW                 "gimp-layer-mask-show"
#define GIMP_HELP_LAYER_MASK_DISABLE              "gimp-layer-mask-disable"
#define GIMP_HELP_LAYER_MASK_SELECTION_REPLACE    "gimp-layer-mask-selection-replace"
#define GIMP_HELP_LAYER_MASK_SELECTION_ADD        "gimp-layer-mask-selection-add"
#define GIMP_HELP_LAYER_MASK_SELECTION_SUBTRACT   "gimp-layer-mask-selection-subtract"
#define GIMP_HELP_LAYER_MASK_SELECTION_INTERSECT  "gimp-layer-mask-selection-intersect"
#define GIMP_HELP_LAYER_ALPHA_ADD                 "gimp-layer-alpha-add"
#define GIMP_HELP_LAYER_ALPHA_REMOVE              "gimp-layer-alpha-remove"
#define GIMP_HELP_LAYER_ALPHA_SELECTION_REPLACE   "gimp-layer-alpha-selection-replace"
#define GIMP_HELP_LAYER_ALPHA_SELECTION_ADD       "gimp-layer-alpha-selection-add"
#define GIMP_HELP_LAYER_ALPHA_SELECTION_SUBTRACT  "gimp-layer-alpha-selection-subtract"
#define GIMP_HELP_LAYER_ALPHA_SELECTION_INTERSECT "gimp-layer-alpha-selection-intersect"
#define GIMP_HELP_LAYER_FLIP_HORIZONTAL           "gimp-layer-flip-horizontal"
#define GIMP_HELP_LAYER_FLIP_VERTICAL             "gimp-layer-flip-vertical"
#define GIMP_HELP_LAYER_ROTATE_90                 "gimp-layer-rotate-90"
#define GIMP_HELP_LAYER_ROTATE_180                "gimp-layer-rotate-180"
#define GIMP_HELP_LAYER_ROTATE_270                "gimp-layer-rotate-270"
#define GIMP_HELP_LAYER_RESIZE                    "gimp-layer-resize"
#define GIMP_HELP_LAYER_RESIZE_TO_IMAGE           "gimp-layer-resize-to-image"
#define GIMP_HELP_LAYER_SCALE                     "gimp-layer-scale"
#define GIMP_HELP_LAYER_RESIZE_TO_SELECTION       "gimp-layer-resize-to-selection"
#define GIMP_HELP_LAYER_CROP_TO_CONTENT           "gimp-layer-crop-to-content"
#define GIMP_HELP_LAYER_EDIT                      "gimp-layer-edit"

#define GIMP_HELP_CHANNEL_DIALOG                  "gimp-channel-dialog"
#define GIMP_HELP_CHANNEL_NEW                     "gimp-channel-new"
#define GIMP_HELP_CHANNEL_RAISE                   "gimp-channel-raise"
#define GIMP_HELP_CHANNEL_RAISE_TO_TOP            "gimp-channel-raise-to-top"
#define GIMP_HELP_CHANNEL_LOWER                   "gimp-channel-lower"
#define GIMP_HELP_CHANNEL_LOWER_TO_BOTTOM         "gimp-channel-lower-to-bottom"
#define GIMP_HELP_CHANNEL_DUPLICATE               "gimp-channel-duplicate"
#define GIMP_HELP_CHANNEL_DELETE                  "gimp-channel-delete"
#define GIMP_HELP_CHANNEL_PREVIOUS                "gimp-channel-previous"
#define GIMP_HELP_CHANNEL_NEXT                    "gimp-channel-next"
#define GIMP_HELP_CHANNEL_TOP                     "gimp-channel-top"
#define GIMP_HELP_CHANNEL_BOTTOM                  "gimp-channel-bottom"
#define GIMP_HELP_CHANNEL_VISIBLE                 "gimp-channel-visible"
#define GIMP_HELP_CHANNEL_LINKED                  "gimp-channel-linked"
#define GIMP_HELP_CHANNEL_COLOR_TAG               "gimp-channel-color-tag"
#define GIMP_HELP_CHANNEL_LOCK_PIXELS             "gimp-channel-lock-pixels"
#define GIMP_HELP_CHANNEL_LOCK_POSITION           "gimp-channel-lock-position"
#define GIMP_HELP_CHANNEL_LOCK_VISIBILITY         "gimp-channel-lock-visibility"
#define GIMP_HELP_CHANNEL_SELECTION_REPLACE       "gimp-channel-selection-replace"
#define GIMP_HELP_CHANNEL_SELECTION_ADD           "gimp-channel-selection-add"
#define GIMP_HELP_CHANNEL_SELECTION_SUBTRACT      "gimp-channel-selection-subtract"
#define GIMP_HELP_CHANNEL_SELECTION_INTERSECT     "gimp-channel-selection-intersect"
#define GIMP_HELP_CHANNEL_EDIT                    "gimp-channel-edit"

#define GIMP_HELP_QUICK_MASK                      "gimp-quick-mask"
#define GIMP_HELP_QUICK_MASK_TOGGLE               "gimp-quick-mask-toggle"
#define GIMP_HELP_QUICK_MASK_INVERT               "gimp-quick-mask-invert"
#define GIMP_HELP_QUICK_MASK_EDIT                 "gimp-quick-mask-edit"

#define GIMP_HELP_PATH_DIALOG                     "gimp-path-dialog"
#define GIMP_HELP_PATH_NEW                        "gimp-path-new"
#define GIMP_HELP_PATH_PREVIOUS                   "gimp-path-previous"
#define GIMP_HELP_PATH_NEXT                       "gimp-path-next"
#define GIMP_HELP_PATH_TOP                        "gimp-path-top"
#define GIMP_HELP_PATH_BOTTOM                     "gimp-path-bottom"
#define GIMP_HELP_PATH_RAISE                      "gimp-path-raise"
#define GIMP_HELP_PATH_RAISE_TO_TOP               "gimp-path-raise-to-top"
#define GIMP_HELP_PATH_LOWER                      "gimp-path-lower"
#define GIMP_HELP_PATH_LOWER_TO_BOTTOM            "gimp-path-lower-to-bottom"
#define GIMP_HELP_PATH_DUPLICATE                  "gimp-path-duplicate"
#define GIMP_HELP_PATH_DELETE                     "gimp-path-delete"
#define GIMP_HELP_PATH_MERGE_VISIBLE              "gimp-path-merge-visible"
#define GIMP_HELP_PATH_VISIBLE                    "gimp-path-visible"
#define GIMP_HELP_PATH_LINKED                     "gimp-path-linked"
#define GIMP_HELP_PATH_COLOR_TAG                  "gimp-path-color-tag"
#define GIMP_HELP_PATH_LOCK_STROKES               "gimp-path-lock-strokes"
#define GIMP_HELP_PATH_LOCK_POSITION              "gimp-path-lock-position"
#define GIMP_HELP_PATH_LOCK_VISIBILITY            "gimp-path-lock-visibility"
#define GIMP_HELP_PATH_SELECTION_REPLACE          "gimp-path-selection-replace"
#define GIMP_HELP_PATH_SELECTION_ADD              "gimp-path-selection-add"
#define GIMP_HELP_PATH_SELECTION_SUBTRACT         "gimp-path-selection-subtract"
#define GIMP_HELP_PATH_SELECTION_INTERSECT        "gimp-path-selection-intersect"
#define GIMP_HELP_PATH_FILL                       "gimp-path-fill"
#define GIMP_HELP_PATH_STROKE                     "gimp-path-stroke"
#define GIMP_HELP_PATH_COPY                       "gimp-path-copy"
#define GIMP_HELP_PATH_PASTE                      "gimp-path-paste"
#define GIMP_HELP_PATH_IMPORT                     "gimp-path-import"
#define GIMP_HELP_PATH_EXPORT                     "gimp-path-export"
#define GIMP_HELP_PATH_EDIT                       "gimp-path-edit"

#define GIMP_HELP_PATH_TOOL_DELETE_ANCHOR         "gimp-path-path-tool-delete-anchor"
#define GIMP_HELP_PATH_TOOL_DELETE_SEGMENT        "gimp-path-path-tool-delete-segment"
#define GIMP_HELP_PATH_TOOL_INSERT_ANCHOR         "gimp-path-path-tool-insert-anchor"
#define GIMP_HELP_PATH_TOOL_REVERSE_STROKE        "gimp-path-path-tool-reverse-stroke"
#define GIMP_HELP_PATH_TOOL_SHIFT_START           "gimp-path-path-tool-shift-start"

#define GIMP_HELP_TEXT_TOOL_CUT                   "gimp-text-tool-cut"
#define GIMP_HELP_TEXT_TOOL_COPY                  "gimp-text-tool-copy"
#define GIMP_HELP_TEXT_TOOL_PASTE                 "gimp-text-tool-paste"
#define GIMP_HELP_TEXT_TOOL_DELETE                "gimp-text-tool-delete"
#define GIMP_HELP_TEXT_TOOL_OPEN_TEXT_FILE        "gimp-text-tool-open-text-file"
#define GIMP_HELP_TEXT_TOOL_CLEAR                 "gimp-text-tool-clear"
#define GIMP_HELP_TEXT_TOOL_TEXT_TO_PATH          "gimp-text-tool-text-to-path"
#define GIMP_HELP_TEXT_TOOL_TEXT_ALONG_PATH       "gimp-text-tool-text-along-path"
#define GIMP_HELP_TEXT_TOOL_DIRECTION_LTR         "gimp-text-tool-direction-ltr"
#define GIMP_HELP_TEXT_TOOL_DIRECTION_RTL         "gimp-text-tool-direction-rtl"
#define GIMP_HELP_TEXT_TOOL_DIRECTION_TTB_RTL     "gimp-text-tool-direction-ttb-rtl"
#define GIMP_HELP_TEXT_TOOL_DIRECTION_TTB_RTL_UP  "gimp-text-tool-direction-ttb-rtl-upright"
#define GIMP_HELP_TEXT_TOOL_DIRECTION_TTB_LTR     "gimp-text-tool-direction-ttb-ltr"
#define GIMP_HELP_TEXT_TOOL_DIRECTION_TTB_LTR_UP  "gimp-text-tool-direction-ttb-ltr-upright"

#define GIMP_HELP_TOOL_AIRBRUSH                   "gimp-tool-airbrush"
#define GIMP_HELP_TOOL_ALIGN                      "gimp-tool-align"
#define GIMP_HELP_TOOL_BRIGHTNESS_CONTRAST        "gimp-tool-brightness-contrast"
#define GIMP_HELP_TOOL_BUCKET_FILL                "gimp-tool-bucket-fill"
#define GIMP_HELP_TOOL_BY_COLOR_SELECT            "gimp-tool-by-color-select"
#define GIMP_HELP_TOOL_CAGE                       "gimp-tool-cage"
#define GIMP_HELP_TOOL_CLONE                      "gimp-tool-clone"
#define GIMP_HELP_TOOL_COLORIZE                   "gimp-tool-colorize"
#define GIMP_HELP_TOOL_COLOR_BALANCE              "gimp-tool-color-balance"
#define GIMP_HELP_TOOL_COLOR_PICKER               "gimp-tool-color-picker"
#define GIMP_HELP_TOOL_CONVOLVE                   "gimp-tool-convolve"
#define GIMP_HELP_TOOL_CROP                       "gimp-tool-crop"
#define GIMP_HELP_TOOL_CURVES                     "gimp-tool-curves"
#define GIMP_HELP_TOOL_DODGE_BURN                 "gimp-tool-dodge-burn"
#define GIMP_HELP_TOOL_ELLIPSE_SELECT             "gimp-tool-ellipse-select"
#define GIMP_HELP_TOOL_ERASER                     "gimp-tool-eraser"
#define GIMP_HELP_TOOL_FLIP                       "gimp-tool-flip"
#define GIMP_HELP_TOOL_FREE_SELECT                "gimp-tool-free-select"
#define GIMP_HELP_TOOL_FOREGROUND_SELECT          "gimp-tool-foreground-select"
#define GIMP_HELP_TOOL_FUZZY_SELECT               "gimp-tool-fuzzy-select"
#define GIMP_HELP_TOOL_GEGL                       "gimp-tool-gegl"
#define GIMP_HELP_TOOL_GRADIENT                   "gimp-tool-gradient"
#define GIMP_HELP_TOOL_HANDLE_TRANSFORM           "gimp-tool-handle-transform"
#define GIMP_HELP_TOOL_HEAL                       "gimp-tool-heal"
#define GIMP_HELP_TOOL_HUE_SATURATION             "gimp-tool-hue-saturation"
#define GIMP_HELP_TOOL_INK                        "gimp-tool-ink"
#define GIMP_HELP_TOOL_ISCISSORS                  "gimp-tool-iscissors"
#define GIMP_HELP_TOOL_LEVELS                     "gimp-tool-levels"
#define GIMP_HELP_TOOL_MEASURE                    "gimp-tool-measure"
#define GIMP_HELP_TOOL_MOVE                       "gimp-tool-move"
#define GIMP_HELP_TOOL_MYPAINT_BRUSH              "gimp-tool-mypaint-brush"
#define GIMP_HELP_TOOL_N_POINT_DEFORMATION        "gimp-tool-n-point-deformation"
#define GIMP_HELP_TOOL_OFFSET                     "gimp-tool-offset"
#define GIMP_HELP_TOOL_PATH                       "gimp-tool-path"
#define GIMP_HELP_TOOL_PAINTBRUSH                 "gimp-tool-paintbrush"
#define GIMP_HELP_TOOL_PENCIL                     "gimp-tool-pencil"
#define GIMP_HELP_TOOL_PERSPECTIVE                "gimp-tool-perspective"
#define GIMP_HELP_TOOL_PERSPECTIVE_CLONE          "gimp-tool-perspective-clone"
#define GIMP_HELP_TOOL_RECT_SELECT                "gimp-tool-rect-select"
#define GIMP_HELP_TOOL_ROTATE                     "gimp-tool-rotate"
#define GIMP_HELP_TOOL_SCALE                      "gimp-tool-scale"
#define GIMP_HELP_TOOL_SEAMLESS_CLONE             "gimp-tool-seamless-clone"
#define GIMP_HELP_TOOL_SHEAR                      "gimp-tool-shear"
#define GIMP_HELP_TOOL_SMUDGE                     "gimp-tool-smudge"
#define GIMP_HELP_TOOL_TEXT                       "gimp-tool-text"
#define GIMP_HELP_TOOL_THRESHOLD                  "gimp-tool-threshold"
#define GIMP_HELP_TOOL_TRANSFORM_3D               "gimp-tool-transform-3d"
#define GIMP_HELP_TOOL_UNIFIED_TRANSFORM          "gimp-tool-unified-transform"
#define GIMP_HELP_TOOL_VECTORS                    "gimp-tool-vectors"
#define GIMP_HELP_TOOL_WARP                       "gimp-tool-warp"
#define GIMP_HELP_TOOL_ZOOM                       "gimp-tool-zoom"

#define GIMP_HELP_FILTER_REPEAT                   "gimp-filter-repeat"
#define GIMP_HELP_FILTER_RESHOW                   "gimp-filter-reshow"
#define GIMP_HELP_FILTER_RESET_ALL                "gimp-filter-reset-all"

#define GIMP_HELP_FILTER_ALIEN_MAP                "gimp-filter-alien-map"
#define GIMP_HELP_FILTER_ANTIALIAS                "gimp-filter-antialias"
#define GIMP_HELP_FILTER_APPLY_CANVAS             "gimp-filter-apply-canvas"
#define GIMP_HELP_FILTER_APPLY_LENS               "gimp-filter-apply-lens"
#define GIMP_HELP_FILTER_BAYER_MATRIX             "gimp-filter-bayer-matrix"
#define GIMP_HELP_FILTER_BLOOM                    "gimp-filter-bloom"
#define GIMP_HELP_FILTER_BUMP_MAP                 "gimp-filter-bump-map"
#define GIMP_HELP_FILTER_C2G                      "gimp-filter-c2g"
#define GIMP_HELP_FILTER_CARTOON                  "gimp-filter-cartoon"
#define GIMP_HELP_FILTER_CHANNEL_MIXER            "gimp-filter-channel-mixer"
#define GIMP_HELP_FILTER_CHECKERBOARD             "gimp-filter-checkerboard"
#define GIMP_HELP_FILTER_COLOR_ENHANCE            "gimp-filter-color-enhance"
#define GIMP_HELP_FILTER_COLOR_EXCHANGE           "gimp-filter-color-exchange"
#define GIMP_HELP_FILTER_COLOR_ROTATE             "gimp-filter-color-rotate"
#define GIMP_HELP_FILTER_COLOR_TEMPERATURE        "gimp-filter-color-temperature"
#define GIMP_HELP_FILTER_COLOR_TO_ALPHA           "gimp-filter-color-to-alpha"
#define GIMP_HELP_FILTER_COMPONENT_EXTRACT        "gimp-filter-component-extract"
#define GIMP_HELP_FILTER_CONVOLUTION_MATRIX       "gimp-filter-convolution-matrix"
#define GIMP_HELP_FILTER_CUBISM                   "gimp-filter-cubism"
#define GIMP_HELP_FILTER_DEINTERLACE              "gimp-filter-deinterlace"
#define GIMP_HELP_FILTER_DESATURATE               "gimp-filter-desaturate"
#define GIMP_HELP_FILTER_DIFFERENCE_OF_GAUSSIANS  "gimp-filter-difference-of-gaussians"
#define GIMP_HELP_FILTER_DIFFRACTION_PATTERNS     "gimp-filter-diffraction-patterns"
#define GIMP_HELP_FILTER_DILATE                   "gimp-filter-dilate"
#define GIMP_HELP_FILTER_DISPLACE                 "gimp-filter-displace"
#define GIMP_HELP_FILTER_DISTANCE_MAP             "gimp-filter-distance-map"
#define GIMP_HELP_FILTER_DITHER                   "gimp-filter-dither"
#define GIMP_HELP_FILTER_DROPSHADOW               "gimp-filter-drop-shadow"
#define GIMP_HELP_FILTER_EDGE                     "gimp-filter-edge"
#define GIMP_HELP_FILTER_EDGE_LAPLACE             "gimp-filter-edge-laplace"
#define GIMP_HELP_FILTER_EDGE_NEON                "gimp-filter-edge-neon"
#define GIMP_HELP_FILTER_EDGE_SOBEL               "gimp-filter-edge-sobel"
#define GIMP_HELP_FILTER_EMBOSS                   "gimp-filter-emboss"
#define GIMP_HELP_FILTER_ENGRAVE                  "gimp-filter-engrave"
#define GIMP_HELP_FILTER_ERODE                    "gimp-filter-erode"
#define GIMP_HELP_FILTER_EXPOSURE                 "gimp-filter-exposure"
#define GIMP_HELP_FILTER_FATTAL_2002              "gimp-filter-fattal-2002"
#define GIMP_HELP_FILTER_FOCUS_BLUR               "gimp-filter-focus-blur"
#define GIMP_HELP_FILTER_FRACTAL_TRACE            "gimp-filter-fractal-trace"
#define GIMP_HELP_FILTER_GAUSSIAN_BLUR            "gimp-filter-gaussian-blur"
#define GIMP_HELP_FILTER_GAUSSIAN_BLUR_SELECTIVE  "gimp-filter-gaussian-blur-selective"
#define GIMP_HELP_FILTER_GEGL_GRAPH               "gimp-filter-gegl-graph"
#define GIMP_HELP_FILTER_GRID                     "gimp-filter-grid"
#define GIMP_HELP_FILTER_HIGH_PASS                "gimp-filter-high-pass"
#define GIMP_HELP_FILTER_HUE_CHROMA               "gimp-filter-hue-chroma"
#define GIMP_HELP_FILTER_ILLUSION                 "gimp-filter-illusion"
#define GIMP_HELP_FILTER_INVERT_LINEAR            "gimp-filter-invert-linear"
#define GIMP_HELP_FILTER_INVERT_PERCEPTUAL        "gimp-filter-invert-perceptual"
#define GIMP_HELP_FILTER_INVERT_VALUE             "gimp-filter-invert-value"
#define GIMP_HELP_FILTER_IMAGE_GRADIENT           "gimp-filter-image-gradient"
#define GIMP_HELP_FILTER_KALEIDOSCOPE             "gimp-filter-kaleidoscope"
#define GIMP_HELP_FILTER_LENS_BLUR                "gimp-filter-lens-blur"
#define GIMP_HELP_FILTER_LENS_DISTORTION          "gimp-filter-lens-distortion"
#define GIMP_HELP_FILTER_LENS_FLARE               "gimp-filter-lens-flare"
#define GIMP_HELP_FILTER_LINEAR_SINUSOID          "gimp-filter-linear-sinusoid"
#define GIMP_HELP_FILTER_LITTLE_PLANET            "gimp-filter-little-planet"
#define GIMP_HELP_FILTER_LONG_SHADOW              "gimp-filter-long-shadow"
#define GIMP_HELP_FILTER_MANTIUK_2006             "gimp-filter-mantiuk-2006"
#define GIMP_HELP_FILTER_MAZE                     "gimp-filter-maze"
#define GIMP_HELP_FILTER_MEAN_CURVATURE_BLUR      "gimp-filter-mean-curvature-blur"
#define GIMP_HELP_FILTER_MEDIAN_BLUR              "gimp-filter-median-blur"
#define GIMP_HELP_FILTER_MONO_MIXER               "gimp-filter-mono-mixer"
#define GIMP_HELP_FILTER_MOSAIC                   "gimp-filter-mosaic"
#define GIMP_HELP_FILTER_MOTION_BLUR_CIRCULAR     "gimp-filter-motion-blur-circular"
#define GIMP_HELP_FILTER_MOTION_BLUR_LINEAR       "gimp-filter-motion-blur-linear"
#define GIMP_HELP_FILTER_MOTION_BLUR_ZOOM         "gimp-filter-motion-blur-zoom"
#define GIMP_HELP_FILTER_NEWSPRINT                "gimp-filter-newsprint"
#define GIMP_HELP_FILTER_NOISE_CELL               "gimp-filter-noise-cell"
#define GIMP_HELP_FILTER_NOISE_CIE_LCH            "gimp-filter-noise-cie-lch"
#define GIMP_HELP_FILTER_NOISE_HSV                "gimp-filter-noise-hsv"
#define GIMP_HELP_FILTER_NOISE_HURL               "gimp-filter-noise-hurl"
#define GIMP_HELP_FILTER_NOISE_PERLIN             "gimp-filter-noise-perlin"
#define GIMP_HELP_FILTER_NOISE_PICK               "gimp-filter-noise-pick"
#define GIMP_HELP_FILTER_NOISE_RGB                "gimp-filter-noise-rgb"
#define GIMP_HELP_FILTER_NOISE_REDUCTION          "gimp-filter-noise-reduction"
#define GIMP_HELP_FILTER_NOISE_SIMPLEX            "gimp-filter-noise-simplex"
#define GIMP_HELP_FILTER_NOISE_SLUR               "gimp-filter-noise-slur"
#define GIMP_HELP_FILTER_NOISE_SOLID              "gimp-filter-noise-solid"
#define GIMP_HELP_FILTER_NOISE_SPREAD             "gimp-filter-noise-spread"
#define GIMP_HELP_FILTER_NORMAL_MAP               "gimp-filter-normal-map"
#define GIMP_HELP_FILTER_OILIFY                   "gimp-filter-oilify"
#define GIMP_HELP_FILTER_PANORAMA_PROJECTION      "gimp-filter-panorama-projection"
#define GIMP_HELP_FILTER_PHOTOCOPY                "gimp-filter-photocopy"
#define GIMP_HELP_FILTER_PIXELIZE                 "gimp-filter-pixelize"
#define GIMP_HELP_FILTER_PLASMA                   "gimp-filter-plasma"
#define GIMP_HELP_FILTER_POLAR_COORDINATES        "gimp-filter-polar-coordinates"
#define GIMP_HELP_FILTER_POSTERIZE                "gimp-filter-posterize"
#define GIMP_HELP_FILTER_RECURSIVE_TRANSFORM      "gimp-filter-recursive-transform"
#define GIMP_HELP_FILTER_RED_EYE_REMOVAL          "gimp-filter-red-eye-removal"
#define GIMP_HELP_FILTER_REINHARD_2005            "gimp-filter-reinhard-2005"
#define GIMP_HELP_FILTER_RGB_CLIP                 "gimp-filter-rgb-clip"
#define GIMP_HELP_FILTER_RIPPLE                   "gimp-filter-ripple"
#define GIMP_HELP_FILTER_SATURATION               "gimp-filter-saturation"
#define GIMP_HELP_FILTER_SEMI_FLATTEN             "gimp-filter-semi-flatten"
#define GIMP_HELP_FILTER_SEPIA                    "gimp-filter-sepia"
#define GIMP_HELP_FILTER_SHADOWS_HIGHLIGHTS       "gimp-filter-shadows-highlights"
#define GIMP_HELP_FILTER_SHIFT                    "gimp-filter-shift"
#define GIMP_HELP_FILTER_SINUS                    "gimp-filter-sinus"
#define GIMP_HELP_FILTER_SLIC                     "gimp-filter-slic"
#define GIMP_HELP_FILTER_SNN_MEAN                 "gimp-filter-snn-mean"
#define GIMP_HELP_FILTER_SOFTGLOW                 "gimp-filter-softglow"
#define GIMP_HELP_FILTER_SPHERIZE                 "gimp-filter-spherize"
#define GIMP_HELP_FILTER_SPIRAL                   "gimp-filter-spiral"
#define GIMP_HELP_FILTER_STRETCH_CONTRAST         "gimp-filter-stretch-contrast"
#define GIMP_HELP_FILTER_STRETCH_CONTRAST_HSV     "gimp-filter-stretch-contrast-hsv"
#define GIMP_HELP_FILTER_STRESS                   "gimp-filter-stress"
#define GIMP_HELP_FILTER_SUPERNOVA                "gimp-filter-supernova"
#define GIMP_HELP_FILTER_THRESHOLD_ALPHA          "gimp-filter-threshold-alpha"
#define GIMP_HELP_FILTER_TILE_GLASS               "gimp-filter-tile-glass"
#define GIMP_HELP_FILTER_TILE_PAPER               "gimp-filter-tile-paper"
#define GIMP_HELP_FILTER_TILE_SEAMLESS            "gimp-filter-tile-seamless"
#define GIMP_HELP_FILTER_UNSHARP_MASK             "gimp-filter-unsharp-mask"
#define GIMP_HELP_FILTER_VALUE_PROPAGATE          "gimp-filter-value-propagate"
#define GIMP_HELP_FILTER_VARIABLE_BLUR            "gimp-filter-variable-blur"
#define GIMP_HELP_FILTER_VIDEO_DEGRADATION        "gimp-filter-video-degradation"
#define GIMP_HELP_FILTER_VIGNETTE                 "gimp-filter-vignette"
#define GIMP_HELP_FILTER_WATERPIXELS              "gimp-filter-waterpixels"
#define GIMP_HELP_FILTER_WAVES                    "gimp-filter-waves"
#define GIMP_HELP_FILTER_WHIRL_PINCH              "gimp-filter-whirl-pinch"
#define GIMP_HELP_FILTER_WIND                     "gimp-filter-wind"

#define GIMP_HELP_TOOLBOX                         "gimp-toolbox"
#define GIMP_HELP_TOOLBOX_COLOR_AREA              "gimp-toolbox-color-area"
#define GIMP_HELP_TOOLBOX_IMAGE_AREA              "gimp-toolbox-image-area"
#define GIMP_HELP_TOOLBOX_INDICATOR_AREA          "gimp-toolbox-indicator-area"
#define GIMP_HELP_TOOLBOX_DEFAULT_COLORS          "gimp-toolbox-default-colors"
#define GIMP_HELP_TOOLBOX_SWAP_COLORS             "gimp-toolbox-swap-colors"

#define GIMP_HELP_BRUSH_DIALOG                    "gimp-brush-dialog"
#define GIMP_HELP_BRUSH_EDIT                      "gimp-brush-edit"
#define GIMP_HELP_BRUSH_OPEN_AS_IMAGE             "gimp-brush-open-as-image"
#define GIMP_HELP_BRUSH_NEW                       "gimp-brush-new"
#define GIMP_HELP_BRUSH_DUPLICATE                 "gimp-brush-duplicate"
#define GIMP_HELP_BRUSH_COPY_LOCATION             "gimp-brush-copy-location"
#define GIMP_HELP_BRUSH_SHOW_IN_FILE_MANAGER      "gimp-brush-show-in-file-manager"
#define GIMP_HELP_BRUSH_DELETE                    "gimp-brush-delete"
#define GIMP_HELP_BRUSH_REFRESH                   "gimp-brush-refresh"

#define GIMP_HELP_BRUSH_EDITOR_DIALOG             "gimp-brush-editor-dialog"
#define GIMP_HELP_BRUSH_EDITOR_EDIT_ACTIVE        "gimp-brush-editor-edit-active"

#define GIMP_HELP_DYNAMICS_EDITOR_DIALOG          "gimp-dynamics-editor-dialog"

#define GIMP_HELP_TOOL_PRESET_EDITOR_DIALOG       "gimp-tool-preset-editor-dialog"
#define GIMP_HELP_TOOL_PRESET_EDITOR_EDIT_ACTIVE  "gimp-tool-preset-editor-edit-active"

#define GIMP_HELP_DYNAMICS_DIALOG                 "gimp-dynamics-dialog"
#define GIMP_HELP_DYNAMICS_EDIT                   "gimp-dynamics-edit"
#define GIMP_HELP_DYNAMICS_NEW                    "gimp-dynamics-new"
#define GIMP_HELP_DYNAMICS_DUPLICATE              "gimp-dynamics-duplicate"
#define GIMP_HELP_DYNAMICS_COPY_LOCATION          "gimp-dynamics-copy-location"
#define GIMP_HELP_DYNAMICS_SHOW_IN_FILE_MANAGER   "gimp-dynamics-show-in-file-manager"
#define GIMP_HELP_DYNAMICS_DELETE                 "gimp-dynamics-delete"
#define GIMP_HELP_DYNAMICS_REFRESH                "gimp-dynamics-refresh"

#define GIMP_HELP_MYPAINT_BRUSH_DIALOG            "gimp-mypaint-brush-dialog"
#define GIMP_HELP_MYPAINT_BRUSH_EDIT              "gimp-mypaint-brush-edit"
#define GIMP_HELP_MYPAINT_BRUSH_NEW               "gimp-mypaint-brush-new"
#define GIMP_HELP_MYPAINT_BRUSH_DUPLICATE         "gimp-mypaint-brush-duplicate"
#define GIMP_HELP_MYPAINT_BRUSH_COPY_LOCATION     "gimp-mypaint-brush-copy-location"
#define GIMP_HELP_MYPAINT_BRUSH_SHOW_IN_FILE_MANAGER "gimp-mypaint-brush-show-in-file-manager"
#define GIMP_HELP_MYPAINT_BRUSH_DELETE            "gimp-mypaint-brush-delete"
#define GIMP_HELP_MYPAINT_BRUSH_REFRESH           "gimp-mypaint-brush-refresh"

#define GIMP_HELP_PATTERN_DIALOG                  "gimp-pattern-dialog"
#define GIMP_HELP_PATTERN_EDIT                    "gimp-pattern-edit"
#define GIMP_HELP_PATTERN_OPEN_AS_IMAGE           "gimp-pattern-open-as-image"
#define GIMP_HELP_PATTERN_NEW                     "gimp-pattern-new"
#define GIMP_HELP_PATTERN_DUPLICATE               "gimp-pattern-duplicate"
#define GIMP_HELP_PATTERN_COPY_LOCATION           "gimp-pattern-copy-location"
#define GIMP_HELP_PATTERN_SHOW_IN_FILE_MANAGER    "gimp-pattern-show-in-file-manager"
#define GIMP_HELP_PATTERN_DELETE                  "gimp-pattern-delete"
#define GIMP_HELP_PATTERN_REFRESH                 "gimp-pattern-refresh"

#define GIMP_HELP_GRADIENT_DIALOG                 "gimp-gradient-dialog"
#define GIMP_HELP_GRADIENT_EDIT                   "gimp-gradient-edit"
#define GIMP_HELP_GRADIENT_NEW                    "gimp-gradient-new"
#define GIMP_HELP_GRADIENT_DUPLICATE              "gimp-gradient-duplicate"
#define GIMP_HELP_GRADIENT_COPY_LOCATION          "gimp-gradient-copy-location"
#define GIMP_HELP_GRADIENT_SHOW_IN_FILE_MANAGER   "gimp-gradient-show-in-file-manager"
#define GIMP_HELP_GRADIENT_DELETE                 "gimp-gradient-delete"
#define GIMP_HELP_GRADIENT_REFRESH                "gimp-gradient-refresh"
#define GIMP_HELP_GRADIENT_SAVE_AS_POV            "gimp-gradient-save-as-pov"

#define GIMP_HELP_GRADIENT_EDITOR_DIALOG          "gimp-gradient-editor-dialog"
#define GIMP_HELP_GRADIENT_EDITOR_LEFT_COLOR      "gimp-gradient-editor-left-color"
#define GIMP_HELP_GRADIENT_EDITOR_LEFT_LOAD       "gimp-gradient-editor-left-load"
#define GIMP_HELP_GRADIENT_EDITOR_LEFT_SAVE       "gimp-gradient-editor-left-save"
#define GIMP_HELP_GRADIENT_EDITOR_RIGHT_COLOR     "gimp-gradient-editor-right-color"
#define GIMP_HELP_GRADIENT_EDITOR_RIGHT_LOAD      "gimp-gradient-editor-right-load"
#define GIMP_HELP_GRADIENT_EDITOR_RIGHT_SAVE      "gimp-gradient-editor-right-save"
#define GIMP_HELP_GRADIENT_EDITOR_BLENDING        "gimp-gradient-editor-blending"
#define GIMP_HELP_GRADIENT_EDITOR_COLORING        "gimp-gradient-editor-coloring"
#define GIMP_HELP_GRADIENT_EDITOR_FLIP            "gimp-gradient-editor-flip"
#define GIMP_HELP_GRADIENT_EDITOR_REPLICATE       "gimp-gradient-editor-replicate"
#define GIMP_HELP_GRADIENT_EDITOR_SPLIT_MIDPOINT  "gimp-gradient-editor-split-midpoint"
#define GIMP_HELP_GRADIENT_EDITOR_SPLIT_UNIFORM   "gimp-gradient-editor-split-uniform"
#define GIMP_HELP_GRADIENT_EDITOR_DELETE          "gimp-gradient-editor-delete"
#define GIMP_HELP_GRADIENT_EDITOR_RECENTER        "gimp-gradient-editor-recenter"
#define GIMP_HELP_GRADIENT_EDITOR_REDISTRIBUTE    "gimp-gradient-editor-redistribute"
#define GIMP_HELP_GRADIENT_EDITOR_BLEND_COLOR     "gimp-gradient-editor-blend-color"
#define GIMP_HELP_GRADIENT_EDITOR_BLEND_OPACITY   "gimp-gradient-editor-blend-opacity"
#define GIMP_HELP_GRADIENT_EDITOR_ZOOM_OUT        "gimp-gradient-editor-zoom-out"
#define GIMP_HELP_GRADIENT_EDITOR_ZOOM_IN         "gimp-gradient-editor-zoom-in"
#define GIMP_HELP_GRADIENT_EDITOR_ZOOM_ALL        "gimp-gradient-editor-zoom-all"
#define GIMP_HELP_GRADIENT_EDITOR_EDIT_ACTIVE     "gimp-gradient-editor-edit-active"

#define GIMP_HELP_PALETTE_DIALOG                  "gimp-palette-dialog"
#define GIMP_HELP_PALETTE_EDIT                    "gimp-palette-edit"
#define GIMP_HELP_PALETTE_NEW                     "gimp-palette-new"
#define GIMP_HELP_PALETTE_DUPLICATE               "gimp-palette-duplicate"
#define GIMP_HELP_PALETTE_COPY_LOCATION           "gimp-palette-copy-location"
#define GIMP_HELP_PALETTE_SHOW_IN_FILE_MANAGER    "gimp-palette-show-in-file-manager"
#define GIMP_HELP_PALETTE_DELETE                  "gimp-palette-delete"
#define GIMP_HELP_PALETTE_REFRESH                 "gimp-palette-refresh"
#define GIMP_HELP_PALETTE_IMPORT                  "gimp-palette-import"
#define GIMP_HELP_PALETTE_MERGE                   "gimp-palette-merge"

#define GIMP_HELP_PALETTE_EDITOR_DIALOG           "gimp-palette-editor-dialog"
#define GIMP_HELP_PALETTE_EDITOR_NEW              "gimp-palette-editor-new"
#define GIMP_HELP_PALETTE_EDITOR_EDIT             "gimp-palette-editor-edit"
#define GIMP_HELP_PALETTE_EDITOR_DELETE           "gimp-palette-editor-delete"
#define GIMP_HELP_PALETTE_EDITOR_ZOOM_OUT         "gimp-palette-editor-zoom-out"
#define GIMP_HELP_PALETTE_EDITOR_ZOOM_IN          "gimp-palette-editor-zoom-in"
#define GIMP_HELP_PALETTE_EDITOR_ZOOM_ALL         "gimp-palette-editor-zoom-all"
#define GIMP_HELP_PALETTE_EDITOR_EDIT_ACTIVE      "gimp-palette-editor-edit-active"

#define GIMP_HELP_FONT_DIALOG                     "gimp-font-dialog"
#define GIMP_HELP_FONT_REFRESH                    "gimp-font-refresh"

#define GIMP_HELP_BUFFER_DIALOG                   "gimp-buffer-dialog"
#define GIMP_HELP_BUFFER_CUT                      "gimp-buffer-cut"
#define GIMP_HELP_BUFFER_COPY                     "gimp-buffer-copy"
#define GIMP_HELP_BUFFER_PASTE                    "gimp-buffer-paste"
#define GIMP_HELP_BUFFER_PASTE_IN_PLACE           "gimp-buffer-paste-in-place"
#define GIMP_HELP_BUFFER_PASTE_INTO               "gimp-buffer-paste-into"
#define GIMP_HELP_BUFFER_PASTE_INTO_IN_PLACE      "gimp-buffer-paste-into-in-place"
#define GIMP_HELP_BUFFER_PASTE_AS_NEW_LAYER       "gimp-buffer-paste-as-new-layer"
#define GIMP_HELP_BUFFER_PASTE_AS_NEW_LAYER_IN_PLACE "gimp-buffer-paste-as-new-layer-in-place"
#define GIMP_HELP_BUFFER_PASTE_AS_NEW_IMAGE       "gimp-buffer-paste-as-new-image"
#define GIMP_HELP_BUFFER_DELETE                   "gimp-buffer-delete"

#define GIMP_HELP_TOOL_PRESET_DIALOG              "gimp-tool-preset-dialog"
#define GIMP_HELP_TOOL_PRESET_EDIT                "gimp-tool-preset-edit"
#define GIMP_HELP_TOOL_PRESET_NEW                 "gimp-tool-preset-new"
#define GIMP_HELP_TOOL_PRESET_DUPLICATE           "gimp-tool-preset-duplicate"
#define GIMP_HELP_TOOL_PRESET_COPY_LOCATION       "gimp-tool-preset-copy-location"
#define GIMP_HELP_TOOL_PRESET_SHOW_IN_FILE_MANAGER "gimp-tool-preset-show-in-file-manager"
#define GIMP_HELP_TOOL_PRESET_SAVE                "gimp-tool-preset-save"
#define GIMP_HELP_TOOL_PRESET_RESTORE             "gimp-tool-preset-restore"
#define GIMP_HELP_TOOL_PRESET_DELETE              "gimp-tool-preset-delete"
#define GIMP_HELP_TOOL_PRESET_REFRESH             "gimp-tool-preset-refresh"

#define GIMP_HELP_DOCUMENT_CLEAR                  "gimp-document-clear"
#define GIMP_HELP_DOCUMENT_COPY_LOCATION          "gimp-document-copy-location"
#define GIMP_HELP_DOCUMENT_SHOW_IN_FILE_MANAGER   "gimp-document-show-in-file-manager"
#define GIMP_HELP_DOCUMENT_DIALOG                 "gimp-document-dialog"
#define GIMP_HELP_DOCUMENT_OPEN                   "gimp-document-open"
#define GIMP_HELP_DOCUMENT_REMOVE                 "gimp-document-remove"
#define GIMP_HELP_DOCUMENT_REFRESH                "gimp-document-refresh"

#define GIMP_HELP_TEMPLATE_DIALOG                 "gimp-template-dialog"
#define GIMP_HELP_TEMPLATE_NEW                    "gimp-template-new"
#define GIMP_HELP_TEMPLATE_DUPLICATE              "gimp-template-duplicate"
#define GIMP_HELP_TEMPLATE_EDIT                   "gimp-template-edit"
#define GIMP_HELP_TEMPLATE_IMAGE_NEW              "gimp-template-image-new"
#define GIMP_HELP_TEMPLATE_DELETE                 "gimp-template-delete"

#define GIMP_HELP_TOOL_OPTIONS_DIALOG             "gimp-tool-options-dialog"
#define GIMP_HELP_TOOL_OPTIONS_SAVE               "gimp-tool-options-save"
#define GIMP_HELP_TOOL_OPTIONS_RESTORE            "gimp-tool-options-restore"
#define GIMP_HELP_TOOL_OPTIONS_EDIT               "gimp-tool-options-edit"
#define GIMP_HELP_TOOL_OPTIONS_DELETE             "gimp-tool-options-delete"
#define GIMP_HELP_TOOL_OPTIONS_RESET              "gimp-tool-options-reset"

#define GIMP_HELP_ERRORS_DIALOG                   "gimp-errors-dialog"
#define GIMP_HELP_ERRORS_HIGHLIGHT                "gimp-errors-highlight"
#define GIMP_HELP_ERRORS_CLEAR                    "gimp-errors-clear"
#define GIMP_HELP_ERRORS_SAVE                     "gimp-errors-save"
#define GIMP_HELP_ERRORS_SELECT_ALL               "gimp-errors-select-all"

#define GIMP_HELP_PREFS_DIALOG                    "gimp-prefs-dialog"
#define GIMP_HELP_PREFS_SYSTEM_RESOURCES          "gimp-prefs-system-resources"
#define GIMP_HELP_PREFS_DEBUGGING                 "gimp-prefs-debugging"
#define GIMP_HELP_PREFS_COLOR_MANAGEMENT          "gimp-prefs-color-management"
#define GIMP_HELP_PREFS_IMPORT_EXPORT             "gimp-prefs-import-export"
#define GIMP_HELP_PREFS_PLAYGROUND                "gimp-prefs-playground"
#define GIMP_HELP_PREFS_TOOL_OPTIONS              "gimp-prefs-tool-options"
#define GIMP_HELP_PREFS_NEW_IMAGE                 "gimp-prefs-new-image"
#define GIMP_HELP_PREFS_DEFAULT_GRID              "gimp-prefs-default-grid"
#define GIMP_HELP_PREFS_INTERFACE                 "gimp-prefs-interface"
#define GIMP_HELP_PREFS_THEME                     "gimp-prefs-theme"
#define GIMP_HELP_PREFS_ICON_THEME                "gimp-prefs-icon-theme"
#define GIMP_HELP_PREFS_TOOLBOX                   "gimp-prefs-toolbox"
#define GIMP_HELP_PREFS_DIALOG_DEFAULTS           "gimp-prefs-dialog-defaults"
#define GIMP_HELP_PREFS_HELP                      "gimp-prefs-help"
#define GIMP_HELP_PREFS_DISPLAY                   "gimp-prefs-display"
#define GIMP_HELP_PREFS_WINDOW_MANAGEMENT         "gimp-prefs-window-management"
#define GIMP_HELP_PREFS_CANVAS_INTERACTION        "gimp-prefs-canvas-interaction"
#define GIMP_HELP_PREFS_CANVAS_MODIFIERS          "gimp-prefs-canvas-modifiers"
#define GIMP_HELP_PREFS_IMAGE_WINDOW              "gimp-prefs-image-window"
#define GIMP_HELP_PREFS_IMAGE_WINDOW_APPEARANCE   "gimp-prefs-image-window-appearance"
#define GIMP_HELP_PREFS_IMAGE_WINDOW_TITLE        "gimp-prefs-image-window-title"
#define GIMP_HELP_PREFS_IMAGE_WINDOW_SNAPPING     "gimp-prefs-image-window-snapping"
#define GIMP_HELP_PREFS_INPUT_DEVICES             "gimp-prefs-input-devices"
#define GIMP_HELP_PREFS_INPUT_CONTROLLERS         "gimp-prefs-input-controllers"
#define GIMP_HELP_PREFS_FOLDERS                   "gimp-prefs-folders"
#define GIMP_HELP_PREFS_FOLDERS_BRUSHES           "gimp-prefs-folders-brushes"
#define GIMP_HELP_PREFS_FOLDERS_DYNAMICS          "gimp-prefs-folders-dynamics"
#define GIMP_HELP_PREFS_FOLDERS_PATTERNS          "gimp-prefs-folders-patterns"
#define GIMP_HELP_PREFS_FOLDERS_PALETTES          "gimp-prefs-folders-palettes"
#define GIMP_HELP_PREFS_FOLDERS_GRADIENTS         "gimp-prefs-folders-gradients"
#define GIMP_HELP_PREFS_FOLDERS_FONTS             "gimp-prefs-folders-fonts"
#define GIMP_HELP_PREFS_FOLDERS_TOOL_PRESETS      "gimp-prefs-folders-tool-presets"
#define GIMP_HELP_PREFS_FOLDERS_MYPAINT_BRUSHES   "gimp-prefs-folders-mypaint-brushes"
#define GIMP_HELP_PREFS_FOLDERS_PLUG_INS          "gimp-prefs-folders-plug-ins"
#define GIMP_HELP_PREFS_FOLDERS_SCRIPTS           "gimp-prefs-folders-scripts"
#define GIMP_HELP_PREFS_FOLDERS_MODULES           "gimp-prefs-folders-modules"
#define GIMP_HELP_PREFS_FOLDERS_INTERPRETERS      "gimp-prefs-folders-interpreters"
#define GIMP_HELP_PREFS_FOLDERS_ENVIRONMENT       "gimp-prefs-folders-environment"
#define GIMP_HELP_PREFS_FOLDERS_THEMES            "gimp-prefs-folders-themes"
#define GIMP_HELP_PREFS_FOLDERS_ICON_THEMES       "gimp-prefs-folders-icon-themes"

#define GIMP_HELP_INPUT_DEVICES                   "gimp-help-input-devices"
#define GIMP_HELP_KEYBOARD_SHORTCUTS              "gimp-help-keyboard-shortcuts"

#define GIMP_HELP_INDEXED_PALETTE_DIALOG          "gimp-indexed-palette-dialog"
#define GIMP_HELP_INDEXED_PALETTE_EDIT            "gimp-indexed-palette-edit"
#define GIMP_HELP_INDEXED_PALETTE_ADD             "gimp-indexed-palette-add"
#define GIMP_HELP_INDEXED_PALETTE_SELECTION_REPLACE "gimp-indexed-palette-selection-replace"
#define GIMP_HELP_INDEXED_PALETTE_SELECTION_ADD   "gimp-indexed-palette-selection-add"
#define GIMP_HELP_INDEXED_PALETTE_SELECTION_SUBTRACT "gimp-indexed-palette-selection-subtract"
#define GIMP_HELP_INDEXED_PALETTE_SELECTION_INTERSECT "gimp-indexed-palette-selection-intersect"

#define GIMP_HELP_POINTER_INFO_DIALOG             "gimp-pointer-info-dialog"
#define GIMP_HELP_POINTER_INFO_SAMPLE_MERGED      "gimp-pointer-info-sample-merged"

#define GIMP_HELP_SAMPLE_POINT_DIALOG             "gimp-sample-point-dialog"
#define GIMP_HELP_SAMPLE_POINT_SAMPLE_MERGED      "gimp-sample-point-sample-merged"

#define GIMP_HELP_DASHBOARD_DIALOG                "gimp-dashboard-dialog"
#define GIMP_HELP_DASHBOARD_GROUPS                "gimp-dashboard-groups"
#define GIMP_HELP_DASHBOARD_UPDATE_INTERVAL       "gimp-dashboard-update-interval"
#define GIMP_HELP_DASHBOARD_HISTORY_DURATION      "gimp-dashboard-history-duration"
#define GIMP_HELP_DASHBOARD_LOG_RECORD            "gimp-dashboard-log-record"
#define GIMP_HELP_DASHBOARD_LOG_ADD_MARKER        "gimp-dashboard-log-add-marker"
#define GIMP_HELP_DASHBOARD_LOG_ADD_EMPTY_MARKER  "gimp-dashboard-log-add-empty-marker"
#define GIMP_HELP_DASHBOARD_RESET                 "gimp-dashboard-reset"
#define GIMP_HELP_DASHBOARD_LOW_SWAP_SPACE_WARNING "gimp-dashboard-low-swap-space-warning"

#define GIMP_HELP_DOCK                            "gimp-dock"
#define GIMP_HELP_DOCK_CLOSE                      "gimp-dock-close"
#define GIMP_HELP_DOCK_IMAGE_MENU                 "gimp-dock-image-menu"
#define GIMP_HELP_DOCK_AUTO_BUTTON                "gimp-dock-auto-button"
#define GIMP_HELP_DOCK_CHANGE_SCREEN              "gimp-dock-change-screen"

#define GIMP_HELP_DOCK_TAB_ADD                    "gimp-dock-tab-add"
#define GIMP_HELP_DOCK_TAB_CLOSE                  "gimp-dock-tab-close"
#define GIMP_HELP_DOCK_TAB_LOCK                   "gimp-dock-tab-lock"
#define GIMP_HELP_DOCK_TAB_MENU                   "gimp-dock-tab-menu"
#define GIMP_HELP_DOCK_TAB_DETACH                 "gimp-dock-tab-detach"
#define GIMP_HELP_DOCK_PREVIEW_SIZE               "gimp-dock-preview-size"
#define GIMP_HELP_DOCK_TAB_STYLE                  "gimp-dock-tab-style"
#define GIMP_HELP_DOCK_VIEW_AS_LIST               "gimp-dock-view-as-list"
#define GIMP_HELP_DOCK_VIEW_AS_GRID               "gimp-dock-view-as-grid"
#define GIMP_HELP_DOCK_SHOW_BUTTON_BAR            "gimp-dock-show-button-bar"

#define GIMP_HELP_ABOUT_DIALOG                    "gimp-about-dialog"
#define GIMP_HELP_ACTION_SEARCH_DIALOG            "gimp-action-search-dialog"
#define GIMP_HELP_COLOR_DIALOG                    "gimp-color-dialog"
#define GIMP_HELP_DEVICE_STATUS_DIALOG            "gimp-device-status-dialog"
#define GIMP_HELP_DISPLAY_FILTER_DIALOG           "gimp-display-filter-dialog"
#define GIMP_HELP_HISTOGRAM_DIALOG                "gimp-histogram-dialog"
#define GIMP_HELP_MODULE_DIALOG                   "gimp-module-dialog"
#define GIMP_HELP_NAVIGATION_DIALOG               "gimp-navigation-dialog"
#define GIMP_HELP_SYMMETRY_DIALOG                 "gimp-symmetry-dialog"
#define GIMP_HELP_TEXT_EDITOR_DIALOG              "gimp-text-editor-dialog"
#define GIMP_HELP_TIPS_DIALOG                     "gimp-tips-dialog"
#define GIMP_HELP_UNDO_DIALOG                     "gimp-undo-dialog"
#define GIMP_HELP_WELCOME_DIALOG                  "gimp-welcome-dialog"

#define GIMP_HELP_EXPORT_DIALOG                   "gimp-export-dialog"
#define GIMP_HELP_EXPORT_CONFIRM_DIALOG           "gimp-export-confirm-dialog"

#define GIMP_HELP_WINDOWS_SHOW_DOCK               "gimp-windows-show-dock"
#define GIMP_HELP_WINDOWS_HIDE_DOCKS              "gimp-windows-hide-docks"
#define GIMP_HELP_WINDOWS_SHOW_TABS               "gimp-windows-show-tabs"
#define GIMP_HELP_WINDOWS_TABS_POSITION           "gimp-windows-tabs-position"
#define GIMP_HELP_WINDOWS_USE_SINGLE_WINDOW_MODE  "gimp-windows-use-single-window-mode"
#define GIMP_HELP_WINDOWS_OPEN_RECENT_DOCK        "gimp-windows-open-recent-dock"

#define GIMP_HELP_HELP                            "gimp-help"
#define GIMP_HELP_HELP_CONTEXT                    "gimp-help-context"

/* Most of the colordisplay, colorselector and controller id's below are not
   used since they are needed in /libgimpwidgets/ or /modules/ where this can't
   be used. Instead the strings are used there directly.
   We define them here anyway, to make gimp-help aware of them.
 */
#define GIMP_HELP_COLORDISPLAY_ACES_RRT           "gimp-colordisplay-aces-rrt"
#define GIMP_HELP_COLORDISPLAY_CLIP               "gimp-colordisplay-clip"
#define GIMP_HELP_COLORDISPLAY_COLORBLIND         "gimp-colordisplay-colorblind"
#define GIMP_HELP_COLORDISPLAY_CONTRAST           "gimp-colordisplay-contrast"
#define GIMP_HELP_COLORDISPLAY_GAMMA              "gimp-colordisplay-gamma"

#define GIMP_HELP_COLORSELECTOR_CMYK              "gimp-colorselector-cmyk"
#define GIMP_HELP_COLORSELECTOR_GIMP              "gimp-colorselector-gimp"
#define GIMP_HELP_COLORSELECTOR_NOTEBOOK          "gimp-colorselector-notebook"
#define GIMP_HELP_COLORSELECTOR_PALETTE           "gimp-colorselector-palette"
#define GIMP_HELP_COLORSELECTOR_SCALES            "gimp-colorselector-scales"
#define GIMP_HELP_COLORSELECTOR_TRIANGLE          "gimp-colorselector-triangle"
#define GIMP_HELP_COLORSELECTOR_WATERCOLOR        "gimp-colorselector-watercolor"

#define GIMP_HELP_CONTROLLER_KEYBOARD             "gimp-controller-keyboard"
#define GIMP_HELP_CONTROLLER_DIRECTX_DIRECTINPUT  "gimp-controller-directx-directinput"
#define GIMP_HELP_CONTROLLER_LINUX_INPUT          "gimp-controller-linux-input"
#define GIMP_HELP_CONTROLLER_MIDI                 "gimp-controller-midi"
#define GIMP_HELP_CONTROLLER_WHEEL                "gimp-controller-wheel"

#define GIMP_HELP_EXTENSIONS_DIALOG               "gimp-extensions-dialog"
#define GIMP_HELP_EXTENSIONS_INSTALLED            "gimp-extensions-installed"
#define GIMP_HELP_EXTENSIONS_SYSTEM               "gimp-extensions-system"
#define GIMP_HELP_EXTENSIONS_INSTALL              "gimp-extensions-install"

#endif /* __GIMP_HELP_IDS_H__ */
