# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

toolbar-button-firefox-view =
    .label = { -firefoxview-brand-name }
    .tooltiptext = { -firefoxview-brand-name }
toolbar-button-firefox-view-2 =
    .label = { -firefoxview-brand-name }
    .tooltiptext = Ver navegação recente em janelas e dispositivos
menu-tools-firefox-view =
    .label = { -firefoxview-brand-name }
    .accesskey = F
firefoxview-page-title = { -firefoxview-brand-name }
firefoxview-page-heading =
    .heading = { -firefoxview-brand-name }
firefoxview-page-label =
    .label = { -firefoxview-brand-name }
firefoxview-close-button =
    .title = Fechar
    .aria-label = Fechar
# Used instead of the localized relative time when a timestamp is within a minute or so of now
firefoxview-just-now-timestamp = há pouco
# This is a headline for an area in the product where users can resume and re-open tabs they have previously viewed on other devices.
firefoxview-tabpickup-header = Escolha de abas
firefoxview-tabpickup-description = Abra páginas de outros dispositivos.
# Variables:
#  $percentValue (Number): the percentage value for setup completion
firefoxview-tabpickup-progress-label = { $percentValue }% concluído
firefoxview-tabpickup-step-signin-header = Passe facilmente de um dispositivo para outro
firefoxview-tabpickup-step-signin-description = Para abrir aqui as abas do seu celular, primeiro entre na sua conta ou crie uma.
firefoxview-tabpickup-step-signin-primarybutton = Avançar
firefoxview-syncedtabs-signin-header-2 = O { -brand-product-name } do seu jeito, em todos os seus dispositivos
firefoxview-syncedtabs-signin-description-2 = Para ver abas abertas em seu celular e outros dispositivos, entre na sua conta ou crie uma. Com uma conta, você também pode sincronizar senhas, histórico e muito mais.
firefoxview-syncedtabs-signin-primarybutton-2 = Entrar
firefoxview-tabpickup-adddevice-header = Sincronize o { -brand-product-name } em seu celular ou tablet
firefoxview-tabpickup-adddevice-description = Instale o { -brand-product-name } para dispositivos móveis e entre na sua conta.
firefoxview-tabpickup-adddevice-learn-how = Saiba como
firefoxview-tabpickup-adddevice-primarybutton = Instale o { -brand-product-name } para dispositivos móveis
firefoxview-syncedtabs-adddevice-header-2 = Recupere suas abas de qualquer dispositivo
firefoxview-syncedtabs-adddevice-description-2 = Entre na sua conta no { -brand-product-name } no seu celular ou outro computador para ver abas aqui. Saiba como <a data-l10n-name="url">conectar dispositivos adicionais</a>.
firefoxview-syncedtabs-adddevice-primarybutton = Experimente o { -brand-product-name } para celular
firefoxview-tabpickup-synctabs-header = Ative a sincronização de abas
firefoxview-tabpickup-synctabs-description = Permitir que o { -brand-short-name } compartilhe abas entre dispositivos.
firefoxview-tabpickup-synctabs-learn-how = Saiba como
firefoxview-tabpickup-synctabs-primarybutton = Sincronizar abas abertas
firefoxview-syncedtabs-synctabs-header = Atualize suas configurações de sincronização
firefoxview-syncedtabs-synctabs-description = Para acessar suas abas de outros dispositivos, você precisa sincronizar suas abas abertas.
firefoxview-syncedtabs-loading-header = Sincronização em andamento
firefoxview-syncedtabs-loading-description = Quando terminar, abas abertas em outros dispositivos aparecem aqui. Verifique mais tarde.
firefoxview-tabpickup-fxa-admin-disabled-header = Sua organização desativou a sincronização
firefoxview-tabpickup-fxa-admin-disabled-description = O { -brand-short-name } não consegue sincronizar abas entre dispositivos porque seu administrador desativou a sincronização.
firefoxview-tabpickup-fxa-disabled-by-policy-description = O { -brand-short-name } não pode sincronizar abas entre dispositivos porque sua organização desativou a sincronização.
firefoxview-tabpickup-network-offline-header = Verifique sua conexão com a internet
firefoxview-tabpickup-network-offline-description = Se estiver usando um firewall ou proxy, verifique se o { -brand-short-name } tem permissão para acessar a web.
firefoxview-tabpickup-network-offline-primarybutton = Tentar novamente
firefoxview-tabpickup-sync-error-header = Há algum problema na sincronização
firefoxview-tabpickup-generic-sync-error-description = O { -brand-short-name } não pode acessar o serviço de sincronização no momento. Tente novamente daqui a pouco.
firefoxview-tabpickup-sync-error-primarybutton = Tentar novamente
firefoxview-tabpickup-sync-disconnected-header = Ative a sincronização para continuar
firefoxview-tabpickup-sync-disconnected-description = Para pegar suas abas, você precisa permitir a sincronização no { -brand-short-name }.
firefoxview-tabpickup-sync-disconnected-primarybutton = Ativar a sincronização nas configurações
firefoxview-tabpickup-password-locked-header = Digite sua senha principal para ver abas
firefoxview-tabpickup-password-locked-description = Para recuperar suas abas, precisa inserir a senha principal do { -brand-short-name }.
firefoxview-tabpickup-password-locked-link = Saiba mais
firefoxview-tabpickup-password-locked-primarybutton = Digite a senha principal
firefoxview-syncedtab-password-locked-link = <a data-l10n-name="syncedtab-password-locked-link">Saiba mais</a>
firefoxview-tabpickup-signed-out-header = Entre na conta para reconectar
firefoxview-tabpickup-signed-out-description = Para reconectar e acessar suas abas, entre na sua conta { -fxaccount-brand-name }.
firefoxview-tabpickup-signed-out-description2 = Para se reconectar e recuperar suas abas, entre na sua conta.
firefoxview-tabpickup-signed-out-primarybutton = Entrar
firefoxview-tabpickup-syncing = Aguarde a sincronização de abas. É rápido.
firefoxview-mobile-promo-header = Abra abas do seu celular ou tablet
firefoxview-mobile-promo-description = Para ver suas abas mais recentes do celular, entre na sua conta no { -brand-product-name } no iOS ou Android.
firefoxview-mobile-promo-primarybutton = Instale o { -brand-product-name } para dispositivos móveis
firefoxview-mobile-confirmation-header = 🎉 Pronto!
firefoxview-mobile-confirmation-description = Agora você pode abrir suas abas do { -brand-product-name } do seu tablet ou celular.
firefoxview-closed-tabs-title = Fechado recentemente
firefoxview-closed-tabs-description2 = Reabra páginas que você fechou neste computador.
firefoxview-closed-tabs-placeholder-header = Nenhuma aba fechada recentemente
firefoxview-closed-tabs-placeholder-body = Ao fechar uma aba nesta janela, você pode recuperar aqui.
# Variables:
#   $tabTitle (string) - Title of tab being dismissed
firefoxview-closed-tabs-dismiss-tab =
    .title = Descartar { $tabTitle }
# refers to the last tab that was used
firefoxview-pickup-tabs-badge = Última ativa
# Variables:
#   $targetURI (string) - URL that will be opened in the new tab
firefoxview-tabs-list-tab-button =
    .title = Abrir { $targetURI } em nova aba
firefoxview-try-colorways-button = Experimentar esquemas de cores
firefoxview-change-colorway-button = Mudar esquema de cores
# Variables:
#  $intensity (String): Colorway intensity
#  $collection (String): Colorway Collection name
firefoxview-colorway-description = { $intensity } · { $collection }
firefoxview-synced-tabs-placeholder-header = Nada para mostrar ainda
firefoxview-synced-tabs-placeholder-body = A próxima vez que você abrir uma página no { -brand-product-name } em outro dispositivo, ela aparece aqui como mágica.
firefoxview-collapse-button-show =
    .title = Exibir lista
firefoxview-collapse-button-hide =
    .title = Ocultar lista
firefoxview-overview-nav = Navegação recente
    .title = Navegação recente
firefoxview-overview-header = Navegação recente
    .title = Navegação recente

## History in this context refers to browser history

firefoxview-history-nav = Histórico
    .title = Histórico
firefoxview-history-header = Histórico
firefoxview-history-context-delete = Excluir do histórico
    .accesskey = x

## Open Tabs in this context refers to all open tabs in the browser

firefoxview-opentabs-nav = Abas abertas
    .title = Abas abertas
firefoxview-opentabs-header = Abas abertas

## Recently closed tabs in this context refers to recently closed tabs from all windows

firefoxview-recently-closed-nav = Abas fechadas recentemente
    .title = Abas fechadas recentemente
firefoxview-recently-closed-header = Abas fechadas recentemente

## Tabs from other devices refers in this context refers to synced tabs from other devices

firefoxview-synced-tabs-nav = Abas de outros dispositivos
    .title = Abas de outros dispositivos
firefoxview-synced-tabs-header = Abas de outros dispositivos

##

# Used for a link in collapsible cards, in the ’Recent browsing’ page of Firefox View
firefoxview-view-all-link = Ver tudo
# Variables:
#   $winID (Number) - The index of the owner window for this set of tabs
firefoxview-opentabs-window-header =
    .title = Janela { $winID }
# Variables:
#   $winID (Number) - The index of the owner window (which is currently focused) for this set of tabs
firefoxview-opentabs-current-window-header =
    .title = Janela { $winID } (atual)
firefoxview-show-more = Mostrar mais
firefoxview-show-less = Mostrar menos
firefoxview-show-all = Mostrar tudo
firefoxview-search-text-box-clear-button =
    .title = Limpar
# Placeholder for the input field to search in recent browsing ("search" is a verb).
firefoxview-search-text-box-recentbrowsing =
    .placeholder = Procurar
# Placeholder for the input field to search in history ("search" is a verb).
firefoxview-search-text-box-history =
    .placeholder = Pesquisar no histórico
# Placeholder for the input field to search in recently closed tabs ("search" is a verb).
firefoxview-search-text-box-recentlyclosed =
    .placeholder = Pesquisar em abas fechadas recentemente
# Placeholder for the input field to search in tabs from other devices ("search" is a verb).
firefoxview-search-text-box-tabs =
    .placeholder = Pesquisar nas abas
# Placeholder for the input field to search in open tabs ("search" is a verb).
firefoxview-search-text-box-opentabs =
    .placeholder = Pesquisar em abas abertas
# "Search" is a noun (as in "Results of the search for")
# Variables:
#   $query (String) - The search query used for searching through browser history.
firefoxview-search-results-header = Resultados da pesquisa de “{ $query }”
# Variables:
#   $count (Number) - The number of visits matching the search query.
firefoxview-search-results-count =
    { $count ->
        [one] { $count } site
       *[other] { $count } sites
    }
# Message displayed when a search is performed and no matching results were found.
# Variables:
#   $query (String) - The search query.
firefoxview-search-results-empty = Nenhum resultado de “{ $query }”
firefoxview-sort-history-by-date-label = Ordenar por data
firefoxview-sort-history-by-site-label = Ordenar por site
firefoxview-sort-open-tabs-by-recency-label = Ordenar por atividade recente
firefoxview-sort-open-tabs-by-order-label = Ordenar por ordem de aba

## Variables:
##   $date (string) - Date to be formatted based on locale

firefoxview-history-date-today = Hoje - { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-yesterday = Ontem - { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-this-month = { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-prev-month = { DATETIME($date, month: "long", year: "numeric") }
# When history is sorted by site, this heading is used in place of a domain, in
# order to group sites that do not come from an outside host.
# For example, this would be the heading for all file:/// URLs in history.
firefoxview-history-site-localhost = (arquivos locais)

##

firefoxview-show-all-history = Mostrar todo o histórico

## Message displayed in Firefox View when the user has no history data

firefoxview-history-empty-header = Retorne para onde você já esteve
firefoxview-history-empty-description = Conforme você navega, as páginas visitadas aparecem aqui.
firefoxview-history-empty-description-two = Proteger sua privacidade está no cerne do que fazemos. É por isso que você pode controlar a atividade que o { -brand-short-name } memoriza, nas <a data-l10n-name="history-settings-url">configurações de histórico</a>.

##

# Button text for choosing a browser within the ’Import history from another browser’ banner
firefoxview-choose-browser-button = Escolher navegador
    .title = Escolher navegador

## Message displayed in Firefox View when the user has chosen to never remember History

firefoxview-dont-remember-history-empty-header-2 = Você tem controle sobre o que o { -brand-short-name } memoriza.
firefoxview-dont-remember-history-empty-description-one = No momento, o { -brand-short-name } não memoriza sua atividade de navegação. Para mudar isto, <a data-l10n-name="history-settings-url-two">altere as configurações de histórico</a>.

##

# This label is read by screen readers when focusing the close button for the "Import history from another browser" banner in Firefox View
firefoxview-import-history-close-button =
    .aria-label = Fechar
    .title = Fechar

## Text displayed in a dismissable banner to import bookmarks/history from another browser

firefoxview-import-history-header = Importar histórico de outro navegador
firefoxview-import-history-description = Torne o { -brand-short-name } seu navegador padrão. Importe histórico de navegação, favoritos, etc.

## Message displayed in Firefox View when the user has no recently closed tabs data

firefoxview-recentlyclosed-empty-header = Fechou uma aba cedo demais?
firefoxview-recentlyclosed-empty-description = Aqui você encontra as abas que fechou recentemente, assim pode reabrir qualquer uma delas rapidamente.
firefoxview-recentlyclosed-empty-description-two = Para encontrar abas fechadas há mais tempo, procure no <a data-l10n-name="history-url">histórico de navegação</a>.

## This message is displayed below the name of another connected device when it doesn't have any open tabs.

firefoxview-syncedtabs-device-notabs = Nenhuma aba aberta neste dispositivo
firefoxview-syncedtabs-connect-another-device = Conecte outro dispositivo
firefoxview-pinned-tabs =
    .title = Abas fixas
firefoxview-tabs =
    .title = Abas

## These tooltips will be displayed when hovering over a pinned tab on the Open Tabs page
## Variables:
##  $tabTitle (string) - Title of pinned tab that will be opened when selected

firefoxview-opentabs-pinned-tab =
    .title = Mudar para { $tabTitle }
# This tooltip will be shown for a pinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-pinned-tab =
    .title = Mudar para { $tabTitle } (favorito)

## These tooltips will be displayed when hovering over an unpinned Open Tab
## Variables:
##   $url (string) - URL of tab that will be opened when selected

# This tooltip will be shown for an unpinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-tab =
    .title = (favorito) { $url }
