/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.PlayerWrapper;
import friendless.games.filler.PlayerWrappers;
import friendless.games.filler.TournamentPointsTable;
import friendless.games.filler.TournamentRules;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class TournamentResultsPanel
extends JPanel {
    private JTextArea textArea;
    private JScrollPane textScroll;
    private JTable pointsTable;
    private TournamentPointsTable tableModel;
    private JScrollPane tableScroll;
    private static TournamentResultsPanel instance;
    private ResourceBundle resources;

    private TournamentResultsPanel(ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
        this.textArea = new JTextArea("Results from any Tournaments will be displayed here");
        this.textArea.setEditable(false);
        this.textScroll = new JScrollPane(this.textArea, 20, 30);
        this.tableScroll = new JScrollPane(20, 30);
        this.add("Center", this.textScroll);
    }

    public static TournamentResultsPanel getInstance(ResourceBundle resourceBundle) {
        if (instance == null) {
            instance = new TournamentResultsPanel(resourceBundle);
        }
        return instance;
    }

    public void addText(String string) {
        String string2 = this.textArea.getText();
        this.textArea.setText(string2 + string);
    }

    public void clearText() {
        this.textArea.setText("");
    }

    public void addMatch(PlayerWrapper[] playerWrapperArray, int[] nArray) {
        this.tableModel.addMatch(playerWrapperArray, nArray);
    }

    public void newTournament(TournamentRules tournamentRules, PlayerWrappers playerWrappers) {
        switch (tournamentRules.rules) {
            case 0: {
                this.removeAll();
                this.tableModel = new TournamentPointsTable(this.resources, playerWrappers);
                this.pointsTable = new JTable(this.tableModel);
                this.tableScroll.setViewportView(this.pointsTable);
                this.tableScroll.setPreferredSize(new Dimension(1, this.pointsTable.getRowHeight() * (this.pointsTable.getRowCount() + 1)));
                this.setLayout(new BorderLayout(4, 4));
                this.add("Center", new JSplitPane(0, this.tableScroll, this.textScroll));
                break;
            }
            default: {
                this.removeAll();
                this.setLayout(new BorderLayout(4, 4));
                this.add("Center", this.textScroll);
            }
        }
        this.clearText();
    }
}

