package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2015
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;

/**
 * Unit test for the Generalized Pareto Distribution (GPD) in ELKI.
 * 
 * The reference values were computed using SciPy.
 * 
 * @author Erich Schubert
 * @since 0.7.0
 */
public class GeneralizedParetoDistributionTest extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  1e-10, 1e-05, 0.1, 0.1234567, 0.2, 0.271828182846, 0.3, 0.314159265359, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.71828182846, 3.14159265359 //
  };

  public static final double[] SCIPY_GPD_CDF_1_05_1 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  9.09090909090909393697188534133601933717727661132812e-02, // 0.600000
  1.66666666666666629659232512494781985878944396972656e-01, // 0.700000
  2.30769230769230837552186130778864026069641113281250e-01, // 0.800000
  2.85714285714285698425385362497763708233833312988281e-01, // 0.900000
  3.33333333333333370340767487505218014121055603027344e-01, // 1.000000
  3.75000000000000000000000000000000000000000000000000e-01, // 1.100000
  4.11764705882352921584299565438413992524147033691406e-01, // 1.200000
  4.44444444444444419772821674996521323919296264648438e-01, // 1.300000
  4.73684210526315818690079595398856326937675476074219e-01, // 1.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 1.500000
  5.23809523809523835957691062503727152943611145019531e-01, // 1.600000
  5.45454545454545414173708195448853075504302978515625e-01, // 1.700000
  5.65217391304347782643446862493874505162239074707031e-01, // 1.800000
  5.83333333333333259318465024989563971757888793945312e-01, // 1.900000
  5.99999999999999977795539507496869191527366638183594e-01, // 2.000000
  6.89275193006072761647828883724287152290344238281250e-01, // 2.718282
  7.25394876603174032503318358067190274596214294433594e-01, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_1_05_1 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  8.26446280991735449106272426433861255645751953125000e-01, // 0.600000
  6.94444444444444530795124137512175366282463073730469e-01, // 0.700000
  5.91715976331360860029917603242211043834686279296875e-01, // 0.800000
  5.10204081632653072553296169644454494118690490722656e-01, // 0.900000
  4.44444444444444419772821674996521323919296264648438e-01, // 1.000000
  3.90624999999999944488848768742172978818416595458984e-01, // 1.100000
  3.46020761245674768336044735406176187098026275634766e-01, // 1.200000
  3.08641975308641958175570607636473141610622406005859e-01, // 1.300000
  2.77008310249307498907000990584492683410644531250000e-01, // 1.400000
  2.50000000000000000000000000000000000000000000000000e-01, // 1.500000
  2.26757369614512455102683929908380378037691116333008e-01, // 1.600000
  2.06611570247933862276568106608465313911437988281250e-01, // 1.700000
  1.89035916824196625896092882612720131874084472656250e-01, // 1.800000
  1.73611111111111132698781034378043841570615768432617e-01, // 1.900000
  1.60000000000000003330669073875469621270895004272461e-01, // 2.000000
  9.65499056814133199688754416456504259258508682250977e-02, // 2.718282
  7.54079737957860096742024325067177414894104003906250e-02, // 3.141593
  };

  public static final double[] SCIPY_GPD_CDF_1_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.66666666666666629659232512494781985878944396972656e-01, // 0.600000
  2.85714285714285698425385362497763708233833312988281e-01, // 0.700000
  3.75000000000000000000000000000000000000000000000000e-01, // 0.800000
  4.44444444444444419772821674996521323919296264648438e-01, // 0.900000
  5.00000000000000000000000000000000000000000000000000e-01, // 1.000000
  5.45454545454545414173708195448853075504302978515625e-01, // 1.100000
  5.83333333333333259318465024989563971757888793945312e-01, // 1.200000
  6.15384615384615418776093065389432013034820556640625e-01, // 1.300000
  6.42857142857142793701541449991054832935333251953125e-01, // 1.400000
  6.66666666666666740681534975010436028242111206054688e-01, // 1.500000
  6.87500000000000000000000000000000000000000000000000e-01, // 1.600000
  7.05882352941176405280998551461379975080490112304688e-01, // 1.700000
  7.22222222222222209886410837498260661959648132324219e-01, // 1.800000
  7.36842105263157964856191028957255184650421142578125e-01, // 1.900000
  7.50000000000000000000000000000000000000000000000000e-01, // 2.000000
  8.16060279414278832987861278525087982416152954101562e-01, // 2.718282
  8.40845056908104626636202283407328650355339050292969e-01, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_1_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.38888888888888906159024827502435073256492614746094e+00, // 0.600000
  1.02040816326530614510659233928890898823738098144531e+00, // 0.700000
  7.81249999999999888977697537484345957636833190917969e-01, // 0.800000
  6.17283950617283916351141215272946283221244812011719e-01, // 0.900000
  5.00000000000000000000000000000000000000000000000000e-01, // 1.000000
  4.13223140495867724553136213216930627822875976562500e-01, // 1.100000
  3.47222222222222265397562068756087683141231536865234e-01, // 1.200000
  2.95857988165680430014958801621105521917343139648438e-01, // 1.300000
  2.55102040816326536276648084822227247059345245361328e-01, // 1.400000
  2.22222222222222209886410837498260661959648132324219e-01, // 1.500000
  1.95312499999999972244424384371086489409208297729492e-01, // 1.600000
  1.73010380622837384168022367703088093549013137817383e-01, // 1.700000
  1.54320987654320979087785303818236570805311203002930e-01, // 1.800000
  1.38504155124653749453500495292246341705322265625000e-01, // 1.900000
  1.25000000000000000000000000000000000000000000000000e-01, // 2.000000
  6.76676416183063511589068639295874163508415222167969e-02, // 2.718282
  5.06605918211688877050846713245846331119537353515625e-02, // 3.141593
  };

  public static final double[] SCIPY_GPD_CDF_2_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.54845745271483425931080546433804556727409362792969e-01, // 0.600000
  2.54644007500070101990274906711420044302940368652344e-01, // 0.700000
  3.25800137536757961065347899420885369181632995605469e-01, // 0.800000
  3.79826327053957690793595247669145464897155761718750e-01, // 0.900000
  4.22649730810374268941131958854384720325469970703125e-01, // 1.000000
  4.57673855453359590406137158424826338887214660644531e-01, // 1.100000
  4.87010823957422900321034830994904041290283203125000e-01, // 1.200000
  5.12049963525733398128636508772615343332290649414062e-01, // 1.300000
  5.33747595879843106381201778276590630412101745605469e-01, // 1.400000
  5.52786404500042127807546421536244451999664306640625e-01, // 1.500000
  5.69668517088064874087649513967335224151611328125000e-01, // 1.600000
  5.84772600731300107312904401624109596014022827148438e-01, // 1.700000
  5.98390335548750540439755241095554083585739135742188e-01, // 1.800000
  6.10750527919238450635930348653346300125122070312500e-01, // 1.900000
  6.22035526990772691391384796588681638240814208984375e-01, // 2.000000
  6.81746908283135999440105479152407497167587280273438e-01, // 2.718282
  7.05963362284699358362161092372843995690345764160156e-01, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_2_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.20736322104073812155888845154549926519393920898438e+00, // 0.600000
  8.28173324999922244593619780061999335885047912597656e-01, // 0.700000
  6.12908965875674560663810552796348929405212402343750e-01, // 0.800000
  4.77056671496955575495491075344034470617771148681641e-01, // 0.900000
  3.84900179459750524380012848268961533904075622558594e-01, // 1.000000
  3.19015379145082544898315290993195958435535430908203e-01, // 1.100000
  2.69994303180303707456744177761720493435859680175781e-01, // 1.200000
  2.32357160225841213874176105491642374545335769653320e-01, // 1.300000
  2.02718436573981281023648648442758712917566299438477e-01, // 1.400000
  1.78885438199983176632557047014415729790925979614258e-01, // 1.500000
  1.59382030708124122764246521910536102950572967529297e-01, // 1.600000
  1.43181861816793043473694524436723440885543823242188e-01, // 1.700000
  1.29551504661693350772821986538474448025226593017578e-01, // 1.800000
  1.17954385479018639126813638995372457429766654968262e-01, // 1.900000
  1.07989849431207776686569843604956986382603645324707e-01, // 2.000000
  6.44685481308166080660626562348625157028436660766602e-02, // 2.718282
  5.08433712733130441230322560386412078514695167541504e-02, // 3.141593
  };

  public static final double[] SCIPY_GPD_CDF_4_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.36659978629549483386540487117599695920944213867188e-01, // 0.600000
  2.12488937889731999142384211154421791434288024902344e-01, // 0.700000
  2.63572037096200140204871331661706790328025817871094e-01, // 0.800000
  3.01465794341990278581988604855723679065704345703125e-01, // 0.900000
  3.31259695023577993566732402541674673557281494140625e-01, // 1.000000
  3.55618591772931535999191510200034826993942260742188e-01, // 1.100000
  3.76101392788250055154719575511990115046501159667969e-01, // 1.200000
  3.93693715151406498087283125641988590359687805175781e-01, // 1.300000
  4.09055715075617998266466202039737254381179809570312e-01, // 1.400000
  4.22649730810374268941131958854384720325469970703125e-01, // 1.500000
  4.34811285940731151455906910996418446302413940429688e-01, // 1.600000
  4.45791051662844717284883699903730303049087524414062e-01, // 1.700000
  4.55780890743860300773349081282503902912139892578125e-01, // 1.800000
  4.64930689389744467021614582336042076349258422851562e-01, // 1.900000
  4.73359612152073339075286639854311943054199218750000e-01, // 2.000000
  5.19413715714150292512840678682550787925720214843750e-01, // 2.718282
  5.38957248542760725129596721671987324953079223632812e-01, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_4_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  9.59266690411611722133500279596773907542228698730469e-01, // 0.600000
  6.05777740084821547661420026997802779078483581542969e-01, // 0.700000
  4.33192919355176342399715849751373752951622009277344e-01, // 0.800000
  3.32635336027623629284732942323898896574974060058594e-01, // 0.900000
  2.67496121990568824777767531486460939049720764160156e-01, // 1.000000
  2.22200485595540814243165073094132822006940841674805e-01, // 1.100000
  1.89060184003560616261552240757737308740615844726562e-01, // 1.200000
  1.63866563472592846606445959878328721970319747924805e-01, // 1.300000
  1.44132752420580989571874397370265796780586242675781e-01, // 1.400000
  1.28300059819916822956287205670378170907497406005859e-01, // 1.500000
  1.15344635522299759911035721415828447788953781127930e-01, // 1.600000
  1.04567726101350053080629720625438494607806205749512e-01, // 1.700000
  9.54770367116034579524352920998353511095046997070312e-02, // 1.800000
  8.77162804279107422011918515636352822184562683105469e-02, // 1.900000
  8.10215981304502480542240050453983712941408157348633e-02, // 2.000000
  5.12727788916758214776692170744354370981454849243164e-02, // 2.718282
  4.16616041088496702471388744015712291002273559570312e-02, // 3.141593
  };

  public static final double[] SCIPY_GPD_CDF_M1_05_1 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  9.99999999999999777955395074968691915273666381835938e-02, // 0.600000
  1.99999999999999955591079014993738383054733276367188e-01, // 0.700000
  3.00000000000000044408920985006261616945266723632812e-01, // 0.800000
  4.00000000000000022204460492503130808472633361816406e-01, // 0.900000
  5.00000000000000000000000000000000000000000000000000e-01, // 1.000000
  6.00000000000000088817841970012523233890533447265625e-01, // 1.100000
  6.99999999999999955591079014993738383054733276367188e-01, // 1.200000
  8.00000000000000044408920985006261616945266723632812e-01, // 1.300000
  8.99999999999999911182158029987476766109466552734375e-01, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_M1_05_1 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_GPD_CDF_M1_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.99999999999999955591079014993738383054733276367188e-01, // 0.600000
  3.99999999999999911182158029987476766109466552734375e-01, // 0.700000
  6.00000000000000088817841970012523233890533447265625e-01, // 0.800000
  8.00000000000000044408920985006261616945266723632812e-01, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_M1_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  2.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_GPD_CDF_M2_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  2.25403330758516595722085185116156935691833496093750e-01, // 0.600000
  5.52786404500041905762941496504936367273330688476562e-01, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_M2_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  2.58198889747161119956331276625860482454299926757812e+00, // 0.600000
  4.47213595499957783374611608451232314109802246093750e+00, // 0.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_GPD_CDF_M4_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  3.31259695023577882544429940026020631194114685058594e-01, // 0.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_GPD_PDF_M4_05_05 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000010
  0.00000000000000000000000000000000000000000000000000e+00, // 0.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.123457
  0.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  0.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  6.68740304976421562344057747395709156990051269531250e+00, // 0.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_GPD_QUANT_1_05_1 = { //
  5.00100010001000017112460227508563548326492309570312e-01, // 0.000100
  5.01001001001001089463215976138599216938018798828125e-01, // 0.001000
  5.10101010101010166053470129554625600576400756835938e-01, // 0.010000
  6.11111111111111160454356650006957352161407470703125e-01, // 0.100000
  8.33333333333333259318465024989563971757888793945312e-01, // 0.250000
  1.50000000000000000000000000000000000000000000000000e+00, // 0.500000
  3.50000000000000000000000000000000000000000000000000e+00, // 0.750000
  9.50000000000000177635683940025046467781066894531250e+00, // 0.900000
  9.94999999999999147348717087879776954650878906250000e+01, // 0.990000
  9.99499999999999090505298227071762084960937500000000e+02, // 0.999000
  9.99950000000110048858914524316787719726562500000000e+03, // 0.999900
  };

  public static final double[] SCIPY_GPD_QUANT_1_05_05 = { //
  5.00050005000500008556230113754281774163246154785156e-01, // 0.000100
  5.00500500500500544731607988069299608469009399414062e-01, // 0.001000
  5.05050505050505083026735064777312800288200378417969e-01, // 0.010000
  5.55555555555555580227178325003478676080703735351562e-01, // 0.100000
  6.66666666666666629659232512494781985878944396972656e-01, // 0.250000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  2.00000000000000000000000000000000000000000000000000e+00, // 0.750000
  5.00000000000000088817841970012523233890533447265625e+00, // 0.900000
  4.99999999999999573674358543939888477325439453125000e+01, // 0.990000
  4.99999999999999545252649113535881042480468750000000e+02, // 0.999000
  5.00000000000055024429457262158393859863281250000000e+03, // 0.999900
  };

  public static final double[] SCIPY_GPD_QUANT_2_05_05 = { //
  5.00050007501000148835146319470368325710296630859375e-01, // 0.000100
  5.00500751001251575900141688180156052112579345703125e-01, // 0.001000
  5.05076012651770156480779405683279037475585937500000e-01, // 0.010000
  5.58641975308642013686721838894300162792205810546875e-01, // 0.100000
  6.94444444444444419772821674996521323919296264648438e-01, // 0.250000
  1.25000000000000000000000000000000000000000000000000e+00, // 0.500000
  4.25000000000000000000000000000000000000000000000000e+00, // 0.750000
  2.52500000000000106581410364015027880668640136718750e+01, // 0.900000
  2.50024999999999545252649113535881042480468750000000e+03, // 0.990000
  2.50000249999999563442543148994445800781250000000000e+05, // 0.999000
  2.50000002500055059790611267089843750000000000000000e+07, // 0.999900
  };

  public static final double[] SCIPY_GPD_QUANT_4_05_05 = { //
  5.00050012502500473843269901408348232507705688476562e-01, // 0.000100
  5.00501252504382043717612305044895038008689880371094e-01, // 0.001000
  5.05127544460652111446563594654435291886329650878906e-01, // 0.010000
  5.65519737844840664209300484799314290285110473632812e-01, // 0.100000
  7.70061728395061706464730377774685621261596679687500e-01, // 0.250000
  2.37500000000000000000000000000000000000000000000000e+00, // 0.500000
  3.23750000000000000000000000000000000000000000000000e+01, // 0.750000
  1.25037500000000113686837721616029739379882812500000e+03, // 0.900000
  1.25000003749999552965164184570312500000000000000000e+07, // 0.990000
  1.25000000000374557495117187500000000000000000000000e+11, // 0.999000
  1.25000000000055100000000000000000000000000000000000e+15, // 0.999900
  };

  public static final double[] SCIPY_GPD_QUANT_M1_05_1 = { //
  5.00099999999999988986587595718447118997573852539062e-01, // 0.000100
  5.01000000000000000888178419700125232338905334472656e-01, // 0.001000
  5.10000000000000008881784197001252323389053344726562e-01, // 0.010000
  5.99999999999999977795539507496869191527366638183594e-01, // 0.100000
  7.50000000000000000000000000000000000000000000000000e-01, // 0.250000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.25000000000000000000000000000000000000000000000000e+00, // 0.750000
  1.39999999999999991118215802998747676610946655273438e+00, // 0.900000
  1.48999999999999999111821580299874767661094665527344e+00, // 0.990000
  1.49900000000000011013412404281552881002426147460938e+00, // 0.999000
  1.49990000000000001101341240428155288100242614746094e+00, // 0.999900
  };

  public static final double[] SCIPY_GPD_QUANT_M1_05_05 = { //
  5.00049999999999994493293797859223559498786926269531e-01, // 0.000100
  5.00499999999999944932937978592235594987869262695312e-01, // 0.001000
  5.05000000000000004440892098500626161694526672363281e-01, // 0.010000
  5.50000000000000044408920985006261616945266723632812e-01, // 0.100000
  6.25000000000000000000000000000000000000000000000000e-01, // 0.250000
  7.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  8.75000000000000000000000000000000000000000000000000e-01, // 0.750000
  9.49999999999999955591079014993738383054733276367188e-01, // 0.900000
  9.94999999999999995559107901499373838305473327636719e-01, // 0.990000
  9.99500000000000055067062021407764405012130737304688e-01, // 0.999000
  9.99950000000000005506706202140776440501213073730469e-01, // 0.999900
  };

  public static final double[] SCIPY_GPD_QUANT_M2_05_05 = { //
  5.00049997500000009686971225164597854018211364746094e-01, // 0.000100
  5.00499750000000021010748696426162496209144592285156e-01, // 0.001000
  5.04974999999999951683093968313187360763549804687500e-01, // 0.010000
  5.47499999999999986677323704498121514916419982910156e-01, // 0.100000
  6.09375000000000000000000000000000000000000000000000e-01, // 0.250000
  6.87500000000000000000000000000000000000000000000000e-01, // 0.500000
  7.34375000000000000000000000000000000000000000000000e-01, // 0.750000
  7.47500000000000053290705182007513940334320068359375e-01, // 0.900000
  7.49975000000000058264504332328215241432189941406250e-01, // 0.990000
  7.49999749999999965055508255318272858858108520507812e-01, // 0.999000
  7.49999997500000015193677427305374294519424438476562e-01, // 0.999900
  };

  public static final double[] SCIPY_GPD_QUANT_M4_05_05 = { //
  5.00049992500499973502314787765499204397201538085938e-01, // 0.000100
  5.00499250499874981379377913981443271040916442871094e-01, // 0.001000
  5.04925498750000034675622373470105230808258056640625e-01, // 0.010000
  5.42987499999999956301621750753838568925857543945312e-01, // 0.100000
  5.85449218750000000000000000000000000000000000000000e-01, // 0.250000
  6.17187500000000000000000000000000000000000000000000e-01, // 0.500000
  6.24511718750000000000000000000000000000000000000000e-01, // 0.750000
  6.24987500000000029132252166164107620716094970703125e-01, // 0.900000
  6.24999998750000007596838713652687147259712219238281e-01, // 0.990000
  6.24999999999874988887427207373548299074172973632812e-01, // 0.999000
  6.25000000000000000000000000000000000000000000000000e-01, // 0.999900
  };

  @Test
  public void testPDF() {
    // Regular:
    checkPDF(new GeneralizedParetoDistribution(.5, 1, 1.), P_CDFPDF, SCIPY_GPD_PDF_1_05_1, 1e-13);
    checkPDF(new GeneralizedParetoDistribution(.5, .5, 1.), P_CDFPDF, SCIPY_GPD_PDF_1_05_05, 1e-12);
    checkPDF(new GeneralizedParetoDistribution(.5, .5, 2.), P_CDFPDF, SCIPY_GPD_PDF_2_05_05, 1e-12);
    checkPDF(new GeneralizedParetoDistribution(.5, .5, 4.), P_CDFPDF, SCIPY_GPD_PDF_4_05_05, 1e-12);
    checkPDF(new GeneralizedParetoDistribution(.5, 1, -1.), P_CDFPDF, SCIPY_GPD_PDF_M1_05_1, 1e-15);
    checkPDF(new GeneralizedParetoDistribution(.5, .5, -1.), P_CDFPDF, SCIPY_GPD_PDF_M1_05_05, 1e-15);
    checkPDF(new GeneralizedParetoDistribution(.5, .5, -2.), P_CDFPDF, SCIPY_GPD_PDF_M2_05_05, 1e-15);
    checkPDF(new GeneralizedParetoDistribution(.5, .5, -4.), P_CDFPDF, SCIPY_GPD_PDF_M4_05_05, 1e-15);
  }

  @Test
  public void testCDF() {
    checkCDF(new GeneralizedParetoDistribution(.5, 1., 1.), P_CDFPDF, SCIPY_GPD_CDF_1_05_1, 1e-13);
    checkCDF(new GeneralizedParetoDistribution(.5, .5, 1.), P_CDFPDF, SCIPY_GPD_CDF_1_05_05, 1e-13);
    checkCDF(new GeneralizedParetoDistribution(.5, .5, 2.), P_CDFPDF, SCIPY_GPD_CDF_2_05_05, 1e-13);
    checkCDF(new GeneralizedParetoDistribution(.5, .5, 4.), P_CDFPDF, SCIPY_GPD_CDF_4_05_05, 1e-13);
    checkCDF(new GeneralizedParetoDistribution(.5, 1., -1.), P_CDFPDF, SCIPY_GPD_CDF_M1_05_1, 1e-15);
    checkCDF(new GeneralizedParetoDistribution(.5, .5, -1.), P_CDFPDF, SCIPY_GPD_CDF_M1_05_05, 1e-15);
    checkCDF(new GeneralizedParetoDistribution(.5, .5, -2.), P_CDFPDF, SCIPY_GPD_CDF_M2_05_05, 1e-15);
    checkCDF(new GeneralizedParetoDistribution(.5, .5, -4.), P_CDFPDF, SCIPY_GPD_CDF_M4_05_05, 1e-15);
  }

  @Test
  public void testQuantile() {
    // Regular:
    checkQuantile(new GeneralizedParetoDistribution(.5, 1., 1.), P_QUANT, SCIPY_GPD_QUANT_1_05_1, 1e-15);
    checkQuantile(new GeneralizedParetoDistribution(.5, .5, 1.), P_QUANT, SCIPY_GPD_QUANT_1_05_05, 1e-15);
    checkQuantile(new GeneralizedParetoDistribution(.5, .5, 2.), P_QUANT, SCIPY_GPD_QUANT_2_05_05, 1e-15);
    checkQuantile(new GeneralizedParetoDistribution(.5, .5, 4.), P_QUANT, SCIPY_GPD_QUANT_4_05_05, 1e-15);
    checkQuantile(new GeneralizedParetoDistribution(.5, 1., -1.), P_QUANT, SCIPY_GPD_QUANT_M1_05_1, 1e-15);
    checkQuantile(new GeneralizedParetoDistribution(.5, .5, -1.), P_QUANT, SCIPY_GPD_QUANT_M1_05_05, 1e-15);
    checkQuantile(new GeneralizedParetoDistribution(.5, .5, -2.), P_QUANT, SCIPY_GPD_QUANT_M2_05_05, 1e-15);
    checkQuantile(new GeneralizedParetoDistribution(.5, .5, -4.), P_QUANT, SCIPY_GPD_QUANT_M4_05_05, 1e-15);
  }
}
